

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveWriters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveWriters.sp,v $ $Id: RMReserveWriters.sp,v 1.169.2.87.8.4 2021/04/27 22:43:06 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveWriters()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMReserveWriters')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveWriters <<<'
	drop procedure RMReserveWriters
END
IF EXISTS (select * from GxQscripts where name='RMReserveWriters')
	delete from GxQscripts where name = 'RMReserveWriters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveWriters')
	delete from GXDBVersions where aliasname = 'RMReserveWriters'
GO
print '... Creating Procedure: RMReserveWriters'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMReserveWriters
  @i_RequestId int,
  @i_CopyId int,
  @i_CanJobInterruption int,
  @isDebug int,
  @o_ReservationList XML OUTPUT,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET XACT_ABORT ON
DECLARE @RMResView TABLE ( ReservationId		integer, CopyId				integer, StreamId			integer, RemainingMx			integer, MediaGroupId		integer, DrivePoolId			integer, DriveId				integer, VolumeId			integer, MediaId				integer, SpareGroupId		integer, MountPathId			integer, StreamPriority		integer, DrivePriority		integer, FailureErrorCode	integer, MarkDelete			integer, RowId				integer IDENTITY(1, 1), UNIQUE CLUSTERED (ReservationId, CopyId, StreamId, DrivePoolId, DriveId, RowId)   )
DECLARE @RMCopyView TABLE ( CopyId					integer, StreamId				integer, MediaGroupId			integer, RemainingMx				integer, DrivePoolId				integer, DriveId					integer, VolumeId				integer, MediaId					integer, SpareGroupId			integer, MountPathId				integer, ReservationId			integer, NoMux					integer, NoOtherSchedule			integer, ScheduleRunId			bigint, lastUsedTime			integer, Priority				integer, Flag					integer, FailureErrorCode		integer, UNIQUE CLUSTERED (CopyId, StreamId, MediaGroupId, DrivePoolId, VolumeId, RemainingMx)	)
DECLARE @RMDriveView TABLE ( DataPathId				integer, DriveControllerId		integer, DriveId					integer, DrivePoolId				integer, MasterPoolId			integer, LibraryId				integer, LibrarySubType			integer, SpareGroupId			integer, HostClientId			integer, MAClientId				integer, MountPathId				integer, DeviceId				integer, DeviceControllerId		integer, FailureErrorCode		integer, DriveAttributes			integer, Priority				integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, DriveId, Priority)	)
DECLARE @RMMediaView TABLE ( DataPathId			integer, HostClientId		integer, LibraryId			integer, LibraryTypeId		integer, LibraryAttribute	integer, MasterPoolId		integer, DrivePoolId			integer, SpareGroupId		integer, AppendableMediaCount	integer, SpareMediaCount			integer    )
	IF object_id('tempdb.dbo.#tmpRMDriveViewWithOffline') IS NOT NULL
		DELETE #tmpRMDriveViewWithOffline
	ELSE
CREATE TABLE #tmpRMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, Priority					integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
  --declare @tmpDPDrives table (DriveId int, DrivePoolId int, RemainingMx int)
  declare @rmJustId table (id int)
  --declare @rmMediaAllo table (RetCode int, VolumeIDForJob int, SpareGroupID int, LibraryID int, MediaOfOtherSideSearched int, MediaAppendibleSearched int, MediaSpareSearched int, SpareStatusUpdated int)
  declare @rmMediaAllo table (RetCode int, VolumeIDForJob int, SpareGroupID int, LibraryID int, MediaOfOtherSideSearched int, MediaAppendibleSearched int, MediaSpareSearched int)
  -- clean all staging tables, we know we are single threaded, aren't we?
  EXEC SQLUtilTruncateTable 'HistoryDB..rmDataPathView'
  declare @hasMagneticDP integer
  declare @ReservationType int
  declare @NumCopyViews int
  declare @NumDriveViews int
  declare @NumMediaViews int
  declare @NumMountPaths int
  declare @NumDataPathViews int
  declare @NumResViews int
  --declare @idaClientId int
  declare @MuxFactor int
  declare @SIDBStoreId int
  declare @UsePreferredDP int
  declare @dpFailoverFlags int
  declare @waitforifoffline int
  declare @waitforifbusy int
  declare @NumMaxMxStreamsAvail int
  declare @NumMaxFreeStreams int
  declare @numStreamsMin int
  declare @numStreamsRemaining int
  declare @HasJobInterrupted int
  declare @hasLicense int
  set @hasMagneticDP = 0
set @o_ErrorCode = 0
set @o_FailureType = 2
set @ReservationType = 2
  set @NumCopyViews  = 0
  set @NumDriveViews = 0
  set @NumMountPaths = 0
  set @NumMediaViews = 0
  set @NumDataPathViews = 0
  set @NumResViews = 0
  set @MuxFactor = 0
  set @SIDBStoreId = 0
  set @UsePreferredDP = 0
  set @HasJobInterrupted = 0
	set @hasLicense = 1;
  /*#include "JobManager/cvjob.h"*/
  declare @BKPJOB int
  declare @CSDRBKPJOB int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  declare @SELDELETEJOB int
  declare @MEDIAREFRESHINGJOB int
  declare @DASHCOPYJOB int
  set @BKPJOB = 1
  set @CSDRBKPJOB = 4
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
  set @SELDELETEJOB  = 16
  set @MEDIAREFRESHINGJOB = 25
  set @DASHCOPYJOB = 37
	declare @jprConfigValue int
	set @jprConfigValue = 1
	select @jprConfigValue = isnull(value, 1) from MMConfigs
	where name = 'MMCONFIG_RESOURCEMANAGER_RETURN_FULL_DETAIL_OF_JOB_FAILURE'
  -------------------------------------------
  -- Module: prepare reservation request   --
  -------------------------------------------
  declare @RequestTime				int
  declare @FailureAttempts			int
  declare @useSCDataPath			int
  declare @interruptInterval		int
  declare @forceMultiplexing		int
  declare @appNum					int
  declare @commCellId				int
  declare @dataType				    int
  declare @jobId					bigint
  declare @numStreams				int
  declare @bestcaseReserve			int
  declare @isBestcaseReserve		int
  declare @markActiveMediaFull		int
  declare @forcedMarkActiveMediaFull	int
  declare @priority				int
  declare @preEmptable				int
  declare @extraRestoreDrive		int
  declare @extraRestoreDrivePoolId	int
  declare @jobType					int
	declare @jobOpType			int
	declare @iDAType				int
  declare @bkpLevel				int
  declare @appType					int
  declare @phaseFirstAttemptTime	bigint
  declare @archGroupId				int
  declare @copyIdList				varchar(max)
  declare @markMediaFullOnSuccess	int
  declare @dataMultiStream			int
  declare @maxDataMultiStream		int
  declare @failIfSecondaryCopyError int
  declare @multiCopyReserve		int
  declare @isForRemainingStreams	int
  declare @clientTokenId			int
  declare @inClientId				int
  declare @MAClientId				int
  declare @doPrelimReserveCheck	int
  declare @scheduleRunId			bigint
  declare @doNotAllowOtherSchedule	int
  declare @agroupNumber			int
  declare @copyId					int
  declare @maxMXCount				int
  declare @singleStream			int
  declare @checkConcurrency		int
  declare @preferredDrivePoolId	int
  declare @volId					int
  declare @DrvPoolId				int
  declare @mediaId					int
  declare @MediaGrpId				int
  declare @rtype					int
  declare @isDummyReservation		int
  declare @destinationMediaGroupId	int
  declare @numResourceInterrupt		int
  declare @numIntrResources			int
  declare @siloCopyId					int
	declare @isIndexingRequired int
	declare @preferredMediaAgentId int
	declare @currentSIDBStoreId		int
	declare @xmlRegistrySetting		XML
  declare @xmlParams						XML
  declare @xmlCopyIdList					XML
  declare @perferredDataPathDrvPoolForCopy int
	declare @IsForSILOBackup	int
  declare @hasJobDataPathOptions int
	declare @oraclBackupCachingEnabledByJob int
	declare @backupCachingEnabledBySP int
	DECLARE @backupCachingEnhance INT = 0
	DECLARE @backupCachingExtraStreamNumber INT = 0
	declare @archGroupName			nvarchar(288)
	declare @archGroupCopyName	nvarchar(288)
	DECLARE @archGrpFlags		INT
	DECLARE @archGrpCpyExtFlags	INT
	DECLARE @curReservationCount int
	SET @curReservationCount = 0
	DECLARE @RMResrvFailedMediaList TABLE (DataPathId INT, MediaBarcode NVARCHAR(2048))
	declare @ddbCopy int = 0
  set @RequestTime					= 0
	set @FailureAttempts			= 0
  set @useSCDataPath				= 0
  set @phaseFirstAttemptTime	= 0
	set @interruptInterval		= 0
  set @forceMultiplexing		= 0
  set @appNum								= 0
  set @commCellId						= 0
  set @dataType				    	= 0
  set @jobId								= 0
  set @numStreams						= 0
  set @bestcaseReserve			= 0
  set @isBestcaseReserve		= 0
  set @markActiveMediaFull	= 0
  set @forcedMarkActiveMediaFull		= 0
  set @priority							= 0
  set @preEmptable					= 0
  set @extraRestoreDrive		= 0
  set @extraRestoreDrivePoolId		= 0
  set @jobType							= 0
	set @jobOpType						= 0
	set @iDAType						= 0
  set @bkpLevel							= 0
  set @appType							= 0
  set @archGroupId					= 0
  set @copyIdList						= ''
  set @markMediaFullOnSuccess		= 0
  set @dataMultiStream			= 0
  set @maxDataMultiStream		= 0
  set @failIfSecondaryCopyError	= 0
  set @multiCopyReserve			= 0
  set @isForRemainingStreams		= 0
  set @clientTokenId				= 0
  set @inClientId						= 0
  set @MAClientId						= 0
  set @doPrelimReserveCheck	= 0
  set @scheduleRunId				= 0
  set @doNotAllowOtherSchedule	= 0
  set @agroupNumber					= 0
  set @copyId								= 0
  set @maxMXCount						= 0
  set @singleStream					= 0
  set @checkConcurrency			= 0
  set @preferredDrivePoolId	= 0
  set @volId								= 0
  set @DrvPoolId						= 0
  set @mediaId							= 0
  set @MediaGrpId						= 0
  set @rtype								= 0
  set @isDummyReservation		= 0
  set @destinationMediaGroupId	= 0
  set @numResourceInterrupt			= 0
  set @numIntrResources			= 0
  set @siloCopyId						= 0
	set @isIndexingRequired 	= 0
	set @preferredMediaAgentId = 0
	set @currentSIDBStoreId 	= 0
	set @xmlParams = ''
	declare @isTurnOffBestcaseReservation int
	set @isTurnOffBestcaseReservation = 0
	declare @skipStreamLimits int = 0
	-- The following are only used by AuxCopy.
	declare @sourceRCID int
	declare @sourceResID int
	declare @sourceMediaGroupId int
	declare @sourceVolumeId int
	declare @sourceDrivePoolId int
	set @sourceRCID = 0
	set @sourceResID = 0
	set @sourceMediaGroupId = 0
	set @sourceVolumeId = 0
	set @sourceDrivePoolId = 0
	DECLARE @isBackupCachingDisabled INT
	SET @isBackupCachingDisabled = 1
	-- IBMi VTL
	declare @use_nonvtl_drivepool int
	set @use_nonvtl_drivepool = 0
	-- IBMi VTL
	-- This is used to back track the destination copy Id in case of GACP
	DECLARE @originalAuxcopyDestCopyId INT = 0
	DECLARE @appClientId INT = 0
	DECLARE @backupSetId INT = 0
	DECLARE @clientId INT = 0
	DECLARE @appTypeId INT = 0
	DECLARE @clientReleaseId INT = 0
	DECLARE @clientServicePackId INT = 0
	-- load the reservation parameters for this request --
  select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@useSCDataPath = useSCDataPath,
		@commCellId = commCellId,
		@jobId = jobId,
		@jobType = jobType,
		@jobOpType = jobOpType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@scheduleRunId = scheduleRunId,
		@copyId	= copyId,
		@xmlRegistrySetting = registrySetting,
		@xmlParams = xmlParams
  from RMReservationRequest
  where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL
	BEGIN
		-- For reservation
		IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t') > 0
		BEGIN
			SELECT	@appNum										= isnull(params.value('@appNum', 'int'), 0),
							@commCellId								= isnull(params.value('@commCellId', 'int'), 0),
							@dataType									= isnull(params.value('@dataType', 'int'), 0),
							@jobId										= isnull(params.value('@jobId', 'bigint'), 0),
							@numStreams								= isnull(params.value('@numStreams', 'int'), 0),
							@bestcaseReserve					= isnull(params.value('@bestcaseReserve', 'int'), 0),
							@markActiveMediaFull			= isnull(params.value('@markActiveMediaFull', 'int'), 0),
							@forcedMarkActiveMediaFull	= isnull(params.value('@forcedMarkActiveMediaFull', 'int'), 0),
							@priority									= isnull(params.value('@priority', 'int'), 0),
							@preEmptable							= isnull(params.value('@preEmptable', 'int'), 0),
							@extraRestoreDrive				= isnull(params.value('@extraRestoreDrive', 'int'), 0),
							@extraRestoreDrivePoolId	= isnull(params.value('@extraRestoreDrivePoolId', 'int'), 0),
							@jobType									= isnull(params.value('@jobType', 'int'), 0),
							@bkpLevel									= isnull(params.value('@bkpLevel', 'int'), 0),
							@appType									= isnull(params.value('@appType', 'int'), 0),
							--@phaseFirstAttemptTime		= isnull(params.value('@phaseFirstAttemptTime', 'bigint'), 0),
							@archGroupId							= isnull(params.value('@archGroupId', 'int'), 0),
							@markMediaFullOnSuccess		= isnull(params.value('@markMediaFullOnSuccess', 'int'), 0),
							@dataMultiStream					= isnull(params.value('@dataMultiStream', 'int'), 0),
							@maxDataMultiStream				= isnull(params.value('@maxDataMultiStream', 'int'), 0),
							@failIfSecondaryCopyError	= isnull(params.value('@failIfSecondaryCopyError', 'int'), 0),
							@multiCopyReserve					= isnull(params.value('@multiCopyReserve', 'int'), 0),
							@isForRemainingStreams		= isnull(params.value('@isForRemainingStreams', 'int'), 0),
							@clientTokenId						= isnull(params.value('@clientTokenId', 'int'), 0),
							@inClientId								= isnull(params.value('@inClientId', 'int'), 0),
							@doPrelimReserveCheck			= isnull(params.value('@doPrelimReserveCheck', 'int'), 0),
							@scheduleRunId						= isnull(params.value('@scheduleRunId', 'bigint'), 0),
							@doNotAllowOtherSchedule	= isnull(params.value('@doNotAllowOtherSchedule', 'int'), 0),
							@siloCopyId								= isnull(params.value('@siloCopyId', 'int'), 0),
							@isIndexingRequired				= isnull(params.value('@isIndexingRequired', 'int'), 0),
							@preferredMediaAgentId		= isnull(params.value('@preferredMediaAgentId', 'int'), 0),
							@currentSIDBStoreId				= isnull(params.value('@currentSIDBStoreId', 'int'), 0),
							@xmlCopyIdList					= params.query('//copyIdList')
			FROM	@xmlParams.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
		END
		ELSE IF @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t') > 0
		BEGIN
			DECLARE @xmlCopyInfoList XML
			SELECT	@appNum										= isnull(params.value('@appNum', 'int'), 0),
							@dataType									= isnull(params.value('@dataType', 'int'), 0),
							@agroupNumber							= isnull(params.value('@agroupNumber', 'int'), 0),
							@copyId										= isnull(params.value('@copyId', 'int'), 0),
							@maxMXCount								= isnull(params.value('@maxMXCount', 'int'), 0),
							@commCellId								= isnull(params.value('@commCellId', 'int'), 0),
							@jobId										= isnull(params.value('@jobId', 'bigint'), 0),
							@numStreams								= isnull(params.value('@numStreams', 'int'), 0),
							@bestcaseReserve					= isnull(params.value('@bestcaseReserve', 'int'), 0),
							@markActiveMediaFull			= isnull(params.value('@markActiveMediaFull', 'int'), 0),
							@forcedMarkActiveMediaFull	= isnull(params.value('@forcedMarkActiveMediaFull', 'int'), 0),
							@priority									= isnull(params.value('@priority', 'int'), 0),
							@preEmptable							= isnull(params.value('@preEmptable', 'int'), 0),
							@extraRestoreDrive				= isnull(params.value('@extraRestoreDrive', 'int'), 0),
							@extraRestoreDrivePoolId	= isnull(params.value('@extraRestoreDrivePoolId', 'int'), 0),
							@singleStream							= isnull(params.value('@singleStream', 'int'), 0),
							@checkConcurrency					= isnull(params.value('@checkConcurrency', 'int'), 0),
							@jobType									= isnull(params.value('@jobType', 'int'), 0),
							@bkpLevel									= isnull(params.value('@bkpLevel', 'int'), 0),
							@appType									= isnull(params.value('@appType', 'int'), 0),
							--@phaseFirstAttemptTime		= isnull(params.value('@phaseFirstAttemptTime', 'bigint'), 0),
							@markMediaFullOnSuccess		= isnull(params.value('@markMediaFullOnSuccess', 'int'), 0),
							@dataMultiStream					= isnull(params.value('@dataMultiStream', 'int'), 0),
							@maxDataMultiStream				= isnull(params.value('@maxDataMultiStream', 'int'), 0),
							@multiCopyReserve					= isnull(params.value('@multiCopyReserve', 'int'), 0),
							@failIfSecondaryCopyError	= isnull(params.value('@failIfSecondaryCopyError', 'int'), 0),
							@preferredDrivePoolId			= isnull(params.value('@preferredDrivePoolId', 'int'), 0),
							@isForRemainingStreams		= isnull(params.value('@isForRemainingStreams', 'int'), 0),
							@clientTokenId						= isnull(params.value('@clientTokenId', 'int'), 0),
							@inClientId								= isnull(params.value('@inClientId', 'int'), 0),
							@scheduleRunId						= isnull(params.value('@scheduleRunId', 'bigint'), 0),
							@doNotAllowOtherSchedule	= isnull(params.value('@doNotAllowOtherSchedule', 'int'), 0),
							@doPrelimReserveCheck			= isnull(params.value('@doPrelimReserveCheck', 'int'), 0),
							@currentSIDBStoreId				= isnull(params.value('@currentSIDBStoreId', 'int'), 0),
							@xmlCopyInfoList					= params.query('//copyInfoList')
					FROM	@xmlParams.nodes('/ResourceManager_RmAuxcopyReservationArgs_t[1]/destinationArgs[1]') AS R(params)
			-- Collect the Auxcopy reservation requirement from the list if there is a Parallel Auxcopy
			IF @xmlCopyInfoList IS NOT NULL AND @xmlCopyInfoList.exist('/copyInfoList') = 1
			BEGIN
				SELECT	@singleStream = isnull(a.singleStream, @singleStream),
								@preferredDrivePoolId = isnull(a.preferredDrivePoolId, @preferredDrivePoolId),
								@maxMXCount = isnull(a.maxMXCount, @maxMXCount)
				FROM
				(
					SELECT	distinct isnull(params.value('@copyId', 'int'), 0) AS copyId,
							isnull(params.value('@streamNum', 'int'), 0) AS singleStream,
							isnull(params.value('@preferredDrivePoolId', 'int'), 0) AS preferredDrivePoolId,
							isnull(params.value('@maxMXCount', 'int'), 0) AS maxMXCount
					FROM	@xmlCopyInfoList.nodes('/copyInfoList') AS R(params)
				) a
				WHERE a.copyId = @i_CopyId
			END
			-- Get the source reservation volume and drive pool info
			SELECT	@sourceVolumeId											= params.value('@volId', 'int'),
							@sourceDrivePoolId									= params.value('@DrvPoolId', 'int')
			FROM	@xmlParams.nodes('/ResourceManager_RmAuxcopyReservationArgs_t[1]/sourceArgs[1]') AS R(params)
		END
	END
	IF @xmlRegistrySetting IS NOT NULL
	BEGIN
		SELECT	@interruptInterval			= params.value('@interruptDelayInterval', 'int'),
						@forceMultiplexing			= params.value('@forceMultiplexingEnabled', 'int'),
						@isTurnOffBestcaseReservation = params.value('@isTurnOffBestcaseReservation', 'int'),
						@isBackupCachingDisabled	= params.value('@isBackupCachingDisabled', 'int')
		FROM		@xmlRegistrySetting.nodes('/ResourceManager_RmRegistrySetting_t[1]') AS R(params)
	END
	declare @SYNTHFULL int
	set @SYNTHFULL = 14
	declare @isDashSynFull int = 0
  set @jobOpType = dbo.GetJobTypeForJobID(@jobId)
	if @jobType = @SYNTHFULLJOB
	begin
		set @jobOpType = @SYNTHFULL
select	@isDashSynFull = cast(dbo.GetJobOption(@jobId, 1370544559) as int)
		if @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t') > 0
			set @isDashSynFull = 0
		if @appNum = 0
		begin
			SELECT @appNum = applicationId FROM JMBkpJobInfo with (NOLOCK) WHERE JobId = @jobId
		end
	end
	declare @debugDetail varchar(max)
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMReserveWriters',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], CopyId['
																				+ cast(isnull(@i_CopyId, 0) as varchar(20)) + '], JobId['
																				+ cast(isnull(@jobId, 0) as varchar(20)) + '], AppID['
																				+ cast(isnull(@appNum, 0) as varchar(20)) + ']',
						@i_RequestId, getutcdate())
	end
	SELECT 	@backupsetId = backupset,
			@clientId = clientId,
			@appTypeId = appTypeId
	FROM	App_Application WITH(READUNCOMMITTED)
	WHERE	id = @appNum
	IF @clientId > 0
	BEGIN
		DECLARE @activeClientId INT = 0
		SELECT @activeClientId =  cast(attrval as int)
		FROM 	APP_ClientProp WITH (NOLOCK)
		WHERE 	componentNameId = @clientId
		AND		attrName = 'Active Physical Node'
		AND		modified = 0
		AND		componentNameId != cast(attrval as int)
		SELECT	@clientReleaseId = client.ReleaseId,
				@clientServicePackId = MAX(pack.HighestSP)
		FROM	App_Client client WITH (READUNCOMMITTED), simInstalledPackages pack WITH (READUNCOMMITTED)
		WHERE	(@activeClientId = 0 AND client.Id = @clientId OR client.Id = @activeClientId)
		AND		client.Id = pack.clientId
		GROUP BY  client.ReleaseId
	END
	declare @parentJobId int = 0
	select @parentJobId = ISNULL(parentJobId, 0) from JMJobDataLink WITH (NOLOCK) WHERE childJobId = @jobId and commCellId = @commCellId
	/*
	-- if @i_CopyId is 0, that is for primary copy
			-- if siloCopyId > 0, this is for SILO backup. Use siloCopyId.
			-- Otherwise usse archGroupId or appNum to figure out which default copy
	-- if @i_CopyId > 0, stick with it,
			-- It can be inline backup copy id in case of non-Auxcopy job
			-- It can be the Auxcopy id in case of Auxcopy Job
	-- @copyId may not be the default copy, like snap backup, in such case stick with the copy id
	*/
 	declare @copyFlags int
 	declare @dedupeFlags int
 	declare @primaryCopyId int
	declare @isInlineCopy int
	set @isInlineCopy = 0
	if  @isDashSynFull > 0
	begin
		set @primaryCopyId = @copyId
		select @copyId = isnull(c.id, 0),
					@isInlineCopy = 0,
					@copyFlags = isnull(c.flags, 0),
					@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
					@waitforifoffline = c.waitforifoffline,
					@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
					@archgroupid = c.archgroupid
		from ArchGroupCopy c with (readuncommitted)
		where c.id = @copyId
		-- Lookup source reservation information
		-- when the job is DASHCOPYJOB, sourceRCID can be 0 in case of magnetic volume
		-- TODO: Make sure the reservation type check is correct
		select top 1 @sourceRCID		= isnull(resToJob.RCID, 0),
									@sourceResID	= isnull(res.ReservationId, 0),
									@inClientId		= isnull(res.ClientId, 0),
									@sourceMediaGroupId = isnull(res.MediaGroupId, 0)
		from MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where res.ReservationId = resToJob.ReservationId
and resToJob.ReservationType = 1 --and res.StreamId = 0
		and resToJob.JobId_l = @jobId
		and res.VolumeId = @sourceVolumeId
		and (res.DrivePoolId = @sourceDrivePoolId or @sourceDrivePoolId = 0)
		order by resToJob.DestMediaGroupId
		-- If the source reservation is done on NAS data path, change the inclient to the client of NDMP host.
		-- So later the comparison are all done on the correct NAS NDMP host
		if exists (select dp.DrivePoolId from MMDrivePool dp with (readuncommitted), MMResource res with (readuncommitted)
					where	res.ReservationId = @sourceResID
					and		dp.DrivePoolId = res.DrivePoolId
					and		dp.DrivePoolType = 3)
		begin
			set @MAClientId = @inClientId
			select @inClientId = ndmp.clientId
			from	MMDrivePool dp with (readuncommitted), MMResource res with (readuncommitted), MMNDMPHostInfo ndmp with (readuncommitted)
			where	res.ReservationId = @sourceResID
			and		dp.DrivePoolId = res.DrivePoolId
			and		dp.DrivePoolType = 3
			and		dp.NDMPHostId = ndmp.NDMPHostId
		end
	end
	else if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	begin
		-- For AuxCopy job, is the passing-in copy id is 0, then it is the reservation for the first secondary copy.
		-- If the passing-in copy has value and not equal to the copyId, it is the reservation for the parallel secondary copy.
		-- In 10.0, we introduce global auxcopy policy, in this case we need to change the actual copy used for write.
		if @i_CopyId is not null and @i_CopyId > 0 and @copyId != @i_CopyId
		begin
			-- If the frist seondary copy using GACP, make sure the primary copyid is the one used for reservation.
if exists (select Id from ArchGroupCopy with (readuncommitted) where Id = @copyId and ExtendedFlags & 2 > 0 and destMediaCopyId > 0)
			begin
				select @copyId = destMediaCopyId from ArchGroupCopy with (readuncommitted) where Id = @copyId
			end
			-- If the seondary copy using GACP, make sure the copyid is the one used for reservation.
if exists (select Id from ArchGroupCopy with (readuncommitted) where Id = @i_CopyId and ExtendedFlags & 2 > 0 and destMediaCopyId > 0)
			begin
				set @originalAuxcopyDestCopyId = @i_copyId
				select @i_CopyId = destMediaCopyId from ArchGroupCopy with (readuncommitted) where Id = @i_CopyId
				if @isDebug > 0
				begin
					insert into RMLogger values ('RMReserveWriters',
									'Switch to GACP copy Id [' + cast(isnull(@i_CopyId, 0) as varchar(20)) + ']',
									@i_RequestId, getutcdate())
				end
			end
			set @primaryCopyId = @copyId
			select @copyId = isnull(c.id, 0),
						@isInlineCopy = 0,
						@copyFlags = isnull(c.flags, 0),
						@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
						@waitforifoffline = c.waitforifoffline,
						@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
						@archgroupid = c.archgroupid
			from ArchGroupCopy c with (readuncommitted)
			where c.id = @i_CopyId
		end
		else
		begin
			-- If the seondary copy using GACP, make sure the copyid is the one used for reservation.
if exists (select Id from ArchGroupCopy with (readuncommitted) where Id = @copyId and ExtendedFlags & 2 > 0 and destMediaCopyId > 0)
			begin
				set @originalAuxcopyDestCopyId = @copyId
				select @copyId = destMediaCopyId from ArchGroupCopy with (readuncommitted) where Id = @copyId
				if @isDebug > 0
				begin
					insert into RMLogger values ('RMReserveWriters',
									'Switch to GACP copy Id [' + cast(isnull(@copyId, 0) as varchar(20)) + ']',
									@i_RequestId, getutcdate())
				end
			end
			set @primaryCopyId = @copyId
			select @copyId = isnull(c.id, 0),
						@isInlineCopy = 0,
						@copyFlags = isnull(c.flags, 0),
						@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
						@waitforifoffline = c.waitforifoffline,
						@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
						@archgroupid = c.archgroupid
			from ArchGroupCopy c with (readuncommitted)
			where c.id = @copyId
		end
		if @originalAuxcopyDestCopyId > 0
		begin
			select	@copyFlags = isnull(c.flags, 0),
					--@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
					@waitforifoffline = c.waitforifoffline,
					@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) )
			from ArchGroupCopy c with (readuncommitted)
			where c.Id = @originalAuxcopyDestCopyId
		end
		-- Lookup source reservation information
		-- when the job is DASHCOPYJOB, sourceRCID can be 0 in case of magnetic volume
		-- TODO: Make sure the reservation type check is correct
		select top 1 @sourceRCID		= isnull(resToJob.RCID, 0),
									@sourceResID	= isnull(res.ReservationId, 0),
									@inClientId		= isnull(res.ClientId, 0),
									@sourceMediaGroupId = isnull(res.MediaGroupId, 0)
		from MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where res.ReservationId = resToJob.ReservationId
and resToJob.ReservationType = 1 --and res.StreamId = 0
		and resToJob.JobId_l = @jobId
		and res.VolumeId = @sourceVolumeId
		and (res.DrivePoolId = @sourceDrivePoolId or @sourceDrivePoolId = 0)
		order by resToJob.DestMediaGroupId
		-- If the source reservation is done on NAS data path, change the inclient to the client of NDMP host.
		-- So later the comparison are all done on the correct NAS NDMP host
		if exists (select dp.DrivePoolId from MMDrivePool dp with (readuncommitted), MMResource res with (readuncommitted)
					where	res.ReservationId = @sourceResID
					and		dp.DrivePoolId = res.DrivePoolId
					and		dp.DrivePoolType = 3)
		begin
			set @MAClientId = @inClientId
			select @inClientId = ndmp.clientId
			from	MMDrivePool dp with (readuncommitted), MMResource res with (readuncommitted), MMNDMPHostInfo ndmp with (readuncommitted)
			where	res.ReservationId = @sourceResID
			and		dp.DrivePoolId = res.DrivePoolId
			and		dp.DrivePoolType = 3
			and		dp.NDMPHostId = ndmp.NDMPHostId
		end
	end
	-- Job is not AuxCopy.
	-- There is a passing-in copy id and it is not a default copy, there should be inline copy reservation
	else if @i_CopyId is not null and @i_CopyId > 0 and not exists (select * from archgroup with (readuncommitted) where defaultcopy = @i_CopyId)
	begin
		set @primaryCopyId = @copyId
		set @appClientId = CASE WHEN @inClientId > 0 THEN @inClientId ELSE 0 END
		select @copyId = isnull(c.id, 0),
					@isInlineCopy = 1,
					@copyFlags = isnull(c.flags, 0),
					@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
					@waitforifoffline = c.waitforifoffline,
					@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
					@archgroupid = c.archgroupid
		from ArchGroupCopy c with (readuncommitted)
		where c.id = @i_CopyId
		select @inClientId = ClientId from RMReservations with (readuncommitted) where RequestId = @i_RequestId and CopyId = @primaryCopyId
	end
	else
	begin
		set @appClientId = CASE WHEN @inClientId > 0 THEN @inClientId ELSE 0 END
		declare @tinClientId integer
		select @tinClientId = (case when @inClientId <= 0 then isnull(clientid, 0) else @inClientId end)
		from App_Application with (readuncommitted)
		where id = @appNum
		declare @nas_proxy_clientId integer = 0
		IF EXISTS (SELECT 1 FROM APP_Client client WITH (NOLOCK), APP_Application app WITH (NOLOCK)
					WHERE app.Id = @appNum AND app.ClientId = client.Id
AND		(client.Status & 0x0080) > 0
				)
		BEGIN
			-- find the nas proxy clientId defined on subclient property
			IF EXISTS (SELECT id from APP_SubClientProp WITH (NOLOCK) where cs_attrName = CheckSum(N'Turbo NAS Proxy Client')
							and attrName = N'Turbo NAS Proxy Client' and modified = 0 and componentnameId = @appNum)
			BEGIN
				SELECT @nas_proxy_clientId = ISNULL(CONVERT(INT, attrVal), 0)
				FROM	App_subclientProp WITH (NOLOCK)
				WHERE	componentnameId = @appNum AND cs_attrName = CheckSum(N'Turbo NAS Proxy Client') AND attrName = N'Turbo NAS Proxy Client' and modified = 0
			END
			-- find the nas proxy clientId if it is set
			ELSE IF EXISTS (SELECT attrVal FROM App_Idaprop WITH (NOLOCK)
							WHERE componentNameId in (
										SELECT TOP 1 a.Id FROM App_IdaName a WITH (NOLOCK), App_Application b WITH (NOLOCK)
										WHERE	b.Id = @appNum -- AND b.ClientId = @i_inClientId
										AND		a.ClientId = b.ClientId AND a.AppTypeId = b.AppTypeId
										)
							AND attrName = 'FPOLICY PRIMARY CLIENT'
							AND Modified = 0
							)
			BEGIN
				SELECT @nas_proxy_clientId = ISNULL(CONVERT(INT, attrVal), 0)
				FROM App_Idaprop WITH (NOLOCK)
				WHERE componentNameId in (
							SELECT TOP 1 a.Id FROM App_IdaName a WITH (NOLOCK), App_Application b WITH (NOLOCK)
							WHERE	b.Id = @appNum -- AND b.ClientId = @i_inClientId
							AND		a.ClientId = b.ClientId AND a.AppTypeId = b.AppTypeId
							)
				AND attrName = 'FPOLICY PRIMARY CLIENT'
				AND Modified = 0
			END
			IF @nas_proxy_clientId > 0
			BEGIN
				SET @tinClientId = @nas_proxy_clientId
			END
		END
		-- IBMi VTL
		set @nas_proxy_clientId = 0
		select @nas_proxy_clientId = ISNULL(CAST(CP.attrVal AS INT),0) from APP_Application as AP WITH (NOLOCK)
			JOIN APP_Client as C WITH (NOLOCK) ON AP.clientid = C.id
			JOIN APP_ClientProp as CP WITH (NOLOCK) ON CP.componentNameId = C.id
		where AP.id=@appNum AND CP.attrName = N'Open VMS proxy client'
		if @nas_proxy_clientId > 0
		Begin
			-- find the Proxy clientId defined on subclient property
			-- however, for archive index we need to select secondary (non-VTL) path
			if EXISTS (select 1 from JMOpTable as OT WITH (NOLOCK)
					JOIN JMJobInfo as JI WITH (NOLOCK) ON JI.opType=OT.operation
					JOIN JMPhase as PH WITH (NOLOCK) ON PH.phase = JI.currentPhase AND OT.id=PH.opTableId
where OT.appTypeType=38 and JI.jobId=@jobId and (PH.phaseType & 0x200000) != 0
			)
			begin
                set @use_nonvtl_drivepool = 1
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter', '@use_nonvtl_drivepool = '+cast(@use_nonvtl_drivepool as varchar(20)), @i_RequestId, getutcdate())
			end
			else
			begin
				SET @tinClientId = @nas_proxy_clientId
				if @isDebug > 0
  					insert into RMLogger values ('RMReserveWriters',
  							'Found Proxy Client ['+cast(isnull(@tinClientId, 0) as varchar(20))+'] for appId ['+ cast(isnull(@appNum, 0) as varchar(20)) + ']',
  							@i_RequestId, getutcdate())
  			end
		end
		-- IBMi VTL
		declare @subOpType int
		set @subOpType = 0
		select @subOpType = isnull(subOpType,0) FROM JMJobInfo WITH (readuncommitted)
		where jobId = @jobId AND commCellId = @commCellId
		-- for silo backup job, copy might not be the default copy
		if @siloCopyId is not null and @siloCopyId > 0
		begin
			declare @sourceCopyId integer
			set @sourceCopyId = 0
			select @copyId = isnull(c.id, 0),
						@isInlineCopy = 0,
						@copyFlags = isnull(c.flags, 0),
						@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
						@waitforifoffline = c.waitforifoffline,
						@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
						@archgroupid = c.archgroupid,
						@sourceCopyId = sourceCopyId
			from ArchGroupCopy c with (readuncommitted)
			where c.id = @siloCopyId
			-- Find the Media Agent used to access the SIDB Store
			if @sourceCopyId > 0
			begin
				-- If cannot find the client id, just keep it as the same as the one from application. This should not happen anyway.
				select 	top 1 @tinClientId = a.ClientId
				from 	IdxSIDBSubStore a with (readuncommitted), ArchCopySIDBStore c with (readuncommitted)
				where	c.copyId = @sourceCopyId
				and		a.SIDBStoreId = c.SIDBStoreId
and 	(c.flags & 2) > 0
			end
			else -- check if the silocopy id has dedup enabled
			begin
				select 	top 1 @tinClientId = a.ClientId
				from 	IdxSIDBSubStore a with (readuncommitted), ArchCopySIDBStore c with (readuncommitted)
				where	c.copyId = @siloCopyId
				and		a.SIDBStoreId = c.SIDBStoreId
and 	(c.flags & 2) > 0
			end
		end
		-- With the specified ArchGroupId, the job might be using incremental storage policy or log storage policy
		else if @archGroupId > 0
		begin
			-- If the data type is for SNAP, use the default SNAP COPY
if @dataType = 6
			begin
				select @copyId = isnull(c.id, 0),
							@isInlineCopy = 0,
							@copyFlags = isnull(c.flags, 0),
							@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
							@waitforifoffline = c.waitforifoffline,
							@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) )
				from archgroup a with (readuncommitted), ArchGroupCopy c with (readuncommitted)
				where a.id = @archGroupId AND
					(
						--enum CvOptype{ DELAYEDCATALOG = 96,
					 	(@subOpType <> 96 AND c.id = a.defaultSnapCopy)
							OR
						(@subOpType = 96 AND c.id = (SELECT CASE WHEN DCProp.sourceCopyId > 0 THEN DCProp.sourceCopyId ELSE a.defaultSnapCopy END
								FROM archDeferredCatalogProp DCProp  WITH (readuncommitted)
								WHERE DCProp.archGroupId = a.id)
						)
					)
			end
			else
			begin
				SET @ddbCopy = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @appNum AND cs_attrName = CheckSum(N'DDB Backup CopyId') AND attrName = N'DDB Backup CopyId' AND Modified = 0), 0)
				IF @ddbCopy > 0
				BEGIN
					SET @copyId = @ddbCopy
					insert into RMLogger values ('RMReserveWriter',
													'Override Backup CopyId [' + cast(@ddbCopy as varchar(10)) + ']',
													@i_RequestId, getutcdate())
				END
				select @copyId = isnull(c.id, 0),
							@isInlineCopy = 0,
							@copyFlags = isnull(c.flags, 0),
							@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
							@waitforifoffline = c.waitforifoffline,
							@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
							@archgroupid = a.id
				from archgroup a with (readuncommitted), ArchGroupCopy c with (readuncommitted)
				where a.id = @archGroupId
				and ((@copyId > 0 AND c.id = @copyId) OR (@copyId = 0 AND a.DefaultCopy = c.id))
			end
		end
		-- No ArchGroup value, use appId to lookup the info
		-- TODO: Job Manager need to pass in ArchGroup Id for the job. If not, we should fail the reservation here.
		else
		begin
			-- If the data type is for SNAP, use the default SNAP COPY
if @dataType = 6
			begin
				select @copyId = isnull(c.id, 0),
							@isInlineCopy = 0,
							@copyFlags = isnull(c.flags, 0),
							@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
							@waitforifoffline = c.waitforifoffline,
							@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
							@archgroupid = a.id
				from archgroup a with (readuncommitted), app_application b with (readuncommitted), ArchGroupCopy c with (readuncommitted)
				where a.id = b.dataarchgrpid
				and b.id = @appNum
				and
				(
				--enum CvOptype{ DELAYEDCATALOG = 96,
				(@subOpType <> 96 AND c.id = a.defaultSnapCopy)
					OR
				(@subOpType = 96 AND c.id = (SELECT CASE WHEN DCProp.sourceCopyId > 0 THEN DCProp.sourceCopyId ELSE a.defaultSnapCopy END
								FROM archDeferredCatalogProp DCProp  WITH (readuncommitted)
								WHERE DCProp.archGroupId = a.id)
				)
				)
				and c.archGroupId = a.id
			end
			else
			begin
				SET @ddbCopy = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @appNum AND attrName = 'DDB Backup CopyId' AND Modified = 0), 0)
				IF @ddbCopy > 0
				BEGIN
					SET @copyId = @ddbCopy
					insert into RMLogger values ('RMReserveWriter',
													'Override Backup CopyId [' + cast(@ddbCopy as varchar(10)) + ']',
													@i_RequestId, getutcdate())
				END
				select @copyId = isnull(c.id, 0),
							@isInlineCopy = 0,
							@copyFlags = isnull(c.flags, 0),
							@dedupeFlags = isnull(c.dedupeFlags, 0),
@dpFailoverFlags = isnull(c.flags, 0) & (512 | 8 | 16),
							@waitforifoffline = c.waitforifoffline,
							@waitforifbusy = c.waitforifbusy,
@UsePreferredDP = 1-sign(isnull(c.flags, 0) & (512 | 8 | 16) ),
							@archgroupid = a.id
				from archgroup a with (readuncommitted), app_application b with (readuncommitted), ArchGroupCopy c with (readuncommitted)
				where a.id = b.dataarchgrpid
				and b.id = @appNum
				and ((@copyId > 0 AND c.id = @copyId) OR (@copyId = 0 AND a.DefaultCopy = c.id))
				and c.archGroupId = a.id
			end
		end
		if @tinClientId is not null and @tinClientId > 0 and @tinClientId != @inClientId
		begin
			-- save the lookup on the client id, which may be used later by reservation for job's inline request
			--update RMReservationRequest set inClientId = @tinClientId where RequestId = @i_RequestId
			select @inClientId = @tinClientId
		end
		set @primaryCopyId = @copyId
		update RMReservationRequest set CopyId = @copyId where RequestId = @i_RequestId
	end
  if @copyId < 1
  begin
	  if @isDebug > 0
  		insert into RMLogger values ('RMReserveWriters',
  				'Error return because cannot find copy info by appId['+ cast(isnull(@appNum, 0) as varchar(20)) + ']...',
  				@i_RequestId, getutcdate())
set @o_ErrorCode = 20210
set @o_FailureType = 2
      goto exit_error
  end
	select @archGroupCopyName = name, @archGrpCpyExtFlags	= extendedFlags, @dedupeFlags = dedupeFlags from ArchGroupCopy with (readuncommitted) where Id = @copyId
	select @archGroupName	= a.name, @archGrpFlags = a.flags from ArchGroup a with (readuncommitted), ArchGroupCopy b with (readuncommitted) where b.Id = @copyId and b.archGroupId = a.Id
if @dedupeFlags & 262144 > 0
	begin
		if @jobType IN (@BKPJOB, @SYNTHFULLJOB, @CSDRBKPJOB)
		begin
			DECLARE @numSubclients INT = 0
			IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
			CREATE TABLE #lt_archCreateCopySubClientDDBMApOutput (xmlOutput XML)
			IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
			CREATE TABLE #inputApps -- only populate appID and copyID if this table is being created in the caller
			(
				appId	 INT,
				copyId	 INT,
				appTypeId	INT,
				instanceId	INT,
				clientId  INT,
				clientstatus INT,
				releaseId INT,
				servicePack INT
			)
			select @SIDBStoreId = SIDBStoreId
			from archSubclientCopyDDBMap with(readuncommitted) where appId = @appNum and copyId = @copyId
			if @SIDBStoreId = 0
			begin
				INSERT INTO #inputApps(appId, copyId)
				SELECT @appNum, @copyId
				SET @numSubclients = 1
			end
			--
			-- For VSA V2 we should check DDB mapping for child subclients also
			--
IF @appTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/
			BEGIN
				IF EXISTS
				(
					SELECT 	1
					FROM 	APP_ClientProp CL WITH (READUNCOMMITTED)
					WHERE 	CL.componentNameId = @clientId
							AND CL.attrName = 'IndexingV2_VSA'
							AND CL.attrVal = 1
							AND CL.modified = 0
				)
				BEGIN
					INSERT INTO #inputApps(appId, copyId)
					SELECT 	APP.id, @copyId
					FROM	(
								SELECT 	DISTINCT VMClientId
								FROM	App_VMProp  WITH(READUNCOMMITTED)
								WHERE	jobId = @jobId
AND commCellId = 2
							) AS VMP
							INNER JOIN APP_VMBackupSet VMB WITH(READUNCOMMITTED) ON VMP.VMClientId = VMB.VMClientId AND VMB.ParentBackupSetId = @backupsetId
							INNER JOIN App_Application APP  WITH(READUNCOMMITTED) ON VMB.ChildBackupSetId = APP.backupset
							LEFT OUTER JOIN archSubclientCopyDDBMap SMAP WITH(READUNCOMMITTED) ON SMAP.copyId = @copyId AND SMAP.appId = APP.id
					WHERE	SMAP.appId IS NULL
					SET @numSubclients += @@ROWCOUNT
				END
			END
			if @numSubclients > 0
			begin
				exec archCreateCopySubClientDDBMAp ''
				if @SIDBStoreId = 0
				begin
					select @SIDBStoreId = SIDBStoreId
					from archSubclientCopyDDBMap with(readuncommitted) where appId = @appNum and copyId = @copyId
				end
			end
			IF OBJECT_ID('tempdb..#lt_archCreateCopySubClientDDBMApOutput') IS NOT NULL DROP TABLE #lt_archCreateCopySubClientDDBMApOutput
			IF object_id('tempdb.dbo.#inputApps') is not null DROP TABLE #inputApps
		end
		else
		begin
			select @SIDBStoreId = destSIDBStoreId
			from ArchJobStreamStatus with(readuncommitted) where ReservationRequestId = @i_RequestId and JobId = @jobId and DestCopyId = @copyId
			--
			-- For AuxCopy SIDBStoreId must be set in the ArchJobStreamStatus table.
			-- Don't take default DDB for AuxCopy, this may cause data to be written to wrong DDB
			--
			if @SIDBStoreId = 0 and @jobOpType <> 104 /*AUXCOPY2*/
				select @SIDBStoreId = SIDBStoreId
from archCopySIDBStore with(readuncommitted) where copyId = @copyId and (flags & 2) > 0
		end
		--
		-- Fail the job if mapping is missing
		--
		IF @SIDBStoreId = 0
		BEGIN
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriters',
						'Error return because subclient to DDB mapping is missing',
						@i_RequestId, getutcdate())
set @o_ErrorCode = 485
set @o_FailureType = 2
			goto exit_error
		END
	end
	-- Don't allow backups to migrated copies.
	if not exists (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUPS_TO_MIGRATED_STORAGE_POLICIES' and value = 1)
		AND ( @jobType <> @MEDIAREFRESHINGJOB )
		AND (
( @archGrpFlags & 262144 > 0 AND @jobType IN (@BKPJOB, @SYNTHFULLJOB)) OR
@archGrpCpyExtFlags & 32 > 0
			)
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriters',
					'Error return because storage policy [' + @archGroupName + '] is migrated policy...',
					@i_RequestId, getutcdate())
set @o_ErrorCode = 849
set @o_FailureType = 1
		goto exit_error
	end
	-- Do load balance between datapaths when
	-- 1. config param is set
	-- 2. numStreams > 1
	-- 3. Round robin is set
	-- 4. copy has more than one MA
	-- 5. no inline copy
	DECLARE @isTransactionLogBackupPhase INT = 0
	EXEC MMIsTransactionLogBackupPhase @JobId, 2, @isTransactionLogBackupPhase output
	if exists (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_LOADBALANCE_ON_MULTIPLE_DATAPATHS_ALWAYS' and value > 0)
		and @jobOpType IN (4 /*BACKUP*/, 14 /*SYNTHFULL*/, 18 /*BACKUP3RD*/)
and	@iDAType IN (22, 80, 61, 81)
		and @numStreams > 3
		and @isTransactionLogBackupPhase = 0
and exists(select 1 from archGroupCopy WITH(READUNCOMMITTED) where id = @copyId and (flags & 512) > 0)
and (select count(distinct DrivePoolId) from MMDataPath WITH(READUNCOMMITTED) where CopyId = @copyId and (Flag & 4) > 0 ) > 1
		and @xmlCopyIdList IS NOT NULL
		and
		(
			ISNULL(@xmlCopyIdList.exist('/copyIdList'), 0) = 0
			or ISNULL(@xmlCopyIdList.exist('/copyIdList[@val != sql:variable("@copyId")]'), 0) = 0
		)
		-- Not support V10 client or V11 Client with server pack 13 or earier for CV_APPTYPE_SAP_FOR_ORACLE
		and	(	@clientReleaseId >= 16
and (@iDAType != 61 or @clientServicePackId >= 14)
			)
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriters',
					'Do load balance between datapaths...',
					@i_RequestId, getutcdate())
set @o_ErrorCode = 20163
set @o_FailureType = 2
		goto exit_error
	end
	if exists (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_LOADBALANCE_ON_MULTIPLE_DATAPATHS' and value > 0)
		and @jobOpType IN (4 /*BACKUP*/, 14 /*SYNTHFULL*/, 18 /*BACKUP3RD*/)
		and	(
@iDAType IN (		/*2, UNUSED_CV_APPTYPE_2,*/
22, 80, 61,
								/*CV_APPTYPE_INFORMIX,*/
37, 62, 103,
106 /*CV_APPTYPE_VIRTUAL_SERVER*/,
64  /*CV_APPTYPE_SGI_FS  */,
135
						)
				OR
				(
					-- Support load-balance for NAS client when using regular disk library
@iDAType IN (13, 88)
					AND
					(
						select count(distinct a.DrivePoolId)
						from MMDataPath a WITH(READUNCOMMITTED), MMDrivePool b WITH (READUNCOMMITTED)
where a.CopyId = @copyId and (a.Flag & 4) > 0
						and a.DrivePoolId = b.DrivePoolId
and b.DrivePoolType != 3
					) > 1
				)
			)
		and @numStreams > 3
		and @isTransactionLogBackupPhase = 0
and exists(select 1 from archGroupCopy WITH(READUNCOMMITTED) where id = @copyId and (flags & 512) > 0)
and (select count(distinct DrivePoolId) from MMDataPath WITH(READUNCOMMITTED) where CopyId = @copyId and (Flag & 4) > 0 ) > 1
		and @xmlCopyIdList IS NOT NULL
		and
		(
			ISNULL(@xmlCopyIdList.exist('/copyIdList'), 0) = 0
			or ISNULL(@xmlCopyIdList.exist('/copyIdList[@val != sql:variable("@copyId")]'), 0) = 0
		)
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriters',
					'Do load balance between datapaths...',
					@i_RequestId, getutcdate())
set @o_ErrorCode = 20163
set @o_FailureType = 2
		goto exit_error
	end
	--------------------------------
	-- Module: cache backup  --
	--------------------------------
--	#define UNUSED_CV_APPTYPE_2						2	-- Oracle 7
----	#define UNUSED_CV_APPTYPE_2						UNUSED_CV_APPTYPE_2
--	#define CV_APPTYPE_INFORMIX						3
--	#define CV_APPTYPE_ORACLE8						22
--	#define CV_APPTYPE_ORACLE_RAC					80
--	#define CV_APPTYPE_SAP_FOR_ORACLE		        61
--	#define CV_APPTYPE_DB2							37
--	#define CV_APPTYPE_UNIX_DB2	                    62
--	#define CV_APPTYPE_DB2_DPF						103
	-- Check if the backup caching feature is enabled to current backup job
	set @oraclBackupCachingEnabledByJob = 0
	set @backupCachingEnabledBySP = 0
select	@oraclBackupCachingEnabledByJob = cast(dbo.GetJobOption(@JobId, 1793771816) as int)
	if @oraclBackupCachingEnabledByJob > 0 and @SIDBStoreId > 0
	begin
		set @oraclBackupCachingEnabledByJob = 0
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriters',
						'Disabled BackupCaching for current job because this is a single instance backup.',
						@i_RequestId, getutcdate())
		end
	end
	if @oraclBackupCachingEnabledByJob > 0
	begin
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriters',
						'Enabled BackupCaching for current job based on the job opton.',
						@i_RequestId, getutcdate())
		end
	end
	if exists (select a.Id
				from ArchGroupCopy a with (readuncommitted), ArchGroup b with (readuncommitted)
where a.Id = @copyId and a.ArchGroupid = b.Id and b.Flags & 1048576 > 0)
	begin
		set @backupCachingEnabledBySP = 1
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriters',
'Enabled BackupCaching for current job based on the storage policy opton 1048576.',
						@i_RequestId, getutcdate())
		end
	end
	IF @jobOpType IN (4 /*BACKUP*/, 14 /*SYNTHFULL*/, 18 /*BACKUP3RD*/)
	AND	@isBackupCachingDisabled = 0
	AND (@oraclBackupCachingEnabledByJob > 0 or @backupCachingEnabledBySP > 0)
	BEGIN
		-- Release all the time out ones
		declare @cachetimeout int
		set @cachetimeout = 5
		select @cachetimeout = isnull(value, 5) from MMConfigs with (readuncommitted) where (name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_TIMEOUT_MINTUES')
		declare @rcidList table (reservationId int, rcid int)
		insert into @rcidList
		select distinct Reservationid, RCID
		from	MMResourceToJob with (readuncommitted)
		where	reservationtype = 2 /*write*/
		and		releasetime != 0
		and		datediff(s, dbo.GetDateTime(releasetime), getutcdate()) > (@cachetimeout * 60)
and 	(inuse = 0 OR (ReserveBitMask & (~2) = 0))
and		(@oraclBackupCachingEnabledByJob > 0 and (cast(dbo.GetJobOption(jobId_l, 1793771816) as int) > 0)
				or
				(@backupCachingEnabledBySP > 0 and exists (select c.Id from MMResource a with (readuncommitted), ArchGroupCopy b with (readuncommitted), ArchGroup c with (readuncommitted)
						where	a.Reservationid = MMResourceToJob.ReservationId
						and		a.CopyId = b.Id and b.ArchGroupId = c.Id
and		c.Flags & 1048576 > 0
						)
				)
				)
		and		NOT EXISTS (SELECT 1 FROM JMJobInfo with (nolock) WHERE JobId = MMResourceToJob.JobId_l)
		if (@@ROWCOUNT > 0)
		begin
			delete MMResourceToJob where RCID in (select RCID from @rcidList)
			delete MMResource
			where ReservationId in (select ReservationId from @rcidList)
			and not exists (select RCID from MMResourceToJob with (readuncommitted) where Reservationid = MMResource.ReservationId)
			if @isDebug > 0
			begin
				set @debugDetail = cast(isnull((select RCID	from @rcidList
										for XML RAW('TimeoutCachedRCId'), TYPE), 'NULL') as nvarchar(max))
				insert into RMLogger values ('RMReserveWriters', @debugDetail, @i_RequestId, getutcdate())
			end
		end
		DECLARE @isInUse				INT
		DECLARE @cachedReservationId	INT
		DECLARE @cachedRCId				INT
		SET @isInUse = 1
		SET @cachedReservationId = 0
		SET @cachedRCId = 0
		DECLARE @cachedResourceTable TABLE (ErrorCode int, ReservationId int, RCId int)
		DELETE @cachedResourceTable
		IF	@iDAType in (
2, 2,
22, 80, 61,
3,
37, 62, 103
				)
		AND @oraclBackupCachingEnabledByJob > 0
		BEGIN
			EXEC RMBackupCachingReserve @jobId, @copyId, @inClientId, @o_ErrorCode output, @cachedReservationId output, @cachedRCId output
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			  goto exit_error
			end
			if @isDebug > 0
			begin
				insert into RMLogger values ('RMBackupCachingReserve',
							'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20))
							+ '], FailureType['+ cast(@o_FailureType as varchar(20))
							+ '], ReservationId [' + cast(@cachedReservationId as varchar(20))
							+ '], RCId [' + cast(@cachedRCId as varchar(20)) + ']',
							@i_RequestId, getutcdate())
			end
			INSERT INTO @cachedResourceTable
SELECT 0, @cachedReservationId, @cachedRCId
		END
		ELSE IF @backupCachingEnabledBySP > 0
		BEGIN
			SELECT @backupCachingEnhance = isnull(value, 0) from MMConfigs with (readuncommitted) where (name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_ENHANCEMENT_STREAM_NUMBER')
			INSERT INTO @cachedResourceTable
EXEC @o_ErrorCode = RMReserveForCachedResource @jobId, @appNum, 0 /*archgroupId*/, @copyId, 2, @dataType, @numStreams, 0 /*not output*/, @o_ErrorCode output, @o_FailureType output,
											@cachedReservationId output, @cachedRCId output
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			  goto exit_error
			end
if @o_ErrorCode != 0
			begin
				DELETE @cachedResourceTable
				if @isDebug > 0
					insert into RMLogger values ('RMReserveForCachedResource',
							'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20))
							+ '], FailureType['+ cast(@o_FailureType as varchar(20)) + ']',
							@i_RequestId, getutcdate())
			end
			else if @isDebug > 0
			begin
				set @debugDetail = cast(isnull((select DISTINCT ReservationId, RCID	from @cachedResourceTable
										for XML RAW('CachedResources'), TYPE), 'NULL') as nvarchar(max))
				insert into RMLogger values ('RMReserveForCachedResource', @debugDetail, @i_RequestId, getutcdate())
			end
			-- For any reason, reservation for backup caching doesn't work. Check the number of current waiting job from the same storage policy.
			-- Try to reserve more than required streams if there are large number of waiting jobs.
			IF @backupCachingEnhance > 0
AND NOT EXISTS (SELECT 1 FROM @cachedResourceTable WHERE ErrorCode = 0 AND ReservationId > 0 AND RCId > 0 )
			BEGIN
				-- For now, don't support this for inline backup
				if @xmlCopyIdList IS NOT NULL
				and
				(
					ISNULL(@xmlCopyIdList.exist('/copyIdList'), 0) = 0
					or ISNULL(@xmlCopyIdList.exist('/copyIdList[@val != sql:variable("@copyId")]'), 0) = 0
				)
				BEGIN
					SELECT	@backupCachingExtraStreamNumber = COUNT(NumStreams)
					FROM	JMBkpJobInfo WITH (readuncommitted)
					WHERE	currentPolicy = @archGroupId --AND JobId != @jobId AND CommcellId = 2
					AND		numStreamsAllocated = 0
					IF @backupCachingExtraStreamNumber > @backupCachingEnhance
						SET @backupCachingExtraStreamNumber = @backupCachingEnhance
						if @isDebug > 0
						insert into RMLogger values ('RMReserveForCachedResource',
									'Turn on MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_ENHANCEMENT_STREAM_NUMBER feature with addtional stream number as [' + cast(@backupCachingExtraStreamNumber as varchar(20)) +']',
									@i_RequestId, getutcdate())
				END
				ELSE
				BEGIN
					if @isDebug > 0
						insert into RMLogger values ('RMReserveForCachedResource',
									'Turn off MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_ENHANCEMENT_STREAM_NUMBER feature due to inline copy configured',
									@i_RequestId, getutcdate())
					SET @backupCachingExtraStreamNumber = 0
					SET @backupCachingEnhance = 0
				END
			END
		END
IF @o_ErrorCode = 0
AND	EXISTS (SELECT * FROM @cachedResourceTable WHERE ErrorCode = 0 AND ReservationId > 0 AND RCId > 0 )
		--AND @cachedReservationId > 0
		--AND @cachedRCId > 0
		BEGIN
			INSERT INTO RMReservations
			SELECT	c.RCID, c.ReservationId, @i_RequestId, c.JobId_l, c.Priority, c.ReservationType, b.ReservationTime,
							b.CopyId, b.StreamId, b.VolumeId, b.MediaId, b.ScheduleRunId, b.NoOtherSchedule,
							b.SpareGroupId, b.MountPathId, b.DriveId, b.ClientId, b.DrivePoolId, b.MasterPoolId, b.LibraryId, b.LibraryTypeId,
							b.MediaGroupId, b.ResourceFlag, b.DriveInUseByDM, b.Released,
							c.PreEmptable, c.InUse, c.ReleaseTime, c.PrimaryRCID, c.ClientTokenId, c.DestMediaGroupid, c.LogicalReleased, b.IntrJobId_l
			FROM		@cachedResourceTable a, MMResource b, MMResourceToJob c
			WHERE		a.ReservationId = b.ReservationId AND a.ReservationId = c.ReservationId
			AND			a.RCID = c.RCID
			SET @o_ReservationList =
			(
				SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
						[copyRsrvList!1!drivePoolId], [copyRsrvList!1!driveId], [copyRsrvList!1!hostId],
						[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
						[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
						[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
						[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
						[rcidList!2!val]
				from (
				SELECT	DISTINCT 1			          as TAG,
					NuLL									as Parent,
					NuLL									as [copyRsrvList!1],
					res.ReservationId			as [copyRsrvList!1!reservationId],
					res.CopyId						as [copyRsrvList!1!copyId],
					res.StreamId					as [copyRsrvList!1!streamNum],
					res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
					res.DriveId						as [copyRsrvList!1!driveId],
					res.ClientId					as [copyRsrvList!1!hostId],
					res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
					res.VolumeId					as [copyRsrvList!1!volumeId],
					@sourceRCID						as [copyRsrvList!1!sourceRCID],
					@archGroupName				as [copyRsrvList!1!archGroupName],
					@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
					l.AliasName						as [copyRsrvList!1!libraryName],
					dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
					c.Name								as [copyRsrvList!1!mediaAgentName],
					d.AliasName						as [copyRsrvList!1!driveName],
					res.MediaId						as [copyRsrvList!1!mediaId],
					m.Barcode							as [copyRsrvList!1!mediaBarcode],
					NULL									as [rcidList!2!val]
					FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted),
					App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted),
					@cachedResourceTable cached
					WHERE	cached.ReservationId = res.ReservationId AND cached.ReservationId = resToJob.ReservationId AND cached.RCId = resToJob.RCID
					AND		res.LibraryId = l.LibraryId
					AND		res.DrivePoolId = dp.DrivePoolId
					AND		res.ClientId = c.Id
					AND		res.DriveId = d.DriveId
					AND		res.MediaId = m.MediaId
				UNION ALL
				SELECT	2			          as TAG,
					1											as Parent,
					NuLL									as [copyRsrvList!1],
					res.ReservationId			as [copyRsrvList!1!reservationId],
					res.CopyId						as [copyRsrvList!1!copyId],
					res.StreamId					as [copyRsrvList!1!streamNum],
					res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
					res.DriveId						as [copyRsrvList!1!driveId],
					res.ClientId					as [copyRsrvList!1!hostId],
					res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
					res.VolumeId					as [copyRsrvList!1!volumeId],
					@sourceRCID						as [copyRsrvList!1!sourceRCID],
					@archGroupName				as [copyRsrvList!1!archGroupName],
					@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
					l.AliasName						as [copyRsrvList!1!libraryName],
					dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
					c.Name								as [copyRsrvList!1!mediaAgentName],
					d.AliasName						as [copyRsrvList!1!driveName],
					res.MediaId						as [copyRsrvList!1!mediaId],
					m.Barcode							as [copyRsrvList!1!mediaBarcode],
					resToJob.RCID					as [rcidList!2!val]
					FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted),
					App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted),
					@cachedResourceTable cached
					WHERE	cached.ReservationId = res.ReservationId AND cached.ReservationId = resToJob.ReservationId AND cached.RCId = resToJob.RCID
					AND		res.LibraryId = l.LibraryId
					AND		res.DrivePoolId = dp.DrivePoolId
					AND		res.ClientId = c.Id
					AND		res.DriveId = d.DriveId
					AND		res.MediaId = m.MediaId
				) a
				ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
						[copyRsrvList!1!drivePoolId], [copyRsrvList!1!hostId],
						[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
						[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
						[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
						[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
						[rcidList!2!val]
				FOR XML EXPLICIT, TYPE
			)
			if @isDebug > 0
			begin
				insert into RMLogger values ('RMReserveWriter',
							cast(isnull(@o_ReservationList, '') as nvarchar(max)),
							@i_RequestId, getutcdate())
				insert into RMLogger values ('RMReserveWriter',
							'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20)) + '], FailureType['+ cast(@o_FailureType as varchar(20)) + ']...',
							@i_RequestId, getutcdate())
			end
			-- Only do the following when we don't expect return directly
			IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
			BEGIN
				if len(cast(@o_ReservationList as nvarchar(max))) > 3930
				begin
					set @o_ReservationList =  'EMPTY_RESULTS'
				end
			END
			SET XACT_ABORT OFF
RETURN 0
		END
		--RETURN @o_ErrorCode
		-- Continue with the regular reservation
SET	@o_ErrorCode = 0
		SET @cachedReservationId = 0
		SET @cachedRCId = 0
	END
	-- If current request is for inline copy reservation, make sure primary copy has no client side dedup enabled.
	-- Otherwise return error directly for the inline copy reservation.
		-- For inline copy only
	if @isInlineCopy > 0
	begin
		-- 1.	when client side is enabled only on the client and not on the Storage Policy
		-- Remvoe this check -- 2.	When inline copy is pointing to a GDSP which is client side de-dupe enabled.
		-- 3.	When client dedup is enabled on storage policy primary copy.
		if exists ( select prop.Id from App_ClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
								where app.Id = @appNum and app.ClientId = prop.ComponentNameId
								and prop.attrName = 'Enable DeDuplication' and prop.attrVal = '1' and prop.Modified = 0
							)
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriters',
						'Inline Copy Reservation cannot complete as client property has client side Dedup enabled.', @i_RequestId, getutcdate())
set @o_ErrorCode = 20068
set @o_FailureType = 2
			goto exit_error
		end
		/*
		if @SIDBStoreId > 0
		and exists (	select gp.id
									from ArchCopySIDBStore sidb with (readuncommitted), ArchGroupCopy copy with (readuncommitted), ArchGroup gp with (readuncommitted)
									where sidb.SIDBStoreId = @SIDBStoreId
									and sidb.CopyId = copy.id
									and copy.ArchGroupId = gp.Id
and copy.dedupeFlags & 268435456 > 0
and gp.flags & 256 > 0
and copy.dedupeFlags & 524288 > 0
								)
		begin
			insert into RMLogger values ('RMReserveWriters',
					'Inline Copy Reservation cannot complete as inline copy using a global deduplication policy whose primary copy has client side Dedup enabled.', @i_RequestId, getutcdate())
set @o_ErrorCode = 20069
set @o_FailureType = 2
			goto exit_error
		end
		*/
		if exists ( select Id from ArchGroupCopy with (readuncommitted)
								where Id = @primaryCopyId
and ( dedupeFlags & 262144 = 262144)
and ( dedupeFlags & 524288 = 524288)
							)
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriters',
						'Inline Copy Reservation cannot complete as the primary copy has client side Dedup enabled.', @i_RequestId, getutcdate())
set @o_ErrorCode = 20058
set @o_FailureType = 2
			goto exit_error
		end
	end
	-- Whether we should use subclient datapath
	-- Don't support subclient data path for log and snap backup.
IF @dataType = 4
OR @dataType = 6
	OR @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	OR @isInlineCopy = 1
	BEGIN
		SET @UseSCDataPath = 0
	END
	ELSE IF EXISTS (SELECT Id FROM App_Application WITH (READUNCOMMITTED) WHERE Id = @appNum AND dataArchGrpID = @archgroupid)
	BEGIN
		SET @UseSCDataPath =
			isnull
						(
							( SELECT TOP 1 cast(attrVal as int) from APP_SubClientProp WITH (READUNCOMMITTED)
							  where componentnameId = @appNum AND cs_attrName = CheckSum(N'Full Failover to SP dataPaths') AND
							  attrName = N'Full Failover to SP dataPaths' and modified = 0
							  order by Id DESC
							), 0
						)
	END
	ELSE IF EXISTS (SELECT a.Id
					FROM App_Application a WITH (READUNCOMMITTED), ArchGroup b WITH (READUNCOMMITTED)
					WHERE a.Id = @appNum
					AND a.dataArchGrpId = b.Id
					AND	b.IncrSP = @archGroupId)
	BEGIN
		SET @UseSCDataPath =
			isnull
						(
							( SELECT TOP 1 cast(attrVal as int) from APP_SubClientProp WITH (READUNCOMMITTED)
							  where componentnameId = @appNum AND cs_attrName = CheckSum(N'Non-Full Failover to SP dataPaths') AND
							  attrName = N'Non-Full Failover to SP dataPaths' and modified = 0
							  order by Id DESC
							), 0
						)
	END
	IF @UseSCDataPath > 0
	AND NOT EXISTS (select * from App_AppToDataPath with (readuncommitted) where ComponentNameId = @appNum and DataType = @dataType
and DataPathId in (select DataPathId from MMDataPath with (readuncommitted) where CopyId = @copyId and (flag & 16) = 0))
	BEGIN
		SET @UseSCDataPath = 0
	END
	set @IsForSILOBackup = 0
	-- Decide whether current job is SILO backup or not
	if @siloCopyId is not null and @siloCopyId > 0
	--if ( @dedupeFlags & CVA_BACKUP_SILO_ENABLED_FLAG > 0 )
	begin
		select @IsForSILOBackup = sign( isnull(bkpattributes, 0) & 0x100000000 /*JMBKP_SINGLE_INSTENCE_SILO*/ )
		from	JMBkpJobInfo with (readuncommitted) where	JobId = @JobId and CommcellId = 2
		if @IsForSILOBackup > 0
		begin
			set @SIDBStoreId = 0
			set @UseSCDataPath = 0
		end
	end
	-- Only SILO backup is allowed to use Global Deduplication storage policy
	if @IsForSILOBackup = 0
	and @jobType  not in ( @AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	and exists (select a.Id from ArchGroup a with (readuncommitted), ArchGroupCopy b with (readuncommitted)
							where b.Id = @copyId and a.Id = b.ArchGroupId
and ((a.flags & 256) > 0))
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriters',
  				'Error return because only SILO backup is allowed to use this global deduplication storage policy ['+ @archGroupName + ']...',
  				@i_RequestId, getutcdate())
set @o_ErrorCode = 848
set @o_FailureType = 2
      goto exit_error
	end
	-- Check if there is Job DataPath Option defined
  set @hasJobDataPathOptions = 0
  declare @jobOptionList varchar(max)
set @jobOptionList =	'<id val="' + cast(18276681 as varchar(20)) + '"/>' +
'<id val="' + cast(523178675 as varchar(20)) + '"/>' +
'<id val="' + cast(71136797 as varchar(20)) + '"/>' +
'<id val="' + cast(2081996217 as varchar(20)) + '"/>' +
'<id val="' + cast(1238677445 as varchar(20)) + '"/>'
	if exists (select * from dbo.GetJobOptionByIDList(CASE WHEN @parentJobId > 0 THEN @parentJobId ELSE @jobId END, @jobOptionList) where cast(value as int) > 0)
	begin
		set @hasJobDataPathOptions = 1
		if @isDebug > 0
		begin
set @debugDetail = cast(isnull((select case when optionId = 18276681 then 'Media Agent'
when optionId = 523178675 then 'Drive Pool'
when optionId = 71136797 then 'Library'
when optionId = 2081996217 then 'Spare Group'
when optionId = 1238677445 then 'Drive Id'
																									else 'NULL' end name,
																							value
																			from dbo.GetJobOptionByIDList(CASE WHEN @parentJobId > 0 THEN @parentJobId ELSE @jobId END, @jobOptionList) where cast (value as int) > 0
																			for XML RAW('JobDataPathOptions'), TYPE), 'NULL') as nvarchar(max))
			insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
		end
	end
	-- get the multiplexing factor, if not enabled, set @muxfactor = 1 --
	if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	begin
		--
		if @maxMXCount > 0
			set @MuxFactor = @maxMXCount
		else
		  select @MuxFactor = (case when @SIDBStoreId > 0
or 	(@dedupeFlags & 2097152 > 0 and @IsForSILOBackup = 0)
		  													then 1
										  					else (case when c.maxmultiplex <= 0 then 1 else c.maxmultiplex end)
													end)
		  from archgroupcopy c with (readuncommitted)
		  where c.id = @copyId
	end
	else if @IsInlineCopy > 0
	begin
		-- For inline copy reservation
		-- If combine stream feature is enabled and the multiplexing factor is set, then use multiplexing factor from inline copy
		-- If combine stream feature is enabled and the multiplexing factor is not set, then consider it as 1
		-- If combine stream feature is disabled, then use the multiplexing factor from primary copy.
if exists (select id  FROM ArchGroupCopy with (readuncommitted) WHERE Id = @copyId AND (Flags & 4) > 0)
		begin
		  select @MuxFactor = (case when @SIDBStoreId > 0
or 	(@dedupeFlags & 2097152 > 0 and @IsForSILOBackup = 0)
		  													then 1
										  					else (case when c.maxmultiplex <= 0 then 1 else c.maxmultiplex end)
													end)
		  from archgroupcopy c with (readuncommitted)
		  where c.id = @copyId
		end
		else
		begin
		  select @MuxFactor = (case when @SIDBStoreId > 0
or 	(@dedupeFlags & 2097152 > 0 and @IsForSILOBackup = 0)
		  													then 1
										  					else (case when c.maxmultiplex <= 0 then 1 else c.maxmultiplex end)
													end)
		  from archgroupcopy c with (readuncommitted), archgroup a with (readuncommitted)
		  where c.id = a.defaultcopy
		  and a.id = @archgroupid
		end
	end
	else
	begin
		-- Otherwise, use the setting on individual copy
	  select @MuxFactor = (case when @SIDBStoreId > 0
or 	(@dedupeFlags & 2097152 > 0 and @IsForSILOBackup = 0)
	  													then 1
									  					else (case when c.maxmultiplex <= 0 then 1 else c.maxmultiplex end)
												end)
	  from archgroupcopy c with (readuncommitted)
	  where c.id = @copyId
	end
  -- Adjust the number of streams to min 1
  IF @numStreams = 0
  BEGIN
	SET @numStreams = 1
  	IF @isDebug > 0
	BEGIN
		INSERT INTO RMLogger VALUES ('RMReserveWriter',	'Adjust NumSteams from 0 to default 1', @i_RequestId, getutcdate())
	END
  END
  -- Bestcase Reservation can be turned off by registry key bTurnOffBestcaseReservation under ResourceManager
  if @isTurnOffBestcaseReservation > 0
  	set @bestCaseReserve = 0
IF @iDAType IN (106) AND @jobOpType IN (4 /*BACKUP*/, 14 /*SYNTHFULL*/, 18 /*BACKUP3RD*/)
	SET @isBestcaseReserve	= @bestCaseReserve
	-- @numStreamsMin is the minimum number of streams required
	-- @numStreamsRemaining is the number of streams that need reservation
  if @bestCaseReserve = 0
    set @numStreamsMin = @numStreams
  else
    set @numStreamsMin = 1
  set @numStreamsRemaining = @numStreams
	IF @backupCachingEnhance > 0 AND @backupCachingExtraStreamNumber > @numStreams
	BEGIN
		set @numStreamsRemaining = @backupCachingExtraStreamNumber
	END
	-- For inline copy only
	if @isInlineCopy > 0
	begin
		set @isForRemainingStreams = 0
		select @numStreamsRemaining = count(distinct RCID)
		from RMReservations
		where RequestId = @i_RequestId
		and		copyId = @primaryCopyId
		if @failIfSecondaryCopyError > 0
			set @numStreamsMin = @numStreamsRemaining
		else
			set @numStreamsMin = 1
	end
	-- Check isForRemainingStreams
if @isForRemainingStreams > 0 and ( not exists (select 1 from MMResourceToJob with (readuncommitted) where ReservationType = 2 AND JobId_l = @jobId)
		OR (
			@UsePreferredDP > 0 AND @jobOpType IN (4 /*BACKUP*/) AND
			 EXISTS (select 1 from MMResource R with (readuncommitted) INNER JOIN MMResourceToJob RJ with (readuncommitted) ON R.reservationId = RJ.reservationId
INNER JOIN MMDataPath DP with (readuncommitted) ON DP.copyId = @copyId AND DP.DrivePoolId = R.DrivePoolId AND (DP.Flag & 1) = 0 WHERE RJ.JobId_l = @jobId)
		   ))
	BEGIN
		set @isForRemainingStreams = 0
	END
	-- check current reserved stream for this job.
	declare @MaxNumOfReservedStreams int
	select @MaxNumOfReservedStreams = MaxNumOfReservedStreams from RMReservationRequest where RequestId = @i_RequestId
	if @MaxNumOfReservedStreams is not null and @MaxNumOfReservedStreams > 0
	begin
		declare @NumOfCurrentReservedStreams int
		select @NumOfCurrentReservedStreams = count( distinct a.StreamId )
		from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
		where	a.CopyId = @copyId
		and		a.ReservationId = b.ReservationId
		and		b.JobId_h = 0 and b.JobId_l = @jobId
		if @NumOfCurrentReservedStreams >= @MaxNumOfReservedStreams
		begin
			-- TODO: set the correct error code here
set @o_ErrorCode = 2000
set @o_FailureType = 2
			goto exit_error
		end
	end
	-- If the client is a virtual client, get the physical Client id
	declare @physicalClientId int
	select	@physicalClientId = cast(attrVal as int)
	from		APP_ClientProp with (readuncommitted)
	where		componentNameId = @inClientId
	and			attrName = 'Active Physical Node'
	and			modified = 0
	-- If job is Synthetic full job, we allow it to use appendable media by default
  declare @UsePartialFullMedia int
	if @jobType = @SYNTHFULLJOB
	begin
		set @UsePartialFullMedia = 1 - sign( @markActiveMediaFull )
	end
	-- If copy has SILO enabled flag, but job is not SILO backup, don't use appenable media
else if ((@dedupeFlags & 2097152) > 0 and @IsForSILOBackup != 1)
	begin
		set @UsePartialFullMedia = 0
	end
	-- For SILO job, if there is a given SIDB Store Id, which means we probably need to compare the SIDB Store for job with SIDB Store Id from the media.
	-- Simply don't use appendable media will be fine.
	else if @IsForSILOBackup > 0 and @currentSIDBStoreId > 0
	begin
		set @UsePartialFullMedia = 0
	end
	else
	begin
  	set @UsePartialFullMedia = 1 - sign( @markActiveMediaFull )
	end
	-- Check the priority again
if exists (select * from JMJobInfo with (readuncommitted) where JobId = @JobId and commCellId = 2)
	begin
select @priority = combPriority from JMJobInfo with (readuncommitted) where JobId = @JobId and commCellId = 2
	end
	-- check option doNotAllowOtherSchedule
	if @MarkActiveMediaFull = 0
		set @doNotAllowOtherSchedule = 0
	-- check option for CVA_USE_STREAMS_OVER_MULTIPLEXING_FLAG
	declare @isUseStreamsOverMultiplexing int
if ( @copyFlags & 268435456 > 0 )
	begin
		set @isUseStreamsOverMultiplexing = 1
	end
	else
	begin
		set @isUseStreamsOverMultiplexing = 0
	end
	-- Interruption flag
	declare @BackupInterruptBackup int
	declare @OtherInterruptAuxCopy int
	declare @RestoreInterruptOther int
	declare @AuxCopyInterruptAuxCopy int
	set @BackupInterruptBackup	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMBackupInterruptBackup' and value like '1') then 1 else 0 end
	set @OtherInterruptAuxCopy	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMOtherJobsInterruptAuxCopy' and value like '1') then 1 else 0 end
	set @RestoreInterruptOther	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMRestoreInterruptOtherJobs' and value like '1') then 1 else 0 end
	set @AuxCopyInterruptAuxCopy	= case when exists (select value from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_AUX_COPY_PREEMPT_WITH_ANOTHER_AUX_COPY' and value = 1) then 1 else 0 end
	if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	or @IsInlineCopy = 1
	or @isDashSynFull > 0
	begin
		set @BackupInterruptBackup = 0
		set @OtherInterruptAuxCopy = 0
		set @RestoreInterruptOther = 0
	end
	if @i_CanJobInterruption = 0
	begin
		set @BackupInterruptBackup = 0
		set @OtherInterruptAuxCopy = 0
		set @RestoreInterruptOther = 0
		set @AuxCopyInterruptAuxCopy = 0
	end
	if @isDebug > 0
	begin
		set @debugDetail = cast(isnull((
												select @jobId JobID, 	(case when @jobType = @AUXCOPYJOB then 'YES' else 'NO' end) AuxCopyJob, (case when @jobType = @MEDIAREFRESHINGJOB then 'YES' else 'NO' end) MediaRefreshingJob,
																		(case when @jobType = @DASHCOPYJOB then 'YES' else 'NO' end) DashCopyJob,
																		(case when @isDashSynFull > 0 then 'YES' else 'NO' end) DashSynthFullJob,
																@copyId CopyID, @SIDBStoreId SIDBStoreID, @IsForSILOBackup IsForSILOBackup,
																@hasJobDataPathOptions HasJobDataPathOptions, @MuxFactor MultiplexingFactor, @isForRemainingStreams IsForRemainingStreams, @isUseStreamsOverMultiplexing IsUseStreamsOverMultiplexing
												for XML RAW('ReservationRequest'), TYPE), 'No Reservation Request') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
												select 	@bestCaseReserve BestCaseReserve, @numStreams NumOfStreams, @inClientId InlineClientID, @physicalClientId PhysicalClientID, @MAClientId SourceMediaAgentID,
																@markActiveMediaFull MarkActiveMediaFull, @UsePartialFullMedia UsePartialFullMedia, @isInlineCopy InlineCopy, @preferredMediaAgentId preferredMediaAgentID
												for XML RAW('ReservationRequest'), TYPE), 'No Reservation Request') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
	end
  ----------------------------------------
  --             License Check          --
  ----------------------------------------
	-- Check License before all start
	-- GridStore
	declare @dataPathCount int
	/* All datapaths in SILO copy are implicit SILO datapaths. Need not do the below explicit check as before
	if @isForSILOBackup = 0
select @dataPathCount = count(*) from MMDataPath with (readuncommitted) Where CopyId = @copyId and (Flag & 8) = 0 and (Flag & 16) = 0
	else
select @dataPathCount = count(*) from MMDataPath with (readuncommitted) where CopyId = @copyId /*and (Flag & 8) > 0*/ and (Flag & 16) = 0
	*/
select @dataPathCount = count(*) from MMDataPath with (readuncommitted) where CopyId = @copyId and (Flag & 16) = 0
	if @dataPathCount > 1
	begin
		set @hasLicense = 1
		/* Jai - Tue Apr  6 14:23:46 EDT 2010
		-- Removing check for GridStore license in 9.0.
		-- -- We are going to give this out with every CS. Not removing the license or the
		-- act of consumption yet.
		--
exec @hasLicense = RMCheckLicenseStatus 0, 2, 91, 1026, 'install', 0, 0
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		if @hasLicense = 0
		begin
			insert into RMLogger values ('RMReserveWriter', 'Error return because there is no GridStore license.', @i_RequestId, getutcdate())
set @o_ErrorCode = 833
set @o_FailureType = 1
			goto exit_error
		end
		*/
	end
	-- Multiplexing
	if @MuxFactor > 1
	begin
		set @hasLicense = 1
/*exec @hasLicense = RMCheckLicenseStatus 0, 2, SIM_CSL_AT_V2_DATA_MULTIPLEXING, 1023, 'install', 0, 0
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		if @hasLicense = 0
		begin
  		insert into RMLogger values ('RMReserveWriter', 'Error return because there is no Multiplexing license.', @i_RequestId, getutcdate())
set @o_ErrorCode = 834
set @o_FailureType = 1
			goto exit_error
		end
		*/
	end
	-- Inline copy
	if @isInlineCopy > 0 and  @jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	begin
		set @hasLicense = 1
/*exec @hasLicense = RMCheckLicenseStatus 0, 2, SIM_CSL_AT_V2_CELL_ADV_COPY, 1052, 'install', 0, 0
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		if @hasLicense = 0
		begin
  		insert into RMLogger values ('RMReserveWriter', 'Error return because there is no Inline Backup license.', @i_RequestId, getutcdate())
set @o_ErrorCode = 509
set @o_FailureType = 1
			goto exit_error
		end
		*/
	end
	-- capacity license check
	if @jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB, @CSDRBKPJOB, @SELDELETEJOB)
	and @IsForSILOBackup = 0
	begin
		exec @o_ErrorCode = LicIsCapactiyBasedValid @appType, @archgroupid, @appNum, @jobId
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
if @o_ErrorCode != 0
		begin
set @o_FailureType = 2
			GOTO exit_error
		end
	end
  ----------------------------------------
  --             End of Module          --
  ----------------------------------------
    ----------------------------------------
	-- Usage based license check Module
    ----------------------------------------
	if @jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB, @CSDRBKPJOB, @SELDELETEJOB)
	and @IsForSILOBackup = 0
	begin
		exec @o_ErrorCode = LicIsUsageBasedValid @appType, @jobId
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
if @o_ErrorCode != 0
		begin
set @o_FailureType = 2
			GOTO exit_error
		end
	end
	----------------------------------------
	-- End of Usage based license check
	----------------------------------------
  --------------------------------
  -- Module: claim interruption --
  --------------------------------
  if exists (select * from MMResource with (readuncommitted) where HasJobInterrupted = 1 and ReservationId in
  					 (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId))
  begin
		-- check if interrupted resource can be claimed
		-- There is no need to check the status in MMResource, as long as the entry MMResourceToJob is marked released for interrupted jobs.
		--if exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and Released = 0)
		if exists (select * from MMResourceToJob with (readuncommitted) where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and NOT (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))))
or exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and DriveId in (select DriveId from MMDrive with (readuncommitted) where MountStatus in (2, 3)))
		begin
			if @isDebug > 0
			begin
				-- interrupted resources are not freed yet
				set @debugDetail = cast(isnull((
												select	ReservationId, CopyId, StreamId, DrivePoolId, DriveId, MediaId
												from		MMResource with (readuncommitted)
												where		intrjobId_l = @JobId
												for XML RAW('InterruptedStreams'), TYPE), 'No Interrupted Resources') as nvarchar(max))
				insert into RMLogger values ('RMReserveWriter',
					'Error return because Interrupted resources are not freed yet' + @debugDetail, @i_RequestId, getutcdate())
			end
set @o_ErrorCode = 20004
set @o_FailureType = 2
		  goto exit_error
		end
		-- release interrupted resource
		delete from MMresourceToJob
		where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0)))
		delete from MMResource where intrjobid_l = @jobId
		-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
		-- those are place holder anyway, also we will have to check availability of everything
		delete @rmJustId
		insert into @rmJustId
		select reservationid from MMResource with (readuncommitted) where ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId)  and HasJobInterrupted = 1
		if @isDebug > 0
		begin
			set @debugDetail = cast(isnull((
												select distinct a.ReservationId RID, a.CopyId, a.StreamId, b.RCID, b.JobId_l JobId
												from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
												where a.ReservationId = b.ReservationId and a.ReservationId in (select id from @rmJustId)
												for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resources') as nvarchar(max))
			insert into RMLogger values ('Claim Interruption', @debugDetail, @i_RequestId, getutcdate())
		end
		delete from MMResourceToJob where ReservationId in (select id from @rmJustId)
		delete from MMResource where ReservationId in (select id from @rmJustId)
  end
  ---------------------------------------
  -- End of Module: claim interruption --
  ---------------------------------------
----------------------------------------------------
-- Module: check based on application setting         --
----------------------------------------------------
-- Check if the client job throttling reaches for Oracle RAC client database and archivelog backup
	if @jobType in (@BKPJOB, @CSDRBKPJOB) and @appClientId > 0
			  and     @iDAType in (
/*2, UNUSED_CV_APPTYPE_2,
22,*/ 80 /*, 61,
3,
37, 62, CV_APPTYPE_DB2_DPF*/
								  )
	begin
		declare @clientReservationNum int = 0
		declare @isForLogOnly int = 0
		if exists (select TOP 1 jobId from JMBkpJobInfo with (nolock)
				   where jobId = @jobId and (bkpattributes & 0x400000000000000 /*JMBKP_THROTTLE_FOR_DATA*/) > 0
					)
		begin
				select @clientReservationNum = isnull(convert(int, prop.attrVal), 0)
				from App_ClientProp prop with (readuncommitted)
				where @appClientId = prop.ComponentNameId
				and prop.Modified = 0
				and prop.attrName = 'Throttle Jobs - Data Threshold'
				set @isForLogOnly = 0
		end
		else if exists (select TOP 1 jobId from JMBkpJobInfo with (nolock)
				where jobId = @jobId and (bkpattributes & 0x800000000000000 /*JMBKP_THROTTLE_FOR_LOG*/)> 0
				)
		begin
				select @clientReservationNum = isnull(convert(int, prop.attrVal), 0)
				from App_ClientProp prop with (readuncommitted)
				where @appClientId = prop.ComponentNameId
				and prop.Modified = 0
				and prop.attrName = 'Throttle Jobs - Log Threshold'
				set @isForLogOnly = 1
		end
		if @clientReservationNum is not null and @clientReservationNum > 0
		begin
				declare @actualOracleClientId int = 0
				select @actualOracleClientId = ClientId from App_Application with (NOLOCK) where Id = @appNum
				declare @currentJobCountTbl table (jobCount int)
				if @isForLogOnly = 0
						INSERT INTO @currentJobCountTbl
					EXEC JMGetBkpJobCountForThrottle @jobId, @actualOracleClientId, @AppType, 0x400000000000000 /*JMBKP_THROTTLE_FOR_DATA*/, 0
				else
					INSERT INTO @currentJobCountTbl
					EXEC JMGetBkpJobCountForThrottle @jobId, @actualOracleClientId, @AppType, 0x800000000000000 /*JMBKP_THROTTLE_FOR_LOG*/, 0x400000000000000 /*JMBKP_THROTTLE_FOR_DATA*/
				if exists (select 1 from @currentJobCountTbl where jobCount >= @clientReservationNum)
				begin
						insert into RMLogger values ('RMReserveWriter',
								'Maximum number of concurrent backup jobs on current physical node (client) reaches the limit [' + cast(@clientReservationNum as varchar(10)) + ']',
								@i_RequestId, getutcdate())
set @o_ErrorCode = 20132
set @o_FailureType = 2
						goto exit_error
				end
		end
	end
  -----------------------------------
  -- Module: copy's data path view --
  -----------------------------------
  set @perferredDataPathDrvPoolForCopy = 0
 	--insert into rmDataPathView
	if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) and @originalAuxcopyDestCopyId > 0
	begin
	  exec RMGetDataPathViewForWrite @i_RequestId, @originalAuxcopyDestCopyId, @JobId, @JobType, @AppNum, @AppType, @DataType, @BkpLevel,
													@UseSCDataPath, @UsePreferredDP, @dpFailoverFlags, @IsForSILOBackup, @hasJobDataPathOptions, @inClientId, @isForRemainingStreams,
													@isDebug,	@o_ErrorCode output, @o_FailureType output
	end
	else
	begin
  exec RMGetDataPathViewForWrite @i_RequestId, @CopyId, @JobId, @JobType, @AppNum, @AppType, @DataType, @BkpLevel,
  												@UseSCDataPath, @UsePreferredDP, @dpFailoverFlags, @IsForSILOBackup, @hasJobDataPathOptions, @inClientId, @isForRemainingStreams,
  												@isDebug,	@o_ErrorCode output, @o_FailureType output
	end
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO exit_error
	END
	select @NumDataPathViews = COUNT(*) from RMDataPathView WHERE FailureErrorCode = 0
	if @NumDataPathViews > 0
	begin
exec RMDataPathStatusFilters @i_RequestId, 2, @copyId, @JobId, @JobType, @AppNum, @AppType, @IsForRemainingStreams,
													@IsForSILOBackup, @currentSIDBStoreId, @inClientId, @MAClientId, @isIndexingRequired, @UseSCDataPath, @isTransactionLogBackupPhase,
													@SIDBStoreId, @isDebug, @o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		select @NumDataPathViews = COUNT(*) from RMDataPathView WHERE FailureErrorCode = 0
	end
  if @NumDataPathViews = 0
  begin
  		-- The unusable DataPaths are all because either configuration or hardware problem. We cannot recover from it.
  		-- If no data path available at this time, just return directly from here.
  		-- We will do additional check on data path based on current reservation status.
  		-- In such case, if data path is no available, interruption might be needed.
  	 -- error code has been set in the sp RMGetDataPathView
if @o_ErrorCode = 0
set @o_ErrorCode = 20013
			--Job FailureType is set inside the stored procedures.
if exists (select * from RMDataPathView where FailureType = 2)
set @o_FailureType = 2
			else
set @o_FailureType = 1
			-- we don't need to show error message from these data paths in the GUI
delete RMDataPathView where FailureErrorCode in (20019, 20018)
			if @isDebug > 0
			begin
				set @debugDetail = cast(isnull((
													select distinct ag.name StoragePolicy, agc.name Copy,
																	a.DatapathId DataPathId, c.Name MediaAgent, l.AliasName Library,
																	mp.MasterPoolName MasterPool, dp.DrivePoolName DrivePool, sg.SpareGroupName SpareGroup,
																	a.FailureErrorCode UsableReason
													from RMDataPathView a, App_Client c with (readuncommitted), MMLibrary l with (readuncommitted), ArchGroup ag with (readuncommitted), ArchGroupCopy agc with (readuncommitted),
															 MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMSpareGroup sg with (readuncommitted)
													where agc.Id = @copyId and agc.ArchGroupId = ag.id
													and		a.HostClientId = c.Id and a.LibraryId = l.LibraryId
													and		a.DrivePoolId = dp.DrivePoolId and a.MasterPoolId = mp.MasterPoolId
													and		a.SpareGroupId = sg.SpareGroupId
													for XML RAW('DataPathList'), TYPE), 'No Data Path defined for copy') as nvarchar(max))
				insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
			end
  	  GOTO exit_error
  end
  -- Additional check for inline copy reservation and auxcopy reservation.
  -- They cannot be put into the general view handler.
  if @NumDataPathViews > 0 and @isInlineCopy > 0
  begin
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriter', 'This is for inline copy reservation.', @i_RequestId, getutcdate())
		end
  	-- For inline copy, make sure the Media Agent is the same as the one used by primary copy.
  	update RMDataPathView
set		FailureErrorCode = 20098,
FailureType = 2
  	where	FailureErrorCode = 0
  	and		HostClientId not in (select ClientId from RMReservations where RequestId = @i_RequestId and CopyId = @primaryCopyId)
  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 20098
				--set @o_FailureType = RM_FAILURE_JOB
		end
  	-- If copy flag set to not use the same library as the primary
if @NumDataPathViews > 0 and @copyFlags & 32768 > 0
  	begin
	  	update RMDataPathView
set		FailureErrorCode = 20014,
FailureType = 2
	  	where	FailureErrorCode = 0
	  	and		LibraryId in (select LibraryId from RMReservations where RequestId = @i_RequestId and CopyId = @primaryCopyId)
 	  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20014
					--set @o_FailureType = RM_FAILURE_JOB
			end
	end
  end
	-- If copy flag set to not use the same library as the primary
	if @NumDataPathViews > 0
	and @jobType in (@AUXCOPYJOB, @DASHCOPYJOB)
and @copyFlags & 65536 > 0
	begin
		if @jobType in (@AUXCOPYJOB)
		begin
			update RMDataPathView
set		FailureErrorCode = 20093,
FailureType = 2
			where	FailureErrorCode = 0
			and		LibraryId in (select LibraryId from RMReservations where RCID = @sourceRCID)
			set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20093
					--set @o_FailureType = RM_FAILURE_JOB
			end
		end
		else if @jobType in (@DASHCOPYJOB)
		begin
			-- check current source volume and library
			declare @sourceLibraryId int = 0
			select @sourceLibraryId = ISNULL(med.LibraryId, 0)
			from	(
						select TOP 1 FirstVolumeId as VolumeId from ArchJobStreamStatus with (NOLOCK) where ReservationRequestId = @i_RequestId and FirstVolumeId > 0
					) a,
					MMVolume vol with (NOLOCK), MMMedia med with (NOLOCK)
			where	a.VolumeId = vol.VolumeId
			and		vol.MediaId = med.MediaId
			if @sourceLibraryId > 0
			begin
				update RMDataPathView
set		FailureErrorCode = 20093,
FailureType = 2
				where	FailureErrorCode = 0
				and		LibraryId = @sourceLibraryId
				set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 20093
						--set @o_FailureType = RM_FAILURE_JOB
				end
			end
		end
	end
	-- Prevent VTL library being used for destination library when source media belongs to non-VTL library
	declare @sourceLibraryVTLType int = 0
	if @NumDataPathViews > 0
	and @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	and exists (select 1 from MMLibrary WITH (NOLOCK) where VTLType = 4 and LibraryId in (select DISTINCT LibraryId from RMDataPathView where FailureErrorCode =0))
	begin
		if @jobType in (@AUXCOPYJOB)
		begin
			select @sourceLibraryVTLType = lib.VTLType
			from	RMReservations res, MMLibrary lib
			where	res.RCID = @sourceRCID
			and		res.LibraryId = lib.LibraryId
		end
		else if @jobType in (@DASHCOPYJOB)
		begin
			select @sourceLibraryVTLType = ISNULL(lib.VTLType, 0)
			from	(
						select TOP 1 FirstVolumeId as VolumeId from ArchJobStreamStatus with (NOLOCK) where ReservationRequestId = @i_RequestId and FirstVolumeId > 0
					) a,
					MMVolume vol with (NOLOCK), MMMedia med with (NOLOCK), MMLibrary lib with (NOLOCK)
			where	a.VolumeId = vol.VolumeId
			and		vol.MediaId = med.MediaId
			and		med.LibraryId = lib.LibraryId
		end
		else if @jobType in (@MEDIAREFRESHINGJOB)
		begin
			if @sourceRCID > 0
			and exists (select RCID from RMReservations where RCId = @sourceRCID)
			begin
				select @sourceLibraryVTLType = lib.VTLType
				from	RMReservations res, MMLibrary lib with (nolock)
				where	res.RCID = @sourceRCID
				and		res.LibraryId = lib.LibraryId
			end
			else
			begin
				select @sourceLibraryVTLType = ISNULL(lib.VTLType, 0)
				from	(
							select TOP 1 FirstVolumeId as VolumeId from ArchJobStreamStatus with (NOLOCK) where ReservationRequestId = @i_RequestId and FirstVolumeId > 0
						) a,
						MMVolume vol with (NOLOCK), MMMedia med with (NOLOCK), MMLibrary lib with (NOLOCK)
				where	a.VolumeId = vol.VolumeId
				and		vol.MediaId = med.MediaId
				and		med.LibraryId = lib.LibraryId
			end
		end
		update	datapath
set		FailureErrorCode = 387,
FailureType = 2
		from	RMDataPathView datapath, MMLibrary lib
		where	datapath.FailureErrorCode = 0
		and		datapath.LibraryId = lib.LibraryId
		and		(
					(@sourceLibraryVTLType = 4 and lib.VTLType != 4)
					or
					(@sourceLibraryVTLType != 4 and lib.VTLType = 4)
				)
		set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		if @NumDataPathViews = 0
		begin
set @o_ErrorCode = 387
			--set @o_FailureType = RM_FAILURE_JOB
		end
	end
	--1.	If recommended MA is Offline then ignore recommend MA setting.
	--2.	If Catalogue server for the recommended MA is Online then ignore the recommended MA setting. All data paths are eligible. DataPath using recommanded MA has higher priority.
	--3.	If there is a catalogue server for the recommended MA and it is Offline then only allocate resources to the recommended MA.
	if @NumDataPathViews > 0
	-- Preferred MA exists and it is online
	and @preferredMediaAgentId > 0 and exists (select ClientId from MMHost with (readuncommitted)
																						 where ClientId = @preferredMediaAgentId and MMHostSoftState = 1 and MMHostEnabled = 1)
	-- Catalogue Server exists and it is offline
	and exists (
								select	h.ClientId from  MMHost h with (readuncommitted), IdxCache idxc with (readuncommitted), IdxAccessPath idxa with (readuncommitted)
								where		idxa.ClientId = @preferredMediaAgentId
								and			idxa.IdxCacheId = idxc.IdxCacheId
and			idxc.IdxCacheType = 1
								and			idxc.CatalogServerClientId > 0 and idxc.CatalogServerClientId = h.ClientId
								and			(h.MMHostSoftState <> 1 or h.MMHostEnabled <> 1)
							)
	begin
		if @isDebug > 0 -- and Catalog Server is offline
		begin
			insert into RMLogger values ('RMReserveWriter', 'There is a preferred Media Agent Id ['
																	+ cast(isnull(@preferredMediaAgentId, 0) as varchar(10)) + '], and Catalogue Server is offline. Other DataPaths using different MA will be disabled because of that.',
																	@i_RequestId, getutcdate())
		end
		-- If Catalogue Server is offline
  	begin
	  	update RMDataPathView
set		FailureErrorCode = 20059
	  	where	FailureErrorCode = 0
	  	and		HostClientId != @preferredMediaAgentId
 	  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20059
			end
	  end
	end
	-- If it is for NAS backup, make sure the backup only does reservation on the recommand MA.
	if exists (select value from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_USE_SAME_MA_FOR_INDEX_AND_BACKUP_IN_NASBACKUP' and value = 1)
	and @NumDataPathViews > 0
	and @preferredMediaAgentId > 0
and @AppType in (13, 88)
	/*
	and exists (select a.HostClientId
				from RMDataPathView a, MMDrivePool b WITH (READUNCOMMITTED)
				where	a.HostClientId = @preferredMediaAgentId
				and		a.DrivePoolId = b.DrivePoolId
				and		b.DrivePoolType = 3)
	*/
	begin
		delete RMDataPathView where HostClientId != @preferredMediaAgentId
		select @NumDataPathViews = count(*) from RMDataPathView where FailureErrorCode = 0
	end
	-- IBMi VTL
  	-- If it is IBM VTL backup Archive Index phase, make sure the backup only uses reservation with non-VTL drive pool
	-- If this is backup phase using IBM VTL library, remove the non-vtl library as well
	if @jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
	and @NumDataPathViews > 0
	and	(
			@use_nonvtl_drivepool > 0
			or
			exists (select 1 from RMDataPathView dp, MMLibrary l WITH (NOLOCK)
					where	dp.LibraryId = l.LibraryId
and		l.VTLType = 4	)
		)
	begin
		if @use_nonvtl_drivepool > 0
		begin
			update	dp
set		FailureErrorCode = 387
			from	RMDataPathView dp, MMLibrary as L WITH (NOLOCK)
			where	dp.FailureErrorCode = 0
			and		dp.LibraryId = L.LibraryId
and		L.VTLType = 4
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter', 'For current index phase, VTL Drive Pools are excluded.', @i_RequestId, getutcdate())
		end
		else
		begin
			update	dp
set		FailureErrorCode = 387
			from	RMDataPathView dp, MMLibrary l WITH (NOLOCK)
			where	dp.FailureErrorCode = 0
			and		dp.LibraryId = l.LibraryId
and		l.VTLType != 4
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter', 'For current backup phase, non-VTL Drive Pools are excluded', @i_RequestId, getutcdate())
			if exists (SELECT id FROM APP_Application WITH (NOLOCK)
						WHERE id = @appNum
AND (subclientStatus & 0x0100) = 0x0100)
			begin
				set @UsePartialFullMedia = 0
				set @markActiveMediaFull = 1
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter', 'For current subclient as VTL DR backup, only spare media should be used.', @i_RequestId, getutcdate())
			end
		end
		select @NumDataPathViews = count(*) from RMDataPathView where FailureErrorCode = 0
		if @NumDataPathViews = 0
		begin
			-- If no data path available at this time, just return directly from here.
			-- The unusable DataPaths are all because of requirements.
			-- error code has been set in the sp RMGetDataPathView
if @o_ErrorCode = 0
set @o_ErrorCode = 65301
			--Job FailureType is set inside the stored procedures.
set @o_FailureType = 2
		end
	end
	-- IBMi VTL
  if @NumDataPathViews = 0
  begin
  		-- The unusable DataPaths are all because either configuration or hardware problem. We cannot recover from it.
  		-- If no data path available at this time, just return directly from here.
  		-- We will do additional check on data path based on current reservation status.
  		-- In such case, if data path is no available, interruption might be needed.
  	 -- error code has been set in the sp RMGetDataPathView
if @o_ErrorCode = 0
set @o_ErrorCode = 20013
if exists (select * from RMDataPathView where FailureType = 2)
set @o_FailureType = 2
			else
set @o_FailureType = 1
			-- Special case for NAS client. Because it will use less data paths, don't put it in black list for NAS client backup
if @preferredMediaAgentId > 0 and @AppType in (13, 88)
set @o_FailureType = 2
			if @isDebug > 0
			begin
				set @debugDetail = cast(isnull((
													select distinct ag.name StoragePolicy, agc.name Copy,
																	a.DatapathId DataPathId, c.Name MediaAgent, l.AliasName Library,
																	mp.MasterPoolName MasterPool, dp.DrivePoolName DrivePool, sg.SpareGroupName SpareGroup,
																	a.FailureErrorCode UsableReason
													from RMDataPathView a, App_Client c with (readuncommitted), MMLibrary l with (readuncommitted), ArchGroup ag with (readuncommitted), ArchGroupCopy agc with (readuncommitted),
															 MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMSpareGroup sg with (readuncommitted)
													where agc.Id = @copyId and agc.ArchGroupId = ag.id
													and		a.HostClientId = c.Id and a.LibraryId = l.LibraryId
													and		a.DrivePoolId = dp.DrivePoolId and a.MasterPoolId = mp.MasterPoolId
													and		a.SpareGroupId = sg.SpareGroupId
													for XML RAW('DataPathList'), TYPE), 'No Data Path defined for copy') as nvarchar(max))
				insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
			end
  	  GOTO exit_error
  end
  select top 1 @perferredDataPathDrvPoolForCopy = DrivePoolId
  from RMDataPathView
  where Precedence >= 0
  order by Precedence
done_datapath:
  -- here, we have collect all data path for the copy for this job
  -- continue checking the drives
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(isnull(@NumDataPathViews, 0) as varchar(20)) + '] DataPath available.', @i_RequestId, getutcdate())
	end
  -- Collect the interruptible resource list in case of interruption
  -- Here we will have all the interruptible DataPath (drive pools) with the data path selection order,
  -- which should also be the interruption order.
  -- This can be used when Multiple Data Path interruption is allowed.
DECLARE @interruptibleDataPathView TABLE ( DataPathId			integer, CopyId				integer, StreamId			integer, DrivePoolId			integer, HostClientId		integer, DriveId				integer, SpareGroupId		integer, MountPathId			integer, MediaId				integer, Precedence			integer, UNIQUE CLUSTERED (DataPathId, CopyId, StreamId, DrivePoolId, DriveId, MediaId)    )
	INSERT INTO @interruptibleDataPathView
	SELECT	DataPathId, @CopyId, 0, DrivePoolId, HostClientId, 0, SpareGroupId, 0, 0, Precedence
	FROM	RMDataPathView
	WHERE FailureErrorCode = 0
	-- For now, we only support interruption for LAN-Free and Default data paths
	DELETE @interruptibleDataPathView
	WHERE DataPathId NOT in
	(	SELECT DataPathId FROM RMDataPathView a, MMDrivePool b WITH (READUNCOMMITTED)
		WHERE FailureErrorCode = 0
		AND		a.DrivePoolId = b.DrivePoolId
		AND		(
						-- For NAS, the Lan-Free client is based on the NDMP Host
						(b.DrivePoolType = 3 AND EXISTS ( SELECT ClientId FROM MMNDMPHostInfo WITH (READUNCOMMITTED) WHERE NDMPHostId = b.NDMPHostId AND ClientId in (@inClientId, @physicalClientId)))
						OR
						-- For Others, is the Client
						(b.DrivePoolType != 3 AND a.HostClientId in (@inClientId, @physicalClientId))
						-- Or default one
						OR
(a.Flag & 1) > 0
					)
	)
	IF @BackupInterruptBackup > 0 OR @OtherInterruptAuxCopy > 0 OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0)
	BEGIN
		-- This will set the interruptible stream count for each available data path
EXEC RMHandleInterrupt @i_RequestId, @jobId, @priority, 8, 0, @ReservationType,
														@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, @copyId, 0, @MuxFactor, 0, 0, 0, 0, 0,
														0,
														@isDebug, @o_ErrorCode output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		UPDATE RMDataPathView
		SET		interruptibleStreams = 0
		WHERE	DataPathId NOT in (SELECT DataPathId FROM @interruptibleDataPathView)
	END
 	-------------------------------------
  --          End of Module          --
  -------------------------------------
  -------------------------------------
  -- Module: load copy resource view --
  -------------------------------------
  insert into @RMCopyView
  exec RMGetCopyStreamView @i_RequestId, @CopyId, @DataMultiStream, @MuxFactor, @singleStream,
  												 @isForRemainingStreams, @forceMultiplexing, @scheduleRunId, @doNotAllowOtherSchedule, @MarkActiveMediaFull,
  												 @jobId, @jobType, @appNum, @isInlineCopy, @primaryCopyId, @isForSILOBackup, @isTransactionLogBackupPhase, @dataType, @SIDBStoreId,
  												 @isDebug, @o_ErrorCode output, @o_FailureType output, @skipStreamLimits output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO exit_error
	END
	if @isDebug > 0
	begin
		set @debugDetail = cast(isnull((
											select CopyId, StreamId, RemainingMx from @RMCopyView where FailureErrorCode = 0
											for XML RAW('AvailableStream'), TYPE), 'No available stream for the copy') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
											select CopyId, StreamId, RemainingMx, FailureErrorCode UnusableReason from @RMCopyView where FailureErrorCode > 0
											for XML RAW('UnusableStream'), TYPE), 'No unusable stream for the copy') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
	end
	if @DataMultiStream = 0
	begin
		select @NumCopyViews = count(*) from @RMCopyView where FailureErrorCode = 0
		-- Update the remaining multiplexing stream number for the given datapath.
		-- This only considers the multiplexable streams and no active streams.
		UPDATE	RMDataPathView
		SET			RemainingMx = (SELECT COUNT(*) FROM @RMCopyView WHERE FailureErrorCode = 0 AND DrivePoolId = RMDataPathView.DrivePoolId /*AND SpareGroupId = RMDataPathView.SpareGroupId*/)
		WHERE		FailureErrorCode = 0
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(isnull(@NumCopyViews, 0) as varchar(20)) + '] Stream available.', @i_RequestId, getutcdate())
		end
	end
	else
	begin
		select @NumCopyViews = sum(RemainingMx) from @RMCopyView where FailureErrorCode = 0
		-- Update the remaining multiplexing stream number for the given datapath
		-- This only considers the multiplexable streams and no active streams.
		UPDATE	RMDataPathView
		SET			RemainingMx = ISNULL((SELECT SUM(RemainingMx) FROM @RMCopyView WHERE FailureErrorCode = 0 AND DrivePoolId = RMDataPathView.DrivePoolId /*AND SpareGroupId = RMDataPathView.SpareGroupId*/), 0)
		WHERE		FailureErrorCode = 0
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(isnull(@NumCopyViews, 0) as varchar(20)) + '] Stream Multiplexing available.', @i_RequestId, getutcdate())
		end
	end
done_stream:
  ------------------------------
  -- Module: load drive view  --
  ------------------------------
 	DECLARE @jobOptionDriveIdList TABLE (DriveId int)
	INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(CASE WHEN @parentJobId > 0 THEN @parentJobId ELSE @jobId END, 1238677445) as int)
	DELETE @jobOptionDriveIdList WHERE DriveId = 0
	exec RMGetDriveView @i_RequestId, @JobId, @appType, @ReservationType, 0, @numStreams, @bestcaseReserve, @copyId, @UsePartialFullMedia,
											 @isDebug,  @o_ErrorCode output, @o_FailureType output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO exit_error
	END
SET @o_ErrorCode = 0
  -- Update the available data path list with the correct failure reason
	UPDATE	RMDataPathView
	SET			ReservedDriveCount = (SELECT COUNT( * )
																FROM		@RMCopyView
																WHERE		FailureErrorCode = 0
																AND			RMDataPathView.DrivePoolId = DrivePoolId
																/*AND			RMDataPathView.SpareGroupId = SpareGroupId*/ )
	UPDATE	RMDataPathView
	SET			NonReservedDriveCount = (SELECT COUNT( DISTINCT DriveId )
																		FROM #tmpRMDriveViewWithOffline
																		WHERE		FailureErrorCode = 0
																		AND			DataPathId = RMDataPathView.DataPathId)
	-- Select all the interruptible drives based on data path
	IF @BackupInterruptBackup > 0 OR @OtherInterruptAuxCopy > 0 OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0)
	BEGIN
		-- This will set the interruptible stream count for each available data path
EXEC RMHandleInterrupt @i_RequestId, @jobId, @priority, 16, 0, @ReservationType,
														@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, @copyId, 0, @MuxFactor, 0, 0, 0, 0, 0,
														0,
														@isDebug, @o_ErrorCode output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		UPDATE RMDataPathView
		SET		interruptibleDrives = 0
		WHERE	DataPathId NOT in (SELECT DataPathId FROM @interruptibleDataPathView)
	END
	UPDATE	RMDataPathView
	SET			FailureErrorCode = ISNULL((
															SELECT	TOP 1 FailureErrorCode
															FROM		#tmpRMDriveViewWithOffline
															WHERE		DataPathId = RMDataPathView.DataPathId
															AND			FailureErrorCode > 0
ORDER BY CASE WHEN 463 = FailureErrorCode THEN 1 ELSE 0 END,
																	FailurePriority DESC
), 807)
	WHERE		FailureErrorCode = 0
	AND			NonReservedDriveCount = 0
	AND			ReservedDriveCount = 0
	--AND			InterruptibleDrives = 0
	insert into @RMDriveView
	select DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId, LibrarySubType,
					SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0, DriveAttributes
	from	#tmpRMDriveViewWithOffline
	where	FailureErrorCode = 0
	order by Priority
  set @NumDriveViews = @@ROWCOUNT
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(isnull(@NumDriveViews, 0) as varchar(20)) + '] Drive(MountPath) available.', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
											select a.DrivePoolId, a.DriveId, a.MountPathId, a.LibraryId, b.DriveSoftState, b.offlineReason from #tmpRMDriveViewWithOffline a, mmdrive b with (nolock)  where a.FailureErrorCode = 0 and a.DriveId = b.DriveId order by Priority
											for XML RAW('AvailableDriveMountPath'), TYPE), 'No available Drive or Mount Path') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
											select a.DrivePoolId, a.DriveId, a.MountPathId, a.LibraryId, a.FailureErrorCode FailureReason, b.DriveSoftState, b.offlineReason from #tmpRMDriveViewWithOffline a, mmdrive b with (nolock)  where a.FailureErrorCode > 0 and a.DriveId = b.DriveId
											for XML RAW('UnusableDriveMountPath'), TYPE), 'No unusable Drive or Mount Path') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
	end
done_drive:
	if @isDebug > 0
	begin
		set @debugDetail = cast(isnull((select DataPathId, DrivePoolId, count(distinct DriveId) NumOfDrives
													from @RMDriveView group by DataPathId, DrivePoolId
													for XML RAW('AvailableDrives'), TYPE), 'No Available Drives') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
	end
 -----------------------------
  --        End of Module    --
  -----------------------------
  ------------------------------
  -- Module: load media view  --
  ------------------------------
	if exists (select DataPathId from RMDataPathView where FailureErrorCode = 0)
	-- If Backup can interrupt AuxCopy, donot do the following check, otherwise we cannot do interruption for media
	and (@OtherInterruptAuxCopy = 0 AND (@jobType NOT IN (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) OR @AuxCopyInterruptAuxCopy = 0))
	and not exists (select * from MMconfigs with (readuncommitted) where name = 'MMCONFIG_RESOURCEMANAGER_SKIP_MEDIA_COUNT_CALCULATION_DURING_BACKUP' and value > 0)
	begin
		insert into @RMMediaView
		exec RMGetMediaView @i_RequestId, @JobId, @CopyId, @doNotAllowOtherSchedule, @ScheduleRunId, @isDebug,
		 										@o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		UPDATE	RMDataPathView
		SET			AppendableMediaCount = b.AppendableMediaCount,
						SpareMediaCount = b.SpareMediaCount
		FROM		RMDataPathView a, @RMMediaView b
		WHERE		a.FailureErrorCode = 0
		AND			a.SpareGroupId > 0
AND			a.LibraryTypeId NOT in  (3,	4, 5)
		AND			a.DataPathId = b.DataPathId
	end
  -----------------------------
  --        End of Module    --
  -----------------------------
  -----------------------------------------------
  -- Filter: number of streams required by job --
  -----------------------------------------------
	IF @skipStreamLimits = 0
	BEGIN
exec RMDataPathAdditionalFilter @i_RequestId, 2, @JobId,
													@numStreams, @bestcaseReserve, @dataMultiStream, @MuxFactor, @extraRestoreDrive, @extraRestoreDrivePoolId,
													@copyId, @SIDBStoreId, @appNum, @isTransactionLogBackupPhase,
													@isDebug, @o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
	END
  -- Check Streams
  -- Cannot do this in above stored procedure because it has no active stream information.
  update	RMDataPathView
set			FailureErrorCode = 20025,
FailureType = 1
	where		FailureErrorCode = 0
	and			RemainingMx <= 0
	and			not exists (select * from @RMCopyView where FailureErrorCode = 0 and DrivePoolId = 0)
  /* After additional checks see if we have any online data paths. If yes, then we can mark the offline power VM datapaths as offline */
  IF EXISTS (
				SELECT 1 FROM RMDataPathView DP INNER JOIN MMHost H ON DP.HostClientId = H.ClientId
				WHERE DP.FailureErrorCode = 0 AND H.OfflineReason <> 7 /* HOST_STATUS_POWER_MANAGED_VM */
			)
AND (@dpFailoverFlags & 512) = 0
   BEGIN
		UPDATE RMDataPathView
SET	FailureErrorCode = 384
		FROM RMDataPathView DP INNER JOIN MMHost H ON DP.HostClientId = H.ClientId
		WHERE DP.FailureErrorCode = 0 AND H.OfflineReason = 7 /* HOST_STATUS_POWER_MANAGED_VM */ AND H.MmHostSoftState <> 1
   END
  select @NumDataPathViews = COUNT(*) from RMDataPathView WHERE FailureErrorCode = 0
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(isnull(@NumDataPathViews, 0) as varchar(20)) + '] DataPath available after additional checks.', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
											select distinct a.DatapathId DataPathId, c.Name MediaAgent, l.AliasName Library,
															dp.DrivePoolName DrivePool, sg.SpareGroupName SpareGroup
											from RMDataPathView a, App_Client c with (readuncommitted), MMLibrary l with (readuncommitted), ArchGroup ag with (readuncommitted), ArchGroupCopy agc with (readuncommitted),
													 MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMSpareGroup sg with (readuncommitted)
											where agc.Id = @copyId and agc.ArchGroupId = ag.id
											and		a.HostClientId = c.Id and a.LibraryId = l.LibraryId
											and		a.DrivePoolId = dp.DrivePoolId and a.MasterPoolId = mp.MasterPoolId
											and		a.SpareGroupId = sg.SpareGroupId
											and		a.FailureErrorCode = 0
											for XML RAW('AvailableDataPath'), TYPE), 'No Available DataPath') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
											select distinct a.DatapathId DataPathId, c.Name MediaAgent, l.AliasName Library,
															dp.DrivePoolName DrivePool, sg.SpareGroupName SpareGroup,
															a.FailureErrorCode UsableReason
											from RMDataPathView a, App_Client c with (readuncommitted), MMLibrary l with (readuncommitted), ArchGroup ag with (readuncommitted), ArchGroupCopy agc with (readuncommitted),
													 MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMSpareGroup sg with (readuncommitted)
											where agc.Id = @copyId and agc.ArchGroupId = ag.id
											and		a.HostClientId = c.Id and a.LibraryId = l.LibraryId
											and		a.DrivePoolId = dp.DrivePoolId and a.MasterPoolId = mp.MasterPoolId
											and		a.SpareGroupId = sg.SpareGroupId
											and		a.FailureErrorCode > 0
											for XML RAW('UnusableDataPath'), TYPE), 'No Unusable DataPath') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
	end
  ------------------------------------------------------
  -- End of Filter: number of streams required by job --
  ------------------------------------------------------
/*
  -------------------------------------------
  -- Module: build the resource candidates --
  -------------------------------------------
  insert into @RMCopyView
  select a.CopyId,  a.StreamId, a.MediaGroupId, a.RemainingMx, b.DrivePoolId,
		 b.DriveId, 0, 0, b.SpareGroupId, b.MountPathId, 0,
		 a.NoMux, a.NoOtherSchedule, a.ScheduleRunId, a.lastUsedTime, 0, 0, 0
  from @RMCopyView a, @RMDriveView b
  where a.ReservationId = 0  or a.DrivePoolId = 0
  delete from @RMCopyView where DrivePoolId = 0
  -------------------------------------------------
  --                  End Of Module              --
  -------------------------------------------------
*/
  ----------------------------------
  -- Module: select the drivepool --
  ----------------------------------
  update @RMCopyView
  set a.Flag = b.Flag
  from @RMCopyView a, RMDataPathView b
  where a.DrivePoolId = b.DrivePoolId
  and	a.SpareGroupId = b.SpareGroupId
	-- Pick the data path based on predefine precedence on available data paths
  -- @dpFailoverFlags = isnull(c.flags, 0) & (CVA_SWITCHLOADBALANCED | CVA_SWITCHIFOFFLINE | CVA_SWITCHIFBUSY),
  declare @resDrivePoolId integer
  declare @resSpareGroupId integer
  declare @resDataPathId	integer
  declare @resClientId		integer
  declare @resCurrentFailureErrorCode integer = 0
  declare @rmDriveId table (DriveId int, CopyId int, StreamId int)
  declare @rmRCID table (RCID int, ReservationID int)
  declare @curReservationId int
  declare @curCopyId int
  declare @curStreamId int
  declare @curRemainingMx int
  declare @curMediaGroupId int
  declare @curDrivePoolId int
  declare @curDriveId int
  declare @curVolumeId int
  declare @curMediaId int
  declare @curSpareGroupId int
  declare @curMountPathId int
  declare @curRCID int
  declare @curClientId int
  declare @curMasterPoolId int
  declare @curLibraryId int
  declare @curLibraryTypeId int
  declare @curResourceFlag int
  declare @curDriveInUseByMM int
  declare @curReleased int
  declare @curScheduleRunId bigint
  declare @curDataPathId int
  declare @curMediaTypeId	int
  declare @curRecordingFormatId int
  declare @curPrimaryResId int
  declare @curPrimaryRCId int
  declare @curPrimaryStreamId int
  declare @curReserveBitMask int
  declare @newClientId int
  declare @newMasterPoolId int
  declare @newLibraryId int
  declare @newLibraryTypeId int
  declare @newResourceFlag int
  declare @mountedMediaId int
  delete	@rmJustId
  declare @LogEvent integer
  declare @migrated integer
  declare @curVolMarkFull integer
  declare @curVolFullReason integer
	DECLARE @interruptibleDataPathList TABLE (DataPathId int)
	declare @numInterrupted int
	declare @existingResCount int
	declare @remainingResCount int
	set @existingResCount = 0
	set @remainingResCount = 0
	DECLARE @tempLogger TABLE (	RMModule	varchar(100),	State		varchar(max), RequestId	integer, TimeStamp	datetime)
	declare @mountPathReservationsNum int = 0
PICKING_DATAPATH:
	SET @curReservationCount = 0
	delete @rmRCID
	delete @rmDriveId
	delete @interruptibleDataPathList
	where DataPathId not in (
				select DataPathId from RMDataPathView
where FailureErrorCode in (330,
349,
20118,
296,
297,
296,
20006)
				)
	set @resDrivePoolId = 0
	set @resSpareGroupId = 0
	set @resDataPathId = 0
	set @resClientid = 0
	set @resCurrentFailureErrorCode = 0
	select top 1	@resDrivePoolId = isnull(DrivePoolId, 0),
								@resSpareGroupId = isnull(SpareGroupId, 0),
								@resDataPathId = isnull(DataPathId, 0),
								@resClientId = isnull(HostClientId, 0)
	from RMDataPathView
	where FailureErrorCode = 0
	order by
		-- If there is preferred media agent, it will be pick first.
		--case when (@preferredMediaAgentId > 0 and HostClientId = @preferredMediaAgentId) then 0 else 1 end,
		Precedence,
case when (LibraryTypeId = 3) then 0 else 1 end,
		(NonReservedDriveCount + ReservedDriveCount),
		(NonReservedDriveCount + RemainingMx),
		ReservedDriveCount,
		RemainingMx
	declare @reasonNotAvailable int
	declare @FailureReason int
	if @resDrivePoolId is null or @resDrivePoolId = 0
	begin
		-- Now we also consider the Data Path that has interruptible streams
		select top 1	@resDrivePoolId = isnull(DrivePoolId, 0),
									@resSpareGroupId = isnull(SpareGroupId, 0),
									@resDataPathId = isnull(DataPathId, 0),
									@resClientId = isnull(HostClientId, 0),
									@resCurrentFailureErrorCode = isnull(FailureErrorCode, 0)
		from RMDataPathView
		where interruptibleStreams > 0
		and		(RemainingMx + interruptibleStreams * @MuxFactor) >= @numStreamsMin
		and		DataPathId not in (select DataPathId from @interruptibleDataPathList)
		order by
			-- If there is preferred media agent, it will be pick first.
			--case when (@preferredMediaAgentId > 0 and HostClientId = @preferredMediaAgentId) then 0 else 1 end,
			-- cliu 10/22/2018, check based on failure reason to make sure the data path with available interrupted stream picked first
case when FailureErrorCode = 20025 then 0 else 1 end,
			Precedence,
case when (LibraryTypeId = 3) then 0 else 1 end,
			(NonReservedDriveCount + ReservedDriveCount),
			(NonReservedDriveCount + RemainingMx),
			ReservedDriveCount,
			RemainingMx
		-- if there are also interruptible drives
		if @resDrivePoolId is null or @resDrivePoolId = 0
		begin
				select top 1	@resDrivePoolId = isnull(DrivePoolId, 0),
									@resSpareGroupId = isnull(SpareGroupId, 0),
									@resDataPathId = isnull(DataPathId, 0),
									@resClientId = isnull(HostClientId, 0),
									@resCurrentFailureErrorCode = isnull(FailureErrorCode, 0)
				from RMDataPathView
				where interruptibleDrives > 0
				and		(RemainingMx + (NonReservedDriveCount + interruptibleDrives) * @MuxFactor) >= @numStreamsMin
				and		DataPathId not in (select DataPathId from @interruptibleDataPathList)
				order by
					-- If there is preferred media agent, it will be pick first.
					--case when (@preferredMediaAgentId > 0 and HostClientId = @preferredMediaAgentId) then 0 else 1 end,
					-- cliu 10/22/2018, check based on failure reason to make sure the data path with available interrupted drive picked first
					case when NonReservedDriveCount = 0 and ReservedDriveCount = 0 then 0 else 1 end,
					Precedence,
case when (LibraryTypeId = 3) then 0 else 1 end,
					(NonReservedDriveCount + ReservedDriveCount),
					(NonReservedDriveCount + RemainingMx),
					ReservedDriveCount,
					RemainingMx
		end
		-- If there are interruption can happend by other cases
		if (@resDrivePoolId is null or @resDrivePoolId = 0)
		and (@BackupInterruptBackup > 0 OR @OtherInterruptAuxCopy > 0 OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
		and exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_INTERRUPTION_BASED_ON_ERROR' and value > 0)
		begin
				select top 1	@resDrivePoolId = isnull(DrivePoolId, 0),
									@resSpareGroupId = isnull(SpareGroupId, 0),
									@resDataPathId = isnull(DataPathId, 0),
									@resClientId = isnull(HostClientId, 0),
									@resCurrentFailureErrorCode = isnull(FailureErrorCode, 0)
				from RMDataPathView
where FailureErrorCode in (330,
349,
20118,
296,
297,
296,
20006)
				and		DataPathId not in (select DataPathId from @interruptibleDataPathList)
				and		exists (select 1 from @RMDriveView where RMDataPathView.DrivePoolId = DrivePoolId)
				order by
					Precedence,
case when (LibraryTypeId = 3) then 0 else 1 end,
					(NonReservedDriveCount + ReservedDriveCount),
					(NonReservedDriveCount + RemainingMx),
					ReservedDriveCount,
					RemainingMx
		end
		if @resDrivePoolId is null or @resDrivePoolId = 0
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter', 'Error return because no data path available for reservation', @i_RequestId, getutcdate())
			if @perferredDataPathDrvPoolForCopy > 0
select @o_ErrorCode = isnull(FailureErrorCode, 0) from  RMDataPathView where DrivePoolId = @perferredDataPathDrvPoolForCopy
			if not exists (select * from @jobOptionDriveIdList)
			begin
				-- Right now the reservation fails and we cannot do interruption also.
				-- Set the Donot Multiplexing flag on current copy. The flag will be reset when the next reservation loop starts.
				-- It is set based on the master pool of the data paths that can be used by current job (with precedence greater than 0).
update	MMResource set ResourceFlag = ResourceFlag | 2
				from		MMResource
				where		StreamId != 0
				and			HasJobInterrupted = 0
				and			Priority > @Priority
				and			exists (select MasterPoolId from RMDataPathView where Precedence > 0 and MMResource.MasterPoolId = MasterPoolId)
				and			exists (select id from ArchGroupCopy with (readuncommitted) where MaxMultiplex > 1 and Id = MMResource.CopyId)
			end
			else
			begin
				-- if exist job option for drive id. only make that drive not multiplexable
update	MMResource set ResourceFlag = ResourceFlag | 2
				from		MMResource
				where		StreamId != 0
				and			HasJobInterrupted = 0
				and			Priority > @Priority
				and			exists (select DriveId from @jobOptionDriveIdList where MMResource.DriveId = DriveId)
			end
			-- Special case when all the streams are reserved and reached the max multipex factor, and they cannot be interrupted.
			-- Set clearer error code.
if not exists (select * from RMDataPathView where FailureErrorCode != 20025)
			begin
set @o_ErrorCode = 20025
			end
else if @o_ErrorCode = 0
			begin
set @o_ErrorCode = 20013
			end
if exists (select * from RMDataPathView where FailureType = 2)
set @o_FailureType = 2
			else
set @o_FailureType = 1
			-- Special case for NAS client. Because it will use less data paths, don't put it in black list for NAS client backup
if @preferredMediaAgentId > 0 and @AppType in (13, 88)
set @o_FailureType = 2
			goto exit_error
		end
		insert into @interruptibleDataPathList
		select @resDataPathId
	end
	-- If the selected drivepool id is different from the perferred drive pool,
	-- it requires data path failover, which condition depends on the data path failover flag.
	/*
	if @IsForSILOBackup > 0
	begin
		insert into RMLogger values ('RMReserveWriter',
						'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on SILO DataPath', @i_RequestId, getutcdate())
	end
	else
	*/
	if @hasJobDataPathOptions > 0
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter',
						'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on Job DataPath Option', @i_RequestId, getutcdate())
	end
	else if @useSCDataPath > 0
	begin
		if @resDrivePoolId = @perferredDataPathDrvPoolForCopy
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter',
							'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on SubClient DataPath', @i_RequestId, getutcdate())
		end
else if (@dpFailoverFlags & 512) > 0
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter',
								'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on SubClient DataPath LOAD BALANCING', @i_RequestId, getutcdate())
		end
		else --if @resDrivePoolId <> @perferredDataPathDrvPoolForCopy
		begin
			-- Check the reason why the perferred datapath is not available
			-- If there is already a reservation, must be busy, otherwise offline. May need more clear reason.
			if exists(select * from MMResource  with (readuncommitted) where drivepoolid = @perferredDataPathDrvPoolForCopy)
set @reasonNotAvailable = 20045
			else
			begin
select @FailureReason = isnull(FailureErrorCode, 0) FROM RMDataPathView WHERE DrivePoolId = @perferredDataPathDrvPoolForCopy
if @FailureReason <> 0
				begin
					exec RMGetDataPathUnusableReason @FailureReason, @reasonNotAvailable output
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
				end
				else
				begin
set @reasonNotAvailable = 20044
				end
			end
			if (
((@dpFailoverFlags & 8) > 0 and
				 		datediff(s, dbo.GetDateTime(@phaseFirstAttemptTime), getutcdate()) >= @waitforifoffline and
@reasonNotAvailable = 20044
				)
				or
((@dpFailoverFlags & 16) > 0 and
						datediff(s, dbo.GetDateTime(@phaseFirstAttemptTime), getutcdate()) >= @waitforifbusy and
@reasonNotAvailable = 20045)
				)
			begin
				if @isDebug > 0
				begin
set @debugDetail =  case @reasonNotAvailable when 20045
																then 'Goto Failover SubClient DataPath because all the reservable drives are busy.'
when 20044
																then 'Goto Failover SubClient DataPath because all the reservable drives are offline.'
																else 'Unknow DataPath Failover Reason.'
																	end
					insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
				end
			end
else if ( (@dpFailoverFlags & 8) > 0 or (@dpFailoverFlags & 16) > 0 )
			begin
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter',
										'SubClient preferred DataPaths are not usable and DataPath Failover condition does not meet yet', @i_RequestId, getutcdate())
				-- if the failover condition is not met, don't return drive pool id
				set @resDrivePoolId = 0
				set @o_ErrorCode = @reasonNotAvailable
set @o_FailureType = 2
				goto exit_error
			end
			else -- if use preferred data path only
			begin
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter',
										'SubClient preferred DataPaths are not usable', @i_RequestId, getutcdate())
				-- if the failover condition is not met, don't return drive pool id
				set @resDrivePoolId = 0
				set @o_ErrorCode = @reasonNotAvailable
set @o_FailureType = 2
				goto exit_error
			end
		end
	end
	else if exists (select a.DataPathId
									from RMDataPathView a, MMDrivePool b with (readuncommitted)
									where a.DrivePoolId = @resDrivePoolId and b.DrivePoolId = @resDrivePoolId
									and		(
													(b.DrivePoolType = 3 and exists (select ClientId from MMNDMPHostInfo with (readuncommitted) where NDMPHostId = b.NDMPHostId and ClientId in (@inClientId, @physicalClientId)))
													or
													(b.DrivePoolType != 3 and a.HostClientId in (@inClientId, @physicalClientId))
												)
									)
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter',
							'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on LAN-Free', @i_RequestId, getutcdate())
	end
	else if exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_CONSIDER_GEOMETRY_LOCATION' and value > 0)
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter',
							'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on geometric location', @i_RequestId, getutcdate())
	end
	else if exists (select 1 from MMConfigs where name = 'RM_CONFIG_PREFER_MA_FROM_PREFERRED_MEDIA_AGENT_GROUP' and value > 0)
		and exists (select 1 from RMDataPathView a, MMDrivePool b with (readuncommitted)
					where a.DrivePoolId = b.DrivePoolId and b.DrivePoolId = @resDrivePoolId
					and dbo.AppGetAdditionalSettingForClient((case when isnull(@physicalClientId, 0) > 0 then @physicalClientId else @inClientId end),
'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
						= dbo.AppGetAdditionalSettingForClient(
								(case when b.DrivePoolType = 3 then (select clientId from MMNDMPHostInfo with (readuncommitted) where NDMPHostId = b.NDMPHostId) else a.HostClientId end),
'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
					)
    begin
            insert into RMLogger values ('RMReserveWriter',
                            'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on client advanced setting PreferredMediaAgentGroup', @i_RequestId, getutcdate())
    end
else if (@dpFailoverFlags & 512) > 0
	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter',
							'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on LOAD BALANCING', @i_RequestId, getutcdate())
	end
	else -- Use Preferred Data Path or (@dpFailoverFlags & (CVA_SWITCHIFOFFLINE | CVA_SWITCHIFBUSY)) > 0
	begin
		if @IsInlineCopy > 0
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter',
							'This is inline Copy reservation. Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on primary copy reservation.', @i_RequestId, getutcdate())
		end
		else if @JobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveWriter',
							'This is AuxCopy (Media Refresh) reservation. Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on preferred Drive Pool Id.', @i_RequestId, getutcdate())
		end
		else if @resDrivePoolId <> @perferredDataPathDrvPoolForCopy
		begin
			-- Check the reason why the perferred datapath is not available
			-- If there is already a reservation, must be busy, otherwise offline. May need more clear reason.
			if exists(select * from MMResource  with (readuncommitted) where drivepoolid = @perferredDataPathDrvPoolForCopy)
			begin
set @reasonNotAvailable = 20045
			end
			else
			begin
select top 1 @FailureReason = isnull(FailureErrorCode, 0) FROM RMDataPathView WHERE DrivePoolId = @perferredDataPathDrvPoolForCopy
if @FailureReason <> 0
				begin
					exec RMGetDataPathUnusableReason @FailureReason, @reasonNotAvailable output
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
				end
				else
				begin
set @reasonNotAvailable = 20044
				end
			end
			if (
((@dpFailoverFlags & 8) > 0 and
				 		datediff(s, dbo.GetDateTime(@phaseFirstAttemptTime), getutcdate()) >= @waitforifoffline and
@reasonNotAvailable = 20044
				)
				or
((@dpFailoverFlags & 16) > 0 and
						datediff(s, dbo.GetDateTime(@phaseFirstAttemptTime), getutcdate()) >= @waitforifbusy and
@reasonNotAvailable = 20045)
				)
			begin
				if @isDebug > 0
				begin
set @debugDetail =  case @reasonNotAvailable when 20045
																then 'Goto Failover DataPath because all the reservable drives are busy.'
when 20044
																then 'Goto Failover DataPath because all the reservable drives are offline.'
																else 'Unknow DataPath Failover Reason.'
																	end
					insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
				end
			end
else if ( (@dpFailoverFlags & 8) > 0 or (@dpFailoverFlags & 16) > 0 )
			begin
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter',
										'Preferred DataPaths are not usable and DataPath Failover condition does not meet yet', @i_RequestId, getutcdate())
				-- if the failover condition is not met, don't return drive pool id
				set @resDrivePoolId = 0
				set @o_ErrorCode = @reasonNotAvailable
set @o_FailureType = 2
				goto exit_error
			end
			else -- if use preferred data path only
			begin
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter',
										'Preferred DataPaths are not usable', @i_RequestId, getutcdate())
				-- if the failover condition is not met, don't return drive pool id
				set @resDrivePoolId = 0
				set @o_ErrorCode = @reasonNotAvailable
set @o_FailureType = 2
				goto exit_error
			end
		end
		-- Perferred/Default datapath selected
		else
		begin
			if @resDrivePoolId > 0
			begin
				if @isDebug > 0
					insert into RMLogger values ('RMReserveWriter',
								'Drive Pool['+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) +'] selected based on Default DataPath', @i_RequestId, getutcdate())
			end
		end
	end
done_choosedp:
	-- TODO: Load Balance among different Data Paths for the same job.
	declare @maxStreamSelected int
	if (@numStreams is not null and @numStreams > 20)
		set @maxStreamSelected = @numStreams
	else
		set @maxStreamSelected = 20
	delete @RMResView
  insert into @RMResView
	-- Multiplexable Streams (including possible interriptible streams)
	select	ReservationId, CopyId, StreamId, RemainingMx, MediaGroupId,
					DrivePoolId, DriveId, VolumeId, MediaId, SpareGroupId, MountPathId, Priority, 0, FailureErrorCode, 0
	from		@RMCopyView
	where		ReservationId > 0
	and			DrivePoolId = @resDrivePoolId
	/*and			SpareGroupId = @resSpareGroupId*/
	and			(	not exists (select * from @jobOptionDriveIdList)
						or
						DriveId in (select DriveId from @jobOptionDriveIdList)
					)
	set @NumResViews = @@rowcount
	--union
  insert into @RMResView
	-- Active Streams (combination of stream and drive)
  select 	0, a.CopyId, a.StreamId, a.RemainingMx, a.MediaGroupId,
b.DrivePoolId, b.DriveId, 0, 0, b.SpareGroupId, b.MountPathId, a.Priority /*stream priority*/, b.Priority /*drive priority*/, 0, 0
	from (select top (@maxStreamSelected) * from @RMCopyView where FailureErrorCode = 0 and RemainingMx > 0 and (ReservationId = 0 or DrivePoolId = 0 )) a,
		 (select top (@maxStreamSelected) * from @RMDriveView where DrivePoolId = @resDrivePoolId and SpareGroupId = @resSpareGroupId and DataPathId = @resDataPathId order by Priority) b
	set @NumResViews = @NumResViews + @@rowcount
	-- Where using PnP library, make sure the drive and media sticking to the existing stream number for active and appendable media.
	-- This will prevent creating new dummy media for the selected drive later, which will cause call to replace media in the drive.
	-- If the expected streams are deleted, it means these streams are current using different drives by other jobs.
	-- Current backup job should go into waiting for streams until it becomes available.
	if not exists (select 1 from MMConfigs WITH (NOLOCK) WHERE Name = 'MMS2_CONFIG_ALLOW_REPLACE_PNP_MEDIA_EVEN_ACIIVE_AVAILABLE' and value > 0)
	and exists (select 1 from  @RMDriveView v left join MMDrive drive WITH (NOLOCK) ON v.DriveId = drive.DriveId
				 where v.DrivePoolId = @resDrivePoolId and v.SpareGroupId = @resSpareGroupId and v.DataPathId = @resDataPathId
and drive.DriveTypeId = 11002 and drive.mediaId != 0)
	begin
		-- Delete active stream and drive combo
		-- if the drive contains active media, and media current stream doesn't match the active stream number
		delete @RMResView
		from @RMResView res, MMDrive drive WITH (NOLOCK), MMVolume vol WITH (NOLOCK), ArchStream stream WITH (NOLOCK)
		-- Active stream only
		where	res.ReservationId = 0
		-- Drive type is PnP drive, and contain media
and	 	res.DriveId = drive.DriveId and drive.DriveTypeId = 11002 and drive.mediaId != 0 and drive.DriveOccupied = 1
		-- Volume is active or appendable
		and		drive.MediaId = vol.MediaId and vol.VolumeFlags in (1 /*VOL_ACTIVE*/, 7 /*VOL_ACTIVE_APPEND*/)
		-- Stream used by current Volume is still active. Otherwise, we still need to reserve current stream and make user to replace volume.
		-- Without this part, backup job will not be able to use the stream unless manually marking the active volume full first.
		and		res.CopyId = stream.ArchGroupCopyId and vol.MediaGroupId = stream.MediaGroupId and stream.isActive = 1
		-- Media group Id doesn't match the one on current media
		and		res.StreamId > 0 and res.MediaGroupId != vol.MediaGroupId
		set @NumResViews = @NumResViews - @@rowcount
	end
	if exists (select StreamId from @RMResView where ReservationId = 0 and VolumeId = 0)
	begin
		-- Try to find the active volume for current active stream based on the recording format
		-- This volume might not be the volume we are going to use.
		-- But there is a bigger changes that we don't need to create a new volume later.
		select	@curLibraryId = a.LibraryId
		from		MMMasterPool a with (readuncommitted), MMDrivePool b with (readuncommitted)
		where		a.MasterPoolId = b.MasterPoolId and b.DrivePoolId = @resDrivePoolId
		update	@RMResView
		set			VolumeId = isnull(b.VolumeId, 0), MediaId = isnull(b.MediaId, 0)
		from		@RMResView a, MMVolume b with (readuncommitted), MMMedia c with (readuncommitted)
		where		b.VolumeFlags = 1 /*VOL_ACTIVE*/
		and			a.MediaGroupId = b.MediaGroupId
		and			b.MediaId = c.MediaId and c.MediaId > 0
		and			c.MediaFlags = 1
		and			c.LibraryId = @curLibraryId
		and			(c.ScheduleRunId = @scheduleRunId	OR
						 @doNotAllowOtherSchedule > 0 AND c.ScheduleRunId = 0 OR
@doNotAllowOtherSchedule <= 0 AND (c.Attributes & 134217728) = 0)
	end
	if exists (select * from RMDataPathView where FailureErrorCode <> 0 and InterruptibleDrives > 0 and DataPathId = @resDataPathId)
	begin
		-- create a place holder for the interruptible drives
		insert into @RMResView
		select 	0, CopyId, StreamId, RemainingMx, MediaGroupId,
0, 0, 0, 0, 0, 0, 99999/*stream priority*/, 99999 /*drive priority*/, 0, 0
		from @RMCopyView
		where	ReservationId = 0 or DrivePoolId = 0
		set @NumResViews = @NumResViews + @@rowcount
		-- If there is still no stream available, it means all the streams are currently in used and cannot be interrupted.
		-- Therefore, even we can do interruption for drive, reservation will still fail due to the stream limitation.
		-- Need to reset the InterruptibleDrives count here to prevent the data path being picked again.
		if @NumResViews <= 0
		begin
			update RMDataPathView set InterruptibleDrives = 0 where DataPathId = @resDataPathId
		end
	end
	if @isDebug > 0
	begin
		declare @totalStreamNum int
		select @totalStreamNum = count(distinct StreamId) from @RMResView where RemainingMx > 0
		insert into RMLogger values ('RMReserveWriter', 'There are [' + cast(@totalStreamNum as varchar(20)) + '] stream available for DataPath ['
														+ cast(isnull(@resDataPathId, 0) as varchar(20)) + '], Drive Pool ['
														+ cast(isnull(@resDrivePoolId, 0) as varchar(20)) + '], Media Agent ['
														+ cast(isnull(@resClientId, 0) as varchar(20)) + '], Spare Group ['
														+ cast(isnull(@resSpareGroupId, 0) as varchar(20)) + ']', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select distinct ReservationId, CopyId, StreamId, RemainingMx, MediaGroupId, VolumeId, DriveId, MountPathId
												from @RMResView where ReservationId > 0 and FailureErrorCode = 0 and RemainingMx > 0
												for XML RAW('AvailbableMultiplexableStream'), TYPE), 'No Multiplexable stream available.') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select distinct CopyId, StreamId, RemainingMx, MediaGroupId, VolumeId ActiveVolumeId
												from @RMResView where ReservationId = 0
												for XML RAW('AvailbableActiveStream'), TYPE), 'No Active stream available.') as nvarchar(max))
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		if exists (select * from @interruptibleDataPathList where DataPathId = @resDataPathId)
		and exists (select interruptibleStreams from RMDataPathView where DataPathId = @resDataPathId and interruptibleStreams > 0)
		and (@jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
		and @IsInlineCopy = 0
		begin
			set @debugDetail = cast(isnull((select distinct ReservationId, CopyId, StreamId, RemainingMx, MediaGroupId, VolumeId, DriveId, MountPathId
													from @RMResView where ReservationId > 0 and (FailureErrorCode > 0 or RemainingMx = 0)
													for XML RAW('InterriptibleStreamCandidates'), TYPE), 'No Interriptible stream available.') as nvarchar(max))
			insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
		end
	end
  ---------------------------------
  --       End of Module         --
  ---------------------------------
  --------------------------------------------
  -- Module: create reservation for the job --
  --------------------------------------------
exit_createReservation:
  if @NumResViews = 0
  begin
  	-- No Multiplexable, Active and Interruptible streams
  	update RMDataPathView
set			FailureErrorCode = 2000,
FailureType = 1
  	where		FailureErrorCode = 0
  	and			DrivePoolId = @resDrivePoolId
	if @isDebug > 0
	begin
		set @debugDetail = 'Error return because there is no Resource Available for Drive Pool ['
  													+ cast(isnull(@resDrivePoolId, 0) as varchar(10)) + '] and DataPath ['
 														+ cast(isnull(@resDataPathId, 0) as varchar(20)) + '], Media Agent ['
														+ cast(isnull(@resClientId, 0) as varchar(20)) + '], Spare Group ['
														+ cast(isnull(@resSpareGroupId, 0) as varchar(20)) + ']'
		insert into RMLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
  	end
  	if not exists (select * from RMDataPathView where FailureErrorCode = 0)
	and (not exists ( select 1 from RMDataPathView
where FailureErrorCode in (330,
349,
20118,
296,
297,
296,
20006)
					and DataPathId not in (select DataPathId from @interruptibleDataPathList)
					and ( @BackupInterruptBackup > 0 OR @OtherInterruptAuxCopy > 0 OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
					)
		or
		not exists (select 1 from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_INTERRUPTION_BASED_ON_ERROR' and value > 0)
		)
  	begin
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter', 'Error return because no more DataPath available.', @i_RequestId, getutcdate())
set @o_ErrorCode = 2000
if exists (select * from RMDataPathView where FailureType = 2)
set @o_FailureType = 2
		else
set @o_FailureType = 1
		-- Special case for NAS client. Because it will use less data paths, don't put it in black list for NAS client backup
if @preferredMediaAgentId > 0 and @AppType in (13, 88)
set @o_FailureType = 2
		goto exit_error
	end
	else
	begin
		goto PICKING_DATAPATH
	end
  end
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMReserveWriter', 'Start reservation attempts for DataPath [' + cast(isnull(@resDataPathId, 0) as varchar(20)) + ']', @i_RequestId, getutcdate())
	end
  -- Now we have all the Multiplexable stream and active stream in table @RMResView
  -- We need to decide the order of how to pick them.
	DECLARE @isMagnetic int
	DECLARE @isLoadBalancing int
	DECLARE @useMPWithMoreFreeSpace int
	DECLARE @usePreferredMP int
	DECLARE @MaxMPFreeSpaceMB bigint
	DECLARE @FreeSpaceDiffMB bigint
SELECT @isMagnetic = CASE LibraryTypeId WHEN 3 THEN 1 ELSE 0 END,
@isLoadBalancing = CASE WHEN ExtendedAttributes & 1 > 0 THEN 1 ELSE 0 END,
@useMPWithMoreFreeSpace = CASE WHEN ExtendedAttributes & 4194304 > 0 THEN 1 ELSE 0 END,
@usePreferredMP = CASE WHEN ExtendedAttributes & 16777216 > 0 THEN 1 ELSE 0 END
	FROM		RMDataPathView
	WHERE		DataPathId = @resDataPathId
	SELECT 	@MaxMPFreeSpaceMB = MAX(MS.FreeBytesMB)
	FROM	@RMResView a
			INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = a.MountPathId
			INNER JOIN MMMediaSide MS WITH (READUNCOMMITTED) ON MS.MediaSideId = MP.MediaSideId
	WHERE	a.MountPathId > 0
SET @FreeSpaceDiffMB = ISNULL((SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_FREE_SPACE_DIFF_IN_GB_TO_CONSIDER_FOR_PREFER_MOUNT_PATH'), 1024) * 1024
SAVE TRANSACTION WRITER_RESERVATION_TRANS
  WHILE @numStreamsRemaining > 0
  BEGIN
  	set @curStreamId = 0
  	set @curReservationId = 0
		-- For inline copy only
		set @curPrimaryResId = 0
		set @curPrimaryRCID = 0
		set @curPrimaryStreamId = 0
		if @isInlineCopy > 0
		begin
			select	top 1 @curPrimaryResId = ReservationId,
							@curPrimaryRCID = RCID,
							@curPrimaryStreamId = StreamId
			from		RMReservations
			where		RequestId = @i_RequestId
			and			CopyId = @primaryCopyId
			and			RCID not in (select primaryRCID from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
													 where a.ReservationId = b.ReservationId
													 and a.CopyId = @curCopyId
													 and b.JobId_l = @JobId)
			order by StreamId
		end
	  /*
1. Select most number of drives to reserve even dataMultiplexing set to true. (This is enabled by the copy flag 268435456)
	  	2. Select Multiplexable stream first to reduce the mount request.
	  	3. Active Stream oder should already be decided when getting Stream list
	  	4. Drive/Mount order should already be decided when get avaliable drive list
	  */
 	  select top 1 @curReservationId		= a.ReservationId,
 	  				@curCopyId					= a.CopyId,
 	  				@curStreamId				= a.StreamId,
 	  				@curRemainingMx			= a.RemainingMx,
 	  				@curMediaGroupId		= a.MediaGroupId,
	  				@curDrivePoolId			= a.DrivePoolId,
	  				@curDriveId					= a.DriveId,
	  				@curVolumeId				= case when a.ReservationId > 0 then a.VolumeId else 0 end,
	  				@curMediaId					= case when a.ReservationId > 0 then a.MediaId else 0 end,
	  				@curSpareGroupId		= a.SpareGroupId,
	  				@curMountPathId			= a.MountPathId,
	  				@mountedMediaId			= b.MediaId
	  from @RMResView a, MMDrive b with (readuncommitted)
	  where a.FailureErrorCode = 0
	  and a.RemainingMx > 0
	  and a.DriveId = b.DriveId
	  and	a.DriveId > 0
		order by
		-- For inline reservation, order by the streamId as the logic for selecting primary reservation/RC id
		case when @isInlineCopy = 0 or a.StreamId = @curPrimaryStreamId then 0 else 1 end,
		-- When preferred streams, pick active stream first
		case when @isUseStreamsOverMultiplexing > 0 and a.ReservationId = 0 then 0 else 1 end,
		-- Multiplexable Write Stream first
		case when a.ReservationId > 0 then 1 - sign(a.StreamId) else 1 end,
		-- Multiplexable Read Streams over Active Streams
		1 - sign(a.ReservationId),
		-- Pick multiplexable streams that are not reserved by current job first
		case when exists (select * from MMResourceToJob with (readuncommitted) where jobId_l = @JobId and ReservationId = a.ReservationId) then 1 else 0 end,
		-- prefer less reservation first
		a.RemainingMx desc,
		--Check drive type for pnp libary, if the media is already assigned, then pick the coresponding stream firt if possible. This will prevent replace media request later during mount.
case when (b.DriveTypeId = 11002) and b.mediaId != 0
			and a.StreamId > 0 and a.MediaGroupId = (select top 1 MediaGroupId from MMVolume with (nolock) where mediaId = b.mediaId) then 0 else 1 end,
		-- stream priority. If stream data distribution enabled, the less data first
		a.StreamPriority,
		-- if existing active volume first. No new volume need to be created.
		sign(a.VolumeId) desc,
		-- for magnetic pick mount paths with more free space when prefer mount paths with more free space is selected
		case when @useMPWithMoreFreeSpace = 0 then 0 else
			(select (@MaxMPFreeSpaceMB - FreeBytesMB) / @FreeSpaceDiffMB from MMMediaSide MS WITH (READUNCOMMITTED) INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
				ON MS.MediaSideId = MP.MediaSideId where MP.MountPathId = a.MountPathId) end,
		-- for magnetic If use preferred is set then pick the preferred first
		(case when @usePreferredMP = 0 then 0 else
(select DC.DeviceAccessType & 8
				from MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED)
					INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED)	ON MPSD.DeviceId = DC.DeviceId
					INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON DC.ClientId = DP.ClientId
				where MPSD.MountPathId = a.MountPathId AND DP.DrivePoolId = a.DrivePoolId) end) desc,
		-- For magetic pick the one which has no or less reservations when load balancing is enabled.
		case when @isMagnetic = 0 or @isLoadBalancing = 0 then 0
else (select Count(*) from MMResource with (readuncommitted) where DriveId = a.DriveId and ReservationType = 2)
			end,
		-- Drive or Mount Priority if there is multiple avaliable for one stream
		a.DrivePriority
		-- rest based on existing orders of active streams
		if (@curStreamId is null or @curStreamId = 0) and (@curReservationId is null or @curReservationId = 0)
		begin
			-- the whole drive list has been go through, try from the beginning again
			delete @rmDriveId
			-- at this point only multiplexable stream left and all the streams should already be reserved by current job
	 	  select top 1 @curReservationId		= a.ReservationId,
	 	  				@curCopyId					= a.CopyId,
	 	  				@curStreamId				= a.StreamId,
	 	  				@curRemainingMx			= a.RemainingMx,
	 	  				@curMediaGroupId		= a.MediaGroupId,
		  				@curDrivePoolId			= a.DrivePoolId,
		  				@curDriveId					= a.DriveId,
		  				@curVolumeId				= a.VolumeId,
		  				@curMediaId					= a.MediaId,
		  				@curSpareGroupId		= a.SpareGroupId,
		  				@curMountPathId			= a.MountPathId,
		  				@mountedMediaId			= b.MediaId
		  from @RMResView a, MMDrive b with (readuncommitted)
		  where a.FailureErrorCode = 0
		  and a.RemainingMx > 0
		  and a.DriveId = b.DriveId
		  order by
		  a.RemainingMx desc,
		  -- if drive id is 0, it means we can do interruption for drive
		  sign (a.DriveId) desc
		  -- no more stream left, end of reservation
		  if @curStreamId is null or @curStreamId = 0
		  begin
		  	break
		  end
		end
set @o_ErrorCode = 0
		-- Reservation exists, do multiplexing
		if @curReservationId != 0
		begin
			if @curStreamId > 0
			begin
				select	@curClientId = ClientId,
								@curMasterPoolId = MasterPoolId,
								@curLibraryId = LibraryId,
								@curLibraryTypeId = LibraryTypeId,
								@curResourceFlag = 0,
								@curDriveInUseByMM = 0,
								@curReleased = 0,
								@curScheduleRunId = ScheduleRunId
				from MMResource with (readuncommitted) where IntrJobId_l = 0 and ReservationId = @curReservationId
			end
			-- Read Multiplexing Stream id = 0
			else
			begin
				select	@curClientId = ClientId,
								@curMasterPoolId = MasterPoolId,
								@curLibraryId = LibraryId,
								@curLibraryTypeId = LibraryTypeId,
								@curResourceFlag = 0,
								@curDriveInUseByMM = 0,
								@curReleased = 0,
								@curScheduleRunId = ScheduleRunId
				from MMResource with (readuncommitted) where IntrJobId_l = 0 and ReservationId = @curReservationId
				-- select the active stream id
				select	@curCopyId = s.ArchGroupCopyId,
								@curStreamId = s.Stream
				from MMVolume v WITH (READUNCOMMITTED), ArchStream s WITH (READCOMMITTED)
				where	v.VolumeId = @curVolumeId
				and		v.MediaGroupId = s.MediaGroupId
				and		v.VolumeFlags = 1 /*VOL_ACTIVE*/
				-- Check if current drive pool and media agent have write access to the volume
				if @curMountPathId > 0
				begin
					IF EXISTS (SELECT 1 FROM MMMountPath WITH (readuncommitted) WHERE MountPathId = @curMountPathId AND MaxConcurrentWriters = 0)
					BEGIN
set @o_ErrorCode = 42024
set @o_FailureType = 2
						delete @RMResView where MountPathId = @curMountPathId
						continue
					END
					SET @o_ErrorCode = dbo.MMS2FUNC_IsMountPathHasSpaceRequired(@curMountPathId, @curMediaId)
					IF  @o_ErrorCode <> 0
					BEGIN
set @o_FailureType = 2
						delete @RMResView where MountPathId = @curMountPathId
						continue
					END
					IF EXISTS (SELECT 1 FROM MMMountPathToStorageDevice ms WITH (READUNCOMMITTED), MMDeviceController dc WITH (READUNCOMMITTED)
								WHERE		@curMountPathId = ms.MountPathId
								AND			ms.DeviceId = dc.DeviceId
								AND			dc.ClientId = @curClientId
AND			(dc.DeviceAccessType & 2) = 0
							)
					BEGIN
set @o_ErrorCode = 463
set @o_FailureType = 2
						delete @RMResView where ReservationId = @curReservationId and StreamId = 0
						continue
					END
					IF EXISTS (SELECT 1 FROM MMMedia WITH (READUNCOMMITTED)
								WHERE		@curMediaId = MediaId
								AND			MediaFlags = 4
							)
					BEGIN
set @o_ErrorCode = 458
set @o_FailureType = 2
						delete @RMResView where MountPathId = @curMountPathId
						continue
					END
				end
				-- copy id and stream id from volume don't match current resource view, delete it from current view
				if @curCopyId != @copyId or not exists (select * from @RMResView where CopyId = @copyId and StreamId = @curStreamId )
				begin
					delete @RMResView where ReservationId = @curReservationId and StreamId = 0
					-- set error cod here
					continue
				end
				-- Remove the stream from active stream list and update the one with streamID 0
				else
				begin
					delete @RMResView where ReservationId = 0 and StreamId = @curStreamId
					update @RMResView
					set		CopyId = @copyId, StreamId = @curStreamId
					where ReservationId = @curReservationId and StreamId = 0
				end
			end
			-- Update the drive pool and data path info for current media group
			if exists (select 1 from MMMediaGroup  with (readuncommitted) where MediaGroupId = @curMediaGroupId
				and (	DrivePoolId != @curDrivePoolId or
							SpareGroupId != @curSpareGroupId or
							DataPathId = 0 or DataPathId != @resDataPathId) )
			begin
				update MMMediaGroup
				set	DrivePoolId = @curDrivePoolId,
					SpareGroupId = @curSpareGroupId,
					DataPathId = @resDataPathId,
					DesiredMediaTypeId = (select MediaTypeId from MMMedia with (readuncommitted) where MediaId = @curMediaId),
					RecordingFormatId = (select RecordingFormatId from MMVolume with (readuncommitted) where VolumeId = @curVolumeId)
				where MediaGroupId = @curMediaGroupId
			end
			-- update resource table for the new multiplexing stream
			update MMResource
			set CopyId = @curCopyId,
					StreamId = @curStreamId,
					MediaGroupId = @curMediaGroupId,
ReservationType = 2,
					preEmptable = (case when @preEmptable = 0 then @preEmptable else preEmptable end),
					Priority = (case when Priority > @priority then @priority else Priority end)
			where ReservationId = @curReservationId
			-- mx
			select @curRCID = next_l + 1 from GXCounter where name = 'RCID_Counter'
			update GXCounter set next_l = @curRCID where name = 'RCID_Counter'
			select top 1 @curReserveBitMask = ReserveBitMask from MMResourceToJob with (readuncommitted) where ReservationId = @curReservationId
if (@curReserveBitMask & 2) > 0
set @curReserveBitMask = 1 | 2
			else
set @curReserveBitMask = 1
			-- Check if extra streams are reserved by reservation for backup caching.
			IF @backupCachingEnhance > 0 AND @backupCachingExtraStreamNumber > @numStreams
			AND (SELECT COUNT(DISTINCT RCID)FROM @rmRCId) >= @numStreams
			BEGIN
				insert into MMResourceToJob
				(ReservationId, JobId_h, JobId_l, Priority, PreEmptable,
					InUse, ReserveBitMask, ReleaseTime,
					ReservationType, RCID, PrimaryRCID, ClientTokenId,
					DestMediaGroupId, LogicalReleased, Flag, AppClientId)
				values
				(@curReservationId, 0, 1/*jobid*/, @priority, @preEmptable,
(case when @HasJobInterrupted > 0 then 1 else 0 end), 1, dbo.GetUnixTime(getutcdate())/*ReleaseTime*/,
2, @curRCID, @curPrimaryRCID, @clientTokenId,
					@sourceMediaGroupId, 0, 0, @appClientId)
			END
			ELSE
			BEGIN
				insert into MMResourceToJob
				(ReservationId, JobId_h, JobId_l, Priority, PreEmptable,
					InUse, ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID,
					ClientTokenId,DestMediaGroupId, LogicalReleased, Flag, AppClientId)
				values
				(@curReservationId, 0, @jobId, @priority, @preEmptable,
(case when @HasJobInterrupted > 0 then 1 else 0 end), @curReserveBitMask, 0, 2, @curRCID, @curPrimaryRCID,
					@clientTokenId,	@sourceMediaGroupId, 0, 0, @appClientId)
			END
			set @numStreamsRemaining = @numStreamsRemaining - 1
			set @curRemainingMx = @curRemainingMx - 1
			insert into @rmDriveId
			select @curDriveId, @curCopyId, @curStreamId
			insert into @rmRCId
			select @curRCID, @curReservationId
			update @RMResView
			set		RemainingMx = RemainingMx -1
			where CopyId = @curCopyId and StreamId = @curStreamId
			set @debugDetail = cast(isnull((select @curReservationId ReservationID, @curRCID newRCID, @curCopyId CopyId, @curStreamId StreamId,
																@curDrivePoolId DrivePoolId, @curDriveId DriveId, @curMediaGroupId MediaGroupId,
																@curVolumeId VolumeId, @curMediaId MediaId, @curMountPathId MountPathId
												for XML RAW('MultiplexingStream'), TYPE), 'No Multiplexing Streams') as nvarchar(max))
			insert into @tempLogger values ('Resource   Reserved', @debugDetail, @i_RequestId, getutcdate())
			if @numStreamsRemaining = 0
				break
			-- Check if current data path can still be used
			update RMDataPathView set RemainingMx = RemainingMx - 1
			where	 DataPathId = @resDataPathId
exec RMDataPathAdditionalFilter @i_RequestId, 2, @JobId,
		  												@numStreamsRemaining, @isBestcaseReserve /*@bestcaseReserve*/, @dataMultiStream, @MuxFactor, @extraRestoreDrive, @extraRestoreDrivePoolId,
		  												@copyId, @SIDBStoreId, @appNum, @isTransactionLogBackupPhase,
		  												@isDebug, @o_ErrorCode output, @o_FailureType output
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			if exists (select * from RMDataPathView where FailureErrorCode = 0 and DataPathId = @resDataPathId)
			begin
				continue
			end
			else
			begin
				break
			end
		end
		-- No multiplexing stream available
		if @curReservationId = 0
		begin
			set @curVolumeId = 0
			EXEC RMMigrateMGAndGetActiveVolume @i_RequestId, @jobId, @copyId,
																					@curMediaGroupID, @resDrivePoolId, @resSpareGroupId, @resDataPathId,
																					@schedulerunid, @doNotAllowOtherSchedule, @markActiveMediaFull, @SIDBStoreId, @IsForSILOBackup, @jobType, @appNum, @currentSIDBStoreId, @isTransactionLogBackupPhase,
																					@isDebug,
																					@curMediaId output, @curVolumeId output, @o_ErrorCode output, @o_FailureType output
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			-- failure returned, there is no need to continue
if @o_ErrorCode != 0
			begin
				delete @RMResView where MediaGroupId = @curMediaGroupID and DrivePoolId = @curDrivePoolId and SpareGroupId = @curSpareGroupId
			  continue
			end
			-- Not active volume for current media group
			if @curVolumeId = 0
			begin
				-- allocate new media
				if @isMagnetic > 0
				begin
					if @curMountPathId = 0
					begin
						-- If there is no mount path picked already, it must be interruption for mount path. Go to interrupt drive directly since we don't know which mount path to pick yet.
						set @curVolumeId = 0
						set @curMediaId = 0
						goto INTERRUPT_DRIVE
					end
					--delete @rmJustId
					--insert into @rmJustId
					select TOP 1 @curClientId = HostClientId FROM RMDataPathView WHERE DrivePoolId = @resDrivePoolId
					exec @o_ErrorCode = MMS2GetMagVolumeForJob @commCellId, @curMountPathId, @curMediaGroupID, @SIDBStoreid, 0 /*AppId*/, @jobId, @jobOpType, @UsePartialFullMedia,
											@markActiveMediaFull, @curClientId, 1 /*IgnoreOutput*/, @curVolumeId OUTPUT
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
if @o_ErrorCode = 0
					begin
						--select top 1 @curVolumeId = isnull(id, 0) from @rmJustId
						select top 1 @curMediaId = isnull(MediaId, 0) from MMVolume with (readuncommitted) where VolumeId = @curVolumeId
					end
					else
					begin
						set @curVolumeId = 0
						set @curMediaId = 0
					end
					if @isDebug > 0
					begin
						set @debugDetail = cast(isnull((select  @curVolumeId NewVolumeId, @curMediaId NewMediaId,
																						@commCellId CommcellId, @curMountPathId MountPathId,
																						@curMediaGroupID MediaGroupId, @SIDBStoreId SIDBStoreId, @jobId JobId, @jobType JobType,
																						@UsePartialFullMedia UsePartialFullMedia, @markActiveMediaFull MarkActiveMediaFull
															for XML RAW('MMS2GetMagVolumeForJob'), TYPE), 'No params for MMS2GetMagVolumeForJob') as nvarchar(max))
						insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
					end
				end
				else
				begin
					-- find tape, optical
					--delete @rmMediaAllo
					--insert into @rmMediaAllo
					exec @o_ErrorCode = MMS2GetVolumeForJob @commCellId, @curMediaGroupID, @jobId, @jobOpType, @UsePartialFullMedia, @scheduleRunId, @doNotAllowOtherSchedule, 1 /*IgnoreOutput*/, @curVolumeId OUTPUT
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
if @o_ErrorCode = 0
					begin
						--select top 1 @curVolumeId = isnull(VolumeIDForJob, 0) from @rmMediaAllo
						select top 1 @curMediaId = isnull(MediaId, 0) from MMVolume with (readuncommitted) where VolumeId = @curVolumeId
					end
					else
					begin
						set @curVolumeId = 0
						set @curMediaId = 0
					end
					if @isDebug > 0
					begin
						set @debugDetail = cast(isnull((select  @curVolumeId NewVolumeId, @curMediaId NewMediaId,
																						@commCellId CommcellId, @curMediaGroupID MediaGroupId, @jobId JobId, @jobType JobType,
																						@UsePartialFullMedia UsePartialFullMedia, @scheduleRunId ScheduleRunId, @doNotAllowOtherSchedule DoNotAllowOtherSchedule
															for XML RAW('MMS2GetVolumeForJob'), TYPE), 'No params for MMS2GetVolumeForJob') as nvarchar(max))
						insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
					end
					-- Check Media Type License
					/* DVD media type */
					if @curMediaId > 0
					and exists (select * from MMMedia with (readuncommitted) where MediaId = @curMediaId
and MediaTypeId in (20020,
20021,
20025,
20026,
20027,
20028))
					begin
						set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, 2, -1, 1036, 'install', 0, 0
						IF @@ERROR > 0
						BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
						  GOTO exit_error
						END
						if @hasLicense = 0
						begin
set @o_ErrorCode = 510
						  set @curVolumeId = 0
						  set @curMediaId = 0
						end
					end
					/* UDO media type */
					if @curMediaId > 0
					and exists (select * from MMMedia with (readuncommitted) where MediaId = @curMediaId
and MediaTypeId in (20040,
20041))
					begin
						set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, 2, -1, 1037, 'install', 0, 0
						IF @@ERROR > 0
						BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
						  GOTO exit_error
						END
						if @hasLicense = 0
						begin
set @o_ErrorCode = 511
						  set @curVolumeId = 0
						  set @curMediaId = 0
						end
					end
					/* WORM media type */
					if @curMediaId > 0
					and exists (select * from MMMedia with (readuncommitted) where MediaId = @curMediaId
and (MediaTypeId in (24,
20006,
20007,
20008,
20009,
20010,
322,
104,
144,
203,
122,
222)
														or exists (select * from MMMediaType with (readuncommitted) where MediaTypeId = MMMedia.MediaTypeId and IsWormMedia = 1)))
					begin
						set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, 2, 90, 1025, 'install', 0, 0
						IF @@ERROR > 0
						BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
						  GOTO exit_error
						END
						if @hasLicense = 0
						begin
set @o_ErrorCode = 513
						  set @curVolumeId = 0
						  set @curMediaId = 0
						end
					end
				end
			end
			-- Check if MountPath has space.
			if @curMountPathId > 0 and @curMediaId > 0
			begin
				set @o_ErrorCode = dbo.MMS2FUNC_IsMountPathHasSpaceRequired(@curMountPathId, @curMediaId)
				if  @o_ErrorCode <> 0
				begin
set @o_FailureType = 2
					set @curVolumeId = 0
					set @curMediaId = 0
				end
			end
			if @curVolumeId = 0
			begin
				-- there is no media in current media group, delete it from @RMResView.
				-- If there is magnetic library, just delete by mount path id because there may be other mount path in the same library can be used.
				-- Otherwise delete by media group because there is no tape under the media group but the drive still usable by other media group.
				if @isMagnetic > 0 and @curMountPathId > 0
				begin
					delete @RMResView where MountPathId = @curMountPathId
				end
				else
				begin
					delete @RMResView where MediaGroupId = @curMediaGroupId
				end
				if @isDebug > 0
				begin
					declare @curLibraryName nvarchar(256)
					select @curLibraryName = isnull(b.AliasName, 'NULL')
					from MMSpareGroup a with (readuncommitted), MMLibrary b with (readuncommitted)
					where a.SpareGroupId = @curSpareGroupId and a.LibraryId = b.LibraryId and b.LibraryId > 0
						insert into @tempLogger values ('RMReserveWriter',
											'Error returns no media to use in Library['+ isnull(@curLibraryName, '')
											+ '] SpareGroup['+ cast(isnull(@curSpareGroupId, 0) as varchar(20))
											+ '] MediaGroup['+ cast(isnull(@curMediaGroupID, 0) as varchar(20))
											+ ']. Skip stream [' + cast(isnull(@curStreamId, 0) as varchar(20)) + '].',
											@i_RequestId, getutcdate())
				end
if @o_ErrorCode = 0
set @o_ErrorCode = 280
				-- no media to use
				continue
			end
			else
			begin
				if @isMagnetic > 0 and @curMountPathId > 0
				begin
					-- Make sure the drive id and mount path id is correct one for the volume
					select	@curMountPathId = b.MountPathId
					from		MMMediaSide a with (readuncommitted), MMMountPath b with (readuncommitted)
					where		a.MediaId = @curMediaId
					and			a.MediaSideId = b.MediaSideId
					select	@curDriveId = DriveId
					from		MMDrive with (readuncommitted)
					where		MediaId = @curMediaId
				end
				if @curMediaId > 0
				and (
exists (select 1 from MMMedia with (NOLOCK) where MediaId = @curMediaId and MediaTypeId IN (11002))
						or
exists (select 1 from RMDataPathView where DataPathId = @resDataPathId and LibraryTypeId in (4, 5))
					)
				begin
					-- If the selected media in PnP library is in the drive, then use the drive
					if exists (select 1 from MMDrive with (readuncommitted) where MediaId = @curMediaId)
					begin
						select	@curDriveId = DriveId
						from		MMDrive with (readuncommitted)
						where		MediaId = @curMediaId
					end
					-- Otherwise, the media must be a dummy media, which is not in the drive. Select a drive without reservation that also has unidentified media first.
					else
					begin
						select @curDriveId = a.DriveId
						from @RMResView a, MMDrive b with (readuncommitted)
						where a.FailureErrorCode = 0
						and a.RemainingMx > 0
						and a.DriveId = b.DriveId
						and a.ReservationId = 0
						and b.MediaId = 0
						and b.DriveOccupied = 1
						-- if there is no such drive exists, then the drive Id will not changed by above logic. Just use whatever drive Id exists.
					end
				end
				-- there is a volume but can it be reserved?
				declare @isReservable int
				set @isReservable = 0
				exec RMIsVolumeReservable @i_RequestId, @JobId, @curVolumeId, @curMediaGroupId,
																	@curDrivePoolId, @curMasterPoolId, @curClientId, @curLibraryId,
2, 1, @isDebug,
																	@isReservable output, @o_ErrorCode output
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO exit_error
				END
if @isReservable = 0 and @o_ErrorCode != 803
				begin
IF NOT EXISTS (SELECT 1 FROM MMMedia WITH (READCOMMITTED) WHERE MediaId = @curMediaId AND MediaTypeId = 10001)
					BEGIN
						IF NOT EXISTS(SELECT 1 FROM @RMResrvFailedMediaList WHERE DataPathId = @resDataPathId)
						BEGIN
							INSERT INTO @RMResrvFailedMediaList
							SELECT @resDataPathId, (SELECT BarCode FROM MMMedia WITH (READCOMMITTED) WHERE MediaId = @curMediaId)
						END
						ELSE
						BEGIN
							UPDATE @RMResrvFailedMediaList
							SET MediaBarcode = (SELECT BarCode FROM MMMedia WITH (READCOMMITTED) WHERE MediaId = @curMediaId)
							WHERE DataPathId = @resDataPathId
						END
					END
					delete @RMResView where MediaGroupId = @curMediaGroupId
					if @isDebug > 0
					begin
							insert into @tempLogger values ('RMReserveWriter',
												'Current active volume ['+ cast(isnull(@curVolumeId, 0) as varchar(20))
												+ '] cannot be reservable because of error ['+ cast(isnull(@o_ErrorCode, 0) as varchar(20))
												+ ']. Skip stream [' + cast(isnull(@curStreamId, 0) as varchar(20)) + '].',
												@i_RequestId, getutcdate())
						end
					continue
				end
				-- Media is reserved
else if @isReservable = 0 and @o_ErrorCode = 803
				begin
					select @existingResCount = count( distinct RCID) from @rmRCId
					select @remainingResCount = count ( RemainingMx ) from ( select distinct StreamId, RemainingMx from @RMResView where DriveId > 0 and StreamId <> @curStreamId ) a group by StreamId
					-- If there are other data paths available or interruptible streams availabe, don't interrupt media
					if exists ( select DataPathId from RMDataPathView where FailureErrorCode = 0 and DataPathId != @resDataPathId )
					or exists ( select DataPathId from RMDataPathView
											where interruptibleStreams > 0
											and		(RemainingMx + interruptibleStreams * @MuxFactor) >= @numStreamsMin
											and		DataPathId not in (select DataPathId from @interruptibleDataPathList)
										)
					-- if bestcasereserve is true and already reserve other stream, don't interrupt media
					or ( @bestcaseReserve > 0 and ( @existingResCount > 0 or @remainingResCount > 0 ) )
					-- if bestcasereserve is false and other reservations including active and multipex streams still satify the requirement, dont' interrupt media
					or ( @bestcaseReserve = 0 and ( @existingResCount + @remainingResCount) >= @numStreamsMin )
					begin
						delete @RMResView where MediaGroupId = @curMediaGroupId
						if @isDebug > 0
						begin
							insert into @tempLogger values ('RMReserveWriter',
												'Current active volume ['+ cast(@curVolumeId as varchar(20)) + '] has been reserved by others and there are other streams available. Skip stream ['
												+ cast(@curStreamId as varchar(20)) + '].',
												@i_RequestId, getutcdate())
						end
						continue
					end
					set @numInterrupted = 0
exec @numInterrupted = RMHandleInterrupt @i_RequestId, @jobId, @priority, 4, 1, @ReservationType,
																										@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, 0, 0, 0, @curMediaId, @curVolumeId, 0, 0, 0,
																										0,
																										@isDebug, @o_ErrorCode output
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
					if @numInterrupted > 0
					begin
						-- Media is interrupted.
						-- If current drive mounting the interrupted media belongs to the selected drive pool, then we don't need to check the drive anymore.
						-- Otherwise, we still need to find a drive for the media.
						if @isMagnetic > 0 and @curMountPathId > 0 and @curDriveId = 0
						begin
							select	@curDriveId = DriveId
							from		MMDrive with (readuncommitted)
							where		MediaId = @curMediaId
						end
						else if (@isMagnetic = 0 or @curMountPathId = 0) and @curDriveId = 0
						begin
							select	@curDriveId = DriveId,
											@curDrivePoolId = @resDrivePoolId,
											@curSpareGroupId = @resSpareGroupId,
											@curMountPathId = 0
							from		MMResource with (readuncommitted)
							where		IntrJobId_l = @jobId
							and			MediaId = @curMediaId
							-- The drive mounting current media cannot be used by the selected drive pool. Check drive availability later.
							if not exists (select DriveControllerId from MMDriveController with (readuncommitted) where DriveId = @curDriveId and DrivePoolId = @curDrivePoolId)
							begin
								set @curDriveId = 0
							end
						end
						set @HasJobInterrupted = 1
						if @isDebug > 0
						begin
							set @debugDetail = cast(isnull((
																select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.VolumeId, a.MediaId, a.DriveId, a.LibraryId
																from MMResource a with (readuncommitted)	where IntrJobId_l = @jobId
																for XML RAW('InterruptedMedia'), TYPE), 'No Interrupted Media') as nvarchar(max))
							insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
						end
set @o_ErrorCode = 0
					end
					-- Cannot interrupt media
					else
					begin
						if @isMagnetic > 0 and @curDriveId > 0
							delete @RMResView where DriveId = @curDriveId
						delete @RMResView where MediaGroupId = @curMediaGroupId
						if @isDebug > 0
						begin
							insert into @tempLogger values ('RMReserveWriter',
												'Current active volume ['+ cast(@curVolumeId as varchar(20)) + '] has been reserved by others and cannot be interrupted. Skip stream ['
												+ cast(@curStreamId as varchar(20)) + '].',
												@i_RequestId, getutcdate())
						end
						--set @o_ErrorCode = E_MM_RESERVE_MEDIA_ALREADY_RESERVED
						continue
					end
				end
			end
INTERRUPT_DRIVE:
			-- There is no available drives, try interrupt drives
			if @curDriveId = 0
			begin
				if exists (select * from @interruptibleDataPathList where DataPathId = @resDataPathId)
				and exists (select DataPathId from RMDataPathView where DataPathId = @resDataPathId and interruptibleDrives > 0)
				and (@jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
				and @IsInlineCopy = 0
				begin
					select @existingResCount = count( distinct RCID) from @rmRCId
					select @remainingResCount = sum ( RemainingMx ) from ( select distinct StreamId, RemainingMx from @RMResView where FailureErrorCode = 0 and DriveId > 0 and StreamId <> @curStreamId) a group by StreamId
					-- If there are other data paths available availabe, don't interrupt drive
					if exists ( select DataPathId from RMDataPathView where FailureErrorCode = 0 )
					-- if bestcasereserve is true and already reserve other stream, don't interrupt drive
					or ( @bestcaseReserve > 0 and ( @existingResCount > 0 or @remainingResCount > 0 ) )
					-- if bestcasereserve is false and other reservations including active and multipex streams still satify the requirement, dont' interrupt drive
					or ( @bestcaseReserve = 0 and ( @existingResCount + @remainingResCount) >= @numStreamsMin )
					begin
set @o_ErrorCode = 279
				  	if @isDebug > 0
				  	begin
							insert into @tempLogger values ('RMReserveWriter',
												'There are other datapaths avaialbe or no need for interrupting drives or mount paths. Skip drive interruption for current data path  ['
												+ cast(@resDataPathId as varchar(20)) + '].',
												@i_RequestId, getutcdate())
						end
						-- There is no need for interrupting stream anymore, if we cannot interrupt drives
						update RMDataPathView set interruptibleStreams = 0 where DataPathId = @resDataPathId and interruptibleStreams > 0
						break
					end
					set @numInterrupted = 0
exec @numInterrupted = RMHandleInterrupt @i_RequestId, @jobId, @priority, 2, 1, @ReservationType,
																										@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, 0, 0, 0, 0, 0, 0, @resDrivePoolId, 0,
																										0,
																										@isDebug, @o_ErrorCode output
					IF @@ERROR > 0
					BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO exit_error
					END
					if @numInterrupted > 0
					begin
						update RMDataPathView set InterruptibleDrives = InterruptibleDrives - 1 where DataPathId = @resDataPathId
						-- There is no more interruptible drive left, remove the resource place holder for interruption.
						if exists (select DataPathId from RMDataPathView where DataPathId = @resDataPathId and InterruptibleDrives = 0)
						begin
							delete @RMResView where DriveId = 0
						end
						select	@curDriveId = DriveId,
										@curDrivePoolId = @resDrivePoolId,
										@curSpareGroupId = @resSpareGroupId,
										@curMountPathId = MountPathId,
										@curVolumeId = case when @curVolumeId > 0 then @curVolumeId else 0 end,
										@curMediaId = case when @curMediaId > 0 then @curMediaId else MediaId end
						from		MMResource with (readuncommitted)
						where		IntrJobId_l = @jobId
						and			DriveId not in (select distinct a.DriveId from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
																		where a.ReservationId = b.ReservationId and b.JobId_l = @jobId)
						update @RMResView
						set		DriveId = @curDriveId,
								DrivePoolId = @curDrivePoolId,
								MountPathId = @curMountPathId
						where	CopyId = @curCopyId and StreamId = @curStreamId
						and		DriveId = 0
						set @HasJobInterrupted = 1
set @o_ErrorCode = 0
						if @isDebug > 0
						begin
							set @debugDetail = cast(isnull((
																select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.VolumeId, a.MediaId, a.DriveId, a.LibraryId
																from MMResource a with (readuncommitted)	where IntrJobId_l = @jobId and DriveId = @curDriveId
																for XML RAW('InterruptedDrive'), TYPE), 'No Interrupted Drive') as nvarchar(max))
							insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
						end
					end
					-- Cannot interrupt drive
					else
					begin
				  	if @isDebug > 0
				  	begin
							insert into @tempLogger values ('RMReserveWriter',
												'There is no non-reserved drive or interruptible drive available. Skip current data path  ['
												+ cast(@resDataPathId as varchar(20)) + '].',
												@i_RequestId, getutcdate())
						end
						-- There is no need for interrupting stream anymore, if we cannot interrupt drives
						update RMDataPathView set interruptibleStreams = 0 where DataPathId = @resDataPathId and interruptibleStreams > 0
set @o_ErrorCode = 279
		  			break
					end
				end
			end -- end of interrupt drive
INTERRUPT_BY_ERROR:
		  -- cliu 10/22/2018,
		  -- If at this point, the data path is actually offline, but reservation still can be created, it means this is a corner case
		  -- that data path is offline due to reasons not related to stream, drive, media,  and media agent.
		  -- In such cases, we can try interruption based on the failure reasons.
		  -- This logic should be run only once even when there are multiple stream required
		  if @HasJobInterrupted = 0 and @curVolumeId > 0 and @curDriveId > 0 and @curStreamId > 0
		  and exists (select * from @interruptibleDataPathList where DataPathId = @resDataPathId)
		  and (@jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
		  and @IsInlineCopy = 0
and @resCurrentFailureErrorCode in (330,
349,
20118,
296,
297,
296,
20006)
		  and exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_INTERRUPTION_BASED_ON_ERROR' and value > 0)
		  begin
			select @existingResCount = count( distinct RCID) from @rmRCId
			select @remainingResCount = sum ( RemainingMx ) from ( select distinct StreamId, RemainingMx from @RMResView where FailureErrorCode = 0 and DriveId > 0 and StreamId <> @curStreamId) a group by StreamId
			-- If there are other data paths available availabe, don't interrupt drive
			if exists ( select DataPathId from RMDataPathView where FailureErrorCode = 0 )
			-- if bestcasereserve is true and already reserve other stream, don't interrupt drive
			or ( @bestcaseReserve > 0 and ( @existingResCount > 0 or @remainingResCount > 0 ) )
			-- if bestcasereserve is false and other reservations including active and multipex streams still satify the requirement, dont' interrupt drive
			or ( @bestcaseReserve = 0 and ( @existingResCount + @remainingResCount) >= @numStreamsMin )
			begin
set @o_ErrorCode = 20013
				if @isDebug > 0
				begin
						insert into @tempLogger values ('RMReserveWriter',
											'There are other datapaths avaialbe or no need for interrupting media agent and drive pool. Skip interruption for current data path  ['
											+ cast(@resDataPathId as varchar(20)) + '].',
											@i_RequestId, getutcdate())
				end
				-- There is no need for interrupting stream anymore, if we cannot interrupt drives
				update RMDataPathView set interruptibleStreams = 0, interruptibleDrives= 0 where DataPathId = @resDataPathId
				break
			end
			set @numInterrupted = 0
exec @numInterrupted = RMHandleInterrupt @i_RequestId, @jobId, @priority, 32, @numStreamsMin, @ReservationType,
													@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, @copyId, 0, @MuxFactor, 0, 0, 0, @resDrivePoolId, 0,
													@resCurrentFailureErrorCode,
													@isDebug, @o_ErrorCode output
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			if @numInterrupted > 0
			begin
				set @HasJobInterrupted = 1
set @o_ErrorCode = 0
				if @isDebug > 0
				begin
					set @debugDetail = cast(isnull((
														select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.VolumeId, a.MediaId, a.DriveId, a.LibraryId
														from MMResource a with (readuncommitted)	where IntrJobId_l = @jobId
														for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resource') as nvarchar(max))
					insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
				end
			end
			-- Cannot interrupt drive
			else
			begin
				if @isDebug > 0
				begin
					insert into @tempLogger values ('RMReserveWriter',
										'There is interruption available based on current error code [' + cast(@resCurrentFailureErrorCode as varchar(20)) +
										']. Skip current data path  [' + cast(@resDataPathId as varchar(20)) + '].',
										@i_RequestId, getutcdate())
				end
				-- There is no need for interrupting stream anymore, if we cannot interrupt
				update RMDataPathView set interruptibleStreams = 0, interruptibleDrives= 0 where DataPathId = @resDataPathId
set @o_ErrorCode = 20013
				break
			end
		  end
		  -- find other data for resource table
		  select top 1
						@newClientId			= HostClientId,
						@newMasterPoolId	= MasterPoolId,
						@newLibraryId			= LibraryId,
						@newLibraryTypeId	= LibraryTypeId,
@newResourceFlag	= case when @markMediaFullOnSuccess > 0 then 1 else 0 end
		  from	RMDataPathView
		  where DrivePoolId = @resDrivePoolId
		  and		DataPathId = @resDataPathId
		  and		SpareGroupId = @resSpareGroupId
		-- Set SIDBStoreId for data backups
		DECLARE @SIDBStoreIdForDataBackup INT
			SET @SIDBStoreIdForDataBackup = @SIDBStoreId
		IF @isTransactionLogBackupPhase > 0
		OR
		 -- If dedupe is disabled on subclient, we allow regular backup run to this particular subclient.
		(@appNum > 0 AND @JobType NOT IN (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
		AND (
				EXISTS ( select prop.Id from APP_SubClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
								where app.Id = @appNum and app.Id = prop.ComponentNameId and prop.cs_attrName = CheckSum(N'Single Instancing Option')
								and prop.attrName = N'Single Instancing Option' and prop.attrVal = '0' and prop.Modified = 0
						)
			)
		)
		OR
		-- If dedupe is disabled on copy, we allow regular bakcup run to this copy for all the subclients.
(@dedupeFlags & 1048576) > 0
		BEGIN
			SET @SIDBStoreIdForDataBackup = 0
		END
		-- Make sure the volume is set as active to allow multiplexing
		update MMVolume set VolumeFlags = 1 WHERE VolumeId = @curVolumeId
		-- create new reservation
	     insert into MMResource (CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
			MasterPoolId, MediaGroupId, IntrJobId_h, IntrJobId_l, HasJobInterrupted, ReservationType,
			ReservationTime, Priority, PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
			DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId,
			NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId)
		  values(@curCopyId, @curStreamId, @curVolumeId, @curMediaId, @curDriveId, @newClientId, @curDrivePoolId,
			@newMasterPoolId, @curMediaGroupId, 0, 0, @HasJobInterrupted, @ReservationType,
			dbo.GetUnixTime(getutcdate()), @priority, @preEmptable, 0, 0, @newResourceFlag, @curPrimaryResId, 0, 0,
			0, @newLibraryId, @newLibraryTypeId, @curSpareGroupId, @curMountPathId, 0, @scheduleRunId,
			@doNotAllowOtherSchedule, 0, 0, @SIDBStoreIdForDataBackup)
		  set @curReservationId = @@identity
	  	select @curRCID = next_l + 1 from GXCounter where name = 'RCID_Counter'
			if @curRCID is NuLL
			begin
				insert into GXCounter select 'RCID_Counter', 0, 1
				set @curRCID = 1
			end
		  update GXCounter set next_l = @curRCID where name = 'RCID_Counter'
		-- Check if extra streams are reserved by reservation for backup caching.
		IF @backupCachingEnhance > 0 AND @backupCachingExtraStreamNumber > @numStreams
		AND (SELECT COUNT(DISTINCT RCID)FROM @rmRCId) >= @numStreams
		BEGIN
			insert into MMResourceToJob
			(ReservationId, JobId_h, JobId_l, Priority, PreEmptable,
				InUse, ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
				DestMediaGroupId, LogicalReleased, Flag, AppClientId)
			values
			(@curReservationId, 0, 1/*jobid*/, @priority, @preEmptable,
0, 1, dbo.GetUnixTime(getutcdate())/*ReleaseTime*/, 2, @curRCID, @curPrimaryRCID, @clientTokenId,
				@sourceMediaGroupId, 0, 0, @appClientId)
		END
		ELSE
		BEGIN
		  insert into MMResourceToJob (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
				ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
				DestMediaGroupId, LogicalReleased, Flag, AppClientId)
		  values(@curReservationId, 0, @jobId, @priority, @preEmptable, (case when @HasJobInterrupted > 0 then 1 else 0 end),
1, 0, 2, @curRCID, @curPrimaryRCID, @clientTokenId,
				@sourceMediaGroupId, 0, 0, @appClientId)
		END
		  set @numStreamsRemaining = @numStreamsRemaining - 1
		  set @curRemainingMx = @curRemainingMx - 1
			insert into @rmDriveId
			select @curDriveId, @curCopyId, @curStreamId
			insert into @rmRCId
			select @curRCID, @curReservationId
			update @RMResView
			set		ReservationId = @curReservationId,
						VolumeId = @curVolumeId,
						MediaId = @curMediaId,
						RemainingMx = RemainingMx -1
			where CopyId = @curCopyId and StreamId = @curStreamId
			and		DriveId = @curDriveId and DrivePoolId = @curDrivePoolId
			and		(@curMountPathId = 0 or MountPathId = @curMountPathId)
			-- remove all others, including all other streams that use the same drive, and all other drives that use the same stream
			delete @RMResView
			where ReservationId = 0
						-- all other drive resources for the same stream
			and		( (CopyId = @curCopyId and StreamId = @curStreamId)
							or
						-- all other streams for the same drive (non-magnetic only)
							(CopyId = @curCopyId and StreamId != @curStreamId and @curMountPathId = 0 and DriveId = @curDriveId and DrivePoolId = @curDrivePoolId))
			set @debugDetail = cast(isnull((select @curReservationId ReservationID, @curRCID newRCID, @curCopyId CopyId, @curStreamId StreamId,
																@curDrivePoolId DrivePoolId, @curDriveId DriveId, @curMediaGroupId MediaGroupId,
																@curVolumeId VolumeId, @curMediaId MediaId, @curMountPathId MountPathId
												for XML RAW('ActiveStream'), TYPE), 'No Reservation For Active Stream') as nvarchar(max))
			insert into @tempLogger values ('Resource   Reserved', @debugDetail, @i_RequestId, getutcdate())
			if @numStreamsRemaining = 0
				break
			-- Check if current data path can still be used
			if @curMountPathId > 0
			begin
				update	RMDataPathView
				set			RemainingMx = RemainingMx + @curRemainingMx
				where		DataPathId = @resDataPathId
				-- If there is no reservation on the mount path, check if the mount path can still be used after this due to the max write on mount path.
				-- Otherwise, we need to switch a different mount path
				set @mountPathReservationsNum = 0
				select @mountPathReservationsNum = count(distinct ReservationId)
				from	MMResource with (readuncommitted)
				where	MediaId = @curMediaId
				and		HasJobInterrupted = 0
and		(ReservationType & 2) = 2
				if exists (select 1 from MMMountPath where MountPathId = @curMountPathId and MaxConcurrentWriters <= @mountPathReservationsNum)
				begin
					delete @RMResView
					where	ReservationId = 0
					-- Rest of the resource that use the same mount path
					and		(CopyId = @curCopyId and StreamId != @curStreamId and MountPathId = @curMountPathId)
				end
			end
			else
			begin
				update 	RMDataPathView
				set			RemainingMx = RemainingMx + @curRemainingMx,
								NonReservedDriveCount = NonReservedDriveCount - 1,
								ReservedDriveCount = ReservedDriveCount + 1
				where	DataPathId = @resDataPathId
				if exists (select mediaId from MMMedia with (readuncommitted) where MediaId = @curMediaId and IsInMediaGroup > 0)
				begin
					update RMDataPathView set AppendableMediaCount = AppendableMediaCount - 1
					where	DataPathId = @resDataPathId and AppendableMediaCount > 0
				end
				else
				begin
					update RMDataPathView set SpareMediaCount = SpareMediaCount - 1
					where	DataPathId = @resDataPathId and SpareMediaCount > 0
				end
			end
			-- If current DataPath already not usable but we still try to do reservation on it, it means there is interruption available on the data path.
			-- There is no need to do following check again.
			if exists (select DataPathId from RMDataPathView where DataPathId = @resDataPathId and FailureErrorCode = 0)
			begin
exec RMDataPathAdditionalFilter @i_RequestId, 2, @JobId,
			  												@numStreamsRemaining, 0 /*@bestcaseReserve*/, @dataMultiStream, @MuxFactor, @extraRestoreDrive, @extraRestoreDrivePoolId,
			  												@copyId, @SIDBStoreId, @appNum, @isTransactionLogBackupPhase,
			  												@isDebug, @o_ErrorCode output, @o_FailureType output
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO exit_error
				END
				if exists (select * from RMDataPathView where DataPathId = @resDataPathId and FailureErrorCode = 0)
				begin
					continue
				end
				else if exists (select * from RMDataPathView where DataPathId = @resDataPathId and FailureErrorCode > 0 and InterruptibleDrives > 0)
				begin
					-- DataPath is not usable anymore.
					-- if bestcasereserve, no need to continue since there is reservation already.
					-- otherwise, try to interrupt additional drives.
					if @bestcaseReserve > 0
					begin
						break
					end
					else
					begin
						delete @RMResView where DriveId > 0 and ReservationId = 0
						continue
					end
				end
				else
				begin
					break
				end
			end
		end -- @curReservationId = 0
  END --@numStreamsRemaining = 0
	SET @curReservationCount = 0
	SELECT @curReservationCount = COUNT(DISTINCT RCID) FROM @rmRCId
	insert into @tempLogger values ('RMReserveWriter',
																'Reserved [' + cast(isnull(@curReservationCount, 0) as varchar(10)) + '] streams. Requirement ['
																+ cast(isnull(@numStreams, 0) as varchar(10)) + '], Minimum Requirement ['
																+ cast(isnull(@numStreamsMin, 0) as varchar(10)) + ']',
																@i_RequestId, getutcdate())
	IF @curReservationCount < @numStreamsMin
	BEGIN
		declare @numIntrStreams int
		set @numIntrStreams = 0
		if exists (select * from @interruptibleDataPathList where DataPathId = @resDataPathId)
		and exists (select interruptibleStreams from RMDataPathView where DataPathId = @resDataPathId and interruptibleStreams > 0)
		and (@jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) OR (@jobType IN (@AUXCOPYJOB, @DASHCOPYJOB) and @AuxCopyInterruptAuxCopy > 0))
		and @IsInlineCopy = 0
		begin
			declare @numInterruptRequired int
			set @numInterruptRequired = @numStreamsMin - @curReservationCount
			set @numInterruptRequired = @numInterruptRequired / @MuxFactor + sign(@numInterruptRequired % @MuxFactor)
			if @isDebug > 0
			begin
				insert into @tempLogger values ('RMReserveWriter', 'Attempting interrupting streams. Number of Interruption Streams [' +
																			cast(isnull(@numInterruptRequired, 0) as varchar(10)) + '] for Drive Pool [' +
																			cast(isnull(@resDrivePoolId, 0) as varchar(10)) + ']',
																			@i_RequestId, getutcdate())
			end
exec @numIntrStreams = RMHandleInterrupt @i_RequestId, @jobId, @priority, 1, @numInterruptRequired, @ReservationType,
																				@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, @copyId, 0, @MuxFactor, 0, 0, 0, @resDrivePoolId, 0,
																				0,
																				@isDebug, @o_ErrorCode output
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			if @numIntrStreams > 0
			begin
				set @HasJobInterrupted = 1
				if @isDebug > 0
				begin
					insert into @tempLogger values ('RMReserveWriter', 'Interrupt ' + cast(isnull(@numIntrStreams, 0) as varchar(10)) + ' streams', @i_RequestId, getutcdate())
					set @debugDetail = cast(isnull((select  StreamId, ReservationId from MMResource with (readuncommitted) where IntrJobId_l = @JobId
										for XML RAW('InterruptedStreams'), TYPE), 'No Interrupted Streams') as nvarchar(max))
					insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
					set @debugDetail = cast(isnull((select  distinct resToJob.JobId_l JOBID
																				 from MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
																				 where res.IntrJobId_l = @JobId and res.ReservationId = resToJob.ReservationId
										for XML RAW('InterruptedJobs'), TYPE), 'No Interrupted Jobs') as nvarchar(max))
					insert into @tempLogger values ('RMReserveWriter', @debugDetail, @i_RequestId, getutcdate())
				end
			end
			else
			begin
				if @isDebug > 0
					insert into @tempLogger values ('RMReserveWriter', 'Interruption failed for DataPath ['
																				+ cast(isnull(@resDataPathId, 0) as varchar(10)) + ']. ErrorCode ['
+ cast(isnull(@o_ErrorCode, 0) as varchar(10)) + ']',
																				@i_RequestId, getutcdate())
			end
		end
		else
		begin
			if @isDebug > 0
				insert into @tempLogger values ('RMReserveWriter', 'No interruption happens for DataPath [' + cast(isnull(@resDataPathId, 0) as varchar(10)) + '].', @i_RequestId, getutcdate())
		end
		if @numIntrStreams = 0
		begin
			-- Release all the reserved streams from @rmRCId
			ROLLBACK TRANSACTION WRITER_RESERVATION_TRANS
			-- reset the value for whether there is interruption happens.
			set @HasJobInterrupted = 0
			-- For some reason, reservations on current data path don't meet the requirement.
			-- We need to try the next data path.
			if exists (select * from MMResource with (readuncommitted) where CopyId = @copyId)
				update RMDataPathView
set		FailureErrorCode = case when @o_ErrorCode != 0 then @o_ErrorCode else 20025 end,
FailureType = 2,
							InterruptibleStreams = 0,
							InterruptibleDrives = 0
				where	DataPathId = @resDataPathId
			else
				update RMDataPathView
set		FailureErrorCode = case when @o_ErrorCode != 0 then @o_ErrorCode else 2000 end,
FailureType = 2,
							InterruptibleStreams = 0,
							InterruptibleDrives = 0
				where	DataPathId = @resDataPathId
			if @isDebug > 0
			begin
				insert into RMLogger
				select * from @tempLogger
				delete @tempLogger
				insert into RMLogger values ('RMReserveWriter', 'Current reservations do not reach the minimum requirement.'
																	+ ' Rollback all the previous reservations and pick a different data path.',
																	@i_RequestId, getutcdate())
			end
			GOTO PICKING_DATAPATH
		end
	END
	if @isDebug > 0
	begin
		insert into RMLogger
		select * from @tempLogger
		delete @tempLogger
	end
  -- for Parallel Auxcopy, need to create one source stream for each reservation.
	set @curRCID = 0
	if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
		and @curMediaGroupId is not null and @curMediaGroupId > 0
  		and @sourceMediaGroupId > 0 and @sourceRCID > 0 and @sourceResID > 0
  begin
		-- The first one of parallel auxcopy
		if exists (select DestMediaGroupId from MMResourceToJob with (readuncommitted) where RCID = @sourceRCID and DestMediaGroupId = 0)
		begin
			update MMResourceToJob set DestMediaGroupId = @curMediaGroupId
			where RCID = @sourceRCID
		end
		else
		-- not the first one, create additional source reservation
		begin
	  	select @curRCID = next_l + 1 from GXCounter where name = 'RCID_Counter'
		  update GXCounter set next_l = @curRCID where name = 'RCID_Counter'
		  insert into MMResourceToJob (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
				ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
				DestMediaGroupId, LogicalReleased, Flag, AppClientId)
			select ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
				ReserveBitMask, ReleaseTime, ReservationType, @curRCID, PrimaryRCID, ClientTokenId,
				@curMediaGroupId, LogicalReleased, Flag, @appClientId
			from MMResourceToJob  with (readuncommitted)
			where RCID = @sourceRCID
			set @sourceRCID = @curRCID
		end
  end
	if @curReservationCount > 0
	begin
		-- Check if extra streams are reserved by reservation for backup caching.
		IF @backupCachingEnhance > 0 AND @backupCachingExtraStreamNumber > @numStreams
		AND @curReservationCount > @numStreams
		BEGIN
			declare @tmpRCID table (RCID int, ReservationID int)
			DELETE @tmpRCID
			INSERT INTO @tmpRCID
			SELECT	DISTINCT a.RCId, a.ReservationID
			FROM 	@rmRCID a, MMResourceToJob c
			WHERE	a.RCId = c.RCId AND a.ReservationId = c.ReservationId
			AND		c.JobId_l = 1 AND c.ReleaseTime != 0 AND InUse = 0
			DELETE @rmRCID
			FROM @rmRCID a, @tmpRCID b
			WHERE a.RCId = b.RCId AND a.ReservationId = b.ReservationId
		END
		INSERT INTO RMReservations
		SELECT	c.RCID, c.ReservationId, @i_RequestId, c.JobId_l, c.Priority, c.ReservationType, b.ReservationTime,
						b.CopyId, b.StreamId, b.VolumeId, b.MediaId, b.ScheduleRunId, b.NoOtherSchedule,
						b.SpareGroupId, b.MountPathId, b.DriveId, b.ClientId, b.DrivePoolId, b.MasterPoolId, b.LibraryId, b.LibraryTypeId,
						b.MediaGroupId, b.ResourceFlag, b.DriveInUseByDM, b.Released,
						c.PreEmptable, c.InUse, c.ReleaseTime, c.PrimaryRCID, c.ClientTokenId, c.DestMediaGroupid, c.LogicalReleased, b.IntrJobId_l
		FROM		@rmRCID a, MMResource b with (readuncommitted), MMResourceToJob c with (readuncommitted)
		WHERE		a.ReservationId = b.ReservationId
		AND			a.RCID = c.RCID
		SET @o_ReservationList =
		(
			SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId], [copyRsrvList!1!driveId], [copyRsrvList!1!hostId],
					[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
					[rcidList!2!val]
			from (
			SELECT	DISTINCT 1			          as TAG,
				NuLL									as Parent,
				NuLL									as [copyRsrvList!1],
				res.ReservationId			as [copyRsrvList!1!reservationId],
				res.CopyId						as [copyRsrvList!1!copyId],
				res.StreamId					as [copyRsrvList!1!streamNum],
				res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
				res.DriveId						as [copyRsrvList!1!driveId],
				res.ClientId					as [copyRsrvList!1!hostId],
 				res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
 				res.VolumeId					as [copyRsrvList!1!volumeId],
				@sourceRCID						as [copyRsrvList!1!sourceRCID],
				@archGroupName				as [copyRsrvList!1!archGroupName],
				@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
				l.AliasName						as [copyRsrvList!1!libraryName],
				dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
				c.Name								as [copyRsrvList!1!mediaAgentName],
				d.AliasName						as [copyRsrvList!1!driveName],
				res.MediaId						as [copyRsrvList!1!mediaId],
				m.Barcode							as [copyRsrvList!1!mediaBarcode],
				NULL									as [rcidList!2!val]
				FROM	@rmRCID a, MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted),
				App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
				WHERE	a.ReservationId = res.ReservationId AND a.ReservationId = resToJob.ReservationId AND a.RCID = resToJob.RCID
				AND		res.LibraryId = l.LibraryId
				AND		res.DrivePoolId = dp.DrivePoolId
				AND		res.ClientId = c.Id
				AND		res.DriveId = d.DriveId
				AND		res.MediaId = m.MediaId
			UNION ALL
			SELECT	2			          as TAG,
				1											as Parent,
				NuLL									as [copyRsrvList!1],
				res.ReservationId			as [copyRsrvList!1!reservationId],
				res.CopyId						as [copyRsrvList!1!copyId],
				res.StreamId					as [copyRsrvList!1!streamNum],
				res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
				res.DriveId						as [copyRsrvList!1!driveId],
				res.ClientId					as [copyRsrvList!1!hostId],
 				res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
				res.VolumeId					as [copyRsrvList!1!volumeId],
				@sourceRCID						as [copyRsrvList!1!sourceRCID],
				@archGroupName				as [copyRsrvList!1!archGroupName],
				@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
				l.AliasName						as [copyRsrvList!1!libraryName],
				dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
				c.Name								as [copyRsrvList!1!mediaAgentName],
				d.AliasName						as [copyRsrvList!1!driveName],
				res.MediaId						as [copyRsrvList!1!mediaId],
				m.Barcode							as [copyRsrvList!1!mediaBarcode],
				resToJob.RCID					as [rcidList!2!val]
				FROM	@rmRCID a, MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted),
				App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
				WHERE	a.ReservationId = res.ReservationId AND a.ReservationId = resToJob.ReservationId AND a.RCID = resToJob.RCID
				AND		res.LibraryId = l.LibraryId
				AND		res.DrivePoolId = dp.DrivePoolId
				AND		res.ClientId = c.Id
				AND		res.DriveId = d.DriveId
				AND		res.MediaId = m.MediaId
			) a
			ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId], [copyRsrvList!1!hostId],
					[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
					[rcidList!2!val]
			FOR XML EXPLICIT, TYPE
		)
		declare @errorList xml
		set @errorList = ''
		-- If this other data paths have been tried but failed, collect the error code list.
		if exists (
			select * from RMDataPathView
			where Precedence <= (select Precedence from RMDataPathView where DataPathId = @resDataPathId)
			and FailureErrorCode != 0
		)
		begin
			-- if the config value doens't exist or is 1, then return the full details.
			if (@jprConfigValue is not NULL and @jprConfigValue = 0)
			begin
				SET @errorList =
				(
					SELECT	TOP 3
						1			      as TAG,
						NuLL									as Parent,
						NuLL									as [errorList!1],
						a.FailureErrorCode				as [errorList!1!failureCode], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
						a.FailureType					as [errorList!1!failureType],
						@CopyId								as [errorList!1!copyId],
						@archGroupName				as [errorList!1!archGroupName],
						@archGroupCopyName		as [errorList!1!archGroupCopyName],
						CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
						a.DataPathId					as [errorList!1!datapathId],
						l.AliasName						as [errorList!1!libraryName],
						d.DrivePoolName				as [errorList!1!drivePoolName],
						c.Name								as [errorList!1!mediaAgentName],
						0 as [errorList!1!driveId], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
						NULL as [errorList!1!driveName], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT MountPathName FROM MMMountPath with (readuncommitted) WHERE MountPathId = dv.MountPathId) END as [errorList!1!driveName],
						NULL									as [errorList!1!mediaBarcode]
					FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
								MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
					WHERE	a.Precedence <= (select Precedence from RMDataPathView where DataPathId = @resDataPathId)
					AND		a.FailureErrorCode != 0
					AND		a.LibraryId = l.LibraryId
					AND		a.DrivePoolId = d.DrivePoolId
					AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
							 case when a.Precedence > 0 then a.Precedence else 9999 end
					FOR XML EXPLICIT, TYPE
				)
			end
			else
			begin
				SET @errorList =
				(
					SELECT	1			      as TAG,
						NuLL									as Parent,
						NuLL									as [errorList!1],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
						a.FailureType					as [errorList!1!failureType],
						@CopyId								as [errorList!1!copyId],
						@archGroupName				as [errorList!1!archGroupName],
						@archGroupCopyName		as [errorList!1!archGroupCopyName],
						CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
						a.DataPathId					as [errorList!1!datapathId],
						l.AliasName						as [errorList!1!libraryName],
						d.DrivePoolName				as [errorList!1!drivePoolName],
						c.Name								as [errorList!1!mediaAgentName],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT TOP 1 MountPathName FROM MMS2getMountPathList with (readuncommitted) WHERE MountPathId = dv.MountPathId AND ClientId = a.HostClientId) END as [errorList!1!driveName],
						NULL									as [errorList!1!mediaBarcode]
					FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
								MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
					WHERE	a.Precedence <= (select Precedence from RMDataPathView where DataPathId = @resDataPathId)
					AND		a.FailureErrorCode != 0
					AND		a.LibraryId = l.LibraryId
					AND		a.DrivePoolId = d.DrivePoolId
					AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
							 case when a.Precedence > 0 then a.Precedence else 9999 end
					FOR XML EXPLICIT, TYPE
				)
			end
		end
		-- Only do the following when we don't expect return directly
		IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
		BEGIN
			if @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
			begin
				-- When there is no source reservation, check the length. otherwise, only return the reservation without error
				if @sourceRCID <= 0 and len(cast(@o_ReservationList as nvarchar(max))) + len(cast(@errorList as nvarchar(max))) <= 3930
					set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(isnull(@errorList, '') as nvarchar(max))
			end
			else if len(cast(@o_ReservationList as nvarchar(max))) + len(cast(@errorList as nvarchar(max))) > 3930
			begin
				if len(cast(@errorList as nvarchar(max))) > 3930
				begin
					SET @errorList =
					(
						SELECT	TOP 3
							1			      as TAG,
							NuLL									as Parent,
							NuLL									as [errorList!1],
							a.FailureErrorCode				as [errorList!1!failureCode], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
							a.FailureType					as [errorList!1!failureType],
							@CopyId								as [errorList!1!copyId],
							@archGroupName				as [errorList!1!archGroupName],
							@archGroupCopyName		as [errorList!1!archGroupCopyName],
							CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
							a.DataPathId					as [errorList!1!datapathId],
							l.AliasName						as [errorList!1!libraryName],
							d.DrivePoolName				as [errorList!1!drivePoolName],
							c.Name								as [errorList!1!mediaAgentName],
							0 as [errorList!1!driveId], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
							NULL as [errorList!1!driveName], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT MountPathName FROM MMMountPath with (readuncommitted) WHERE MountPathId = dv.MountPathId) END as [errorList!1!driveName],
							NULL									as [errorList!1!mediaBarcode]
						FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
									MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
						WHERE	a.Precedence <= (select Precedence from RMDataPathView where DataPathId = @resDataPathId)
						AND		a.FailureErrorCode != 0
						AND		a.LibraryId = l.LibraryId
						AND		a.DrivePoolId = d.DrivePoolId
						AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
								 case when a.Precedence > 0 then a.Precedence else 9999 end
						FOR XML EXPLICIT, TYPE
					)
				end
				set @o_ReservationList =  'EMPTY_RESULTS' + cast(isnull(@errorList, '') as nvarchar(max))
			end
			else
			begin
				set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(isnull(@errorList, '') as nvarchar(max))
			end
		END
		if @isDebug > 0
			insert into RMLogger values ('RMReserveWriter',
	  					cast(isnull(@o_ReservationList, '') as nvarchar(max)),
	  					@i_RequestId, getutcdate())
	end
set @o_ErrorCode = 0
	if @isDebug > 0
		insert into RMLogger values ('RMReserveWriter',
  					'Exit with ['+ cast(isnull(@curReservationCount, 0) as varchar(10)) + '] streams reserved.',
  					@i_RequestId, getutcdate())
  ---------------------------------
  --       End of Module         --
  ---------------------------------
exit_error:
  if @HasJobInterrupted = 1
  begin
set @o_ErrorCode = 20005
set @o_FailureType = 2
  end
	if @curReservationCount = 0
	begin
		declare @errorListNoRsv xml
		set @errorListNoRsv = ''
		if exists (select 1 from RMDataPathView)
		begin
			-- if the config value doens't exist or is 1, then return the full details.
			if (@jprConfigValue is not NULL and @jprConfigValue = 0)
			begin
				SET @errorListNoRsv =
				(
					SELECT	TOP 3
						1			          as TAG,
						NuLL									as Parent,
						NuLL									as [errorList!1],
						a.FailureErrorCode				as [errorList!1!failureCode], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
						a.FailureType					as [errorList!1!failureType],
						@CopyId								as [errorList!1!copyId],
						@archGroupName				as [errorList!1!archGroupName],
						@archGroupCopyName		as [errorList!1!archGroupCopyName],
						@SIDBStoreId			as [errorList!1!SIDBStoreId],
						CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
						a.DataPathId					as [errorList!1!datapathId],
						l.AliasName						as [errorList!1!libraryName],
						d.DrivePoolName				as [errorList!1!drivePoolName],
						c.Name								as [errorList!1!mediaAgentName],
						0 as [errorList!1!driveId], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
						NULL as [errorList!1!driveName], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT MountPathName FROM MMMountPath with (readuncommitted) WHERE MountPathId = dv.MountPathId) END as [errorList!1!driveName],
						ISNULL((SELECT MediaBarcode FROM @RMResrvFailedMediaList WHERE DataPathId = a.DataPathId AND DBO.IsMediaReservFailure(a.FailureErrorCode) > 0 ), NULL) as [errorList!1!mediaBarcode]
					FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
								MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
					WHERE	a.FailureErrorCode != 0
					AND		a.LibraryId = l.LibraryId
					AND		a.DrivePoolId = d.DrivePoolId
					AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
							 case when a.Precedence > 0 then a.Precedence else 9999 end
					FOR XML EXPLICIT, TYPE
				)
			end
			else
			begin
				SET @errorListNoRsv =
				(
					SELECT	1			          as TAG,
						NuLL									as Parent,
						NuLL									as [errorList!1],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
						a.FailureType					as [errorList!1!failureType],
						@CopyId								as [errorList!1!copyId],
						@archGroupName				as [errorList!1!archGroupName],
						@archGroupCopyName		as [errorList!1!archGroupCopyName],
						@SIDBStoreId			as [errorList!1!SIDBStoreId],
						CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
						a.DataPathId					as [errorList!1!datapathId],
						l.AliasName						as [errorList!1!libraryName],
						d.DrivePoolName				as [errorList!1!drivePoolName],
						c.Name								as [errorList!1!mediaAgentName],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
						CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT TOP 1 MountPathName FROM MMS2getMountPathList with (readuncommitted) WHERE MountPathId = dv.MountPathId AND ClientId = a.HostClientId) END as [errorList!1!driveName],
						ISNULL((SELECT MediaBarcode FROM @RMResrvFailedMediaList WHERE DataPathId = a.DataPathId AND DBO.IsMediaReservFailure(a.FailureErrorCode) > 0 ), NULL)	as [errorList!1!mediaBarcode]
					FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
								MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
					WHERE	a.FailureErrorCode != 0
					AND		a.LibraryId = l.LibraryId
					AND		a.DrivePoolId = d.DrivePoolId
					AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
							 case when a.Precedence > 0 then a.Precedence else 9999 end
					FOR XML EXPLICIT, TYPE
				)
			end
			IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
			BEGIN
				if len(cast(@errorListNoRsv as nvarchar(max))) > 3900
				or @jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB) and len(cast(@errorListNoRsv as nvarchar(max))) > 3500
				begin
					SET @errorListNoRsv =
					(
						SELECT	TOP 3
							1			          as TAG,
							NuLL									as Parent,
							NuLL									as [errorList!1],
							a.FailureErrorCode				as [errorList!1!failureCode], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 OR dv.FailureErrorCode = 0 THEN a.FailureErrorCode ELSE dv.FailureErrorCode END	as [errorList!1!failureCode],
							a.FailureType					as [errorList!1!failureType],
							@CopyId								as [errorList!1!copyId],
							@archGroupName				as [errorList!1!archGroupName],
							@archGroupCopyName		as [errorList!1!archGroupCopyName],
							@SIDBStoreId			as [errorList!1!SIDBStoreId],
							CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId],
							a.DataPathId					as [errorList!1!datapathId],
							l.AliasName						as [errorList!1!libraryName],
							d.DrivePoolName				as [errorList!1!drivePoolName],
							c.Name								as [errorList!1!mediaAgentName],
							0 as [errorList!1!driveId], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN 0 ELSE dv.MountPathId END as [errorList!1!driveId],
							NULL as [errorList!1!driveName], --CASE WHEN dv.MountPathId IS NULL OR dv.MountPathId = 0 THEN NULL ELSE (SELECT MountPathName FROM MMMountPath with (readuncommitted) WHERE MountPathId = dv.MountPathId) END as [errorList!1!driveName],
							ISNULL((SELECT MediaBarcode FROM @RMResrvFailedMediaList WHERE DataPathId = a.DataPathId AND DBO.IsMediaReservFailure(a.FailureErrorCode) > 0 ), NULL)				as [errorList!1!mediaBarcode]
						FROM	RMDataPathView a LEFT OUTER JOIN #tmpRMDriveViewWithOffline dv ON dv.DataPathId = a.DataPathId AND dv.MountPathId > 0,
									MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
						WHERE	a.FailureErrorCode != 0
						AND		a.LibraryId = l.LibraryId
						AND		a.DrivePoolId = d.DrivePoolId
						AND		a.HostClientId = c.Id
ORDER BY case when a.FailureType = 1 then 0 else 1 end,
								 case when a.Precedence > 0 then a.Precedence else 9999 end
						FOR XML EXPLICIT, TYPE
					)
				end
			END
		end
		else
		begin
			SET @errorListNoRsv =
			(
				SELECT	1	          as TAG,
					NuLL									as Parent,
					NuLL									as [errorList!1],
					@o_ErrorCode					as [errorList!1!failureCode],
					@o_FailureType				as [errorList!1!failureType],
					@CopyId								as [errorList!1!copyId],
					@archGroupName				as [errorList!1!archGroupName],
					@archGroupCopyName		as [errorList!1!archGroupCopyName],
					@SIDBStoreId			as [errorList!1!SIDBStoreId],
					CASE WHEN @singleStream > 0 THEN @singleStream ELSE 0 END	as [errorList!1!streamId]
				FOR XML EXPLICIT, TYPE
			)
		end
		set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(isnull(@errorListNoRsv, '') as nvarchar(max))
	end
	if @isDebug > 0
		insert into RMLogger values ('RMReserveWriter',
  				'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20)) + '], FailureType['+ cast(@o_FailureType as varchar(20)) + ']...',
  				@i_RequestId, getutcdate())
SET XACT_ABORT OFF
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveWriters')
	delete from GxQscripts where name = 'RMReserveWriters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveWriters')
	delete from GXDBVersions where aliasname = 'RMReserveWriters'
GO

insert into GXDBVersions values(2, 'RMReserveWriters',  'v1.169.2.87.8.4', 'RMReserveWriters', 'v1.169.2.87.8.4')
GO

