

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveSourceForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveSourceForAuxCopy.sp,v $ $Id: RMReserveSourceForAuxCopy.sp,v 1.18.194.9 2019/09/17 15:47:06 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveSourceForAuxCopy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReserveSourceForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveSourceForAuxCopy <<<'
	drop procedure RMReserveSourceForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='RMReserveSourceForAuxCopy')
	delete from GxQscripts where name = 'RMReserveSourceForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveSourceForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveSourceForAuxCopy'
GO
print '... Creating Procedure: RMReserveSourceForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveSourceForAuxCopy
  @i_RequestId int,
  @i_isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT,
  @o_ReservationList XML 		OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_ReservationList = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	-- delete RMReservations where RequestId = @i_RequestId
	declare @jobId int = 0
	select @jobId = jobId
	from RMReservationRequest where RequestId = @i_RequestId
	if @@ROWCOUNT = 0
	begin
		-- Double check if the request still exists or not
set @o_ErrorCode = 415
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Cannot find current requestId ['
										+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		goto exit_error
	end
	-- delete RMLogger where requestId = @i_RequestId
	if @i_isDebug > 0
		insert into RMLogger values ('RMReserveSourceForAuxCopy', 'Enter For Job['+ cast(@jobId as varchar(20)) + ']', @i_RequestId, getutcdate())
	declare @sourceReservationId int
	declare @driveId int
	declare @RCID int
	--declare @sourceReservationResults XML
	DECLARE @l_SubmitDriveReqToLS		INTEGER
	SET			@l_SubmitDriveReqToLS		= 0
	DECLARE @l_LSOfflineDriveCnt		INTEGER
	SET			@l_LSOfflineDriveCnt		= 0
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	DECLARE @l_SubmitPowerOnReqToVM				INTEGER
	SET			@l_SubmitPowerOnReqToVM				= 0
	DECLARE @l_PMOfflineVMCount					INTEGER
	SET			@l_PMOfflineVMCount					= 0
	DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
	SET			@HOST_STATUS_POWER_MANAGED_VM		= 7
	DECLARE @tblLibServerDriveReq TABLE (
		mediaGroupId		INT,
		jobId 			INT,
		commCellId 	INT,
		libraryId		INT,
		driveNumber VARCHAR(MAX),
		driveCnt		INT,
		PRIMARY KEY (mediaGroupId, jobId, commCellId, libraryId)
	)
	declare @retCode INT = 0
	DECLARE @tblVMPowerOnReq TABLE (
	RMRequestId			INT,
	HostId				INT,
	jobId 				INT,
	commCellId 			INT,
	hostSoftState		INT,
	hostOfflineReason 	INT,
	PRIMARY KEY (jobId, HostId)
	)
	SAVE TRANSACTION SRC_RESERVATION_TRANS
	set @sourceReservationId = 0
	set @driveId = 0
	set @RCID = 0
	--set @sourceReservationResults =  ''
	exec @o_ErrorCode = RMReserveReaders @i_RequestId, 0, @i_isDebug,
																			@sourceReservationId output, @driveId output, @RCID output,
																			@o_ReservationList output,
																			@o_ErrorCode output, @o_FailureType output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
	end
if @o_ErrorCode != 0
	--and @o_ErrorCode != E_MM_NO_RESOURCE_INTERRUPTED_JOB
	begin
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	  goto exit_error
	end
	--Check if any offline LS drives are reserved for source
	SELECT @l_LSOfflineDriveCnt = COUNT(DISTINCT RES.driveId)
	FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.LibraryId = L.LibraryId
	AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	AND		RES.DriveId = D.driveId
	AND 	D.DriveSoftState <> 1
	AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	-- check for total offline power managed VMs count which are reserved reserved for source.
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, RES.ClientId, RES.JobId, 2, H.MmHostSoftState, H.OfflineReason
	FROM  RMReservations RES WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.ClientId = H.ClientId
AND 	H.Attribute & 32768 > 0
	SELECT @l_PMOfflineVMCount  = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	IF @l_PMOfflineVMCount > 0
	BEGIN
SET @o_ErrorCode = 346
SET @o_FailureType = 1
		SET @l_SubmitPowerOnReqToVM = 1
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Reservation for source return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	END
	IF @l_LSOfflineDriveCnt > 0
	BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
		SET @l_SubmitDriveReqToLS = 1
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Reservation for source return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		goto exit_error
	END
IF @o_ErrorCode = 0
	AND EXISTS (SELECT 1 FROM @tblVMPowerOnReq WHERE hostSoftState <> 0)
	BEGIN
		DECLARE @MAList varchar(1024) = ''
		SELECT  @MAList = @MAList + name + + ', '
		FROM    APP_Client A WITH (NOLOCK) INNER JOIN @tblVMPowerOnReq B ON A.id = B.HostId
		WHERE	hostSoftState <> 0
		IF @i_isDebug > 0
			insert into RMLogger values('RMReserveSourceForAuxCopy', 'Reserved power managed MAs, recording the usage for the MAs [' + @MAList + '].', @i_RequestId, getutcdate())
		INSERT INTO #tmpVMPowerOnReq
		SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
		FROM @tblVMPowerOnReq WHERE hostSoftState <> 0
		-- This sp does not submit power on request if the MA is already online, it records the last used time of this MA so that MM service can decide when to auto power off the VM.
		EXEC @retCode = RMSubmitVMPowerONRequest 0
		IF @retCode > 0
		BEGIN
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Failed to record the power managed MAs usage for the MAs ['	+ @MAList + '] with retCode [ '+ @retCode +' ] .', @i_RequestId, getutcdate())
		END
		DELETE FROM #tmpVMPowerOnReq
	END
exit_error:
	/*
	if @sourceReservationResults is not null and len(cast(@sourceReservationResults as nvarchar(max))) > 0
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@sourceReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
ReservationResults = case @o_ErrorCode when 0 then cast(@sourceReservationResults as nvarchar(max)) else cast(@o_ReservationList as nvarchar(max)) end
  where RequestId = @i_RequestId
	select @o_ErrorCode, @o_FailureType, @o_ReservationList
	*/
	--Dump the required data into table before Rollback
	IF @l_SubmitDriveReqToLS > 0 OR @l_SubmitPowerOnReqToVM > 0
	BEGIN
		IF @l_SubmitDriveReqToLS > 0
		BEGIN
			DECLARE @preferredDriveList TABLE (DrivePoolId INT, DriveNumberList VARCHAR(MAX))
			INSERT INTO @preferredDriveList
			SELECT	DISTINCT Res.DrivePoolId, ''
			FROM	RMreservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			UPDATE @preferredDriveList
			SET		DriveNumberList = (
										SELECT CAST(Drive.DriveNumber AS VARCHAR(10)) + ',' AS [text()]
										FROM	MMDriveController DC WITH (NOLOCK), MMDrive Drive WITH (NOLOCK)
										WHERE	DC.DrivePoolId = P.DrivePoolId
										AND		DC.DriveId = Drive.DriveId
										AND		Drive.DriveBroken = 0
										AND		Drive.DriveEnabled = 1
AND		MountStatus not in (4, 2, 3)
										AND		((Drive.DriveSoftState = 1)
												OR
												(Drive.DriveSoftState <> 1 AND Drive.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER))
										FOR XML PATH('')
									)
			FROM	@preferredDriveList P
			INSERT INTO @tblLibServerDriveReq
			SELECT V.mediaGroupId, RES.JobId, 2, RES.LibraryId, ISNULL(P.DriveNumberList, ''), COUNT(DISTINCT RES.DriveId)
			FROM 	RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK), @preferredDriveList P,
					MMVolume V WITH(READUNCOMMITTED)
			WHERE 	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			AND		RES.DriveId = D.driveId
			AND 	D.DriveSoftState <> 1
AND		D.MountStatus not in (4, 2, 3)
			AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
			AND     RES.DrivePoolId = P.DrivePoolId
			AND		RES.VolumeId = V.VolumeId
			GROUP BY V.mediaGroupId, RES.JobId, RES.LibraryId, ISNULL(P.DriveNumberList, '')
		END
		declare @tempLog table
		(
				RMModule	varchar(100),
				State		varchar(max),
				RequestId	integer,
				TimeStamp	datetime
		)
		insert into @tempLog
		select RMModule, State, RequestId, TimeStamp
		from	 RMLogger with (readuncommitted)
		where		RequestId = @i_RequestId
		ROLLBACK TRANSACTION SRC_RESERVATION_TRANS
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		IF @l_SubmitDriveReqToLS > 0
		BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Submitting request for shared drives to library server due to error ['
																+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			--Create and populate the shared temp table before submitting the request
			if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
			CREATE TABLE #tmpLibServerDriveReq (
				RMRequestId		INT,
				jobId 				INT,
				commCellId 		INT,
				libraryId			INT,
				driveNumber 	VARCHAR(MAX),
				driveCnt			INT,
				PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId)
			)
			INSERT INTO #tmpLibServerDriveReq
			SELECT mediaGroupId, jobId, commCellId, libraryId, driveNumber, driveCnt
			FROM @tblLibServerDriveReq
			EXEC @o_ErrorCode = RMSubmitLSDriveRequest 0
			IF @o_ErrorCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Failed to submit request for shared drives to library server due to error ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode = 415
set @o_FailureType = 2
			END
			ELSE
			BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Successfully submitted request for shared drives to library server - Error Code['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			END
		END
		IF @l_SubmitPowerOnReqToVM > 0
		BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
			IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Submitting cloud VM power on request due to the reason ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			INSERT INTO #tmpVMPowerOnReq
			SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
			FROM @tblVMPowerOnReq WHERE hostSoftState <> 1
			EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
			IF @o_ErrorCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Failed to submit cloud VM power on request due to error ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
SET @o_ErrorCode 	= 415
SET @o_FailureType 	= 2
			END
			ELSE
			BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Successfully submitted cloud VM power on request - Error Code['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			END
			DELETE FROM #tmpVMPowerOnReq
		END
	END
	if @i_isDebug > 0
	  insert into RMLogger values('RMReserveSourceForAuxCopy', 'Exit...', @i_RequestId, getutcdate())
 	return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveSourceForAuxCopy')
	delete from GxQscripts where name = 'RMReserveSourceForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveSourceForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveSourceForAuxCopy'
GO

insert into GXDBVersions values(2, 'RMReserveSourceForAuxCopy',  '00010018019400090000', 'RMReserveSourceForAuxCopy', '00010018019400090000')
GO

