

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveReaders.sp,v $ $Id: RMReserveReaders.sp,v 1.77.14.19 2020/12/03 02:25:04 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveReaders()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMReserveReaders')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveReaders <<<'
	drop procedure RMReserveReaders
END
IF EXISTS (select * from GxQscripts where name='RMReserveReaders')
	delete from GxQscripts where name = 'RMReserveReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveReaders')
	delete from GXDBVersions where aliasname = 'RMReserveReaders'
GO
print '... Creating Procedure: RMReserveReaders'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMReserveReaders
  @i_RequestId int,
  @i_IsForSwap int,
  @isDebug int,
  @o_ReservationId integer	OUTPUT,
  @o_DriveId integer OUTPUT,
  @o_RCID integer OUTPUT,
  @o_ReservationList XML			OUTPUT,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer	OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET XACT_ABORT ON
	declare @debugDetail varchar(max)
	set @debugDetail = ''
	set @o_ReservationId = 0
	set @o_DriveId = 0
	set @o_RCID = 0
DECLARE @RMDriveView TABLE ( DataPathId				integer, DriveControllerId		integer, DriveId					integer, DrivePoolId				integer, MasterPoolId			integer, LibraryId				integer, LibrarySubType			integer, SpareGroupId			integer, HostClientId			integer, MAClientId				integer, MountPathId				integer, DeviceId				integer, DeviceControllerId		integer, FailureErrorCode		integer, DriveAttributes			integer, Priority				integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, DriveId, Priority)	)
	IF object_id('tempdb.dbo.#tmpRMDriveViewWithOffline') IS NOT NULL
		DELETE #tmpRMDriveViewWithOffline
	ELSE
CREATE TABLE #tmpRMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, Priority					integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
set @o_ErrorCode = 0
set @o_FailureType = 1
  declare @HasJobInterrupted int
  set @HasJobInterrupted = 0
  declare @RSTJOB int
  declare @INDRSTJOB int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  set @RSTJOB = 2
  set @INDRSTJOB = 5
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
/*
enum CVJobType
{
	UNKNOWNJOB = 0,
	BKPJOB = 1,
	RSTJOB = 2,
	ARCHPRUNEJOB = 3,
	CSDRBKPJOB = 4,
	INDRSTJOB = 5,
	AUXCOPYJOB = 6,
	SYNTHFULLJOB = 7,
	REPORTJOB = 8,
	ALLJOBS = 9,
	SCHEDEXPORTJOB = 10,
	MEDIAINVENTORYJOB = 11,
	ARCHCHECKJOB = 12,
	TAPEERASEJOB = 13,
	SHELFMGMTJOB = 14,
	PATCHUPDATEJOB = 15,
	SELDELETEJOB = 16,
	WORKFLOWJOB = 17,
	DRIVEOPJOB	= 18,
	RESOURCEALLOCJOB = 19,
	OFFLINECONTENTINDEXINGJOB = 20	-- use this one for clarity
};
*/
	declare @JOBOPRESTORE			integer
	declare @MEDIAINVENTORY		integer
	declare @DRIVEVALIDATION	integer
	declare @DRIVECLEANING		integer
	declare @STAMPMEDIA				integer
	set @JOBOPRESTORE = 5
	set @MEDIAINVENTORY		= 21
	set @DRIVEVALIDATION = 41
	set @DRIVECLEANING = 42
	set @STAMPMEDIA = 46
	declare @TAPEERASE integer = 32
	-- Job OpType
	declare @AUXCOPY		integer
	declare @SYNTHFULL		integer
	declare @ARCHIVECHECK	integer
	declare @OFFLINECONTENTINDEX int
	declare @MEDIAREFRESH	integer
	declare @DEDUPDBSYNC	integer
	declare @AUXCOPY2		integer
	declare @CONTENT_INDEXING_ENTITY_EXTRACTION		integer
	set @AUXCOPY		= 13
	set @SYNTHFULL		= 14
	set @ARCHIVECHECK	= 31
	set @OFFLINECONTENTINDEX		= 53
	set @MEDIAREFRESH	= 74
	set @DEDUPDBSYNC	= 80
	set @AUXCOPY2		= 104
	set @CONTENT_INDEXING_ENTITY_EXTRACTION 		= 132
  -------------------------------------------
  -- Module: prepare reservation request   --
  -------------------------------------------
  declare @RequestTime				int
  declare @FailureAttempts			int
  declare @useSCDataPath			int
  declare @interruptInterval		int
  declare @forceMultiplexing		int
  declare @appNum					int
  declare @commCellId				int
  declare @dataType				    int
  declare @jobId					bigint
  declare @numStreams				int
  declare @bestcaseReserve			int
  declare @markActiveMediaFull		int
  declare @forcedMarkActiveMediaFull	int
  declare @priority				int
  declare @preEmptable				int
  declare @extraRestoreDrive		int
  declare @extraRestoreDrivePoolId	int
  declare @jobType					int
  declare @bkpLevel				int
  declare @appType					int
  declare @phaseFirstAttemptTime	bigint
  declare @archGroupId				int
  declare @copyIdList				varchar(100)
  declare @markMediaFullOnSuccess	int
  declare @dataMultiStream			int
  declare @maxDataMultiStream		int
  declare @failIfSecondaryCopyError int
  declare @multiCopyReserve		int
  declare @isForRemainingStreams	int
  declare @clientTokenId			int
  declare @inClientId				int
  declare @doPrelimReserveCheck	int
  declare @scheduleRunId			bigint
  declare @doNotAllowOtherSchedule	int
  declare @agroupNumber			int
  declare @copyId					int
  declare @maxMXCount				int
  declare @singleStream			int
  declare @checkConcurrency		int
  declare @preferredDrivePoolId	int
  declare @volId					int
  declare @DrvPoolId				int
  declare @mediaAgentId			int
  declare @mediaAgentName			varchar(256)
  declare @mediaId					int
  declare @MediaGrpId				int
  declare @rtype					int
  declare @isDummyReservation		int
  declare @destinationMediaGroupId	int
  declare @driveId 				int
  declare @rsvBitMask			int
  declare @rmJustId table (id int)
  declare @xmlRegistrySetting		XML
	declare @xmlParams						XML
	declare @jobOpType			int
	declare @jobSubOpType			int
	declare @iDAType				int
  declare @isRestoreCachingDisabled		int
    declare @isInUse                int
	declare @archGroupName			nvarchar(288)
	declare @archGroupCopyName	nvarchar(288)
 	declare @isReservable int
 	set @isReservable = 0
  set @RequestTime				= 0
  set @FailureAttempts		= 0
  set @useSCDataPath			= 0
  set @interruptInterval	= 0
  set @forceMultiplexing	= 0
  set @appNum							= 0
  set @commCellId					= 0
  set @dataType				    = 0
  set @jobId							= 0
  set @numStreams					= 0
  set @bestcaseReserve		= 0
  set @markActiveMediaFull	= 0
  set @forcedMarkActiveMediaFull	= 0
  set @priority						= 0
  set @preEmptable				= 0
  set @extraRestoreDrive	= 0
  set @extraRestoreDrivePoolId	= 0
  set @jobType						= 0
  set @bkpLevel						= 0
  set @appType						= 0
  set @phaseFirstAttemptTime	= 0
  set @archGroupId				= 0
  set @copyIdList					= ''
  set @markMediaFullOnSuccess	= 0
  set @dataMultiStream		= 0
  set @maxDataMultiStream		= 0
  set @failIfSecondaryCopyError = 0
  set @multiCopyReserve		= 0
  set @isForRemainingStreams	= 0
  set @clientTokenId			= 0
  set @inClientId					= 0
  set @doPrelimReserveCheck	= 0
  set @scheduleRunId			= 0
  set @doNotAllowOtherSchedule	= 0
  set @agroupNumber				= 0
  set @copyId							= 0
  set @maxMXCount					= 0
  set @singleStream				= 0
  set @checkConcurrency		= 0
  set @preferredDrivePoolId	= 0
  set @volId							= 0
  set @DrvPoolId					= 0
  set @mediaAgentId				= 0
  set @mediaAgentName			= ''
  set @mediaId						= 0
  set @MediaGrpId					= 0
  set @rtype							= 0
  set @isDummyReservation	= 0
  set @destinationMediaGroupId	= 0
  set @driveId 						= 0
  set @rsvBitMask					= 0
	set @jobOpType					= 0
	set @jobSubOpType					= 0
	set @iDAType						= 0
	set @isRestoreCachingDisabled = 0
    set @isInUse = 0
  select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@useSCDataPath = useSCDataPath,
		@commCellId = commCellId,
		@jobId = jobId,
		@jobType = jobType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@scheduleRunId = scheduleRunId,
		--@copyId = copyId,
		@xmlRegistrySetting = registrySetting,
		@xmlParams	= xmlParams
  from RMReservationRequest
  where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t') > 0
		BEGIN
			SELECT	@volId											= params.value('@volId', 'int'),
							@DrvPoolId									= params.value('@DrvPoolId', 'int'),
							@mediaAgentName							= params.value('@mediaAgentName', 'varchar(256)'),
							@mediaId										= params.value('@mediaId', 'int'),
							@MediaGrpId									= params.value('@MediaGrpId', 'int'),
							@jobId											= params.value('@jobId', 'bigint'),
							@jobOpType									= params.value('@jobOpType', 'int'),
							@priority										= params.value('@priority', 'int'),
							@preEmptable								= params.value('@preEmptable', 'int'),
							@bestcaseReserve						= params.value('@bestcaseReserve', 'int'),
							@rtype											= params.value('@rtype', 'int'),
							@checkConcurrency						= params.value('@checkConcurrency', 'int'),
							@isDummyReservation					= params.value('@isDummyReservation', 'int'),
							@destinationMediaGroupId		= params.value('@destinationMediaGroupId', 'int'),
							@copyId											= params.value('@copyId', 'int'),
							@rsvBitMask									= params.value('@resBitMask', 'int')
					FROM	@xmlParams.nodes('/ResourceManager_RmAuxcopyReservationArgs_t[1]/sourceArgs[1]') AS R(params)
			-- Do not set destination MediaGroup id for AuxCopy
			SET @destinationMediaGroupId = 0
		END
		ELSE IF @xmlParams.exist('/ResourceManager_RmReserveVolAndDriveArgs_t') > 0
		BEGIN
			SELECT	@volId											= params.value('@volId', 'int'),
							@DrvPoolId									= params.value('@DrvPoolId', 'int'),
							@mediaAgentName							= params.value('@mediaAgentName', 'varchar(256)'),
							@mediaId										= params.value('@mediaId', 'int'),
							@MediaGrpId									= params.value('@MediaGrpId', 'int'),
							@jobId											= params.value('@jobId', 'bigint'),
							@jobOpType									= params.value('@jobOpType', 'int'),
							@priority										= params.value('@priority', 'int'),
							@preEmptable								= params.value('@preEmptable', 'int'),
							@bestcaseReserve						= params.value('@bestcaseReserve', 'int'),
							@rtype											= params.value('@rtype', 'int'),
							@checkConcurrency						= params.value('@checkConcurrency', 'int'),
							@isDummyReservation					= params.value('@isDummyReservation', 'int'),
							@destinationMediaGroupId		= params.value('@destinationMediaGroupId', 'int'),
							@copyId											= params.value('@copyId', 'int'),
							@driveId										= params.value('@driveId', 'int'),
							@rsvBitMask									= params.value('@resBitMask', 'int')
					FROM	@xmlParams.nodes('/ResourceManager_RmReserveVolAndDriveArgs_t[1]') AS R(params)
		END
		ELSE IF @xmlParams.exist('/ResourceManager_RmExchangeVolumeArgs_t') > 0
		BEGIN
			SELECT	@volId											= params.value('@volId', 'int'),
							@DrvPoolId									= params.value('@DrvPoolId', 'int'),
							@mediaAgentName							= params.value('@mediaAgentName', 'varchar(256)'),
							@mediaId										= params.value('@mediaId', 'int'),
							@MediaGrpId									= params.value('@MediaGrpId', 'int'),
							@jobId											= params.value('@jobId', 'bigint'),
							@jobOpType									= params.value('@jobOpType', 'int'),
							@priority										= params.value('@priority', 'int'),
							@preEmptable								= params.value('@preEmptable', 'int'),
							@bestcaseReserve						= params.value('@bestcaseReserve', 'int'),
							@rtype											= params.value('@rtype', 'int'),
							@checkConcurrency						= params.value('@checkConcurrency', 'int'),
							@isDummyReservation					= params.value('@isDummyReservation', 'int'),
							@destinationMediaGroupId		= params.value('@destinationMediaGroupId', 'int'),
							@copyId											= params.value('@copyId', 'int'),
							@driveId										= params.value('@driveId', 'int'),
							@rsvBitMask									= params.value('@resBitMask', 'int')
					FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]/newArgs[1]') AS R(params)
		END
	END
	IF @xmlRegistrySetting IS NOT NULL
	BEGIN
		SELECT	@interruptInterval				= params.value('@interruptDelayInterval', 'int'),
						@isRestoreCachingDisabled	= params.value('@isRestoreCachingDisabled', 'int')
		FROM		@xmlRegistrySetting.nodes('/ResourceManager_RmRegistrySetting_t[1]') AS R(params)
	END
	if @jobOpType is null or @jobOpType = 0
	begin
  		set @jobOpType = dbo.GetJobTypeForJobID(@jobId)
	end
	if @volId > 0 and (@copyId is null or @copyId = 0)
	and @jobOpType in (@AUXCOPY, @ARCHIVECHECK, @OFFLINECONTENTINDEX, @MEDIAREFRESH, @DEDUPDBSYNC, @AUXCOPY2)
	begin
		-- For DSA, the media group id may or may not be the one on volume. We do not want to set the media group if it is not provided. So look up through volume only.
		select @copyId = stream.ArchGroupCopyId
		from	ArchStream stream with (nolock), MMVolume vol with (nolock)
		where	vol.VolumeId = @volId
		and		vol.MediaGroupId = stream.MediaGroupId
	end
	if @copyId is not null and @copyId > 0
	begin
		select @archGroupCopyName = name from ArchGroupCopy with (readuncommitted) where Id = @copyId
		select @archGroupName	= a.name from ArchGroup a with (readuncommitted), ArchGroupCopy b with (readuncommitted) where b.Id = @copyId and b.archGroupId = a.Id
	end
	if @driveId is null or @driveId < 0
		set @driveId = 0
--get the job sub optype
	SELECT @jobSubOpType = subOpType FROM JMJobInfo where jobId = @jobId
  ----------------------------------------------------------------
  -- Module  : Usage based License - disabling the Job start
  ----------------------------------------------------------------
  	-- CI license is not required for analytics job
	Declare @isFLAJob int
select @isFLAJob = ISNULL(cast(dbo.GetJobOption(@jobId, 1458825153 ) as int),0)
    if @jobOpType = @OFFLINECONTENTINDEX AND @isFLAJob = 0
		begin
			exec @o_ErrorCode = LicCIUsageBasedValid   @jobId
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				GOTO exit_error
			END
if @o_ErrorCode != 0
			begin
set @o_FailureType = 2
				goto exit_error
			end
		end
  ----------------------------------------------------------------
  -- Usage based License - disabling the Job end
  ----------------------------------------------------------------
  --------------------------------
  -- Module: cache restore  --
  --------------------------------
  --#define UNUSED_CV_APPTYPE_2						2	-- Oracle 7
  --#define UNUSED_CV_APPTYPE_2						UNUSED_CV_APPTYPE_2
  --#define CV_APPTYPE_INFORMIX						3
  --#define CV_APPTYPE_ORACLE8						22
  --#define CV_APPTYPE_ORACLE_RAC					80
  --#define CV_APPTYPE_SAP_FOR_ORACLE		        61
  --#define CV_APPTYPE_DB2							37
  --#define CV_APPTYPE_UNIX_DB2	                    62
  --#define CV_APPTYPE_DB2_DPF						103
  IF @jobOpType = @JOBOPRESTORE
  AND	@iDAType in (
2, 2,
22, 80, 61,
3,
37, 62, 103
			)
  AND	@isRestoreCachingDisabled = 0
  BEGIN
        set @isInUse = 1
		set @o_RCID = 0
		DECLARE @cacheRestoreResult TABLE
		(
			ErrorCode			integer,
			reservationid	integer,
			driveid				integer,
			rcid					integer
		)
		INSERT INTO @cacheRestoreResult
		EXEC RMRestoreCachingReserve @volId, @DrvPoolId, @jobId
		if @@ERROR > 0
		begin
set @o_ErrorCode = 415
set @o_FailureType = 2
		  goto exit_error
		end
		SELECT	@o_ErrorCode = ErrorCode,
						@o_ReservationId = reservationId,
						@o_DriveId = driveId,
						@o_RCId = rcid
		FROM @cacheRestoreResult
IF @o_ErrorCode = 0
		AND @o_ReservationId > 0
		AND @o_RCId > 0
		BEGIN
			INSERT INTO RMReservations
			SELECT	c.RCID, c.ReservationId, @i_RequestId, c.JobId_l, c.Priority, c.ReservationType, b.ReservationTime,
							b.CopyId, b.StreamId, b.VolumeId, b.MediaId, b.ScheduleRunId, b.NoOtherSchedule,
							b.SpareGroupId, b.MountPathId, b.DriveId, b.ClientId, b.DrivePoolId, b.MasterPoolId, b.LibraryId, b.LibraryTypeId,
							b.MediaGroupId, b.ResourceFlag, b.DriveInUseByDM, b.Released,
							c.PreEmptable, c.InUse, c.ReleaseTime, c.PrimaryRCID, c.ClientTokenId, c.DestMediaGroupid, c.LogicalReleased, b.IntrJobId_l
			FROM		MMResource b with (readuncommitted), MMResourceToJob c with (readuncommitted)
			WHERE		c.ReservationId = b.ReservationId
			AND			c.RCID = @o_RCId
			SET @o_ReservationList =
			(
					SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
							[copyRsrvList!1!drivePoolId], [copyRsrvList!1!driveId], [copyRsrvList!1!hostId], [copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId],
							[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
							[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
							[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
							[rcidList!2!val]
					from (
					SELECT	1			          as TAG,
						NuLL									as Parent,
						NuLL									as [copyRsrvList!1],
						res.ReservationId			as [copyRsrvList!1!reservationId],
						res.CopyId						as [copyRsrvList!1!copyId],
						res.StreamId					as [copyRsrvList!1!streamNum],
						res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
						res.DriveId						as [copyRsrvList!1!driveId],
						res.ClientId					as [copyRsrvList!1!hostId],
						res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
						res.VolumeId					as [copyRsrvList!1!volumeId],
						@archGroupName				as [copyRsrvList!1!archGroupName],
						@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
						l.AliasName						as [copyRsrvList!1!libraryName],
						dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
						c.Name								as [copyRsrvList!1!mediaAgentName],
						d.AliasName						as [copyRsrvList!1!driveName],
						res.MediaId						as [copyRsrvList!1!mediaId],
						m.Barcode							as [copyRsrvList!1!mediaBarcode],
						NULL									as [rcidList!2!val]
						FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted), App_Client c with (readuncommitted),
						MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
						WHERE	res.ReservationId = resToJob.ReservationId AND resToJob.RCID = @o_RCID
						AND		res.LibraryId = l.LibraryId
						AND		res.DrivePoolId = dp.DrivePoolId
						AND		res.ClientId = c.Id
						AND		res.DriveId = d.DriveId
						AND		res.MediaId = m.MediaId
					UNION ALL
					SELECT	2			          as TAG,
						1											as Parent,
						NuLL									as [copyRsrvList!1],
						res.ReservationId			as [copyRsrvList!1!reservationId],
						res.CopyId						as [copyRsrvList!1!copyId],
						res.StreamId					as [copyRsrvList!1!streamNum],
						res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
						res.DriveId						as [copyRsrvList!1!driveId],
						res.ClientId					as [copyRsrvList!1!hostId],
						res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
						res.VolumeId					as [copyRsrvList!1!volumeId],
						@archGroupName				as [copyRsrvList!1!archGroupName],
						@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
						l.AliasName						as [copyRsrvList!1!libraryName],
						dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
						c.Name								as [copyRsrvList!1!mediaAgentName],
						d.AliasName						as [copyRsrvList!1!driveName],
						res.MediaId						as [copyRsrvList!1!mediaId],
						m.Barcode							as [copyRsrvList!1!mediaBarcode],
						resToJob.RCID					as [rcidList!2!val]
						FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted), App_Client c with (readuncommitted),
						MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
						WHERE	res.ReservationId = resToJob.ReservationId AND resToJob.RCID = @o_RCID
						AND		res.LibraryId = l.LibraryId
						AND		res.DrivePoolId = dp.DrivePoolId
						AND		res.ClientId = c.Id
						AND		res.DriveId = d.DriveId
						AND		res.MediaId = m.MediaId
					) a
					ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
							[copyRsrvList!1!drivePoolId],  [copyRsrvList!1!driveId], [copyRsrvList!1!hostId], [copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId],
							[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
							[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
							[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
							[rcidList!2!val]
					FOR XML EXPLICIT, TYPE
			)
			insert into RMLogger values ('RMReserveReaders::RMRestoreCachingReserve',
						'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20))
						+ '], FailureType['+ cast(@o_FailureType as varchar(20))
						+ '], ReservationId [' + cast(@o_ReservationId as varchar(20))
						+ '], DriveId [' + cast(@o_DriveId as varchar(20)) + ']',
						@i_RequestId, getutcdate())
RETURN 0
		END
		insert into RMLogger values ('RMReserveReaders::RMRestoreCachingReserve',
					'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20))
					+ '], FailureType['+ cast(@o_FailureType as varchar(20))
					+ '], ReservationId [' + cast(@o_ReservationId as varchar(20))
					+ '], DriveId [' + cast(@o_DriveId as varchar(20)) + ']',
					@i_RequestId, getutcdate())
		--RETURN @o_ErrorCode
		-- Continue with the regular reservation
SET	@o_ErrorCode = 0
		SET @o_ReservationId = 0
		SET @o_DriveId = 0
		SET @o_RCId = 0
  END
  --------------------------------
  -- Module: claim interruption --
  --------------------------------
  if exists (select * from MMResource with (readuncommitted) where HasJobInterrupted = 1 and ReservationId in
  						 (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId))
  begin
		-- check if interrupted resource can be claimed
		-- There is no need to check the status in MMResource, as long as the entry MMResourceToJob is marked released for interrupted jobs.
		--if exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and Released = 0)
		if exists (select * from MMResourceToJob with (readuncommitted) where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and NOT (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))))
or exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and DriveId in (select DriveId from MMDrive with (readuncommitted) where MountStatus in (2, 3)))
		begin
		  -- interrupted resources are not freed yet
			set @debugDetail = cast(isnull((
												select	ReservationId, CopyId, StreamId, DrivePoolId, DriveId, MediaId, MountPathId
												from		MMResource with (readuncommitted)
												where		intrjobId_l = @JobId
												for XML RAW('InterruptedStreams'), TYPE), 'No Interrupted Resources') as nvarchar(max))
  		insert into RMLogger values ('RMReserveReader',
  				'Error return because Interrupted resources are not freed yet' + @debugDetail, @i_RequestId, getutcdate())
set @o_ErrorCode = 20004
set @o_FailureType = 2
		  goto exit_error
		end
		-- release interrupted resource
		delete from MMresourceToJob
		where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0)))
		delete from MMResource where intrjobid_l = @jobId
		-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
		-- those are place holder anyway, also we will have to check availability of everything
		delete @rmJustId
		insert into @rmJustId
		select reservationid from MMResource with (readuncommitted) where ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId) and HasJobInterrupted = 1
		if @isDebug > 0
		begin
			set @debugDetail = cast(isnull((
												select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.MediaId, a.DriveId, a.LibraryId, b.RCID, b.JobId_l
												from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
												where a.ReservationId = b.ReservationId and a.ReservationId in (select id from @rmJustId)
												for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resources') as nvarchar(max))
			insert into RMLogger values ('Claim Interruption', @debugDetail, @i_RequestId, getutcdate())
		end
    delete from MMResourceToJob where ReservationId in (select id from @rmJustId)
    delete from MMResource where ReservationId in (select id from @rmJustId)
  end
  ---------------------------------------
  -- End of Module: claim interruption --
  ---------------------------------------
	IF @volId <= 0 OR NOT EXISTS (SELECT * FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId)
	BEGIN
		IF @jobOpType = @MEDIAINVENTORY	OR @jobOpType = @DRIVEVALIDATION OR @jobOpType = @DRIVECLEANING OR @jobOpType = @STAMPMEDIA
		BEGIN
			SET @volId = 0
			SET @mediaId = 0
		END
		ELSE
		BEGIN
SET @o_ErrorCode = 268
			insert into RMLogger values ('RMReserveReaders', 'The specified volume id is invalid', @i_RequestId, getutcdate())
			goto exit_error
		END
	END
	ELSE
	BEGIN
		SELECT @MediaId = MediaId FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId
	END
	if @isDebug > 0
		insert into RMLogger values ('RMReserveReaders',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], MediaId['
																				+ cast(isnull(@mediaId, 0) as varchar(20)) + '], DrivePoolId['
																				+ cast(isnull(@DrvPoolId, 0) as varchar(20)) + '] DriveId['
																				+ cast(isnull(@DriveId, 0) as varchar(20)) + '] JobId['
																				+ cast(isnull(@JobId, 0) as varchar(20)) + ']',
						@i_RequestId, getutcdate())
	-- For drive cleaning job, check the media first. Make sure the media is not reserved
	if @jobOpType = @DRIVECLEANING
	begin
		if @driveId is null or @driveId = 0
		begin
set @o_ErrorCode = 807
			insert into RMLogger values ('RMReserveReaders', 'This is a drive cleaning job but no drive specified', @i_RequestId, getutcdate())
			goto exit_error
		end
		if @volId = 0
		or exists (select * from MMResource with (readuncommitted) where volumeId = @volId)
		or not exists (select b.MediaTypeId from MMMedia a with (readuncommitted), MMMediaType b with (readuncommitted) where a.MediaId = @MediaId and a.MediaTypeId = b.MediaTypeId and b.isCleaningMedia = 1)
		begin
			if @isDebug > 0
				insert into RMLogger values ('RMReserveReaders', 'The given volume id is either 0, reserved or not a cleaning media. Select a differnt one.', @i_RequestId, getutcdate())
			declare @tempMediaList table
			(
					mediaId					int,
mediaBarcode		varchar(255),
					mediaTypeId			int,
mediaTypeName		varchar(255),
					isCleaningMedia	int,
					isWormMedia			int,
					libraryId				int,
					reservationId		int,
					isAged					int,
					mediaSideId			int,
sideName				varchar(255),
					isDeprecatable	int
			)
			insert into @tempMediaList
			exec MMS2GetMediaListByDriveRecFmt @driveId
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			  goto exit_error
			end
			set @mediaId = 0
			set @volId = 0
			select top 1 @mediaId = isnull(mediaId, 0)
			from @tempMediaList
			where isCleaningMedia > 0
			and		isDeprecatable = 0
			and		reservationId = 0
			if @mediaId is not null and @mediaId > 0
			begin
				select top 1 @volId = VolumeId from MMVolume with (readuncommitted) where MediaId = @mediaId
			end
			else
			begin
				if exists (select * from @tempMediaList where isCleaningMedia > 0 and isDeprecatable = 0 and reservationId > 0)
                begin
set @o_ErrorCode = 803
    				insert into RMLogger values ('RMReserveReaders', 'Cleaning media has been reserved by other drives', @i_RequestId, getutcdate())
                end
				else
                begin
set @o_ErrorCode = 907
				    insert into RMLogger values ('RMReserveReaders', 'This is no unreserved cleaning media in library', @i_RequestId, getutcdate())
                end
				goto exit_error
			end
		end
	end
  -- Based on the Drive Pool Id and possible Media Agent Id
	declare @NumDriveViews int
  declare @SpareGroupId int
  declare @MountPathId int
  declare @MasterPoolId int
  declare @ClientId int
  declare @LibraryId int
  declare @LibraryTypeId int
  declare @ReservationId int
  declare @RCID int
  set @ReservationId = 0
  set @NumDriveViews = 0
  declare @RecordingFormatId int
	declare @numInterrupted int
	/*
  IF @MediaGrpId <= 0
  BEGIN
  	SELECT @MediaGrpId = MediaGroupId FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId
  END
  */
  IF @DrvPoolId <= 0 and @MediaGrpId > 0
  BEGIN
  	SELECT @DrvPoolId = DrivePoolId
  	FROM	MMMediaGroup with (readuncommitted)
  	WHERE	MediaGroupId = @MediaGrpId
	END
  IF LEN(@mediaAgentName) > 0
  BEGIN
  	SELECT TOP 1 @mediaAgentId = h.ClientId
  	FROM	MMHost h WITH (READUNCOMMITTED), APP_Client c WITH (READUNCOMMITTED)
  	WHERE	H.ClientId = c.Id
  	AND		c.Net_HostName = @mediaAgentName
  END
	if @driveId > 0
	begin
		declare @driveTypeId int
		select @driveTypeid = DriveTypeId from MMDrive with (readuncommitted) where DriveId = @driveId
		-- THis is assumption that it has to be non-magnetic drive id. Maybe we need check the type
		if  @DrvPoolId > 0
		begin
if @driveTypeId <> 10001
			and not exists (select * from MMDriveController with (readuncommitted) where DriveId = @driveid and DrivePoolid = @DrvPoolId)
				set @driveId = 0
		end
		else
		begin
if @driveTypeId = 10001
			begin
				select @DrvPoolId = dp.DrivePoolId
				from MMDrive d with (readuncommitted), MMDrivePool dp with (readuncommitted)
				where d.DriveId = @driveId
				and		d.MasterPoolId = dp.MasterPoolId
			end
			else
			begin
				select @DrvPoolId = DrivePoolId
				from MMDriveController with (readuncommitted)
				where DriveId = @driveId
			end
		end
	end
	IF (@mediaAgentId IS NULL OR @mediaAgentId = 0)
 	AND @DrvPoolId > 0
 	BEGIN
  		SELECT @mediaAgentId = ClientId
  		FROM	MMDrivePool WITH (READUNCOMMITTED)
  		WHERE DrivePoolId = @DrvPoolId
	END
	if @DrvPoolId <= 0
	begin
set @o_ErrorCode = 398
		insert into RMLogger values ('RMReserveReaders', 'Cannot find the drive pool information for reader reservation', @i_RequestId, getutcdate())
		goto exit_error
	end
  -- look up volume info --
 	set @isReservable = 0
 	exec RMIsVolumeReservable @i_RequestId, @JobId, @volId, @MediaGrpId, 	@DrvPoolId, 0, @mediaAgentId, 0,
1, 1, @isDebug,
 														@isReservable output, @o_ErrorCode output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	  goto exit_error
	end
	if @isDebug > 0
	begin
			set @debugDetail = cast(isnull((
												select (case when @isReservable = 1 then 'YES' else 'NO' end) IsVolumeReservable,
																@o_ErrorCode ErrorCode,
																@jobId JobId, @volId VolumeId, @MediaGrpId MediaGroupId, @DrvPoolId DrivePoolId,
																0 MasterPoolId, @mediaAgentId MediaAgentId, 0 LibraryId,
1 ReservationType, 1 CheckOppositeSide
												for XML RAW('RMIsVolumeReservable'), TYPE), 'No params for RMIsVolumeReservable') as nvarchar(max))
		insert into RMLogger values ('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
	end
if @isReservable = 0 and @o_ErrorCode != 803
	begin
		  GOTO exit_error
	end
  select	@RecordingFormatId = RecordingFormatId, @mediaId = MediaId
  from		MMVolume  with (readuncommitted)
  where		VolumeId = @volId
  select	@SpareGroupId = SpareGroupId, @LibraryId = LibraryId
  from		MMMedia with (readuncommitted)
  where		MediaId = @mediaId
  select	@MountPathId = isnull(MountPathId, 0)
  from		MMMountPath with (readuncommitted)
  where		MediaSideId in (select top 1 MediaSideId from MMMediaSide with (readuncommitted) where MediaId = @mediaId)
  if @MountPathId is null
		set @MountPathId = 0
if @RecordingFormatId = 10001 or @RecordingFormatId = 11002
  begin
		-- check drive reservable
		exec RMGetAvailableDrivesForDrivePool @i_RequestId, @CopyId, @JobId, @JobType, @DrvPoolId, @mediaAgentId,
0, @RecordingFormatId, @volId, 0, 1, @i_IsForSwap,
																					@isDebug, @o_ErrorCode output, @o_FailureType output
		if @@ERROR > 0
		begin
set @o_ErrorCode = 415
set @o_FailureType = 2
		  goto exit_error
		end
		insert into @RMDriveView
		select DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId, LibrarySubType,
						SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0, DriveAttributes
		from	#tmpRMDriveViewWithOffline
		where	FailureErrorCode = 0
		order by Priority
		select @NumDriveViews = @@rowcount
		if @isDebug > 0
		begin
			insert into RMLogger values ('RMReserveReaders',
							'There are total ['+ cast(isnull(@NumDriveViews, 0) as varchar(10))
							+ '] Mount Paths (Drive) availabe for volume ['
							+ cast(isnull(@volId, 0) as varchar(10)) + '] in this magnetic library ['
							+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
							@i_RequestId, getutcdate())
			set @debugDetail = cast(isnull((select FailureErrorCode FailureReason, DataPathId, DrivePoolId, MasterPoolId,
																						LibraryId, HostClientId, MAClientId, DeviceId, MountPathId
																			from #tmpRMDriveViewWithOffline
																			for XML RAW('MountPathList'), TYPE), 'No Mount Path Available') as nvarchar(max))
			insert into RMLogger values('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
			if not exists (select * from #tmpRMDriveViewWithOffline)
			and exists (select top 1 * from RMDataPathView)
			begin
				set @debugDetail = cast(isnull((select FailureErrorCode FailureReason, DataPathId, DrivePoolId, MasterPoolId, LibraryId, HostClientId
																				from RMDataPathView
																				for XML RAW('DataPathList'), TYPE), 'No Data Path Available') as nvarchar(max))
				insert into RMLogger values('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
			end
		end
		if @NumDriveViews = 0
		begin
			insert into RMLogger values ('RMReserveReaders',
							'Error return because no Mount Path available for reserve in Magnetic Library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
							@i_RequestId, getutcdate())
if @o_ErrorCode = 0
set @o_ErrorCode = 312
			goto exit_error
		end
		-- use the same drive
		if exists (select * from MMResource with (readuncommitted) where VolumeId = @volId and DriveId in (select DriveId from @RMDriveView))
		begin
			select top 1 @DriveId = isnull(DriveId, 0) from MMResource with (readuncommitted) where VolumeId = @volId
		end
		else
		begin
			select top 1 @DriveId = isnull(DriveId, 0) from @RMDriveView order by Priority
		end
		if @DriveId is null or @DriveId = 0
		begin
			insert into RMLogger values ('RMReserveReaders',
					'Error return because no Mount Path available for reserve in Magnetic Library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
					@i_RequestId, getutcdate())
if @o_ErrorCode = 0
set @o_ErrorCode = 312
			goto exit_error
		end
		if @isDebug > 0
			insert into RMLogger values ('RMReserveReaders',
						'Drive['+ cast(isnull(@DriveId, 0) as varchar(20)) + '] is selected for reservation in Magnetic Library [' + cast(isnull(@LibraryId, 0) as varchar(20)) +']',
						@i_RequestId, getutcdate())
		goto exit_createReservation
  end
	-- if @RecordingFormatId != CV_MAGNETIC_FORMAT
	else -- RecordingFormatId is not CV_MAGNETIC_FORMAT or CV_REMOVABLE_PNP_DISK_MEDIA
	begin
if @o_ErrorCode = 803
		begin
			-- check media reservable
			if exists (select * from MMResource with (readuncommitted) where MediaId = @mediaId)
			begin
				set @numInterrupted = 0
exec @numInterrupted = RMHandleInterrupt @i_RequestId, @jobId, @priority, 4, 1, 1,
																									@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, 0, 0, 0, @mediaId, @volId, 0, 0, 0,
																									0,
																									@isDebug, @o_ErrorCode output
				if @@ERROR > 0
				begin
set @o_ErrorCode = 415
set @o_FailureType = 2
				  goto exit_error
				end
				if @numInterrupted > 0
				begin
					set @HasJobInterrupted = 1
					/*
if @o_ErrorCode = 0
set @o_ErrorCode = 803
					*/
					if @isDebug > 0
					begin
						set @debugDetail = cast(isnull((
															select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.MediaId, a.DriveId, a.LibraryId
															from MMResource a with (readuncommitted)	where IntrJobId_l = @jobId
															for XML RAW('InterruptedMedia'), TYPE), 'No Interrupted Media') as nvarchar(max))
						insert into RMLogger values ('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
					end
					select	@DriveId = DriveId,
									@DrvPoolId = @DrvPoolId,
									@MasterPoolId = MasterPoolId,
									@LibraryId = LibraryId,
									@SpareGroupId = SpareGroupId
					from MMResource with (readuncommitted) where IntrJobId_l = @jobId
					goto exit_createReservation
				end
				else	-- no interruption
				begin
					insert into RMLogger values ('RMReserveReaders',
										'Error return because media ['+ cast(isnull(@mediaId, 0) as varchar(20)) + '] in Library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +'] already been reserved',
										@i_RequestId, getutcdate())
set @o_ErrorCode = 803
					goto exit_error
				end
			end
			-- should not happen
			else
			begin
set @o_ErrorCode = 268
				goto exit_error
			end
		end
		-- Media is not reserved
		else
		begin
check_drive:
			if @jobOpType = @TAPEERASE
			BEGIN
				-- check drive reservable
				exec RMGetAvailableDrivesForDrivePool @i_RequestId, @CopyId, @JobId, @JobType, @DrvPoolId, @mediaAgentId,
0, @RecordingFormatId, @volId, 0, 2, @i_IsForSwap,
																							@isDebug, @o_ErrorCode output, @o_FailureType output
			END
			ELSE
			BEGIN
				-- check drive reservable
				exec RMGetAvailableDrivesForDrivePool @i_RequestId, @CopyId, @JobId, @JobType, @DrvPoolId, @mediaAgentId,
0, @RecordingFormatId, @volId, 0, 1, @i_IsForSwap,
																							@isDebug, @o_ErrorCode output, @o_FailureType output
			END
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			  goto exit_error
			end
			insert into @RMDriveView
			select DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId, LibrarySubType,
							SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0, DriveAttributes
			from	#tmpRMDriveViewWithOffline
			where	FailureErrorCode = 0
			order by Priority
			select @NumDriveViews = @@rowcount
			if (@jobOpType in (@DRIVECLEANING, @DRIVEVALIDATION)) and @driveId > 0
			begin
				if not exists (select DriveId from #tmpRMDriveViewWithOffline where DriveId = @driveId and FailureErrorCode = 0)
				begin
set @o_FailureType = 2
					select @o_ErrorCode = FailureErrorCode
					from #tmpRMDriveViewWithOffline
					where DriveId = @driveId
if @o_ErrorCode = 0
set @o_ErrorCode = 40008
					if (@jobOpType = @DRIVECLEANING)
						insert into RMLogger values ('RMReserveReaders', 'This is a drive cleaning job and the specified drive cannot be reserved', @i_RequestId, getutcdate())
					else
						insert into RMLogger values ('RMReserveReaders', 'This is a storage validation job and the specified drive cannot be reserved', @i_RequestId, getutcdate())
					goto exit_error
				end
				else
				begin
					delete @RMDriveView where DriveId <> @driveId
					set @NumDriveViews = 1
					if @isDebug > 0
						if (@jobOpType = @DRIVECLEANING)
							insert into RMLogger values('RMReserveReaders', 'This is drive cleaning job.', @i_RequestId, getutcdate())
						else
							insert into RMLogger values('RMReserveReaders', 'This is storage validation job.', @i_RequestId, getutcdate())
				end
			end
			if @isDebug > 0
			begin
				insert into RMLogger values ('RMReserveReaders',
								'There are total ['+ cast(isnull(@NumDriveViews, 0) as varchar(10)) + '] Drive availabe for volume ['
								+ cast(isnull(@volId, 0) as varchar(10)) + '] in this library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
								@i_RequestId, getutcdate())
				set @debugDetail = cast(isnull((select FailureErrorCode FailureReason, DataPathId, DrivePoolId, MasterPoolId,
																							LibraryId, HostClientId, MAClientId, DriveId
																				from #tmpRMDriveViewWithOffline
																				for XML RAW('DriveList'), TYPE), 'No Drive Available') as nvarchar(max))
				insert into RMLogger values('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
			end
			if @NumDriveViews <= 0
			begin
				-- Cannot do interruption in following cases
				if exists (select DriveId from #tmpRMDriveViewWithOffline
										where MediaId = @MediaId
and		FailureErrorCode in ( 20001,
20002,
20038))
				begin
					select @o_ErrorCode = FailureErrorCode
					from #tmpRMDriveViewWithOffline
					where MediaId = @MediaId
					insert into RMLogger values ('RMReserveReaders', 'The required media is in a drive that is either busy or offline. Therefore interruption cannot be performed', @i_RequestId, getutcdate())
					goto exit_error
				end
				declare @tmpErrorCode int
set @tmpErrorCode = 0
				set @numInterrupted = 0
exec @numInterrupted = RMHandleInterrupt @i_RequestId, @jobId, @priority, 2, 1, 1,
																									@PhaseFirstAttemptTime, @interruptInterval, @PreEmptable, 0, 0, 0, 0, 0, 0, @DrvPoolId, @driveId,
																									0,
																									@isDebug, @tmpErrorCode output
				if @@ERROR > 0
				begin
set @o_ErrorCode = 415
set @o_FailureType = 2
				  goto exit_error
				end
				if @numInterrupted > 0
				begin
					select	top 1 @DriveId = DriveId,
									@DrvPoolId = @DrvPoolId,
									@MasterPoolId = MasterPoolId,
									@LibraryId = LibraryId,
									@SpareGroupId = SpareGroupId
					from MMResource with (readuncommitted) where IntrJobId_l = @jobId
					set @HasJobInterrupted = 1
set @o_ErrorCode = 0
					if @isDebug > 0
					begin
						set @debugDetail = cast(isnull((
															select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.MediaId, a.DriveId, a.LibraryId
															from MMResource a	with (readuncommitted) where IntrJobId_l = @jobId
															for XML RAW('InterruptedDrive'), TYPE), 'No Interrupted Drive') as nvarchar(max))
						insert into RMLogger values ('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
					end
					goto exit_createReservation
				end
				-- No interruptible drive avaliable
				else
				begin
					insert into RMLogger values ('RMReserveReaders',
										'Error return because no drives or interruptible drives available for reserve in Library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
										@i_RequestId, getutcdate())
if @o_ErrorCode = 0
set @o_ErrorCode = 807
					goto exit_error
				end
			end
			else -- there is available drives
			begin
set @o_ErrorCode = 0
				if exists (select * from MMDrive with (readuncommitted) where MediaId = @mediaId and DriveSoftState = 1 and DriveId in (select DriveId from @RMDriveView))
				begin
					-- get a free drive
					select top 1 @DriveId = isnull(DriveId, 0) from MMDrive with (readuncommitted) where MediaId = @mediaId and DriveSoftState = 1 and DriveId in (select DriveId from @RMDriveView)
				end
				else
				begin
					select top 1 @DriveId = DriveId from @RMDriveView order by Priority
				end
				if @DriveId is not null and @DriveId > 0
				begin
					if @isDebug > 0
						insert into RMLogger values ('RMReserveReaders',
									'Drive['+ cast(isnull(@DriveId, 0) as varchar(20)) + '] is selected for reservation in Library ['
									+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
									@i_RequestId, getutcdate())
					goto exit_createReservation
				end
				insert into RMLogger values ('RMReserveReaders',
									'Error return because no drive available for reserve in Library ['+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
									@i_RequestId, getutcdate())
if @o_ErrorCode = 0 set @o_ErrorCode = 20040
				goto exit_error
			end
		end -- end of media is not reserved
  end -- end of reservation check for non-magnetic drive
done_drive:
exit_createReservation:
/*
	if @checkConcurrency > 0
	and exists (select CopyManagerCtrlId from MMDrivePool where DrivePoolId = @DrvPoolId
	begin
		declare @copyManagerId int
		set @cpoyManagerId = 0
		select	@copyManagerId = isnull(CMC.CopyManagerId, 0)
		from		MMCopyManagerCtrl as CMC, MMDrivePool as DP
		where		CMC.CopyManagerCtrlId = DP.CopyManagerCtrlId
		and			DP.DrivePoolId = @DrvPoolId
		if exists (select * from MMCopyManager
							 where	CopyManagerId = @copyManagerId
							 and		( ( CurrentConcurrency + 1 )< 0 or ( CurrentConcurrency + 1 > ConcurrencyLimit ))
		begin
set @o_ErrorCode = 303
			goto exit_error
		end
		else
		begin
			update MMCopyManager set CurrentConcurrency = CurrentConcurrency + 1
		end
	end
*/
  select @ClientId = ClientId, @MasterPoolId = MasterPoolId
  from MMDrivePool with (readuncommitted)
  where DrivePoolId = @DrvPoolId
  if (@LibraryId is null or @LibraryId = 0) and @MasterPoolId > 0
  begin
	select @LibraryId = LibraryId from MMMasterPool with (readuncommitted) where MasterPoolId = @MasterPoolId
  end
  select @LibraryTypeId = LibraryTypeId
  from MMLibrary with (readuncommitted)
  where LibraryId = @LibraryId
  -- Volume Id might be 0. In such case, reservation might already exist for volume id 0 but different drive.
  if @volId > 0
  begin
  	select top 1 @ReservationId = isnull(ReservationId, 0) from MMResource with (readuncommitted) where VolumeId = @volId
	end
	else
	begin
		set @ReservationId = 0
	end
	-- In the case of shared magnetic library, the volume can be used already by other media agent and drive pool.
	-- Now we might be required to use a differnt drive pool and media agent for current job.
	-- Try to reservation the volume using correct drive pool adn media agent.
	-- cliu 08/26/2013, MR 100307, DV job goes pending with reservation error on DSA enabled SP when auxcopy and DV is run at the same time
	-- In addition to the drive pool consideration, we need to check the passing-in Media Group id as well, which is decided by stream number.
	-- In DSA mode, different type of jobs (such as auxcopy and dv) may use different stream number for the same volume.
	-- But the lookup of new reservations is based on the source media group in the database. Any wrong matching will cause job points the resevation to different stream number.
	-- To prevent problem, only when the volume is reserved by the same media group id, we reuse the reservation.
	-- Otherwise, just create a new one with different source media group id.
	-- cliu 10/18/2013, MR 106274, Reconstruction job on DSA enabled copies may go pending in add records phase
	-- With previous change, a new reservation will be created even with the same job in this case.
	-- But from MM service and Reservation lookup, we don't have the ability to look up by media group. Any changes on that part will cause too much regression.
	-- So only do the above change for different job. Within on job, we still do multiplexing on the volume for the same drive pool, disregard the media group info.
	if @ReservationId > 0
and (@RecordingFormatId = 10001 or @RecordingFormatId = 11002)
  begin
  	if exists (select res.ReservationId from MMResource res WITH (NOLOCK), MMResourceToJob restojob WITH (NOLOCK)
				where res.VolumeId = @volId and res.DrivePoolId = @DrvPoolId
				and	  restojob.reservationId = res.reservationId
				and	  (restojob.jobId_l = @jobId or res.MediaGroupId = @mediaGrpId))
	begin
  		select top 1 @ReservationId = res.ReservationId
		from MMResource res WITH (NOLOCK), MMResourceToJob restojob WITH (NOLOCK)
		where res.VolumeId = @volId and res.DrivePoolId = @DrvPoolId
		and	  restojob.reservationId = res.reservationId
		and	  (restojob.jobId_l = @jobId or res.MediaGroupId = @mediaGrpId)
	end
	else
		set @ReservationId = 0
  end
	-- Find a Content Indexing engine and store the value to resourcetojob table.
	-- Additional CI job can do load-balance based on the existing reservations.
	DECLARE @CIEngineCoreId INT
	SET @CIEngineCoreId = 0
	DECLARE @CloudId		INT
	SET @CloudId = 0
	-- For file analytics job which is using CI job framework, use the given soruce media agent for Cloud and CI engine
	IF @jobOpType = @OFFLINECONTENTINDEX AND @isFLAJob != 0 AND @jobSubOpType <> @CONTENT_INDEXING_ENTITY_EXTRACTION
	BEGIN
		Declare @sourceMediaAgentId int = 0
Declare @indexServerClientId int = cast(dbo.GetJobOption(@jobId, 2101836446) as int)
		 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
					CREATE TABLE #getIndexServers
						(     serverURL NVARCHAR(512),
							  clientId INT,
							  clientName NVARCHAR(256),
							  cloudId INT,
							  hostName NVARCHAR(256),
							  basePort INT,
							  engineName  NVARCHAR(256),
							  serverType INT,
							  indexServerClientId INT,
							  internalCloudName NVARCHAR(256)
						)
EXEC DM2GetIndexServers 'Data Analytics', @indexServerClientId
		SELECT TOP 1 @CloudId = cloudId, @sourceMediaAgentId=ClientId  FROM #getIndexServers WHERE indexServerClientId = @indexServerClientId
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL    DROP TABLE #getIndexServers
		IF @CloudId IS NULL OR @CloudId <= 0
		BEGIN
			insert into RMLogger values ('RMReserveReaders',
					'Error return because cannot find Clould Information by the given source Media Agent for current File Analytics job.',
					@i_RequestId, getutcdate())
			set @isReservable = 0
if @o_ErrorCode = 0
set @o_ErrorCode = 20113
			goto exit_error
		END
		SELECT Top 1	@CIEngineCoreId = a.CoreId
		FROM	DM2SearchServerCoreInfo a WITH (READUNCOMMITTED), App_Client b WITH (READUNCOMMITTED), MMHost c WITH (READUNCOMMITTED)
		WHERE	a.CommCellId = @commcellid
		AND		a.CloudId = @CloudId
		AND		a.ClientId = @sourceMediaAgentId
		AND		a.ClientId = b.Id
AND		a.CoreRoles & 16 > 0
		AND		a.SoftState > 0
		AND		a.Enabled > 0
		AND		a.ClientId = c.ClientId
		AND		c.MMHostSoftState > 0
		AND		c.MMHostEnabled > 0
		IF @CIEngineCoreId IS NULL OR @CIEngineCoreId <= 0
		BEGIN
			insert into RMLogger values ('RMReserveReaders',
					'Error return because cannot find online Content Indexing engine/Media Agent by the given source Media Agent for current File Analytics job.',
					@i_RequestId, getutcdate())
			set @isReservable = 0
if @o_ErrorCode = 0
set @o_ErrorCode = 20114
			goto exit_error
		END
	END
	ELSE IF @jobOpType = @OFFLINECONTENTINDEX
	AND EXISTS (SELECT value FROM MMConfigs WITH (NOLOCK)
					WHERE NAME = 'MMCONFIG_RESOURCEMANAGER_CONTENTINDEX_PREFER_LOADBALANCE'
					AND		Value > 0
				)
	BEGIN
		DECLARE @CIEngineInfo TABLE
		(
			ErrorCode			INT,
			ErrorString			NVARCHAR(MAX),
			ClientId			INT,
			ClientName			NVARCHAR(MAX),
			CoreId				INT,
			CoreName			NVARCHAR(MAX)
		)
		--DECLARE @ArchGroupId	INT
		IF @copyId IS NOT NULL AND @copyId > 0
		BEGIN
			SELECT @ArchGroupId = ArchGroupId FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE Id = @copyId
		END
		ELSE
		BEGIN
			SET @ArchGroupId =
				(
					SELECT  top 1 archgroupid
					FROM	(SELECT TOP 1 Id, CommCellId FROM ArchChunk WITH (READUNCOMMITTED) WHERE VolumeId = @volId) chunk,
							ArchChunkMapping mapping WITH (READUNCOMMITTED),
							ArchGroupCopy copy WITH (READUNCOMMITTED)
					WHERE	chunk.Id = mapping.ArchChunkId
					AND		mapping.archCopyId = copy.Id
					AND		chunk.CommCellId = mapping.chunkCommcellId
				)
		END
		IF @MediaGrpId IS NULL OR @MediaGrpId <= 0
		BEGIN
			SELECT @MediaGrpId = MediaGroupId FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId
		END
		--Skip getting cloud id for entity extraction job
		IF @jobSubOpType <> @CONTENT_INDEXING_ENTITY_EXTRACTION
		BEGIN
		    IF @ArchGroupId > 0
		    BEGIN
			    SELECT @CloudId = CloudId FROM archContentIndexingRules WIHT (READUNCOMMITTED) WHERE ArchGroupId = @ArchGroupId
		    END
		    IF @CloudId IS NULL OR @CloudId <= 0
		    BEGIN
			    insert into RMLogger values ('RMReserveReaders',
					    'Error return because there is no Clould Information found for this offline Content Indexing job.',
					    @i_RequestId, getutcdate())
			    set @isReservable = 0
if @o_ErrorCode = 0
set @o_ErrorCode = 20113
			    goto exit_error
		    END
		    INSERT INTO @CIEngineInfo
		    EXEC DM2GetContentIndexEngineByCloud @commcellid, @CloudId, @ClientId, @jobId, @ArchGroupId, 0, @MediaGrpId
		    IF EXISTS (SELECT * FROM @CIEngineInfo WHERE ErrorCode != 0)
		    BEGIN
			    SELECT @debugDetail = CAST(ErrorString AS VARCHAR(MAX)) FROM @CIEngineInfo WHERE ErrorCode != 0
set @o_ErrorCode = ISNULL ((SELECT TOP 1 ErrorCode FROM @CIEngineInfo WHERE ErrorCode != 0), 0)
			    insert into RMLogger values ('RMReserveReaders', @debugDetail, @i_RequestId, getutcdate())
			    set @isReservable = 0
if @o_ErrorCode = 0
set @o_ErrorCode = 20114
			    goto exit_error
		    END
		    SELECT @CIEngineCoreId = CoreId FROM @CIEngineInfo WHERE ErrorCode = 0
        END
	END
  if @HasJobInterrupted = 1 or @ReservationId = 0
  begin
	  insert into MMResource (CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId,
			DrivePoolId, MasterPoolId, MediaGroupId, IntrJobId_h, IntrJobId_l, HasJobInterrupted,
			ReservationType, ReservationTime, Priority, PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
			DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId, NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId)
	  values(@copyId, 0, @volId, @mediaId, @DriveId, @ClientId,
			@DrvPoolId, @MasterPoolId, @MediaGrpId, 0, 0, @HasJobInterrupted,
			@rtype, dbo.GetUnixTime(getutcdate()), @priority, @preEmptable, 0, 0, 0, 0, 0, 0,
			0, @LibraryId, @LibraryTypeId, @SpareGroupId, @MountPathId, 0, @scheduleRunId, @doNotAllowOtherSchedule, 0, 0, 0)
	  set @ReservationId = @@identity
  end
  else
  begin
	  -- update resource table for the new multiplexing stream
	  update MMResource
	  set 	preEmptable = (case when @preEmptable = 0 then @preEmptable else preEmptable end),
					Priority = (case when Priority > @priority then @priority else Priority end)
	  where ReservationId = @ReservationId
  end
if exists (select * from MMResourceToJob with (readuncommitted) where ReservationId = @ReservationId and (ReserveBitMask & 2 > 0))
  begin
set @rsvBitMask = @rsvBitMask | 2
  end
  select @RCID = next_l + 1 from GXCounter where name = 'RCID_Counter'
  if @RCID is NuLL
  begin
  	insert into GXCounter select 'RCID_Counter', 0, 1
  	set @RCID = 1
  end
  update GXCounter set next_l = @RCID where name = 'RCID_Counter'
  insert into MMResourceToJob (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
		ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
		DestMediaGroupId, LogicalReleased, Flag, CIEngineCoreId)
  values(@ReservationId, 0, @jobId, @priority, @preEmptable, (case when @HasJobInterrupted > 0 then 1 else @isInUse end),
		@rsvBitMask, 0, @rtype, @RCID, 0, @clientTokenId,
		@destinationMediaGroupId, 0, 0, @CIEngineCoreId)
	INSERT INTO RMReservations
	SELECT	c.RCID, c.ReservationId, @i_RequestId, c.JobId_l, c.Priority, c.ReservationType, b.ReservationTime,
					b.CopyId, b.StreamId, b.VolumeId, b.MediaId, b.ScheduleRunId, b.NoOtherSchedule,
					b.SpareGroupId, b.MountPathId, b.DriveId, b.ClientId, b.DrivePoolId, b.MasterPoolId, b.LibraryId, b.LibraryTypeId,
					b.MediaGroupId, b.ResourceFlag, b.DriveInUseByDM, b.Released,
					c.PreEmptable, c.InUse, c.ReleaseTime, c.PrimaryRCID, c.ClientTokenId, c.DestMediaGroupid, c.LogicalReleased, b.IntrJobId_l
	FROM		MMResource b with (readuncommitted), MMResourceToJob c with (readuncommitted)
	WHERE		c.ReservationId = b.ReservationId
	AND			c.RCID = @RCID
 	SET @o_ReservationList =
	(
			SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId], [copyRsrvList!1!driveId], [copyRsrvList!1!hostId], [copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
					[rcidList!2!val]
			from (
			SELECT	1			          as TAG,
				NuLL									as Parent,
				NuLL									as [copyRsrvList!1],
				res.ReservationId			as [copyRsrvList!1!reservationId],
				res.CopyId						as [copyRsrvList!1!copyId],
				res.StreamId					as [copyRsrvList!1!streamNum],
				res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
				res.DriveId						as [copyRsrvList!1!driveId],
				res.ClientId					as [copyRsrvList!1!hostId],
				res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
				res.VolumeId					as [copyRsrvList!1!volumeId],
				@archGroupName				as [copyRsrvList!1!archGroupName],
				@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
				l.AliasName						as [copyRsrvList!1!libraryName],
				dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
				c.Name								as [copyRsrvList!1!mediaAgentName],
				d.AliasName						as [copyRsrvList!1!driveName],
				res.MediaId						as [copyRsrvList!1!mediaId],
				m.Barcode							as [copyRsrvList!1!mediaBarcode],
				NULL									as [rcidList!2!val]
				FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted), App_Client c with (readuncommitted),
				MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
				WHERE	res.ReservationId = resToJob.ReservationId AND resToJob.RCID = @RCID
				AND		res.LibraryId = l.LibraryId
				AND		res.DrivePoolId = dp.DrivePoolId
				AND		res.ClientId = c.Id
				AND		res.DriveId = d.DriveId
				AND		res.MediaId = m.MediaId
			UNION ALL
			SELECT	2			          as TAG,
				1											as Parent,
				NuLL									as [copyRsrvList!1],
				res.ReservationId			as [copyRsrvList!1!reservationId],
				res.CopyId						as [copyRsrvList!1!copyId],
				res.StreamId					as [copyRsrvList!1!streamNum],
				res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
				res.DriveId						as [copyRsrvList!1!driveId],
				res.ClientId					as [copyRsrvList!1!hostId],
				res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
				res.VolumeId					as [copyRsrvList!1!volumeId],
				@archGroupName				as [copyRsrvList!1!archGroupName],
				@archGroupCopyName		as [copyRsrvList!1!archGroupCopyName],
				l.AliasName						as [copyRsrvList!1!libraryName],
				dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
				c.Name								as [copyRsrvList!1!mediaAgentName],
				d.AliasName						as [copyRsrvList!1!driveName],
				res.MediaId						as [copyRsrvList!1!mediaId],
				m.Barcode							as [copyRsrvList!1!mediaBarcode],
				resToJob.RCID					as [rcidList!2!val]
				FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted), MMLibrary l with (readuncommitted), App_Client c with (readuncommitted),
				MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted)
				WHERE	res.ReservationId = resToJob.ReservationId AND resToJob.RCID = @RCID
				AND		res.LibraryId = l.LibraryId
				AND		res.DrivePoolId = dp.DrivePoolId
				AND		res.ClientId = c.Id
				AND		res.DriveId = d.DriveId
				AND		res.MediaId = m.MediaId
			) a
			ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId],  [copyRsrvList!1!driveId], [copyRsrvList!1!hostId],  [copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
					[rcidList!2!val]
			FOR XML EXPLICIT, TYPE
	)
		set @debugDetail = cast(isnull((select @ReservationId RID, @RCID RCID, @copyId CopyId, @DrvPoolId DrivePoolId,
															@DriveId DriveId, @MediaGrpId MediaGroupId, @volId VolumeId,
															@mediaId MediaId, @MountPathId MountPathId
											for XML RAW('ReadReservation'), TYPE), 'No Read Reservation') as nvarchar(max))
		insert into RMLogger values ('Resource   Reserved', @debugDetail, @i_RequestId, getutcdate())
	select @o_ReservationId = @ReservationId, @o_DriveId = @DriveId, @o_RCId = @RCId
exit_error:
  if @HasJobInterrupted = 1
  begin
set @o_ErrorCode = 20005
set @o_FailureType = 2
  end
if @o_ErrorCode != 0
	begin
		declare @errorList xml
		set @errorList = ''
		if @isReservable = 0
		begin
			SET @errorList =
			(
				SELECT	1	          as TAG,
					NuLL									as Parent,
					NuLL									as [errorList!1],
					@o_ErrorCode					as [errorList!1!failureCode],
					NULL									as [errorList!1!failureType],
					NULL									as [errorList!1!datapathId],
					NULL									as [errorList!1!libraryName],
					NULL									as [errorList!1!drivePoolName],
					NULL									as [errorList!1!mediaAgentName],
					NULL									as [errorList!1!driveId],
					NULL									as [errorList!1!driveName],
					CASE WHEN @MediaId IS NULL THEN NULL
							ELSE (SELECT Barcode FROM MMMedia with (readuncommitted) WHERE MediaId = @MediaId) END
																as [errorList!1!mediaBarcode]
				FOR XML EXPLICIT, TYPE
			)
		end
		else if exists (select * from #tmpRMDriveViewWithOffline)
		begin
			SET @errorList =
			(
				SELECT	TOP 3
					 1	          as TAG,
					NuLL									as Parent,
					NuLL									as [errorList!1],
					a.FailureErrorCode		as [errorList!1!failureCode],
					NULL									as [errorList!1!failureType],
					@CopyId									as [errorList!1!copyId],
					NULL									as [errorList!1!datapathId],
					l.AliasName						as [errorList!1!libraryName],
					d.DrivePoolName				as [errorList!1!drivePoolName],
					c.Name								as [errorList!1!mediaAgentName],
					CASE WHEN a.MountPathId IS NULL OR a.MountPathId = 0 THEN NULL ELSE a.MountPathId END as [errorList!1!driveId],
					CASE WHEN a.MountPathId IS NULL OR a.MountPathId = 0 THEN NULL ELSE (SELECT TOP 1 MountPathName FROM MMS2getMountPathList with (NOLOCK) WHERE MountPathId = a.MountPathId AND ClientId = a.HostClientId) END as [errorList!1!driveName],
					CASE WHEN @MediaId IS NULL THEN NULL
							ELSE (SELECT Barcode FROM MMMedia with (readuncommitted) WHERE MediaId = @MediaId) END
																as [errorList!1!mediaBarcode]
				FROM	#tmpRMDriveViewWithOffline a, MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
				WHERE	(@DriveId = 0 OR @DriveId = a.DriveId)
				AND		a.FailureErrorCode != 0
				AND		a.LibraryId = l.LibraryId
				AND		a.DrivePoolId = d.DrivePoolId
				AND		a.HostClientId = c.Id
				ORDER BY a.Priority
				FOR XML EXPLICIT, TYPE
			)
		end
		else
		begin
			SET @errorList =
			(
				SELECT	1	          as TAG,
					NuLL									as Parent,
					NuLL									as [errorList!1],
					@o_ErrorCode							as [errorList!1!failureCode],
					NULL									as [errorList!1!failureType],
					@CopyId									as [errorList!1!copyId],
					a.DataPathId					as [errorList!1!datapathId],
					l.AliasName						as [errorList!1!libraryName],
					d.DrivePoolName				as [errorList!1!drivePoolName],
					c.Name								as [errorList!1!mediaAgentName],
					@DriveId							as [errorList!1!driveId],
					CASE WHEN @DriveId IS NULL THEN NULL
							ELSE (SELECT AliasName	FROM MMDrive with (readuncommitted) WHERE DriveId = @DriveId) END
																as [errorList!1!driveName],
					CASE WHEN @MediaId IS NULL THEN NULL
							ELSE (SELECT Barcode FROM MMMedia with (readuncommitted) WHERE MediaId = @MediaId) END
																as [errorList!1!mediaBarcode]
				FROM	RMDataPathView a, MMLibrary l with (readuncommitted), MMDrivePool d with (readuncommitted), App_Client c with (readuncommitted)
				WHERE	a.LibraryId = l.LibraryId
				AND		a.DrivePoolId = d.DrivePoolId
				AND		a.HostClientId = c.Id
				ORDER BY a.priority
				FOR XML EXPLICIT, TYPE
			)
		end
		set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(isnull(@errorList, '') as nvarchar(max))
	end
	DROP TABLE #tmpRMDriveViewWithOffline
  insert into RMLogger values ('RMReserveReaders',
  				'Exit with ErrorCode['+ cast(@o_ErrorCode as varchar(20)) + '], FailureType['+ cast(@o_FailureType as varchar(20)) + ']...',
  				@i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveReaders')
	delete from GxQscripts where name = 'RMReserveReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveReaders')
	delete from GXDBVersions where aliasname = 'RMReserveReaders'
GO

insert into GXDBVersions values(2, 'RMReserveReaders',  '00010077001400190000', 'RMReserveReaders', '00010077001400190000')
GO

