

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForRestore.sp,v $ $Id: RMReserveForRestore.sp,v 1.26.2.9 2020/05/23 13:39:04 kbora Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForRestore()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReserveForRestore')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveForRestore <<<'
	drop procedure RMReserveForRestore
END
IF EXISTS (select * from GxQscripts where name='RMReserveForRestore')
	delete from GxQscripts where name = 'RMReserveForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForRestore')
	delete from GXDBVersions where aliasname = 'RMReserveForRestore'
GO
print '... Creating Procedure: RMReserveForRestore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveForRestore
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationId integer;
  DECLARE @o_DriveId integer;
  DECLARE @o_RCId integer;
  DECLARE @o_ReservationList NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  DECLARE @ReqDriveId 		INTEGER
  SET 		@ReqDriveId 		= 0
  DECLARE @jobId		INT = 0
  DECLARE @copyId		INT = 0
  DECLARE @jobOpType	INT = 0
  declare @retCode INT = 0
  DECLARE @xmlParams	XML
  SELECT  @xmlParams = xmlParams
  FROM 	RMReservationRequest
  WHERE RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmReserveVolAndDriveArgs_t') > 0
		BEGIN
			SELECT	@ReqDriveId = params.value('@driveId', 'int'),
					@jobId		= params.value('@jobId', 'bigint'),
					@jobOpType  = params.value('@jobOpType', 'int'),
					@copyId		= params.value('@copyId', 'int')
			FROM	@xmlParams.nodes('/ResourceManager_RmReserveVolAndDriveArgs_t[1]') AS R(params)
		END
		ELSE IF @xmlParams.exist('/ResourceManager_RmExchangeVolumeArgs_t') > 0
		BEGIN
			SELECT	@ReqDriveId = params.value('@driveId', 'int'),
					@jobId		= params.value('@jobId', 'bigint'),
					@jobOpType  = params.value('@jobOpType', 'int'),
					@copyId		= params.value('@copyId', 'int')
			FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]/newArgs[1]') AS R(params)
		END
	END
	if @ReqDriveId < 0
		set @ReqDriveId = 0
	if @jobOpType is null or @jobOpType = 0
	begin
  		set @jobOpType = dbo.GetJobTypeForJobID(@jobId)
	end
	set @o_ReservationList = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	declare @sourceReservationResults XML
	set @o_ReservationId = 0
	set @o_DriveId = 0
	set @sourceReservationResults = ''
	DECLARE @l_SubmitDriveReqToLS		INTEGER
	SET			@l_SubmitDriveReqToLS		= 0
	DECLARE @l_LSOfflineDriveCnt		INTEGER
	SET			@l_LSOfflineDriveCnt		= 0
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	DECLARE @ARCHIVECHECK 						INTEGER
	SET 	@ARCHIVECHECK  						= 31		-- Data Verification
	DECLARE @ARCHIVECHECK2 						INTEGER
	SET 	@ARCHIVECHECK2 						= 106 		-- Data Verfication(Dash)
	DECLARE @l_SubmitPowerOnReqToVM				INTEGER
	SET		@l_SubmitPowerOnReqToVM				= 0
	DECLARE @l_PMOfflineVMCount					INTEGER
	SET		@l_PMOfflineVMCount					= 0
	DECLARE @l_PMOfflineDDBVMCount				INTEGER
	SET		@l_PMOfflineDDBVMCount				= 0
	DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
	SET		@HOST_STATUS_POWER_MANAGED_VM		= 7
	DECLARE @tblVMPowerOnReq TABLE (
	RMRequestId			INT,
	HostId				INT,
	jobId 				INT,
	commCellId 			INT,
	isForDDB	 		INT,
	hostSoftState		INT,
	hostOfflineReason 	INT,
	PRIMARY KEY (jobId, HostId, isForDDB)
	)
	--Create and populate the shared temp table before submitting the request
	if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null DROP TABLE #tmpVMPowerOnReq
	CREATE TABLE #tmpVMPowerOnReq (
			RMRequestId		INT,
			HostId			INT,
			jobId 			INT,
			commCellId 		INT,
			PRIMARY KEY (jobId, HostId)
		)
	DECLARE @tblLibServerDriveReq TABLE (
		jobId 			INT,
		commCellId 	INT,
		libraryId		INT,
		driveNumber VARCHAR(MAX),
		driveCnt		INT,
		PRIMARY KEY (jobId, commCellId, libraryId)
	)
	SAVE TRANSACTION RESTORE_RESERVATION_TRANS
	if @i_isDebug > 0
	  insert into RMLogger values ('RMReserveForRestore', 'Enter...', @i_RequestId, getutcdate())
	exec @o_ErrorCode = RMReserveReaders @i_RequestId, 0, @i_isDebug,
																			@o_ReservationId output, @o_DriveId output, @o_RCId output,
																			@sourceReservationResults output,
																			@o_ErrorCode output, @o_FailureType output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	end
if @o_ErrorCode != 0
	--and @o_ErrorCode != E_MM_NO_RESOURCE_INTERRUPTED_JOB
	begin
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForRestore', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	  goto exit_error
	end
	--Check if any offline LS drives are reserved for restores
	SELECT @l_LSOfflineDriveCnt = COUNT(DISTINCT RES.driveId)
	FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.LibraryId = L.LibraryId
	AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	AND		RES.DriveId = D.driveId
	AND 	D.DriveSoftState <> 1
	AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	IF @l_LSOfflineDriveCnt > 0
	BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
		SET @l_SubmitDriveReqToLS = 1
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForRestore', 'Reservation for restore return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		goto exit_error
	END
	-- check if any offline power managed VMs are reserved for read.
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, RES.ClientId, RES.JobId, 2, 0, H.MmHostSoftState, H.OfflineReason
	FROM  RMReservations RES WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.ClientId = H.ClientId
AND 	H.Attribute & 32768 = 32768
	SELECT @l_PMOfflineVMCount = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	IF @jobOpType IN ( @ARCHIVECHECK, @ARCHIVECHECK2 )
	--In JMAdminJobInfoTable table if cloudid column is greater than 0 means it is DDB verification job.
	AND EXISTS (SELECT 1 FROM JMAdminJobInfoTable WITH (NOLOCK) WHERE jobId = @jobId AND cloudId > 0)
	BEGIN
		DECLARE @tblStores TABLE (SIDBStoreId int)
		INSERT INTO @tblStores
		SELECT cloudId FROM JMAdminJobInfoTable WITH (NOLOCK)
		WHERE jobId = @jobId AND cloudId > 0
		IF @@ROWCOUNT = 0 AND @copyId > 0
		BEGIN
			INSERT INTO @tblStores
			SELECT 	SIDBStoreId
			FROM	ArchCopySIDBStore WITH (NOLOCK)
WHERE 	copyId = @copyId AND flags & 4 > 0
		END
		IF EXISTS(SELECT 1 FROM @tblStores)
		BEGIN
			INSERT INTO @tblVMPowerOnReq
			SELECT DISTINCT @i_RequestId, HOST.ClientId, @jobId, 2, 1, HOST.MmHostSoftState, HOST.OfflineReason
			FROM IdxSIDBSubStore subStore WITH (NOLOCK)
				INNER JOIN MMHost HOST WITH (NOLOCK) ON HOST.ClientId = subStore.ClientId
				INNER JOIN IdxCache idxc WITH (NOLOCK) ON idxc.IdxCacheId = subStore.IdxCacheId
				INNER JOIN IdxAccessPath idxa WITH (NOLOCK) ON idxa.IdxAccessPathId = subStore.IdxAccessPathId
				INNER JOIN @tblStores S ON subStore.SIDBStoreId = S.SIDBStoreId
			WHERE HOST.MMHostEnabled <> 0
				AND idxc.Enabled <> 0
				AND idxa.Enabled <> 0
AND HOST.Attribute & 32768 > 0
				AND NOT EXISTS ( SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
										INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
								 WHERE VM.HostId = HOST.ClientId AND VM.FailureReason = 2
AND VMMAP.EntityId = @jobId AND VMMAP.EntityType = 1
								)
			AND NOT EXISTS (SELECT 1 FROM @tblVMPowerOnReq tmp WHERE tmp.HostId = HOST.ClientId)
		SELECT @l_PMOfflineDDBVMCount = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
		END
	END
	IF @l_PMOfflineVMCount > 0 OR @l_PMOfflineDDBVMCount > 0
	BEGIN
SET @o_ErrorCode = 346
SET @o_FailureType = 1
		SET @l_SubmitPowerOnReqToVM = 1
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForRestore', 'Reservation for restore return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		goto exit_error
	END
exit_error:
	if @sourceReservationResults is not null and len(cast(@sourceReservationResults as nvarchar(max))) > 0
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@sourceReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
	--Dump the required data into table before Rollback
	IF @l_SubmitDriveReqToLS > 0
	BEGIN
		DECLARE @preferredDriveList TABLE (DrivePoolId INT, DriveNumberList VARCHAR(MAX))
		INSERT INTO @preferredDriveList
		SELECT	DISTINCT Res.DrivePoolId, ''
		FROM	RMreservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
		WHERE	RES.RequestId = @i_RequestId
		AND		RES.LibraryId = L.LibraryId
		AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
		UPDATE @preferredDriveList
		SET		DriveNumberList = (
									SELECT CAST(Drive.DriveNumber AS VARCHAR(10)) + ',' AS [text()]
									FROM	MMDriveController DC WITH (NOLOCK), MMDrive Drive WITH (NOLOCK)
									WHERE	DC.DrivePoolId = P.DrivePoolId
									AND		DC.DriveId = Drive.DriveId
									AND		Drive.DriveBroken = 0
									AND		Drive.DriveEnabled = 1
AND		MountStatus not in (4, 2, 3)
									AND		((Drive.DriveSoftState = 1)
											OR
											(Drive.DriveSoftState <> 1 AND Drive.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER))
									FOR XML PATH('')
								)
		FROM	@preferredDriveList P
		INSERT INTO @tblLibServerDriveReq
		SELECT RES.JobId, 2, RES.LibraryId,
				CASE WHEN @ReqDriveId > 0 THEN CAST(D.driveNumber AS VARCHAR(10)) ELSE P.DriveNumberList END,
				COUNT(DISTINCT RES.DriveId)
		FROM 	RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK), @preferredDriveList P
		WHERE 	RES.RequestId = @i_RequestId
		AND		RES.LibraryId = L.LibraryId
		AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
		AND		RES.DriveId = D.driveId
		AND 	D.DriveSoftState <> 1
AND		D.MountStatus not in (4, 2, 3)
		AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
        AND     RES.DrivePoolId = P.DrivePoolId
		GROUP BY RES.JobId, RES.LibraryId,
				CASE WHEN @ReqDriveId > 0 THEN CAST(D.driveNumber AS VARCHAR(10)) ELSE P.DriveNumberList END
	END
	IF @l_SubmitDriveReqToLS > 0 OR @l_SubmitPowerOnReqToVM > 0
	BEGIN
		declare @tempLog table
		(
				RMModule	varchar(100),
				State		varchar(max),
				RequestId	integer,
				TimeStamp	datetime
		)
		insert into @tempLog
		select RMModule, State, RequestId, TimeStamp
		from	 RMLogger with (readuncommitted)
		where		RequestId = @i_RequestId
		ROLLBACK TRANSACTION RESTORE_RESERVATION_TRANS
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		IF @l_SubmitDriveReqToLS > 0
		BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveForRestore', 'Submitting request for shared drives to library server due to error ['
																+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			--Create and populate the shared temp table before submitting the request
			if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
			CREATE TABLE #tmpLibServerDriveReq (
				RMRequestId		INT,
				jobId 				INT,
				commCellId 		INT,
				libraryId			INT,
				driveNumber 	VARCHAR(MAX),
				driveCnt			INT,
				PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId)
			)
			INSERT INTO #tmpLibServerDriveReq
			SELECT 0, jobId, commCellId, libraryId, driveNumber, driveCnt
			FROM @tblLibServerDriveReq
			EXEC @o_ErrorCode = RMSubmitLSDriveRequest 0
			IF @o_ErrorCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForRestore', 'Failed to submit request for shared drives to library server due to error ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode = 415
set @o_FailureType = 2
			END
			ELSE
			BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForRestore', 'Successfully submitted request for shared drives to library server - Error Code['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			END
		END
		IF @l_SubmitPowerOnReqToVM > 0
		BEGIN
			IF @l_PMOfflineVMCount > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForRestore', 'Submitting cloud VM power on request due to the reason ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				INSERT INTO #tmpVMPowerOnReq
				SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
				FROM @tblVMPowerOnReq WHERE isForDDB = 0 AND hostSoftState <> 1
				EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
				IF @o_ErrorCode > 0
				BEGIN
					IF @i_isDebug > 0
						  INSERT INTO RMLogger values('RMReserveForRestore', 'Failed to submit cloud VM power on request due to error ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
SET @o_ErrorCode 		= 415
SET @o_FailureType 	= 2
				END
				ELSE
				BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
					IF @i_isDebug > 0
						  INSERT INTO RMLogger VALUES('RMReserveForRestore', 'Successfully submitted cloud VM power on request - Error Code['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				END
				DELETE FROM #tmpVMPowerOnReq
			END
			IF @l_PMOfflineDDBVMCount > 0
			BEGIN
				IF @i_isDebug > 0
					  INSERT INTO RMLogger VALUES('RMReserveForRestore', 'Submitting DDB cloud VM power on request due to the reason ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				INSERT INTO #tmpVMPowerOnReq
				SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
				FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1
				EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
				IF @o_ErrorCode > 0
				BEGIN
					IF @i_isDebug > 0
						  INSERT INTO RMLogger VALUES('RMReserveForRestore', 'Failed to submit DDB cloud VM power on request due to error ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
SET @o_ErrorCode 		= 415
SET @o_FailureType 	= 2
				END
				ELSE
				BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
					IF @i_isDebug > 0
						  INSERT INTO RMLogger VALUES('RMReserveForRestore', 'Successfully submitted DDB cloud VM power on request - Error Code['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				END
				DELETE FROM #tmpVMPowerOnReq
			END
		END
	END
IF @o_ErrorCode = 0
	AND EXISTS (SELECT 1 FROM @tblVMPowerOnReq WHERE hostSoftState <> 0)
	BEGIN
		DECLARE @MAList varchar(1024) = ''
		SELECT  @MAList = @MAList + name + + ', '
		FROM    APP_Client A WITH (NOLOCK) INNER JOIN @tblVMPowerOnReq B ON A.id = B.HostId
		WHERE	hostSoftState <> 0
		IF @i_isDebug > 0
			insert into RMLogger values('RMReserveForRestore', 'Reserved power managed MAs, recording the usage for the MAs [' + @MAList + '].', @i_RequestId, getutcdate())
		INSERT INTO #tmpVMPowerOnReq
		SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
		FROM @tblVMPowerOnReq WHERE hostSoftState <> 0
		-- This sp does not submit power on request if the MA is already online, it records the last used time of this MA so that MM service can decide when to auto power off the VM.
		EXEC @retCode = RMSubmitVMPowerONRequest 0
		IF @retCode > 0
		BEGIN
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveForRestore', 'Failed to record the power managed MAs usage for the MAs ['	+ @MAList + '] with retCode [ '+ @retCode +' ] .', @i_RequestId, getutcdate())
set @o_ErrorCode 		= 415
set @o_FailureType 	= 2
		END
		DELETE FROM #tmpVMPowerOnReq
	END
	-- For dash copy reservation, mark the stream status as fail before update reservation request
if @o_ErrorCode != 0
	and exists (SELECT 1 FROM ArchJobStreamStatus WITH (NOLOCK) WHERE ReservationRequestId = @i_RequestId)
	begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE ReservationRequestId = @i_RequestId
	end
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
  where RequestId = @i_RequestId
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
		  select top 1 ErrorCode, FailureType, @o_ReservationId, @o_DriveId, @o_RCId, @o_ReservationList
		  from RMReservationRequest
		where RequestId = @i_RequestId
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
  end
	*/
	if @i_isDebug > 0
	  insert into RMLogger values('RMReserveForRestore', 'Exit...', @i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveForRestore')
	delete from GxQscripts where name = 'RMReserveForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForRestore')
	delete from GXDBVersions where aliasname = 'RMReserveForRestore'
GO

insert into GXDBVersions values(2, 'RMReserveForRestore',  '00010026000200090000', 'RMReserveForRestore', '00010026000200090000')
GO

