

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForLoadBalanceBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForLoadBalanceBackup.sp,v $ $Id: RMReserveForLoadBalanceBackup.sp,v 1.6.2.6 2018/03/19 23:56:36 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForLoadBalanceBackup()
--	|
--	| Provide ability for true load-balance among all the data paths.
--	| 1. Available data paths depend on the existing data path configurations.
--	|		Using perferred data paths will allow load-balance on all the perferred data paths.
--	|		Using Round-Robin and failover will allow load-balance on all the data paths.
--	|		Using subclient data path will allow load-balance only on subclient data paths.
--	| 2. No interruption support.
--	| 3. No inline copy support.
--	| 4. No library server support.
--	| 5.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMReserveForLoadBalanceBackup <<<'

IF EXISTS (select * from sysobjects where name='RMReserveForLoadBalanceBackup')
	drop procedure RMReserveForLoadBalanceBackup
IF EXISTS (select * from GxQscripts where name='RMReserveForLoadBalanceBackup')
	delete from GxQscripts where name = 'RMReserveForLoadBalanceBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForLoadBalanceBackup')
	delete from GXDBVersions where aliasname = 'RMReserveForLoadBalanceBackup'
GO
print '... Creating Procedure: RMReserveForLoadBalanceBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveForLoadBalanceBackup
  @i_RequestId int,
  @i_jobId bigint,
  @i_CopyId int,
  @i_isDebug int,
  @o_ReservationList XML OUTPUT,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	IF @i_RequestId = 0 OR @i_jobId = 0 OR @i_CopyId = 0
		GOTO exit_error
SAVE TRANSACTION LOAD_BALANCE_RESERVATION_TRANS
	DECLARE @xmlParams XML
	SELECT @xmlParams = xmlParams FROM RMReservationRequest WHERE RequestId = @i_RequestId
	DECLARE @numberOfStreams INT
	SET @numberOfStreams = 0
	DECLARE @bestcaseReserve INT
	SET @bestcaseReserve = 0
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t') > 0
		BEGIN
			IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t[1]/copyIdList') > 0
			AND @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t[1]/copyIdList[@val != sql:variable("@i_copyId")]') > 0
				GOTO exit_error
			SELECT	@numberOfStreams = params.value('@numStreams', 'int'),
					@bestcaseReserve = isnull(params.value('@bestcaseReserve', 'int'), 0)
			FROM	@xmlParams.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
			IF @numberOfStreams IS NULL OR @numberOfStreams <= 1
				GOTO exit_error
		END
	END
	ELSE
	BEGIN
		GOTO exit_error
	END
SET @o_ErrorCode = 0
SET @o_FailureType = 2
	SET @o_ReservationList = ''
	DECLARE @canCommitReservations int
	DECLARE @howManySuccessReservations int
	SET @canCommitReservations = 0
	SET @howManySuccessReservations = 0
	DECLARE @l_SubmitDriveReqToLS		INTEGER
	SET			@l_SubmitDriveReqToLS		= 0
	DECLARE @l_LSOfflineDriveCnt		INTEGER
	SET			@l_LSOfflineDriveCnt		= 0
	DECLARE @l_LSOfflineDriveCntWithInlineCopy		INTEGER
	SET			@l_LSOfflineDriveCntWithInlineCopy		= 0
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	DECLARE @tblLibServerDriveReq TABLE (
		mediaGroupId		INT,
		jobId 			INT,
		commCellId 	INT,
		libraryId		INT,
		driveNumber VARCHAR(MAX),
		driveCnt		INT,
		PRIMARY KEY (mediaGroupId, jobId, commCellId, libraryId)
	)
	DECLARE @reservationResults XML
	SET @reservationResults = ''
	DECLARE @oneStreamRequestId INT
	SET @oneStreamRequestId = 0
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@numStreams)[1] with "1"')
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@isForRemainingStreams)[1] with "0"')
	WHILE @numberOfStreams > 0
	BEGIN
		set @reservationResults = ''
SET @o_ErrorCode = 0
SET @o_FailureType = 2
		INSERT INTO RMReservationRequest
		(
			ErrorCode, FailureType, RequestTime, FailureAttempts, ShouldFailRequest, MaxNumOfAttempts, MaxNumOfReservedStreams,
			JobId, CommCellId, ScheduleRunId,
			UseSCDataPath,
			JobType, JobOpType, iDAType,
			PhaseFirstAttemptTime, CopyId, Priority, RequestCategory,
			RegistrySetting,
			XmlParams,
			ReservationResults
		)
		SELECT
0, 0, -1, FailureAttempts, ShouldFailRequest, 1, MaxNumOfReservedStreams,
			JobId, CommCellId, ScheduleRunId,
			UseSCDataPath,
			JobType, JobOpType, iDAType,
			PhaseFirstAttemptTime, @i_CopyId, Priority, RequestCategory,
			RegistrySetting,
			cast(@xmlParams as nvarchar(4000)),
			''
		FROM RMReservationRequest
		WHERE RequestId = @i_RequestId
		SELECT @oneStreamRequestId = SCOPE_IDENTITY()
		if @i_isDebug > 0
			insert into RMLogger values ('RMReserveForLoadBalanceBackup', 'Enter For Job['+ cast(@i_jobId as varchar(20)) + ']', @oneStreamRequestId, getutcdate())
		-- Interruption is turned off here.
		exec @o_ErrorCode = RMReserveWriters @oneStreamRequestId, 0, 0, @i_isDebug, @reservationResults output, @o_ErrorCode output, @o_FailureType output
		if @@ERROR > 0
		begin
set @o_ErrorCode = 415
set @o_FailureType = 2
		end
		update RMLogger set requestId = @i_RequestId where requestId = @oneStreamRequestId
		update RMReservations set RequestId = @i_RequestId where requestId = @oneStreamRequestId
		update RMReservationRequest set requestTime = -1 where requestId = @oneStreamRequestId
if @o_ErrorCode = 0
		begin
			set @howManySuccessReservations = @howManySuccessReservations + 1
		end
		-- For old RM logic, return the reservation string directly. Otherwise, check the size.
		-- One reservation attempt fails, there is no need for more tries.
		IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
		begin
			-- If best case reserve is false, then it requires all the streams.
			-- When fails, return directly with the last failure reason
			-- When succeeds, continue and ignore any failure messsage
if @o_ErrorCode = 0
			begin
				set @o_ReservationList =  'EMPTY_RESULTS'
			end
			else
			begin
				if @howManySuccessReservations > 0 and @bestcaseReserve > 0
				begin
					set @canCommitReservations = 1
set @o_ErrorCode = 0
					set @o_ReservationList =  'EMPTY_RESULTS'
				end
				else
				begin
					set @canCommitReservations = 0
					set @o_ReservationList = cast(@reservationResults as nvarchar(max))
				end
				if @i_isDebug > 0
					insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Reservation for backup return error code ['
																+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				goto exit_error
			end
		end
		else
		begin
			set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
if @o_ErrorCode != 0
			begin
				if @howManySuccessReservations > 0 and @bestcaseReserve > 0
				begin
					set @canCommitReservations = 1
set @o_ErrorCode = 0
				end
				else
				begin
					set @canCommitReservations = 0
				end
				if @i_isDebug > 0
					  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Reservation for backup return error code ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				goto exit_error
			end
		end
		set @numberOfStreams = @numberOfStreams - 1
	END
	--Check if any offline LS drives are reserved for Primary copy
	SELECT @l_LSOfflineDriveCnt = COUNT(DISTINCT RES.driveId)
	FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.LibraryId = L.LibraryId
	AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	AND		RES.DriveId = D.driveId
	AND 	D.DriveSoftState <> 1
	AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	IF @l_LSOfflineDriveCnt > 0
	BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
		SET @l_SubmitDriveReqToLS = 1
		SET @canCommitReservations = 0
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		SET @howManySuccessReservations = 0
	END
	--ELSE
	--	SET @howManySuccessReservations = 1
IF ((@howManySuccessReservations > 0) AND @o_ErrorCode = 0)
	BEGIN
		SET @canCommitReservations = 1
	END
exit_error:
	if @o_ReservationList is not null and len(cast(@o_ReservationList as nvarchar(max))) > 0
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@o_ReservationList as nvarchar(max)) + '</ResourceManager_ReservationList>'
	declare @tempLog table
	(
			RMModule	varchar(100),
			State		varchar(max),
			RequestId	integer,
			TimeStamp	datetime
	)
	if @canCommitReservations > 0
	begin
	  update RMReservationRequest
	  set ErrorCode = @o_ErrorCode,
			FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
      		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
 			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
	  where RequestId = @i_RequestId
	end
	else
	begin
		insert into @tempLog
		select RMModule, State, RequestId, TimeStamp
		from	 RMLogger with (readuncommitted)
		where		RequestId = @i_RequestId
		--Dump the required data into table before Rollback
		IF @l_SubmitDriveReqToLS > 0
		BEGIN
			DECLARE @preferredDriveList TABLE (DrivePoolId INT, DriveNumberList VARCHAR(MAX))
			INSERT INTO @preferredDriveList
			SELECT	DISTINCT Res.DrivePoolId, ''
			FROM	RMreservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			UPDATE @preferredDriveList
			SET		DriveNumberList = (
										SELECT CAST(Drive.DriveNumber AS VARCHAR(10)) + ',' AS [text()]
										FROM	MMDriveController DC WITH (NOLOCK), MMDrive Drive WITH (NOLOCK)
										WHERE	DC.DrivePoolId = P.DrivePoolId
										AND		DC.DriveId = Drive.DriveId
AND		Drive.Attributes & 128 = 0
										AND		Drive.DriveBroken = 0
										AND		Drive.DriveEnabled = 1
AND		MountStatus not in (4, 2, 3)
										AND		((Drive.DriveSoftState = 1)
												OR
												(Drive.DriveSoftState <> 1 AND Drive.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER))
										FOR XML PATH('')
									)
			FROM	@preferredDriveList P
			INSERT INTO @tblLibServerDriveReq
			SELECT RES.mediaGroupId, RES.JobId, 2, RES.LibraryId, ISNULL(P.DriveNumberList, ''), COUNT(DISTINCT RES.DriveId)
			FROM 	RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK), @preferredDriveList P
			WHERE 	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			AND		RES.DriveId = D.driveId
			AND 	D.DriveSoftState <> 1
AND		D.MountStatus not in (4, 2, 3)
			AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
			AND     RES.DrivePoolId = P.DrivePoolId
			GROUP BY RES.mediaGroupId, RES.JobId, RES.LibraryId, ISNULL(P.DriveNumberList, '')
		END
		ROLLBACK TRANSACTION LOAD_BALANCE_RESERVATION_TRANS
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		-- Create LS drive request
		IF (@l_SubmitDriveReqToLS > 0)
		BEGIN
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Submitting request for shared drives to library server due to error ['
																+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			--Create and populate the shared temp table before submitting the request
			if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
			CREATE TABLE #tmpLibServerDriveReq (
				RMRequestId		INT,
				jobId 				INT,
				commCellId 		INT,
				libraryId			INT,
				driveNumber 	VARCHAR(MAX),
				driveCnt			INT,
				PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId)
			)
			INSERT INTO #tmpLibServerDriveReq
			SELECT mediaGroupId, jobId, commCellId, libraryId, driveNumber, driveCnt
			FROM @tblLibServerDriveReq
			EXEC @o_ErrorCode = RMSubmitLSDriveRequest 0
			IF @o_ErrorCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Failed to submit request for shared drives to library server due to error ['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode = 415
set @o_FailureType = 2
			END
			ELSE
			BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Successfully submitted request for shared drives to library server - Error Code['
																	+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			END
		END
	  update RMReservationRequest
	  set ErrorCode = @o_ErrorCode,
			FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
      		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
	  where RequestId = @i_RequestId
	end
	if @i_isDebug > 0
	  insert into RMLogger values('RMReserveForLoadBalanceBackup', 'Exit...', @i_RequestId, getutcdate())
 	return @o_ErrorCode
GO


IF EXISTS (select * from GxQscripts where name = 'RMReserveForLoadBalanceBackup')
	delete from GxQscripts where name = 'RMReserveForLoadBalanceBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForLoadBalanceBackup')
	delete from GXDBVersions where aliasname = 'RMReserveForLoadBalanceBackup'
GO

insert into GXDBVersions values(2, 'RMReserveForLoadBalanceBackup',  '00010006000200060000', 'RMReserveForLoadBalanceBackup', '00010006000200060000')
GO

