

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForDashCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForDashCopy.sp,v $ $Id: RMReserveForDashCopy.sp,v 1.16.2.19 2019/07/30 15:46:18 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForDashCopy()
--  +========================================================================+
--
--	This stored procedure is used for Dash copy reservation and follows the new logic for Dash Copy handler.
--	Based on the reservation request Id, it can do source and destinaiton reservation or destination reservation only.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReserveForDashCopy')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveForDashCopy <<<'
	drop procedure RMReserveForDashCopy
END
IF EXISTS (select * from GxQscripts where name='RMReserveForDashCopy')
	delete from GxQscripts where name = 'RMReserveForDashCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForDashCopy')
	delete from GXDBVersions where aliasname = 'RMReserveForDashCopy'
GO
print '... Creating Procedure: RMReserveForDashCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveForDashCopy
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationList NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_ReservationList = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	insert into RMLogger values ('RMReserveForDashCopy', 'Enter...', @i_RequestId, getutcdate())
	-- Whether we need results. Need this because read side reservation will return different structure.
	DECLARE @isExpectReturns INT = 1
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL
	BEGIN
		CREATE TABLE #__suppress_results (dummycol int)
	END
	ELSE
	BEGIN
		SET @isExpectReturns = 0
	END
	declare @jobId int
	declare @xmlParams xml
	select @jobId = JobId, @xmlParams = xmlParams from RMReservationRequest where RequestId = @i_RequestId
	declare @results table (
		errorCode int,
		failureType	int,
		reservationList varchar(max)
	)
	declare @AUXCOPY2 int = 104
	declare @ARCHIVECHECK2 int = 106
	declare @MEDIAREFRESHING2 int = 127
	declare @SYNTHFULL int = 14
	declare @DEDUPDBSYNC_DASH int = 131
	declare @jobOpType int = 0
	declare @jobSubOpType int = 0
	--set @jobOpType = dbo.GetJobTypeForJobID(@jobId)
	IF EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK) WHERE JobId = @jobId)
	BEGIN
		SELECT	@jobOpType = ISNULL(job.opType, 0),
				@jobSubOpType = ISNULL(job.subOpType, 0)
		FROM	JMJobInfo job WITH (NOLOCK)
		WHERE	job.JobId = @jobId
	END
	IF @jobSubOpType > 0
		SET @jobOpType = @jobSubOpType
	declare @now int = 0
	-- For now, used the setting based on Dash copy properties
	DECLARE @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS INT = 60
	SET @SKIP_INTERVAL_ON_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_SOURCE_ERROR_INTERVAL_MINS'), 60)
	DECLARE @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS    INT = 10
	-- SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_DASHCOPY_JOB_SKIP_CHUNK_ON_NONE_SOURCE_ERROR_INTERVAL_MINS'), 10)
	SET @SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'), 10)
	-- Check if this is for snap copy
	DECLARE @isForSnapCopyData int = 0
	DECLARE @keys TABLE (
       jobid  INT,
       streamReaderId       INT,
       destcopyId INT
	 )
	SELECT @isForSnapCopyData = CASE WHEN b.isSnapCopy = 1 AND stream.SrcStreamNum != 1 THEN 1 ELSE 0 END
	FROM ArchJobStreamStatus stream WITH (NOLOCK), ArchGroupCopy b WITH (NOLOCK)
	WHERE	stream.ReservationRequestId = @i_RequestId
	AND		stream.JobId = @jobId
	AND		stream.DestCopyId = b.Id
	-- The following exec statement will need further modification since 'nested insert into exec' is not supported.
	if @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t') > 0
	and @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t[1]/sourceArgs') > 0
	begin
		--insert into @results
		exec RMReserveForAuxCopy @i_RequestId, @i_isDebug
		SELECT @o_ErrorCode = ErrorCode, @o_FailureType = FailureType
		FROM RMReservationRequest
		where RequestId = @i_RequestId
		-- If there is no destination reservation for current request, then mark the chunk skipped for now to allow other chunks to be processed first.
if @o_ErrorCode != 0
		begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE JobId = @jobId AND ReservationRequestId = @i_RequestId
			set @now = dbo.GetUnixTime(GetUTCDate())
if @jobOpType = @AUXCOPY2 and @o_ErrorCode != 20005
			AND EXISTS (
				SELECT TOP 1 chunk.SegmentId
				FROM	archChunkToReplicate chunk WITH (NOLOCK), ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId)
				AND		(
							stream.DestCopyId != chunk.DestCopyId
							OR
							stream.DestStreamNum > 0 AND stream.DestStreamNum != chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum > 0
							OR
							EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				)
			BEGIN
				UPDATE	chunk
SET		Status = 3,
						-- There is no need to add skip count in this case
						--SkippedCount != 1,
						SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
						ErrorCode = @o_ErrorCode,
						Modified = @now
				FROM	archChunkToReplicate chunk, ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
				AND		stream.DestCopyId = chunk.DestCopyId
				AND		(
							stream.DestStreamNum > 0 AND stream.DestStreamNum = chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum = 0
							AND NOT EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				--AND		stream.segmentId = chunk.segmentId
				--AND		stream.SrcCopyId = chunk.SrcCopyId
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId AND s.segmentId != stream.segmentId)
			END
if @jobOpType = @MEDIAREFRESHING2 and @o_ErrorCode != 20005
			AND EXISTS (
				SELECT TOP 1 chunk.SegmentId
				FROM	archChunkToReplicate chunk, ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
AND		(
							stream.DestCopyId != chunk.DestCopyId
							OR
							stream.DestStreamNum > 0 AND stream.DestStreamNum != chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum > 0
							OR
							EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
				)
				AND		chunk.mediaType != 10001
				--AND chunk.ArchFileId NOT IN (SELECT ArchFileId FROM archChunkToReplicate r WITH (NOLOCK) WHERE r.AdminJobId = stream.jobId AND r.VolumeId = stream.FirstVolumeId)
			 )
			BEGIN
				UPDATE	chunk
SET		Status =  3,
						-- There is no need to add skip count in this case
						--SkippedCount != 1,
						SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason =  0X13,
						ErrorCode = @o_ErrorCode,
						Modified = @now
				FROM	archChunkToReplicate chunk, ArchJobStreamStatus stream WITH (NOLOCK), archChunkToReplicate R
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
				AND		stream.DestCopyId = chunk.DestCopyId
AND		chunk.Status IN (0)
				AND		(
							stream.DestStreamNum > 0 AND stream.DestStreamNum = chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum = 0
							AND NOT EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				AND		chunk.ArchFileId = R.ArchFileId AND
				R.CommCellId = chunk.CommCellId AND
				R.AdminJobId = stream.jobId AND R.VolumeId = stream.FirstVolumeId
				AND		chunk.mediaType != 10001
			END
		end
	end
	else if @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t') > 0
	and @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t[1]/sourceArgs') = 0
	begin
		--insert into @results
		--exec RMReserveForBackup @i_RequestId, @i_isDebug
		declare @destReservationResults XML
		set @destReservationResults = ''
	--Create and populate the shared temp table before submitting power on request
	if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null DROP TABLE #tmpVMPowerOnReq
	CREATE TABLE #tmpVMPowerOnReq (
			RMRequestId		INT,
			HostId			INT,
			jobId 			INT,
			commCellId 		INT,
			PRIMARY KEY (jobId, HostId)
	)
SAVE TRANSACTION AUXCOPY_RESERVATION_TRANS
		exec RMReserveDestinationForAuxCopy @i_RequestId, @i_isDebug, @o_ErrorCode output, @o_FailureType output, @destReservationResults output
		if @@ERROR > 0
		begin
set @o_ErrorCode = 415
set @o_FailureType = 2
		end
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@o_ReservationList as nvarchar(max)) + cast(@destReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
if @o_ErrorCode != 0
		begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE jobId = @jobId AND ReservationRequestId = @i_RequestId
		end
		update RMReservationRequest
		set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
            FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
   			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
				ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
		where RequestId = @i_RequestId
		-- If there is no destination reservation for current request, then mark the chunk skipped for now to allow other chunks to be processed first.
if @o_ErrorCode != 0
		begin
			set @now = dbo.GetUnixTime(GetUTCDate())
if @jobOpType IN (@AUXCOPY2, @MEDIAREFRESHING2) and @o_ErrorCode != 20005
			AND EXISTS (
				SELECT TOP 1 chunk.SegmentId
				FROM	archChunkToReplicate chunk WITH (NOLOCK), ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId)
				AND		(
							stream.DestCopyId != chunk.DestCopyId
							OR
							stream.DestStreamNum > 0 AND stream.DestStreamNum != chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum > 0
							OR
							EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				)
			BEGIN
				UPDATE	chunk
SET		Status = 3,
						-- There is no need to add skip count in this case
						--SkippedCount != 1,
						SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
						ErrorCode = @o_ErrorCode,
						Modified = @now
				FROM	archChunkToReplicate chunk, ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
				AND		stream.DestCopyId = chunk.DestCopyId
				AND		(
							stream.DestStreamNum > 0 AND stream.DestStreamNum = chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum = 0
							AND NOT EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				--AND		stream.segmentId = chunk.segmentId
				--AND		stream.SrcCopyId = chunk.SrcCopyId
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId AND s.segmentId != stream.segmentId)
			END
if @jobOpType = @SYNTHFULL and @o_ErrorCode != 20005
			AND EXISTS (
				SELECT TOP 1 chunk.SegmentId
				FROM	archChunkToSF chunk WITH (NOLOCK), ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId)
				AND		(
							stream.DestStreamNum > 0 AND stream.DestStreamNum != chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum > 0
							OR
							EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
				)
			BEGIN
				UPDATE	chunk
SET		Status = 3,
						-- There is no need to add skip count in this case
						--SkippedCount != 1,
						SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
						ErrorCode = @o_ErrorCode,
						Modified = @now
				FROM	archChunkToSF chunk, ArchJobStreamStatus stream WITH (NOLOCK)
				WHERE	stream.ReservationRequestId = @i_RequestId
				AND		stream.JobId = @jobId
				AND		stream.JobId = chunk.adminJobId
				AND		(
							stream.DestStreamNum > 0 AND stream.DestStreamNum = chunk.DestStreamNum
							OR
							stream.DestStreamNum = 0 AND chunk.DestStreamNum = 0
							AND NOT EXISTS (select MMResource.ReservationId
											 FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
											 WHERE MMResourceToJob.jobId_l = @jobId
											 AND	MMResourceToJob.ReservationId = MMResource.ReservationId
											 AND	MMResource.CopyId = stream.DestCopyId)
						)
AND		chunk.Status IN (0)
				AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId AND s.segmentId != stream.segmentId)
			END
		end
	end
	else if @xmlParams.exist('/ResourceManager_RmReserveVolAndDriveArgs_t') > 0
	begin
        DECLARE @ReqVolId int = 0
        SELECT @ReqVolId = params.value('@volId', 'int')
		FROM	@xmlParams.nodes('/ResourceManager_RmReserveVolAndDriveArgs_t[1]') AS R(params)
		IF @isForSnapCopyData = 1
			SET @ReqVolId = 0
        IF @ReqVolId > 0
	AND EXISTS (SELECT VolumeId FROM MMVolume with (NOLOCK) WHERE VolumeId = @ReqVolId AND RecordingFormatId != 10001)
        BEGIN
	    	--insert into @results
	    	exec RMReserveForRestore @i_RequestId, @i_isDebug
            SELECT @o_ErrorCode = ErrorCode
            FROM    RMReservationRequest
            WHERE   RequestId = @i_RequestId
if @o_ErrorCode != 0
		    begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE jobId = @jobId AND ReservationRequestId = @i_RequestId
			    set @now = dbo.GetUnixTime(GetUTCDate())
if @jobOpType = @ARCHIVECHECK2 and @o_ErrorCode != 20005
				AND EXISTS (
					SELECT TOP 1 chunk.SegmentId
					FROM	archChunkToVerify2 chunk WITH (NOLOCK), ArchJobStreamStatus stream WITH (NOLOCK)
					WHERE	stream.ReservationRequestId = @i_RequestId
					AND		stream.JobId = @jobId
					AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
					AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId)
					AND		(
								stream.FirstVolumeId != chunk.VolumeId
								OR
								stream.SrcCopyId != chunk.SrcCopyId
								OR
								EXISTS (select MMResource.ReservationId
										FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
										WHERE MMResourceToJob.jobId_l = @jobId
										AND	MMResourceToJob.ReservationId = MMResource.ReservationId
										AND	MMResource.VolumeId = stream.FirstVolumeId)
							)
					)
				BEGIN
					UPDATE	chunk
SET		Status = 3,
							-- There is no need to add skip count in this case
							--SkippedCount != 1,
							SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
							ErrorCode = @o_ErrorCode,
							Modified = @now
					FROM	archChunkToVerify2 chunk, ArchJobStreamStatus stream WITH (NOLOCK)
					WHERE	stream.ReservationRequestId = @i_RequestId
					AND		stream.JobId = @jobId
					AND		stream.JobId = chunk.adminJobId
					AND		stream.FirstVolumeId = chunk.VolumeId
					AND NOT EXISTS (select MMResource.ReservationId
										FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
										WHERE MMResourceToJob.jobId_l = @jobId
										AND	MMResourceToJob.ReservationId = MMResource.ReservationId
										AND	MMResource.VolumeId = stream.FirstVolumeId)
					AND		stream.SrcCopyId = chunk.SrcCopyId
AND		chunk.Status IN (0)
					AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId AND s.segmentId != stream.segmentId)
				END
if @jobOpType = @DEDUPDBSYNC_DASH and @o_ErrorCode != 20005
				AND EXISTS (
					SELECT TOP 1 chunk.SegmentId
					FROM	ArchChunkToRecoverDDB chunk, ArchJobStreamStatus stream WITH (NOLOCK)
					WHERE	stream.ReservationRequestId = @i_RequestId
					AND		stream.JobId = @jobId
					AND		stream.JobId = chunk.adminJobId
AND		chunk.Status IN (0)
					AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId)
					AND		(
								stream.FirstVolumeId != chunk.VolumeId
								OR
								stream.SrcCopyId != chunk.SrcCopyId
								OR
								EXISTS (select MMResource.ReservationId
										FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
										WHERE MMResourceToJob.jobId_l = @jobId
										AND	MMResourceToJob.ReservationId = MMResource.ReservationId
										AND	MMResource.VolumeId = stream.FirstVolumeId)
							)
					)
				BEGIN
					UPDATE	chunk
SET		Status = 3,
							-- There is no need to add skip count in this case
							--SkippedCount != 1,
							SkippedForSeconds = (@SKIP_INTERVAL_ON_NONE_SOURCE_ERROR_MINS * 60),
SkippedReason = 0X13,
							ErrorCode = @o_ErrorCode,
							Modified = @now
					FROM	ArchChunkToRecoverDDB chunk, ArchJobStreamStatus stream WITH (NOLOCK)
					WHERE	stream.ReservationRequestId = @i_RequestId
					AND		stream.JobId = @jobId
					AND		stream.JobId = chunk.adminJobId
					AND		stream.FirstVolumeId = chunk.VolumeId
					AND NOT EXISTS (select MMResource.ReservationId
										FROM MMResourceToJob WITH (NOLOCK), MMResource WITH (NOLOCK)
										WHERE MMResourceToJob.jobId_l = @jobId
										AND	MMResourceToJob.ReservationId = MMResource.ReservationId
										AND	MMResource.VolumeId = stream.FirstVolumeId)
					AND		stream.SrcCopyId = chunk.SrcCopyId
AND		chunk.Status IN (0)
					AND		chunk.segmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus s WITH (NOLOCK) WHERE s.jobId = stream.jobId AND s.segmentId != stream.segmentId)
				END
		    end
        END
        ELSE
        BEGIN
            DECLARE @ReservationId  INT = 0
            DECLARE @RCID           INT = 0
            DECLARE @SrcMAId        INT = 0
            DECLARE @SrcDrivePoolId INT = 0
			DECLARE @CopyId			INT = 0
			DECLARE @volId			INT = 0
			DECLARE @mediaId		INT = 0
			DECLARE @archGroupName			VARCHAR(120) =''
			DECLARE @archGroupCopyName		VARCHAR(120) =''
			DECLARE @mediaAgentName			VARCHAR(120) =''
			DECLARE @drivePoolName			VARCHAR(120) = ''
			DECLARE @libraryName			VARCHAR(120) = ''
            select @RCID = next_l + 1 from GXCounter where name = 'RCID_Counter'
            if @RCID is NuLL
            begin
  	            insert into GXCounter select 'RCID_Counter', 0, 1
  	            set @RCID = 1
            end
            update GXCounter set next_l = @RCID where name = 'RCID_Counter'
            SELECT @SrcMAId = SrcMAId,
                   @SrcDrivePoolId = SrcDrivePoolId,
				   @copyId	= SrcCopyId,
				   @volId	= FirstVolumeId
            FROM   ArchJobStreamStatus WITH (NOLOCK)
            WHERE  ReservationRequestId = @i_RequestId
			AND	   JobId = @jobId
			IF @CopyId > 0
				SELECT @archGroupName =a.Name, @archGroupCopyName = b.Name
				FROM ArchGroup a with (NOLOCK), ArchGroupCopy b with (NOLOCK)
				WHERE b.Id = @CopyId
				AND	b.ArchGroupId = a.Id
			IF @SrcMAId > 0
				SELECT @mediaAgentName = name FROM App_Client WITH (NOLOCK) WHERE Id = @SrcMAId
			IF @SrcDrivePoolId > 0
				SELECT @drivePoolName = a.DrivePoolName, @libraryName = c.AliasName
				FROM	MMDrivePool a WITH (NOLOCK), MMMasterPool b WITH (NOLOCK), MMLibrary c WITH (NOLOCK)
				WHERE	a.DrivePoolId = @SrcDrivePoolId
				AND		a.MasterPoolId = b.MasterPoolId
				AND		b.LibraryId = c.LibraryId
	        INSERT INTO RMReservations
	        SELECT	@RCId, 0, @i_RequestId, @jobId, 0, 1, 0,
					       @copyId, 0, @volId, 0, 0, 0,
					      0, 0, 0, @SrcMAId, @SrcDrivePoolId, 0, 0, 0,
					      0, 0, 0, 0,
                          1, 0, 0, 0, 0, 0, 0, 0
         	set @o_ReservationList = cast(
			(
			SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId], [copyRsrvList!1!hostId], [copyRsrvList!1!volumeId],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[rcidList!2!val]
			from (
			SELECT	1		as TAG,
				NuLL		as Parent,
				NuLL		as [copyRsrvList!1],
				0			as [copyRsrvList!1!reservationId],
				@copyId		as [copyRsrvList!1!copyId],
				0			as [copyRsrvList!1!streamNum],
				@SrcDrivePoolId 				as [copyRsrvList!1!drivePoolId],
				@SrcMAId						as [copyRsrvList!1!hostId],
				@volId							as [copyRsrvList!1!volumeId],
				@archGroupName					as [copyRsrvList!1!archGroupName],
				@archGroupCopyName				as [copyRsrvList!1!archGroupCopyName],
				@libraryName					as [copyRsrvList!1!libraryName],
				@drivePoolName					as [copyRsrvList!1!drivePoolName],
				@mediaAgentName					as [copyRsrvList!1!mediaAgentName],
				NULL									as [rcidList!2!val]
			UNION ALL
			SELECT	2			          as TAG,
				1											as Parent,
				NuLL									as [copyRsrvList!1],
				0			as [copyRsrvList!1!reservationId],
				@copyId		as [copyRsrvList!1!copyId],
				0			as [copyRsrvList!1!streamNum],
				@SrcDrivePoolId 				as [copyRsrvList!1!drivePoolId],
				@SrcMAId						as [copyRsrvList!1!hostId],
				@volId							as [copyRsrvList!1!volumeId],
				@archGroupName					as [copyRsrvList!1!archGroupName],
				@archGroupCopyName				as [copyRsrvList!1!archGroupCopyName],
				@libraryName					as [copyRsrvList!1!libraryName],
				@drivePoolName					as [copyRsrvList!1!drivePoolName],
				@mediaAgentName					as [copyRsrvList!1!mediaAgentName],
				@RCID							as [rcidList!2!val]
			) a
			ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
					[copyRsrvList!1!drivePoolId], [copyRsrvList!1!hostId], [copyRsrvList!1!volumeId],
					[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
					[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
					[rcidList!2!val]
			FOR XML EXPLICIT, TYPE
			) as nvarchar(max))
             update RMReservationRequest
             set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
                    RequestTime = dbo.GetUnixTime(getutcdate()),
                    FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
  		            PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		            ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
              where RequestId = @i_RequestId
			insert into RMLogger values('RMReserveForDashCopy', 'Create Dummy reservation ' + @o_ReservationList, @i_RequestId, getutcdate())
    		select top 1 ErrorCode, FailureType, ReservationResults
	    	from RMReservationRequest
	    	where RequestId = @i_RequestId
        END
	end
	-- Only update ArchJobStreamStatus where there is actual sucessful reservation done for given requestId.
	-- This should prevent additional lock request on table ArchJobStreamStatus.
	-- There is one exception that when interruption happens. In such case, chunk will not be marked skipped, and reservations are created. But request should still be marked as failed to allow later process.
	if exists (select 1 from RMReservations with (NOLOCK) where requestId = @i_RequestId)
and @o_ErrorCode != 20005
	begin
		-- Need to update ArchJobStreamStatus table for the reservation results
		-- Source info can be for multiple destination copies
		update stream
		set		SrcReservationId = res.ReservationId,
				SrcRCId = res.RCId,
				SrcMAId = res.ClientId,
				SrcDrivePoolId = res.DrivePoolId,
Status = 1 /* 0x01 */
		from	RMReservations res, ArchJobStreamStatus stream
		where	res.copyId = stream.SrcCopyId
		and		res.VolumeId = stream.FirstVolumeId
		and		res.requestId = @i_RequestId
		and		stream.ReservationRequestId = @i_RequestId
		AND		stream.JobId = @jobId
		and		res.CopyId > 0
and		res.ReservationType = 1
		-- If Dash copy uses GACP, make sure the match is correct since reservation is done on GACP, and ArchJobStreamStatus contains dependent copy
		if @jobOpType IN (@AUXCOPY2,@MEDIAREFRESHING2)
		begin
			-- Destination info will be one particular copy
			update stream
			set		DestStreamNum = res.StreamId,
					DestReservationId = res.ReservationId,
					DestRCId = res.RCId,
					DestMAId = res.ClientId,
					DestDrivePoolId = res.DrivePoolId,
Status = 1 /* 0x01 */
			from	RMReservations res, ArchJobStreamStatus stream, ArchGroupCopy copy with (NOLOCK)
			where	res.requestId = @i_RequestId
			and		stream.ReservationRequestId = @i_RequestId
			AND		stream.JobId = @jobId
			and		res.CopyId > 0
			and		stream.DestCopyId = copy.Id
			and		(
copy.ExtendedFlags & 2 > 0 and copy.destMediaCopyId = res.copyId
						OR
copy.ExtendedFlags & 2 = 0 and res.copyId = stream.DestCopyId
					)
and		res.ReservationType = 2
		end
		else
		begin
			-- Destination info will be one particular copy
			update stream
			set		DestStreamNum = res.StreamId,
					DestReservationId = res.ReservationId,
					DestRCId = res.RCId,
					DestMAId = res.ClientId,
					DestDrivePoolId = res.DrivePoolId,
Status = 1 /* 0x01 */
			from	RMReservations res, ArchJobStreamStatus stream
			where	res.copyId = stream.DestCopyId
			--and		res.VolumeId != stream.FirstVolumeId
			and		res.StreamId > 0
			and		res.requestId = @i_RequestId
			and		stream.ReservationRequestId = @i_RequestId
			AND		stream.JobId = @jobId
			and		res.CopyId > 0
and		res.ReservationType = 2
		end
	end
	-- If this is for parallel copies, and only one copy or part of the copies get resources, rest of the failed copies should be marked as reservation failed.
	IF EXISTS (	SELECT 1
				FROM ArchJobStreamStatus with (NOLOCK)
				WHERE	jobId = @jobId
				AND     ReservationRequestId = @i_RequestId
AND     Status not in (0x04, 0x01)
			)
	BEGIN
		insert into @keys
		SELECT
			s.jobId,
			s.streamReaderId,
			s.destcopyId
		FROM ArchJobStreamStatus s
		WHERE	s.jobId = @jobId
		AND     s.ReservationRequestId = @i_RequestId
AND     s.Status not in (0x04, 0x01)
		UPDATE  S
SET     Status = 0x04
		FROM 	ArchJobStreamStatus S WITH (index(ArchJobStreamStatus_JobId_StreamReaderId_DestCopyId_PK)) INNER JOIN @keys K ON
				K.jobid = S.jobid
				AND K.streamreaderid = S.streamreaderid
				AND K.destcopyid = S.destcopyid
	END
exit_error:
	IF @isExpectReturns = 1
	BEGIN
		select top 1 ErrorCode, FailureType, ReservationResults
		from RMReservationRequest
		where RequestId = @i_RequestId
		order by ErrorCode desc
	END
  --select top 1 ErrorCode, FailureType, @o_ReservationList
  --from @results
  insert into RMLogger values('RMReserveForDashCopy', 'Exit...', @i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveForDashCopy')
	delete from GxQscripts where name = 'RMReserveForDashCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForDashCopy')
	delete from GXDBVersions where aliasname = 'RMReserveForDashCopy'
GO

insert into GXDBVersions values(2, 'RMReserveForDashCopy',  '00010016000200190000', 'RMReserveForDashCopy', '00010016000200190000')
GO

