

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForCachedResource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForCachedResource.sp,v $ $Id: RMReserveForCachedResource.sp,v 1.6.2.6 2018/03/19 23:56:54 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForCachedResource()
--  +========================================================================+
--
--
--	This is stored procedure used for reserving cached resource.
--	Reservation caching is to make sure jobs from certain application can use dedicated resoruces for long period of time.
--	When scheduling jobs from one application for very short time period (for example every 15 minitues), the resource used by previous jobs will be put
--  into reservation cache and following jobs can continue using them without going through whole reservation process.
--
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMReserveForCachedResource <<<'

IF EXISTS (select * from sysobjects where name='RMReserveForCachedResource')
	drop procedure RMReserveForCachedResource
IF EXISTS (select * from GxQscripts where name='RMReserveForCachedResource')
	delete from GxQscripts where name = 'RMReserveForCachedResource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForCachedResource')
	delete from GXDBVersions where aliasname = 'RMReserveForCachedResource'
GO
print '... Creating Procedure: RMReserveForCachedResource'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMReserveForCachedResource
  @i_jobid int,
  @i_appId int,
  @i_archGroupId int,
  @i_copyId int,
  @i_reservationType int,
  @i_dataType int,
  @i_noOfStreams int,
  @i_returnResult int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT,
  @o_ReservationId integer OUTPUT,
  @o_RCId integer OUTPUT
AS
  DECLARE @output_ErrorCode Integer;
  DECLARE @output_ReservationId Integer;
  DECLARE @output_RCId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_FailureType = 2
set @o_reservationid = 0
set @o_rcid = 0
declare @reservationid integer
declare @drivepoolid integer
declare @driveid integer
declare @rcid integer
declare @mediaid integer
declare @mediagroupid integer
declare @recordingformatid integer
declare @previousBkpJobId integer
declare @previousDataArchGroupId integer
declare @previousLogArchGroupId	integer
declare @dataArchGroupId		integer
declare @logArchGroupId			integer
declare @lock_result		integer = -1
declare @lock_name			varchar(max) = ''
set @reservationId = 0
set @rcid = 0
set @drivepoolid = 0
set @driveid = 0
set @mediaid = 0
set @mediagroupid = 0
set @recordingformatid = 0
set @previousBkpJobId = 0
set @previousDataArchGroupId = 0
set @previousLogArchGroupId = 0
set @dataArchGroupId = 0
set @logArchGroupId = 0
set @i_returnResult = 1 -- Always provide output
declare @cachedResourceTable TABLE (ReservationId int, RCId int)
if @i_appId = 0 or @i_jobId = 0
begin
set @o_ErrorCode = 103
  goto exit_done
end
if  @i_dataType = 6
begin
	goto exit_done
end
DECLARE @backupCachingEnhance INT = 0
SELECT @backupCachingEnhance = isnull(value, 0) from MMConfigs with (readuncommitted) where (name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_CACHING_ENHANCEMENT_STREAM_NUMBER')
IF @backupCachingEnhance = 0
BEGIN
	-- Find previous job id, storage policy info for the same application first, and then find out the reservation/RC id for the cached resources.
	if @i_reservationType = 0 or @i_reservationType = 2 /* write */
	begin
		select TOP 1 @previousBkpJobId = JobId
		from	JMBkpStats job with (readuncommitted), MMResourceToJob restojob with (readuncommitted)
		where	job.CommcellId = 2
		and		job.appId = @i_appId
		and		job.jobId = restojob.jobId_l
		and		(
(@i_dataType = 1 /*data*/ AND job.dataArchGrpId > 0)
					OR
(@i_dataType = 4 /*log*/ AND job.logArchGrpId > 0)
					OR
					(@i_dataType = 0)
				)
		order by	job.servEndDate desc
	end
END
ELSE
BEGIN
	SET @previousBkpJobId = 0
	IF @i_noOfStreams <= 0
		SELECT	@i_noOfStreams = NumStreams
		FROM	JMBkpJobInfo WITH (readuncommitted)
		WHERE	JobId = @i_jobid AND CommcellId = 2
END
-- If there is a given storage policy id, then all the lookup will be based on
if (@i_copyId is null or @i_copyId = 0)
and @i_archGroupId is not null and @i_archGroupId > 0
begin
	select @i_copyId = DefaultCopy from ArchGroup with (readuncommitted) where Id = @i_archGroupId
end
-- If there is a given copy id, then consider the storage policy setting on such copy only.
-- In this case, we can cover any storag policy/copy changes in one backup job, such as using snap backup copy, log storage policy, full/incrementall, and so on.
if @i_copyId is not NULL and @i_copyId > 0
begin
	select @dataArchGroupId = ArchGroupId from ArchGroupCopy with (readuncommitted) where Id = @i_CopyId
	-- no need continue if the option is not set
if not exists (select Id from ArchGroup with (readuncommitted) where Id = @dataArchGroupId and Flags & 1048576 > 0)
		goto exit_done
	IF @backupCachingEnhance = 0 OR @i_noOfStreams <= 0
	BEGIN
		-- Get the caching reserve candidates by job id and copy id
		-- Enhancement: reuse all the cached resources for the new job instead of just one.
		insert into @cachedResourceTable
		--select top 1 @reservationid = isnull(restojob.reservationid, 0), @rcid = isnull(rcid, 0)
		select distinct restojob.reservationid, restojob.rcid
		from	mmresourcetojob restojob with (readuncommitted), mmresource res with (readuncommitted)
		where	restojob.jobid_l in (@i_JobId, @previousBkpJobId) and restojob.reservationtype = 2 /*write*/
and		restojob.releasetime != 0 and (restojob.inuse = 0 OR (restojob.ReserveBitMask /*& (~2) */= 0))
		and		restojob.ReservationId = res.ReservationId
		and		res.CopyId = @i_copyId
	END
	ELSE
	-- Enhancement to reuse only the given number of streams from reservations of current copy
	BEGIN
		SET @lock_name = 'BackupCachingLock_SP' + cast(@dataArchGroupId as varchar(20))
		EXEC @lock_result = sp_getapplock @Resource = @lock_name, @LockOwner='Session', @LockMode = 'Exclusive', @LockTimeout = 6000
		IF (@lock_result NOT IN (0, 1))
		BEGIN
			GOTO exit_done
		END
		insert into @cachedResourceTable
		select TOP (@i_noOfStreams) restojob.reservationid, restojob.rcid
		from	mmresourcetojob restojob with (readuncommitted), mmresource res with (readuncommitted)
		where	restojob.reservationtype = 2 /*write*/
and		restojob.releasetime != 0 and (restojob.inuse = 0 OR (restojob.ReserveBitMask /*& (~2) */= 0))
		-- Current job or jobs are not in running
		and		(restojob.jobid_l = @i_JobId or NOT EXISTS (SELECT 1 FROM JMJobInfo with (readuncommitted) WHERE JobId = restojob.JobId_l and state in (1, 3)))
		and		restojob.ReservationId = res.ReservationId
		and		res.CopyId = @i_copyId
		and		res.VolumeId > 0
		order by case when (restojob.jobid_l = @i_JobId) then 0 else 1 end,
					restojob.releasetime
	END
end
-- There is no given copy id, we assume all reservation happens on data archgroup only.
else
begin
	-- select @dataArchGroupId = dataArchGrpID, @logArchGroupId = logArchGrpId from app_application with (readuncommitted) where id = @i_appId
	select @dataArchGroupId = currentPolicy from JMBkpJobInfo with (readuncommitted) where jobId = @i_jobid
	-- no need continue if the option is not set
if not exists (select Id from ArchGroup with (readuncommitted) where Id = @dataArchGroupId and Flags & 1048576 > 0)
		goto exit_done
	IF @backupCachingEnhance = 0 OR @i_noOfStreams <= 0
	BEGIN
		-- Previous one is the same of current one
		if @previousDataArchGroupId > 0 and @previousDataArchGroupId = @dataArchGroupId
		begin
			-- Enhancement: reuse all the cached resources for the new job instead of just one.
			insert into @cachedResourceTable
			-- Get the caching reserve candidates by job id
			--select top 1 @reservationid = isnull(reservationid, 0), @rcid = isnull(rcid, 0)
			select distinct reservationid, rcid
			from	mmresourcetojob with (readuncommitted)
where	jobid_l in (@i_JobId, @previousBkpJobId) and reservationtype = 2 /*write*/ and releasetime != 0 and (inuse = 0 OR (ReserveBitMask /*& (~2) */= 0))
		end
		else
		begin
			-- Enhancement: reuse all the cached resources for the new job instead of just one.
			insert into @cachedResourceTable
			-- Get the caching reserve candidates by job id and storage policy id
			--select top 1 @reservationid = isnull(restojob.reservationid, 0), @rcid = isnull(rcid, 0)
			select distinct restojob.reservationid, restojob.rcid
			from	mmresourcetojob restojob with (readuncommitted), mmresource res with (readuncommitted)
			where	restojob.jobid_l in (@i_JobId, @previousBkpJobId) and restojob.reservationtype = 2 /*write*/
and		restojob.releasetime != 0 and (restojob.inuse = 0 OR (restojob.ReserveBitMask /*& (~2) */= 0))
			and		restojob.ReservationId = res.ReservationId
			and		res.CopyId in (select DefaultCopy from ArchGroup with (readuncommitted) where Id = @dataArchGroupId)
		end
	END
	ELSE
	BEGIN
		SET @lock_name = 'BackupCachingLock_SP' + cast(@dataArchGroupId as varchar(20))
		EXEC @lock_result = sp_getapplock @Resource = @lock_name, @LockOwner='Session', @LockMode = 'Exclusive', @LockTimeout = 6000
		IF (@lock_result NOT IN (0, 1))
		BEGIN
			GOTO exit_done
		END
		insert into @cachedResourceTable
		select TOP (@i_noOfStreams) restojob.reservationid, restojob.rcid
		from	mmresourcetojob restojob with (readuncommitted), mmresource res with (readuncommitted)
		where	restojob.reservationtype = 2 /*write*/
and		restojob.releasetime != 0 and (restojob.inuse = 0 OR (restojob.ReserveBitMask /*& (~2) */= 0))
		-- Current job or jobs are not in running
		and		(restojob.jobid_l = @i_JobId or NOT EXISTS (SELECT 1 FROM JMJobInfo with (readuncommitted) WHERE JobId = restojob.JobId_l and state in (1, 3)))
		and		restojob.ReservationId = res.ReservationId
		and		res.CopyId in (select DefaultCopy from ArchGroup with (readuncommitted) where Id = @dataArchGroupId)
		and		res.VolumeId > 0
		order by case when (restojob.jobid_l = @i_JobId) then 0 else 1 end,
					restojob.releasetime
	END
end
-- If there is interruption happens, remove the cached reservations
if exists (select * from @cachedResourceTable)
begin
	delete @cachedResourceTable
	from @cachedResourceTable a, MMResource b with (readuncommitted)
	where	a.ReservationId = b.ReservationId
	and		(b.intrjobid_l > 0 or b.hasjobinterrupted > 0)
end
-- TBD: when multiple storage policies or copies used by the same job, such as data backup and log backup, we need to have a way to differenciate the cached resources on storage policyid
if exists (select * from @cachedResourceTable)
begin
	if exists (select a.ReservationId from MMResource a with (readuncommitted), @cachedResourceTable b where a.reservationId = b.reservationId and a.VolumeId = 0)
	begin
		delete MMResourceToJob
		from MMResourceToJob a, @cachedResourceTable b
		where a.RCID = b.RCId
		delete MMResource
		from MMResource a, @cachedResourceTable b
		where a.ReservationId = b.ReservationId
		and not exists(select ReservationId from MMResourceToJob with (readuncommitted) where ReservationId = a.ReservationId)
		delete @cachedResourceTable
		goto exit_done
	end
	if @i_noOfStreams > 0
	begin
		DELETE  a
		FROM	@cachedResourceTable a,
				(SELECT *, ROW_NUMBER()  OVER (ORDER BY ReservationId, RCId) as rownumber FROM @cachedResourceTable) b
		WHERE	a.ReservationId = b.ReservationId
		AND		a.RCId = b.RCId
		AND		rownumber > @i_noOfStreams
	end
update mmresourcetojob set inuse = 0, releasetime = 0, ReserveBitMask = (ReserveBitMask | 1), LogicalReleased = 0, jobId_l = @i_jobid
	where rcid in (select distinct RCId from @cachedResourceTable)
	update mmresource set LogicalRelease = 0
	where reservationId in (select distinct ReservationId from @cachedResourceTable)
	goto exit_done
end
exit_done:
	IF @backupCachingEnhance != 0 AND @i_noOfStreams > 0 and @lock_result IN (0, 1)
		EXEC @lock_result = sp_releaseapplock @Resource = @lock_name, @LockOwner='Session'
	--IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
	  IF @i_returnResult > 0
	  BEGIN
		IF NOT EXISTS (SELECT * FROM @cachedResourceTable)
			SELECT @o_ErrorCode, 0, 0
		ELSE
			SELECT DISTINCT @o_ErrorCode, ReservationId, RCId FROM @cachedResourceTable
	  END
	--END
  RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveForCachedResource')
	delete from GxQscripts where name = 'RMReserveForCachedResource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForCachedResource')
	delete from GXDBVersions where aliasname = 'RMReserveForCachedResource'
GO

insert into GXDBVersions values(2, 'RMReserveForCachedResource',  '00010006000200060000', 'RMReserveForCachedResource', '00010006000200060000')
GO

