

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForBackup.sp,v $ $Id: RMReserveForBackup.sp,v 1.51.2.27 2020/02/12 12:18:27 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForBackup()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReserveForBackup')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveForBackup <<<'
	drop procedure RMReserveForBackup
END
IF EXISTS (select * from GxQscripts where name='RMReserveForBackup')
	delete from GxQscripts where name = 'RMReserveForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForBackup')
	delete from GXDBVersions where aliasname = 'RMReserveForBackup'
GO
print '... Creating Procedure: RMReserveForBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveForBackup
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationList NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_FailureType = 2
	set @o_ReservationList = ''
	declare @canCommitReservations int
	declare @howManySuccessReservations int
	set @canCommitReservations = 0
	set @howManySuccessReservations = 0
	DECLARE @l_SubmitDriveReqToLS		INTEGER
	SET			@l_SubmitDriveReqToLS		= 0
	DECLARE @l_LSOfflineDriveCnt		INTEGER
	SET			@l_LSOfflineDriveCnt		= 0
	DECLARE @l_LSOfflineDriveCntWithInlineCopy		INTEGER
	SET			@l_LSOfflineDriveCntWithInlineCopy		= 0
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	DECLARE @l_SubmitPowerOnReqToVM				INTEGER
	SET			@l_SubmitPowerOnReqToVM				= 0
	DECLARE @l_PMOfflineVMCount					INTEGER
	SET			@l_PMOfflineVMCount					= 0
	DECLARE @l_PMOfflineDDBVMCntWithInlineCopy	INTEGER
	SET			@l_PMOfflineDDBVMCntWithInlineCopy	= 0
	DECLARE @l_PMOfflineDDBVMCount				INTEGER
	SET			@l_PMOfflineDDBVMCount				= 0
	DECLARE @l_PMOfflineVMCntWithInlineCopy		INTEGER
	SET			@l_PMOfflineVMCntWithInlineCopy		= 0
	DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
	SET			@HOST_STATUS_POWER_MANAGED_VM		= 7
	DECLARE @tblLibServerDriveReq TABLE (
		jobId 			INT,
		commCellId 	INT,
		libraryId		INT,
		driveNumber VARCHAR(MAX),
		driveCnt		INT,
		PRIMARY KEY (jobId, commCellId, libraryId)
	)
	declare @retCode INT = 0
	DECLARE @tblVMPowerOnReq TABLE (
	RMRequestId			INT,
	HostId				INT,
	jobId 				INT,
	commCellId 			INT,
	isForDDB	 		INT,
	isForInline			INT,
	hostSoftState		INT,
	hostOfflineReason 	INT,
	PRIMARY KEY (jobId, HostId, isForDDB, isForInline)
	)
	-- check if job has interrupted anything
	declare @jobId int
	select @jobId = jobId from RMReservationRequest where RequestId = @i_RequestId
	delete RMReservations where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	declare @reservationResults XML
	set @reservationResults = ''
	declare @containInlineCopy int
	set @containInlineCopy = 0
	declare @primaryCopyId int = 0
	--Create and populate the shared temp table before submitting power on request.
	if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null DROP TABLE #tmpVMPowerOnReq
		CREATE TABLE #tmpVMPowerOnReq (
			RMRequestId		INT,
			HostId			INT,
			jobId 			INT,
			commCellId 		INT,
			PRIMARY KEY (jobId, HostId))
SAVE TRANSACTION BACKUP_RESERVATION_TRANS
	if @i_isDebug > 0
		insert into RMLogger values ('RMReserveForBackup', 'Enter For Job['+ isnull(cast(@jobId as varchar(20)), 'NULL') + ']', @i_RequestId, getutcdate())
	exec @o_ErrorCode = RMReserveWriters @i_RequestId, 0, 1, @i_isDebug,
																			 @reservationResults output, @o_ErrorCode output, @o_FailureType output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	end
	set @o_ReservationList = cast(@reservationResults as nvarchar(max))
if @o_ErrorCode != 0 --and @o_ErrorCode != E_MM_NO_RESOURCE_INTERRUPTED_JOB
	begin
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForBackup', 'Reservation for backup return error code ['
			  												+ isnull(cast(@o_ErrorCode as varchar(10)), 'NULL') + '].', @i_RequestId, getutcdate())
		goto exit_error
	end
	--Check if any offline LS drives are reserved for Primary copy
	SELECT @l_LSOfflineDriveCnt = COUNT(DISTINCT RES.driveId)
	FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.LibraryId = L.LibraryId
	AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	AND		RES.DriveId = D.driveId
	AND 	D.DriveSoftState <> 1
	AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	-- check if any offline power managed VMs are reserved for primary copy.
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, RES.ClientId, RES.JobId, 2, 0, 0, H.MmHostSoftState, H.OfflineReason
	FROM  RMReservations RES WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.ClientId = H.ClientId
AND     H.Attribute & 32768 = 32768
	SELECT @l_PMOfflineVMCount = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	-- check if any offline power managed VMs are part of primary copy's DDB
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, HOST.ClientId, RES.JobId, 2, 1, 0, HOST.MmHostSoftState, HOST.OfflineReason
	FROM RMReservations RES WITH (NOLOCK) INNER JOIN MMVolume V WITH (NOLOCK) ON RES.VolumeId = V.VolumeId
		INNER JOIN IdxSIDBSubStore subStore WITH (NOLOCK) ON subStore.SIDBStoreId = V.SIDBStoreId
		INNER JOIN MMHost HOST WITH (NOLOCK) ON HOST.ClientId = subStore.ClientId
		INNER JOIN IdxCache idxc WITH (NOLOCK) ON idxc.IdxCacheId = subStore.IdxCacheId
		INNER JOIN IdxAccessPath idxa WITH (NOLOCK) ON idxa.IdxAccessPathId = subStore.IdxAccessPathId
	WHERE RES.RequestId = @i_RequestId
		AND HOST.MMHostEnabled <> 0
		AND idxc.Enabled <> 0
		AND idxa.Enabled <> 0
AND RES.ReservationType = 2
AND HOST.Attribute & 32768 = 32768
		AND NOT EXISTS (SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
								 INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
						WHERE 	VM.HostId = HOST.ClientId
								AND VM.FailureReason = 2
								AND VMMAP.EntityId = @jobId
AND VMMAP.EntityType = 1)
		AND NOT EXISTS (SELECT 1 FROM @tblVMPowerOnReq tmp WHERE tmp.HostId = HOST.ClientId)
	SELECT @l_PMOfflineDDBVMCount = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	IF @l_LSOfflineDriveCnt > 0 OR @l_PMOfflineVMCount > 0 OR @l_PMOfflineDDBVMCount > 0
		SET @howManySuccessReservations = 0
	ELSE
		SET @howManySuccessReservations = 1
	-- Check for in-line copy reservation
	declare @copyIdList varchar(200)
	declare @failIfSecondaryCopyError int = 0
	declare @inlineCopyId int
	declare @xmlParams XML
	declare @xmlCopyIDList XML
	set @copyIdList = ''
	set @failIfSecondaryCopyError = 0
	set @primaryCopyId = 0
	set @inlineCopyId = 0
	set @xmlParams = ''
	set @xmlCopyIDList = ''
	declare @jobOpType int = 0
	declare @iDAType int = 0
	select
				-- copyId in table RMReservationRequest will be updated as primary copy id in RMReserveWriters
				@primaryCopyId = copyId,
				@jobOpType = jobOpType,
				@iDAType = iDAType,
				@xmlParams = xmlParams
	from RMReservationRequest
	where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t') > 0
		BEGIN
			SELECT	@failIfSecondaryCopyError	= params.value('@failIfSecondaryCopyError', 'int'),
							@xmlCopyIDList = params.query('//copyIdList')
			FROM	@xmlParams.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
		END
		if @failIfSecondaryCopyError = 0
		and @jobOpType IN (4 /*BACKUP*/, 18 /*BACKUP3RD*/)
AND @iDAType IN (22, 80, 61,
/*3,*/
/*37, 62,*/
/*103,*/
135)
		BEGIN
			if exists (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_STOP_RESERVATION_WITH_INLINE_FAILURE' and value > 0)
			BEGIN
				SET @failIfSecondaryCopyError = 1
				if @i_isDebug > 0
			  		insert into RMLogger values('RMReserveForBackup', 'Setting failIfSecondaryCopyError to TRUE with global option for Oracle/HANA backup job', @i_RequestId, getutcdate())
			END
		END
	END
	IF @xmlCopyIDList IS NOT NULL
	AND @xmlCopyIDList.exist('/copyIdList') > 0
	AND @xmlCopyIDList.exist('/copyIdList[@val != sql:variable("@primaryCopyId")]') > 0
	BEGIN
		SAVE TRANSACTION INLINE_COPY_RESERVATION_TRANS
		IF (Cursor_Status('LOCAL', 'inlineCopy_Cursor') >= -1)
		BEGIN
			CLOSE inlineCopy_Cursor
			DEALLOCATE inlineCopy_Cursor
		END
		DECLARE inlineCopy_Cursor CURSOR LOCAL FOR
			SELECT	DISTINCT params.value('@val', 'int')
			FROM	@xmlCopyIDList.nodes('/copyIdList') AS R(params)
		OPEN inlineCopy_Cursor
		FETCH NEXT FROM inlineCopy_Cursor INTO @inlineCopyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF  @inlineCopyId = 0 OR (@primaryCopyId > 0 AND @primaryCopyId = @inlineCopyId)
			--IF EXISTS (SELECT defaultCopy FROM ArchGroup with (readuncommitted) WHERE DefaultCopy = @inlineCopyId)
			BEGIN
				FETCH NEXT FROM inlineCopy_Cursor INTO @inlineCopyId
				CONTINUE
			END
			set @containInlineCopy = 1
			set @reservationResults = ''
			if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForBackup', 'Start reservation attempt for inline copy ['
			  												+ cast(@inlineCopyId as varchar(10)) +'].', @i_RequestId, getutcdate())
			-- inline copy reservation
			exec @o_ErrorCode = RMReserveWriters @i_RequestId, @inlineCopyId, 0, @i_isDebug,
																					 @reservationResults output, @o_ErrorCode output, @o_FailureType output
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			end
if @o_ErrorCode = 0
			-- inline copy reservation cannot interrupt resource
			-- or @o_ErrorCode = E_MM_NO_RESOURCE_INTERRUPTED_JOB
			begin
				set @howManySuccessReservations = @howManySuccessReservations + 1
				IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
				begin
					-- Inline copy resevation successes, and backup reservation results is already large.
					-- Ignore current result. It will be picked by later query as primary reservations.
					if not (@o_ReservationList like '%EMPTY_RESULTS%')
					begin
						-- Ignore any failure messages
						if len(cast(@o_ReservationList as nvarchar(max))) + len(cast(@reservationResults as nvarchar(max))) > 3930
							set @o_ReservationList =  'EMPTY_RESULTS'
						else
							set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
					end
				end
				else
				begin
					set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
				end
			end
			else if @failIfSecondaryCopyError > 0
			begin
				if @i_isDebug > 0
				  insert into RMLogger values('RMReserveForBackup', 'Reservation for inline copy ['
				  												+ cast(@inlineCopyId as varchar(10)) +'] return error ['
				  												+ cast(@o_ErrorCode as varchar(10)) + ']. Do not continue because of job option failIfSecondaryCopyError.',
				  												@i_RequestId, getutcdate())
				IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
				begin
					if not (@o_ReservationList like '%EMPTY_RESULTS%')
					begin
						-- If the string is too long, keep the result from inline only.
						-- Backup cannot run because of inline failure anyway. JPR will show that
						if len(cast(@o_ReservationList as nvarchar(max))) + len(cast(@reservationResults as nvarchar(max))) > 3930
							set @o_ReservationList = cast(@reservationResults as nvarchar(max))
						else
							set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
					end
					else
					begin
						set @o_ReservationList = cast(@reservationResults as nvarchar(max))
					end
				end
				else
				begin
					set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
				end
set @o_FailureType = 2
				break
			end
			-- Inline reservation fails, and backup can still continue with next copy reservation or run with primary copy only
			else
			begin
				IF OBJECT_ID('tempdb..#__suppress_results') IS NOT NULL
				begin
					if (not (@o_ReservationList like '%EMPTY_RESULTS%'))
					and len(cast(@o_ReservationList as nvarchar(max))) + len(cast(@reservationResults as nvarchar(max))) <= 3930
						set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
				end
				else
				begin
					set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@reservationResults as nvarchar(max))
				end
			end
			if @i_isDebug > 0
		  	insert into RMLogger values('RMReserveForBackup', 'Reservation for inline copy ['
		  												+ cast(@inlineCopyId as varchar(10)) +'] return error code ['
		  												+ cast(@o_ErrorCode as varchar(10)) + ']. Continue to the next copy.', @i_RequestId, getutcdate())
SET @o_ErrorCode = 0
			FETCH NEXT FROM inlineCopy_Cursor INTO @inlineCopyId
		END
		CLOSE inlineCopy_Cursor
		DEALLOCATE inlineCopy_Cursor
		--Check if any offline LS drives are reserved for Inline copies also
		SELECT @l_LSOfflineDriveCntWithInlineCopy = COUNT(DISTINCT RES.driveId)
		FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
		WHERE RES.RequestId = @i_RequestId
		AND		RES.LibraryId = L.LibraryId
		AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
		AND		RES.DriveId = D.driveId
		AND 	D.DriveSoftState <> 1
		AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
		-- check if any offline power managed VMs are reserved for Inline copies.
		INSERT INTO @tblVMPowerOnReq
		SELECT DISTINCT RES.RequestId, RES.ClientId, RES.JobId, 2, 0, 1, H.MmHostSoftState, H.OfflineReason
		FROM  RMReservations RES WITH (NOLOCK), MMHost H WITH (NOLOCK)
		WHERE RES.RequestId = @i_RequestId
		AND		RES.ClientId = H.ClientId
AND 	H.Attribute & 32768 = 32768
		SELECT @l_PMOfflineVMCntWithInlineCopy = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForInline = 1 AND isForDDB = 0 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
		-- check if any offline power managed VMs are part of inline copy's DDB
		INSERT INTO @tblVMPowerOnReq
		SELECT DISTINCT RES.RequestId, HOST.ClientId, RES.JobId, 2, 1, 1, HOST.MmHostSoftState, HOST.OfflineReason
		FROM RMReservations RES WITH (NOLOCK) INNER JOIN MMVolume V WITH (NOLOCK) ON RES.VolumeId = V.VolumeId
			INNER JOIN IdxSIDBSubStore subStore WITH (NOLOCK) ON subStore.SIDBStoreId = V.SIDBStoreId
			INNER JOIN MMHost HOST WITH (NOLOCK) ON HOST.ClientId = subStore.ClientId
			INNER JOIN IdxCache idxc WITH (NOLOCK) ON idxc.IdxCacheId = subStore.IdxCacheId
			INNER JOIN IdxAccessPath idxa WITH (NOLOCK) ON idxa.IdxAccessPathId = subStore.IdxAccessPathId
		WHERE RES.RequestId = @i_RequestId
			AND HOST.MMHostEnabled <> 0
			AND idxc.Enabled <> 0
			AND idxa.Enabled <> 0
AND RES.ReservationType = 2
AND HOST.Attribute & 32768 = 32768
			AND NOT EXISTS (SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
							INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
WHERE VM.HostId = HOST.ClientId AND VM.FailureReason = 2 AND VMMAP.EntityId = @jobId AND VMMAP.EntityType = 1)
			AND NOT EXISTS (SELECT 1 FROM @tblVMPowerOnReq tmp WHERE tmp.HostId = HOST.ClientId)
		SELECT @l_PMOfflineDDBVMCntWithInlineCopy = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForInline = 1 AND isForDDB = 1 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
		-- If Primary reservation is successful and LS offline drives are required only for in-line copies
		-- Then continue reservation with Primary copy and rollback reservation of in-line copies with @failIfSecondaryCopyError = 0
		-- Rollback Primary copy reservation also if @failIfSecondaryCopyError > 0
		IF ((@l_LSOfflineDriveCnt = 0 AND @l_LSOfflineDriveCntWithInlineCopy > 0) OR (@l_PMOfflineVMCount = 0 AND @l_PMOfflineVMCntWithInlineCopy > 0) OR
			( @l_PMOfflineDDBVMCount = 0 AND @l_PMOfflineDDBVMCntWithInlineCopy > 0)) AND @failIfSecondaryCopyError = 0
		BEGIN
			SET @howManySuccessReservations = 1
			ROLLBACK TRANSACTION INLINE_COPY_RESERVATION_TRANS
		END
IF @o_ErrorCode != 0
		BEGIN
			if @i_isDebug > 0
				  insert into RMLogger values('RMReserveForBackup', 'Reservation for in-line copy return error code ['
				  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			GOTO exit_error
		END
	END
	-- IF here then @o_ErrorCode = E_MM_NOERROR
	-- Check for LS Offline drives final count
		SELECT @l_LSOfflineDriveCntWithInlineCopy = COUNT(DISTINCT RES.driveId)
		FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
		WHERE RES.RequestId = @i_RequestId
		AND		RES.LibraryId = L.LibraryId
		AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
		AND		RES.DriveId = D.driveId
		AND 	D.DriveSoftState <> 1
		AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	IF @l_LSOfflineDriveCntWithInlineCopy > 0
	BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
		SET @l_SubmitDriveReqToLS = 1
		SET @canCommitReservations = 0
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForBackup', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	END
	-- check for total offline power managed VMs count which are reserved for both primary and inline copies.
	SELECT @l_PMOfflineVMCntWithInlineCopy = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForDDB = 0 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	-- check for total offline power managed DDB VMs count which are needed for both primary and inline copies.
	SELECT @l_PMOfflineDDBVMCntWithInlineCopy = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	IF @l_PMOfflineVMCntWithInlineCopy > 0 OR @l_PMOfflineDDBVMCntWithInlineCopy > 0
	BEGIN
SET @o_ErrorCode = 346
SET @o_FailureType = 1
		SET @l_SubmitPowerOnReqToVM = 1
		SET @canCommitReservations = 0
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveForBackup', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	END
IF ((@howManySuccessReservations > 0) AND (@l_LSOfflineDriveCntWithInlineCopy = 0) AND (@l_PMOfflineVMCntWithInlineCopy = 0) AND (@l_PMOfflineDDBVMCntWithInlineCopy = 0) AND @o_ErrorCode = 0)
	BEGIN
		SET @canCommitReservations = 1
	END
exit_error:
	if @o_ReservationList is not null and len(cast(@o_ReservationList as nvarchar(max))) > 0
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@o_ReservationList as nvarchar(max)) + '</ResourceManager_ReservationList>'
	declare @tempLog table
	(
			RMModule	varchar(100),
			State		varchar(max),
			RequestId	integer,
			TimeStamp	datetime
	)
	select @primaryCopyId = copyId
	from RMReservationRequest
	where RequestId = @i_RequestId
	insert into @tempLog
	select RMModule, State, RequestId, TimeStamp
	from	RMLogger with (readuncommitted)
	where	RequestId = @i_RequestId
if @o_ErrorCode = 20005
	begin
		-- If there is interruption happens, should rollback all the database changes and only keep the interruption related changes.
		-- Including:
		-- 1. Interrupting job id set on interrupted resources
		-- 2. Dummy reservations for interrupting job
		DECLARE @interruptedResource	TABLE (
				InterruptedReservationId	INT
		)
		DECLARE @interruptingResources TABLE (
				ReservationId				INT,
				RCId						INT,
				JobId						bigint,
				Priority					INT,
				PreEmptable					INT,
				ReservationBitMask			INT,
				ReservationType				INT,
				PrimaryRCID					INT,
				ClientTokenId				INT,
				DestMediaGroupId			INT,
				CopyId						INT,
				StreamId					INT,
				VolumeId					INT,
				MediaId						INT,
				DriveId						INT,
				ClientId 					INT,
				DrivePoolId					INT,
				MasterPoolId				INT,
				MediaGroupId				INT,
				ReservationTime				INT,
				ResourceFlag				INT,
				PrimaryResId				INT,
				LibraryId					INT,
				LibraryTypeId				INT,
				SpareGroupId				INT,
				MountPathId					INT,
				ScheduleRunId				bigint,
				NoOtherSchedule				INT,
				SIDBStoreId					INT
		)
		INSERT INTO @interruptedResource
		SELECT		ReservationId
		FROM		MMResource
		WHERE		IntrJobId_h = 0 AND IntrJobId_l =  @jobId
		INSERT INTO @interruptingResources
		SELECT	res.ReservationId, restojob.RCId, @jobId,
				restojob.Priority, restojob.PreEmptable, restojob.ReserveBitMask, restojob.ReservationType,
				restojob.PrimaryRCID, restojob.ClientTokenId, restojob.DestMediaGroupId,
				res.CopyId, res.StreamId, res.VolumeId, res.MediaId, res.DriveId, res.ClientId, res.DrivePoolId, res.MasterPoolId,
				res.MediaGroupId, res.ReservationTime, res.ResourceFlag, res.PrimaryResId,
				res.LibraryId, res.LibraryTypeId, res.SpareGroupId, res.MountPathId, res.ScheduleRunId, res.NoOtherSchedule, res.SIDBStoreId
		FROM		MMResource res, MMResourceToJob restojob
		WHERE		restojob.JobId_l = @jobId
		AND			res.ReservationId = restojob.ReservationId
		AND			res.HasJobInterrupted = 1
		ROLLBACK TRANSACTION BACKUP_RESERVATION_TRANS
		UPDATE MMResource SET IntrJobId_l = @jobId
		WHERE	ReservationId IN (SELECT InterruptedReservationId FROM @interruptedResource)
		-- create new reservation
		-- sqlexec_cv has "ALTER TABLE" rights on HistoryDB..MMResource, so no impersonation needed
		SET IDENTITY_INSERT HistoryDB..MMResource ON
		INSERT INTO MMResource (ReservationId, CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
								MasterPoolId, MediaGroupId, IntrJobId_h, IntrJobId_l, HasJobInterrupted, ReservationType,
								ReservationTime, Priority, PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
								DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId,
								NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId)
							SELECT DISTINCT ReservationId, CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
								MasterPoolId, MediaGroupId, 0, 0, 1, ReservationType,
								ReservationTime, Priority, PreEmptable, 0, 0, ResourceFlag, PrimaryResId, 0, 0,
								0, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, 0, ScheduleRunId,
								NoOtherSchedule, 0, 0, SIDBStoreId
		FROM @interruptingResources
		SET IDENTITY_INSERT HistoryDB..MMResource OFF
		INSERT INTO MMResourceToJob (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
			ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
			DestMediaGroupId, LogicalReleased, Flag)
		SELECT DISTINCT ReservationId, 0, JobId, Priority, PreEmptable, 1 /*inUse*/,
			ReservationBitMask, 0, ReservationType, RCId, PrimaryRCID, ClientTokenId,
			DestMediaGroupId, 0, 0
		FROM @interruptingResources
		UPDATE GXCounter set next_l = (SELECT MAX(RCID) FROM @interruptingResources) where name = 'RCID_Counter'
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		update RMReservationRequest
		set ErrorCode = @o_ErrorCode,
			FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
			FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
		where RequestId = @i_RequestId
		IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
			select @o_ErrorCode, @o_FailureType, ''
		END
	end
	else
	begin
		if @canCommitReservations > 0
		begin
		  update RMReservationRequest
		  set ErrorCode = @o_ErrorCode,
				FailureType = @o_FailureType,
                RequestTime = dbo.GetUnixTime(getutcdate()),
				FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
				PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
				ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
		  where RequestId = @i_RequestId
			IF EXISTS (SELECT 1 FROM @tblVMPowerOnReq WHERE hostSoftState <> 0)
			BEGIN
				DECLARE @MAList varchar(1024) = ''
				SELECT  @MAList = @MAList + name + + ', '
				FROM    APP_Client A WITH (NOLOCK) INNER JOIN @tblVMPowerOnReq B ON A.id = B.HostId
				WHERE	hostSoftState <> 0
				IF @i_isDebug > 0
					insert into RMLogger values('RMReserveForBackup', 'Reserved power managed MAs, recording the usage for the MAs [' + @MAList + '].', @i_RequestId, getutcdate())
				INSERT INTO #tmpVMPowerOnReq
				SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
				FROM @tblVMPowerOnReq WHERE hostSoftState <> 0
				-- This sp does not submit power on request if the MA is already online, it records the last used time of this MA so that MM service can decide when to auto power off the VM.
				EXEC @retCode = RMSubmitVMPowerONRequest 0
				IF @retCode > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveForBackup', 'Failed to record the power managed MAs usage for the MAs ['	+ @MAList + '] with retCode [ '+ @retCode +' ] .', @i_RequestId, getutcdate())
set @o_ErrorCode 		= 415
set @o_FailureType 	= 2
				END
				DELETE FROM #tmpVMPowerOnReq
			END
			IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
select 0, FailureType, @o_ReservationList
			  from RMReservationRequest
			  where RequestId = @i_RequestId
			END
		end
		else if @l_SubmitDriveReqToLS = 0
		and @l_SubmitPowerOnReqToVM = 0
		and @containInlineCopy = 0
and @o_ErrorCode = 20163
		begin
			ROLLBACK TRANSACTION BACKUP_RESERVATION_TRANS
			delete RMLogger where RequestId = @i_RequestId
			insert into RMLogger
			select * from @tempLog
			if @i_isDebug > 0
				insert into RMLogger values ('RMReserveForBackup', 'Enter For Job['+ cast(@jobId as varchar(20)) + ']', @i_RequestId, getutcdate())
			set @reservationResults = ''
			exec @o_ErrorCode = RMReserveForLoadBalanceBackup @i_RequestId, @jobId, @primaryCopyId, @i_isDebug,
															@reservationResults output, @o_ErrorCode output, @o_FailureType output
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			end
			set @o_ReservationList = cast(@reservationResults as nvarchar(max))
			IF OBJECT_ID('tempdb..#__suppress_results') IS NULL
			BEGIN
				select ErrorCode, FailureType, @o_ReservationList
				from RMReservationRequest
				where RequestId = @i_RequestId
			END
		end
		else
		begin
			IF	@containInlineCopy = 1
AND @o_ErrorCode = 20163
			BEGIN
set @o_ErrorCode = 20167
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForBackup', 'No inline backup support for data path loadbalance within one backup job', @i_RequestId, getutcdate())
			END
			--Dump the required data into table before Rollback
			IF @l_SubmitDriveReqToLS > 0
			BEGIN
				DECLARE @preferredDriveList TABLE (DrivePoolId INT, DriveNumberList VARCHAR(MAX))
				INSERT INTO @preferredDriveList
				SELECT	DISTINCT Res.DrivePoolId, ''
				FROM	RMreservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
				WHERE	RES.RequestId = @i_RequestId
				AND		RES.LibraryId = L.LibraryId
				AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
				UPDATE @preferredDriveList
				SET		DriveNumberList = (
											SELECT CAST(Drive.DriveNumber AS VARCHAR(10)) + ',' AS [text()]
											FROM	MMDriveController DC WITH (NOLOCK), MMDrive Drive WITH (NOLOCK)
											WHERE	DC.DrivePoolId = P.DrivePoolId
											AND		DC.DriveId = Drive.DriveId
AND		Drive.Attributes & 128 = 0
											AND		Drive.DriveBroken = 0
											AND		Drive.DriveEnabled = 1
AND		MountStatus not in (4, 2, 3)
											AND		((Drive.DriveSoftState = 1)
													OR
													(Drive.DriveSoftState <> 1 AND Drive.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER))
											FOR XML PATH('')
										)
				FROM	@preferredDriveList P
				INSERT INTO @tblLibServerDriveReq
				SELECT RES.JobId, 2, RES.LibraryId, ISNULL(P.DriveNumberList, ''), COUNT(DISTINCT RES.DriveId)
				FROM 	RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK), @preferredDriveList P
				WHERE 	RES.RequestId = @i_RequestId
				AND		RES.LibraryId = L.LibraryId
				AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
				AND		RES.DriveId = D.driveId
				AND 	D.DriveSoftState <> 1
AND		D.MountStatus not in (4, 2, 3)
				AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
                AND     RES.DrivePoolId = P.DrivePoolId
				GROUP BY RES.JobId, RES.LibraryId, ISNULL(P.DriveNumberList, '')
			END
			ROLLBACK TRANSACTION BACKUP_RESERVATION_TRANS
			delete RMLogger where RequestId = @i_RequestId
			insert into RMLogger
			select * from @tempLog
			-- Create LS drive request
			IF (@l_SubmitDriveReqToLS > 0)
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveForBackup', 'Submitting request for shared drives to library server due to error ['
					  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				--Create and populate the shared temp table before submitting the request
				if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
				CREATE TABLE #tmpLibServerDriveReq (
					RMRequestId		INT,
					jobId 				INT,
					commCellId 		INT,
					libraryId			INT,
					driveNumber 	VARCHAR(MAX),
					driveCnt			INT,
					PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId)
				)
				INSERT INTO #tmpLibServerDriveReq
				SELECT 0, jobId, commCellId, libraryId, driveNumber, driveCnt
				FROM @tblLibServerDriveReq
				EXEC @o_ErrorCode = RMSubmitLSDriveRequest 0
				IF @o_ErrorCode > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveForBackup', 'Failed to submit request for shared drives to library server due to error ['
						  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode = 415
set @o_FailureType = 2
				END
				ELSE
				BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 1
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveForBackup', 'Successfully submitted request for shared drives to library server - Error Code['
						  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				END
			END
			IF @l_SubmitPowerOnReqToVM > 0
			BEGIN
				IF @l_PMOfflineVMCntWithInlineCopy > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveForBackup', 'Submitting cloud VM power on request due to the reason ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
					INSERT INTO #tmpVMPowerOnReq
					SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
					FROM @tblVMPowerOnReq WHERE isForDDB = 0 AND hostSoftState <> 1
					EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
					IF @o_ErrorCode > 0
					BEGIN
						IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveForBackup', 'Failed to submit cloud VM power on request due to error ['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode 		= 415
set @o_FailureType 	= 2
					END
					ELSE
					BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
						IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveForBackup', 'Successfully submitted cloud VM power on request - Error Code['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
					END
					DELETE FROM #tmpVMPowerOnReq
				END
				-- Now submit power on request for DDB MAs if there are any.
				ELSE IF @l_PMOfflineDDBVMCntWithInlineCopy > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveForBackup', 'Submitting DDB cloud VM power on request due to the reason ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
					INSERT INTO #tmpVMPowerOnReq
					SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
					FROM @tblVMPowerOnReq WHERE isForDDB > 0 AND hostSoftState <> 1
					EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
					IF @o_ErrorCode > 0
					BEGIN
						IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveForBackup', 'Failed to submit DDB cloud VM power on request due to error ['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode 		= 415
set @o_FailureType 	= 2
					END
					ELSE
					BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
						IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveForBackup', 'Successfully submitted DDB cloud VM power on request - Error Code['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
					END
					DELETE FROM #tmpVMPowerOnReq
				END
			END
			-- Reservation failure case we should not set the EMPTY_RESULTS
			-- since we tries to un-serialize to get the error list, which fails if this EMPTY_RESULTS is set
			if @o_ReservationList like '%EMPTY_RESULTS%'
				set @o_ReservationList = REPLACE(@o_ReservationList, 'EMPTY_RESULTS', '')
		  update RMReservationRequest
		  set ErrorCode = @o_ErrorCode,
		  		FailureType = @o_FailureType,
                RequestTime = dbo.GetUnixTime(getutcdate()),
				FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
		  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
		  		ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
		  where RequestId = @i_RequestId
			IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
			  select ErrorCode, FailureType, @o_ReservationList
			  from RMReservationRequest
			  where RequestId = @i_RequestId
			END
		end
	end
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
    delete RMReservations
    where RequestId = @i_RequestId
  end
  */
	if @i_isDebug > 0
	  insert into RMLogger values('RMReserveForBackup', 'Exit...', @i_RequestId, getutcdate())
 	return @o_ErrorCode
GO


IF EXISTS (select * from GxQscripts where name = 'RMReserveForBackup')
	delete from GxQscripts where name = 'RMReserveForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForBackup')
	delete from GXDBVersions where aliasname = 'RMReserveForBackup'
GO

insert into GXDBVersions values(2, 'RMReserveForBackup',  '00010051000200270000', 'RMReserveForBackup', '00010051000200270000')
GO

