

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveForAuxCopy.sp,v $ $Id: RMReserveForAuxCopy.sp,v 1.19.2.5 2018/03/26 12:48:21 kbora Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveForAuxCopy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMReserveForAuxCopy <<<'

IF EXISTS (select * from sysobjects where name='RMReserveForAuxCopy')
	drop procedure RMReserveForAuxCopy
IF EXISTS (select * from GxQscripts where name='RMReserveForAuxCopy')
	delete from GxQscripts where name = 'RMReserveForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveForAuxCopy'
GO
print '... Creating Procedure: RMReserveForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReserveForAuxCopy
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationList NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_ReservationList = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	insert into RMLogger values ('RMReserveForAuxCopy', 'Enter...', @i_RequestId, getutcdate())
	declare @sourceReservationResults XML
	set @sourceReservationResults = ''
	--Create and populate the shared temp table before submitting power on request
	if object_id('tempdb.dbo.#tmpVMPowerOnReq') is not null DROP TABLE #tmpVMPowerOnReq
	CREATE TABLE #tmpVMPowerOnReq (
			RMRequestId		INT,
			HostId			INT,
			jobId 			INT,
			commCellId 		INT,
			PRIMARY KEY (jobId, HostId)
		)
	SAVE TRANSACTION AUXCOPY_RESERVATION_TRANS
	exec RMReserveSourceForAuxCopy @i_RequestId, @i_isDebug, @o_ErrorCode output, @o_FailureType output, @sourceReservationResults output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	end
if @o_ErrorCode != 0
	begin
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@sourceReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
set @o_FailureType = 4
		-- For dash copy reservation, mark the stream status as fail before update reservation request
		if exists (SELECT 1 FROM ArchJobStreamStatus WITH (NOLOCK) WHERE ReservationRequestId = @i_RequestId)
		begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE ReservationRequestId = @i_RequestId
		end
	  update RMReservationRequest
	  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
			FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
 	  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
				ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
	  where RequestId = @i_RequestId
	  goto exit_error
	end
	set @o_ReservationList = cast(@sourceReservationResults as nvarchar(max))
	declare @destReservationResults XML
	set @destReservationResults = ''
	exec RMReserveDestinationForAuxCopy @i_RequestId, @i_isDebug, @o_ErrorCode output, @o_FailureType output, @destReservationResults output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	end
	set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@o_ReservationList as nvarchar(max)) + cast(@destReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
	-- For dash copy reservation, mark the stream status as fail before update reservation request
if @o_ErrorCode != 0
	and exists (SELECT 1 FROM ArchJobStreamStatus WITH (NOLOCK) WHERE ReservationRequestId = @i_RequestId)
	begin
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE ReservationRequestId = @i_RequestId
	end
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
            RequestTime = dbo.GetUnixTime(getutcdate()),
			FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
   		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
  where RequestId = @i_RequestId
exit_error:
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
	  select top 1 ErrorCode, FailureType, @o_ReservationList
	  from RMReservationRequest
	  where RequestId = @i_RequestId
	  order by ErrorCode desc
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
    delete RMReservations
    where RequestId = @i_RequestId
  end
	*/
  insert into RMLogger values('RMReserveForAuxCopy', 'Exit...', @i_RequestId, getutcdate())
 	return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveForAuxCopy')
	delete from GxQscripts where name = 'RMReserveForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveForAuxCopy'
GO

insert into GXDBVersions values(2, 'RMReserveForAuxCopy',  '00010019000200050000', 'RMReserveForAuxCopy', '00010019000200050000')
GO

