

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveDestinationForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveDestinationForAuxCopy.sp,v $ $Id: RMReserveDestinationForAuxCopy.sp,v 1.24.44.20.46.1 2021/02/24 11:11:11 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveDestinationForAuxCopy()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMReserveDestinationForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveDestinationForAuxCopy <<<'
	drop procedure RMReserveDestinationForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='RMReserveDestinationForAuxCopy')
	delete from GxQscripts where name = 'RMReserveDestinationForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveDestinationForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveDestinationForAuxCopy'
GO
print '... Creating Procedure: RMReserveDestinationForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMReserveDestinationForAuxCopy
  @i_RequestId int,
  @i_isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT,
  @o_ReservationList XML 		OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	set @o_ReservationList = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	declare @canCommitReservations int
	declare @howManySuccessReservations int
	set @canCommitReservations = 0
	set @howManySuccessReservations = 0
	DECLARE @l_SubmitDriveReqToLS		INTEGER
	SET			@l_SubmitDriveReqToLS		= 0
	DECLARE @l_LSOfflineDriveCnt		INTEGER
	SET			@l_LSOfflineDriveCnt		= 0
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	DECLARE @l_SubmitPowerOnReqToVM				INTEGER
	SET			@l_SubmitPowerOnReqToVM				= 0
	DECLARE @l_PMOfflineVMCount					INTEGER
	SET			@l_PMOfflineVMCount					= 0
	DECLARE @l_PMOfflineDDBVMCount				INTEGER
	SET			@l_PMOfflineDDBVMCount				= 0
	DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
	SET			@HOST_STATUS_POWER_MANAGED_VM		= 7
	DECLARE @tblLibServerDriveReq TABLE (
		mediaGroupId              INT,
		jobId 			INT,
		commCellId 	INT,
		libraryId		INT,
		driveNumber VARCHAR(MAX),
		driveCnt		INT,
		PRIMARY KEY (mediaGroupId, jobId, commCellId, libraryId)
	)
	DECLARE @tblVMPowerOnReq TABLE (
		RMRequestId			INT,
		HostId				INT,
		jobId 				INT,
		commCellId 			INT,
		isForDDB	 		INT,
		hostSoftState		INT,
		hostOfflineReason 	INT,
		PRIMARY KEY (jobId, HostId, isForDDB)
	)
	SAVE TRANSACTION DEST_RESERVATION_TRANS
	-- check if job has interrupted anything
	declare @jobId int = 0
	select @jobId = jobId
	from RMReservationRequest where RequestId = @i_RequestId
	if @@ROWCOUNT = 0
	begin
		-- Double check if the request still exists or not
set @o_ErrorCode = 415
		if @i_isDebug > 0
			  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Cannot find current requestId ['
										+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		goto exit_error
	end
	-- delete RMLogger where requestId = @i_RequestId
	if @i_isDebug > 0
		insert into RMLogger values ('RMReserveDestinationForAuxCopy', 'Enter For Job['+ cast(@jobId as varchar(20)) + ']', @i_RequestId, getutcdate())
	declare @destReservationResults XML
	set @destReservationResults = ''
	-- fetch destination copy id list
	declare @copyIdList varchar(200)
	declare @failIfSecondaryCopyError int
	declare @destCopyId int
	declare @xmlParams XML
	declare @xmlCopyInfoList XML
	declare @retCode INT = 0
	select @xmlParams = xmlParams
	from RMReservationRequest
	where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmAuxcopyReservationArgs_t') > 0
		BEGIN
			SELECT	@failIfSecondaryCopyError	= params.value('@failIfSecondaryCopyError', 'int'),
							@xmlCopyInfoList = params.query('//copyInfoList')
			FROM	@xmlParams.nodes('/ResourceManager_RmAuxcopyReservationArgs_t[1]/destinationArgs[1]') AS R(params)
		END
	END
	IF @xmlCopyInfoList IS NOT NULL AND @xmlCopyInfoList.exist('/copyInfoList') = 1
	BEGIN
		IF (Cursor_Status('LOCAL', 'inlineCopy_Cursor') >= -1)
		BEGIN
			CLOSE inlineCopy_Cursor
			DEALLOCATE inlineCopy_Cursor
		END
		DECLARE inlineCopy_Cursor CURSOR LOCAL FOR
			SELECT	DISTINCT params.value('@copyId', 'int')
			FROM	@xmlCopyInfoList.nodes('/copyInfoList') AS R(params)
		OPEN inlineCopy_Cursor
		FETCH NEXT FROM inlineCopy_Cursor INTO @destCopyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
SET @o_ErrorCode = 0
			SET @destReservationResults = ''
			-- inline copy reservation
			exec @o_ErrorCode = RMReserveWriters @i_RequestId, @destCopyId, 1, @i_isDebug,
																					 @destReservationResults output, @o_ErrorCode output, @o_FailureType output
			if @@ERROR > 0
			begin
set @o_ErrorCode = 415
set @o_FailureType = 2
			end
			set @o_ReservationList = cast(@o_ReservationList as nvarchar(max)) + cast(@destReservationResults as nvarchar(max))
if @o_ErrorCode = 0
or @o_ErrorCode = 20005
			begin
				set @howManySuccessReservations = @howManySuccessReservations + 1
			end
			else if @failIfSecondaryCopyError > 0
			begin
				if @i_isDebug > 0
				  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Reservation for copy ['
				  												+ cast(@destCopyId as varchar(10)) +'] return error ['
				  												+ cast(@o_ErrorCode as varchar(10)) + ']. Do not continue because of job option failIfSecondaryCopyError.',
				  												@i_RequestId, getutcdate())
				break
			end
			if @i_isDebug > 0
			  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Reservation for copy ['
			  												+ cast(@destCopyId as varchar(10)) +'] return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + ']. Continue to the next copy.', @i_RequestId, getutcdate())
			FETCH NEXT FROM inlineCopy_Cursor INTO @destCopyId
		END
		CLOSE inlineCopy_Cursor
		DEALLOCATE inlineCopy_Cursor
		if @howManySuccessReservations > 0 and
(@o_ErrorCode = 0
		--or @o_ErrorCode = E_MM_NO_RESOURCE_INTERRUPTED_JOB
		or @failIfSecondaryCopyError = 0)
		begin
			set @canCommitReservations = 1
		end
		set @destReservationResults = @o_ReservationList
	END
	ELSE
	BEGIN
		-- Only one Auxcopy this time
		select @destCopyId = copyId
		from RMReservationRequest
		where RequestId = @i_RequestId
		exec @o_ErrorCode = RMReserveWriters @i_RequestId, @destCopyId, 1, @i_isDebug,
																				 @destReservationResults output, @o_ErrorCode output, @o_FailureType output
		if @@ERROR > 0
		begin
set @o_ErrorCode = 415
set @o_FailureType = 2
		end
		set @o_ReservationList = @destReservationResults
if @o_ErrorCode = 0
or @o_ErrorCode = 20005
		begin
				set @howManySuccessReservations = @howManySuccessReservations + 1
 				set @canCommitReservations = 1
		end
		else
		begin
			if @i_isDebug > 0
			  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Reservation for copy ['
			  												+ cast(@destCopyId as varchar(10)) +'] return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].',
			  												@i_RequestId, getutcdate())
		end
	END
	--Check if any offline LS drives are reserved for Aux copy
	SELECT @l_LSOfflineDriveCnt = COUNT(DISTINCT RES.driveId)
	FROM  RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.LibraryId = L.LibraryId
	AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	AND		RES.DriveId = D.driveId
	AND 	D.DriveSoftState <> 1
	AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
	IF @l_LSOfflineDriveCnt > 0
	BEGIN
		SET @howManySuccessReservations = 0
		SET @canCommitReservations = 0
SET @o_ErrorCode = 340
SET @o_FailureType = 1
		SET @l_SubmitDriveReqToLS = 1
	END
	-- check for total offline power managed VMs count which are reserved reserved for Aux copy.
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, RES.ClientId, RES.JobId, 2, 0, H.MmHostSoftState, H.OfflineReason
	FROM  RMReservations RES WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE RES.RequestId = @i_RequestId
	AND		RES.ClientId = H.ClientId
AND 	H.Attribute & 32768 > 0
	SELECT @l_PMOfflineVMCount  = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	-- check if any offline power managed VMs are part sec copy's DDB
	INSERT INTO @tblVMPowerOnReq
	SELECT DISTINCT RES.RequestId, HOST.ClientId, RES.JobId, 2, 1, HOST.MmHostSoftState, HOST.OfflineReason
	FROM RMReservations RES WITH (NOLOCK) INNER JOIN MMVolume V WITH (NOLOCK) ON RES.VolumeId = V.VolumeId
		INNER JOIN IdxSIDBSubStore subStore WITH (NOLOCK) ON subStore.SIDBStoreId = V.SIDBStoreId
		INNER JOIN MMHost HOST WITH (NOLOCK) ON HOST.ClientId = subStore.ClientId
		INNER JOIN IdxCache idxc WITH (NOLOCK) ON idxc.IdxCacheId = subStore.IdxCacheId
		INNER JOIN IdxAccessPath idxa WITH (NOLOCK) ON idxa.IdxAccessPathId = subStore.IdxAccessPathId
	WHERE RES.RequestId = @i_RequestId
		AND V.SIDBStoreId > 0
		AND HOST.MMHostEnabled <> 0
		AND idxc.Enabled <> 0
		AND idxa.Enabled <> 0
AND RES.ReservationType = 2
AND HOST.Attribute & 32768 = 32768
		AND NOT EXISTS (SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
								 INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
						WHERE 	VM.HostId = HOST.ClientId
								AND VM.FailureReason = 2
								AND VMMAP.EntityId = @jobId
AND VMMAP.EntityType = 1)
		AND NOT EXISTS (SELECT 1 FROM @tblVMPowerOnReq tmp WHERE tmp.HostId = HOST.ClientId)
	SELECT @l_PMOfflineDDBVMCount = COUNT(DISTINCT HostId) FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1 AND hostOfflineReason = @HOST_STATUS_POWER_MANAGED_VM
	IF @l_PMOfflineVMCount > 0 OR @l_PMOfflineDDBVMCount > 0
	BEGIN
		SET @howManySuccessReservations = 0
		SET @canCommitReservations = 0
SET @o_ErrorCode = 346
SET @o_FailureType = 1
		SET @l_SubmitPowerOnReqToVM = 1
	END
exit_error:
	/*
	if @o_ReservationList is not null and len(cast(@o_ReservationList as nvarchar(max))) > 0
		set @o_ReservationList = '<ResourceManager_ReservationList>' + cast(@o_ReservationList as nvarchar(max)) + '</ResourceManager_ReservationList>'
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		ReservationResults = '<ResourceManager_ReservationList>' + cast(ReservationResults as nvarchar(max))
  													+ cast(@destReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
  where RequestId = @i_RequestId
	*/
	declare @tempLog table
	(
			RMModule	varchar(100),
			State		varchar(max),
			RequestId	integer,
			TimeStamp	datetime
	)
if @o_ErrorCode = 20005
	begin
		-- If there is interruption happens, should rollback all the database changes and only keep the interruption related changes.
		-- Including:
		-- 1. Interrupting job id set on interrupted resources
		-- 2. Dummy reservations for interrupting job
		DECLARE @interruptedResource	TABLE (
				InterruptedReservationId	INT
		)
		DECLARE @interruptingResources TABLE (
				ReservationId				INT,
				RCId						INT,
				JobId						bigint,
				Priority					INT,
				PreEmptable					INT,
				ReservationBitMask			INT,
				ReservationType				INT,
				PrimaryRCID					INT,
				ClientTokenId				INT,
				DestMediaGroupId			INT,
				CopyId						INT,
				StreamId					INT,
				VolumeId					INT,
				MediaId						INT,
				DriveId						INT,
				ClientId 					INT,
				DrivePoolId					INT,
				MasterPoolId				INT,
				MediaGroupId				INT,
				ReservationTime				INT,
				ResourceFlag				INT,
				PrimaryResId				INT,
				LibraryId					INT,
				LibraryTypeId				INT,
				SpareGroupId				INT,
				MountPathId					INT,
				ScheduleRunId				bigint,
				NoOtherSchedule				INT,
				SIDBStoreId					INT
		)
		INSERT INTO @interruptedResource
		SELECT		ReservationId
		FROM		MMResource
		WHERE		IntrJobId_h = 0 AND IntrJobId_l =  @jobId
		INSERT INTO @interruptingResources
		SELECT	res.ReservationId, restojob.RCId, @jobId,
				restojob.Priority, restojob.PreEmptable, restojob.ReserveBitMask, restojob.ReservationType,
				restojob.PrimaryRCID, restojob.ClientTokenId, restojob.DestMediaGroupId,
				res.CopyId, res.StreamId, res.VolumeId, res.MediaId, res.DriveId, res.ClientId, res.DrivePoolId, res.MasterPoolId,
				res.MediaGroupId, res.ReservationTime, res.ResourceFlag, res.PrimaryResId,
				res.LibraryId, res.LibraryTypeId, res.SpareGroupId, res.MountPathId, res.ScheduleRunId, res.NoOtherSchedule, res.SIDBStoreId
		FROM		MMResource res, MMResourceToJob restojob
		WHERE		restojob.JobId_l = @jobId
		AND			res.ReservationId = restojob.ReservationId
		AND			res.HasJobInterrupted = 1
		insert into @tempLog
		select RMModule, State, RequestId, TimeStamp
		from	RMLogger with (readuncommitted)
		where	RequestId = @i_RequestId
		ROLLBACK TRANSACTION DEST_RESERVATION_TRANS
		ROLLBACK TRANSACTION AUXCOPY_RESERVATION_TRANS
		UPDATE MMResource SET IntrJobId_l = @jobId
		WHERE	ReservationId IN (SELECT InterruptedReservationId FROM @interruptedResource)
		-- create new reservation
		-- sqlexec_cv has "ALTER TABLE" rights on HistoryDB..MMResource, so no impersonation needed
		SET IDENTITY_INSERT HistoryDB..MMResource ON
		INSERT INTO MMResource (ReservationId, CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
								MasterPoolId, MediaGroupId, IntrJobId_h, IntrJobId_l, HasJobInterrupted, ReservationType,
								ReservationTime, Priority, PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
								DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId,
								NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId)
							SELECT DISTINCT ReservationId, CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
								MasterPoolId, MediaGroupId, 0, 0, 1, ReservationType,
								ReservationTime, Priority, PreEmptable, 0, 0, ResourceFlag, PrimaryResId, 0, 0,
								0, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, 0, ScheduleRunId,
								NoOtherSchedule, 0, 0, SIDBStoreId
		FROM @interruptingResources
		SET IDENTITY_INSERT HistoryDB..MMResource OFF
		INSERT INTO MMResourceToJob (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
			ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
			DestMediaGroupId, LogicalReleased, Flag)
		SELECT DISTINCT ReservationId, 0, JobId, Priority, PreEmptable, 0,
			ReservationBitMask, 0, ReservationType, RCId, PrimaryRCID, ClientTokenId,
			DestMediaGroupId, 0, 0
		FROM @interruptingResources
		UPDATE GXCounter set next_l = (SELECT MAX(RCID) FROM @interruptingResources) where name = 'RCID_Counter'
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		update RMReservationRequest
		set ErrorCode = @o_ErrorCode,
			FailureType = @o_FailureType,
			FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
MaxNumOfAttempts = case when @o_ErrorCode = 20005 then 1 else MaxNumOfAttempts end,
 			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@o_ReservationList as nvarchar(max)), 4000)
		where RequestId = @i_RequestId
	end
	ELSE IF @canCommitReservations > 0
	BEGIN
set @o_ErrorCode = 0
		IF EXISTS (SELECT 1 FROM @tblVMPowerOnReq WHERE hostSoftState <> 0)
		BEGIN
			DECLARE @MAList varchar(1024) = ''
			SELECT  @MAList = @MAList + name + + ', '
			FROM    APP_Client A WITH (NOLOCK) INNER JOIN @tblVMPowerOnReq B ON A.id = B.HostId
			WHERE	hostSoftState <> 0
			IF @i_isDebug > 0
				insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Reserved power managed MAs, recording the usage for the MAs [' + @MAList + '].', @i_RequestId, getutcdate())
			INSERT INTO #tmpVMPowerOnReq
			SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
			FROM @tblVMPowerOnReq WHERE hostSoftState <> 0
			-- This sp does not submit power on request if the MA is already online, it records the last used time of this MA so that MM service can decide when to auto power off the VM.
			EXEC @retCode = RMSubmitVMPowerONRequest 0
			IF @retCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Failed to record the power managed MAs usage for the MAs ['	+ @MAList + '] with retCode [ '+ @retCode +' ] .', @i_RequestId, getutcdate())
			END
			DELETE FROM #tmpVMPowerOnReq
		END
	END
	ELSE
	BEGIN
		--Dump the required data into table before Rollback
		IF @l_SubmitDriveReqToLS > 0
		BEGIN
			DECLARE @preferredDriveList TABLE (DrivePoolId INT, DriveNumberList VARCHAR(MAX))
			INSERT INTO @preferredDriveList
			SELECT	DISTINCT Res.DrivePoolId, ''
			FROM	RMreservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK)
			WHERE	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			UPDATE @preferredDriveList
			SET		DriveNumberList = (
										SELECT CAST(Drive.DriveNumber AS VARCHAR(10)) + ',' AS [text()]
										FROM	MMDriveController DC WITH (NOLOCK), MMDrive Drive WITH (NOLOCK)
										WHERE	DC.DrivePoolId = P.DrivePoolId
										AND		DC.DriveId = Drive.DriveId
AND		Drive.Attributes & 128 = 0
										AND		Drive.DriveBroken = 0
										AND		Drive.DriveEnabled = 1
AND		MountStatus not in (4, 2, 3)
										AND		((Drive.DriveSoftState = 1)
												OR
												(Drive.DriveSoftState <> 1 AND Drive.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER))
										FOR XML PATH('')
									)
			FROM	@preferredDriveList P
			INSERT INTO @tblLibServerDriveReq
			SELECT RES.MediaGroupId, RES.JobId, 2, RES.LibraryId, ISNULL(P.DriveNumberList, ''), COUNT(DISTINCT RES.DriveId)
			FROM 	RMReservations RES WITH (NOLOCK), MMLibrary L WITH (NOLOCK), MMDrive D WITH (NOLOCK), @preferredDriveList P
			WHERE 	RES.RequestId = @i_RequestId
			AND		RES.LibraryId = L.LibraryId
			AND		L.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
			AND		RES.DriveId = D.driveId
			AND 	D.DriveSoftState <> 1
AND		D.MountStatus not in (4, 2, 3)
			AND 	D.OfflineReason = @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER
            AND     RES.DrivePoolId = P.DrivePoolId
			GROUP BY RES.MediaGroupId, RES.JobId, RES.LibraryId, ISNULL(P.DriveNumberList, '')
		END
		insert into @tempLog
		select RMModule, State, RequestId, TimeStamp
		from	 RMLogger with (readuncommitted)
		where		RequestId = @i_RequestId
		ROLLBACK TRANSACTION DEST_RESERVATION_TRANS
		ROLLBACK TRANSACTION AUXCOPY_RESERVATION_TRANS
		delete RMLogger where RequestId = @i_RequestId
		insert into RMLogger
		select * from @tempLog
		-- When dash copy or auxcopy job does interruption, the reservation may still fail due to other reason like stream still be reserved.
		-- In this case, interrupted resource will be kept in database only when current job get the resource.
		-- That may put a long delay especially using tape library.
IF  @o_ErrorCode != 20005
		AND EXISTS (SELECT 1 FROM MMResource with (readuncommitted) where HasJobInterrupted = 1 and ReservationId in
  					 (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId))
		BEGIN
			-- check if interrupted resource can be claimed
			-- There is no need to check the status in MMResource, as long as the entry MMResourceToJob is marked released for interrupted jobs.
			--if exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and Released = 0)
			if not exists (select 1 from MMResourceToJob with (readuncommitted) where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and NOT (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))))
and not exists (select 1 from MMResource with (readuncommitted) where intrjobid_l = @jobId and DriveId in (select DriveId from MMDrive with (readuncommitted) where MountStatus in (2, 3)))
			begin
				-- To prevent frequent interruption, set time limit on how long the job will need to wait until give up the interrupted resource
				declare @interruptResId table (id integer)
				declare @interruptWaitTime int = 1
				select @interruptWaitTime = isnull(value, 1) from MMConfigs with (readuncommitted) where name = 'Resource Manager interrupted resource on hold time limit in minutes'
				if exists (select 1 from MMResource with (readuncommitted)
							where ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId)
							and HasJobInterrupted = 1
							and (ReservationTime + @interruptWaitTime * 60) <= dbo.GetUnixTime(getutcdate())
				)
				begin
					-- release interrupted resource
					delete from MMresourceToJob
					where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0)))
					delete from MMResource where intrjobid_l = @jobId
					-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
					-- those are place holder anyway, also we will have to check availability of everything
					insert into @interruptResId
					select reservationid from MMResource with (readuncommitted) where ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @jobId)  and HasJobInterrupted = 1
					if @i_isDebug > 0
					begin
						insert into RMLogger values ('Claim Interruption',
													cast(isnull((
															select distinct a.ReservationId RID, a.CopyId, a.StreamId, b.RCID, b.JobId_l JobId
															from MMResource a with (readuncommitted), MMResourceToJob b with (readuncommitted)
															where a.ReservationId = b.ReservationId and a.ReservationId in (select id from @interruptResId)
															for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resources') as nvarchar(max)),
													@i_RequestId, getutcdate())
					end
					delete from MMResourceToJob where ReservationId in (select id from @interruptResId)
					delete from MMResource where ReservationId in (select id from @interruptResId)
				end
			END
		END
		-- Create LS drive request
		IF (@l_SubmitDriveReqToLS > 0)
		BEGIN
			IF @i_isDebug > 0
				  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Submitting request for shared drives to library server due to error ['
				  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			--Create and populate the shared temp table before submitting the request
			if object_id('tempdb.dbo.#tmpLibServerDriveReq') is not null DROP TABLE #tmpLibServerDriveReq
			CREATE TABLE #tmpLibServerDriveReq (
				RMRequestId		INT,
				jobId 				INT,
				commCellId 		INT,
				libraryId			INT,
				driveNumber 	VARCHAR(MAX),
				driveCnt			INT,
				PRIMARY KEY (RMRequestId, jobId, commCellId, libraryId)
			)
			INSERT INTO #tmpLibServerDriveReq
			SELECT mediaGroupId, jobId, commCellId, libraryId, driveNumber, driveCnt
			FROM @tblLibServerDriveReq
			EXEC @o_ErrorCode = RMSubmitLSDriveRequest 0
			IF @o_ErrorCode > 0
			BEGIN
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Failed to submit request for shared drives to library server due to error ['
					  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
set @o_ErrorCode = 415
set @o_FailureType = 2
			END
			ELSE
			BEGIN
SET @o_ErrorCode = 340
SET @o_FailureType = 2
				IF @i_isDebug > 0
					  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Successfully submitted request for shared drives to library server - Error Code['
					  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			END
		END
		IF @l_SubmitPowerOnReqToVM > 0
		BEGIN
			IF @l_PMOfflineVMCount > 0
			BEGIN
				IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Submitting cloud VM power on request due to the reason ['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				INSERT INTO #tmpVMPowerOnReq
				SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
				FROM @tblVMPowerOnReq WHERE isForDDB = 0 AND hostSoftState <> 1
				EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
				IF @o_ErrorCode > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Failed to submit cloud VM power on request due to error ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
SET @o_ErrorCode 	= 415
SET @o_FailureType 	= 2
				END
				ELSE
				BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Successfully submitted cloud VM power on request - Error Code['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				END
				DELETE FROM #tmpVMPowerOnReq
			END
			IF @l_PMOfflineDDBVMCount > 0
			BEGIN
				IF @i_isDebug > 0
							  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Submitting DDB cloud VM power on request due to the reason ['
																			+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				INSERT INTO #tmpVMPowerOnReq
				SELECT DISTINCT @i_RequestId, HostId, jobId, commCellId
				FROM @tblVMPowerOnReq WHERE isForDDB = 1 AND hostSoftState <> 1
				EXEC @o_ErrorCode = RMSubmitVMPowerONRequest 0
				IF @o_ErrorCode > 0
				BEGIN
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Failed to submit DDB cloud VM power on request due to error ['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
SET @o_ErrorCode 	= 415
SET @o_FailureType 	= 2
				END
				ELSE
				BEGIN
SET @o_ErrorCode 	= 346
SET @o_FailureType 	= 1
					IF @i_isDebug > 0
						  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Successfully submitted DDB cloud VM power on request - Error Code['
																		+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
				END
				DELETE FROM #tmpVMPowerOnReq
			END
		END
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
    delete RMReservations
    where RequestId = @i_RequestId
  end
	*/
	if @i_isDebug > 0
	  insert into RMLogger values('RMReserveDestinationForAuxCopy', 'Exit...', @i_RequestId, getutcdate())
 	return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveDestinationForAuxCopy')
	delete from GxQscripts where name = 'RMReserveDestinationForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveDestinationForAuxCopy')
	delete from GXDBVersions where aliasname = 'RMReserveDestinationForAuxCopy'
GO

insert into GXDBVersions values(2, 'RMReserveDestinationForAuxCopy',  'v1.24.44.20.46.1', 'RMReserveDestinationForAuxCopy', 'v1.24.44.20.46.1')
GO

