

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReserveAdditionalMediaOnHold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReserveAdditionalMediaOnHold.sp,v $ $Id: RMReserveAdditionalMediaOnHold.sp,v 1.1.2.5 2020/01/31 07:45:14 dmitriy Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReserveAdditionalMediaOnHold()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReserveAdditionalMediaOnHold')
BEGIN
	print '>>> Drop Stored Procedure: RMReserveAdditionalMediaOnHold <<<'
	drop procedure RMReserveAdditionalMediaOnHold
END
IF EXISTS (select * from GxQscripts where name='RMReserveAdditionalMediaOnHold')
	delete from GxQscripts where name = 'RMReserveAdditionalMediaOnHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveAdditionalMediaOnHold')
	delete from GXDBVersions where aliasname = 'RMReserveAdditionalMediaOnHold'
GO
print '... Creating Procedure: RMReserveAdditionalMediaOnHold'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMReserveAdditionalMediaOnHold
  @i_requestId int,
  @i_jobId int,
  @i_drivePoolId int,
  @i_spareGroupId int,
  @i_reservationId int,
  @i_rcId int,
  @i_noOfMedia int,
  @i_isSpareOnly int,
  @i_actualRequestId int = 0
AS
  DECLARE @r_MediaId integer;
  DECLARE @r_Barcode varchar(256);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  -- Based on the given reservationId or rcId, figure out which library, spare group to use.
  -- Otherwise, select based on given drive pool and spare group info.
DECLARE @errorCode int = 0
    DECLARE @currentReservedMediaId int = 0
    DECLARE @currentReservedVolumeId int = 0
    DECLARE @currentLibraryId int = 0
    DECLARE @currentMediaGroupId int = 0
    DECLARE @currentLibraryTypeId int = 0
    DECLARE @libraryAttribute int = 0
    DECLARE @UseWithInDaysInSec int = 0
    DECLARE @mediaSearched int  = 0
    DECLARE @honourSpareGroup int = 0
    SET @honourSpareGroup = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_HONOUR_SPAREGROUP_FOR_PICKING_MEDIA'), 0)
    IF @i_requestId = 0
    BEGIN
        SET @i_requestId = @i_actualRequestId
    END
    CREATE TABLE #tmptblVolumeMedia
    (
        VolumeID int,
        MediaID int,
        SpareGroupId int,
        Attributes int,
        origCCcommCellID int,
        MediaLocation int,
        LastBackupTime int,
        IsExportable int,
        NumberOfReUses int,
BarCode varchar(256)
    )
    IF @i_reservationId > 0 AND @i_jobId > 0
    OR @i_rcId > 0
    BEGIN
        SELECT @currentReservedMediaId = res.MediaId, @currentReservedVolumeId = res.VolumeId,
                @currentLibraryId = res.LibraryId, @i_spareGroupId = res.SpareGroupId,
                @currentMediaGroupId = res.MediaGroupId, @i_drivePoolId = res.DrivePoolId
        FROM    MMResource res WITH (NOLOCK), MMResourceToJob resToJob WITH (NOLOCK)
        WHERE   res.ReservationId = resToJob.ReservationId
        AND     (
                    res.reservationId = @i_reservationId AND resToJob.JobId_l = @i_jobId
                    OR
                    resToJob.RCId = @i_rcId
                )
    END
    IF @currentLibraryId = 0 AND @i_drivePoolId > 0 AND @i_spareGroupId > 0
    BEGIN
        SELECT @currentLibraryId = LibraryId
        FROM    MMSpareGroup WITH (NOLOCK)
        WHERE   SpareGroupId = @i_spareGroupId
    END
IF NOT EXISTS (SELECT 1 FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = @currentLibraryId AND VTLType IN ( 4))
    BEGIN
SET @errorCode = 387
        GOTO ERROR_EXIT
    END
    SELECT @currentLibraryTypeId = LibraryTypeID,
            @libraryAttribute = LibraryAttribute,
            @UseWithInDaysInSec = UseWithinDaysInSec
    FROM    MMLibrary  WITH (NOLOCK)
    WHERE   LibraryId = @currentLibraryId
    IF @i_spareGroupId = 0
    BEGIN
        SELECT @i_spareGroupId = SpareGroupId
        FROM    MMMedia
        WHERE   MediaId = @currentReservedMediaId
    END
    DECLARE @SpareGroupAttributes int = 0
    select @SpareGroupAttributes = Attributes
    from MMSpareGroup WITH (READUNCOMMITTED)
    where SpareGroupId = @i_spareGroupId
    IF @i_isSpareOnly = 0
    BEGIN
        -- get all appendable media
        INSERT INTO #tmptblVolumeMedia
SELECT v.VolumeId, v.MediaId, m.SpareGroupId, m.Attributes, 0, 0, v.LastBackupTime, (m.Attributes & 1), 0, ''
        FROM MMVolume v WITH (NOLOCK), MMMedia m WITH (NOLOCK)
        WHERE v.MediaGroupID = @currentMediaGroupId
        AND v.VolumeFlags = 7
        AND v.VolumeState != 2
        AND v.VolumeId > 0
        AND not exists (select mediaid from MMResource WITH (NOLOCK) where mediaId = m.MediaId)
        AND v.mediaid = m.mediaid
AND m.Attributes & 536870912 = 0
        AND m.MediaFlags = 1
AND not exists (select barcode from MMSlot with (readuncommitted) where barcode = m.barcode and (MediaStatus & 1) > 0	)
        IF  @honourSpareGroup > 0 AND @i_spareGroupId > 0
        BEGIN
            DELETE #tmptblVolumeMedia
            WHERE SpareGroupId != @i_spareGroupId
        END
        delete from #tmptblVolumeMedia
        where LastBackupTime > 0
        AND DATEDIFF(second, DATEADD(second, LastBackupTime, '01/01/1970'), getutcdate()) > @UseWithInDaysInSec
    END
    INSERT INTO #tmptblVolumeMedia
    SELECT v.VolumeId, m.MediaId, m.SpareGroupId, m.Attributes, m.origCCcommCellID, m.MediaLocation,
m.LastBackupTime, (m.Attributes & 1), m.NumberOfReUses, m.BarCode
    FROM MMVolume v WITH (NOLOCK), MMMedia m WITH (NOLOCK)
    WHERE
        (
            v.MediaGroupId = 0 or m.IsAged > 0
        )
    AND v.VolumeFlags = 5
    AND v.VolumeId > 0
    AND v.VolumeState != 2
    AND v.MediaId = m.MediaId
    AND m.MediaFlags = 1
    AND m.LibraryId = @currentLibraryId
AND (@currentLibraryTypeId in (4, 5) or MediaLocation in (1,2))
    AND m.SpareGroupId = @i_spareGroupId
    AND not exists (select mediaId from MMResource WITH (NOLOCK) where mediaId = m.MediaId)
AND (m.Attributes & 536870912) = 0
AND not exists (select barcode from MMSlot with (readuncommitted) where barcode = m.barcode and (MediaStatus & 1) > 0	)
    SELECT @mediaSearched = COUNT(*) FROM #tmptblVolumeMedia
    IF @mediaSearched > 0
    BEGIN
        -- media is outside
IF @currentLibraryTypeId NOT IN ( 4, 5)
        BEGIN
            delete a
            from #tmptblVolumeMedia a left join MMSlot s on a.MediaId = s.MediaId
            where  a.MediaLocation in (1)
            and    (s.SlotId is null or s.SlotType != 1)
--SET @errorCode = 0
            delete a
            from #tmptblVolumeMedia a left join MMDrive d on a.MediaId = d.MediaId
            where  a.MediaLocation in (2)
            and    (d.DriveSoftState = 0 or d.DriveEnabled = 0 or d.DriveBroken = 1 or d.MountStatus = 4)
--SET @errorCode = 0
            delete a
            from #tmptblVolumeMedia a, mmdrive DRV with (readuncommitted),
                 mmdrivecontroller DRVCTRL with (readuncommitted), MMHost HOST with (readuncommitted)
            where   a.MediaLocation = 2
            and     a.MediaId = DRV.MediaId
            and     DRV.DriveId = DRVCTRL.DriveControllerId and DRVCTRL.ClientId = HOST.ClientId
            and     (HOST.MmHostSoftState = 0 OR HOST.MmHostEnabled = 0
                    or
                    DRVCTRL.DriveControllerEnabled = 0 or DRVCTRL.DriveAccessible = 1)
--SET @errorCode = 0
        END
        ELSE
        BEGIN
if (@currentLibraryTypeId in ( 4, 5))
            and exists (select * from #tmptblVolumeMedia where MediaLocation = 2)
            begin
                delete from #tmptblVolumeMedia
                where MediaLocation != 2
--SET @errorCode = 0
           end
        END
        SELECT @mediaSearched = COUNT(*) FROM #tmptblVolumeMedia
        IF @mediaSearched = 0
        BEGIN
            GOTO ERROR_EXIT
        END
        ELSE
        BEGIN
SET @errorCode = 0
        END
        -- check if can use media from wrong APP_CommCell
        delete from #tmptblVolumeMedia
where (Attributes & 268435456) = 0
and (@LibraryAttribute & 32) = 0
        and origCCcommCellID > 2
--SET @errorCode = 0
        select @mediaSearched = @mediaSearched - @@rowcount
        IF @i_drivePoolId > 0
        BEGIN
            -- delete media with the non-supported media type
            delete tv
            FROM #tmptblVolumeMedia tv, MMVolume mmv, MMMedia mmm
            WHERE tv.VolumeId = mmv.VolumeId AND mmm.MediaId = mmv.MediaId AND mmm.MediaTypeId NOT IN
            (SELECT mrfmt.MediaTypeId FROM MMDrivePool mmdp, MMDrive mmd, MMRecFmtMedTyp mrfmt
            WHERE mmdp.drivePoolId = @i_drivePoolId AND mmd.MasterPoolId = mmdp.MasterPoolId
            AND mrfmt.DriveTypeId = mmd.DriveTypeId
AND (mrfmt.CompatibilityType & 2) > 0)
--SET @errorCode = 281
            select @mediaSearched = @mediaSearched - @@rowcount
            -- if media in drive, has to be accessible by the media group's drive pool
            if exists (select * from #tmptblVolumeMedia where MediaLocation = 2)
            begin
                delete from #tmptblVolumeMedia
                where MediaLocation = 2
                and not exists (select * from MMdrive
                            where mediaid = #tmptblVolumeMedia.MediaId
                            and driveid in (select driveid from mmdrivecontroller
                                            where drivepoolid = @i_drivePoolId)
                            )
                select @mediaSearched = @mediaSearched - @@rowcount
            end
        END
        -- Delete the media which is not in the drive for PnP library
        delete #tmptblVolumeMedia
        from #tmptblVolumeMedia a, MMMedia m WITH (NOLOCK)
        where	a.MediaId = m.MediaId
and		m.MediaTypeId in (11002)
        and 	not exists (select driveId from MMDrive with (NOLOCK) where mediaId = a.MediaId)
        select @mediaSearched = @mediaSearched - @@rowcount
    END
    DECLARE @selectedMediaList TABLE (mediaId int, volumeId int, attributes int)
    IF @mediaSearched >= @i_noOfMedia
    BEGIN
         if exists (SELECT 1 FROM mmconfigs WHERE name = 'MMCONFIG_RESOURCEMANAGER_BACKUP_USE_SPARE_BY_BARCODE_ORDER_ONLY' and value = 1)
        begin
            insert into @selectedMediaList
            select TOP (@i_noOfMedia) MediaId, VolumeId, Attributes
            from #tmptblVolumeMedia
            order by BarCode
        end
        else
        begin
if (@SpareGroupAttributes & 16) > 0
            BEGIN
                insert into @selectedMediaList
                select top (@i_noOfMedia) MediaId, VolumeId, Attributes
                from #tmptblVolumeMedia
                order by IsExportable, NumberOfReUses, LastBackupTime, BarCode, VolumeId
            END
else if(@SpareGroupAttributes & 32) > 0
            BEGIN
                insert into @selectedMediaList
                select top (@i_noOfMedia) A.MediaId, A.VolumeId, A.Attributes
                FROM #tmptblVolumeMedia A, MMMedia M WITH (READUNCOMMITTED), MMMediaType MT WITH (READUNCOMMITTED)
                WHERE A.MediaID = M.MediaId AND M.MediaTypeId = MT.MediaTypeId
                ORDER BY A.IsExportable, MT.MaxUncompressCapacityMB, A.NumberOfReUses DESC, A.LastBackupTime DESC, A.BarCode, A.VolumeId
            END
else if(@SpareGroupAttributes & 64) > 0
            BEGIN
                insert into @selectedMediaList
                select top (@i_noOfMedia) A.MediaId, A.VolumeId, A.Attributes
                FROM #tmptblVolumeMedia A, MMMedia M WITH (READUNCOMMITTED), MMMediaType MT WITH (READUNCOMMITTED)
                WHERE A.MediaID = M.MediaId AND M.MediaTypeId = MT.MediaTypeId
                ORDER BY  A.IsExportable, MT.MaxUncompressCapacityMB DESC, A.NumberOfReUses DESC, A.LastBackupTime DESC, A.BarCode, A.VolumeId
            END
            else
            BEGIN
                insert into @selectedMediaList
                select top (@i_noOfMedia) MediaId, VolumeId, Attributes
                from #tmptblVolumeMedia
                order by IsExportable, NumberOfReUses desc, LastBackupTime desc, BarCode, VolumeId
            END
        end
IF EXISTS (SELECT mediaId FROM @selectedMediaList WHERE Attributes & 1 > 0)
        BEGIN
            IF (CURSOR_STATUS('LOCAL', 'Remove_Media_From_VT_Cursor') >= -1)
            BEGIN
                CLOSE Remove_Media_From_VT_Cursor
                DEALLOCATE Remove_Media_From_VT_Cursor
            END
            DECLARE @exported_mediaId int = 0
            DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
            DECLARE Remove_Media_From_VT_Cursor CURSOR FOR
SELECT mediaId FROM @selectedMediaList WHERE Attributes & 1 > 0
            OPEN Remove_Media_From_VT_Cursor
            FETCH	NEXT FROM Remove_Media_From_VT_Cursor
            INTO	@exported_mediaId
            WHILE @@FETCH_STATUS = 0
            BEGIN
                if exists (select top 1 * from VTActionMedia with (readuncommitted) where MediaId = @exported_mediaId)
                begin
                    insert into @tblActionCmdReturn
EXEC VTRunActionCmd 2, 0, @exported_mediaId, 0
                end
                update MMMedia
set Attributes = Attributes & ~1
                where mediaid = @exported_mediaId
                FETCH	NEXT FROM Remove_Media_From_VT_Cursor
                INTO	@exported_mediaId
            END
            CLOSE Remove_Media_From_VT_Cursor
            DEALLOCATE Remove_Media_From_VT_Cursor
        END
        UPDATE MMMedia
        SET    MediaFlags = 5 /*MEDIA_FLAG_RESERVED_BY_JOB*/, isInMediaGroup = 1
        WHERE   MediaId IN (SELECT MediaId FROM @selectedMediaList)
        UPDATE MMVolume
        SET     MediaGroupId = @currentMediaGroupId
        WHERE   VolumeId IN (SELECT VolumeId FROM @selectedMediaList)
        IF @i_reservationId > 0 AND @i_jobId > 0
        OR @i_rcId > 0
        BEGIN
            INSERT INTO RMReservations
            SELECT	0, 0, @i_RequestId, @i_jobId, 0, b.ReservationType, 0,
                    b.CopyId, b.StreamId, a.VolumeId, a.MediaId, b.ScheduleRunId, 0,
                    b.SpareGroupId, 0, 0, b.ClientId, b.DrivePoolId, b.MasterPoolId, b.LibraryId, b.LibraryTypeId,
                    b.MediaGroupId, b.ResourceFlag, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0
            FROM		@selectedMediaList a,
                        (
                            SELECT TOP 1 res.* FROM MMResource res WITH (NOLOCK), MMResourceToJob resToJob WITH (NOLOCK)
                            WHERE   res.ReservationId = resToJob.ReservationId
                            AND     (
                                        res.reservationId = @i_reservationId AND resToJob.JobId_l = @i_jobId
                                        OR
                                        resToJob.RCId = @i_rcId
                                    )
                        ) b
        END
        ELSE
        BEGIN
           INSERT INTO RMReservations
            SELECT	0, 0, @i_RequestId, @i_jobId, 0, 2, 0,
                    0, 0, a.VolumeId, a.MediaId, 0, 0,
                    @i_spareGroupId, 0, 0, 0, @i_drivePoolId, 0, @currentLibraryId, @currentLibraryTypeId,
                    @currentMediaGroupId, 0, 0, 0,
                    0, 0, 0, 0, 0, 0, 0, 0
            FROM		@selectedMediaList a
        END
        goto NORMAL_EXIT
    END
    else
    begin
SET @errorCode = 280
        GOTO ERROR_EXIT
    end
NORMAL_EXIT:
ERROR_EXIT:
  select 0, ''
  return @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReserveAdditionalMediaOnHold')
	delete from GxQscripts where name = 'RMReserveAdditionalMediaOnHold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReserveAdditionalMediaOnHold')
	delete from GXDBVersions where aliasname = 'RMReserveAdditionalMediaOnHold'
GO

insert into GXDBVersions values(2, 'RMReserveAdditionalMediaOnHold',  '00010001000200050000', 'RMReserveAdditionalMediaOnHold', '00010001000200050000')
GO

