

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMReleaseReservation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMReleaseReservation.sp,v $ $Id: RMReleaseReservation.sp,v 1.19.14.10 2019/05/22 13:15:49 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMReleaseReservation()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMReleaseReservation')
BEGIN
	print '>>> Drop Stored Procedure: RMReleaseReservation <<<'
	drop procedure RMReleaseReservation
END
IF EXISTS (select * from GxQscripts where name='RMReleaseReservation')
	delete from GxQscripts where name = 'RMReleaseReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReleaseReservation')
	delete from GXDBVersions where aliasname = 'RMReleaseReservation'
GO
print '... Creating Procedure: RMReleaseReservation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMReleaseReservation
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  declare @rmJustId table (id int)
  declare @rmResId table (ReservationId int, RCID int, RsvBitMask int, tempRsvBitMask int)
  declare @noOfRes int = 0
	declare @debugDetail	varchar(max)
set @o_ErrorCode = 0
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
  declare @RequestTime		int
  declare @FailureAttempts int
  declare @commCellId				int
	declare @jobId			bigint
	declare @jobType		int
	declare @jobOpType	int
	declare @iDAType		int
	declare @phaseFirstAttemptTime	bigint
	declare @xmlRegistrySetting XML
	declare @xmlParams	XML
	select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@commCellId = commCellId,
		@jobId = jobId,
		@jobType = jobType,
		@jobOpType = jobOpType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@xmlRegistrySetting = registrySetting,
		@xmlParams	= xmlParams
  from RMReservationRequest
  where RequestId = @i_RequestId
	declare @releaseJobId		int
	declare @useRCID				int
	declare @RCID						int
	declare @appType				int
	declare @logicalRelease	int
	declare @clientTokenId	int
	declare @noOfStreamsToRetain	int
	declare @noOfStreamsToRelease	int
	declare @rsvBitMask			int
	declare @copyId					int
	declare @reservationId	int
	declare @volumeId				int
	declare @driveId				int
	declare @ReservationRequestStatus int
	declare @ReleaseReservationType int
	set	@releaseJobId				= 0
	set @useRCID						= 0
	set @RCID								= 0
	set @appType						= 0
	set @logicalRelease			= 0
	set @clientTokenId			= 0
	set @noOfStreamsToRetain			= 0
	set @noOfStreamsToRelease	= 0
	set @rsvBitMask					= 0
	set @copyId							= 0
	set @reservationId			= 0
	set	@volumeId						= 0
	set	@driveId						= 0
set @ReservationRequestStatus = 0
set @ReleaseReservationType = 0
	DECLARE @reservationRequestId INT = 0
	declare @timeout int = 0
	IF @xmlParams IS NOT NULL AND @xmlParams.exist('/ResourceManager_RmReleaseJobStreamsArgs_t') > 0
	BEGIN
		SELECT	@useRCID								= params.value('@useRCID', 'int'),
						@RCID										= params.value('@RCID', 'int'),
						@releaseJobId						= params.value('@releaseJobId', 'int'),
						@appType								= params.value('@appType', 'int'),
						@logicalRelease					= params.value('@logicalRelease', 'int'),
						@clientTokenId					= params.value('@clientTokenId', 'int'),
						@noOfStreamsToRetain		= params.value('@noOfStreamsToRetain', 'int'),
						@noOfStreamsToRelease		= params.value('@noOfStreamsToRelease', 'int'),
						@rsvBitMask							= params.value('@rsvBitMask', 'int'),
						@copyId									= params.value('@copyId', 'int'),
						@reservationId					= params.value('@reservationId', 'int'),
						@volumeId								= params.value('@volumeId', 'int'),
						@driveId								= params.value('@driveId', 'int'),
						@ReleaseReservationType		= params.value('@ReleaseReservationType', 'int'),
						@reservationRequestId		= params.value('@ReservationRequestId', 'int'),
						@timeout					= params.value('@timeout', 'int')
				FROM	@xmlParams.nodes('/ResourceManager_RmReleaseJobStreamsArgs_t[1]') AS R(params)
	END
  declare @isRestoreCachingDisabled		int
	set @isRestoreCachingDisabled = 0
	IF @xmlRegistrySetting IS NOT NULL
	BEGIN
		SELECT	@isRestoreCachingDisabled	= params.value('@isRestoreCachingDisabled', 'int')
		FROM		@xmlRegistrySetting.nodes('/ResourceManager_RmRegistrySetting_t[1]') AS R(params)
	END
	if @i_isDebug > 0
	begin
		insert into RMLogger values ('RMReleaseReservation',
																	'Releasing Stream(s) for Job [' + cast(ISNULL(@jobId, 0) as varchar(20)) + ']',
																	@i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((
												select @jobId JobId, @ReleaseReservationType ReleaseReservationType,
															@useRCID usRCID, @RCID RCID, @appType AppType,
															@logicalRelease logicalRelease, @clientTokenId ClientTokenId,
															@noOfStreamsToRetain noOfStreamsToRetain, @noOfStreamsToRelease noOfStreamsToRelease,
															@rsvBitMask rsvBitMask, @copyId copyId,
															@reservationId ReservationId, @volumeId VolumeId, @driveId DriveId
												for XML RAW('ReleaseParams'), TYPE), 'No params for release reservation') as varchar(max))
		insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
	end
	declare @JOBOPRESTORE			integer
	set @JOBOPRESTORE = 5
	declare @AUXCOPY int = 13
	declare @AUXCOPY2 int = 104
	declare @ARCHIVECHECK2 int = 106
	declare @SYNTHFULL int = 14
	declare @MEDIAREFRESHING2 int = 127
	declare @jobSubOpType int = 0
	IF EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK) WHERE JobId = @jobId)
	BEGIN
		SELECT	@jobOpType = ISNULL(job.opType, 0),
				@jobSubOpType = ISNULL(job.subOpType, 0)
		FROM	JMJobInfo job WITH (NOLOCK)
		WHERE	job.JobId = @jobId
		IF @jobSubOpType > 0
			SET @jobOpType = @jobSubOpType
	END
	-- Release the Dangling reservations
	UPDATE MMResource SET LogicalRelease = 1
	WHERE	ReservationId NOT IN (SELECT ReservationId FROM MMResourceToJob WITH (NOLOCK))
	AND		HasJobInterrupted = 0 AND IntrJobId_h = 0 AND IntrJobId_l = 0
  --#define UNUSED_CV_APPTYPE_2						2	-- Oracle 7
  --#define UNUSED_CV_APPTYPE_2						UNUSED_CV_APPTYPE_2
  --#define CV_APPTYPE_INFORMIX						3
  --#define CV_APPTYPE_ORACLE8						22
  --#define CV_APPTYPE_ORACLE_RAC					80
  --#define CV_APPTYPE_SAP_FOR_ORACLE		        61
  --#define CV_APPTYPE_DB2							37
  --#define CV_APPTYPE_UNIX_DB2	                    62
  --#define CV_APPTYPE_DB2_DPF						103
  IF @jobOpType = @JOBOPRESTORE
  AND	@iDAType in (
2, 2,
22, 80, 61,
3,
37, 62, 103
			)
  AND	@isRestoreCachingDisabled = 0
  BEGIN
		insert into @rmJustId
		select J.RCID from MMResourceToJob J WITH (NOLOCK)
			INNER JOIN MMResource R WITH (NOLOCK) ON J.ReservationId = R.ReservationId
		where J.JobId_l = @jobId and J.JobId_h = 0 and ( @volumeId = 0 OR R.VolumeId = @volumeId)
		if exists (select * from @rmJustId)
		begin
			update	RJ
			set		RJ.InUse = 0, RJ.ReleaseTime = dbo.GetUnixTime(getutcdate())
			from 	MMResourceToJob RJ INNER JOIN @rmJustId R ON RJ.RCID = R.id
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(ISNULL((select id RCID from @rmJustId	for XML RAW('RCIDList'), TYPE), 'No RCID') as varchar(max))
				set @debugDetail = 'Set Cache Restore reservation RCID ' + @debugDetail + ' not in use.'
				insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
			end
set @o_ErrorCode = 0
			goto error_exit
		end
		delete @rmJustId
  END
IF @ReleaseReservationType = 2
	AND @useRCID > 0
	BEGIN
		IF @jobOpType IN (@AUXCOPY2, @ARCHIVECHECK2, @MEDIAREFRESHING2)
		--OR @jobOpType = @SYNTHFULL AND cast(dbo.GetJobOption(@jobId, DATABKPOTION_USE_MULTI_STREAM) as int) > 0
SET @rsvBitMask = 0
		insert into @rmResId
		select	ReservationId, @RCID, ReserveBitMask, @rsvBitMask
		from		MMResourceToJob WITH (NOLOCK)
		where		RCID = @RCID
		-- default is to release inline resoruce as well
		insert into @rmResId
		select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
		from		MMResourceToJob WITH (NOLOCK)
		where		JobId_l = @jobId
		and			PrimaryRCID in (select RCID from @rmResId)
	END
ELSE IF @ReleaseReservationType = 4
	AND @noOfStreamsToRetain > 0 AND @copyId <= 0
	BEGIN
set @rsvBitMask = 1
		delete @rmJustId
		IF @clientTokenId > 0
		BEGIN
			insert into @rmJustId
			select		RCID
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ClientTokenId = @clientTokenId
			and			PrimaryRCID = 0
			order by RCID
			select @noOfRes = count(*) from @rmJustId
		END
		ELSE
		BEGIN
			insert into @rmJustId
			select		RCID
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			PrimaryRCId = 0
			order by RCID
			select @noOfRes = count(*) from @rmJustId
		END
		if @noOfRes > 0 and @noOfRes > @noOfStreamsToRetain
		begin
			insert into @rmResId
			select	top (@noOfRes - @noOfStreamsToRetain) a.ReservationId, a.RCID, a.ReserveBitMask, @rsvBitMask
			from		MMResourceToJob a WITH (NOLOCK)  , @rmJustId b
						--(select top (@noOfRes - @noOfStreamsToRetain) id from @rmJustId order by id) b
			where		a.RCId = b.id
			order by a.InUse, a.ReleaseTime desc, b.id
		end
	END
ELSE IF @ReleaseReservationType = 8
	AND @noOfStreamsToRelease > 0 AND @copyId > 0
	BEGIN
set @rsvBitMask = 1
		delete @rmJustId
		insert into @rmJustId
		select		RCID
		from		MMResourceToJob WITH (NOLOCK)
		where		JobId_l = @jobId
		and			ReservationId in (select ReservationId from MMResource WITH (NOLOCK) where CopyId = @copyId)
		and			PrimaryRCId = 0
		order by RCID
		select @noOfRes = count(*) from @rmJustId
		if @noOfRes > 0
		begin
			insert into @rmResId
			select	top (@noOfStreamsToRelease) a.ReservationId, a.RCID, a.ReserveBitMask, @rsvBitMask
			from		MMResourceToJob a WITH (NOLOCK), @rmJustId b
						--(select top (@noOfStreamsToRelease) id from @rmJustId order by id) b
			where		a.RCId = b.id
			order by a.InUse, a.ReleaseTime desc, b.id
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			PrimaryRCID in (select RCID from @rmResId)
		end
	END
ELSE IF @ReleaseReservationType = 1
	BEGIN
		-- Release the interrupted resource first
		insert into @rmJustId
		select	ReservationId
		from		MMResource WITH (NOLOCK)
		where		IntrJobId_l = @jobId
		and			Released = 1
		if exists (select * from @rmJustId)
		begin
			if exists (select * from MMResourceToJob WITH (NOLOCK) where ReservationId in (select id from @rmJustId))
			begin
				-- There are jobs still reserve the resources that are supposed being released already from flag in MMResource table
				if @i_isDebug > 0
				begin
					set @debugDetail = cast(isnull((
														select distinct a.id ReservationID, b.RCID RCID, b.JobId_l JobId
														from @rmJustId a, MMResourceToJob b WITH (NOLOCK)
														where a.id = b.ReservationId
														for XML RAW('JobList'), TYPE), 'No Jobs have problem') as varchar(max))
					insert into RMLogger values ('RMReleaseReservation', 'Reservation has been released but following jobs still use it.' + @debugDetail, @i_RequestId, getutcdate())
				end
set @o_ErrorCode = 836
				goto error_exit
			end
			if exists (select * from MMResource WITH (NOLOCK) where HasJobInterrupted = 1
									and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK) where JobId_l = @jobId))
			begin
				--This resource was interrupted by some other job. Just set the Released flag
				--so that the interrupting job knows that this job has released resources.
				update MMResource set Released = 1, DoNotInterrupt = 0
				where ReservationId in (select id from @rmJustId)
			end
			-- this resource is not interrupted
			else
			begin
				if @i_isDebug > 0
				begin
					set @debugDetail = cast(ISNULL((select id ReservationId from @rmJustId
																			 for XML RAW('ReservationIdList'), TYPE), 'No ReservationID') as varchar(max))
					set @debugDetail = 'Removed reservation ' + @debugDetail
					insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
				end
				--If logical release do not delete the resource. just set it as logically released.
				--If marked as do not interrupt, just set it as logically released so that the
				--resource cannot be used by another job, till logicall reservations are released
				--at the end of jobmanager loop
				if @logicalRelease > 1
				begin
					update MMResource set LogicalRelease = 1, DoNotInterrupt = 0
					where ReservationId in (select id from @rmJustId)
				end
				else
				begin
					delete MMResource
					where	ReservationId in (select id from @rmJustId)
					and		DoNotInterrupt = 0
					update MMResource set LogicalRelease = 1, DoNotInterrupt = 0
					where ReservationId in (select id from @rmJustId)
					and		DoNotInterrupt != 0
				end
			end
		end
		delete @rmJustId
		IF @clientTokenId > 0
		BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ClientTokenId = @clientTokenId
		END
		ELSE
		BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
		END
	END
ELSE IF @ReleaseReservationType = 3
	AND	@reservationId > 0
	BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId = @reservationId
	END
ELSE IF @ReleaseReservationType = 5
	BEGIN
		IF @reservationId > 0
		BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId = @reservationId
if @rsvBitMask = 2
			AND NOT EXISTS (select 1 from MMResourceToJob WITH (NOLOCK)
							WHERE JobId_l = @jobId
							AND ReservationId = @reservationId
AND	ReservationType = 1)
			begin
				insert into @rmResId
				select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
				from		MMResourceToJob WITH (NOLOCK)
				where		JobId_l != @jobId
				and			ReservationId = @reservationId
and			ReservationType = 2
			end
		END
		ELSE
		BEGIN
			insert into @rmResId
			select ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId in (
																	select ReservationId from MMResource WITH (NOLOCK)
																	where (@volumeId = 0 OR VolumeId = @volumeId)
																	and		(@driveId = 0 OR DriveId = @driveId)
																)
		END
	END
ELSE IF @ReleaseReservationType = 6
	BEGIN
		IF @reservationId > 0
		BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId = @reservationId
if @rsvBitMask = 2
			AND NOT EXISTS (select 1 from MMResourceToJob WITH (NOLOCK)
							WHERE JobId_l = @jobId
							AND ReservationId = @reservationId
AND	ReservationType = 1)
			begin
				insert into @rmResId
				select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
				from		MMResourceToJob WITH (NOLOCK)
				where		JobId_l != @jobId
				and			ReservationId = @reservationId
and			ReservationType = 2
			end
		END
		ELSE
		BEGIN
			insert into @rmResId
			select ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId in (
																	select ReservationId from MMResource WITH (NOLOCK)
																	where (@volumeId = 0 OR VolumeId = @volumeId)
																)
		END
		IF EXISTS (SELECT * FROM MMResource WITH (NOLOCK)
								WHERE DriveId > 0
								AND		ReservationId IN (SELECT ReservationId FROM @rmResId)
							)
		BEGIN
			UPDATE	MMResource SET VolumeId = 0
			WHERE		ReservationId IN (SELECT ReservationID FROM @rmResId)
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(ISNULL((select RCId from @rmResId for XML RAW('RCIDList'), TYPE), 'No RCID') as varchar(max))
				set @debugDetail = 'Rlease Volume From resource user ' + @debugDetail
				insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
			end
			GOTO error_exit
		END
	END
ELSE IF @ReleaseReservationType = 7
	BEGIN
		IF @reservationId > 0
		BEGIN
			insert into @rmResId
			select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId = @reservationId
if @rsvBitMask = 2
			AND NOT EXISTS (select 1 from MMResourceToJob WITH (NOLOCK)
							WHERE JobId_l = @jobId
							AND ReservationId = @reservationId
AND	ReservationType = 1)
			begin
				insert into @rmResId
				select	ReservationId, RCID, ReserveBitMask, @rsvBitMask
				from		MMResourceToJob WITH (NOLOCK)
				where		JobId_l != @jobId
				and			ReservationId = @reservationId
and			ReservationType = 2
			end
		END
		ELSE
		BEGIN
			insert into @rmResId
			select ReservationId, RCID, ReserveBitMask, @rsvBitMask
			from		MMResourceToJob WITH (NOLOCK)
			where		JobId_l = @jobId
			and			ReservationId in (
																	select ReservationId from MMResource WITH (NOLOCK)
																	where (@driveId = 0 OR DriveId = @driveId)
																)
		END
		IF EXISTS (SELECT * FROM MMResource WITH (NOLOCK)
								WHERE VolumeId > 0
								AND		ReservationId IN (SELECT ReservationId FROM @rmResId)
							)
		BEGIN
			UPDATE	MMResource SET DriveId = 0
			WHERE		ReservationId IN (SELECT ReservationID FROM @rmResId)
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(ISNULL((select RCId from @rmResId for XML RAW('RCIDList'), TYPE), 'No RCID') as varchar(max))
				set @debugDetail = 'Rlease Drive From resource user ' + @debugDetail
				insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
			end
			GOTO error_exit
		END
	END
ELSE IF @ReleaseReservationType = 9
	BEGIN
		IF @reservationRequestId > 0
		BEGIN
SET @rsvBitMask = 1
			insert into @rmResId
			select	b.ReservationId, b.RCID, b.ReserveBitMask, @rsvBitMask
			from		RMReservations a, MMResourceToJob b WITH (NOLOCK)
			where		a.JobId = @jobId
			and			a.RequestId = @reservationRequestId
			and			a.JobId = b.JobId_l
			and			a.ReservationId = b.ReservationId
			DELETE FROM RMReservationRequest WHERE RequestId = @reservationRequestId
		END
	END
ELSE IF @ReleaseReservationType = 10
	BEGIN
		set @jobId = 0
		if @timeout > 0
		begin
			declare @now int = dbo.GetUnixTime(GetUTCDate())
set @rsvBitMask = 0
			insert into @rmResId
			select	b.ReservationId, b.RCID, b.ReserveBitMask,
case when b.ReleaseTime = 0 and b.ReserveBitMask & 1 > 0 then 1 else 0 end
			from		MMResource a WITH (NOLOCK), MMResourceToJob b WITH (NOLOCK)
			where		a.ReservationId = b.ReservationId
			and			(
b.ReleaseTime != 0 and b.ReleaseTime < @now - @timeout and b.ReserveBitMask & (2 | 4) > 0
							or
							(
								b.JobId_l NOT IN (SELECT DISTINCT JobId FROM JMJobInfo with (nolock)) and
								(
b.ReserveBitMask & 1 > 0 or
b.ReserveBitMask & (2 | 4) > 0 and
									not exists (select 1 from MMDrive with (nolock) where driveId = a.DriveId and (DriveOccupied = 1 OR MountStatus <> 0))
								)
							)
						)
		end
		insert into @rmResId
select	ReservationId, 0, 0, 0
		from	MMResource a WITH (NOLOCK)
		where	not exists (SELECT DISTINCT ReservationId FROM MMResourceToJob WITH (NOLOCK) where ReservationId = a.ReservationId)
		and 	(
					((IntrJobId_h = 0 AND IntrJobId_l = 0) AND HasJobInterrupted = 0 AND LogicalRelease = 0)
					OR	(IntrJobId_l > 0 AND NOT EXISTS (SELECT DISTINCT ReservationId FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = a.IntrJobId_l))
					OR	(HasJobInterrupted > 0)
				)
	END
	-- If there is no reservation exists, skip the rest and mark the request finish.
	if not exists( select * from @rmResId)
	begin
set @o_ErrorCode = 0
		goto error_exit
	end
	--JobManager is releasing the resource for this job. Check if there
	--are any other jobs which are sharing the same resource. If there
	--are then donot just reset the mask, delete the entire row.
	--This is because, DataMover does not send an unmount for all jobs
	--using a volume due to which the DataMover mask may not get reset.
	--This affects jobs which release resourcesbetween phases. The next phase of
	--such jobs may not be able to reserve the same resource again.
	--As long as we have atleast one job which is ensuring the bit masks are right this should
	--not be a problem.
if @rsvBitMask = 1
	begin
		update @rmResId
set		tempRsvBitMask = 0
		where	ReservationId in
				(
					select ReservationId from MMResourceToJob WITH (NOLOCK)
					where		ReservationId in (select ReservationId from @rmResId)
					and			JobId_l != @jobId
				)
	end
	-- For auxcopy like jobs, the reserveBitMask is always set as NOT_RESERVED when releasing based on RCID.
	-- This causes problem when release reqeust is received but DataMover still holds the reservation.
	-- Delete the resource direclty will cause resource being picked by others right aways, even though MA still uses it.
	-- Check if there is any other RCID holds the resource. If not, then change the bitMASK to RM_JM_RESERVED instead.
	-- When DM tries to release it, it should delete the row.
IF @rsvBitMask = 0
AND @ReleaseReservationType = 2
	AND @useRCID > 0
	AND @jobOpType IN (@AUXCOPY, @AUXCOPY2, @ARCHIVECHECK2, @MEDIAREFRESHING2)
	BEGIN
		SELECT @ReservationId = ReservationId FROM MMResourceToJob WITH (NOLOCK) WHERE RCID = @RCID
		IF NOT EXISTS (SELECT 1 FROM MMResourceToJob WITH (NOLOCK) WHERE ReservationId = @ReservationId AND RCID != @RCID)
		BEGIN
			-- If the only left one has DM bitMask set, remove everything else.
			-- Otherwise, keep it as NOT_RESERVED
			update  @rmResId
set		tempRsvBitMask = (~2)
where	(RsvBitMask & 2) > 0
		END
	END
	/*
	** If JM is trying to free, it is likely
	** that it is also trying to free reservations
	** made by Mediamanager. as in the case of Auxcopy
	** and synthetic full, when the drivepools do not match.
	** This is a hack. The correct fix would be to put in the
	** correct bit mask, when we release and reserve the
	** drive in MLMReserveMountVol::handleReserve()
	*/
if @rsvBitMask = 1
	begin
		update @rmResId
set			tempRsvBitMask = 4
where		tempRsvBitMask != 0 and RsvBitMask & tempRsvBitMask = 0
		delete @rmResId
where		tempRsvBitMask != 0 and RsvBitMask & tempRsvBitMask = 0
	end
	/*
	** This case is added only for Archive Check.
	** For Archive Check the reservations are made
	** by Job Manager. However, resources are released
	** by MediaManager. May need to be fixed. Hack to make sure
	** that the masks are found.
	*/
else if @rsvBitMask = 4
	begin
		update @rmResId
set			tempRsvBitMask = 1
where		tempRsvBitMask != 0 and RsvBitMask & tempRsvBitMask = 0
		delete @rmResId
where		tempRsvBitMask != 0 and RsvBitMask & tempRsvBitMask = 0
	end
	/*
	** No reservation found with the expected BitMask set
	** Do not raise error, just ignore
	*/
	else
	begin
		delete @rmResId
where		tempRsvBitMask != 0 and RsvBitMask & tempRsvBitMask = 0
	end
	/*
	** This resource has not been released by everyone
	** Set the bit mask appropriately and modify the release
	** time for this resource
	*/
	delete @rmJustId
	insert into @rmJustId
	select RCID from @rmResId
where tempRsvBitMask != 0
and		(RsvBitMask & (~ tempRsvBitMask)) != 0
	if exists (select * from @rmJustId)
	begin
		update MMResourceToJob
		set ReserveBitMask = (b.RsvBitMask & (~ b.tempRsvBitMask)),
				ReleaseTime = dbo.GetUnixTime(getutcdate())
		from	MMResourceToJob a, @rmResId b
		where a.RCID = b.RCID and b.RCID in (select id from @rmJustId)
		--and		a.JobId_l = @jobId
	end
	-- Release following
	delete @rmJustId
	insert into @rmJustId
	select RCID from @rmResId
where tempRsvBitMask = 0
or		(RsvBitMask & (~ tempRsvBitMask)) = 0
	if exists (select * from @rmJustId)
	begin
		delete MMResourceToJob
		where RCID in (select id from @rmJustId)
		--and	 (@jobId = 0 OR JobId_l = @jobId)
		if @i_isDebug > 0
		begin
			set @debugDetail = cast(ISNULL((select id RCID from @rmJustId for XML RAW('RCIDList'), TYPE), 'No RCID') as varchar(max))
			set @debugDetail = 'Removed resource user ' + @debugDetail
			insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
		end
	end
	-- After release RCID, reservation has no job associated with it anymore
	delete @rmJustId
	insert into @rmJustId
	select distinct a.ReservationId
	from @rmResId a left join MMResourceToJob b WITH (NOLOCK) on a.ReservationId = b.ReservationId
	where b.ReservationId is null
	--The Reservation is not being used by any other jobs.
	--It is ok to delete.
	if exists (select * from @rmJustId)
	begin
		declare @interruptedResId table (id int)
		insert into @interruptedResId
		select ReservationId
		from		MMResource a WITH (NOLOCK), @rmJustId b
		where		a.ReservationId = b.id
		and			(a.IntrJobId_l > 0 or a.IntrJobId_h > 0) and a.Released = 0
		and			exists (select * from MMResource WITH (NOLOCK) where HasJobInterrupted = 1
										and ReservationId in (select ReservationId from MMResourceToJob WITH (NOLOCK)
																					 where JobId_l = a.IntrJobId_l and JobId_h = a.IntrJobId_h))
		if exists (select * from @interruptedResId)
		begin
			--This resource was interrupted by some other job. Just set the Released flag
			--so that the interrupting job knows that this job has released resources.
			update MMResource set Released = 1, DoNotInterrupt = 0
			where ReservationId in (select id from @interruptedResId)
		end
		-- this resource is not interrupted
		delete @rmJustId where id in (select id from @interruptedResId)
		if exists (select * from @rmJustId)
		begin
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(ISNULL((select id ReservationId from @rmJustId
																		 for XML RAW('ReservationIdList'), TYPE), 'No ReservationID') as varchar(max))
				set @debugDetail = 'Removed reservation ' + @debugDetail
				insert into RMLogger values ('RMReleaseReservation', @debugDetail, @i_RequestId, getutcdate())
			end
			--If logical release do not delete the resource. just set it as logically released.
			--If marked as do not interrupt, just set it as logically released so that the
			--resource cannot be used by another job, till logicall reservations are released
			--at the end of jobmanager loop
			if @logicalRelease > 1
			begin
				update MMResource set LogicalRelease = 1, DoNotInterrupt = 0
				where ReservationId in (select id from @rmJustId)
			end
			else
			begin
				delete MMResource
				where	ReservationId in (select id from @rmJustId)
				and		DoNotInterrupt = 0
				update MMResource set LogicalRelease = 1, DoNotInterrupt = 0
				where ReservationId in (select id from @rmJustId)
				and		DoNotInterrupt != 0
			end
		end
	end
	delete @rmJustId
	insert into @rmJustId
	select distinct a.ReservationId
	from @rmResId a left join MMResourceToJob b WITH (NOLOCK) on a.ReservationId = b.ReservationId
	where b.ReservationId > 0
	--The Reservation is still used by other jobs
	if exists (select * from @rmJustId)
	begin
		--Check if there are any writers which are still using the resource. If there are none
		--but we still have reservations we need to reset the stream number in the resource
		--This will usually happen for magnetic volumes when a read job uses the same volume as
		--a write job, and then the write job completes.
		--If we do not reset the stream number, getActiveStreams() in Resourcemanager will
		--not return this stream even though there are no backup jobs running to it.
		update MMResource set StreamId = 0
		from MMResource a
		where a.ReservationId in (select id from @rmJustId)
		and		not exists (select RCID from MMResourceToJob WITH (NOLOCK)
											where ReservationId = a.ReservationId
and		ReservationType = 2)
		--Set the priority and preemptability for the resource from the remaining jobs
		--Get ResourceToJob for this reservationId which are not Preeemtable sorted by priority
		update MMResource
		set		PreEmptable = 0,
					Priority = (
												select min(Priority)
												from MMResourceToJob WITH (NOLOCK)
												where ReservationId = a.ReservationId
												and		PreEmptable = 0
											)
		from 	MMResource a
		where a.ReservationId in (select id from @rmJustId)
		and		exists (select RCID from MMResourceToJob WITH (NOLOCK)
											where ReservationId = a.ReservationId
											and		Preemptable = 0)
		--No non-preemptable jobs found. get the highest priority amongst the remaining jobs.
		update MMResource
		set		PreEmptable = 1,
					Priority = (
												select min(Priority)
												from MMResourceToJob WITH (NOLOCK)
												where ReservationId = a.ReservationId
											)
		from 	MMResource a
		where a.ReservationId in (select id from @rmJustId)
		and		not exists (select RCID from MMResourceToJob WITH (NOLOCK)
											where ReservationId = a.ReservationId
											and		Preemptable = 0)
	end
error_exit:
if @o_ErrorCode = 0
if @ReleaseReservationType = 1 or @ReleaseReservationType = 9
			delete RMReservationRequest where RequestId = @i_RequestId
		else
update RMReservationRequest set ErrorCode = 0 where RequestId = @i_RequestId
	else
		update RMReservationRequest
		set		ErrorCode = @o_ErrorCode,
					FailureAttempts = FailureAttempts + sign(@o_ErrorCode)
		where RequestId = @i_RequestId
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
		select @o_ErrorCode
	END
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMReleaseReservation')
	delete from GxQscripts where name = 'RMReleaseReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMReleaseReservation')
	delete from GXDBVersions where aliasname = 'RMReleaseReservation'
GO

insert into GXDBVersions values(2, 'RMReleaseReservation',  '00010019001400100000', 'RMReleaseReservation', '00010019001400100000')
GO

