

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMQueryReservationRequestList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMQueryReservationRequestList.sp,v $ $Id: RMQueryReservationRequestList.sp,v 1.6.2.13 2019/04/24 14:45:10 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMQueryReservationRequestList()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMQueryReservationRequestList')
BEGIN
	print '>>> Drop Stored Procedure: RMQueryReservationRequestList <<<'
	drop procedure RMQueryReservationRequestList
END
IF EXISTS (select * from GxQscripts where name='RMQueryReservationRequestList')
	delete from GxQscripts where name = 'RMQueryReservationRequestList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMQueryReservationRequestList')
	delete from GXDBVersions where aliasname = 'RMQueryReservationRequestList'
GO
print '... Creating Procedure: RMQueryReservationRequestList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMQueryReservationRequestList
  @i_RequestIdList NVARCHAR(max)
AS
  DECLARE @o_JobId integer
  DECLARE @o_RequestId integer
  DECLARE @o_ErrorCode integer
  DECLARE @o_FailureType integer
  DECLARE @o_noOfStreamsAllocated integer
  DECLARE @o_mediaAgentId integer
  DECLARE @o_mediaAgentName NVARCHAR(1024)
  DECLARE @o_archGroupName NVARCHAR(256)
  DECLARE @o_markNewMediaStatus integer
  DECLARE @o_noOfInterruptedJobs integer
  DECLARE @o_interruptedJobIdList nvarchar(max)
  DECLARE @o_reservedInt integer
  DECLARE @o_resevedString NVARCHAR(max)
  DECLARE @o_ReservationResults NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_ErrorCode = 0
SET @o_FailureType = 1
    SET @o_noOfStreamsAllocated = 0
    SET @o_mediaAgentId = 0
    SET @o_mediaAgentName = ''
    SET @o_archGroupName = ''
    SET @o_markNewMediaStatus = 0
    SET @o_noOfInterruptedJobs = 0
    SET @o_interruptedJobIdList = ''
    SET @o_reservedInt = 0
    SET @o_resevedString = ''
	SET @o_ReservationResults = ''
	DECLARE @requestIdListTbl TABLE (requestId integer)
	DECLARE @xmlmsg XML = @i_RequestIdList
	IF @i_RequestIdList IS NOT NULL AND LEN(@i_RequestIdList) > 0
	BEGIN
		INSERT INTO @requestIdListTbl
		SELECT	isnull(p.value('@Id', 'int'), 0)
		FROM	@xmlmsg.nodes('/RequestId') AS R(p)
	END
    DECLARE @resultListTbl TABLE (
        JobId				integer,
        RequestId			integer,
        ErrorCode			integer,
        FailureType			integer,
        noOfStreamsAllocated integer,
        mediaAgentId         integer,
mediaAgentName       NVARCHAR(1024),
archGroupName        NVARCHAR(256),
        markNewMediaStatus   integer,
        noOfInterruptedJobs  integer,
        interruptedJobIdList nvarchar(max),
        reservedInt          integer,
        resevedString        NVARCHAR(max),
        ReservationResults	NVARCHAR(max)
    )
    DECLARE @lastQueryTime integer = 0
    DECLARE @now integer = 0
    IF EXISTS (SELECT id from GXCounter where name = 'RM_Query_Counter' and next_l > 0)
    BEGIN
  	  	select @lastQueryTime = next_l from GXCounter where name = 'RM_Query_Counter'
    END
    ELSE
    BEGIN
	INSERT INTO GXCounter VALUES  ('RM_Query_Counter', 0, 0)
    END
	IF NOT EXISTS (SELECT 1 FROM @requestIdListTbl)
	BEGIN
        INSERT      INTO @resultListTbl
        SELECT	    a.JobId, a.RequestId, a.ErrorCode, a.FailureType,
                    0, 0, '', '', 0, 0, '', 0, '',
                    '' as results
	    FROM		RMReservationRequest a with (readuncommitted), RMJobControl b with (readuncommitted)
WHERE		a.RequestCategory in (/*RM_RESERVATION_RESTORE,*/ 2, /*RM_RESERVATION_AUXCOPY,*/ /*RM_RESERVATION_OTHERS,*/ 8)
	    AND			a.ErrorCode != -1
	    --AND			(a.MaxNumOfAttempts < 0 OR a.FailureAttempts = 0 OR a.MaxNumOfAttempts < a.FailureAttempts)
	    AND			a.PhaseFirstAttemptTime > 0
	    --AND			(a.PhaseFirstAttemptTime = 0 OR a.FailureAttempts = 0 OR a.PhaseFirstAttemptTime > 0 AND (a.PhaseFirstAttemptTime + a.FailureAttempts * RM_RESERVATION_RETRY_INTERVAL) <= dbo.GetUnixTime(getutcdate()))
	    AND			a.JobId > 0 AND a.JobId = b.JobId
AND			b.Status = 1
        AND         a.RequestTime != -1
	    ORDER BY a.PhaseFirstAttemptTime
        ;WITH resinfo (JobId, RequestId, noOfStreamsAllocated, mediaAgentId, archGroupId, hasInterruptedJobs)
        AS
        (
			SELECT A.JobId, A.RequestId, A.noOfStreamsAllocated, A.mediaAgentId, A.archGroupId, A.hasInterruptedJobs
			FROM
			(
				SELECT  JobResults.JobId as JobId,
						JobResults.RequestId as RequestId,
						COUNT(b.RCId) as noOfStreamsAllocated,
						MIN(b.ClientId) as mediaAgentId,
						(SELECT ArchGroupId FROM ArchGroupCopy with (readuncommitted) WHERE Id = b.Copyid) as archGroupId,
(CASE WHEN JobResults.ErrorCode = 20005 THEN 1 ELSE 0 END) as hasInterruptedJobs,
						b.CopyId as CopyId,
						RANK() OVER (PARTITION BY JobResults.JobId, JobResults.RequestId, b.CopyId ORDER BY COUNT(b.RCID) DESC) N
				FROM    @resultListTbl JobResults, RMReservations b with (readuncommitted)
				WHERE   JobResults.ErrorCode = 0
				AND     JobResults.JobId = b.JobId AND JobResults.RequestId = b.RequestId
				AND		(b.ReservationId = 0 and b.RCId > 0 OR EXISTS (SELECT 1 FROM MMResource with (readuncommitted) WHERE ReservationId = b.ReservationId))
				GROUP  BY JobResults.JobId, JobResults.RequestId, JobResults.ErrorCode, b.CopyId
			) A
			WHERE N = 1
        )
        UPDATE results
        SET         noOfStreamsAllocated = resinfo.noOfStreamsAllocated,
                    mediaAgentId = resinfo.mediaAgentId,
                    mediaAgentName = (SELECT name FROM App_Client with (readuncommitted) WHERE Id = resinfo.mediaAgentId),
                    archGroupName = (SELECT name FROM ArchGroup with (readuncommitted) WHERE Id = resinfo.archGroupId),
                    markNewMediaStatus = 0,
noOfInterruptedJobs = CASE WHEN results.ErrorCode != 20005 THEN 0 ELSE
                                             (SELECT COUNT(DISTINCT JobId_l) FROM MMResourceToJob a with (readuncommitted), MMResource b with (readuncommitted) WHERE b.IntrJobId_l = resinfo.JobId AND b.ReservationId = a.ReservationId)
                                          END
        FROM        @resultListTbl results INNER JOIN resinfo ON results.JobId = resinfo.JobId AND results.RequestId = resinfo.RequestId
        set @now = dbo.GetUnixTime(getutcdate())
		-- Make the requests as processed. It can be deleted later based on timeout condition.
		UPDATE	request
		SET		RequestTime = -1, PhaseFirstAttemptTime = @now
		FROM	RMReservationRequest request, @resultListTbl results
		WHERE	request.requestId = results.RequestId
        update GXCounter set next_h = @lastQueryTime, next_l = @now where name = 'RM_Query_Counter'
	END
	ELSE
	BEGIN
        INSERT      INTO @resultListTbl
        SELECT	    a.JobId, a.RequestId, a.ErrorCode, a.FailureType,
                    0, 0, '', '', 0, 0, '', 0, '',
                    '' as results
		FROM		RMReservationRequest a with (readuncommitted), @requestIdListTbl b
		WHERE a.RequestId = b.requestId
		ORDER BY a.PhaseFirstAttemptTime
	END
	SELECT * FROM @resultListTbl
exit_done:
  return
GO

IF EXISTS (select * from GxQscripts where name = 'RMQueryReservationRequestList')
	delete from GxQscripts where name = 'RMQueryReservationRequestList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMQueryReservationRequestList')
	delete from GXDBVersions where aliasname = 'RMQueryReservationRequestList'
GO

insert into GXDBVersions values(2, 'RMQueryReservationRequestList',  '00010006000200130000', 'RMQueryReservationRequestList', '00010006000200130000')
GO

