

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMQueryReservationRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMQueryReservationRequest.sp,v $ $Id: RMQueryReservationRequest.sp,v 1.8.46.5 2019/04/24 14:45:10 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMQueryReservationRequest()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMQueryReservationRequest')
BEGIN
	print '>>> Drop Stored Procedure: RMQueryReservationRequest <<<'
	drop procedure RMQueryReservationRequest
END
IF EXISTS (select * from GxQscripts where name='RMQueryReservationRequest')
	delete from GxQscripts where name = 'RMQueryReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMQueryReservationRequest')
	delete from GXDBVersions where aliasname = 'RMQueryReservationRequest'
GO
print '... Creating Procedure: RMQueryReservationRequest'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMQueryReservationRequest
  @i_RequestId int
AS
  DECLARE @o_ErrorCode int;
  DECLARE @o_FailureType int;
  DECLARE @o_ReservationResults NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET @o_ReservationResults = ''
SET @o_ErrorCode = 0
SET @o_FailureType = 1
	IF @i_RequestId IS NOT NULL AND @i_RequestId > 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM RMReservationRequest WHERE RequestId = @i_RequestId)
			-- return no result
			goto exit_done
SELECT	@o_ErrorCode = ISNULL(ErrorCode, 0),
@o_FailureType = ISNULL(FailureType, 1),
						@o_ReservationResults = ISNULL(ReservationResults, '')
		FROM		RMReservationRequest (NOLOCK)
		WHERE		RequestId = @i_RequestId
		IF @o_ErrorCode != -1
		AND EXISTS (SELECT * FROM RMReservationRequest WHERE RequestId = @i_RequestId AND JobId = 0)
			DELETE RMReservationRequest WHERE RequestId = @i_RequestId
	END
	IF @i_RequestId > 0 AND @o_ReservationResults like '%EMPTY_RESULTS%'
	BEGIN
		IF EXISTS (SELECT 1 FROM RMReservations WITH (NOLOCK) WHERE RequestId = @i_RequestId)
		BEGIN
			--Look up reservations from RMReservations table
			DECLARE @results XML = ''
			SET @results =
			(
				SELECT	TAG, Parent, [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
						[copyRsrvList!1!drivePoolId], [copyRsrvList!1!driveId], [copyRsrvList!1!hostId],
						[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
						[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
						[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
						[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
						[rcidList!2!val]
				from (
				SELECT	DISTINCT 1			          as TAG,
					NuLL									as Parent,
					NuLL									as [copyRsrvList!1],
					res.ReservationId			as [copyRsrvList!1!reservationId],
					res.CopyId						as [copyRsrvList!1!copyId],
					res.StreamId					as [copyRsrvList!1!streamNum],
					res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
					res.DriveId						as [copyRsrvList!1!driveId],
					res.ClientId					as [copyRsrvList!1!hostId],
					res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
					res.VolumeId					as [copyRsrvList!1!volumeId],
					0						as [copyRsrvList!1!sourceRCID],
					ag.Name					as [copyRsrvList!1!archGroupName],
					copy.Name			as [copyRsrvList!1!archGroupCopyName],
					l.AliasName						as [copyRsrvList!1!libraryName],
					dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
					c.Name								as [copyRsrvList!1!mediaAgentName],
					d.AliasName						as [copyRsrvList!1!driveName],
					res.MediaId						as [copyRsrvList!1!mediaId],
					m.Barcode							as [copyRsrvList!1!mediaBarcode],
					NULL									as [rcidList!2!val]
					FROM	RMReservations a, MMResource res, MMResourceToJob resToJob, MMLibrary l with (readuncommitted),
					App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted),
					ArchGroup ag with (readuncommitted), ArchGroupCopy copy with (readuncommitted)
					WHERE	a.RequestId = @i_RequestId
					AND		a.ReservationId = res.ReservationId AND a.ReservationId = resToJob.ReservationId AND a.RCID = resToJob.RCID
					AND		res.LibraryId = l.LibraryId
					AND		res.DrivePoolId = dp.DrivePoolId
					AND		res.ClientId = c.Id
					AND		res.DriveId = d.DriveId
					AND		res.MediaId = m.MediaId
					AND		res.CopyId = copy.Id
					AND		copy.ArchGroupId = ag.Id
				UNION ALL
				SELECT	2			          as TAG,
					1											as Parent,
					NuLL									as [copyRsrvList!1],
					res.ReservationId			as [copyRsrvList!1!reservationId],
					res.CopyId						as [copyRsrvList!1!copyId],
					res.StreamId					as [copyRsrvList!1!streamNum],
					res.DrivePoolId				as [copyRsrvList!1!drivePoolId],
					res.DriveId						as [copyRsrvList!1!driveId],
					res.ClientId					as [copyRsrvList!1!hostId],
					res.MediaGroupId			as [copyRsrvList!1!mediaGroupId],
					res.VolumeId					as [copyRsrvList!1!volumeId],
					0						as [copyRsrvList!1!sourceRCID],
					ag.Name				as [copyRsrvList!1!archGroupName],
					copy.Name		as [copyRsrvList!1!archGroupCopyName],
					l.AliasName						as [copyRsrvList!1!libraryName],
					dp.DrivePoolName			as [copyRsrvList!1!drivePoolName],
					c.Name								as [copyRsrvList!1!mediaAgentName],
					d.AliasName						as [copyRsrvList!1!driveName],
					res.MediaId						as [copyRsrvList!1!mediaId],
					m.Barcode							as [copyRsrvList!1!mediaBarcode],
					resToJob.RCID					as [rcidList!2!val]
					FROM	RMReservations a, MMResource res, MMResourceToJob resToJob, MMLibrary l with (readuncommitted),
					App_Client c with (readuncommitted), MMDrivePool dp with (readuncommitted), MMDrive d with (readuncommitted), MMMedia m with (readuncommitted),
					ArchGroup ag with (readuncommitted), ArchGroupCopy copy with (readuncommitted)
					WHERE	a.RequestId = @i_RequestId
					AND		a.ReservationId = res.ReservationId AND a.ReservationId = resToJob.ReservationId AND a.RCID = resToJob.RCID
					AND		res.LibraryId = l.LibraryId
					AND		res.DrivePoolId = dp.DrivePoolId
					AND		res.ClientId = c.Id
					AND		res.DriveId = d.DriveId
					AND		res.MediaId = m.MediaId
					AND		res.CopyId = copy.Id
					AND		copy.ArchGroupId = ag.Id
				) a
				ORDER BY [copyRsrvList!1!reservationId], [copyRsrvList!1!copyId], [copyRsrvList!1!streamNum],
						[copyRsrvList!1!drivePoolId], [copyRsrvList!1!hostId],
						[copyRsrvList!1!mediaGroupId], [copyRsrvList!1!volumeId], [copyRsrvList!1!sourceRCID],
						[copyRsrvList!1!archGroupName], [copyRsrvList!1!archGroupCopyName],
						[copyRsrvList!1!libraryName], [copyRsrvList!1!drivePoolName], [copyRsrvList!1!mediaAgentName],
						[copyRsrvList!1!driveName], [copyRsrvList!1!mediaId], [copyRsrvList!1!mediaBarcode],
						[rcidList!2!val]
				FOR XML EXPLICIT, TYPE
			)
			SET @o_ReservationResults = replace(@o_ReservationResults, 'EMPTY_RESULTS', cast(@results as nvarchar(max)))
		END
		ELSE
		-- Something wrong here. There is no reservation found
		BEGIN
set @o_ErrorCode = 407
			set @o_ReservationResults = ''
		END
	END
	select @o_ErrorCode, @o_FailureType, @o_ReservationResults
exit_done:
  return
GO

IF EXISTS (select * from GxQscripts where name = 'RMQueryReservationRequest')
	delete from GxQscripts where name = 'RMQueryReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMQueryReservationRequest')
	delete from GXDBVersions where aliasname = 'RMQueryReservationRequest'
GO

insert into GXDBVersions values(2, 'RMQueryReservationRequest',  '00010008004600050000', 'RMQueryReservationRequest', '00010008004600050000')
GO

