

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMProcessWithoutPriority.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMProcessWithoutPriority.sp,v $ $Id: RMProcessWithoutPriority.sp,v 1.7.46.6 2019/03/30 23:23:21 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMProcessWithoutPriority()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMProcessWithoutPriority')
BEGIN
	print '>>> Drop Stored Procedure: RMProcessWithoutPriority <<<'
	drop procedure RMProcessWithoutPriority
END
IF EXISTS (select * from GxQscripts where name='RMProcessWithoutPriority')
	delete from GxQscripts where name = 'RMProcessWithoutPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessWithoutPriority')
	delete from GXDBVersions where aliasname = 'RMProcessWithoutPriority'
GO
print '... Creating Procedure: RMProcessWithoutPriority'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMProcessWithoutPriority
  @i_isDebug int
AS
--:DECLARE o_ErrorCode			integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode				integer
SET @ErrorCode = 0
	DECLARE @RequestId				integer
	DECLARE @JobId						integer
	DECLARE @CommCellId				integer
	DECLARE @JobType					integer
	DECLARE @ScheduleRunId		bigint
	DECLARE @PhaseFirstAttemptTime		integer
	DECLARE @FailureAttempts	integer
	DECLARE @MaxNumOfAttempts	integer
	DECLARE @Priority					integer
	DECLARE @RequestCategory	integer
    DECLARE @HistoryDbExists integer = 0
	/*
    IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..RMReservationRequestHistory') IS NOT NULL)
        SET @HistoryDbExists = 1
	*/
	-- Cursor for geting reservation request list except release and exchangevol requests
	IF (CURSOR_STATUS('LOCAL', 'Request_NoPriority_Cursor') >= -1)
	BEGIN
		CLOSE Request_NoPriority_Cursor
		DEALLOCATE Request_NoPriority_Cursor
	END
	DECLARE Request_NoPriority_Cursor CURSOR STATIC FOR
	SELECT	RequestId, JobId, CommCellId, JobType, ScheduleRunId, PhaseFirstAttemptTime,
					FailureAttempts, MaxNumOfAttempts, Priority, RequestCategory
	FROM		RMReservationRequest
WHERE		RequestCategory in (0, 4, 5, 7, 9)
	AND			ErrorCode = -1
ORDER BY CASE RequestCategory WHEN 0 THEN 0 ELSE 1 END,
					Priority, RequestTime
  OPEN Request_NoPriority_Cursor
  FETCH	NEXT FROM Request_NoPriority_Cursor
  INTO	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
  			@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory
	WHILE @@FETCH_STATUS = 0
	BEGIN
SET @ErrorCode = 0
		-- Check if current reservation request belong to black list
		BEGIN TRANSACTION NO_PRIORITY_RESERVATION_TRANS
IF @RequestCategory = 0
		BEGIN
			EXEC @ErrorCode = RMReleaseReservation @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
ELSE IF @RequestCategory = 4
		BEGIN
			EXEC @ErrorCode = RMExchangeForRestore @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
ELSE IF @RequestCategory = 5
		BEGIN
			EXEC @ErrorCode = RMExchangeForBackup @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
ELSE IF @RequestCategory = 7
		BEGIN
			EXEC @ErrorCode = RMExchangeForMAAndDP @RequestId, 0, 0, 0, 0, 0, 0, 0, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
ELSE IF @RequestCategory = 9
		BEGIN
			EXEC @ErrorCode = RMExchangeMultiplexingSourceVolume @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
        IF(@HistoryDbExists = 1)
        BEGIN
            -- Add the resource allocation details to history db
            INSERT INTO HistoryDB..RMReservationRequestHistory (RequestId, ErrorCode, FailureType, JobId, AppId, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, ResourceReservationEndTime, RequestCategory, XmlParams, ReservationResults)
            --values (@RequestId,  @ErrorCode, FailureType, @JobId, AppId, @CommCellId, @JobType, @jobOpType, iDAType, @PhaseFirstAttemptTime, ResourceReservationEndTime, @RequestCategory, XmlParams, ReservationResults)
            SELECT RequestId, ErrorCode, FailureType, JobId, FailureType, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, dbo.GetUnixTime(getutcdate()), RequestCategory, XmlParams, ReservationResults
                FROM RMReservationRequest where requestId = @RequestId and jobId = @JobId
        END
		--IF @@TRANCOUNT > 0
		COMMIT TRANSACTION NO_PRIORITY_RESERVATION_TRANS
	  FETCH	NEXT FROM Request_NoPriority_Cursor
	  INTO	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
	  			@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory
	END
	CLOSE Request_NoPriority_Cursor
	DEALLOCATE Request_NoPriority_Cursor
error_exit:
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMProcessWithoutPriority')
	delete from GxQscripts where name = 'RMProcessWithoutPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessWithoutPriority')
	delete from GXDBVersions where aliasname = 'RMProcessWithoutPriority'
GO

insert into GXDBVersions values(2, 'RMProcessWithoutPriority',  '00010007004600060000', 'RMProcessWithoutPriority', '00010007004600060000')
GO

