

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMProcessReservation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMProcessReservation.sp,v $ $Id: RMProcessReservation.sp,v 1.21.2.44.8.3 2021/04/13 17:43:05 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMProcessReservation()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMProcessReservation')
BEGIN
	print '>>> Drop Stored Procedure: RMProcessReservation <<<'
	drop procedure RMProcessReservation
END
IF EXISTS (select * from GxQscripts where name='RMProcessReservation')
	delete from GxQscripts where name = 'RMProcessReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessReservation')
	delete from GXDBVersions where aliasname = 'RMProcessReservation'
GO
print '... Creating Procedure: RMProcessReservation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMProcessReservation
  @i_isBlackListingFeatureEnabled int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationList NVARCHAR(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @BKPJOB						integer
	DECLARE @SYNTHFULLJOB			integer
	DECLARE @RESOURCEALLOCJOB	integer
	SET @BKPJOB							= 1
	SET @SYNTHFULLJOB				= 7
	SET @RESOURCEALLOCJOB		= 19
	DECLARE @ErrorCode				integer
SET @ErrorCode = 0
	DECLARE @RequestId				integer
	DECLARE @JobId						integer
	DECLARE @CommCellId				integer
	DECLARE @JobType					integer
	DECLARE @ScheduleRunId		bigint
	DECLARE @PhaseFirstAttemptTime		integer
	DECLARE @FailureAttempts	integer
	DECLARE @MaxNumOfAttempts	integer
	DECLARE @Priority					integer
	DECLARE @RequestCategory	integer
	DECLARE @jobOpType			integer
    DECLARE @HistoryDbExists integer = 0
	/*
    IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..RMReservationRequestHistory') IS NOT NULL)
        SET @HistoryDbExists = 1
	*/
	DECLARE @beginTime					DATETIME
	DECLARE @totReqCount 				INT
	DECLARE @successCount 				INT
	DECLARE @failedCount 				INT
	DECLARE @blackListedCount 			INT
	DECLARE @exceededStreamLimitCount	INT
	CREATE TABLE #__suppress_results (dummycol int)
	delete rmlogger where requestId = 0
	-- Remove all the unwanted request
UPDATE RMJobControl SET Status = 5 WHERE Status = 4
	-- This is when the job failed.
	UPDATE	RMJobControl
SET			ErrorCode = ISNULL(a.ErrorCode, 0),
					FailureType = ISNULL(a.FailureType, 0),
FailureReason = CASE WHEN a.ErrorCode = 0 THEN ''
										WHEN RIGHT(a.ReservationResults, 1) != '>' THEN ''
										ELSE a.ReservationResults END,
					FailureAttempts = ISNULL(a.FailureAttempts, 0)
	FROM
					(
						SELECT	TOP 1 req.JobId as JobId, req.CommCellId as CommCellId,
										req.ErrorCode as ErrorCode, req.FailureType as FailureType, req.ReservationResults as ReservationResults,
										req.FailureAttempts as FailureAttempts
						FROM		RMReservationRequest req with (readuncommitted), RMJobControl job with (readuncommitted)
						WHERE		req.JobId = job.JobId AND req.CommcellId = job.CommcellId
AND			job.Status in (5, 3)
						AND			req.ErrorCode > 0
						ORDER BY	req.PhaseFirstAttemptTime desc
					)	a,
					RMJobControl b
	WHERE		a.JobId = b.JobId AND a.CommCellId = b.CommCellId
AND			b.Status in (5, 3)
	-- Release for this job
	-- WHERE RMJobControl.Status in (RM_RESERVATION_REQUEST_CANCELLED, RM_RESERVATION_REQUEST_PENDING)
	DECLARE @tempReqIds TABLE(requestId integer)
	INSERT  INTO @tempReqIds
	SELECT	req.RequestId
	FROM	RMReservationRequest req with (readcommitted readpast), RMJobControl job with (readcommitted readpast)
WHERE	req.RequestCategory != 0
AND		job.Status in (5, 3)
	AND		req.JobId = job.JobId
	DELETE RMReservationRequest
	FROM	@tempReqIds ids
	WHERE	RMReservationRequest.requestId = ids.RequestId
	-- Release all the logical released resources.
	-- Logical release resources should have only MMResource entries.
	DELETE MMResource WHERE LogicalRelease = 1 AND ReservationId NOT IN (SELECT ReservationId FROM MMResourceToJob)
	DELETE MMResource WHERE Released = 1
	AND ( IntrJobId_l > 0 AND NOT EXISTS (SELECT 1 FROM MMResourceToJob WHERE JobId_l = MMResource.IntrJobId_l)
			OR
		  IntrJobId_l = 0 AND NOT EXISTS (SELECT 1 FROM MMResourceToJob WHERE ReservationId = MMResource.ReservationId)
		)
	-- Delete dangling resources from certain condition
	DECLARE @danglingReservationsAndJob TABLE
			(
				jobId 			integer,
				reservationId	integer,
				rcId			integer
			)
	INSERT INTO @danglingReservationsAndJob
	SELECT DISTINCT b.JobId_l, b.ReservationId, b.RCId
	FROM	MMResource a WITH (NOLOCK), MMResourceToJob b WITH (NOLOCK)
	WHERE	a.ReservationId = b.ReservationId
	AND		b.JobId_l > 0
	AND		(
				(a.IntrJobId_l = 0 AND NOT EXISTS (SELECT 1 FROM JMJobInfo with (nolock) WHERE JobId = b.JobId_l))
				OR
				-- Interruption happens, but job doesn't exist anymore
				(a.IntrJobId_l > 0 AND NOT EXISTS (SELECT 1 FROM JMJobInfo with (nolock) WHERE JobId = a.IntrJobId_l))
			)
	-- exclude the cached resources for backup caching
	AND		(b.InUse = 0 AND b.ReleaseTime = 0)
	AND		(
b.ReserveBitMask = 1
				OR
b.ReserveBitMask = 2
				AND not exists (select 1 from MMDrive with (nolock) where driveId = a.DriveId and (MountStatus <> 0))
			)
	IF EXISTS (SELECT * FROM @danglingReservationsAndJob)
	BEGIN
		DELETE MMResourceToJob
		FROM	MMResourceToJob a, @danglingReservationsAndJob b
		WHERE	a.ReservationId = b.ReservationId AND a.RCId = b.RCId AND a.JobId_l = b.jobId
		DELETE @danglingReservationsAndJob
		FROM @danglingReservationsAndJob a
		WHERE EXISTS (SELECT 1 FROM MMResourceToJob WHERE ReservationId = a.ReservationId AND JobId_l != a.JobId)
		DELETE MMResource
		FROM MMResource a, @danglingReservationsAndJob b
		WHERE a.ReservationId = b.ReservationId
	END
	-- Reset the Donot Multiplexing flag on all the reservations. It is been set during reservation to prevent multiplexing.
UPDATE MMResource SET ResourceFlag = 	ResourceFlag & (~2)
	-- Reset the Job Priority because it might be changed during process
	DECLARE @jobWithPriorityChange TABLE
			(
				jobId		integer,
				commcellId	integer,
				priority	integer
			)
	INSERT INTO @jobWithPriorityChange
	SELECT	DISTINCT a.jobId, a.commcellId, b.combPriority
	FROM	RMReservationRequest a with (readuncommitted), JMJobInfo b with (readuncommitted)
	WHERE	a.jobId = b.jobId
	AND		a.commcellId = b.commcellid
	AND		a.priority != b.combPriority
	IF @@ROWCOUNT != 0
	BEGIN
		UPDATE	RMReservationRequest
		SET		Priority = a.priority
		FROM	RMReservationRequest request, @jobWithPriorityChange a
		WHERE	request.jobId = a.jobId and request.commcellid = a.commcellId
	END
	-- Reset the reservation status for release and exchangevol request if they fail last time.
	-- So it will be retry again at the beginning of each loop.
	-- The new request will be try during process the loop if it comes in.
	UPDATE	RMReservationRequest
	SET			ErrorCode = -1, FailureType = -1
WHERE		RequestCategory in (0, 4, 5, 7, 9)
AND			ErrorCode <> 0
	AND			(MaxNumOfAttempts <= 0 OR MaxNumOfAttempts > FailureAttempts)
	-- next_l is the current lookup time, next_h is the previous lookup time.
	-- If next_l greater then now time, it means current returned results haven't been processed by JM completely.
	-- Delete results based on the previous time in this case will remove some unprocessed request. Skip one attempt is OK.
	DECLARE @now int = dbo.GetUnixTime(getutcdate())
	DECLARE @lastQueryTime integer = 0
	SELECT @lastQueryTime = CASE WHEN next_l > @now THEN -1 ELSE next_h END FROM GXCounter WITH (NOLOCK) WHERE name = 'RM_Query_Counter'
	IF @lastQueryTime > 0
	BEGIN
		DELETE RMReservationRequest
WHERE		RequestCategory in (2, 3, 6, 8)
		AND			ErrorCode > 0
		AND			(MaxNumOfAttempts > 0 AND FailureAttempts > 0 AND MaxNumOfAttempts <= FailureAttempts)
		-- MR 200319, cliu
		-- Request Time will be set to -1 once the results are returned to job manager.
		-- We cannot delete based on RequestTime anymore for backup and dashcopy request.
		-- This problem should be recovered automatically even when it happens.
		AND			(
						(
RequestCategory in (3, 6)
AND RequestTime < (@lastQueryTime - 2 * 60)
						)
						OR
						(
RequestCategory in (2, 8)
							AND
PhaseFirstAttemptTime < (@lastQueryTime - 2 * 60) AND RequestTime = -1
							AND	(
RequestCategory <> 8
									OR
									NOT EXISTS (SELECT 1 FROM ArchJobStreamStatus with (NOLOCK) WHERE ReservationRequestId = RequestId)
								)
						)
					)
	END
	/*
	-- Get the storage policy list by whether it has mounted media.
	-- This is done by stored procedure MMS2GetSPForMediaInDrive
	DECLARE @tmpArchGroupID TABLE ( Id integer, name NVARCHAR(255))
	INSERT INTO @tmpArchGroupID
	EXEC MMS2GetSPForMediaInDrive 0
	*/
	DECLARE @SPBlackListing TABLE ( ArchGroupId integer, SIDBStoreId integer, DataType integer, ErrorRequestId integer)
	DECLARE @isBlackListingEnabled integer = 0
	DECLARE @isFatalError			integer = 0
	DECLARE @l_archGroupId		integer = 0
	DECLARE @l_archGroupFlags	integer = 0
	DECLARE @l_copyId			integer = 0
	DECLARE @l_appId			integer = 0
	DECLARE @l_SIDBStoreId		integer = 0
	DECLARE @l_bkpAttributes	bigint = 0
	DECLARE @l_DataType			integer = 0
	DECLARE @l_skipStreamLimits BIT = 0
	DECLARE @processStartTime int = dbo.GetUnixTime(getutcdate())
	DECLARE @waitCounts int = 0
	DECLARE @currentJobActivity int = 0
	DECLARE @jobActivityHighWaterMark int = 0
	select @jobActivityHighWaterMark = isnull(value, 500) from GXGlobalParam with (nolock) where name = 'JMJobActivityLevelHighWaterMark' and modified = 0
	DECLARE @currentSynthFullJobActivity int = 0
DECLARE @synthFulljobActivityHighWaterMark int = 50
	SELECT 	@synthFulljobActivityHighWaterMark = cast(cast(value as nvarchar(30)) as int)
	FROM	APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE	entityId = 2 AND entityType = 3
			AND keyname = 'JMSynthFullJobHighWaterMark'
			AND enabled = 1 AND deleted = 0
			AND cast(cast(value as nvarchar(30)) as int) > 0
	-- Cursor for geting reservation request list except release and exchangevol requests
	IF (CURSOR_STATUS('LOCAL', 'Reservation_Request_Cursor') >= -1)
	BEGIN
		CLOSE Reservation_Request_Cursor
		DEALLOCATE Reservation_Request_Cursor
	END
	-- Create a snap on the table, so any new inserts will not affect the cursor
	IF object_id('tempdb.dbo.#tmpRMReservationRequestSnap') IS NOT NULL
		DROP TABLE #tmpRMReservationRequestSnap
	CREATE TABLE #tmpRMReservationRequestSnap (RequestId INT, JobId INT, CommCellId INT, JobType INT, ScheduleRunId INT, PhaseFirstAttemptTime INT,
				FailureAttempts INT, MaxNumOfAttempts INT, Priority INT, RequestCategory INT,
				InnerOrder INT NOT NULL IDENTITY(1, 1) primary key)
	DECLARE @tmpBackupSPId	INT = 0
	-- Start reservation from the top
RESERVATION_REATTEMPT:
	SET @beginTime 					= GetUTCDate()
	SET @totReqCount 				= 0
	SET @successCount 				= 0
	SET @failedCount 				= 0
	SET @blackListedCount			= 0
	SET @exceededStreamLimitCount	= 0
	-- Before doing reservation, check if the release request and exchange volume request exist
	IF EXISTS (SELECT RequestId FROM RMReservationRequest
WHERE		RequestCategory in (0, 4, 5, 7, 9)
						AND			ErrorCode = -1)
	BEGIN
		-- Call stored procedure to precess the request
		EXEC @ErrorCode = RMProcessWithoutPriority @i_isDebug
		IF @@ERROR > 0
		BEGIN
SET @ErrorCode = 415
			-- TODO: log the error information
		END
	END
	IF EXISTS (SELECT RequestId FROM RMReservationRequest
WHERE RequestCategory = 6
							AND		JobId = 0)
	BEGIN
		EXEC RMProcessOtherRequests 0, @i_isDebug
		IF @@ERROR > 0
		BEGIN
SET @ErrorCode = 415
			-- TODO: log the error information
		END
	END
	/*
	-- DEBUG ONLY
	IF object_id('RMProcessHistory') IS NOT NULL
		DELETE RMProcessHistory
	ELSE
		CREATE TABLE RMProcessHistory (RequestId INT, JobId INT, CommCellId INT, JobType INT, ScheduleRunId INT, PhaseFirstAttemptTime INT,
					FailureAttempts INT, MaxNumOfAttempts INT, Priority INT, RequestCategory INT)
	*/
	insert INTO #tmpRMReservationRequestSnap
				( RequestId, JobId, CommCellId, JobType, ScheduleRunId, PhaseFirstAttemptTime,
					FailureAttempts, MaxNumOfAttempts, Priority, RequestCategory)
	SELECT	a.RequestId, a.JobId, a.CommCellId, a.JobType, a.ScheduleRunId, a.PhaseFirstAttemptTime,
					a.FailureAttempts, a.MaxNumOfAttempts, a.Priority, a.RequestCategory
	FROM		RMReservationRequest a with (readuncommitted), RMJobControl b with (readuncommitted)
WHERE		a.RequestCategory in (1, 2, 3, 6, 8)
AND			a.ErrorCode <> 0
	AND			(a.MaxNumOfAttempts < 0 OR a.FailureAttempts = 0 OR a.MaxNumOfAttempts > a.FailureAttempts)
AND			(a.PhaseFirstAttemptTime = 0 OR a.FailureAttempts = 0 OR a.PhaseFirstAttemptTime > 0 AND (a.PhaseFirstAttemptTime + a.FailureAttempts * 2 * 60) <= dbo.GetUnixTime(getutcdate()))
	AND			a.JobId > 0 AND a.JobId = b.JobId
AND			b.Status = 1
	ORDER BY
				-- 1.	Assigned priority. Note that a lower priority number means higher priority.
				Priority,
				-- 2.	If having resources allocated already, the jobs have higher priority.
				CASE WHEN EXISTS (SELECT RCId FROM MMResourceToJob WHERE JobId_h = 0 AND JobId_l = a.JobId) THEN 0 ELSE 1 END,
				-- 3. Check if there are media mount by the storage policy. If so, it has higher priority
CASE WHEN NOT EXISTS (select * from JMBkpJobInfo with (readuncommitted) where JobId = a.JobId and commCellId = 2)
THEN CASE WHEN NOT EXISTS (select * from JMAdminJobInfoTable with (readuncommitted) where JobId = a.JobId and commCellId = 2)
							THEN 0
							ELSE CASE WHEN EXISTS (SELECT * FROM MMResource res, ArchGroupCopy copy with (readuncommitted), JMAdminJobInfoTable admin with (readuncommitted)
where res.CopyId = copy.Id and copy.ArchGroupId = admin.archGrpId and admin.JobId = a.JobId and admin.commCellId = 2)
										THEN 0
										ELSE 1 END
						 	END
				ELSE CASE WHEN EXISTS (SELECT * FROM MMResource res, ArchGroupCopy copy with (readuncommitted), JMBkpJobInfo job with (readuncommitted)
where res.CopyId = copy.Id and copy.ArchGroupId = job.CurrentPolicy and job.JobId = a.JobId and job.commCellId = 2)
						 THEN 0
						 ELSE 1 END
				END,
				-- 4. Combined Dynamic Priority JM_DYNAMIC_PRIORITY_OF_JOB_NAME
(SELECT TOP 1 (-1 * ISNULL(attributeValueInt, 0)) FROM JMJobOptions jOption with (readuncommitted) where jOption.attributeName = 'Combined Dynamic priority' AND jOption.jobId = a.JobId  AND jOption.commCellId =  2), --lower valued number means higher priority, hence multiply by -1
				-- 5.	Check how long the resource allocation request has been pending.
				a.PhaseFirstAttemptTime,
				-- 6. Base on the job start time
				(SELECT ISNULL(JobStartTime, 0) FROM JMJobInfo with (readuncommitted) where JobId = a.JobId)
	SET @totReqCount = @@ROWCOUNT
	IF @totReqCount = 0
	BEGIN
IF (@processStartTime + 2 * 60) < dbo.GetUnixTime(getutcdate())
		OR @waitCounts >= 5
			GOTO error_exit
		ELSE
		BEGIN
			SET @waitCounts = @waitCounts + 1
			waitfor delay '00:00:01'
			GOTO RESERVATION_REATTEMPT
		END
	END
	SET @waitCounts = 0
	WHILE EXISTS (SELECT 1 FROM #tmpRMReservationRequestSnap)
	BEGIN
SET @ErrorCode = 0
		SET @isBlackListingEnabled = @i_isBlackListingFeatureEnabled
		SET @isFatalError = 0
		SET @l_archGroupId = 0
		SET @l_archGroupFlags = 0
		SET @l_appId = 0
		SET @l_copyId = 0
		SET @l_SIDBStoreId = 0
		SET @l_bkpAttributes = 0
		SET @l_DataType = 0
		SET @l_skipStreamLimits = 0
		SELECT	TOP 1 @RequestId = RequestId,
				@JobId = JobId,
				@CommCellId = CommCellId,
				@JobType = JobType,
				@ScheduleRunId = ScheduleRunId,
				@PhaseFirstAttemptTime = PhaseFirstAttemptTime,
				@FailureAttempts = FailureAttempts,
				@MaxNumOfAttempts = MaxNumOfAttempts,
				@Priority = Priority,
				@RequestCategory = RequestCategory
		FROM	#tmpRMReservationRequestSnap
		ORDER BY InnerOrder
		-- Because of the limitation, we cannot use the function to get opType for snap related jobs
		--set @jobOpType = dbo.GetJobTypeForJobID(@JobId)
		SELECT @jobOpType = ISNULL(opType, -1) FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @JobId
		IF EXISTS (SELECT 1 FROM RMJobControl
								WHERE	JobId = @JobId AND CommcellId = @commCellId
AND		Status in (4, 5, 3))
		BEGIN
			UPDATE RMJobControl
SET Status = 5
			WHERE 	JobId = @JobId AND CommcellId = @CommCellId
AND		Status = 4
			-- This is when the job failed.
			UPDATE	RMJobControl
SET			ErrorCode = ISNULL(a.ErrorCode, 0),
							FailureType = ISNULL(a.FailureType, 0),
FailureReason = CASE WHEN a.ErrorCode = 0 THEN ''
												WHEN RIGHT(a.ReservationResults, 1) != '>' THEN ''
												ELSE a.ReservationResults END,
							FailureAttempts = ISNULL(a.FailureAttempts, 0)
			FROM
							(
								SELECT	TOP 1 req.JobId as JobId, req.ErrorCode as ErrorCode ,
												req.FailureType as FailureType, req.ReservationResults as ReservationResults,
												req.FailureAttempts as FailureAttempts
								FROM		RMReservationRequest req
								WHERE		req.JobId = @JobId AND req.CommCellId = @CommCellId
								AND			req.ErrorCode > 0
								ORDER BY req.PhaseFirstAttemptTime
							)	a,
							RMJobControl b
			WHERE		b.JobId = @JobId AND b.CommcellId = @CommCellId
			AND			a.JobId = @JobId
			DELETE FROM RMReservationRequest
			WHERE JobId = @JobId AND CommCellId = @CommCellId
AND		RequestCategory != 0
			DELETE FROM #tmpRMReservationRequestSnap
			WHERE JobId = @JobId AND CommCellId = @CommCellId
AND		RequestCategory != 0
			CONTINUE
		END
		-- Before doing reservation, check if the release request and exchange volume request exist
		IF EXISTS (SELECT RequestId FROM RMReservationRequest
WHERE		RequestCategory in (0, 4, 5, 7, 9)
							AND			ErrorCode = -1)
		BEGIN
			-- Call stored procedure to precess the request
			EXEC @ErrorCode = RMProcessWithoutPriority @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
		-- requests without job id
		IF EXISTS (SELECT RequestId FROM RMReservationRequest
WHERE RequestCategory = 6
								AND		JobId = 0)
		BEGIN
			EXEC RMProcessOtherRequests 0, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
		-- TODO: check the job status to set whether should try the request for this job or not
		DECLARE @isJobRunning INT = 1
		EXEC 	RMIsJobOnRunningState @JobId, @CommCellId, @isJobRunning output
		IF @@ERROR > 0
		BEGIN
SET @ErrorCode = 415
			-- TODO: log the error information
		END
		IF @isJobRunning = 0
		BEGIN
			/*
			-- DEBUG ONLY
			insert RMProcessHistory ( RequestId, JobId, CommCellId, JobType, ScheduleRunId, PhaseFirstAttemptTime,
							FailureAttempts, MaxNumOfAttempts, Priority, RequestCategory)
			select	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
				@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory
			*/
UPDATE RMJobControl SET Status = 5 WHERE JobId = @JobId AND CommcellId = @CommCellId
UPDATE RMReservationRequest SET ErrorCode = 365 WHERE RequestId = @RequestId
			DELETE #tmpRMReservationRequestSnap WHERE RequestId = @RequestId
			CONTINUE
		END
		-- Check if current reservation request belong to black list
		-- 1. Job is not interrupting other jobs.
		-- 2. Use Storage Policy Black Listing Feature is enabled.
		-- 3. Job is OK to check Storage Policy Black Listing. If job type is unknown, it must not be a backup job. No need to do blacklist for it.
		--		Always true when job type is BKPJOB, SYNTHFULLJOB, or RESOURCEALLOCJOB
		-- 4. Job storage policy belong to black list.
		-- Exception: for Oracle Multi instance backup job, try reservation even it is blacklisted.
		IF 	@isBlackListingEnabled > 0 -- Value from registry key default as enabled
			AND
			(
				@JobType NOT IN (@BKPJOB, @SYNTHFULLJOB, @RESOURCEALLOCJOB)
				OR @jobOpType IN (59, 60, 65)
				-- SNAPBACKUP = 59, -- Snap Backup
				-- SNAPTOTAPE = 60, -- Backup Copy
				-- SNAPBACKUP3RD = 65, -- Third Party Snap Backup
			)
		BEGIN
			SET @isBlackListingEnabled = 0
		END
		IF 	@isBlackListingEnabled > 0
		BEGIN
			SELECT 	@l_archGroupId 		= CurrentPolicy,
					@l_appId 			= applicationId,
					@l_bkpAttributes 	= bkpattributes
			FROM 	JMBkpJobInfo with (readuncommitted)
WHERE 	JobId = @JobId AND commCellId = 2
			IF @@ROWCOUNT = 0
			BEGIN
				SELECT 	@l_archGroupId 	= ArchGrpId,
						@l_appId 		= appId
				FROM 	JMAdminJobInfoTable with (readuncommitted)
WHERE 	JobId = @JobId AND commCellId = 2
			END
			SELECT 	@l_copyId = defaultCopy,
					@l_archGroupFlags = flags
			FROM 	archGroup WITH(READUNCOMMITTED)
			WHERE 	id = @l_archGroupId
			DECLARE @ddbCopyId INT = 0
			SET @ddbCopyId = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId = @l_appId AND cs_attrName = CheckSum(N'DDB Backup CopyId') AND attrName = N'DDB Backup CopyId' AND Modified = 0), 0)
			IF @ddbCopyId > 0
			BEGIN
				SET @l_copyId = @ddbCopyId
			END
			SELECT	@l_SIDBStoreId = SIDBStoreId
			FROM	archSubclientCopyDDBMap WITH(READUNCOMMITTED)
			WHERE	appId = @l_appId
					AND copyId = @l_copyId
			DECLARE @isTransactionLogBackup INT = 0
			DECLARE @dedupeFlags int = 0
			SELECT @dedupeFlags = ISNULL(dedupeFlags, 0)
			FROM ArchGroupCopy WITH (READUNCOMMITTED)
			WHERE id = @l_copyId
EXEC MMIsTransactionLogBackupPhase @jobId, 2, @isTransactionLogBackup output
			IF @isTransactionLogBackup > 0
			OR
			 -- If dedupe is disabled on subclient, we allow regular backup run to this particular subclient.
			(@l_appId > 0 AND EXISTS ( select prop.Id from APP_SubClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
									where app.Id = @l_appId and app.Id = prop.ComponentNameId and prop.cs_attrName = CheckSum(N'Single Instancing Option')
									and prop.attrName = N'Single Instancing Option' and prop.attrVal = '0' and prop.Modified = 0	))
			OR
			 -- If dedupe is disabled on copy, we allow regular bakcup run to this copy for all the subclients.
(@dedupeFlags & 1048576) > 0
			BEGIN
				SET @l_SIDBStoreId = 0
			END
			DECLARE @l_RequestXml xml = (SELECT xmlParams FROM RMReservationRequest WITH(READUNCOMMITTED) WHERE RequestId = @RequestId)
			SELECT	@l_DataType = params.value('@dataType', 'int')
			FROM   	@l_RequestXml.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
WHERE	isnull(params.value('@dataType', 'int'), 0) IN (2, 6)
		END
		IF 	@isBlackListingEnabled > 0
			AND
			(
				@l_bkpAttributes & 0x100000000 /*JMBKP_SINGLE_INSTENCE_SILO*/ >  0
OR @l_bkpAttributes & 0x800000 > 0
			)
		BEGIN
			SET @isBlackListingEnabled = 0
		END
		IF @isBlackListingEnabled > 0
		AND NOT EXISTS (SELECT 1 FROM MMResource WHERE IntrJobId_h = 0 AND IntrJobId_l = @JobId)
		BEGIN
			-- Check if storage policy was already black listed
			DECLARE @ErrorRequestId INT = 0
			DECLARE @BLErrorCode INT = -1
			DECLARE @BLFailureType INT = -1
			DECLARE @BLReservationResults nvarchar(4000) = N''
			DECLARE @BLShouldFailRequest INT = 0
			SELECT	@ErrorRequestId = ErrorRequestId
			FROM	@SPBlackListing
			WHERE 	ArchGroupId = @l_archGroupId
					AND SIDBStoreId = @l_SIDBStoreId
					AND DataType = @l_DataType
			IF @ErrorRequestId > 0
			BEGIN
				SELECT 	TOP 1 @BLErrorCode = ErrorCode,
						@BLFailureType = FailureType,
						@BLReservationResults = ReservationResults,
						@BLShouldFailRequest = ShouldFailRequest
				FROM 	RMReservationRequest
				WHERE 	RequestId = @ErrorRequestId
				IF @@ROWCOUNT = 0
					SET @ErrorRequestId = 0
			END
			-- Backup caching feature may require disable blacklisting temporarily.
			IF @ErrorRequestId > 0
AND @l_archGroupFlags & 1048576 > 0
			BEGIN
				IF EXISTS (	select 1
							from	mmresourcetojob restojob with (readuncommitted), mmresource res with (readuncommitted)
							where	restojob.reservationtype = 2 /*write*/
and		restojob.releasetime != 0 and (restojob.inuse = 0 OR (restojob.ReserveBitMask /*& (~2) */= 0))
							and		restojob.ReservationId = res.ReservationId
							and		res.CopyId = @l_copyId
							and		res.VolumeId > 0
						)
					SET @ErrorRequestId = 0
			END
			-- Skip blacklist for log phase backup when the failure reason is DDB related
			IF @ErrorRequestId > 0
			BEGIN
				DECLARE @isTransactionLogBackupPhase INT = 0
				DECLARE @skipBlackListing INT = 0
EXEC JMCanSkipSPBlackListing @jobId, 2, @l_archGroupId, 1 /*skipResultSet*/, @skipBlackListing output, 	@isTransactionLogBackupPhase output
				IF @skipBlackListing = 1
				BEGIN
					SET @ErrorRequestId = 0
				END
				ELSE IF @isTransactionLogBackupPhase = 1
					AND @BLErrorCode IN (
20119,
20066,
20067,
20082,
20072,
20074,
20073,
66017,
53078,
53049,
66105,
20122,
20121,
20120,
20109,
20118
									)
				BEGIN
					SET @ErrorRequestId = 0
				END
			END
			IF (@ErrorRequestId > 0)
			BEGIN
				IF @JobType In (@SYNTHFULLJOB, @RESOURCEALLOCJOB)
				BEGIN
UPDATE ArchJobStreamStatus SET Status = 0x04  WHERE JobId = @jobId AND ReservationRequestId = @RequestId
				END
				UPDATE	a
				SET		ErrorCode = @BLErrorCode,
						FailureType  = @BLFailureType,
						RequestTime = dbo.GetUnixTime(getutcdate()),
						FailureAttempts = a.FailureAttempts + 1,
						PhaseFirstAttemptTime = case a.PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else a.PhaseFirstAttemptTime end,
						ReservationResults = @BLReservationResults,
						ShouldFailRequest = @BLShouldFailRequest
				FROM	RMReservationRequest a
				WHERE	a.RequestId = @RequestId
				DELETE #tmpRMReservationRequestSnap WHERE RequestId = @RequestId
				SET @blackListedCount = @blackListedCount + 1
				CONTINUE
			END
		END
		--
		-- Skip stream limit checks for VSA V2 archive index reservation request
		-- VSA V2 backups a vm and keeps the pipeline open and calls inline archive index
		-- Index MA does a new stream reservation to do archive index
		-- iDA side stream will be idle until archive index completes so there will be only one stream in active state.
		--
		IF @JobType IN (@BKPJOB, @SYNTHFULLJOB)
		BEGIN
			IF EXISTS
			(
				select 	1
				from 	JMBkpJobInfo BJ WITH (READUNCOMMITTED)
						INNER JOIN App_Application APP WITH (READUNCOMMITTED) ON BJ.applicationId = APP.id
						INNER JOIN APP_ClientProp CL WITH (READUNCOMMITTED) ON CL.componentNameId = APP.clientId
where 	BJ.JobId = @JobId AND BJ.commCellId = 2
AND APP.AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/
						AND CL.attrName = 'IndexingV2_VSA'
						AND CL.attrVal = N'1'
						AND CL.modified = 0
			)
			BEGIN
				IF @l_DataType = 0
				BEGIN
					DECLARE @l_XmlParams xml = (SELECT ISNULL(xmlParams, '') FROM RMReservationRequest WITH(READUNCOMMITTED) WHERE RequestId = @RequestId)
					IF EXISTS
					(
						SELECT	1
						FROM   	@l_XmlParams.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
WHERE	ISNULL(params.value('@dataType', 'int'), 0) IN (2, 6)
					)
					BEGIN
						SET @l_skipStreamLimits = 1
					END
				END
ELSE IF @l_DataType IN (2, 6)
				BEGIN
					SET @l_skipStreamLimits = 1
				END
			END
		END
		IF @l_skipStreamLimits = 0
		BEGIN
			--
			-- CommCell level streams high watermark check
			--
IF @RequestCategory IN ( 2, 3, 8)
			BEGIN
				SELECT @currentJobActivity = COUNT(1)
				FROM JMJobInfo JI  WITH (NOLOCK)
				LEFT OUTER JOIN JMBkpJobInfo JBI WITH (NOLOCK) ON JI.jobId = JBI.jobId AND JI.commCellId = JBI.commCellId
				LEFT OUTER JOIN MMResourceToJob MMR	 WITH (NOLOCK) ON MMR.JobId_l = JI.jobId
WHERE JI.state in (1, 3, 6,7,8,13,17,18) AND JI.commCellId = 2
				AND (
(JBI.jobId IS NULL OR JBI.bkpAttributesEx & 0x4000000 /*0x4000000*/ = 0) AND JI.state != 3
						OR MMR.jobId_l IS NOT NULL
					)
				IF @currentJobActivity >= @jobActivityHighWaterMark
				BEGIN
					UPDATE	a
SET		ErrorCode = 20175,
FailureType  = 2,
							RequestTime = dbo.GetUnixTime(getutcdate()),
							FailureAttempts = a.FailureAttempts + 1,
							PhaseFirstAttemptTime = case a.PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else a.PhaseFirstAttemptTime end,
ReservationResults = '<ResourceManager_ReservationList><errorList failureCode="' + cast(20175 as varchar(20)) +
'" failureType="' + cast(2 as varchar(20)) + '"/></ResourceManager_ReservationList>',
							ShouldFailRequest = 0
					FROM	RMReservationRequest a
					WHERE	a.RequestId = @RequestId
					DELETE #tmpRMReservationRequestSnap WHERE RequestId = @RequestId
IF --@RequestCategory IN ( 8) AND
						EXISTS (SELECT 1 FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @jobId AND ReservationRequestId = @RequestId)
					BEGIN
						UPDATE ArchJobStreamStatus
						SET		Status = 0x04 /* STREAM_READER_STATUS_FAILED */
						WHERE	jobId = @jobId
						AND		ReservationRequestId = @RequestId
						--AND		Status != 0x01 /* STREAM_READER_STATUS_RESERVED */
					END
					SET @exceededStreamLimitCount = @exceededStreamLimitCount + 1
					CONTINUE
				END
			END
			--
			-- Synthfull job activity high watermark check
			--
			IF 	@JobType = @SYNTHFULLJOB
			BEGIN
				--
				--Skip check if job already has some resources and requesting for additional streams
				--
				IF NOT EXISTS
				(
					SELECT 	1
					FROM 	JMJobInfo JI WITH (NOLOCK), MMResourceToJob RJ WITH (NOLOCK)
					WHERE 	JI.jobId = RJ.JobId_l
							AND JI.jobId = @jobId
AND JI.commCellId = 2
							AND JI.state = 1  --Running
				)
				BEGIN
					SELECT 	@currentSynthFullJobActivity = COUNT(1)
					FROM 	JMJobInfo JI  WITH (NOLOCK)
WHERE 	JI.opType = 14 AND JI.commCellId = 2
							AND
							(
								JI.state = 1 --Running
								OR EXISTS(SELECT 1 FROM MMResourceToJob RJ WITH (NOLOCK) WHERE RJ.JobId_l = JI.jobId) --Has a stream
							)
							AND JI.jobId <> @jobId --skip current job
					IF @currentSynthFullJobActivity >= @synthFullJobActivityHighWaterMark
					BEGIN
						UPDATE	RMReservationRequest
SET		ErrorCode = 20185,
FailureType  = 2,
								RequestTime = dbo.GetUnixTime(getutcdate()),
								FailureAttempts = FailureAttempts + 1,
								PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
ReservationResults = '<ResourceManager_ReservationList><errorList failureCode="' + cast(20185 as varchar(20)) +
'" failureType="' + cast(2 as varchar(20)) + '"/></ResourceManager_ReservationList>',
								ShouldFailRequest = 0
						FROM	RMReservationRequest
						WHERE	RequestId = @RequestId
						DELETE #tmpRMReservationRequestSnap WHERE RequestId = @RequestId
						UPDATE 	ArchJobStreamStatus
SET		Status = 0x04 /* STREAM_READER_STATUS_FAILED */
						WHERE	jobId = @jobId
						AND		ReservationRequestId = @RequestId
						SET @exceededStreamLimitCount = @exceededStreamLimitCount + 1
						CONTINUE
					END
				END
			END
		END -- IF @l_skipStreamLimits = 0
		BEGIN TRANSACTION PROCESS_RESERVATION_TRANS
		/*
		-- DEBUG ONLY
		insert RMProcessHistory ( RequestId, JobId, CommCellId, JobType, ScheduleRunId, PhaseFirstAttemptTime,
						FailureAttempts, MaxNumOfAttempts, Priority, RequestCategory)
		select	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
  			@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory
		*/
IF @RequestCategory = 1
		BEGIN
			EXEC @ErrorCode = RMReserveForRestore @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
ELSE IF @RequestCategory = 2
		BEGIN
			EXEC @ErrorCode = RMReserveForBackup @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
ELSE IF @RequestCategory = 3
		BEGIN
			EXEC @ErrorCode = RMReserveForAuxCopy @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
ELSE IF @RequestCategory = 6
		BEGIN
			EXEC RMProcessOtherRequests @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
		END
ELSE IF @RequestCategory = 8
		BEGIN
			EXEC @ErrorCode = RMReserveForDashCopy @RequestId, @i_isDebug
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
			END
		END
		ELSE
		BEGIN
			-- Do nothing
UPDATE RMReservationRequest SET ErrorCode = 0 WHERE RequestId = @RequestId
UPDATE RMJobControl SET Status = 2 WHERE JobId = @JobId
		END
IF @ErrorCode <> 0
		BEGIN
			SET @isFatalError = 0
			SET @failedCount = @failedCount + 1
IF @ErrorCode != 0
			BEGIN
				EXEC RMIsFatalError @ErrorCode, @isFatalError OUTPUT
				IF @@ERROR > 0
				BEGIN
SET @ErrorCode = 415
					-- TODO: log the error information
				END
			END
			IF @isFatalError = 1
			BEGIN
				-- If there case, don't retry the job anymore
				UPDATE RMReservationRequest SET MaxNumOfAttempts = 1, ShouldFailRequest = 1 WHERE RequestId = @RequestId
				--UPDATE RMJobControl SET Status = RM_RESERVATION_REQUEST_INACTIVE WHERE JobId = @JobId
			END
			ELSE IF @isBlackListingEnabled = 1
				AND @l_archGroupId > 0
			BEGIN
IF EXISTS (SELECT 1 FROM RMReservationRequest WHERE RequestId = @RequestId AND FailureType = 1)
				BEGIN
					INSERT 	INTO @SPBlackListing
					VALUES (@l_archGroupId, @l_SIDBStoreId, @l_DataType, @RequestId)
				END
			END
		END
		ELSE -- @ErrorCode = E_MM_NOERROR
		BEGIN
			SET @successCount = @successCount + 1
			-- There is corner case that job is marked suspended or failed after reservation is done,
			-- we need to provide a way to clean it up
IF @RequestCategory IN (2, 3, 8)
			AND EXISTS (SELECT 1 FROM RMJobControl
									WHERE	JobId = @JobId AND CommcellId = @commCellId
AND		Status in (4, 5, 3))
			BEGIN
				ROLLBACK TRANSACTION PROCESS_RESERVATION_TRANS
				UPDATE RMJobControl
SET Status = 5
				WHERE 	JobId = @JobId AND CommcellId = @CommCellId
AND		Status = 4
				-- This is when the job failed.
				UPDATE	RMJobControl
SET			ErrorCode = ISNULL(a.ErrorCode, 0),
								FailureType = ISNULL(a.FailureType, 0),
FailureReason = CASE WHEN a.ErrorCode = 0 THEN ''
														WHEN RIGHT(a.ReservationResults, 1) != '>' THEN ''
														ELSE a.ReservationResults END,
								FailureAttempts = ISNULL(a.FailureAttempts, 0)
				FROM
								(
									SELECT	TOP 1 req.JobId as JobId, req.ErrorCode as ErrorCode ,
													req.FailureType as FailureType, req.ReservationResults as ReservationResults,
													req.FailureAttempts as FailureAttempts
									FROM		RMReservationRequest req
									WHERE		req.JobId = @JobId AND req.CommCellId = @CommCellId
									AND			req.ErrorCode > 0
									ORDER BY req.PhaseFirstAttemptTime
								)	a,
								RMJobControl b
				WHERE		b.JobId = @JobId AND b.CommcellId = @CommCellId
				AND			a.JobId = @JobId
				DELETE FROM RMReservationRequest
				WHERE JobId = @JobId AND CommCellId = @CommCellId
AND		RequestCategory != 0
				DELETE FROM #tmpRMReservationRequestSnap
				WHERE JobId = @JobId AND CommCellId = @CommCellId
AND		RequestCategory != 0
				CONTINUE
			END
		END
        IF(@HistoryDbExists = 1)
        BEGIN
            -- Add the resource allocation details to history db
            INSERT INTO HistoryDB..RMReservationRequestHistory (RequestId, ErrorCode, FailureType, JobId, AppId, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, ResourceReservationEndTime, RequestCategory, XmlParams, ReservationResults)
            --values (@RequestId,  @ErrorCode, FailureType, @JobId, AppId, @CommCellId, @JobType, @jobOpType, iDAType, @PhaseFirstAttemptTime, ResourceReservationEndTime, @RequestCategory, XmlParams, ReservationResults)
            SELECT RequestId, ErrorCode, FailureType, JobId, FailureType, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, dbo.GetUnixTime(getutcdate()), RequestCategory, XmlParams, ReservationResults
                FROM RMReservationRequest where requestId = @RequestId and jobId = @JobId and ErrorCode <> -1
        END
		COMMIT TRANSACTION PROCESS_RESERVATION_TRANS
		/*
		IF EXISTS (SELECT 1 FROM RMReservationRequest
					WHERE RequestId = @RequestId
					AND RequestTime < (select next_l from GXCounter where name = 'RM_Query_Counter')
					)
		BEGIN
			UPDATE  RMReservationRequest
			SET     RequestTime = dbo.GetUnixTime(getutcdate())
			WHERE   RequestId = @RequestId
		END
		*/
		DELETE #tmpRMReservationRequestSnap WHERE RequestId = @RequestId
		CONTINUE
	END
	INSERT INTO HistoryDB..RMPerformanceHistory
	SELECT @beginTime, GetUTCDate(), @totReqCount, @successCount, @failedCount, @blackListedCount, @exceededStreamLimitCount
	-- Release logical released resource at the end
	DELETE MMResource WHERE LogicalRelease = 1 AND ReservationId NOT IN (SELECT ReservationId FROM MMResourceToJob)
IF (@processStartTime + 2 * 60) < dbo.GetUnixTime(getutcdate())
		GOTO error_exit
	ELSE
	BEGIN
		GOTO RESERVATION_REATTEMPT
	END
error_exit:
	SELECT 0, 0, ''
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMProcessReservation')
	delete from GxQscripts where name = 'RMProcessReservation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessReservation')
	delete from GXDBVersions where aliasname = 'RMProcessReservation'
GO

insert into GXDBVersions values(2, 'RMProcessReservation',  'v1.21.2.44.8.3', 'RMProcessReservation', 'v1.21.2.44.8.3')
GO

