

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMProcessOtherRequests.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMProcessOtherRequests.sp,v $ $Id: RMProcessOtherRequests.sp,v 1.5.58.6 2019/05/22 14:37:24 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMProcessOtherRequests()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMProcessOtherRequests')
BEGIN
	print '>>> Drop Stored Procedure: RMProcessOtherRequests <<<'
	drop procedure RMProcessOtherRequests
END
IF EXISTS (select * from GxQscripts where name='RMProcessOtherRequests')
	delete from GxQscripts where name = 'RMProcessOtherRequests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessOtherRequests')
	delete from GXDBVersions where aliasname = 'RMProcessOtherRequests'
GO
print '... Creating Procedure: RMProcessOtherRequests'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMProcessOtherRequests
  @i_RequestId int,
  @i_isDebug int
AS
--:DECLARE o_ErrorCode			integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ErrorCode				integer
SET @ErrorCode = 0
	DECLARE @RequestId				integer
	DECLARE @JobId						integer
	DECLARE @CommCellId				integer
	DECLARE @JobType					integer
	DECLARE @ScheduleRunId		bigint
	DECLARE @PhaseFirstAttemptTime		integer
	DECLARE @FailureAttempts	integer
	DECLARE @MaxNumOfAttempts	integer
	DECLARE @Priority					integer
	DECLARE @RequestCategory	integer
	DECLARE @script						varchar(max)
	DECLARE @results					nvarchar(max)
	SET @results = ''
    DECLARE @HistoryDbExists integer = 0
	/*
    IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..RMReservationRequestHistory') IS NOT NULL)
        SET @HistoryDbExists = 1
	*/
		-- Cursor for geting reservation request list except release and exchangevol requests
	IF (CURSOR_STATUS('LOCAL', 'Request_Others_Cursor') >= -1)
	BEGIN
		CLOSE Request_Others_Cursor
		DEALLOCATE Request_Others_Cursor
	END
	DECLARE Request_Others_Cursor CURSOR FOR
	SELECT	RequestId, JobId, CommCellId, JobType, ScheduleRunId, PhaseFirstAttemptTime,
					FailureAttempts, MaxNumOfAttempts, Priority, RequestCategory, CAST(XmlParams as varchar(max))
	FROM		RMReservationRequest
WHERE		RequestCategory = 6
	AND			ErrorCode = -1
	AND			(@i_RequestId = 0 OR RequestId = @i_RequestId)
	ORDER BY Priority, RequestTime
  OPEN Request_Others_Cursor
  FETCH	NEXT FROM Request_Others_Cursor
  INTO	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
  			@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory, @script
	WHILE @@FETCH_STATUS = 0
	BEGIN
SET @ErrorCode = 0
		IF LEN(@script) = 0
		BEGIN
		  FETCH	NEXT FROM Request_Others_Cursor
				  INTO	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
					@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory, @script
			CONTINUE
		END
		BEGIN TRY
			BEGIN TRANSACTION OTHER_TRANS
			IF @JobId > 0
			BEGIN
				IF CHARINDEX('RMReserveAdditionalMediaOnHold', @script) > 0
				BEGIN
					SET @script = @script + ', ' + CAST(@RequestId as varchar(20))
				END
			END
			EXEC (@script)
			IF @@ERROR > 0
			BEGIN
SET @ErrorCode = 415
				-- TODO: log the error information
			END
			IF EXISTS (SELECT JobId FROM RMJobControl WHERE JobId = @JobId AND CommCellId = @CommCellId)
			BEGIN
					UPDATE	RMJobControl
SET			ErrorCode = 0,
Status = 6
					WHERE		JobId = @JobId AND CommCellId = @CommCellId
			END
			UPDATE RMReservationRequest
SET			ErrorCode = 0
			WHERE		RequestId = @RequestId
			if @i_isDebug > 0
			begin
				insert into RMLogger values ('RMProcessOtherRequests', 'Script: ''' + @script + ' '' run successfully.', @RequestId, getutcdate())
			end
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			IF @@TRANCOUNT > 0
				ROLLBACK TRANSACTION OTHER_TRANS
			SET @results = cast((SELECT
													    ERROR_NUMBER() AS ErrorNumber
													    ,ERROR_SEVERITY() AS ErrorSeverity
													    ,ERROR_STATE() AS ErrorState
													    ,ERROR_PROCEDURE() AS ErrorProcedure
													    ,ERROR_LINE() AS ErrorLine
													    ,ERROR_MESSAGE() AS ErrorMessage
													  FOR XML RAW('Error'), TYPE) as nvarchar(max))
			if @i_isDebug > 0
			begin
				insert into RMLogger values ('RMProcessOtherRequests', 'Script: ''' + @script + ' '' return error.', @RequestId, getutcdate())
				insert into RMLogger values ('RMProcessOtherRequests', @results, @RequestId, getutcdate())
			end
			IF EXISTS (SELECT JobId FROM RMJobControl WHERE JobId = @JobId AND CommCellId = @CommCellId)
			BEGIN
					UPDATE	RMJobControl
SET			ErrorCode = 415,
									FailureAttempts = 1,
Status = 6,
									FailureReason = @results
					WHERE		JobId = @JobId AND CommCellId = @CommCellId
			END
			UPDATE RMReservationRequest
SET			ErrorCode = 415,
							FailureAttempts = 1,
							ReservationResults = @results
			WHERE RequestId = @RequestId
		END CATCH
        IF(@HistoryDbExists = 1)
        BEGIN
            -- Add the resource allocation details to history db
            INSERT INTO HistoryDB..RMReservationRequestHistory (RequestId, ErrorCode, FailureType, JobId, AppId, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, ResourceReservationEndTime, RequestCategory, XmlParams, ReservationResults)
            --values (@RequestId,  @ErrorCode, FailureType, @JobId, AppId, @CommCellId, @JobType, @jobOpType, iDAType, @PhaseFirstAttemptTime, ResourceReservationEndTime, @RequestCategory, XmlParams, ReservationResults)
            SELECT RequestId, ErrorCode, FailureType, JobId, FailureType, CommCellId, JobType, JobOpType, iDAType, PhaseFirstAttemptTime, dbo.GetUnixTime(getutcdate()), RequestCategory, XmlParams, ReservationResults
                FROM RMReservationRequest where requestId = @RequestId and jobId = @JobId
        END
		IF @@TRANCOUNT > 0
			COMMIT TRANSACTION RESERVATION_TRANS
	  FETCH	NEXT FROM Request_Others_Cursor
	  INTO	@RequestId, @JobId, @CommCellId, @JobType, @ScheduleRunId, @PhaseFirstAttemptTime,
	  			@FailureAttempts, @MaxNumOfAttempts, @Priority, @RequestCategory, @script
	END
	CLOSE Request_Others_Cursor
	DEALLOCATE Request_Others_Cursor
error_exit:
RETURN 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMProcessOtherRequests')
	delete from GxQscripts where name = 'RMProcessOtherRequests'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMProcessOtherRequests')
	delete from GXDBVersions where aliasname = 'RMProcessOtherRequests'
GO

insert into GXDBVersions values(2, 'RMProcessOtherRequests',  '00010005005800060000', 'RMProcessOtherRequests', '00010005005800060000')
GO

