

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMMigrateMGAndGetActiveVolume.sp] ---------- 

--#include "ArMgr/ArMgrDefs.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMMigrateMGAndGetActiveVolume.sp,v $ $Id: RMMigrateMGAndGetActiveVolume.sp,v 1.8.52.11 2020/04/05 19:25:17 anarulkar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMMigrateMGAndGetActiveVolume()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMMigrateMGAndGetActiveVolume')
BEGIN
	print '>>> Drop Stored Procedure: RMMigrateMGAndGetActiveVolume <<<'
	drop procedure RMMigrateMGAndGetActiveVolume
END
IF EXISTS (select * from GxQscripts where name='RMMigrateMGAndGetActiveVolume')
	delete from GxQscripts where name = 'RMMigrateMGAndGetActiveVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMMigrateMGAndGetActiveVolume')
	delete from GXDBVersions where aliasname = 'RMMigrateMGAndGetActiveVolume'
GO
print '... Creating Procedure: RMMigrateMGAndGetActiveVolume'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMMigrateMGAndGetActiveVolume
  @i_RequestId integer,
  @i_JobId integer,
  @i_CopyId integer,
  @i_MediaGroupId integer,
  @i_CurrentDrivePoolId integer,
  @i_CurrentSpareGroupId integer,
  @i_CurrentDataPathId integer,
  @i_ScheduleRunId integer,
  @i_DoNotAllowOtherSchedule integer,
  @i_MarkActiveMediaFull integer,
  @i_SIDBStoreId integer,
  @i_IsForSILOBackup integer,
  @i_JobType integer,
  @i_AppNum integer,
  @i_currentSIDBStoreId integer,
  @i_isTransactionLogBackupPhase integer,
  @isDebug int,
  @o_MediaId integer OUTPUT,
  @o_VolumeId integer OUTPUT,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET XACT_ABORT ON
  declare @BKPJOB int
  declare @CSDRBKPJOB int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  set @BKPJOB = 1
  set @CSDRBKPJOB = 4
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
	declare @debugdetail varchar(max)
	set @debugdetail = ''
	set @o_MediaId = 0
	set @o_VolumeId = 0
set @o_ErrorCode = 0
set @o_FailureType = 2
	declare @currentActiveMedia table (retcode int, volumeid int, mediaid int, schedulerunid bigint)
	declare @curVolumeId			integer
	declare @curMediaId				integer
	set @curVolumeId = 0
	set @curMediaId = 0
  declare @curVolMarkFull		integer
  declare @curVolFullReason integer
  set @curVolMarkFull	= @i_MarkActiveMediaFull
set @curVolFullReason	= 42007
	declare @curMediaTypeId					integer
	declare @curRecordingFormatId		integer
	set @curMediaTypeId = 0
	set @curRecordingFormatId = 0
  declare @LogEvent integer
	-- Decide whether we should migrate media group
  if exists (select * from MMMediaGroup  with (readuncommitted) where MediaGroupId = @i_MediaGroupId
				and (	DrivePoolId != @i_CurrentDrivePoolId or
							SpareGroupId != @i_CurrentSpareGroupId or
							DataPathId = 0 or DataPathId != @i_CurrentDataPathId) )
  begin
		declare @driveTypeIds table (DriveTypeId int)
		insert into @driveTypeIds
		select distinct d.DriveTypeId
		from MMDrive as d with (readuncommitted), MMDrivePool as dp with (readuncommitted)
		where d.MasterPoolId = dp.MasterPoolId
		and dp.DrivePoolId = @i_CurrentDrivePoolId
		if @@ROWCOUNT > 1
		begin
set @o_ErrorCode = 20089
set @o_FailureType = 1
			goto ERROR_EXIT
		end
		select top 1 @curMediaTypeId = isnull(dt.DefaultMediaTypeId, 0),
								 @curRecordingFormatId = isnull(rfmt.RecordingFormatId, 0)
		from MMDriveType as dt with (readuncommitted), MMRecFmtMedTyp as rfmt with (readuncommitted), @driveTypeIds as d
		where dt.DriveTypeId = d.DriveTypeId
		and dt.DriveTypeId = rfmt.DriveTypeId
		order by rfmt.RecordingFormatId desc
		if @curRecordingFormatId is null or @curRecordingFormatId = 0
		begin
set @o_ErrorCode = 391
set @o_FailureType = 1
			goto ERROR_EXIT
		end
		-- Because both of SILO and non-SILO backup shared the same copy information be different set of data paths, there is no need to mark the volume full.
		-- Otherwise, a new volume will be created or allocated every time job switches between SILO and non-SILO.
		set @curVolMarkFull = 1
		if @i_SIDBStoreId > 0 or @i_IsForSILOBackup > 0
		begin
			-- If current job is single instance job
			if @i_SIDBStoreId > 0 and @i_IsForSILOBackup = 0
			begin
				-- If current data path from Media Group is SILO data path, don't mark the volume full
				if exists ( select a.DataPathId
										from MMDataPath a with (readuncommitted), MMMediaGroup b with (readuncommitted), archGroupCopy c with (readuncommitted)
										where MediaGroupId = @i_MediaGroupId
										and		b.DataPathId = a.DataPathId
										and		a.copyId = c.id
and		c.Flags & 524288 = 524288
									)
					set @curVolMarkFull = 0
			end
			-- If current job is SILO backup
			else if @i_IsForSILOBackup > 0
			begin
				-- If current data path from Media Group is non-SILO data path, don't mark the volume full
				if exists ( select a.DataPathId
										from MMDataPath a with (readuncommitted), MMMediaGroup b with (readuncommitted), archGroupCopy c with (readuncommitted)
										where MediaGroupId = @i_MediaGroupId
										and		b.DataPathId = a.DataPathId
										and		a.copyId = c.id
and		c.Flags & 524288 != 524288
									)
					set @curVolMarkFull = 0
			end
		end
		-- If spare group has been changed, mark the active media full.
		-- If both are using magnetic library, then mark the active media full when drive pool is changed.
		-- One exception is when the migration is between SILO data path and non-SILO data path.
		if @curVolMarkFull > 0
		and exists (	select * from MMMediaGroup with (readuncommitted)
									where MediaGroupId = @i_MediaGroupId
									and		(( SpareGroupId != @i_CurrentSpareGroupId )
													or
												 ( DrivePoolId != @i_CurrentDrivePoolId and SpareGroupId = 0 and @i_CurrentSpareGroupId = 0 )
												)
							)
		begin
			-- Get current Volume by Media Group
		  if @curVolumeId is null or @curVolumeId = 0
		  begin
		  	delete @currentActiveMedia
			  insert into @currentActiveMedia
			  exec MMS2GetCurrentVolForMG @i_MediaGroupId, @i_ScheduleRunId, @i_DoNotAllowOtherSchedule, 1, @i_JobId, @i_JobType
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO ERROR_EXIT
				END
			  if exists (select * from @currentActiveMedia where volumeid is not null and volumeid > 0)
			  begin
				  select top 1 @curVolumeId = isnull(volumeid, 0), @curMediaId = isnull(mediaid, 0) from @currentActiveMedia
					if @isDebug > 0
					begin
						set @debugDetail = cast(isnull((select @curVolumeId ActiveVolumeId, @i_MediaGroupId MediaGroupId, @i_ScheduleRunId scheduleRunId,
																						@i_DoNotAllowOtherSchedule doNotAllowOtherSchedule, @i_JobId JobId
															for XML RAW('MMS2GetCurrentVolForMG'), TYPE), 'No params for MMS2GetCurrentVolForMG') as nvarchar(max))
						insert into RMLogger values ('RMMigrateMGAndGetActiveVolume', @debugDetail, @i_RequestId, getutcdate())
					end
			  end
		  end
			if @curVolumeId is not null and @curVolumeId > 0
			begin
set @curVolFullReason	= 42026
				EXEC MMS2SetVolumeFull @curVolumeId, @LogEvent output, @curVolFullReason, @i_JobId, 0, 0
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO ERROR_EXIT
				END
UPDATE MMVolume SET Attributes = 1 WHERE VolumeId = @curVolumeId
				if @isDebug > 0
				begin
					set @debugDetail = cast(isnull((select @i_MediaGroupId MediaGroupId, @curVolumeId VolumeId, @curVolFullReason VolumeFullReason
														for XML RAW('MMS2SetVolumeFull'), TYPE), 'Not Mark Active Media Full') as nvarchar(max))
					insert into RMLogger values ('RMMigrateMGAndGetActiveVolume', @debugDetail, @i_RequestId, getutcdate())
				end
			end
			set @curVolumeId = 0
			set @curMediaId = 0
		end
		-- migrate media groups for all free streams
		update MMMediaGroup
		set	DrivePoolId = @i_CurrentDrivePoolId,
			SpareGroupId = @i_CurrentSpareGroupId,
			DataPathId = @i_CurrentDataPathId,
			DesiredMediaTypeId = @curMediaTypeId,
			RecordingFormatId = @curRecordingFormatId
		where MediaGroupId = @i_MediaGroupId
		if @isDebug > 0
		begin
			set @debugDetail = cast(isnull((select @i_MediaGroupId MediaGroupId, @i_CurrentDrivePoolId DrivePoolId,
																							@i_CurrentSpareGroupId SpareGroupId, @i_CurrentDataPathId DataPathId,
																							@curMediaTypeId MediaType, @curRecordingFormatId RecordingFormat
												for XML RAW('MigrateMediaGroup'), TYPE), 'Not Migrate Media Group') as nvarchar(max))
			insert into RMLogger values ('RMMigrateMGAndGetActiveVolume', @debugDetail, @i_RequestId, getutcdate())
		end
	end -- end of migrate media group
	set @curVolMarkFull	= @i_MarkActiveMediaFull
set @curVolFullReason	= 42007
	-- Get current Volume by Media Group
	if @curVolumeId is null or @curVolumeId = 0
	begin
		delete @currentActiveMedia
	  insert into @currentActiveMedia
	  exec MMS2GetCurrentVolForMG @i_MediaGroupId, @i_ScheduleRunId, @i_DoNotAllowOtherSchedule, 1, @i_JobId, @i_JobType
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO ERROR_EXIT
		END
	  if exists (select * from @currentActiveMedia where volumeid is not null and volumeid > 0)
	  begin
		  select top 1 @curVolumeId = isnull(volumeid, 0), @curMediaId = isnull(mediaid, 0) from @currentActiveMedia
			if @isDebug > 0
			begin
				set @debugDetail = cast(isnull((select @curVolumeId ActiveVolumeId, @i_MediaGroupId MediaGroupId, @i_ScheduleRunId scheduleRunId,
																				@i_DoNotAllowOtherSchedule doNotAllowOtherSchedule, @i_JobId JobId
													for XML RAW('MMS2GetCurrentVolForMG'), TYPE), 'No params for MMS2GetCurrentVolForMG') as nvarchar(max))
				insert into RMLogger values ('RMMigrateMGAndGetActiveVolume', @debugDetail, @i_RequestId, getutcdate())
			end
	  end
	end
	-- Whether we should mark the active volume full
	-- for DDB change mark vol as appendable
	DECLARE @l_volSIDBStoreId INT = 0
	IF @curVolumeId > 0
		SELECT @l_volSIDBStoreId = SIDBStoreId FROM MMVolume WITH(READUNCOMMITTED) WHERE VolumeId = @curVolumeId
	if @curVolumeId > 0 and @i_SIDBStoreId > 0 and @l_volSIDBStoreId > 0 and @l_volSIDBStoreId <> @i_SIDBStoreId
	begin
		set @curVolMarkFull = 1
set @curvolFullReason = 42047
	end
	-- for synthetic full job, do not use media that we need to read
	else if @curVolumeId > 0 and @i_JobType = @SYNTHFULLJOB
	and not exists (SELECT V.VolumeId FROM MMVolume as V WITH (READUNCOMMITTED)
									WHERE V.VolumeId = @curVolumeId
AND V.RecordingFormatId = 10001)
	begin
	  exec @curVolMarkFull = archMediaHasChunkForApp @i_AppNum, @curVolumeId, @i_JobId, 1
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO ERROR_EXIT
		END
	  -- output is hasChunk
	  if @curVolMarkFull > 0
	  begin
			set @curVolMarkFull = 1
set @curvolFullReason = 42014
	  end
	  else
	  begin
	  	set @curVolMarkFull = 0
		end
	end
	-- if volume returned has zero or different schedulerunid, and start new media is set, then mark the volume full
	else if @curVolumeId > 0 and @curVolMarkFull = 1 and
					not exists (select * from @currentActiveMedia where schedulerunid = @i_ScheduleRunId)
	begin
		set @curVolMarkFull = 1
set @curVolFullReason = 42028
	end
  -- If the round robin for Mountpath is selected, still mark the volume full even markActiveMediaFull set to false
  else if @curVolumeId > 0 and @curVolMarkFull = 0 and
  				exists (select a.LibraryId from MMLibrary a with (readuncommitted), MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted)
  								where dp.DrivePoolId = @i_CurrentDrivePoolId
  								and		dp.MasterPoolId = mp.MasterPoolId
  								and		a.LibraryId = mp.LibraryId
and		a.LibraryTypeId = 3
and		(a.ExtendedAttributes & 1) > 0)
  begin
  	set @curVolMarkFull = 1
set @curVolFullReason = 42025
	end
	else if @curVolumeId > 0 and @curMediaId > 0 and
		(
 			exists (select a.LibraryId from MMLibrary a with (readuncommitted), MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted)
  					where dp.DrivePoolId = @i_CurrentDrivePoolId
  					and		dp.MasterPoolId = mp.MasterPoolId
  					and		a.LibraryId = mp.LibraryId
and		a.LibraryTypeId in (4, 5))
			OR
exists (select 1 from MMMedia with (NOLOCK) where MediaId = @curMediaId and MediaTypeId IN (11002))
		)
	begin
		if not exists (select driveId from MMDrive with (NOLOCK) where mediaId = @curMediaId)
		begin
			set @curVolMarkFull = 1
set @curVolFullReason = 42017
		end
	end
	-- For all other conditions, don't set volume full
  else
  begin
  	set @curVolMarkFull = 0
	end
	-- This following check should be done for single instance backups.
	-- For SI backup, the SIDB Id on active volume can be different from the SIDB ID on copy.
	-- In such case, the current active volume need to be marked full.
	-- We don't do such check for SILO backup (tape media).
	if @curVolumeId > 0 and @curVolMarkFull = 0
	and	@i_SIDBStoreId > 0 and @i_IsForSILOBackup = 0
	begin
		if exists (select VolumeId from MMVolume with (readuncommitted) where VolumeId = @curVolumeId and SIDBStoreId <> @i_SIDBStoreId)
		begin
			set @curVolMarkFull = 1
set @curVolFullReason = 42038
		end
	end
	-- The following check should be done for SILO job.
	-- When the given SIDBStore Id is different from current one on the tape,
	-- and the option is set to prevent different SIDB Store goes to the same media,
	-- then make the media full
	if @curVolumeId > 0 and @curVolMarkFull = 0
	and @i_IsForSILOBackup > 0
	and @i_currentSIDBStoreId > 0
	and 0 = isnull((select top 1 value from MMConfigs  with (readuncommitted) where name = 'MMS2_CONFIG_ALLOW_MEDIA_CONTAIN_DIFF_SIDB_STORE_IN_SILO'), 0)
	begin
		if exists (select volume.SIDBStoreId from
								(
									select distinct siloVolume.siloVolumeId
									from
									(
										select	distinct a.VolumeId, mapping.archFileId, mapping.commCellId
										from
										(
											select chunk.id, chunk.commCellId, chunk.volumeId
											from archChunk chunk with (readuncommitted)
											where chunk.volumeId = @curVolumeId
										) a
										left join archChunkMapping mapping with (readuncommitted)
										on a.id = mapping.archChunkId and a.commCellId = mapping.chunkCommCellId
									) b
									inner join archFileSiloVolume siloVolume with (readuncommitted)
									on b.archFileId = siloVolume.archFileId and b.commCellId = siloVolume.commCellId
								) c
								left join MMVolume volume with (readuncommitted)
								on c.siloVolumeId = volume.volumeId
								where volume.VolumeId > 0
								and volume.SIDBStoreId > 0
								and volume.SIDBStoreId != @i_currentSIDBStoreId
							)
		begin
			set @curVolMarkFull = 1
set @curVolFullReason = 42038
		end
	end
	-- Check the cache mount path properties only when backup is runnig in dedup mode
	IF @curVolumeId > 0 and @curVolMarkFull = 0
	AND @i_CopyId > 0 and @i_SIDBStoreId > 0
	--dedupe is not disabled on subclient
	AND (@i_appNum = 0 OR NOT EXISTS ( select 1 from APP_SubClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
													where app.Id = @i_appNum and app.Id = prop.ComponentNameId and prop.cs_attrName = CheckSum(N'Single Instancing Option')
													and prop.attrName = N'Single Instancing Option' and prop.attrVal = '0' and prop.Modified = 0)
			)
	--dedupe is not disabled on copy
AND NOT EXISTS (select 1 from archGroupCopy with (readuncommitted) where id = @i_CopyId and (dedupeFlags & 1048576) > 0)
	--allow dedupe jobs when DDB in maintenance config param is not set
	AND NOT EXISTS (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION' and value = 1)
	--not transactional log backup
	AND @i_isTransactionLogBackupPhase = 0
	BEGIN
		IF EXISTS (SELECT 1 FROM MMCloudVolCacheMountPath WITH (READUNCOMMITTED) WHERE VolumeId = @curVolumeId)
		BEGIN
			-- Make sure the cache mount path is usable
			DECLARE @cacheMPId	INT = 0
			DECLARE @cacheMediaId INT = 0
			DECLARE @cacheErrorCode INT = 0
			DECLARE @curClientId INT = 0
			SELECT @cacheMPId = cacheMountPathId
			FROM MMCloudVolCacheMountPath WITH (READUNCOMMITTED)
			WHERE VolumeId = @curVolumeId
			SELECT @cacheMediaId = ms.MediaId
			FROM MMMountPath mp WITH (READUNCOMMITTED), MMMediaSide ms WITH (READUNCOMMITTED)
			WHERE mp.MountPathId = @cacheMPId AND mp.MediaSideId = ms.MediaSideId
			SELECT @curClientId = ClientId FROM MMDrivePool WITH (READUNCOMMITTED) WHERE DrivePoolId = @i_CurrentDrivePoolId
			IF NOT EXISTS (
								SELECT MP.MountPathId
								FROM    MMMountPath MP WITH (READUNCOMMITTED), MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED),
										MMDevice DV WITH (READUNCOMMITTED), MMDeviceController DC WITH (READUNCOMMITTED), MMHost H WITH (READUNCOMMITTED), MMLibrary LIB WITH (READUNCOMMITTED)
								WHERE   MP.MountPathId = @cacheMPId
								AND			H.ClientId = @curClientId
								AND			MP.MountPathId = MSD.MountPathId
								AND			MSD.DeviceId = DV.DeviceId
								AND			MSD.DeviceId = DC.DeviceId
								AND			DC.ClientId = H.ClientId
								AND			MP.LibraryId = LIB.LibraryId
								AND			MP.IsEnabled = 1
								AND			MP.IsOffline = 0
								AND			H.MmHostEnabled = 1
								AND			H.MmHostSoftState = 1
								AND			DC.DeviceAccessible = 1
								AND			DC.DeviceControllerEnabled = 1
								AND			MP.MaxConcurrentWriters > 0
AND			(DC.DeviceAccessType & 2 > 0)
								AND			LIB.LibrarySoftState >0 AND LIB.LibraryEnabled >0 AND LIB.LibraryBroken = 0
								AND			DV.DeviceBroken = 0 AND DV.DeviceEnabled = 1
							)
			OR EXISTS (SELECT 1 FROM MMMedia WITH (READCOMMITTED) WHERE MediaId = @cacheMediaId AND MediaFlags = 4)
			BEGIN
				set @curVolMarkFull = 1
set @curVolFullReason = 42048
			END
			IF @curVolMarkFull = 0
			BEGIN
				SET @cacheErrorCode = dbo.MMS2FUNC_IsMountPathHasSpaceRequired(@cacheMpId, @cacheMediaId)
				IF  @cacheErrorCode <> 0
				BEGIN
					set @curVolMarkFull = 1
set @curVolFullReason = 42049
				END
			END
		END
	END
	-- Mark active volume full
	if @curVolumeId > 0 and @curVolMarkFull > 0
	begin
		-- mark media full
		EXEC MMS2SetVolumeFull @curVolumeId, @LogEvent output, @curVolFullReason, @i_JobId, 0, 0
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO ERROR_EXIT
		END
UPDATE MMVolume SET Attributes = 1 WHERE VolumeId = @curVolumeId
		if @isDebug > 0
		begin
			set @debugDetail = cast(isnull((select @i_MediaGroupId MediaGroupId, @curVolumeId VolumeId, @curVolFullReason VolumeFullReason
												for XML RAW('MMS2SetVolumeFull'), TYPE), 'Not Mark Active Media Full') as nvarchar(max))
			insert into RMLogger values ('RMMigrateMGAndGetActiveVolume', @debugDetail, @i_RequestId, getutcdate())
		end
		set @curVolumeId = 0
		set @curMediaId = 0
	end
	set @o_MediaId = @curMediaId
	set @o_VolumeId = @curVolumeId
ERROR_EXIT:
	RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMMigrateMGAndGetActiveVolume')
	delete from GxQscripts where name = 'RMMigrateMGAndGetActiveVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMMigrateMGAndGetActiveVolume')
	delete from GXDBVersions where aliasname = 'RMMigrateMGAndGetActiveVolume'
GO

insert into GXDBVersions values(2, 'RMMigrateMGAndGetActiveVolume',  '00010008005200110000', 'RMMigrateMGAndGetActiveVolume', '00010008005200110000')
GO

