

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMIsVolumeReservable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMIsVolumeReservable.sp,v $ $Id: RMIsVolumeReservable.sp,v 1.8.276.7 2018/03/20 00:00:34 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMIsVolumeReservable <<<'

IF EXISTS (select * from sysobjects where name='RMIsVolumeReservable')
	drop procedure RMIsVolumeReservable
IF EXISTS (select * from GxQscripts where name='RMIsVolumeReservable')
	delete from GxQscripts where name = 'RMIsVolumeReservable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMIsVolumeReservable')
	delete from GXDBVersions where aliasname = 'RMIsVolumeReservable'
GO
print '... Creating Procedure: RMIsVolumeReservable'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMIsVolumeReservable
  @i_RequestId integer,
  @i_JobId integer,
  @i_VolumeId integer,
  @i_MediaGroupId integer,
  @i_DrivePoolId integer,
  @i_MasterPoolId integer,
  @i_ClientId integer,
  @i_LibraryId integer,
  @i_ReservationType integer,
  @i_CheckForOppositeSide integer,
  @isDebug integer,
  @o_IsReservable integer OUTPUT,
  @o_ErrorCode integer OUTPUT
AS
SET @o_ErrorCode = 0
	SET @o_IsReservable = 1
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	DECLARE @mediaGroupId int
	DECLARE @drivePoolId int
	DECLARE @masterPoolId int
	DECLARE @libraryId int
	DECLARE @libraryTypeId int
	DECLARE @barcodeReaderPresent int
	DECLARE @libraryAttribute int
	DECLARE @mediaId int
	DECLARE @mediaAttributes int
	SET @mediaGroupId = @i_MediaGroupId
	SET	@drivePoolId = @i_DrivePoolId
	SET @masterPoolId = @i_MasterPoolId
	SET @libraryId = @i_LibraryId
	SET @libraryTypeId = 0
	SET @barcodeReaderPresent = 0
	SET @libraryAttribute = 0
	SET @mediaId = 0
	SET @mediaAttributes = 0
	DECLARE @jobType integer = 0
	if	@i_JobId > 0
		set @jobType= dbo.GetJobTypeForJobID(@i_JobId)
	DECLARE @ARCHIVECHECK	int = 31
	DECLARE @isPowerVMFeatureEnabled INT
	SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
	IF @i_VolumeId <= 0
	BEGIN
		SET @o_IsReservable = 1
		GOTO EXIT_AND_RETURN
	END
	-- If the volume is reserved by other job, return false
	ELSE IF (EXISTS (SELECT * FROM MMResource WHERE VolumeId = @i_VolumeId)
						AND NOT EXISTS (SELECT * FROM MMResource
														WHERE VolumeId = @i_VolumeId AND HasJobInterrupted = 1
														AND		ReservationId IN (SELECT ReservationId FROM MMResourceToJob WHERE JobId_l = @i_JobId)))
	BEGIN
SET @o_ErrorCode = 803
		SET @o_IsReservable = 0
		GOTO EXIT_AND_RETURN
	END
	ELSE
	BEGIN
		SELECT @mediaId = v.MediaId,
					@mediaAttributes = m.Attributes,
					@mediaGroupId = v.MediaGroupId
		FROM MMVolume v with (readuncommitted), MMMedia m with (readuncommitted)
		WHERE v.VolumeId = @i_VolumeId AND v.MediaId = m.MediaId
		IF @i_MediaGroupId > 0 AND @i_MediaGroupId <> @mediaGroupId
			SET @mediaGroupId = @i_MediaGroupId
		ELSE
			SET @i_MediaGroupId = @mediaGroupId
	END
	IF @i_MediaGroupId > 0
	BEGIN
		-- select Drive pool id for write reservation, media group should points to corret drive pool
		SELECT	@drivePoolId = DrivePoolId
		FROM		MMMediaGroup WITH (READUNCOMMITTED)
		WHERE		MediaGroupId = @i_MediaGroupId
		-- have passing  drive pool id, it might be exhange volume (write). Consider the passing-in drive poolid
		IF @i_DrivePoolId > 0  AND @i_DrivePoolId <> @drivePoolId
			SET @drivePoolId = @i_DrivePoolId
		ELSE
			SET @i_DrivePoolId = @drivePoolId
	END
	IF @i_DrivePoolId > 0
	BEGIN
		-- select master pool id
		SELECT TOP 1 @masterPoolId = MasterPoolId
		FROM		MMDrivePool WITH (READUNCOMMITTED)
		WHERE		DrivePoolId = @i_DrivePoolId
		IF @i_MasterPoolId > 0 AND @i_MasterPoolId <> @masterPoolId
			SET @masterPoolId = @i_MasterPoolId
		ELSE
			SET @i_MasterPoolId = @masterPoolId
	END
	IF @i_MasterPoolId > 0
	BEGIN
		-- select library
		SELECT @libraryId = LibraryId
		FROM		MMMasterPool WITH (READUNCOMMITTED)
		WHERE		MasterPoolId = @i_MasterPoolId
		-- If there is passing library id, it might be exchange reseve volume (read).
		IF @i_LibraryId > 0 AND @i_LibraryId <> @libraryId
			SET @libraryId = @i_LibraryId
		ELSE
			SET @i_LibraryId = @libraryId
	END
	IF @i_LibraryId > 0
	BEGIN
		SELECT	@libraryTypeId = LibraryTypeId,
						@barcodeReaderPresent = BarcodeReaderPresent,
						@libraryAttribute = LibraryAttribute
		FROM	MMLibrary with (readuncommitted)
		WHERE	LibraryId = @i_LibraryId
	END
	-- Check Mount Path Status, if the volume is magnetic volume
	-- This has been done already when checking the mount path.
IF @libraryTypeId = 3
	BEGIN
SELECT @o_ErrorCode = CASE WHEN mp.IsEnabled = 0 THEN 395
ELSE 312 END
		FROM MMMountPath mp with (readuncommitted), MMVolume v with (readuncommitted)
		WHERE mp.MediaSideId = v.MediaSideId
		AND		(mp.IsEnabled = 0 OR (mp.IsOffline = 1 AND (@jobType <> @ARCHIVECHECK OR mp.OfflineReason <> 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/)))
		AND		v.VolumeId = @i_VolumeId
		AND NOT EXISTS (
							SELECT 1 FROM MMMountPath MP1, MMMountPathToStorageDevice MS, MMDeviceController DC, MMHost H
								  WHERE MP1.MountPathId = MP.MountPathId AND
								  MP1.MountPathId = MS.MountPathId AND
								  MS.DeviceId = DC.DeviceId AND
								  DC.ClientId = H.ClientId AND
								  H.MmHostEnabled = 1 AND
H.Attribute & 32768 > 0 AND
								  H.MmHostSoftState = 0 AND
								  H.OfflineReason = 7 /*HOST_STATUS_POWER_MANAGED_VM*/ AND
								  MP1.IsEnabled = 1 AND
								  MP1.IsOffline = 1 AND (@jobType <> @ARCHIVECHECK OR mp.OfflineReason <> 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/) AND
								  MP1.OfflineReason = 1 /*MOUNTPATH_NOT_ACCESIBLE*/ AND @isPowerVMFeatureEnabled > 0
						)
IF @o_ErrorCode != 0
		BEGIN
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
	END
	-- Check the slot status for regular library
IF @libraryTypeId = 1 OR @libraryTypeId = 2
	BEGIN
		DECLARE @slotType int
		DECLARE @InventoryStatus int
		DECLARE @MediaStatus int
		SELECT @slotType = SlotType, @InventoryStatus = InventoryStatus, @MediaStatus = MediaStatus
		FROM MMSlot with (readuncommitted) WHERE MediaId = @mediaId
		IF @slotType IS NOT NULL AND @slotType > 0
		BEGIN
			IF @SlotType != 1 /*REGULAR_SLOT = 1*/
			BEGIN
SET @o_ErrorCode = 329
				SET @o_IsReservable = 0
				GOTO EXIT_AND_RETURN
			END
			IF @barcodeReaderPresent = 0 AND @InventoryStatus = 1 /*MM_INVENTORY_IN_PROGRESS*/
			BEGIN
SET @o_ErrorCode = 432
				SET @o_IsReservable = 0
				GOTO EXIT_AND_RETURN
			END
IF (@MediaStatus != 0 AND @MediaStatus != 4)
			BEGIN
SET @o_ErrorCode = 307
				SET @o_IsReservable = 0
				GOTO EXIT_AND_RETURN
			END
		END
IF 1 != @i_ReservationType
AND (1 & @mediaAttributes) > 0
AND (32768 & @libraryAttribute) = 0
		BEGIN
SET @o_ErrorCode = 20008
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
	END
	-- Check opposite side of the volume
IF @libraryTypeId != 3 AND @i_checkForOppositeSide > 0
	BEGIN
		-- If the opposite side is reserved
		IF EXISTS (SELECT * FROM MMResource
								WHERE VolumeId IN (SELECT VolumeId FROM MMVolume with (readuncommitted)
																		WHERE MediaId = @mediaId AND VolumeId != @i_VolumeId))
		BEGIN
SET @o_ErrorCode = 284
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
	END
	DECLARE @volumeState int
	SELECT @volumeState = VolumeState FROM MMVolume with (readuncommitted) WHERE VolumeId = @i_VolumeId
	IF @volumeState IS NOT NULL
	BEGIN
		IF @volumeState = 2 /*VOLUME_STUCK*/
		BEGIN
SET @o_ErrorCode = 819
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
		IF @volumeState = 6 /*VOL_RECYCLE*/
		BEGIN
SET @o_ErrorCode = 821
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
	END
	IF EXISTS (SELECT * FROM MMMedia with (readuncommitted) WHERE MediaId = @mediaId AND (MediaLocation = 3 /* LOCATION_SHELF*/ OR libraryId != @libraryId))
	BEGIN
IF @libraryTypeId = 1 OR @libraryTypeId = 2 OR @libraryTypeId = 3
		BEGIN
SET @o_ErrorCode = 273
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
ELSE IF @libraryTypeId != 4 AND @libraryTypeId != 5
		BEGIN
SET @o_ErrorCode = 265
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
	END
	IF EXISTS (SELECT MediaId FROM MMMedia with (readuncommitted) WHERE MediaId = @mediaId AND MediaLocation = 2 /* LOCATION_DRIVE*/)
	BEGIN
		DECLARE @driveId INTEGER
		SET @driveId = 0
		SELECT @driveId = DriveId FROM MMDrive with (readuncommitted) WHERE MediaId = @mediaId
		IF @driveId = 0
			GOTO EXIT_AND_RETURN
IF EXISTS (SELECT DriveId FROM MMDrive with (readuncommitted) WHERE DriveId = @driveId AND MountStatus IN (2, 3, 4))
		BEGIN
SET @o_ErrorCode = 20001
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
		IF NOT EXISTS (SELECT DriveId FROM MMDrive with (readuncommitted) WHERE DriveId = @driveId AND DriveSoftState = 1 AND DriveEnabled = 1 AND DriveBroken = 0)
		BEGIN
SET @o_ErrorCode = 20002
			SET @o_IsReservable = 0
			GOTO EXIT_AND_RETURN
		END
IF @libraryTypeId != 3
		BEGIN
			DECLARE @driveSoftState int = 0
			DECLARE @driveEnabled int = 0
			DECLARE @driveAccessible int = 0
			DECLARE @rowCount int = 0
			SELECT 	@driveSoftState = DriveControllerSoftState,
					@driveEnabled = DriveControllerEnabled,
					@driveAccessible = DriveAccessible
			FROM 	MMDriveController with (readuncommitted)
			WHERE 	DriveId = @driveId AND DrivePoolId = @drivePoolId
			SET @rowCount = @@ROWCOUNT
			--If drive is not shared with MA and config param is set then don't fail
			--We will reserve a drive to which MA has access and media will get unmounted and mounted back into selected drive
			IF 	(
					@rowCount = 0
					AND
					(
						NOT EXISTS(SELECT 1 FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'RM_CONFIG_SKIP_DRIVE_ACCESSIBLE_CHECK' AND value = 1)
						OR NOT EXISTS (SELECT 1 FROM MMDriveController with (readuncommitted)
										WHERE DriveId = @driveId
										AND	DriveControllerSoftState = 1
										AND	DriveControllerEnabled = 1
										AND	DriveAccessible = 1
										) --There should be at least one drive controller to unmount the media
					)
				)
				OR
				(
					@rowCount > 0
					AND
					(
						@driveSoftState <> 1
						OR @driveEnabled <> 1
						OR @driveAccessible <> 1
					)
				)
			BEGIN
SET @o_ErrorCode = 20038
				SET @o_IsReservable = 0
				GOTO EXIT_AND_RETURN
			END
		END
	END
EXIT_AND_RETURN:
GO

IF EXISTS (select * from GxQscripts where name = 'RMIsVolumeReservable')
	delete from GxQscripts where name = 'RMIsVolumeReservable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMIsVolumeReservable')
	delete from GXDBVersions where aliasname = 'RMIsVolumeReservable'
GO

insert into GXDBVersions values(2, 'RMIsVolumeReservable',  '00010008027600070000', 'RMIsVolumeReservable', '00010008027600070000')
GO

