

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMIsBackupCachingUsedByJobId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMIsBackupCachingUsedByJobId.sp,v $ $Id: RMIsBackupCachingUsedByJobId.sp,v 1.2.88.2 2018/03/20 00:03:58 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMIsBackupCachingUsedByJobId()
--  +========================================================================+
--
--
--	This is stored procedure used for reserving cached resource.
--	Reservation caching is to make sure jobs from certain application can use dedicated resoruces for long period of time.
--	When scheduling jobs from one application for very short time period (for example every 15 minitues), the resource used by previous jobs will be put
--  into reservation cache and following jobs can continue using them without going through whole reservation process.
--
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMIsBackupCachingUsedByJobId <<<'

IF EXISTS (select * from sysobjects where name='RMIsBackupCachingUsedByJobId')
	drop procedure RMIsBackupCachingUsedByJobId
IF EXISTS (select * from GxQscripts where name='RMIsBackupCachingUsedByJobId')
	delete from GxQscripts where name = 'RMIsBackupCachingUsedByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMIsBackupCachingUsedByJobId')
	delete from GXDBVersions where aliasname = 'RMIsBackupCachingUsedByJobId'
GO
print '... Creating Procedure: RMIsBackupCachingUsedByJobId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMIsBackupCachingUsedByJobId
  @i_jobid int,
  @i_archGroupId int,
  @i_returnResult int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT,
  @o_IsBackupCachingUsed integer OUTPUT
AS
  DECLARE @output_ErrorCode integer;
  DECLARE @output_FailureType integer;
  DECLARE @output_IsBackupCachingUsed integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_FailureType = 2
set @o_IsBackupCachingUsed = 0
declare @reservationid		integer
declare @rcid 				integer
declare @archGroupCopyId 	integer
set @reservationId = 0
set @rcid = 0
set @archGroupCopyId = 0
if @i_archGroupId is not null and @i_archGroupId > 0
begin
	-- Get the caching reserve candidates by job id
	select top 1 @reservationid = isnull(res.reservationid, 0), @rcid = isnull(restojob.rcid, 0), @archGroupCopyId = isnull(res.CopyId, 0)
	from	mmresource res with (readuncommitted), mmresourcetojob restojob with (readuncommitted)
	where	restojob.jobId_l = @i_jobId
	and		restojob.ReservationType = 2 /* write */
	and		restojob.ReservationId = res.ReservationId
	and		res.CopyId in (select DefaultCopy from ArchGroup with (readuncommitted) where Id = @i_archGroupId)
end
else
begin
	-- Get the caching reserve candidates by job id
	select top 1 @reservationid = isnull(res.reservationid, 0), @rcid = isnull(restojob.rcid, 0), @archGroupCopyId = isnull(res.CopyId, 0)
	from	mmresource res with (readuncommitted), mmresourcetojob restojob with (readuncommitted)
	where	restojob.jobId_l = @i_jobId
	and		restojob.ReservationType = 2 /* write */
	and		restojob.ReservationId = res.ReservationId
end
if @archGroupCopyId > 0 and @i_archGroupId = 0
begin
	select @i_archGroupId = sp.Id
	from ArchGroup sp with (readuncommitted), ArchGroupCopy copy with (readuncommitted)
	where	copy.Id = @archGroupCopyId
	and		copy.archGroupId = sp.Id
end
-- There is no reservation exists for current job
if @i_archGroupId = 0
begin
	select @i_archGroupId = currentPolicy from JMBkpJobInfo with (readuncommitted) where jobId = @i_jobid
end
declare @jobOpType int
set @jobOpType = dbo.GetJobTypeForJobID(@i_jobid)
if exists (select Id from ArchGroup with (readuncommitted) where Id = @i_archGroupId
and	   Flags & 1048576 /*CVA_SP_ALLOW_BACKUP_CACHE_RESERVE_FLAG*/ > 0)
and
@jobOpType in (4 /*BACKUP*/, 14 /*SYNTHFULL*/, 18 /*BACKUP3RD*/)
begin
	set @o_IsBackupCachingUsed = 1
end
else
begin
	set @o_IsBackupCachingUsed = 0
end
exit_done:
  IF (@i_returnResult > 0)
	SELECT 0, 0, @o_IsBackupCachingUsed
  RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMIsBackupCachingUsedByJobId')
	delete from GxQscripts where name = 'RMIsBackupCachingUsedByJobId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMIsBackupCachingUsedByJobId')
	delete from GXDBVersions where aliasname = 'RMIsBackupCachingUsedByJobId'
GO

insert into GXDBVersions values(2, 'RMIsBackupCachingUsedByJobId',  '00010002008800020000', 'RMIsBackupCachingUsedByJobId', '00010002008800020000')
GO

