

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMHandleInterrupt.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMHandleInterrupt.sp,v $ $Id: RMHandleInterrupt.sp,v 1.25.44.10 2020/10/30 00:27:06 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMHandleInterrupt()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMHandleInterrupt')
BEGIN
	print '>>> Drop Stored Procedure: RMHandleInterrupt <<<'
	drop procedure RMHandleInterrupt
END
IF EXISTS (select * from GxQscripts where name='RMHandleInterrupt')
	delete from GxQscripts where name = 'RMHandleInterrupt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMHandleInterrupt')
	delete from GXDBVersions where aliasname = 'RMHandleInterrupt'
GO
print '... Creating Procedure: RMHandleInterrupt'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMHandleInterrupt
  @i_RequestId int,
  @i_JobId bigint,
  @i_Priority int,
  @i_InterruptFor int,
  @i_numMinResourceRequired int,
  @i_ReservationType int,
  @i_PhaseFirstAttemptTime bigint,
  @i_interruptInterval int,
  @i_PreEmptable int,
  @i_CopyId int,
  @i_DataPathId int,
  @i_maxMXCount int,
  @i_MediaId int,
  @i_VolumeId int,
  @i_MasterPoolId int,
  @i_DrivePoolId int,
  @i_DriveId int,
  @i_DataPathFailureCode int,
  @isDebug int,
--:OUTPUT o_InterruptedJobList XML
--,
  @o_ErrorCode integer OUTPUT
AS
  DECLARE @o_NumIntrResources int
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @BKP 						int
	declare @RST 						int
	declare @CSDRBKP 				int
	declare @INDEXRESTORE		int
	declare @AUXCOPY 				int
	declare @SYNTHFULL 			int
	declare @SYSSTATEBACKUP	int
	declare @MEDIAREFRESHING		int
	declare @DASHCOPY			int
	set @BKP 								= 4
	set @RST	 							= 5
	set @CSDRBKP 						= 11
	set @INDEXRESTORE 			= 12
	set @AUXCOPY 						= 13
	set @SYNTHFULL 					= 14
	set @SYSSTATEBACKUP			= 30
	set @MEDIAREFRESHING		= 74
	set @DASHCOPY				= 104
	set @o_NumIntrResources = 0
	declare @JobOpType int
	set @jobOpType = dbo.GetJobTypeForJobID(@i_JobId)
	--Interruption is supported only for restore, backup and auxcopy
	if @jobOpType not in (@RST, @INDEXRESTORE, @BKP, @CSDRBKP, @SYSSTATEBACKUP, @SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
	begin
		goto error_exit
	end
	declare @BackupInterruptBackup int
	declare @OtherInterruptAuxCopy int
	declare @RestoreInterruptOther int
	declare @AuxCopyInterruptAuxCopy int
	set @BackupInterruptBackup	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMBackupInterruptBackup' and value like '1') then 1 else 0 end
	set @OtherInterruptAuxCopy	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMOtherJobsInterruptAuxCopy' and value like '1') then 1 else 0 end
	set @RestoreInterruptOther	= case when exists (select value from GXGlobalParam WITH (READUNCOMMITTED) where name = 'RMRestoreInterruptOtherJobs' and value like '1') then 1 else 0 end
	set @AuxCopyInterruptAuxCopy	= case when exists (select value from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_AUX_COPY_PREEMPT_WITH_ANOTHER_AUX_COPY' and value = 1) then 1 else 0 end
	--
	--Nothing to do if interruption is not enabled
	--
	if
	(
		@jobOpType IN (@BKP, @CSDRBKP, @SYSSTATEBACKUP)
		AND @BackupInterruptBackup = 0
		AND @OtherInterruptAuxCopy = 0
	)
	OR
	(
		@jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		AND @AuxCopyInterruptAuxCopy = 0
	)
	OR
	(
		@jobOpType IN (@RST, @INDEXRESTORE)
		AND @RestoreInterruptOther = 0
	)
	begin
		goto error_exit
	end
	declare @rmIntrId table (id int)
	declare @JobIdToInterrupt int
	declare @StreamId int
	declare @curResId int
	declare @intrResId int
	declare @curRCId int
	if @i_Priority <= 0
	begin
select @i_Priority = combPriority from JMJobInfo with (readuncommitted) where JobId = @i_JobId and commCellId = 2
	end
if @i_InterruptFor = 8
	begin
		if @i_CopyId <= 0 or
		(@i_DataPathId > 0 and
			not exists (select * from RMDataPathView where DataPathId = @i_DataPathId))
		begin
			set @o_NumIntrResources = 0
			goto error_exit
		end
	  -----------------------------------------------------------------------------------------------------
	  -- Figure out if interruptible Streams number for all the DataPath if there is no give DataPath id --
	  -----------------------------------------------------------------------------------------------------
	  -- 1. Get interruptible reservation list for the specified copy having priority less than the passed in priority
	  -- 2. Stream Id should greater than 0. (Filter out the read reservations)
	  -- 3. All the reservation types for this stream should match the passing-in reservation type
	  -- 4. All the existing jobs need to be interruptible by current job.
	  -- 5. The stream should reach the max multiplexing factor. Otherwise, it should returned as the multiplable streams.
		declare @interruptibleStreams table
		(
				DrivePoolId			int,
				ClientId				int,
				LibraryId				int,
				SpareGroupId		int,
				StreamId				int,
				ReservationId		int,
				RCID				int,
				JobId				int,
				JobType				int
		)
		insert	into @interruptibleStreams
		select	distinct res.DrivePoolId, res.ClientId, res.LibraryId, res.SpareGroupId, res.StreamId, res.ReservationId, resToJob.RCID, resToJob.JobId_l, 0
		from		RMDataPathView dp, MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where		dp.FailureErrorCode = 0
		and			(@i_DataPathId = 0 or dp.DataPathId = @i_DataPathId)
		and			res.DrivePoolId = dp.DrivePoolId
		and			res.ClientId = dp.HostClientId
		and			res.LibraryId = dp.LibraryId
		and			res.SpareGroupId = dp.SpareGroupId
		and			res.CopyId = @i_CopyId
		and			res.StreamId > 0
		and			res.HasJobInterrupted = 0 and res.LogicalRelease = 0
		and			res.DoNotInterrupt = 0 and res.IntrJobId_h = 0 and res.IntrJobId_l = 0
		and			res.Preemptable = 1 and res.Priority > @i_Priority
		and			res.ReservationId = resToJob.ReservationId
		-- All the reservation types of the stream need to match current job reservation type
		delete @interruptibleStreams
		where	ReservationId in
			(select a.ReservationId
			 from		MMResourceToJob a with (readuncommitted), @interruptibleStreams b
			 where	a.ReservationId = b.ReservationId
			 and		a.ReservationType <> @i_ReservationType
			)
		if @i_maxMXCount > 0
		begin
			delete @interruptibleStreams
			where ReservationId in
				(select a.ReservationId
					from MMResourceToJob a with (readuncommitted), @interruptibleStreams b
					where a.ReservationId = b.ReservationId
					group by a.ReservationId
					having (count(*) < @i_maxMXCount))
		end
		-- Refer to logic in function GetJobTypeForJobID
		update	@interruptibleStreams
		set		jobtype = case when b.jobcategory is NULL then -1
								when b.jobcategory = 1 then 4
								when b.jobcategory = 2 then 5
								else ISNULL(b.opType, -1)
								end
		from @interruptibleStreams a left join JMJobInfo b with (nolock)
		on a.jobId = b.jobid
		-- Since we don't support interruption for job right now, interruption has to be done based on reservation Id, even when resource is doing multiplexing.
		if @jobOpType = @BKP
		or @jobOpType = @CSDRBKP
		or @jobOpType = @SYSSTATEBACKUP
		begin
			delete @interruptibleStreams
			where  ReservationId in (
					select	distinct ReservationId
					from	@interruptibleStreams
					where	jobType in ( @RST, @INDEXRESTORE)
					or		@BackupInterruptBackup <= 0 and jobType in (@CSDRBKP, @BKP, @SYSSTATEBACKUP)
					or		@OtherInterruptAuxCopy <= 0 and	jobType in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
					)
		end
		else if @jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		begin
			delete @interruptibleStreams
			where @AuxCopyInterruptAuxCopy = 0
			or	 (@AuxCopyInterruptAuxCopy > 0
					and ReservationId in (select distinct ReservationId from @interruptibleStreams
											where jobType not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
				)
		end
		-- Update the interruptible stream count for data path
		update RMDataPathView
		set		InterruptibleStreams = (
						select count(distinct StreamId)
						from @interruptibleStreams
						where DrivePoolId		= RMDataPathView.DrivePoolId
						and		ClientId			= RMDataPathView.HostClientId
						and		LibraryId			= RMDataPathView.LibraryId
						and		SpareGroupId	= RMDataPathView.SpareGroupId
					)
		set @o_NumIntrResources = isnull((select count(distinct StreamId) from @interruptibleStreams), 0)
		goto error_exit
	end
if @i_InterruptFor = 16
	begin
		if @i_CopyId <= 0 or
		(@i_DataPathId > 0 and
			not exists (select * from RMDataPathView where DataPathId = @i_DataPathId))
		begin
			set @o_NumIntrResources = 0
			goto error_exit
		end
	  -----------------------------------------------------------------------------------------------------
	  -- Figure out if interruptible Streams number for all the DataPath if there is no give DataPath id --
	  -----------------------------------------------------------------------------------------------------
	  -- 1. Get interruptible reservation list for the specified copy having priority less than the passed in priority
	  -- 2. Copy Id should be different from current job, or stream id is 0. (If it is the same, that should belong to stream interruption)
	  -- 3. All the existing jobs need to be interruptible by current job.
		declare @interruptibleDrives table
		(
				DrivePoolId			int,
				DriveId					int,
				ClientId				int,
				LibraryId				int,
				SpareGroupId		int,
				MountPathId			int,
				ReservationId		int,
				RCid				int,
				jobId				int,
				jobType 			int
		)
		insert	into @interruptibleDrives
		select	distinct dp.DrivePoolId, res.DriveId, dp.HostClientId, dp.LibraryId, dp.SpareGroupId, res.MountPathId, res.ReservationId, resToJob.RCId, resToJob.JobId_l, 0
		from		RMDataPathView dp, MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where		dp.FailureErrorCode = 0
		and			(@i_DataPathId = 0 or dp.DataPathId = @i_DataPathId)
		and			res.MasterPoolId = dp.MasterPoolId
		-- When it is disk library, need to make sure the media agent of current reservation matches the one trying to do interruption.
		and			(res.MountPathId = 0 OR res.ClientId = dp.HostClientId)
		--and			res.ClientId = dp.HostClientId
		--and			res.LibraryId = dp.LibraryId
		--and			res.SpareGroupId = dp.SpareGroupId
		and			res.HasJobInterrupted = 0 and res.LogicalRelease = 0
		and			res.DoNotInterrupt = 0 and res.IntrJobId_h = 0 and res.IntrJobId_l = 0
		and			res.Preemptable = 1 and res.Priority > @i_Priority
		and			res.ReservationId = resToJob.ReservationId
		and			resToJob.ReleaseTime = 0
		-- if it is write reservation, only interrupt writer
		delete @interruptibleDrives
		where MountPathId > 0
		and		ReservationId in
					( select	res.ReservationId
						from		MMResource res with (readuncommitted), @interruptibleDrives d
						where		res.ReservationId = d.ReservationId
and			res.ReservationType != 2
and			@i_ReservationType = 2
					)
		-- Make sure the drives belong to selected drive pool
		delete @interruptibleDrives
		where		MountPathId = 0
		and			DriveId not in
						(	select a.DriveId
						 	from	@interruptibleDrives a, MMDriveController b with (readuncommitted)
						 	where	a.DriveId = b.DriveId
						 	and		b.DrivePoolId = a.DrivePoolId
						)
		-- When using disk library, make sure the mount path can be access by the drive pool for write
if (@i_ReservationType = 2)
		begin
			-- Device controller has write access
			delete @interruptibleDrives
			where		MountPathId > 0
			and			exists (select DeviceId from MMMountPathToStorageDevice mpsd with (readuncommitted) where MountPathId = mpsd.MountPathId)
			and			not exists
							(	select	b.DeviceId
								from	@interruptibleDrives a, RMDataPathView dp, MMMountPathToStorageDevice b with (readuncommitted), MMDeviceController c with (readuncommitted)
								where	dp.DrivePoolId = a.DrivePoolId
								and		b.MountPathId = a.MountPathId
								and		b.DeviceId = c.DeviceId
								and		dp.HostClientId = c.ClientId
and		c.DeviceAccessType & 2 > 0
								and		c.DeviceControllerEnabled > 0
								and		c.DeviceAccessible > 0
							)
		end
		-- Refer to logic in function GetJobTypeForJobID
		update	@interruptibleDrives
		set		jobtype = case when b.jobcategory is NULL then -1
								when b.jobcategory = 1 then 4
								when b.jobcategory = 2 then 5
								else ISNULL(b.opType, -1)
								end
		from @interruptibleDrives a left join JMJobInfo b with (nolock)
		on a.jobId = b.jobid
		-- Since we don't support interruption for job right now, interruption has to be done based on reservation Id, even when resource is doing multiplexing.
		if @jobOpType = @BKP
		or @jobOpType = @CSDRBKP
		or @jobOpType = @SYSSTATEBACKUP
		begin
			delete @interruptibleDrives
			where  ReservationId in (
					select	distinct ReservationId
					from	@interruptibleDrives
					where	jobType in ( @RST, @INDEXRESTORE)
					or		@BackupInterruptBackup <= 0 and jobType in (@CSDRBKP, @BKP, @SYSSTATEBACKUP)
					or		@OtherInterruptAuxCopy <= 0 and	jobType in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
					)
		end
		else if @jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		begin
			delete @interruptibleDrives
			where @AuxCopyInterruptAuxCopy = 0
			or	 (@AuxCopyInterruptAuxCopy > 0
					and ReservationId in (select distinct ReservationId from @interruptibleDrives
											where jobType not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
				)
		end
		-- Update the interruptible stream count for data path
		update RMDataPathView
		set		InterruptibleDrives = (
						select count(distinct DriveId)
						from @interruptibleDrives
						where DrivePoolId		= RMDataPathView.DrivePoolId
						and		ClientId			= RMDataPathView.HostClientId
						and		LibraryId			= RMDataPathView.LibraryId
						and		SpareGroupId	= RMDataPathView.SpareGroupId
					)
		set @o_NumIntrResources = isnull((select count(distinct DriveId) from @interruptibleDrives), 0)
		goto error_exit
	end
  if @i_numMinResourceRequired <= 0
  begin
   	goto error_exit
  end
	-- If there is job option for drive id exists, interruption should only happen for the given drive ids.
 	DECLARE @jobOptionDriveIdList TABLE (DriveId int)
IF @i_ReservationType = 2
	BEGIN
		INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(@i_jobId, 1238677445) as int)
		DELETE @jobOptionDriveIdList WHERE DriveId = 0
	END
	ELSE
	BEGIN
		INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(@i_jobId, 785491355) as int)
		DELETE @jobOptionDriveIdList WHERE DriveId = 0
	END
  -- interrupt for stream
if @i_InterruptFor = 1
  begin
		-- Make sure the time requirement is met.
if datediff(s, dbo.GetDateTime(@i_PhaseFirstAttemptTime), getutcdate()) < (@i_InterruptInterval * 60)
		begin
			goto error_exit
		end
		DECLARE @intr_StreamIds TABLE (Id int, StreamId int, RowNumber int, RCId int, JobId int, JobType int)
		INSERT into @intr_StreamIds
		SELECT res.ReservationId, res.StreamId, ROW_NUMBER() OVER (order by res.Priority desc, res.CopyId ASC, res.ReservationTime, resToJob.RCID) as RowNumber,
				resToJob.RCID, resToJob.JobId_l, 0
		FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where	res.CopyId = @i_CopyId
		and		res.StreamId != 0
		and		(@i_DrivePoolId = 0 or res.DrivePoolId = @i_DrivePoolId)
		and		res.HasJobInterrupted = 0 and res.LogicalRelease = 0
		and		res.DoNotInterrupt = 0 and res.IntrJobId_h = 0 and res.IntrJobId_l = 0
		and		res.Preemptable = 1 and res.Priority > @i_Priority
		and		(
					not exists (select * from @jobOptionDriveIdList)
					or
					res.DriveId in (select DriveId from @jobOptionDriveIdList)
				)
		and		res.ReservationId = resToJob.ReservationId
		order by res.Priority DESC, res.CopyId ASC, res.ReservationTime, resToJob.RCID
		delete @intr_StreamIds
		where		Id in
			(select a.ReservationId
			 from		MMResourceToJob a with (readuncommitted), @intr_StreamIds b
			 where	a.ReservationId = b.Id
							-- All the reservation types of the stream need to match current job reservation type
			 and		( a.ReservationType <> @i_ReservationType
			 				or
			 				-- No job is releasing the reservation
( a.ReleaseTime <> 0 and a.ReserveBitMask = 2)
			 				)
			)
		if @i_maxMXCount > 0
		begin
			delete @intr_StreamIds
			where Id in
				(select a.ReservationId
					from MMResourceToJob a with (readuncommitted), @intr_StreamIds b
					where a.ReservationId = b.Id
					group by a.ReservationId
					having (count(*) < @i_maxMXCount))
		end
		-- Refer to logic in function GetJobTypeForJobID
		update	@intr_StreamIds
		set		jobtype = case when b.jobcategory is NULL then -1
								when b.jobcategory = 1 then 4
								when b.jobcategory = 2 then 5
								else ISNULL(b.opType, -1)
								end
		from @intr_StreamIds a left join JMJobInfo b with (nolock)
		on a.jobId = b.jobid
		if @jobOpType = @BKP
		or @jobOpType = @CSDRBKP
		or @jobOpType = @SYSSTATEBACKUP
		begin
			delete @intr_StreamIds
			where	Id in (
						select	distinct Id
						from	@intr_StreamIds
						where	jobType in ( @RST, @INDEXRESTORE)
						or		@BackupInterruptBackup <= 0 and jobType in (@CSDRBKP, @BKP, @SYSSTATEBACKUP)
						or		@OtherInterruptAuxCopy <= 0 and	jobType in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
					)
		end
		else if @jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		begin
			delete @intr_StreamIds
			where	@AuxCopyInterruptAuxCopy = 0
			or		(@AuxCopyInterruptAuxCopy > 0
						and id in (select distinct Id from @intr_StreamIds
								where jobType not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
					)
		end
		insert into @rmIntrId
		SELECT Id
		FROM
		(
			SELECT DISTINCT Id, ROW_NUMBER() over (order by RowNumber) row
			FROM @intr_StreamIds
		) a
		WHERE row BETWEEN 1 AND @i_numMinResourceRequired
		select @o_NumIntrResources = @@ROWCOUNT
		if @o_NumIntrResources < @i_numMinResourceRequired
		begin
		  set @o_NumIntrResources = 0
			goto error_exit
		end
		update MMResource set IntrJobId_l = @i_JobId where ReservationId in (select id from @rmIntrId)
		while (@i_numMinResourceRequired > 0)
		begin
			select top 1 @intrResId = id from @rmIntrId
			if @intrResId is null or @intrResId = 0
				break
	    insert into MMResource
		        (CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
							MasterPoolId, MediaGroupId, IntrJobId_h, IntrJobId_l, HasJobInterrupted, ReservationType,
							ReservationTime, Priority, PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
							DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId,
							NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId)
			select	CopyId, StreamId, VolumeId, MediaId, DriveId, ClientId, DrivePoolId,
							MasterPoolId, MediaGroupId, 0, 0, 1, ReservationType,
							dbo.GetUnixTime(getutcdate()), @i_Priority, @i_PreEmptable, IsResDummy, Released, ResourceFlag, PrimaryResId, IntrResId, LogicalRelease,
							DoNotInterrupt, LibraryId, LibraryTypeId, SpareGroupId, MountPathId, DriveInUseByDM, ScheduleRunId,
							NoOtherSchedule, ReleaseTime, Flag, SIDBStoreId
			from MMResource
			where ReservationId = @intrResId
		  set @curResId = @@identity
	  	select @curRCID = next_l + 1 from gxcounter where name = 'RCID_Counter'
		  update gxcounter set next_l = @curRCID where name = 'RCID_Counter'
		  insert into MMResourceToJob
			   (ReservationId, JobId_h, JobId_l, Priority, PreEmptable, InUse,
					ReserveBitMask, ReleaseTime, ReservationType, RCID, PrimaryRCID, ClientTokenId,
					DestMediaGroupId, LogicalReleased, Flag)
			values
				(@curResId, 0, @i_jobId, @i_priority, @i_preEmptable, 1 /*InUse*/,
1, 0, @i_ReservationType, @curRCID, 0, 0,
				0, 0, 0)
			delete @rmIntrId where id = @intrResId
			set @i_numMinResourceRequired = @i_numMinResourceRequired - 1
		end
		goto error_exit
  end
  -- interrupt for drive
if @i_InterruptFor = 2
  begin
  	if @i_MasterPoolId <= 0
  	begin
  		-- cannot do interruption
  		if @i_DrivePoolId <= 0
  			goto error_exit
  		select @i_MasterPoolId = MasterPoolId from MMDrivePool with (readuncommitted) where DrivePoolId = @i_DrivePoolId
  	end
  	declare @MaxDrivesToSwitch int
  	declare @numReservations	int
  	select @MaxDrivesToSwitch = MaxDrivesToSwitch from MMDrivePool with (readuncommitted) where DrivePoolId = @i_DrivePoolId
  	select @numReservations = count(*) from MMResource with (readuncommitted) where HasJobInterrupted = 0 and DrivePoolId = @i_DrivePoolId
  	-- Get the interruptible resource based on the master pool id
		DECLARE @intr_DriveIds TABLE (ReservationId int, DriveId int, DrivePoolId int, MountPathId int, RowNumber int, RCId int, JobId int, JobType int)
		INSERT INTO @intr_DriveIds
		SELECT	res.ReservationId, res.DriveId, res.DrivePoolId, res.MountPathId, ROW_NUMBER() OVER (order by res.Priority desc, res.DrivePoolId, res.ReservationTime, resToJob.RCId) as RowNumber,
				resToJob.RCId, resToJob.JobId_l, 0
		FROM		MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
		where		res.MasterPoolId = @i_MasterPoolId
		and			res.HasJobInterrupted = 0 and res.LogicalRelease = 0 and res.DoNotInterrupt = 0
		and			res.IntrJobId_h = 0 and res.IntrJobId_l = 0
		and			res.Preemptable = 1
		and			res.Priority > @i_Priority
		and			(@i_DriveId = 0 or res.DriveId = @i_DriveId)
		and		(
					not exists (select * from @jobOptionDriveIdList)
					or
					res.DriveId in (select DriveId from @jobOptionDriveIdList)
				)
		and		res.ReservationId = resToJob.ReservationId
		and		resToJob.ReleaseTime = 0
		order by res.Priority DESC, res.CopyId, res.ReservationTime, resToJob.RCID
		if exists (select MountPathId from @intr_DriveIds where MountPathId > 0)
		begin
			-- if it is write reservation, only interrupt writer
			delete @intr_DriveIds
			where ReservationId in
						( select	res.ReservationId
							from		MMResource res, @intr_DriveIds d
							where		res.ReservationId = d.ReservationId
and			res.ReservationType != 2
and			@i_ReservationType = 2
						)
			if not exists (select * from @intr_DriveIds)
				goto error_exit
			-- When using disk library, make sure the mount path can be access by the drive pool for write
if (@i_ReservationType = 2)
			begin
				-- Device controller has write access
				delete @intr_DriveIds
				where		MountPathId > 0
				and			exists (select DeviceId from MMMountPathToStorageDevice mpsd with (readuncommitted) where MountPathId = mpsd.MountPathId)
				and			not exists
								(	select	b.DeviceId
									from	@intr_DriveIds a, MMMountPathToStorageDevice b with (readuncommitted), MMDeviceController c with (readuncommitted), MMDrivePool d with (readuncommitted)
									where	b.MountPathId = a.MountPathId
									and		b.DeviceId = c.DeviceId
									and		d.DrivePoolId = @i_DrivePoolId
									and		d.ClientId = c.ClientId
and		c.DeviceAccessType & 2 > 0
									and		c.DeviceControllerEnabled > 0
									and		c.DeviceAccessible > 0
								)
			end
		end
		-- non-magnetic drive interruption
		else
		begin
			-- Make sure the drives belong to selected drive pool
			delete @intr_DriveIds
			where		DriveId not in
							(	select a.DriveId
							 	from	@intr_DriveIds a, MMDriveController b with (readuncommitted)
							 	where	a.DriveId = b.DriveId
							 	and		b.DrivePoolId = @i_DrivePoolId
							)
			if not exists (select * from @intr_DriveIds)
				goto error_exit
			-- Make sure the drive controller is online
			delete @intr_DriveIds
			where		DriveId in
							(	select a.DriveId
							 	from	@intr_DriveIds a, MMDriveController b with (readuncommitted)
							 	where	a.DriveId = b.DriveId
							 	and		b.DrivePoolId = @i_DrivePoolId
							 	and		(
								 				b.DriveControllerSoftState <= 0
								 				or b.DriveControllerEnabled <= 0
								 				or b.DriveAccessible <= 0
							 				)
						 )
			if not exists (select * from @intr_DriveIds)
			begin
set @o_ErrorCode = 276
				goto error_exit
			end
			-- make sure we are not over drive allocation policy set on drive pool for drivePoolId
			-- if the drive interrupted is allocated
			if @MaxDrivesToSwitch >= 0 and @MaxDrivesToSwitch <= @numReservations
			begin
				delete @intr_DriveIds
				where DrivePoolId <> @i_DrivePoolId
				if not exists (select * from @intr_DriveIds)
				begin
set @o_ErrorCode = 296
					goto error_exit
				end
			end
		end
		if (@jobOpType = @RST or @jobOpType = @INDEXRESTORE)
		and @RestoreInterruptOther <= 0
		begin
			goto error_exit
		end
		-- Refer to logic in function GetJobTypeForJobID
		update	@intr_DriveIds
		set		jobtype = case when b.jobcategory is NULL then -1
								when b.jobcategory = 1 then 4
								when b.jobcategory = 2 then 5
								else ISNULL(b.opType, -1)
								end
		from @intr_DriveIds a left join JMJobInfo b with (nolock)
		on a.jobId = b.jobid
		if @jobOpType = @BKP
		or @jobOpType = @CSDRBKP
		or @jobOpType = @SYSSTATEBACKUP
		begin
			delete @intr_DriveIds
			where  ReservationId in (
						select	distinct ReservationId
						from	@intr_DriveIds
						where	jobType in ( @RST, @INDEXRESTORE)
						or		@BackupInterruptBackup <= 0 and jobType in (@CSDRBKP, @BKP, @SYSSTATEBACKUP)
						or		@OtherInterruptAuxCopy <= 0 and	jobType in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
						)
		end
		else if @jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		begin
			delete @intr_DriveIds
			where @AuxCopyInterruptAuxCopy = 0
			or		(@AuxCopyInterruptAuxCopy > 0
						and ReservationId in (select distinct ReservationId from @intr_DriveIds
								where jobType not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
					)
		end
		insert into @rmIntrId
		SELECT ReservationId
		FROM
		(
			SELECT DISTINCT ReservationId, ROW_NUMBER() over (order by RowNumber) row
			FROM @intr_DriveIds
		) a
		WHERE row BETWEEN 1 AND @i_numMinResourceRequired
    select @o_NumIntrResources = @@rowcount
		if @o_NumIntrResources < @i_numMinResourceRequired
		begin
			set @o_NumIntrResources = 0
			goto error_exit
		end
		-- Make sure the time requirement is met.
if datediff(s, dbo.GetDateTime(@i_PhaseFirstAttemptTime), getutcdate()) < (@i_InterruptInterval * 60)
		begin
			update MMResource
			set			DoNotInterrupt = 1
			where		ReservationId in (select id from @rmIntrId)
			set @o_NumIntrResources = 0
			goto error_exit
		end
		update MMResource set IntrJobId_l = @i_JobId where ReservationId in (select id from @rmIntrId)
		goto error_exit
  end
	-- interrupt for media
if @i_InterruptFor = 4
	begin
		if @i_MediaId = 0
		begin
	  	goto error_exit
		end
		set @intrResId = 0
		select top 1 @intrResId = ReservationId
		from		MMResource with (readuncommitted)
		where		MediaId = @i_MediaId
		and			(@i_VolumeId = 0 or VolumeId = @i_VolumeId)
		and			Priority > @i_Priority
		and			HasJobInterrupted = 0 and LogicalRelease = 0 and DoNotInterrupt = 0
		and			IntrJobId_h = 0 and IntrJobId_l = 0
		and			Preemptable = 1
		and			not exists (Select ReservationId from MMResourceToJob where ReleaseTime <> 0 and ReservationId = MMResource.ReservationId)
		order by Priority DESC, ReservationTime
		if @intrResId = 0
		begin
			select top 1 @intrResId = ReservationId
			from		MMResource with (readuncommitted)
			where		MediaId = @i_MediaId
			and			Priority > @i_Priority
			and			HasJobInterrupted = 0 and LogicalRelease = 0 and DoNotInterrupt = 0
			and			IntrJobId_h = 0 and IntrJobId_l = 0
			and			Preemptable = 1
			and			not exists (Select ReservationId from MMResourceToJob where ReleaseTime <> 0 and ReservationId = MMResource.ReservationId)
			order by Priority DESC, ReservationTime
		end
		if @intrResId = 0
		begin
	  	goto error_exit
		end
		-- No job is releasing the reservation
		if exists (select ReservationId from MMResourceToJob
								where ReservationId = @intrResId
								and		ReleaseTime <> 0
and		ReserveBitMask = 2)
		begin
			goto error_exit
		end
		if (@jobOpType = @RST or @jobOpType = @INDEXRESTORE)
		and @RestoreInterruptOther <= 0
		begin
			goto error_exit
		end
		if @jobOpType = @BKP
		or @jobOpType = @CSDRBKP
		or @jobOpType = @SYSSTATEBACKUP
		begin
			if (@BackupInterruptBackup <= 0
					and exists (select ReservationId from MMResourceToJob with (readuncommitted)
											where ReservationId = @intrResId
											and		dbo.GetJobTypeForJobID(JobId_l) in (@CSDRBKP, @BKP, @SYSSTATEBACKUP))
					)
					or
				 (@OtherInterruptAuxCopy <= 0
					and exists (select ReservationId from MMResourceToJob with (readuncommitted)
											where ReservationId = @intrResId
											and 		dbo.GetJobTypeForJobID(JobId_l) in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
					)
					or
					(exists (select ReservationId from MMResourceToJob with (readuncommitted)
					 where ReservationId = @intrResId
					 and 		dbo.GetJobTypeForJobID(JobId_l) in (@RST, @INDEXRESTORE))
					)
			begin
				goto error_exit
			end
		end
		else if @jobOpType IN (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING)
		begin
			if (@AuxCopyInterruptAuxCopy <= 0
			or		(@AuxCopyInterruptAuxCopy > 0
						and		exists (select ReservationId from	MMResourceToJob with (readuncommitted)
									 				where	ReservationId = @intrResId
									 				and 	dbo.GetJobTypeForJobID(JobId_l) not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY, @MEDIAREFRESHING))
						))
			begin
				goto error_exit
			end
		end
		-- Make sure the time requirement is met.
if datediff(s, dbo.GetDateTime(@i_PhaseFirstAttemptTime), getutcdate()) < (@i_InterruptInterval * 60)
		begin
			update MMResource
			set	DoNotInterrupt = 1
			where ReservationId = @intrResId
			goto error_exit
		end
		update MMResource set IntrJobId_l = @i_JobId where ReservationId = @intrResId
		set @o_NumIntrResources = 1
		goto error_exit
	end
  -- interrupt based on data path failure reason
if @i_InterruptFor = 32
  begin
if @i_DataPathFailureCode not in (/*330,
349,*/
20118/*,
296,
297,
296,
20006*/)
	or @i_numMinResourceRequired = 0
	begin
	  	goto error_exit
	end
if datediff(s, dbo.GetDateTime(@i_PhaseFirstAttemptTime), getutcdate()) < (@i_InterruptInterval * 60)
	begin
		goto error_exit
	end
	DECLARE @intr_RCIds TABLE (ReservationId int, RCId int, RowNumber int, JobId int, JobType int)
	-- Pick interruption candidates based on the error code
if @i_DataPathFailureCode = 20118 -- E_MM_DDB_MAX_CONNECTION_EXCEEDED
	begin
		-- If this error code returned, then either configuration "MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB" is set
		-- or MaxAllowedConnections in table IdxSIDBStore is set
		DECLARE @maxSIDBReservationOnCopy int = 0
		DECLARE @lt_CopyList TABLE (copyId int)
		--Get total number of streams reserved on store including all dependent copies in case of GDSP.
		INSERT INTO @lt_CopyList
		SELECT  DISTINCT copyId
		FROM    ArchCopySIDBStore WITH (READUNCOMMITTED)
		WHERE   SIDBStoreId = (SELECT SIDBStoreId FROM ArchCopySIDBStore WITH (READUNCOMMITTED) WHERE CopyId = @i_CopyId)
		INSERT into @intr_RCIds
		SELECT a.ReservationId, a.RCID, ROW_NUMBER() OVER (order by a.Priority desc, a.CopyId ASC, a.ReservationTime, a.RCID) as RowNumber,
				a.JobId, 0
		FROM
		(
			SELECT	res.ReservationId as ReservationId, resToJob.RCID as RCID, resToJob.JobId_l as JobId, res.Priority as Priority,
					res.CopyId as CopyId, res.StreamId as StreamId, res.ReservationTime as ReservationTime
			FROM	MMResource res with (readuncommitted), MMResourceToJob resToJob with (readuncommitted)
			where	res.StreamId != 0
			and		res.HasJobInterrupted = 0 and res.LogicalRelease = 0
			and		res.DoNotInterrupt = 0 and res.IntrJobId_h = 0 and res.IntrJobId_l = 0
			and		res.Preemptable = 1 and res.Priority > @i_Priority
			and		(
						not exists (select * from @jobOptionDriveIdList)
						or
						res.DriveId in (select DriveId from @jobOptionDriveIdList)
					)
			and		res.ReservationId = resToJob.ReservationId
		) a inner join @lt_CopyList c on a.CopyId = c.CopyId
		left join
		(
			select Stream, ArchGroupCopyId from ArchStream with (readuncommitted)
where  Flags & 1 = 0
		) b
		on a.StreamId = b.Stream and c.CopyId = b.ArchGroupCopyId
		where b.Stream is not null
		order by a.Priority DESC, a.CopyId ASC, a.ReservationTime, a.RCID
		delete @intr_RCIds
		where	ReservationId in
			(select a.ReservationId
			 from	MMResourceToJob a with (readuncommitted), @intr_RCIds b
			 where	a.ReservationId = b.ReservationId
					-- All the reservation types of the stream need to match current job reservation type
			 and	( a.ReservationType <> @i_ReservationType
						or
					-- No job is releasing the reservation
( a.ReleaseTime <> 0 and a.ReserveBitMask = 2)
					)
			)
	end -- error code E_MM_DDB_MAX_CONNECTION_EXCEEDED
	-- Refer to logic in function GetJobTypeForJobID
	update	@intr_RCIds
	set		jobtype = case when b.jobcategory is NULL then -1
							when b.jobcategory = 1 then 4
							when b.jobcategory = 2 then 5
							else ISNULL(b.opType, -1)
							end
	from @intr_RCIds a left join JMJobInfo b with (readuncommitted)
	on a.jobId = b.jobid
	-- Remove unsupported jobTypes reservations
	delete	@intr_RCIds
	where	jobType NOT IN (@RST, @INDEXRESTORE, @BKP, @CSDRBKP, @SYSSTATEBACKUP, @SYNTHFULL, @AUXCOPY, @DASHCOPY)
	if @jobOpType = @BKP
	or @jobOpType = @CSDRBKP
	or @jobOpType = @SYSSTATEBACKUP
	begin
		delete @intr_RCIds
		where	ReservationId in (
					select	distinct ReservationId
					from	@intr_RCIds
					where	jobType in ( @RST, @INDEXRESTORE)
					or		@BackupInterruptBackup <= 0 and jobType in (@CSDRBKP, @BKP, @SYSSTATEBACKUP)
					or		@OtherInterruptAuxCopy <= 0 and	jobType in (@SYNTHFULL, @AUXCOPY, @DASHCOPY)
				)
	end
	else if @jobOpType = @AUXCOPY
	or @jobOpType = @DASHCOPY
	begin
		delete @intr_RCIds
		where	@AuxCopyInterruptAuxCopy = 0
		or		(@AuxCopyInterruptAuxCopy > 0
					and Reservationid in (select distinct ReservationId from @intr_RCIds
							where jobType not in (@SYNTHFULL, @AUXCOPY, @DASHCOPY))
				)
	end
	insert into @rmIntrId
	SELECT RCId
	FROM
	(
		SELECT DISTINCT RCId, ROW_NUMBER() over (order by RowNumber) row
		FROM @intr_RCIds
	) a
	WHERE row BETWEEN 1 AND @i_numMinResourceRequired
	select @o_NumIntrResources = @@ROWCOUNT
	if @o_NumIntrResources < @i_numMinResourceRequired
	begin
		set @o_NumIntrResources = 0
		goto error_exit
	end
	update MMResource set IntrJobId_l = @i_JobId
	where ReservationId in (
				select	resToJob.ReservationId
				from	MMResourceToJob resToJob WITH (READUNCOMMITTED), @rmIntrId as Id
				where 	resToJob.RCid = Id.Id
				)
	set @o_NumIntrResources = 1
	goto error_exit
  end
error_exit:
  return @o_NumIntrResources
GO


IF EXISTS (select * from GxQscripts where name = 'RMHandleInterrupt')
	delete from GxQscripts where name = 'RMHandleInterrupt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMHandleInterrupt')
	delete from GXDBVersions where aliasname = 'RMHandleInterrupt'
GO

insert into GXDBVersions values(2, 'RMHandleInterrupt',  '00010025004400100000', 'RMHandleInterrupt', '00010025004400100000')
GO

