

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMGetMediaView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMGetMediaView.sp,v $ $Id: RMGetMediaView.sp,v 1.6.200.2 2018/03/20 00:08:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMGetMediaView <<<'

IF EXISTS (select * from sysobjects where name='RMGetMediaView')
	drop procedure RMGetMediaView
IF EXISTS (select * from GxQscripts where name='RMGetMediaView')
	delete from GxQscripts where name = 'RMGetMediaView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetMediaView')
	delete from GXDBVersions where aliasname = 'RMGetMediaView'
GO
print '... Creating Procedure: RMGetMediaView'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMGetMediaView
  @i_RequestId integer,
  @i_JobId integer,
  @i_CopyId integer,
  @i_doNotAllowOtherSchedule integer,
  @i_ScheduleRunId integer,
  @isDebug integer,
  @o_ErrorCode integer OUTPUT
,
  @o_FailureType integer OUTPUT
AS
DECLARE @RMMediaView TABLE ( DataPathId			integer, HostClientId		integer, LibraryId			integer, LibraryTypeId		integer, LibraryAttribute	integer, MasterPoolId		integer, DrivePoolId			integer, SpareGroupId		integer, AppendableMediaCount	integer, SpareMediaCount			integer    )
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	IF 0 = (SELECT COUNT(*) FROM RMDataPathView WHERE FailureErrorCode = 0)
	BEGIN
SET	@o_ErrorCode = 20029
		GOTO EXIT_AND_RETURN
	END
	-- only consider the non-magnetic media
	INSERT INTO @RMMediaView
	SELECT	DataPathId, HostClientId, LibraryId, LibraryTypeId, LibraryAttribute,
					MasterPoolId, DrivePoolId, SpareGroupId, 0, 0
	FROM		RMDataPathView
	WHERE		FailureErrorCode = 0
	AND			SpareGroupId > 0
	DECLARE @SpareGroupList TABLE ( LibraryId int, SpareGroupId int, LibraryAttribute int, UseWithInDaysInSec int, MediaCount int, UNIQUE CLUSTERED (LibraryId, SpareGroupId))
	INSERT	INTO @SpareGroupList
	SELECT	DISTINCT l.LibraryId, a.SpareGroupId, a.LibraryAttribute, l.UseWithInDaysInSec, 0
	FROM		@RMMediaView a, MMLibrary l with (readuncommitted)
	WHERE		a.LibraryId = l.LibraryId
AND			a.LibraryTypeId NOT IN  (3,	4, 5)
	DECLARE @SpareGroupMediaCount TABLE ( MediaCount int, SpareGroupId int, LibraryId int)
	INSERT INTO @SpareGroupMediaCount
	SELECT	COUNT(Distinct m.MediaId) MediaCount, 0, a.LibraryId
	FROM	@SpareGroupList a, MMMedia m WITH (READUNCOMMITTED), MMVolume v WITH (READUNCOMMITTED)
	WHERE	a.LibraryId = m.LibraryId
	AND		m.MediaLocation in (1, 2) -- LOCATION_SLOT, LOCATION_DRIVE
	AND		m.MediaFlags = 1 -- MEDIA_FLAG_GOOD
	AND		m.IsInMediaGroup > 0
	AND		m.IsAged = 0
	AND		m.MediaId = v.MediaId
	-- exclude the exportable media if library attribute set to not use exportable media
AND		((a.LibraryAttribute & 32768) > 0 OR (m.Attributes & 1) = 0)
	-- all are marked exportable
	-- E_MM_MEDIA_MARKED_EXPORTABLE
AND		m.Attributes & 536870912 = 0
	-- E_MM_MEDIA_MARKED_PINNED_FOR_RECALL
AND		NOT (m.origCCcommCellId > 2 AND (a.LibraryAttribute & 32) = 0 AND (m.Attributes & 268435456) = 0)
	-- all spare are from diff APP_CommCell, cannot overwrite
	-- E_MM_DB_ALL_SPARES_FROM_DIFF_COMMCELL
	AND		v.VolumeState != 2 /*VOLUME_STUCK*/
	-- E_MM_RESERVE_MEDIA_STUCK
AND		NOT EXISTS (SELECT Barcode FROM MMSlot WITH (READUNCOMMITTED) WHERE Barcode = m.BarCode AND (MediaStatus & 1) > 0)
	-- duplicate
	-- E_MM_PC_MEDIA_DUPLICATE
	AND		EXISTS (SELECT mediaGroupId FROM ArchStream with (readuncommitted) WHERE v.MediaGroupId = mediaGroupId AND ArchGroupCopyId = @i_CopyId)
	-- delete assigned media that are not in media group
	-- E_MM_DB_NO_MORE_SPARES
AND		(a.LibraryAttribute & 512 > 0 OR (v.VolumeFlags != 7 /*VOL_ACTIVE_APPEND*/ ))
	-- delete appendible that cannot be used
	-- E_MM_PC_MEDIA_NO_APP
	AND		NOT (m.LastBackupTime > 0
				AND DATEDIFF(second, DATEADD(second, m.LastBackupTime, '01/01/1970'), getutcdate()) > a.UseWithInDaysInSec
				AND v.VolumeFlags = 7 /*VOL_ACTIVE_APPEND*/ )
	-- delete app due to usewithindays
	-- E_MM_PC_MEDIA_NO_APP_WITHIN
AND		NOT (((m.Attributes & 134217728) > 0 OR @i_doNotAllowOtherSchedule > 0)
							AND m.ScheduleRunId > 0 AND m.ScheduleRunId <> @i_ScheduleRunId)
	-- media has schedule run id already, do not allow others
	-- E_MM_DB_NO_MEDIA_FOR_SCHEDULE
	AND		v.VolumeFlags IN (1, 5, 7) -- VOL_ACTIVE, VOL_IDLE, VOL_ACTIVE_APPEND
	-- E_MM_DB_NO_MORE_SPARES
	AND		NOT EXISTS (SELECT MediaId From MMResource WHERE MediaId = m.MediaId AND IntrJobId_l = 0 AND HasJobInterrupted = 0)
	GROUP BY a.LibraryId
	UPDATE	@RMMediaView
	SET			AppendableMediaCount	= b.MediaCount
	FROM		@RMMediaView a, @SpareGroupMediaCount b
	WHERE		a.LibraryId = b.LibraryId
	DELETE @SpareGroupMediaCount
	INSERT INTO @SpareGroupMediaCount
	SELECT	COUNT(Distinct m.MediaId) MediaCount, a.SpareGroupId, 0
	FROM	@SpareGroupList a, MMMedia m WITH (READUNCOMMITTED), MMVolume v WITH (READUNCOMMITTED)
	WHERE	a.SpareGroupId = m.SpareGroupId
	AND		m.MediaLocation in (1, 2) -- LOCATION_SLOT, LOCATION_DRIVE
	AND		m.MediaFlags = 1 -- MEDIA_FLAG_GOOD
	AND		m.IsInMediaGroup = 0
	AND		m.MediaId = v.MediaId
	-- exclude the exportable media if library attribute set to not use exportable media
AND		((a.LibraryAttribute & 32768) > 0 OR (m.Attributes & 1) = 0)
	-- all are marked exportable
	-- E_MM_MEDIA_MARKED_EXPORTABLE
AND		m.Attributes & 536870912 = 0
	-- E_MM_MEDIA_MARKED_PINNED_FOR_RECALL
AND		NOT (m.origCCcommCellId > 2 AND (a.LibraryAttribute & 32) = 0 AND (m.Attributes & 268435456) = 0)
	-- all spare are from diff APP_CommCell, cannot overwrite
	-- E_MM_DB_ALL_SPARES_FROM_DIFF_COMMCELL
	AND		v.VolumeState != 2 /*VOLUME_STUCK*/
	-- E_MM_RESERVE_MEDIA_STUCK
AND		NOT EXISTS (SELECT Barcode FROM MMSlot WITH (READUNCOMMITTED) WHERE Barcode = m.BarCode AND (MediaStatus & 1) > 0)
	-- duplicate
	-- E_MM_PC_MEDIA_DUPLICATE
	AND		v.VolumeFlags IN (1, 5, 7) -- VOL_ACTIVE, VOL_IDLE, VOL_ACTIVE_APPEND
	-- E_MM_DB_NO_MORE_SPARES
	GROUP BY a.SpareGroupId
	UPDATE	@RMMediaView
	SET			SpareMediaCount	= b.MediaCount
	FROM		@RMMediaView a, @SpareGroupMediaCount b
	WHERE		a.SpareGroupId = b.SpareGroupId
EXIT_AND_RETURN:
SELECT * FROM @RMMediaView
GO

IF EXISTS (select * from GxQscripts where name = 'RMGetMediaView')
	delete from GxQscripts where name = 'RMGetMediaView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetMediaView')
	delete from GXDBVersions where aliasname = 'RMGetMediaView'
GO

insert into GXDBVersions values(2, 'RMGetMediaView',  '00010006020000020000', 'RMGetMediaView', '00010006020000020000')
GO

