

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMGetDriveView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMGetDriveView.sp,v $ $Id: RMGetDriveView.sp,v 1.58.2.15 2020/08/24 14:12:35 pnara Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMGetDriveView')
BEGIN
	print '>>> Drop Stored Procedure: RMGetDriveView <<<'
	drop procedure RMGetDriveView
END
IF EXISTS (select * from GxQscripts where name='RMGetDriveView')
	delete from GxQscripts where name = 'RMGetDriveView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetDriveView')
	delete from GXDBVersions where aliasname = 'RMGetDriveView'
GO
print '... Creating Procedure: RMGetDriveView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMGetDriveView
  @i_RequestId integer,
  @i_JobId integer,
  @i_AppTypeId integer,
  @i_AccessType integer,
  @i_IsForSwap integer,
  @i_numStreams integer,
  @i_bestcaseReserve integer,
  @i_CopyId integer,
  @i_UseAppendable integer,
  @isDebug integer,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
	--set @o_FailureType = RM_FAILURE_SP
	-- RM_TABLE_DEFINE_DRIVEVIEW()
	IF object_id('tempdb.dbo.#RMDriveViewWithOffline') IS NULL
CREATE TABLE #RMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
	DELETE #RMDriveViewWithOffline
	CREATE NONCLUSTERED INDEX DriveView_DataPath ON #RMDriveViewWithOffline(dataPathId)
	CREATE NONCLUSTERED INDEX DriveView_FailureErrorCode ON #RMDriveViewWithOffline(FailureErrorCode)
	CREATE NONCLUSTERED INDEX DriveView_Error_MountPath ON #RMDriveViewWithOffline(FailureErrorCode, MountPathId)
	CREATE NONCLUSTERED INDEX DriveView_Error_MountPath_DrivePool ON #RMDriveViewWithOffline(FailureErrorCode, MountPathId, DrivePoolId)
	CREATE NONCLUSTERED INDEX DriveView_Error_MountPath_MasterPool ON #RMDriveViewWithOffline(FailureErrorCode, MountPathId, MasterPoolId)
	CREATE NONCLUSTERED INDEX DriveView_Error_Drive ON #RMDriveViewWithOffline(FailureErrorCode, DriveId)
	CREATE NONCLUSTERED INDEX DriveView_Error_Library ON #RMDriveViewWithOffline(FailureErrorCode, LibraryId)
	IF object_id('tempdb.dbo.#tmpRMDriveViewWithOffline') IS NULL
CREATE TABLE #tmpRMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, Priority					integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
	delete #tmpRMDriveViewWithOffline
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	DECLARE @l_RWBits Integer
SET @l_RWBits = CASE 	WHEN @i_accessType = 2 then 4
WHEN @i_accessType = 1 then 2
												ELSE 0
									END
	declare @MOUNT_PATH_MAGNETIC				integer
	declare @MOUNT_PATH_CENTERA					integer
	declare @MOUNT_PATH_DYNAMIC_SHARED	integer
	declare @MOUNT_PATH_TAPE						integer
	declare @MOUNT_PATH_SHARED_STATIC		integer
	declare @MOUNT_PATH_SHARED_REPLICA	integer
	declare @MOUNT_PATH_DRU							integer
	declare @MOUNT_PATH_EXTERNAL_REMOTE_HOST	integer
	set @MOUNT_PATH_MAGNETIC				= 0
	set @MOUNT_PATH_CENTERA					= 1
	set @MOUNT_PATH_DYNAMIC_SHARED	= 2
	set @MOUNT_PATH_TAPE						= 3
	set @MOUNT_PATH_SHARED_STATIC		= 4
	set @MOUNT_PATH_SHARED_REPLICA	= 5
	set @MOUNT_PATH_DRU							= 6
	set @MOUNT_PATH_EXTERNAL_REMOTE_HOST	= 7
	declare @BKP 							int
 	declare @RST 							int
 	declare @CSDRBKP 					int
 	declare @INDEXRESTORE			int
 	declare @AUXCOPY 					int
 	declare @SYNTHFULL 				int
 	declare @SYSSTATEBACKUP		int
 	declare @DRIVEVALIDATION	int
 	declare @DRIVECLEANING		int
 	declare @STAMPMEDIA				int
	declare @ARCHIVECHECK 		 	int
 	set @BKP 									= 4
 	set @RST	 								= 5
 	set @CSDRBKP 							= 11
 	set @INDEXRESTORE 				= 12
 	set @AUXCOPY 							= 13
 	set @SYNTHFULL 						= 14
 	set @SYSSTATEBACKUP				= 30
 	set @DRIVEVALIDATION			= 41
 	set @DRIVECLEANING				= 42
 	set @STAMPMEDIA						= 46
	set	@ARCHIVECHECK 				= 31
	declare @TAPEERASE integer = 32
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER INTEGER
	SET			@DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER = 16
	declare @isMaintenanceJob int
	declare @isDriveCleaningJob int
	declare @jobOpType int
	set @isMaintenanceJob = 0
	set @isDriveCleaningJob = 0
	set @jobOpType = 0
	set @jobOpType = dbo.GetJobTypeForJobID(@i_JobId)
  if @jobOpType = @DRIVEVALIDATION or @jobOpType = @DRIVECLEANING or @jobOpType = @STAMPMEDIA
    set @isMaintenanceJob = 1
	if @jobOpType = @DRIVECLEANING
		set @isDriveCleaningJob = 1
	DECLARE @NumDriveView integer
	-- Use to identify the failure priority and set data path failure reason
	DECLARE @CheckPriority	integer
	SET	@CheckPriority = 0
 	DECLARE @jobOptionDriveIdList TABLE (DriveId int)
	DECLARE @isPowerVMFeatureEnabled INT
	SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
GETDATA:
	IF 0 = (SELECT COUNT(*) FROM RMDataPathView WHERE FailureErrorCode = 0)
	BEGIN
SET	@o_ErrorCode = 807
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
	INSERT INTO #RMDriveViewWithOffline
	-- tape
	SELECT 	DISTINCT DPV.Priority, DPV.DatapathId, DC.DriveControllerId, DC.DriveId, DC.DrivePoolId, DPV.MasterPoolId,
					DPV.LibraryId, DPV.SpareGroupId, DPV.HostClientId, DC.ClientId,
					0, 0, 0, 0, D.LastUseTime, 0,
					D.MediaId,
					0, 0,
					0, DPV.LibrarySubType, D.Attributes
FROM 	(SELECT * FROM RMDataPathView WHERE FailureErrorCode = 0 AND LibraryTypeId != 3) AS DPV
				INNER JOIN	MMDriveController as DC with (readuncommitted) ON DC.DrivePoolId = DPV.DrivePoolId
				INNER JOIN	MMDrive as D with (readuncommitted) on D.driveid = DC.driveid
	UNION ALL
	--INSERT INTO #RMDriveViewWithOffline
	-- magnetic
	SELECT	DISTINCT DPath.Priority, DPath.DataPathId, 0, D.driveid, DPath.drivepoolid, DPath.masterpoolid,
					DPath.libraryid, 0, DPath.HostClientId, DPath.HostClientId,
					MP.MountPathId, isnull(DVC.DeviceId, 0), isnull(DVC.DeviceControllerId, 0),
					-- now the order - if we are not using round robin, sort by Number of Writers on the Mount Path
CASE WHEN (DPath.ExtendedAttributes & 1) = 0 THEN MP.NumberOfWriters
					     ELSE isnull(ResUsage.NumReservations, 0)
					END AS NumDrvWriters,
					M.LastBackupTime AS DrvLastBackupTime,
CASE WHEN (DPath.ExtendedAttributes & 1) = 0 THEN 0
						ELSE M.NumberOfReUses
					END AS MediaNumReused,
					D.MediaId,
					0, 0,
					DPath.ExtendedAttributes,
					DPath.LibrarySubType, D.Attributes
	FROM
		 (
		 		SELECT	DPV.Priority, DPV.DatapathId, DPV.DrivePoolId, DPV.MasterPoolId,
		 						DPV.LibraryId, DPV.HostClientId, DPV.ExtendedAttributes, DPV.LibrarySubType
				FROM		RMDataPathView DPV
WHERE		FailureErrorCode = 0 AND LibraryTypeId = 3
			) DPath
			INNER JOIN MMDrive D			with (readuncommitted) ON D.MasterPoolId = DPath.MasterPoolId
			INNER JOIN MMMediaSide MS	with (readuncommitted) ON MS.MediaId = D.MediaId
			INNER JOIN MMMedia M			with (readuncommitted) ON M.MediaId = D.MediaId
			INNER JOIN MMMountPath MP	with (readuncommitted) ON MP.MediaSideId = MS.MediaSideId
			LEFT OUTER JOIN MMMountPathToStorageDevice MP2SD	with (readuncommitted) ON MP2SD.MountPathId = MP.MountPathId
			LEFT OUTER JOIN MMDeviceController DVC						with (readuncommitted) ON DVC.DeviceId = MP2SD.DeviceId AND DVC.ClientId = DPath.HostClientId
			LEFT OUTER JOIN (
												SELECT	R.DriveId, count(R.DriveId) as NumReservations
												FROM		MMResource R with (readuncommitted)
WHERE		ReservationType = 2
												GROUP BY R.DriveId
											) ResUsage ON ResUsage.DriveId = D.DriveId
	SET @NumDriveView = @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 807
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  --------------------------------------------------
  --   License Check For Drive and Mount Path     --
  --------------------------------------------------
if @i_accessType = 2
	begin
		declare @hasLicense int
		declare @mediaAgentList table ( clientId int, Id int )
		declare @mediaAgentId int
		/* -- remove license check for USB Tape Drive completely
		-- Check USB Tape Drive
		-- For all the USB Tape Drive, media agent has to have advance media agent license Adevance SIM_CSL_AT_V2_CELL_ADV_MA
		insert into @mediaAgentList
		select	a.MAClientId, a.DriveControllerId
		from #RMDriveViewWithOffline a, MMDriveController b with (readuncommitted)
		where	a.DriveControllerId > 0
		and		a.DriveControllerId = b.DriveControllerId
		and		b.SCSIID like 'P:USB%'
		set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, 2, SIM_CSL_AT_V2_CELL_ADV_MA, 1053, 'install', 0, 0
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO EXIT_AND_RETURN
		END
		if @hasLicense = 0
		begin
		  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 502
		  WHERE	FailureErrorCode = 0
		  AND		DriveControllerId in (select Id from @mediaAgentList)
			select @NumDriveView = @NumDriveView - @@rowcount
			if @NumDriveView = 0
			begin
set @o_ErrorCode = 502
set @o_FailureType = 1
			  GOTO EXIT_AND_RETURN
			end
			-- check advance MA license
		  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 502
		  WHERE	FailureErrorCode = 0
		  AND		MountPathId in (select a.MountPathId from #RMDriveViewWithOffline a, MMMountPath b with (readuncommitted)
		  											where a.MountPathId > 0
		  											and		a.MountPathId = b.MountPathId
		  											and	 (b.Attribute & 1 /*MNTPTH_ATTRIB_BUFFERED_IO*/ > 0)
		  											and 	b.MountPathTypeId <> @MOUNT_PATH_DYNAMIC_SHARED)
			select @NumDriveView = @NumDriveView - @@rowcount
			if @NumDriveView = 0
			begin
set @o_ErrorCode = 502
set @o_FailureType = 1
			  GOTO EXIT_AND_RETURN
			end
		end
		*/
		--
		-- Metallic license check
		--
		DECLARE @lt_MetallicDevices TABLE (MountPathId INT, LicenseType INT)
		INSERT INTO @lt_MetallicDevices
		SELECT 	DISTINCT T.MountPathId, MS.LicenseType
		FROM	#RMDriveViewWithOffline T,
				MMMetallicStorage MS with(readuncommitted)
		WHERE	T.MountPathId > 0
				AND	T.MountPathId = MS.MountPathId
		IF @@ROWCOUNT > 0
		BEGIN
			DECLARE @metallicLicenseType INT = 0
			DECLARE @licErrorCode INT = 0
			DECLARE MetallicLicenseCur Cursor LOCAL FORWARD_ONLY FOR
			SELECT 	DISTINCT T.LicenseType
			FROM	@lt_MetallicDevices T
			OPEN MetallicLicenseCur
			FETCH NEXT FROM MetallicLicenseCur INTO @metallicLicenseType
			WHILE @@FETCH_STATUS = 0
			BEGIN
				EXEC @licErrorCode = LicIsUsageBasedValid 0 /*appType*/, 0 /*jobId*/, @metallicLicenseType
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				END
				if @licErrorCode <> 0
				begin
					UPDATE 	#RMDriveViewWithOffline
					SET		FailureErrorCode = @licErrorCode
					WHERE	FailureErrorCode = 0
							AND	MountPathId in (select MountPathId from @lt_MetallicDevices where LicenseType = @metallicLicenseType)
					select @NumDriveView = @NumDriveView - @@rowcount
					if @NumDriveView = 0
					begin
					  set @o_ErrorCode = @licErrorCode
set @o_FailureType = 1
					  GOTO EXIT_AND_RETURN
					end
				end
				FETCH NEXT FROM MetallicLicenseCur INTO @metallicLicenseType
			END
			CLOSE MetallicLicenseCur
			DEALLOCATE MetallicLicenseCur
		END
		-- Check for Mount Path
		declare @mediaAgentMountPathList table ( clientId int, id int, MountPathTypeId int, Attribute int )
		insert into @mediaAgentMountPathList
		select a.MAClientid, a.MountPathId, b.MountPathTypeId, b.Attribute
		from	#RMDriveViewWithOffline a, MMMountPath b with (readuncommitted)
		where a.MountPathId > 0
		and		a.MountPathId = b.MountPathId
		while exists (select * from @mediaAgentMountPathList)
		begin
			select top 1 @mediaAgentId = clientId from @mediaAgentMountPathList
			-- check DDO license
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @mediaAgentId, 84, 1020, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 504
			  WHERE	FailureErrorCode = 0
			  AND		MountPathId in (select Id from @mediaAgentMountPathList where clientId = @mediaAgentId
										 and
											(MountPathTypeId in ( @MOUNT_PATH_MAGNETIC)
											 OR
											 	(MountPathTypeId in (@MOUNT_PATH_SHARED_STATIC, @MOUNT_PATH_SHARED_REPLICA) AND
											 		EXISTS (select value from MMConfigs with (NOLOCK) where name = 'MMCONFIG_RESOURCEMANAGER_DDO_LIC_CHECK_FOR_SHARE_AND_REPLICA' and value = 1)
												)
											)
										)
				select @NumDriveView = @NumDriveView - @@rowcount
				if @NumDriveView = 0
				begin
set @o_ErrorCode = 504
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			-- check ynamic Mount Path license
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @mediaAgentId, -1, 1044, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 503
			  WHERE	FailureErrorCode = 0
			  AND		MountPathId in (select Id from @mediaAgentMountPathList where clientId = @mediaAgentId and MountPathTypeId = @MOUNT_PATH_DYNAMIC_SHARED)
				select @NumDriveView = @NumDriveView - @@rowcount
				if @NumDriveView = 0
				begin
set @o_ErrorCode = 503
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			--Check for Cloud Storage
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @mediaAgentId, 190, 1113, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 528
			  WHERE	FailureErrorCode = 0
			  AND		MountPathId in (select Id from @mediaAgentMountPathList where clientId = @mediaAgentId
			  											 and MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
				select @NumDriveView = @NumDriveView - @@rowcount
				if @NumDriveView = 0
				begin
set @o_ErrorCode = 528
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			delete @mediaAgentMountPathList where clientId = @mediaAgentId
		end
		declare @centeraMountPathAndDrivePoolId table (MountPathId int, DrivePoolId int)
		declare @centeraDrivePoolId int
		insert into @centeraMountPathAndDrivePoolId
		select distinct a.MountPathId, a.DrivePoolId
		from #RMDriveViewWithOffline a, MMMountPath b with (readuncommitted)
		where a.MountPathId = b.MountPathId
		and		b.MountPathTypeId = @MOUNT_PATH_CENTERA
		set @centeraDrivePoolId = 0
		while exists (select * from @centeraMountPathAndDrivePoolId)
		begin
			select top 1 @centeraDrivePoolId = DrivePoolId from @centeraMountPathAndDrivePoolId
			-- check Centera license
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @centeraDrivePoolId, 71, 1010, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE #RMDriveViewWithOffline
SET		FailureErrorCode = 506
			  WHERE	FailureErrorCode = 0
			  AND		DrivePoolId = @centeraDrivePoolId
				select @NumDriveView = @NumDriveView - @@rowcount
				if @NumDriveView = 0
				begin
set @o_ErrorCode = 506
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			delete @centeraMountPathAndDrivePoolId where DrivePoolId = @centeraDrivePoolId
		end
	end
	/*
	** The priority of filter check should use following rules:
	** 1. DataPath related first, because if any of such check fails the whole data path is unusable.
	**		-- Master Pool
	**		-- Drive Pool
	**		-- Library
	** 2. Hard error. It means resources are offline.
	** 3. Soft error. It means resources are busy.
	**
	*/
-- *********************************************************************************  --
--                                                                      							--
-- 	The following check should be related to Data Path directly.											--
--	In this case, if any of the error happens, the whole data path become unusable.		--
--																																										--
--																																										--
-- *********************************************************************************  --
	-- In this case additional drive is required
	IF @i_IsForSwap = 0
	BEGIN
	  ---------------------------------------------------
	  -- Filter: check for total drives in the master pool --
	  ---------------------------------------------------
		declare @masterPoolReservations table (MasterPoolId int, ReservationCount int)
		insert into @masterPoolReservations
		select	a.MasterPoolId, COUNT(DISTINCT r.ReservationId)
		from	RMDatapathView a, MMResource r with (readuncommitted)
		where	a.FailureErrorCode = 0
		and		r.HasJobInterrupted = 0
		and		a.MasterPoolId = r.MasterPoolId
		group by a.MasterPoolId
		set @CheckPriority = @CheckPriority + 1
		update	#RMDriveViewWithOffline
set			FailureErrorCode = 279,
						FailurePriority = @CheckPriority
		from		#RMDriveViewWithOffline a, MMMasterPool mp with (readuncommitted), @masterPoolReservations b
		where		FailureErrorCode = 0
		and			a.MasterPoolId = b.MasterPoolId
		and			mp.MasterPoolId = a.MasterPoolId
		and			mp.TotalDrives <= b.ReservationCount
		set @NumDriveView = @NumDriveView - @@rowcount
		if @NumDriveView = 0
		begin
set @o_ErrorCode = 279
set @o_FailureType = 1
				goto EXIT_AND_RETURN
		end
	  	---------------------------------------------------
	  	-- Filter: master pool's drive allocation policy --
	  	---------------------------------------------------
		set @CheckPriority = @CheckPriority + 1
		-- For non-magnetic library
		update	#RMDriveViewWithOffline
set			FailureErrorCode = 296,
						FailurePriority = @CheckPriority
		where		FailureErrorCode = 0
		and			MountPathId = 0
		and			MasterPoolId in
	  				( select MasterPoolId from RMDatapathView
	  					where		MPMaxSwitchForHost = 0
	  					or
	  					(
		  					MPMaxSwitchForHost > 0
								and 		MPMaxSwitchForHost <= (select ReservationCount from @masterPoolReservations where MasterPoolId = RMDataPathView.MasterPoolId)
							)
						)
	  	set @NumDriveView = @NumDriveView - @@rowcount
		if @NumDriveView = 0
	  	begin
set @o_ErrorCode = 296
set @o_FailureType = 1
				goto EXIT_AND_RETURN
		end
if @i_accessType <> 1
	  begin
		delete @masterPoolReservations
		insert into @masterPoolReservations
		select	a.MasterPoolId, COUNT(DISTINCT r.ReservationId)
		from	RMDatapathView a, MMResource r with (readuncommitted)
		where	a.FailureErrorCode = 0
		and		a.MasterPoolId = r.MasterPoolId
		and		r.IntrJobId_l = 0
and		r.LibraryTypeId = 3
and		(r.ReservationType & 2) = 2
		group by a.MasterPoolId
		  -- For magnetic library
		  update	#RMDriveViewWithOffline
set			FailureErrorCode = 297,
							FailurePriority = @CheckPriority
		  where		FailureErrorCode = 0
		  and			MountPathId > 0
		  and			MasterPoolId in
		  				(	select MasterPoolId from RMDataPathView
							  where		MPMaxSwitchForHost = 0
							  or
							  (
							  	MPMaxSwitchForHost > 0
									and			MPMaxSwitchForHost  <= (select ReservationCount from @masterPoolReservations where MasterPoolId = RMDataPathView.MasterPoolId)
								)
							)
		  set @NumDriveView = @NumDriveView - @@rowcount
		  if @NumDriveView = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 1
			    goto EXIT_AND_RETURN
			end
		end
	  ---------------------------------------------------
	  -- Filter: drive pool's drive allocation policy --
	  ---------------------------------------------------
		declare @drivePoolReservations table (DrivePoolId int, ReservationCount int)
		insert into @drivePoolReservations
		select	a.DrivePoolId, COUNT(DISTINCT r.ReservationId)
		from	RMDatapathView a, MMResource r with (readuncommitted)
		where	a.FailureErrorCode = 0
		and		r.HasJobInterrupted = 0
		and		a.DrivePoolId = r.DrivePoolId
		group by a.DrivePoolId
		set @CheckPriority = @CheckPriority + 1
		-- For non-magnetic library
	  update	#RMDriveViewWithOffline
set			FailureErrorCode = 296,
						FailurePriority = @CheckPriority
	  where		FailureErrorCode = 0
	  and			MountPathId = 0
	  and			DrivePoolId in
	  				(	select DrivePoolId from RMDataPathView
						  where		DPMaxDrivestoSwitch = 0
						  or
						  (
						  	DPMaxDrivestoSwitch > 0
								and			DPMaxDrivestoSwitch <= (select ReservationCount from @drivePoolReservations where DrivePoolId = RMDataPathView.DrivePoolId)
							)
						)
	  set @NumDriveView = @NumDriveView - @@rowcount
	  if @NumDriveView = 0
	  begin
set @o_ErrorCode = 296
set @o_FailureType = 1
		    goto EXIT_AND_RETURN
		end
if @i_accessType <> 1
	  begin
		delete @drivePoolReservations
		insert into @drivePoolReservations
		select	a.DrivePoolId, COUNT(DISTINCT r.ReservationId)
		from	RMDatapathView a, MMResource r with (readuncommitted)
		where	a.FailureErrorCode = 0
		and		a.DrivePoolId = r.DrivePoolId
		and		r.IntrJobId_l = 0
and		r.LibraryTypeId = 3
and		(r.ReservationType & 2) = 2
		group by a.DrivePoolId
		  -- For magnetic library
		  update	#RMDriveViewWithOffline
set			FailureErrorCode = 297,
							FailurePriority = @CheckPriority
		  where		FailureErrorCode = 0
		  and			MountPathId > 0
		  and			DrivePoolId in
		  				(	select	DrivePoolId from RMDataPathView
		  					where		DPMaxDrivestoSwitch = 0
		  					or
		  					(
		  						DPMaxDrivestoSwitch > 0
									and			DPMaxDrivestoSwitch <= (select ReservationCount from @drivePoolReservations where DrivePoolId = RMDataPathView.DrivePoolId)
								)
							)
		  set @NumDriveView = @NumDriveView - @@rowcount
		  if @NumDriveView = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 1
			    goto EXIT_AND_RETURN
			end
		end
	  ---------------------------------------------------
	  -- Filter: Library RestrictActivity status			 --
	  ---------------------------------------------------
		set @CheckPriority = @CheckPriority + 1
		DECLARE @DriveInActionList	TABLE ( DriveId int, MasterPoolId int)
		INSERT INTO @DriveInActionList
    	SELECT DISTINCT R.DriveId, D.MasterPoolId
    	FROM MMResource AS R with (readuncommitted), MMDrive AS D WITH (READUNCOMMITTED)
   		WHERE R.DriveId = D.DriveId
   		AND 	((R.MediaId != D.MediaId) OR
(D.MountStatus in (2, 3)))
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20006,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMLibrary l WITH (READUNCOMMITTED)
		WHERE		a.FailureErrorCode = 0
		AND			a.LibraryId > 0
		AND			a.LibraryId = l.LibraryId
		AND			l.RestrictActivity > 0
		AND			l.RestrictActivity <= (	SELECT COUNT(*) FROM @DriveInActionList WHERE MasterPoolId = a.MasterPoolId )
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20006
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END -- isForSwap = 0 end
-- *********************************************************************************  --
--                                                                      							--
-- 	The following check should be related to the hardware status											--
--	It means resources are offline.																										--
--																																										--
--																																										--
-- *********************************************************************************  --
  ---------------------------------------------------
  -- Filter: check for DriveController status			 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	-- One Drive Controller offline doesn't mean the data path is unusable
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = CASE WHEN MediaId > 0 THEN 20038
ELSE 465
															END,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMDriveController dc WITH (READUNCOMMITTED)
	WHERE		a.FailureErrorCode = 0
	AND			a.MountPathId = 0
	AND			a.DriveControllerId = dc.DriveControllerId
	AND			(
							dc.DriveControllerSoftState <> 1
					OR	dc.DriveControllerEnabled <> 1
					OR	dc.DriveAccessible <> 1
					)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 701
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
	---------------------------------------------------
  -- Filter: check for MMMountPath 	status				 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = CASE WHEN (mp.Attribute & 2 > 0 AND @i_AccessType = 2)
THEN 20075
WHEN (mp.MaxConcurrentWriters = 0 AND @i_AccessType = 2)	THEN 42024
										WHEN (mp.IsOffline <> 0 AND (@jobOpType <> @ARCHIVECHECK OR mp.OfflineReason <> 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/))
THEN 312
WHEN mp.IsEnabled <> 1	THEN 395
										ELSE 0
									END,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED)
	WHERE		a.FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.MountPathId = mp.MountPathId
	AND			(	mp.IsEnabled <> 1
				or	(mp.IsOffline <> 0 AND (@jobOpType <> @ARCHIVECHECK OR mp.OfflineReason <> 6 /*MOUNTPATH_MARKED_PERMANENTLY_OFFLINE_BY_USER*/))
or  ( mp.Attribute & 2 > 0 AND @i_AccessType = 2)
or	( mp.MaxConcurrentWriters = 0 and @i_AccessType = 2))
	AND	NOT EXISTS (
						SELECT 1 FROM MMHost H WHERE H.clientId = a.HostClientId AND H.MmHostEnabled = 1 AND
H.Attribute & 32768 > 0 AND
							  H.OfflineReason = 7 /*HOST_STATUS_POWER_MANAGED_VM*/ AND
							  H.MmHostSoftState = 0 AND @isPowerVMFeatureEnabled > 0
					)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 312
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------
  -- Filter: check for MMMountPath 	free space		 --
  ---------------------------------------------------
IF @i_AccessType = 2
	BEGIN
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20174,
					FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMLibrary l WITH (READUNCOMMITTED)
		WHERE		a.FailureErrorCode = 0
		AND			a.LibraryId > 0
		AND			a.LibraryId = l.LibraryId
AND			(l.ExtendedAttributes & (67108864 | 134217728)) = (67108864 | 134217728)
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20174
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
DECLARE @minFreeSpaceMB int = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED) WHERE name = 'RM_CONFIG_MIN_MP_FREE_SPACE_OVER_RESERVE_LIMIT'), 1024)
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20011,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED), MMMediaSide ms WITH (READUNCOMMITTED)
		WHERE		a.FailureErrorCode = 0
		AND			a.MountPathId > 0
		AND			a.MountPathId = mp.MountPathId
		AND			ms.MediaSideId = mp.MediaSideId
		AND			ms.FreeBytesMB < (mp.MagneticSpaceRsrvInMB + @minFreeSpaceMB)
		AND 		NOT EXISTS(SELECT 1 FROM @lt_MetallicDevices MD WHERE MD.MountPathId = mp.MountPathId)
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20011
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20010,
						FailurePriority = @CheckPriority
		FROM		MMMountPath mp WITH (READUNCOMMITTED), #RMDriveViewWithOffline a
					LEFT OUTER JOIN (SELECT MediaId, COUNT(ReservationId) NumCurReservs FROM MMResource WITH(READUNCOMMITTED)
						WHERE HasJobInterrupted = 0 AND (ReservationType & 2) = 2 GROUP BY MediaId) AS RS
						ON a.MediaId = RS.MediaId
		WHERE		a.FailureErrorCode = 0
		AND			a.MountPathId > 0
		AND			a.MountPathId = mp.MountPathId
		AND			mp.maxDataToWriteMB > 0
AND			(dbo.MMS2FUNC_GetMediaValidData(a.MediaId) /(1024 * 1024) + (4096 * (ISNULL(RS.NumCurReservs, 0) + 1))) > mp.maxDataToWriteMB
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20010
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
  ---------------------------------------------------
  -- Filter: check for MMDevice Status						 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 317,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED)
	WHERE		FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.MountPathId = mp.MountPathId
	AND			a.DeviceId = 0
	AND			mp.MountPathTypeId in	(@MOUNT_PATH_DYNAMIC_SHARED, @MOUNT_PATH_SHARED_STATIC,
																 @MOUNT_PATH_SHARED_REPLICA, @MOUNT_PATH_DRU, @MOUNT_PATH_EXTERNAL_REMOTE_HOST)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 317
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = CASE WHEN d.DeviceBroken = 1			THEN 442
WHEN d.DeviceEnabled <> 1		THEN 441
																	ELSE 0
															END,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMDevice d WITH (READUNCOMMITTED)
	WHERE		a.FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.DeviceId > 0
	AND			a.DeviceId = d.DeviceId
	AND			(	d.DeviceBroken = 1
				OR	d.DeviceEnabled <> 1)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 318
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------
  -- Filter: check for MMDeviceController Status	 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = CASE WHEN a.DeviceControllerId = 0		THEN 317
WHEN dc.DeviceControllerEnabled <> 1	THEN 456
WHEN dc.DeviceAccessible <> 1		THEN 456
ELSE 463
															END,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMDeviceController dc WITH (READUNCOMMITTED)
	WHERE		a.FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.DeviceId > 0
	AND			(	a.DeviceControllerId = 0
						OR
						(
							a.DeviceControllerId = dc.DeviceControllerId
							AND (	dc.DeviceControllerEnabled <> 1
									OR	dc.DeviceAccessible <> 1
OR	( ( (dc.DeviceAccessType & 2) = 0 ) AND @i_accessType = 2))
						)
					)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 317
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------------------
  -- Filter: check for Mount Reserve Status	for Dynamic Shared --
  ---------------------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	-- If the library is dynamic shared, and curently reserved,
	-- disable other MAs except the one reservaing the mount path.
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 457,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED)
	WHERE		FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.MountPathId = mp.MountPathId
	AND			mp.MountPathTypeId in	(@MOUNT_PATH_DYNAMIC_SHARED)
	AND			EXISTS (SELECT * FROM MMResource with (readuncommitted) WHERE HasJobInterrupted = 0
									AND MediaId = a.MediaId AND ClientId != a.HostClientId)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 457
set @o_FailureType = 2
		GOTO EXIT_AND_RETURN
	END
	set @CheckPriority = @CheckPriority + 1
	-- If the dynamic shared mount path reserved, and device controller has VolumeScsiReserved as 0
	-- and not exists reservation for current job, diable the mount path.
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 457,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED), MMDeviceController dc WITH (READUNCOMMITTED)
	WHERE		FailureErrorCode = 0
	AND			a.MountPathId > 0
	AND			a.MountPathId = mp.MountPathId
	AND			mp.MountPathTypeId in	(@MOUNT_PATH_DYNAMIC_SHARED)
	AND			a.DeviceControllerId = dc.DeviceControllerId
	AND			dc.VolumeScsiReserved = 0
	AND			EXISTS (SELECT * FROM MMResource with (readuncommitted) WHERE HasJobInterrupted = 0
									AND MediaId = a.MediaId AND ClientId = a.HostClientId)
	AND			NOT EXISTS (SELECT MMResourceToJob.JobId_l
							FROM MMResourceToJob with (readuncommitted), MMResource with (readuncommitted)
							WHERE MMResourceToJob.JobId_l = @i_JobId
							AND MMResourceToJob.ReservationId = MMResource.ReservationId
							AND MMResource.HasJobInterrupted = 0 AND MMResource.MediaId = a.MediaId)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 457
set @o_FailureType = 2
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------
  -- Filter: check for MMMedia Status for magnetic --
  ---------------------------------------------------
IF @i_AccessType = 2
	BEGIN
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 458,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMMedia m with (readuncommitted)
		WHERE		FailureErrorCode = 0
		AND			a.MountPathId > 0
		AND			a.MediaId = m.MediaId
		AND			m.MediaFlags = 4 --MEDIA_FLAG_READONLY
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 458
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
  ---------------------------------------------------
  -- Filter: check for Job Option for drive				 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	-- For tape erase job, it will go through read reservation logic but reservation type should be write.
	-- Job options in tape erase case will be similar to read operations.
IF @i_accessType = 2 AND @jobOpType != @TAPEERASE
	BEGIN
		INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(@i_jobId, 1238677445) as int)
		DELETE @jobOptionDriveIdList WHERE DriveId = 0
	END
	ELSE
	BEGIN
		INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(@i_jobId, 785491355) as int)
		DELETE @jobOptionDriveIdList WHERE DriveId = 0
	END
	if exists (select * from @jobOptionDriveIdList)
	begin
	 	if @isDebug > 0
		begin
			set @debugDetail = cast(isnull((select 'Drive Id' name, DriveId from @jobOptionDriveIdList
																			for XML RAW('JobOptions'), TYPE), 'NULL') as nvarchar(max))
			insert into RMLogger values ('RMGetDriveView', @debugDetail, @i_RequestId, getutcdate())
		end
		if @jobOpType NOT IN (@RST, @INDEXRESTORE)
		or not exists (select * from MMConfigs WITH (NOLOCK) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_USE_DIFF_MA_AND_DRIVEPOOL' and value > 0)
		begin
			update	#RMDriveViewWithOffline
set			FailureErrorCode = 20047,
							FailurePriority = @CheckPriority
			where		FailureErrorCode = 0
			and			DriveId not in ( select DriveId from @jobOptionDriveIdList where DriveId > 0)
			SET @NumDriveView = @NumDriveView - @@ROWCOUNT
			IF @NumDriveView = 0
			BEGIN
SET @o_ErrorCode = 20047
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			END
		end
	end
  ---------------------------------------------------
  -- Filter: check for Drive Status								 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = CASE WHEN a.MediaId > 0 THEN 20002
ELSE 40008
															END,
						FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMDrive d WITH (READUNCOMMITTED)
	WHERE		FailureErrorCode = 0
	AND			a.DriveId = d.DriveId
	AND			(
						--TODO : Add support for DriveValidation, DriveCleaning, StampMedia later
						(a.LibrarySubType <> @CV_LIBSUBTYPE_LIBRARY_SERVER AND d.DriveSoftState <> 1)
						OR
						(a.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER AND d.DriveSoftState <> 1 AND d.OfflineReason <> @DRIVE_STATUS_NOT_ALLOTED_BY_LIBRARY_SERVER)
						OR	d.DriveEnabled <> 1
						OR	d.DriveBroken <> 0
					)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
IF EXISTS (SELECT * FROM #RMDriveViewWithOffline WHERE FailureErrorCode = 20002 AND FailurePriority = @CheckPriority )
SET @o_ErrorCode = 20002
		ELSE
SET @o_ErrorCode = 276
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------
  -- Filter: check for Drive Read-Only flag				 --
  ---------------------------------------------------
IF @i_AccessType <> 1
	BEGIN
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode	= 845,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMDrive d WITH (READUNCOMMITTED)
		WHERE		FailureErrorCode = 0
		AND			a.DriveId = d.DriveId
AND			d.Attributes & 128 > 0
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 845
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
  ---------------------------------------------------
  -- Filter: check for Mark for Maintenance				 --
  ---------------------------------------------------
	IF @isMaintenanceJob <> 1
	BEGIN
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20036,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMHost h WITH (READUNCOMMITTED)
		WHERE		a.FailureErrorCode = 0
		AND			(a.HostClientId = h.ClientId OR a.MAClientId = h.ClientId)
AND			(h.Attribute & 16 > 0)
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20046
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20037,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMLibrary l WITH (READUNCOMMITTED)
		WHERE		a.FailureErrorCode = 0
		AND			a.LibraryId = l.LibraryId
AND			(l.ExtendedAttributes & 512) <> 0
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20046
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode	= 20035,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMDrive d WITH (READUNCOMMITTED)
		WHERE		FailureErrorCode = 0
		AND			a.DriveId = d.DriveId
AND			d.Attributes & 256 > 0
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 20046
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
  ---------------------------------------------------
  -- Filter: check for Drive need clean						 --
  ---------------------------------------------------
	IF @isDriveCleaningJob <> 1
	BEGIN
		set @CheckPriority = @CheckPriority + 1
		UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode	= 793,
						FailurePriority = @CheckPriority
		FROM		#RMDriveViewWithOffline a, MMDrive d WITH (READUNCOMMITTED), MMLibrary l WITH (READUNCOMMITTED)
		WHERE		FailureErrorCode = 0
		AND			a.DriveId = d.DriveId
		AND			a.LibraryId = l.LibraryId
		AND			d.CleaningRequired = 1
		AND			(
(l.LibraryAttribute & 2048 > 0 AND @jobOpType NOT IN (@RST, @INDEXRESTORE))
						OR
l.LibraryAttribute & 2048 = 0
					)
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 793
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
-- *********************************************************************************  --
--                                                                      							--
-- 	The following check should be related to the soft errors.													--
--	It means resource are busy for the time being																			--
--																																										--
--																																										--
-- *********************************************************************************  --
	---------------------------------------------------
  -- Filter: mount path's drive allocation policy --
  ---------------------------------------------------
IF @i_IsForSwap = 0 AND @i_AccessType = 2
	BEGIN
		declare @mountPathReservations table (MediaId int, ReservationCount int)
		insert into @mountPathReservations
		select	a.MediaId, COUNT(DISTINCT r.ReservationId)
		from	#RMDriveViewWithOffline a, MMResource r with (readuncommitted)
		where	a.FailureErrorCode = 0
		and		a.MountPathId > 0
		and		r.HasJobInterrupted = 0
and		(r.ReservationType & 2) = 2
		and		a.MediaId = r.MediaId
		group by a.MediaId
		set @CheckPriority = @CheckPriority + 1
		-- Perform the check for all the mount path always
		--IF @i_numStreams <= 1 OR @i_bestcaseReserve = 1
		BEGIN
			UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 297,
							FailurePriority = @CheckPriority
			FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED)
			WHERE		FailureErrorCode = 0
			AND			a.MountPathId > 0
			AND			a.MountPathId = mp.MountPathId
			AND			mp.MaxConcurrentWriters <=
							 isnull( (SELECT ReservationCount FROM @mountPathReservations WHERE MediaId = a.MediaId), 0)
		END
		/* There is no need to to the following since we can switch mount path within a job and correct check is in later logic.
		ELSE
		BEGIN
			UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 297,
							FailurePriority = @CheckPriority
			FROM		#RMDriveViewWithOffline a, MMMountPath mp WITH (READUNCOMMITTED)
			WHERE		FailureErrorCode = 0
			AND			a.MountPathId > 0
			AND			a.MountPathId = mp.MountPathId
			AND			mp.MaxConcurrentWriters <
							 (
								 isnull( (SELECT ReservationCount FROM @mountPathReservations WHERE MediaId = a.MediaId), 0)
							) + @i_numStreams
		END
		*/
		SET @NumDriveView = @NumDriveView - @@ROWCOUNT
		IF @NumDriveView = 0
		BEGIN
SET @o_ErrorCode = 297
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
	END
  ---------------------------------------------------
  -- Filter: check for Drive Mount Status					 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 20001,
						FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline a, MMDrive d WITH (READUNCOMMITTED)
	WHERE		FailureErrorCode = 0
	AND			a.DriveId = d.DriveId
AND			d.MountStatus in (4, 2, 3)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 20006
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  ---------------------------------------------------
  -- Filter: drive is reserved										 --
  ---------------------------------------------------
	set @CheckPriority = @CheckPriority + 1
	UPDATE	#RMDriveViewWithOffline
SET			FailureErrorCode = 258,
					FailurePriority = @CheckPriority
	FROM		#RMDriveViewWithOffline A
	WHERE		FailureErrorCode = 0
	AND			MountPathId = 0
	AND			DriveId > 0
	AND			EXISTS (SELECT MMResource.ReservationId
						FROM MMResource with (readuncommitted), MMResourceToJob with (readuncommitted)
						WHERE	MMResource.DriveId = A.DriveId
						AND		MMResource.ReservationId  = MMResourceToJob.ReservationId
						--AND		MMResourceToJob.ReserveBitMask in
						--		(RM_JM_RESERVED, RM_MM_RESERVED, (RM_JM_RESERVED | RM_DM_RESERVED), (RM_MM_RESERVED | RM_DM_RESERVED))
						)
	SET @NumDriveView = @NumDriveView - @@ROWCOUNT
	IF @NumDriveView = 0
	BEGIN
SET @o_ErrorCode = 276
set @o_FailureType = 2
		GOTO EXIT_AND_RETURN
	END
EXIT_AND_RETURN:
IF @NumDriveView = 0 AND @o_ErrorCode = 0
SET @o_ErrorCode = 807
DECLARE @MaxMPFreeSpaceMB bigint
DECLARE @FreeSpaceDiffMB bigint
SELECT 	@MaxMPFreeSpaceMB = MAX(MS.FreeBytesMB)
FROM	#RMDriveViewWithOffline a
		INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = a.MountPathId
		INNER JOIN MMMediaSide MS WITH (READUNCOMMITTED) ON MS.MediaSideId = MP.MediaSideId
WHERE	a.MountPathId > 0
SET @FreeSpaceDiffMB = ISNULL((SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_FREE_SPACE_DIFF_IN_GB_TO_CONSIDER_FOR_PREFER_MOUNT_PATH'), 10) * 1024
INSERT INTO #tmpRMDriveViewWithOffline
SELECT a.*
FROM #RMDriveViewWithOffline a LEFT OUTER JOIN MMDeviceController DC WITH (READUNCOMMITTED)
	ON a.DeviceControllerId > 0 AND a.DeviceControllerId = DC.DeviceControllerId
WHERE	a.MountPathId > 0
ORDER BY a.DataPathId,
				CASE WHEN exists (select DriveId from @jobOptionDriveIdList WHERE DriveId = a.DriveId) THEN 0 ELSE 1 END,
				CASE WHEN a.LibrarySubType <> @CV_LIBSUBTYPE_LIBRARY_SERVER THEN 0
				ELSE
				(
CASE WHEN (a.DriveAttributes & 512 = 512)
					THEN 1 ELSE 2 END
				)
				END,
				-- When prefer mountPaths with more free space is set then pick mount paths having more free space
				-- If the difference of free space between mount paths is less than 10GB then we do round robin among them.
CASE WHEN (a.RMStatus & 4194304) = 0 THEN 0 ELSE
					(select  (@MaxMPFreeSpaceMB - FreeBytesMB) / @FreeSpaceDiffMB from MMMediaSide MS WITH (READUNCOMMITTED) INNER JOIN MMMountPath MP WITH (READUNCOMMITTED)
						ON MS.MediaSideId = MP.MediaSideId where MP.MountPathId = a.MountPathId) END,
				-- If use preferred is set then pick the preferred first
(CASE WHEN (a.RMStatus & 16777216) = 0 THEN 0 ELSE (ISNULL(DC.DeviceAccessType, 0) & 8) END) DESC,
CASE WHEN (a.RMStatus & 1) = 0 THEN 0 ELSE SIGN(a.MagNumReservations) END,	-- If Round-Robin, non-Reserved first
(CASE WHEN (a.RMStatus & 1) = 0 THEN a.LastUseTime ELSE 0 END) DESC,			-- If not Round-Robin, last used one first
				a.MagNumReservations,													-- If Round-Robin, must reserved first. Otherwise, based on NumberOfWriters.
CASE WHEN (a.RMStatus & 1) = 0 THEN 0 ELSE a.LastUseTime END,					-- If Round-Robin, less used one first
				a.MagNumReused,															-- NumberOfReUses
				(CASE WHEN a.MountPathId > 0 THEN a.MediaId ELSE 0 END ) DESC			-- Magnetic MediaId
--UNION ALL
INSERT INTO #tmpRMDriveViewWithOffline
SELECT *
FROM #RMDriveViewWithOffline
WHERE MountPathId = 0 AND FailureErrorCode != 0
INSERT INTO #tmpRMDriveViewWithOffline
SELECT a.*
FROM #RMDriveViewWithOffline a
--LEFT OUTER JOIN MMMedia m  WITH (READUNCOMMITTED) ON a.MediaId = m.MediaId
--LEFT OUTER JOIN MMVolume v  WITH (READUNCOMMITTED) ON a.MediaId = v.MediaId
--LEFT OUTER JOIN ArchStream s  WITH (READUNCOMMITTED) ON v.MediaGroupId = s.MediaGroupId
WHERE a.MountPathId = 0 AND FailureErrorCode = 0
ORDER BY a.DataPathId,
				CASE WHEN exists (select DriveId from @jobOptionDriveIdList WHERE DriveId = a.DriveId) THEN 0 ELSE 1 END,
				CASE WHEN a.LibrarySubType <> @CV_LIBSUBTYPE_LIBRARY_SERVER THEN 0
				ELSE
				(
CASE WHEN (a.DriveAttributes & 512 = 512) THEN
							(
								--LS Drive that is available to use has higher precedence
								CASE WHEN (SELECT DriveSoftState FROM MMDrive WITH (NOLOCK) WHERE DriveId = a.DriveId) = 1 THEN
									1
								ELSE
									3
								END
							)
					ELSE
							(
								--LS Drive that is available to use has higher precedence
								CASE WHEN (SELECT DriveSoftState FROM MMDrive WITH (NOLOCK) WHERE DriveId = a.DriveId) = 1 THEN
									2
								ELSE
									4
								END
							)
					END
				)
				END,
				-- for read reservation, prefer read only drive first
CASE WHEN @i_accessType = 1
AND EXISTS (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE DriveId = a.DriveId AND Attributes & 128 > 0)
					THEN 0 ELSE 1 END,
	  		-- prefer empty drives for reads or if reservation type is not known
CASE WHEN @i_accessType != 2 THEN SIGN(a.MediaId) ELSE 0 END,
	  		-- prefer active media which belongs to the current media group
				-- prefer appendable media if library option is set and media is from correct stream
CASE WHEN @i_accessType = 2 AND a.MediaId > 0 AND @i_CopyId > 0
	  					AND EXISTS (SELECT m.MediaId FROM MMMedia m  WITH (READUNCOMMITTED)
	  								where a.MediaId = m.MediaId
	  								AND m.MediaFlags = 1 AND m.IsInMediaGroup = 1
	  								)
	  					AND EXISTS (SELECT v.volumeid FROM MMVolume v  WITH (READUNCOMMITTED)
	  								WHERE a.MediaId = v.MediaId
	  								AND	 v.MediaGroupId > 0
	  								AND EXISTS (SELECT stream FROM ArchStream WITH (READUNCOMMITTED)
	  											WHERE ArchGroupCopyId = @i_CopyId
	  											AND MediaGroupid = v.MediaGroupId)
	  								)
						THEN (CASE	WHEN EXISTS (SELECT VolumeId FROM MMVolume WITH (READUNCOMMITTED)
										 WHERE MediaId = a.MediaId
										 AND VolumeFlags = 1)
									 THEN 0
									 WHEN EXISTS (SELECT VolumeId FROM MMVolume WITH (READUNCOMMITTED)
											WHERE MediaId = a.MediaId
											AND VolumeFlags = 7 AND @i_UseAppendable > 0)
									 THEN 1
									 ELSE 2 END)
	  					ELSE 3 END,
						-- prefer spare media if writeable
CASE WHEN @i_accessType = 2
	  					AND EXISTS (SELECT MediaId
	  								FROM MMMedia WITH (READUNCOMMITTED)
	  								WHERE a.MediaId = MediaId
			  						AND MediaFlags = 1 AND IsInMediaGroup = 0)
			  			THEN 0 ELSE 1 END,
			  -- prefer empty drives for writes if none of the other media in the other drives is useable
CASE WHEN @i_accessType = 2 AND a.MediaId = 0
			  			THEN 0 ELSE 1 END,
			  -- otherwise sort by lastusetime
			  a.LastUseTime
GO


IF EXISTS (select * from GxQscripts where name = 'RMGetDriveView')
	delete from GxQscripts where name = 'RMGetDriveView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetDriveView')
	delete from GXDBVersions where aliasname = 'RMGetDriveView'
GO

insert into GXDBVersions values(2, 'RMGetDriveView',  '00010058000200150000', 'RMGetDriveView', '00010058000200150000')
GO

