

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMGetDataPathViewForWrite.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMGetDataPathViewForWrite.sp,v $ $Id: RMGetDataPathViewForWrite.sp,v 1.35.32.15 2020/03/31 12:11:47 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMGetDataPathViewForWrite()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMGetDataPathViewForWrite')
BEGIN
	print '>>> Drop Stored Procedure: RMGetDataPathViewForWrite <<<'
	drop procedure RMGetDataPathViewForWrite
END
IF EXISTS (select * from GxQscripts where name='RMGetDataPathViewForWrite')
	delete from GxQscripts where name = 'RMGetDataPathViewForWrite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetDataPathViewForWrite')
	delete from GXDBVersions where aliasname = 'RMGetDataPathViewForWrite'
GO
print '... Creating Procedure: RMGetDataPathViewForWrite'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMGetDataPathViewForWrite
  @i_RequestId int,
  @i_CopyId int,
  @i_JobId int,
  @i_JobType int,
  @i_AppNum int,
  @i_AppType int,
  @i_Datatype int,
  @i_BkpLevel int,
  @i_UseSCDataPath int,
  @i_UsePreferredDP int,
  @i_FailoverFlags int,
  @i_IsForSILOBackup int,
  @i_hasJobDataPathOptions int,
  @i_inClientId int,
  @i_isForRemainingStreams int,
  @isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--:DECLARE o_ErrorCode			integer;
--:DECLARE o_FailureType			integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--set @o_FailureType = RM_FAILURE_JOB
  declare @BKPJOB int
  declare @RSTJOB	int
  declare @CSDRBKPJOB int
	declare @INDRSTJOB	int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  set @BKPJOB = 1
  set @RSTJOB = 2
  set @CSDRBKPJOB = 4
  set @INDRSTJOB = 5
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
	declare @o_perferredDataPathForCopy	integer
	declare @NumDataPathViews int
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	/*
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMGetDataPathView', 'Enter...', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select @i_CopyId copyId, @i_JobId jobId, @i_JobType jobType, @i_AppNum appNum, @i_AppType appType,
																	@i_DataType dataType, @i_BkpLevel bkpLevel, @i_IsForRemainingStreams isForRemainingStreams,
																	@i_UseSCDataPath useSCDataPath, @i_UsePreferredDP usePreferredDP, @i_IsForSILOBackup isForSILOBackup, @i_inClientId inClientId,
																	@i_addtionalFilter additionalFilter
															for XML RAW('Parameters'), TYPE), 'NULL') as varchar(max))
		insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	end
	*/
	IF OBJECT_ID('tempdb..#drivePoolReservationList') IS NOT NULL
	DROP TABLE #drivePoolReservationList
	create table #drivePoolReservationList (drivepoolid int, revCount int)
	declare @DRIVEVALIDATION integer
	declare @DRIVECLEANING integer
	declare @STAMPMEDIA integer
	set @DRIVEVALIDATION = 41
	set @DRIVECLEANING = 42
	set @STAMPMEDIA = 46
	declare @isMaintenanceJob int
	declare @jobOpType int
	set @isMaintenanceJob = 0
  set @jobOpType = dbo.GetJobTypeForJobID(@i_JobId)
  if @jobOpType = @DRIVEVALIDATION or @jobOpType = @DRIVECLEANING or @jobOpType = @STAMPMEDIA
    set @isMaintenanceJob = 1
	-- Physical Client id
	declare @physicalClientId int
	select	@physicalClientId = cast(attrVal as int)
	from		APP_ClientProp with (readuncommitted)
	where		componentNameId = @i_inClientId
	and			attrName = 'Active Physical Node'
	and			modified = 0
	if @physicalClientId is null or @physicalClientId = 0
		set @physicalClientId = @i_inClientId
  -----------------------------------
  -- Module: copy's data path view --
  -----------------------------------
  insert into RMDataPathView
  select @i_RequestId, a.DataPathId, a.Priority, a.DrivePoolId, f.Id,
  			 b.LibraryId, b.MasterPoolId, a.SpareGroupId, a.Flag, e.LibraryTypeId,
  			 b.MaxSwitchForHost, c.MaxDrivestoSwitch, d.MaxReservations,
  			 e.LibraryAttribute, e.ExtendedAttributes, e.RestrictActivity,
  			 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, e.LibrarySubType
  from MMDataPath a with (readuncommitted), MMMasterPool b with (readuncommitted), MMDrivePool c with (readuncommitted),
  MMHost d with (readuncommitted), MMLibrary e with (readuncommitted), app_client f with (readuncommitted)
  where	a.CopyId = @i_CopyId
  --and		(a.Flag & MMS2_ENABLED_FAILOVER) = MMS2_ENABLED_FAILOVER
AND		(a.Flag & 16) = 0
  and		a.DrivePoolId = c.DrivePoolId
  and		b.MasterPoolId = c.MasterPoolId
  and		b.LibraryId = e.LibraryId
  and		c.ClientId = d.ClientId
  and		f.id = d.ClientId
  /*
and (d.Attribute & 16) = 0
and (e.ExtendedAttributes & 512) = 0
  -- don't include preconfigured client
  and (f.status & 16384) = 0
  and d.mmhostsoftstate = 1
  and d.mmhostenabled = 1
  and b.MasterPoolSoftState	= 1
  and b.MasterPoolEnabled = 1
  and c.DrivePoolSoftState = 1
  and c.DrivePoolEnabled = 1
  and e.LibrarySoftState = 1
  and e.LibraryEnabled = 1
  and e.LibraryBroken = 0
	*/
	set @NumDataPathViews = @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
		if @i_IsForSILOBackup > 0
set @o_ErrorCode = 20050
		else
set @o_ErrorCode = 20016
    --set @o_FailureType = RM_FAILURE_SP
		GOTO EXIT_AND_RETURN
	end
	--For MA core package where in new core package that is being created (with minimal set of MA binaries to backup to cloud) will be installed on all laptops directly.
	--We don’t want thousands of these core MA to be in datapath list on SP Copy.
	--So making changes to allow backups to use this core MA when config param is set.
	IF @i_JobType = @BKPJOB
		AND EXISTS (SELECT 1 FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'RM_CONFIG_ALLOW_LAPTOPS_TO_BACKUP_DIRECTLY_TO_CLOUD' and value = 1)
		AND EXISTS(SELECT 1 FROM MMHost H WITH (READUNCOMMITTED) WHERE H.clientId IN (@i_inClientId, @physicalClientId))
		AND NOT EXISTS(SELECT 1 FROM RMDataPathView DP WITH (READUNCOMMITTED)
WHERE DP.RequestId = @i_RequestId AND DP.LibraryTypeId = 3
						AND DP.HostClientId IN (@i_inClientId, @physicalClientId))
		AND EXISTS (SELECT 1 FROM RMDataPathView DP WITH (READUNCOMMITTED), MMDrivePool LMADPool WITH (READUNCOMMITTED)
WHERE DP.RequestId = @i_RequestId AND DP.LibraryTypeId = 3
								AND DP.MasterPoolId = LMADPool.MasterPoolId
								AND LMADPool.clientId IN (@i_inClientId, @physicalClientId))
		AND @i_hasJobDataPathOptions = 0
	BEGIN
		--Populate datapath view with core MA as datapath.
		insert into RMDataPathView
		select top 1 @i_RequestId, 0 /*DataPathId*/, 0 /*DataPathPriority*/, c.DrivePoolId, c.clientId,
a.LibraryId, a.MasterPoolId, 0 /*SpareGroupId*/, 1 | 4 /*DataPathFlag*/, a.LibraryTypeId,
				 a.MPMaxSwitchForHost, c.MaxDrivestoSwitch, a.MaxReservations,
				 a.LibraryAttribute, a.ExtendedAttributes, a.RestrictActivity,
				 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, a.LibrarySubType
		from 	RMDataPathView a,  MMDrivePool c with (readuncommitted)
		where	a.RequestId = @i_RequestId
and		a.LibraryTypeId = 3
		and		a.MasterPoolId = c.MasterPoolId
		and		c.ClientId IN (@i_inClientId, @physicalClientId)
order by case when (a.Flag & 1) > 0 then 0 else 1 end,
case when (a.Flag & 4) > 0 then 0 else 1 end
		--Remove actual copy datapaths so that backups uses only core MA.
		delete RMDataPathView where RequestId = @i_RequestId and DataPathId > 0
		set @NumDataPathViews  = 1
	END
	-- Remove the disabled datapath
  	update	RMDataPathView
set			FailureErrorCode = 20090,
FailureType = 1,
  				Precedence = -1
where		Flag & 4 = 0
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
  	if @NumDataPathViews = 0
  	begin
		if @i_IsForSILOBackup > 0
set @o_ErrorCode = 20050
		else
set @o_ErrorCode = 20016
  		GOTO EXIT_AND_RETURN
  	end
	/*
	if @isDebug > 0
	begin
		set @debugDetail = cast(isnull((select DataPathId, Priority, DrivePoolId, HostClientId, LibraryId, MasterPoolId, SpareGroupId
																		from RMDataPathView
																	for XML RAW('AvailableDataPathList'), TYPE), 'NULL') as varchar(max))
		insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	end
  */
 /*********************************************************************************
	Decide the DataPath selection order in this part.
	Datapath should be picked based on following order:
	1. If job is SILO backup, only consider SILO data path
			1) Check the Job DataPath Option
			2) Use Lan-Free first
			3) Then Failover based on priority
	2. If Job DataPath Option available, only consider the Job Data Path option
			1) First Subclient Data path
			2) Then default Lan Free or Lan Free
			3) Then load balancing if Round-Robin enabled
			4) Otherwise, try default and others by data path priority
	3. SubClient Data Path first if defined. Internal order based on the subclient data path precedence.
	4. Lan Free first if possible
			1) If Lan Free fails
			2) if Round-Robin enabled, try load balancing.
			3) if failover enabled, based on failure reason try default and then by data path priority
			4) Otherwise, fail directly
	5. Lan Free if not possible
			1) If Round-Robin enabled, try load balancing.
			2) Otherwise, try default.
			3) If deault fails and failover enable, try failover based on failure reason and by data path priority
 *********************************************************************************/
 -------------------------------------
  -- Filter: use SILO data path			 --
  -------------------------------------
 	set @o_perferredDataPathForCopy = 0
  if @i_IsForSILOBackup > 0
  begin
	/*
  	-- Remove all the non-SILO data path
  	update	RMDataPathView
set			FailureErrorCode = 20050,
FailureType = 2,
  					Precedence = -1
where		Flag & 8 = 0
  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
  	if @NumDataPathViews = 0
		begin
set @o_ErrorCode = 20050
			--set @o_FailureType = RM_FAILURE_JOB
  		GOTO EXIT_AND_RETURN
  	end
delete	RMDataPathView where FailureErrorCode = 20050
	*/
		set @i_useSCDataPath = 0
		--set @i_usePreferredDP = 0
		--set @i_FailoverFlags = @i_FailoverFlags & (~RM_CVA_SWITCHLOADBALANCED)
  	/*
  	select Top 1 @o_perferredDataPathForCopy = DataPathId
  	from	RMDataPathView
  	where FailureErrorCode = 0
  	order by priority
		*/
  end
  else
  begin
  	/* All datapaths in SILO copy are implicit SILO datapaths. Need not do the below explicit check as before
  	-- Remove all the SILO data path
  	update	RMDataPathView
set			FailureErrorCode = 20016,
FailureType = 2,
  					Precedence = -1
where		Flag & 8 > 0
  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
  	if @NumDataPathViews = 0
  	begin
set @o_ErrorCode = 20016
			--set @o_FailureType = RM_FAILURE_JOB
  		GOTO EXIT_AND_RETURN
  	end
	*/
delete	RMDataPathView where FailureErrorCode = 20016
  end
   --------------------------------------
  -- Filter: use Job data path option --
  --
	-- User can specify the Job level DataPath selection criterias.
	-- There are five options: MediaAgent, Library, DrivePool, SpareGroup and Drive (new).
  -- Here we only consider the first four.
  -------------------------------------
	if @i_hasJobDataPathOptions = 1
	begin
		DECLARE @parentJobId INT = 0
		select @parentJobId = ISNULL(parentJobId, 0) from JMJobDataLink WITH (NOLOCK) WHERE childJobId = @i_jobId and commCellId = 2
		DECLARE @jobOptionList Table (optionId bigint, value NVARCHAR(MAX), type INT)
		INSERT INTO @jobOptionList
		SELECT	*
		FROM		dbo.GetJobOptionByIDList( CASE WHEN @parentJobId > 0 THEN @parentJobId ELSE @i_jobId END,
'<id val="' + cast(18276681 as varchar(20)) + '"/>' +
'<id val="' + cast(523178675 as varchar(20)) + '"/>' +
'<id val="' + cast(71136797 as varchar(20)) + '"/>' +
'<id val="' + cast(2081996217 as varchar(20)) + '"/>' +
'<id val="' + cast(1238677445 as varchar(20)) + '"/>'
						)
		WHERE		cast(Value as int) > 0
		-- Media Agent
		declare @MediaAgentList	table ( clientId int)
		declare @NumMediaAgent	int
		insert	into @MediaAgentList
		select	distinct cast(Value as int)
		from		@jobOptionList
where		optionId = 18276681
		set @NumMediaAgent = @@ROWCOUNT
		-- Library
		declare @LibraryList		table ( libraryId int)
		declare @NumLibrary			int
		insert	into @LibraryList
		select	distinct cast(Value as int)
		from		@jobOptionList
where		optionId = 71136797
		set @NumLibrary = @@ROWCOUNT
		-- Drive Pool
		declare @DrivePoolList	table ( drivePoolId int)
		declare @NumDrivePool		int
		insert	into @DrivePoolList
		select	distinct cast(Value as int)
		from		@jobOptionList
where		optionId = 523178675
		set @NumDrivePool = @@ROWCOUNT
		-- Spare Group
		declare @SpareGroupList table ( spareGroupId int)
		declare @NumSpareGroup	int
		insert	into @SpareGroupList
		select	distinct cast(Value as int)
		from		@jobOptionList
where		optionId = 2081996217
		set @NumSpareGroup = @@ROWCOUNT
		update	RMDataPathView
set			FailureErrorCode = 20047,
FailureType = 2,
  					Precedence = -1
		where		FailureErrorCode = 0
		and		( (
							@NumMediaAgent > 0
							and HostClientId not in (select clientId from @MediaAgentList)
						 )
						or
						(
							@NumLibrary > 0
							and LibraryId not in	(select libraryId from @LibraryList)
						)
						or
						(
							@NumDrivePool > 0
							and DrivePoolId not in	(select DrivePoolId from @DrivePoolList)
						)
						or
						(
							@NumSpareGroup > 0
							and SpareGroupId not in	(select spareGroupId from @SpareGroupList)
						)
					)
		set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		if @NumDataPathViews = 0
		begin
set @o_ErrorCode = 20047
			--set @o_FailureType = RM_FAILURE_JOB
			GOTO EXIT_AND_RETURN
		end
		declare @DriveIdList table (driveId int, masterPoolId int)
		declare @NumDriveId int
		insert	into @DriveIdList
		select	distinct cast(a.Value as int), b.MasterPoolId
		from		@jobOptionList a, MMDrive b with (readuncommitted)
where		a.optionId = 1238677445
		and			cast(a.Value as int) = b.DriveId
		set @NumDriveId = @@ROWCOUNT
		if @NumDriveId > 0
		begin
			update	RMDataPathView
set			FailureErrorCode = 	20047,
FailureType = 2,
							Precedence = -1
			where		FailureErrorCode = 0
			and			MasterPoolId not in (select MasterPoolId from @DriveIdList)
			set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20047
				GOTO EXIT_AND_RETURN
			end
		end
	end
  -------------------------------------
  -- Filter: use subclient data path --
  -------------------------------------
	-- Make sure when check backupLevel, the corresponding storage policy does exist and different from FULL backup storage policy.
	-- For example in case of incremental backup, if the incremental backup sp does not exist, Data path goes to the full backup sp.
	if @i_bkpLevel <> 1 -- FULL
	begin
		declare @archGroupId int
		select @archGroupId = isnull(archGroupId, 0) from ArchGroupCopy with (readuncommitted) where id = @i_copyId
		if exists (select * from App_Application with (readuncommitted)
							 where id = @i_appNum
							 and ((dataArchGrpId = @archGroupId and @i_dataType != 4 /*CVA_DATATYPE_LOGS*/ )
							 			or
							 			(logArchGrpId = @archGroupId and @i_dataType = 4 /*CVA_DATATYPE_LOGS*/)))
		begin
			set @i_bkpLevel = 1
		end
	end
  if @i_IsForSILOBackup = 0						-- Don't consider subclient data path for SILO backup
  and @i_hasJobDataPathOptions = 0		-- For job option, use different logic for subclient data path
  and @i_useSCDataPath > 0
  begin
  	set @o_perferredDataPathForCopy = 0
  	-- Get the preferred subclient data path which has highest precedence in table App_AppToDAtaPath
  	select top 1 @o_perferredDataPathForCopy = isnull(b.DataPathId, 0)
  	from APP_AppToDataPath a with (readuncommitted), MMDataPath b with (readuncommitted)
  	where a.componentnameid = @i_appNum
		and a.datatype = @i_dataType
		--and	a.BackupType = @i_bkpLevel
		and b.copyId = @i_CopyId
		and a.datapathid = b.DataPathId
		and a.datapathid <> 0
and (b.flag & 16) = 0
		order by a.precedence
		-- If there is no subclient data path defined, return directly.
		if @o_perferredDataPathForCopy = 0
		begin
	  	update	RMDataPathView
set			FailureErrorCode = 20017,
FailureType = 2,
	  					Precedence = -1
	  	where		FailureErrorCode = 0
	  	set @NumDatapathViews = 0
set @o_ErrorCode = 20017
			--set @o_FailureType = RM_FAILURE_JOB
			GOTO EXIT_AND_RETURN
		end
  	-- Remove all the non-subclient data paths
	 	update	RMDataPathView
set			FailureErrorCode = 20017,
FailureType = 2,
  					Precedence = -1
  	where		FailureErrorCode = 0
  	and			not exists (select * from APP_AppToDataPath with (readuncommitted)
  											where	ComponentNameId = @i_appNum
  											and		DataType = @i_dataType
  											--and		BackupType = @i_bkpLevel
  											and		DataPathId = RMDataPathView.DataPathId)
  	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
  	if @NumDatapathViews = 0
  	begin
set @o_ErrorCode = 20017
			--set @o_FailureType = RM_FAILURE_JOB
			GOTO EXIT_AND_RETURN
		end
		-- If Failover option is not set, only consider the first subclient data path
		if @i_usePreferredDP > 0
		begin
			update	RMDataPathView
set			FailureErrorCode = 20033,
FailureType = 2,
	  					Precedence = -1
			where		FailureErrorCode = 0
			and			DataPathId != @o_perferredDataPathForCopy
			set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20033
				--set @o_FailureType = RM_FAILURE_JOB
				GOTO EXIT_AND_RETURN
			end
		end
  end
  --------------------------------------------
  -- End of Filter: use subclient data path --
  --------------------------------------------
-- *********************************************************************************  --
--                                                                      							--
--	Now decide which order the data path should be picked.														--
--																																										--
--																																										--
-- *********************************************************************************  --
	DECLARE	@JOBOPTION	INT
	DECLARE	@SILO				INT
	DECLARE @SUBCLIENT	INT
	DECLARE	@LANFREE		INT
	DECLARE	@FAILOVER		INT
	DECLARE	@ROUNDROBIN	INT
	SET @JOBOPTION	= 1
	SET @SILO				= 2
	SET @SUBCLIENT	= 3
	SET @LANFREE		= 4
	SET @FAILOVER		= 5
	SET @ROUNDROBIN	= 6
	DECLARE @maxorder int
	SET @maxorder = 0
	DECLARE @maxPriority int
	SET @maxPriority = 0
	DECLARE @lt_PreferredMAGroupDPList table (DrivePoolId int)
	-- The Data Paths left contain subclient data path, lan-free and Failover ones
	IF @i_UseSCDataPath > 0
	BEGIN
		-- Use sbuclient option enabled
 	 	update	RMDataPathView
  	set			Precedence = @SUBCLIENT + b.Precedence
  	from		RMDataPathView a, APP_AppToDataPath b with (readuncommitted)
  	where		a.FailureErrorCode = 0
  	and			a.Precedence = 0
  	and			a.DataPathId > 0
  	and			a.DataPathId = b.DataPathId
		and			b.ComponentNameId = @i_appNum
		and			b.DataType = @i_dataType
		--and			b.BackupType = @i_bkpLevel
		SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
	END
	ELSE -- @i_UseSCDataPath = 0
	BEGIN
		-- Lan-Free
		if @i_inClientId > 0
		begin
			-- Get all the lan-free drive pool
			declare @lanFreeDrivePoolList table (drivePoolId int)
			insert into @lanFreeDrivePoolList
			select distinct a.DrivePoolId
			from		RMDataPathView a, MMDrivePool b with (readuncommitted)
			where		a.FailureErrorCode = 0
			and			a.Precedence = 0
			and			a.DrivePoolId = b.DrivePoolId
			-- For NAS, the Lan-Free client is based on NDMP Host, which might not be the media agent
			and			(
								(b.DrivePoolType = 3 and exists (select Clientid From MMNDMPHostInfo where NDMPHostId = b.NDMPHostId and (ClientId = @i_inClientId or ClientId = @physicalClientId)))
								 or
								(b.DrivePoolType != 3 and (a.HostClientId = @i_inClientId or a.HostClientId = @physicalClientId))
							)
			-- Return drivePools sorted by the usage count.
			-- Use inclientid first. Reserved datapaths with less reservation first , then not reserved.
			-- Then use physical client id. Reserved datapath with less reserved first, then not reserved.
			--First get DrivePools which have already been reserved for this copy.
			insert into #drivePoolReservationList
			select c.DrivePoolId, count(distinct d.RCID)
			from
			(
				select distinct a.DrivePoolId, b.ReservationId
				from	@lanFreeDrivePoolList a, MMResource b with (readuncommitted)
				where a.DrivePoolId = b.DrivePoolId
			) c,
			MMResourceToJob d with (readuncommitted)
			where c.ReservationId = d.ReservationId
			and		c.DrivePoolId in (select DrivePoolId from @lanFreeDrivePoolList)
			group by c.DrivePoolId
			insert into #drivePoolReservationList
			select  distinct DrivePoolId, 0
			from		RMDataPathView
			where		FailureErrorCode = 0
			and			Precedence = 0
			and			DrivePoolId in (select DrivePoolId from @lanFreeDrivePoolList)
			and			DrivePoolId not in (select DrivePoolId from #drivePoolReservationList)
			if exists (select * from #drivePoolReservationList)
			begin
				declare @maxNonRes int = 0
				select @maxNonRes = max(priority) from RMDataPathView where FailureErrorCode = 0 and Precedence = 0
				update	RMDataPathView
set			Precedence = case when b.revCount = 0 then (case when (Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 2 end)
																	else @maxorder + @maxNonRes + b.revCount + 3
																end
				from		RMDataPathView a, #drivePoolReservationList b
				where		a.FailureErrorCode = 0
				and			a.Precedence = 0
				and			a.HostClientId = @i_inClientId
				and			a.DrivePoolId = b.DrivePoolId
				SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
				if @physicalClientId <> @i_inClientId
				begin
					select @maxNonRes = max(priority) from RMDataPathView where FailureErrorCode = 0 and Precedence = 0
					update	RMDataPathView
set			Precedence = case when b.revCount = 0 then (case when (Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 2 end)
																		else @maxorder + @maxNonRes + b.revCount + 3
																	end
					from		RMDataPathView a, #drivePoolReservationList b
					where		a.FailureErrorCode = 0
					and			a.Precedence = 0
					and			a.HostClientId = @physicalClientId
					and			a.DrivePoolId = b.DrivePoolId
					SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
				end
			end
		end
		IF exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_CONSIDER_GEOMETRY_LOCATION' and value > 0)
		begin
			-- select preferred media agent based on geometry information
			DECLARE @SQLStr VARCHAR(2048)
			SET @SQLStr = '
			DECLARE @clientGeoXML	XML
			DECLARE @clientGeoInfo	geography
			SELECT @clientGeoXML = ISNULL(AttrVal, '''') FROM App_ClientProp WITH (NOLOCK)
													   WHERE componentNameId = CASE WHEN '+ CONVERT(VARCHAR(16), @physicalClientId) + ' <> ' +CONVERT(VARCHAR(16), @i_inClientId) + ' THEN '+ CONVERT(VARCHAR(16), @physicalClientId) + ' ELSE ' + CONVERT(VARCHAR(16), @i_inClientId) + ' END AND AttrName = ''Client Geo Location'' AND Modified = 0' + '
			SET @clientGeoInfo = geography::Point(ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
												ISNULL(@clientGeoXML.value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
												4326)
			INSERT INTO #drivePoolReservationList
			SELECT isnull(dp.DrivePoolId, 0),
					DENSE_RANK() OVER (ORDER BY @clientGeoInfo.STDistance(geography::Point(ISNULL(CAST(client.AttrVal AS XML).value(''/App_GeoLocation[1]/@latitude'', ''float''), 0),
																		ISNULL(CAST(client.AttrVal as XML).value(''/App_GeoLocation[1]/@longitude'', ''float''), 0),
																		4326)),
CASE WHEN ' + CONVERT(VARCHAR(16), @i_FailoverFlags) + ' & 512 > 0 THEN
															(SELECT count(ReservationId) FROM MMResource WITH (NOLOCK) WHERE DrivePoolId = dp.DrivePoolId)
ELSE	1- sign(dp.Flag & 1) END
										)
			FROM		RMDataPathView dp, App_ClientProp client with (nolock)
			WHERE		dp.FailureErrorCode = 0
			AND			dp.Precedence = 0
			AND			dp.HostClientId = client.componentNameId
			AND			client.AttrName = ''Client Geo Location''
			AND			client.Modified = 0
			'
			EXEC (@SQLStr)
			IF EXISTS (select * from #drivePoolReservationList where DrivePoolId > 0)
			BEGIN
				update	RMDataPathView
				set			Precedence = @maxorder + b.revCount
				from		RMDataPathView a, #drivePoolReservationList b
				where		a.FailureErrorCode = 0
				and			a.Precedence = 0
				and			a.DrivePoolId = b.DrivePoolId
			END
			SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
		end
		if exists (select 1 from MMConfigs where name = 'RM_CONFIG_PREFER_MA_FROM_PREFERRED_MEDIA_AGENT_GROUP' and value > 0)
        begin
            -- select preferred media agent based on client advance setting PreferredMediaAgentGroup.
            DECLARE @preferredMediaAgentGroup nvarchar(max)
			IF @physicalClientId <> @i_inClientId
SET @preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient(@physicalClientId, 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
            ELSE
SET @preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient(@i_inClientId, 'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
            IF ISNULL(@preferredMediaAgentGroup, '') <> ''
			BEGIN
				insert 	into @lt_PreferredMAGroupDPList
				select 	distinct a.DrivePoolId
				from	RMDataPathView a, MMDrivePool b with (readuncommitted)
				where	a.FailureErrorCode = 0
				and		a.Precedence = 0
				and		a.DrivePoolId = b.DrivePoolId
				-- For NAS, the PreferredMediaAgentGroup is based on NDMP Host, which might not be the media agent
				and		@preferredMediaAgentGroup = dbo.AppGetAdditionalSettingForClient(
								(case when b.DrivePoolType = 3 then (select clientId from MMNDMPHostInfo with (readuncommitted) where NDMPHostId = b.NDMPHostId) else a.HostClientId end),
'PreferredMediaAgentGroup', 'CommServDb.ResourceManager')
				IF EXISTS (select 1 from @lt_PreferredMAGroupDPList)
				BEGIN
					-- Get reservation count for each drive pool in the list to do load balance if it's set.
					delete #drivePoolReservationList
					insert 	into #drivePoolReservationList
					select 	a.DrivePoolId, count(distinct c.RCID)
					from	@lt_PreferredMAGroupDPList a
							inner join MMResource b on a.DrivePoolId = b.DrivePoolId
							inner join MMResourceToJob c on c.ReservationId = b.ReservationId
					group by a.DrivePoolId
					insert 	into #drivePoolReservationList
					select  a.DrivePoolId, 0
					from	@lt_PreferredMAGroupDPList a
							left outer join #drivePoolReservationList b on a.DrivePoolId = b.DrivePoolId
					where	b.DrivePoolId is null
					select @maxPriority = max(priority) from RMDataPathView where FailureErrorCode = 0 and Precedence = 0
					-- Set priority based on
					-- 1. If load balancing give high priority for least used datapaths.
					--	a. Give high priority to default data path if it's not used.
					-- 2. If use preferred or switch alternate then give high priority to default data path.
					-- Note: Default data path will be give high priority in above cases only when it's in the preferred media agent group list.
					update  	RMDataPathView
set         Precedence = (case when @i_FailoverFlags & 512 > 0
then (case when b.revCount = 0 then (case when (a.Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 2 end)
																else @maxorder + @maxPriority + b.revCount + 3 end)
else (case when (a.Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 2 end)
												end)
					from        RMDataPathView a, #drivePoolReservationList b
					where       a.FailureErrorCode = 0
					and         a.Precedence = 0
					and         a.DrivePoolId = b.DrivePoolId
					SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
				END
			END
        end
		-- If Round-Robin
IF @i_FailoverFlags & 512 > 0
		BEGIN
			delete #drivePoolReservationList
			insert into #drivePoolReservationList
			select c.DrivePoolId, count(distinct d.RCID)
			from
			(
				select distinct a.DrivePoolId, b.ReservationId
				from
					(
						select	distinct DrivePoolId
						from		RMDataPathView
						where		FailureErrorCode = 0
						and			Precedence = 0
					) a,
					MMResource b with (readuncommitted)
				where a.DrivePoolId = b.DrivePoolId
			) c,
			MMResourceToJob d with (readuncommitted)
			where c.ReservationId = d.ReservationId
			group by c.DrivePoolId
			insert into #drivePoolReservationList
			select  distinct DrivePoolId, 0
			from		RMDataPathView
			where		FailureErrorCode = 0
			and			Precedence = 0
			and			DrivePoolId not in (select DrivePoolId from #drivePoolReservationList)
			if exists (select * from #drivePoolReservationList)
			begin
				select @maxPriority = max(priority) from RMDataPathView where FailureErrorCode = 0 and Precedence = 0
				-- Not reserved first based on default flag and priority
				-- THen reserved drive pool, less reserved first
				update	RMDataPathView
				set			Precedence = case when b.revCount = 0
then (case when (Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 1 end)
																else @maxorder + @maxPriority + b.revCount + 2 end
				from		RMDataPathView a, #drivePoolReservationList b
				where		a.FailureErrorCode = 0
				and			a.Precedence = 0
				and			a.DrivePoolId = b.DrivePoolId
/*
				and			a.LibrarySubType <> @CV_LIBSUBTYPE_LIBRARY_SERVER
				SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
				update	RMDataPathView
				set			Precedence = case when b.revCount = 0
then (case when (Flag & 1) > 0 then @maxorder + 1 else @maxorder + a.Priority + 1 end)
																else @maxorder + @maxPriority + b.revCount + 2 end
				from		RMDataPathView a, #drivePoolReservationList b
				where		a.FailureErrorCode = 0
				and			a.Precedence = 0
				and			a.DrivePoolId = b.DrivePoolId
				and			a.LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
*/
			end
		END
		ELSE
		-- Use preferred or Failover
		-- IF @i_FailoverFlags & (RM_CVA_SWITCHIFOFFLINE | RM_CVA_SWITCHIFBUSY)
		BEGIN
			update	RMDataPathView
set			Precedence = case when (Flag & 1) > 0 then @maxorder + @FAILOVER
															else @maxorder + @FAILOVER + Priority + 1 end
			where		FailureErrorCode = 0
			and			Precedence = 0
/*
			and			LibrarySubType <> @CV_LIBSUBTYPE_LIBRARY_SERVER
			SELECT @maxorder = max(Precedence) FROM RMDataPathView WHERE FailureErrorCode = 0
			update	RMDataPathView
set			Precedence = case when (Flag & 1) > 0 then @maxorder + @FAILOVER
															else @maxorder + @FAILOVER + Priority + 1 end
			where		FailureErrorCode = 0
			and			Precedence = 0
			and			LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
*/
		END
	END -- End of @i_useSCDataPath = 0
  -------------------------------------
	declare @lanFreeDrivePoolIdList table (drivePoolId int)
	/*
	insert into @lanFreeDrivePoolIdList
	select distinct a.DrivePoolId
	from		RMDataPathView a, MMDrivePool b with (readuncommitted)
	where		a.FailureErrorCode = 0
	and			a.DrivePoolId = b.DrivePoolId
	-- For NAS, the Lan-Free client is based on NDMP Host, which might not be the media agent
	and			(
						(b.DrivePoolType = 3 and exists (select Clientid From MMNDMPHostInfo where NDMPHostId = b.NDMPHostId and (ClientId = @i_inClientId or ClientId = @physicalClientId)))
						 or
						(b.DrivePoolType != 3 and (a.HostClientId = @i_inClientId or a.HostClientId = @physicalClientId))
					)
	*/
	insert into @lanFreeDrivePoolIdList
	select distinct a.DrivePoolId
	from		MMDataPath a with (readuncommitted),  MMDrivePool b with (readuncommitted)
	where		a.CopyId = @i_CopyId
and			(a.Flag & 16) = 0
	--and			( (@i_IsForSILOBackup = 0 and (Flag & MMS2_SILO_FAILOVER = 0))
	--				or
	--				  (@i_IsForSILOBackup > 0 and (Flag & MMS2_SILO_FAILOVER > 0)))
	-- need to consider the NAS drive pool, whose Lan-Free client is based on NDMP Host, which might not be the media agent.
	and			a.DrivePoolId = b.DrivePoolId
	and			(
						(b.DrivePoolType = 3 and exists (select Clientid From MMNDMPHostInfo where NDMPHostId = b.NDMPHostId and ClientId in (@i_inClientId, @physicalClientId)))
						 or
						(b.DrivePoolType != 3 and a.HostClientId in (@i_inClientId, @physicalClientId))
				)
  -------------------------------------
  -- Filter: use preferred data path --
  -- Only consider the lanfree and default data paths
  -------------------------------------
	if @i_hasJobDataPathOptions = 0		-- For job option, use different logic for preferred data paths
	and @i_useSCDataPath = 0 					-- Don't consider subclient data path for use preferred data path
	--and @i_IsForSILOBackup = 0 				-- Use differnt logic to consider the lan-free for SILO backup
	and @i_usePreferredDP > 0
	begin
		-- if @physicalClientId != @i_inClientId
		begin
			if exists (select * from @lanFreeDrivePoolIdList)
			begin
		 		/*
				delete	RMDataPathView
				where		DrivePoolId not in (select DrivePoolId From @lanFreeDrivePoolIdList)
				*/
				update	RMDataPathView
set			FailureErrorCode = 20018,
FailureType = 2
				where		FailureErrorCode = 0
				and			DrivePoolId not in (select DrivePoolId From @lanFreeDrivePoolIdList)
				-- if lan-free is possible, do not consider default one if it is not lan-free
				--and			(Flag & MMS2_DEFAULT_FAILOVER) != MMS2_DEFAULT_FAILOVER
				set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
				if @NumDataPathViews = 0
				begin
					update	RMDataPathView
set			FailureErrorCode = 20091
where		FailureErrorCode = 20090
set @o_ErrorCode = 20018
					--set @o_FailureType = RM_FAILURE_JOB
					GOTO EXIT_AND_RETURN
				end
			end
			else if exists (select * from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_RESTORE_CONSIDER_GEOMETRY_LOCATION' and value > 0)
			begin
				declare @currentPrecedence int = 0
		 		select top 1 @currentPrecedence = Precedence
		 		from RMDataPathView
		 		where FailureErrorCode = 0
		 		order by Precedence
				update	RMDataPathView
set			FailureErrorCode = 20124,
FailureType = 2
				where		FailureErrorCode = 0
				and			Precedence != @currentPrecedence
				set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 20124
					--set @o_FailureType = RM_FAILURE_JOB
					GOTO EXIT_AND_RETURN
				end
			end
			else
			begin
				--
				-- MR#212394
				-- For backups we may do exchange reservation to do lan free backups when proxy is MA
				-- If copy is set to use preferred then exchange may reserve streams on non-default datapath
				-- For additional stream allocation we tries to reserve only on current reserved MA
				-- So don't set error code on reserved MAs if it's not default data path.
				--
				IF @i_JobType = @BKPJOB AND @i_isForRemainingStreams > 0
				BEGIN
					update	RMDataPathView
set			FailureErrorCode = 20019,
FailureType = 2
					where		FailureErrorCode = 0
and			(Flag & 1) != 1
					and 		not exists(select 1 from @lt_PreferredMAGroupDPList where DrivePoolId = RMDataPathView.DrivePoolId)
					and			not exists(select 1 from MMResource R with (readuncommitted), MMResourceToJob RJ with (readuncommitted)
where R.ReservationId = RJ.ReservationId and RJ.ReservationType = 2 and RJ.JobId_l = @i_JobId
											and R.DrivePoolId = RMDataPathView.DrivePoolId)
				END
				ELSE
				BEGIN
					update	RMDataPathView
set			FailureErrorCode = 20019,
FailureType = 2
					where		FailureErrorCode = 0
and			(Flag & 1) != 1
					and 		not exists(select 1 from @lt_PreferredMAGroupDPList where DrivePoolId = RMDataPathView.DrivePoolId)
				END
				set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
				if @NumDataPathViews = 0
				begin
					update	RMDataPathView
set			FailureErrorCode = 20092
where		FailureErrorCode = 20090
set @o_ErrorCode = 20019
					--set @o_FailureType = RM_FAILURE_JOB
					GOTO EXIT_AND_RETURN
				end
			end
		end
	end
  --------------------------------------------
  -- End of Filter: use preferred data path --
  --------------------------------------------
	/*
  -------------------------------------
  -- Filter: use lan-free only 			 --
  -------------------------------------
	declare @isUseLanFreeOnly int
	set @isUseLanFreeOnly = 0
select @isUseLanFreeOnly = (Flags & 134217728) from ArchGroupCopy with (readuncommitted) where id = @i_CopyId
	if @isUseLanFreeOnly > 0
	and @i_hasJobDataPathOptions = 0		-- For job option, use different logic for preferred data paths
	and @i_useSCDataPath = 0 					-- Don't consider subclient data path for use preferred data path
	and @i_IsForSILOBackup = 0 				-- Use differnt logic to consider the lan-free for SILO backup
	begin
		update	RMDataPathView
set			FailureErrorCode = 20018,
FailureType = 2
		where		FailureErrorCode = 0
		and			DrivePoolId not in (select DrivePoolId From @lanFreeDrivePoolIdList)
 		set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		if @NumDataPathViews = 0
		begin
set @o_ErrorCode = 20018
			--set @o_FailureType = RM_FAILURE_JOB
			GOTO EXIT_AND_RETURN
		end
	end
  --------------------------------------------
  -- End of Filter: use preferred data path --
  --------------------------------------------
  */
EXIT_AND_RETURN:
if @NumDataPathViews > 0
set @o_ErrorCode = 0
/*
if @isDebug > 0
begin
	set @debugDetail = cast(isnull((select DataPathId, FailureErrorCode	from RMDataPathView where FailureErrorCode > 0
																	for XML RAW('UnavailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	set @debugDetail = cast(isnull((select DataPathId, Priority, DrivePoolId, HostClientId, LibraryId, MasterPoolId, SpareGroupId
																	from RMDataPathView where FailureErrorCode = 0
																	for XML RAW('AvailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
end
*/
-- select * from RMDataPathView where FailureErrorCode = 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMGetDataPathViewForWrite')
	delete from GxQscripts where name = 'RMGetDataPathViewForWrite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetDataPathViewForWrite')
	delete from GXDBVersions where aliasname = 'RMGetDataPathViewForWrite'
GO

insert into GXDBVersions values(2, 'RMGetDataPathViewForWrite',  '00010035003200150000', 'RMGetDataPathViewForWrite', '00010035003200150000')
GO

