

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMGetCopyStreamView.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMGetCopyStreamView.sp,v $ $Id: RMGetCopyStreamView.sp,v 1.35.46.16 2020/03/24 19:59:06 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMGetCopyStreamView()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMGetCopyStreamView')
BEGIN
	print '>>> Drop Stored Procedure: RMGetCopyStreamView <<<'
	drop procedure RMGetCopyStreamView
END
IF EXISTS (select * from GxQscripts where name='RMGetCopyStreamView')
	delete from GxQscripts where name = 'RMGetCopyStreamView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetCopyStreamView')
	delete from GXDBVersions where aliasname = 'RMGetCopyStreamView'
GO
print '... Creating Procedure: RMGetCopyStreamView'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMGetCopyStreamView
  @i_RequestId int,
  @i_CopyId int,
  @i_DataMultiStream int,
  @i_MuxFactor int,
  @i_SingleStream int,
  @i_isForRemainingStreams int,
  @i_forceMultiplexing int,
  @i_ScheduleRunId int,
  @i_doNotAllowOtherSchedule int,
  @i_MarkActiveMediaFull int,
  @i_JobId int,
  @i_JobType int,
  @i_AppNum int,
  @i_IsInlineCopy int,
  @i_primaryCopyId int,
  @i_isForSILOBackup int,
  @i_isTransactionLogBackupPhase int,
  @i_DataType int,
  @i_SIDBStoreId int,
  @isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT,
  @o_skipStreamLimits integer OUTPUT
AS
--:DECLARE o_ErrorCode			integer;
--:DECLARE o_FailureType			integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	/*
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMGetCopyStreamView', 'Enter...', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select @i_CopyId copyId, @i_DataMultiStream dataMultiStream, @i_MuxFactor muxFactore, @i_SingleStream signleStream,
																	@i_isForRemainingStreams isForRemainingStreams, @i_forceMultiplexing forMultiplexing, @i_ScheduleRunId scheduleRunId,
																	@i_doNotAllowOtherSchedule doNotAllowOtherSchedule, @i_JobId jobId, @i_JobType jobType, @i_AppNum appNum
															for XML RAW('Parameters'), TYPE), 'NULL') as varchar(max))
		insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
	end
	*/
	/*
	Based on the given copy id, figure out
	 1. Available active stream
	 2. multiplexable stream
	 3.multiplexable read stream when using magnetic media
	*/
	declare @AUXCOPYJOB int
	declare @MEDIAREFRESHINGJOB int
	declare @DASHCOPYJOB int
	set @AUXCOPYJOB = 6
	set @MEDIAREFRESHINGJOB = 25
	set @DASHCOPYJOB = 37
DECLARE @RMCopyView TABLE ( CopyId					integer, StreamId				integer, MediaGroupId			integer, RemainingMx				integer, DrivePoolId				integer, DriveId					integer, VolumeId				integer, MediaId					integer, SpareGroupId			integer, MountPathId				integer, ReservationId			integer, NoMux					integer, NoOtherSchedule			integer, ScheduleRunId			bigint, lastUsedTime			integer, Priority				integer, Flag					integer, FailureErrorCode		integer, UNIQUE CLUSTERED (CopyId, StreamId, MediaGroupId, DrivePoolId, VolumeId, RemainingMx)	)
	DECLARE @NumCopyViews int
	SET @NumCopyViews = 0
	DECLARE @NumActiveStream int
	DECLARE @NumMultiplexableStream int
	DeCLARE @NumMultiplexableReadStream int
	SET @NumActiveStream = 0
	SET @NumMultiplexableStream = 0
	SET @NumMultiplexableReadStream = 0
set @o_ErrorCode = 0
  --set @o_FailureType = RM_FAILURE_JOB
	-- Allow combine streams on inline copy/Dash Copy
	DECLARE @allowCombineStreams INT = 0
	DECLARE @maxStreamNum INT = 1
	DECLARE @l_archGroupId INT = (SELECT archGroupId FROM archGroupCopy WITH(READUNCOMMITTED) WHERE id = @i_CopyId)
	DECLARE @l_TotalNumStreams INT = 0
	DECLARE @l_archGroupFlags INT = 0
	SELECT 	@l_TotalNumStreams = maxStreams,
			@l_archGroupFlags = flags
	FROM 	archGroup WITH(READUNCOMMITTED)
	WHERE 	id = @l_archGroupId
	IF @i_jobType IN (@DASHCOPYJOB) OR @i_IsInlineCopy > 0 OR @i_isForSILOBackup > 0
	BEGIN
SELECT @allowCombineStreams = (Flags & 4),
				@maxStreamNum = MaxStreamNum
		FROM ArchGroupCopy with (readuncommitted) WHERE Id = @i_CopyId
	END
	-- When the required stream is reserved but released already,
	-- reset the stream/mediagroup info on existing reservation to allow other jobs go to the same stream right away.
	IF (@i_copyId > 0 AND @i_singleStream > 0)
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM MMResource a with (NOLOCK), MMResourceToJob b with (NOLOCK)
						WHERE	a.streamId = @i_singlestream and a.copyId = @i_copyId
						AND		a.ReservationId = b.ReservationId
						AND		(
									-- Only when drive is stuck
(b.ReserveBitMask != 2 OR b.ReleaseTime = 0)
									OR
									-- only when there is no interruption happenning
									(a.HasJobInterrupted > 0 OR a.IntrJobId_l > 0 OR a.IntrJobId_h > 0)
									OR
									-- there is no read multiplexing
(a.ReservationType = 1 )
								)
						)
		BEGIN
			UPDATE MMResource
			SET		StreamId = 0, MediaGroupId = 0
			WHERE	streamId = @i_singlestream and copyId = @i_copyId
		END
	END
	IF @i_IsInlineCopy = 0
	BEGIN
		DECLARE @l_MinStreamNum INT = 0
		DECLARE @l_MaxStreamNum INT = 0
		--
		-- If dedicated streams set for log backups then use log streams for log backups only
		--
if @i_JobType IN (1 /*RM_BKPJOB*/, 7 /*RM_SYNTHFULLJOB*/)
		BEGIN
DECLARE @l_DedicatedNumStreams INT = ISNULL((SELECT intVal FROM MMEntityProp WITH(READUNCOMMITTED) WHERE CommCellId = 2 AND EntityId = @l_archGroupId
AND EntityType = 1 AND propertyName = 'StreamsToHoldForLogBackups'), 0)
			if  @l_DedicatedNumStreams > 0
			begin
				SET @l_MinStreamNum = CASE WHEN @i_isTransactionLogBackupPhase = 0 THEN 1 ELSE (@l_TotalNumStreams - @l_DedicatedNumStreams) + 1 END
				SET @l_MaxStreamNum = CASE WHEN @i_isTransactionLogBackupPhase = 0 THEN (@l_TotalNumStreams - @l_DedicatedNumStreams) ELSE @l_TotalNumStreams END
			end
		END
		-- Get all the active streams
		INSERT INTO @RMCopyView
		SELECT distinct @i_copyId,
					a.Stream as Stream,
					a.MediaGroupId as MediaGroupId,
					-- If @i_dataMultiStream is not allowed, se the MuxFactore as 1
					(CASE WHEN @i_dataMultiStream = 0 THEN 1 ELSE @i_MuxFactor END) as RemainingMx,
					0 as DrivePoolId,
					0 as DriveId,
					0 as VolumeId,
					0 as MediaId,
					0 as SpareGroupId,
					0 as MountPatchId,
					0 as ReservationId,
					0 as NoMux,
					0 as NoOtherSchedule,
					0 as ScheduleRunId,
					isnull(a.lastUsedTIme, 0) as LastUsedTime,
					0 as Priority,
					0,
					0
		FROM	ArchStream a with (readuncommitted)
		WHERE	a.ArchGroupCopyId = @i_copyId
		AND		a.Stream not in (select StreamId from MMResource WITH (READUNCOMMITTED) WHERE streamId > 0 AND copyId = @i_copyId)
		AND		a.isActive = 1
		AND		(@i_singleStream <= 0 or a.Stream = @i_singleStream)
		AND 	(@l_MinStreamNum = 0 OR a.Stream >= @l_MinStreamNum)
		AND 	(@l_MaxStreamNum = 0 OR a.Stream <= @l_MaxStreamNum)
--		AND		((@i_isForSILOBackup = 0 AND a.Flags & CVA_SILO_STREAM_FLAG = 0) OR (@i_isForSILOBackup > 0 AND a.Flags & CVA_SILO_STREAM_FLAG > 0))
		ORDER BY a.Stream
	 	SET @NumActiveStream = @@ROWCOUNT
		IF (@i_isForSILOBackup > 0 OR @i_jobType IN (@DASHCOPYJOB)) AND @allowCombineStreams > 0
		BEGIN
			DELETE @RMCopyView WHERE StreamId > @maxStreamNum
		 	SET @NumActiveStream = @NumActiveStream - @@ROWCOUNT
		END
		/*
		if @NumActiveStream > 0 and @isDebug > 0
		begin
			set @debugDetail = cast(isnull((select @NumCopyViews totalNum, CopyId, StreamId, RemainingMx
															from @RMCopyView for XML RAW('ActiveStreams'), TYPE), 'NULL') as varchar(max))
			insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
		end
		*/
	 	-- Get all the multiplexing stream
	 	INSERT INTO @RMCopyView
	  SELECT	DISTINCT @i_copyId,
				a.stream as Stream,
				a.mediaGroupId as MediaGroupId,
				-- following find out how many remaining mulitplexing streams left for the archive stream
				(case when @i_dataMultiStream = 1 then @i_MuxFactor - (select count(RCID) from MMResourceToJob WITH (READUNCOMMITTED)
																 															where reservationId = b.ReservationId)
				else sign(@i_MuxFactor - (select count(RCID) from MMResourceToJob  WITH (READUNCOMMITTED) where reservationId = b.ReservationId)) end)
				as RemainingMx,
				isnull(b.DrivePoolId, 0) as DrivePoolId,
				isnull(b.DriveId, 0) as DriveId,
				isnull(b.VolumeId, 0) as VolumeId,
				isnull(b.MediaId, 0) as MediaId,
				isnull(b.SpareGroupId, 0) as SpareGroupId,
				isnull(b.MountPathId, 0) as MountPathId,
				isnull(b.ReservationId, 0) as ReservationId,
(isnull(b.ResourceFlag, 0) & (2 | 4)) as NoMux,
				(isnull(b.NoOtherSchedule, 0)) as NoOtherSchedule,
				(isnull(b.ScheduleRunId, 0))  as ScheduleRunId,
				(isnull(a.lastUsedTime, 0)) as lastUsedTime,
				0 as Priority,
				0,
				0
		FROM archStream a with (readuncommitted), MMResource b with (readuncommitted)
		-- read reservation in mmresoruce has streamid = 0, so they are not included
		WHERE	a.archgroupcopyid = b.copyid and a.stream = b.streamid
		AND		a.archgroupcopyid = @i_copyId
		AND		(@i_singleStream <= 0 or a.stream = @i_singleStream)
		AND		a.stream not in (select streamid from MMResource WITH (READUNCOMMITTED) where CopyId = @i_copyId and StreamId > 0 and (IntrJobId_l != 0 or HasJobInterrupted = 1))
		AND		b.LogicalRelease <> 1
--		AND		((@i_isForSILOBackup = 0 AND a.Flags & CVA_SILO_STREAM_FLAG = 0) OR (@i_isForSILOBackup > 0 AND a.Flags & CVA_SILO_STREAM_FLAG > 0))
		SET @NumMultiplexableStream = @@ROWCOUNT
		-- For Auxcopy job, the required stream might not be available in the database
		IF @i_singleStream > 0 AND NOT EXISTS( select * from @RMCopyView where StreamId = @i_singleStream) and @i_jobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
		BEGIN
			DECLARE @auxCopyMediaGroupId INT
			SELECT @auxCopyMediaGroupId = isnull(MediaGroupId, 0) FROM ArchStream with (readuncommitted) WHERE ArchGroupCopyId = @i_CopyId AND Stream = @i_singleStream
			-- Only when the media group does exist for the given streamId, we all reservation.
			IF @auxCopyMediaGroupId IS NOT NULL AND @auxCopyMediaGroupId > 0
			BEGIN
				INSERT INTO @RMCopyView
				SELECT	@i_copyId, @i_singleStream,	@auxCopyMediaGroupId,
								(case when @i_dataMultiStream = 0 then 1 else @i_MuxFactor end),
								0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
				SET @NumActiveStream = @NumActiveStream + 1
			END
		END
		-- TODO: If reserved by current job, and DataMultiStream is false, then the stream cannot be reserved.
		if @i_dataMultiStream = 0 and @i_jobType not in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB)
		begin
			update @RMCopyView
			set			RemainingMx = 0
			where		StreamId in (select StreamId From MMResource WITH (READUNCOMMITTED) where CopyId = @i_CopyId
														and ReservationId in (select ReservationId from MMResourceToJob WITH (READUNCOMMITTED) where JobId_l = @i_JobId))
		end
		--AND		RemainingMx > 0
		update	@RMCopyView
set			FailureErrorCode = 20025
		where		FailureErrorCode = 0
		and			RemainingMx <= 0
		SET @NumMultiplexableStream = @NumMultiplexableStream - @@ROWCOUNT
		/*
		if @NumMultiplexableStream > 0 and @isDebug > 0
		begin
			set @debugDetail = cast(isnull((select StreamId, MediaGroupId, RemainingMx, DrivePoolId, DriveId,
																						 VolumeId, MediaId, SpareGroupId, MountPathId, ReservationId
																						 from @RMCopyView where VolumeId > 0 and FailureErrorCode = 0
															for XML RAW('MultiplexableStreams'), TYPE), 'NULL') as varchar(max))
			insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
		end
		*/
		-- If the copy has Magnetic data path, and the data path is reserved by other jobs for read.
		-- This is also a candidate for reservation
IF EXISTS (SELECT 1 FROM MMDataPath with (readuncommitted) Where copyId = @i_copyId AND (flag & 4) > 0 AND spareGroupId = 0)
		BEGIN
			INSERT INTO @RMCopyView
			SELECT	@i_copyId,
				0 as Stream,
				ISNULL(a.volMediaGroupId, 0) as MediaGroupId,
				-- following find out how many remaining mulitplexing streams left for the archive stream
				(case when @i_dataMultiStream = 0 then 1 else @i_MuxFactor end) as RemainingMx,
				isnull(a.DrivePoolId, 0) as DrivePoolId,
				isnull(a.DriveId, 0) as DriveId,
				isnull(a.VolumeId, 0) as VolumeId,
				isnull(a.MediaId, 0) as MediaId,
				isnull(a.SpareGroupId, 0) as SpareGroupId,
				isnull(a.MountPathId, 0) as MountPathId,
				isnull(a.ReservationId, 0) as ReservationId,
(isnull(a.ResourceFlag, 0) & (1 | 2 | 4)) as NoMux,
				isnull(a.NoOtherSchedule, 0) as NoOtherSchedule,
				isnull(a.ScheduleRunId, 0) as ScheduleRunId,
				0,
				0 as Priority,
				0,
				0
			FROM (
					select 	res.*, b.MediaGroupId volMediaGroupId,
							-- Keep the distinct volume only. In case of DV or auxcopy job, same voume can be reserved multiple time for read.
							ROW_NUMBER() OVER (PARTITION BY res.DrivePoolId, res.VolumeId ORDER BY res.ReservationId) AS volOrder
					FROM 	MMResource res with (readuncommitted)
							inner join
							(
								SELECT 	V.VolumeId, V.MediaGroupId
								FROM 	MMVolume as V WITH (READUNCOMMITTED), archStream as ASTR WITH (READUNCOMMITTED)
								WHERE 	V.VolumeFlags = 1 -- VOL_ACTIVE
										AND V.MediaGroupId = ASTR.mediaGroupId
AND V.RecordingFormatId = 10001
										AND ASTR.ArchGroupCopyId = @i_copyId
										AND
										(
											@i_SIDBStoreId = 0
											OR (@i_SIDBStoreId > 0 and @i_SIDBStoreId = V.SIDBStoreId)
										)
							) b on res.VolumeId = b.VolumeId
							inner join
							(
								Select 	DrivePoolId
								FROM 	MMDataPath with (readuncommitted)
								WHERE 	copyId = @i_copyId
AND (flag & 4) > 0
							) c on res.DrivePoolId = c.DrivePoolId
					WHERE	res.LogicalRelease = 0 AND res.StreamId = 0
							-- Make sure there is no other job is reserving the same volume for write. (For read is OK)
							AND	NOT EXISTS ( SELECT 1 FROM MMResource WITH (READUNCOMMITTED) WHERE ReservationId != res.ReservationId AND VolumeId = res.VolumeId AND StreamId != 0)
							AND EXISTS (Select 1 from MMResourceToJob with (readuncommitted)
WHERE res.ReservationId = ReservationId and ReleaseTime <= 0 AND ReserveBitMask IN (1, 2, 4))
				) a
			WHERE a.volOrder = 1
		 	SET @NumMultiplexableReadStream = @@ROWCOUNT
			/*
			if @NumMultiplexableReadStream > 0 and @isDebug > 0
			begin
			set @debugDetail = cast(isnull((select StreamId, MediaGroupId, RemainingMx, DrivePoolId, DriveId,
																						 VolumeId, MediaId, SpareGroupId, MountPathId, ReservationId
																						 from @RMCopyView where streamId = 0 and FailureErrorCode = 0
																				for XML RAW('MultiplexableReadStreams'), TYPE), 'NULL') as varchar(max))
				insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
			end
			*/
		END
		SET @NumCopyViews = @NumActiveStream + @NumMultiplexableStream + @NumMultiplexableReadStream
		--
		-- VSA holds stream for backup phase and requests another stream for indexing
		-- This causes deadlock when all streams are allocated to VSA and all them are waiting in backup phase
		-- So don't allocate all streams when VSA job is running for the current storage policy
		--
		DECLARE @l_NumStreamsToHoldForIndexPercentage INT = ISNULL((select value from MMConfigs with(readuncommitted)
															where name = 'RM_CONFIG_NUM_STREAMS_TO_HOLD_FOR_INDEXING'),
10)
		DECLARE @l_NumStreamsToHoldForIndex INT = 0
		if  @l_NumStreamsToHoldForIndexPercentage > 0
and @i_JobType IN (1 /*RM_BKPJOB*/, 7 /*RM_SYNTHFULLJOB*/)
and @i_DataType <> 6
		begin
			if 	exists
				(
					select 	1
					from 	JMBkpJobInfo BJ with(readuncommitted)
							INNER JOIN JMJobInfo JI with(readuncommitted) ON BJ.jobId = JI.jobId AND BJ.commCellId = JI.commCellId
							INNER JOIN App_Application APP with (readuncommitted) ON BJ.applicationId = APP.id
							INNER JOIN ArchGroupCopy AGC with (readuncommitted) ON AGC.id = @i_copyId AND BJ.currentPolicy = AGC.archGroupId
							INNER JOIN APP_ClientProp CL WITH (READUNCOMMITTED) ON CL.componentNameId = APP.clientId
where 	APP.AppTypeId = 106 /*CV_APPTYPE_VIRTUAL_SERVER*/
							and JI.state IN (1 /*RUNNING*/, 3 /*WAITING*/)  --JobManager/cvjob.h
							AND CL.attrName = 'IndexingV2_VSA'
							AND CL.attrVal = 1
							AND CL.modified = 0
				)
			begin
				-- we reuse backup stream for index incase of non-deudpe from SP21 so this holding stream is needed for non-dedupe only from SP21 onwards.
				if @i_SIDBStoreId > 0 OR
				EXISTS
				(
					SELECT 	1
					FROM	RMDataPathView DP
							LEFT OUTER JOIN App_VMToPMMap VC WITH(READUNCOMMITTED) ON DP.HostClientId = VC.VMClientId
							INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON CN.id = ISNULL(VC.PMClientId, DP.HostClientId)
							INNER JOIN SimInstalledPackages PKG WITH(READUNCOMMITTED) ON PKG.clientId = CN.id
WHERE   PKG.simPackageID IN (51, 1301)
							AND (CN.releaseId < 16 OR (CN.releaseId = 16 AND PKG.HighestSP < 21))
				)
				begin
					--
					-- Request is for index itself then we should skip all stream limits at different levels except the one on storage policy
					--
if @i_DataType = 2
					begin
						SET @o_skipStreamLimits =  1
					end
					else
					begin
						SET @l_NumStreamsToHoldForIndex = @l_NumStreamsToHoldForIndexPercentage * @l_TotalNumStreams / 100
						IF @l_NumStreamsToHoldForIndex = 0
							SET @l_NumStreamsToHoldForIndex = 1
					end
				end
			end
		end
		if @l_NumStreamsToHoldForIndex > 0
		begin
			DECLARE @l_MaxTotalRemainingMx INT = 0
			IF OBJECT_ID('tempdb..#lt_RMCopyView') IS NOT NULL DROP TABLE #lt_RMCopyView
			CREATE TABLE #lt_RMCopyView
			(
				CopyId                  integer,
				StreamId                integer,
				MediaGroupId            integer,
				TotalRemainingMx        integer,
				primary key(CopyId, StreamId, MediaGroupId, TotalRemainingMx)
			)
			INSERT 	INTO #lt_RMCopyView
			SELECT 	CopyId, StreamId, MediaGroupId, SUM(RemainingMx) OVER (ORDER BY RemainingMx DESC, MediaGroupId) TotalRemainingMx
			FROM	( SELECT CopyId, StreamId, MediaGroupId, MIN(RemainingMx) AS RemainingMx
					  FROM 	@RMCopyView
					  GROUP BY CopyId, StreamId, MediaGroupId ) AS T
			SELECT 	@l_MaxTotalRemainingMx = MIN(TotalRemainingMx)
			FROM	#lt_RMCopyView
			WHERE	TotalRemainingMx >= @l_NumStreamsToHoldForIndex
			UPDATE	CV
			SET		RemainingMx = 0,
FailureErrorCode = 20176
			FROM	@RMCopyView CV, #lt_RMCopyView TCV
			WHERE	CV.CopyId = TCV.CopyId
					AND CV.StreamId = TCV.StreamId
					AND CV.MediaGroupId = TCV.MediaGroupId
					AND TCV.TotalRemainingMx <= @l_NumStreamsToHoldForIndex
					AND CV.FailureErrorCode = 0
			SELECT @NumCopyViews = @NumCopyViews - @@ROWCOUNT
			if @NumCopyViews = 0
			begin
set @o_ErrorCode = 2000
set @o_FailureType = 1
				GOTO EXIT_AND_RETURN
			end
			IF @l_MaxTotalRemainingMx > @l_NumStreamsToHoldForIndex
			BEGIN
				UPDATE	CV
				SET		RemainingMx = (@l_MaxTotalRemainingMx - @l_NumStreamsToHoldForIndex)
				FROM	@RMCopyView CV, #lt_RMCopyView TCV
				WHERE	CV.CopyId = TCV.CopyId
						AND CV.StreamId = TCV.StreamId
						AND CV.MediaGroupId = TCV.MediaGroupId
						AND TCV.TotalRemainingMx = @l_MaxTotalRemainingMx
			END
		end
	END
	ELSE -- @i_IsInlineCopy > 0
	BEGIN
		IF @allowCombineStreams > 0
		BEGIN
			WHILE @maxStreamNum > 0
			BEGIN
				INSERT INTO @RMCopyView
				SELECT @i_copyId,
							@maxStreamNum as Stream,
							0 as MediaGroupId,
							@i_MuxFactor as RemainingMx,
							0 as DrivePoolId,
							0 as DriveId,
							0 as VolumeId,
							0 as MediaId,
							0 as SpareGroupId,
							0 as MountPatchId,
							0 as ReservationId,
							0 as NoMux,
							0 as NoOtherSchedule,
							0 as ScheduleRunId,
							0 as LastUsedTime,
							0 as Priority,
							0,
							0
				SET @maxStreamNum = @maxStreamNum - 1
			END
			SET @NumCopyViews = @maxStreamNum
		END
		ELSE
		BEGIN
			-- Get all the active streams
			INSERT INTO @RMCopyView
			SELECT @i_copyId,
						StreamId as Stream,
						0 as MediaGroupId,
						count(distinct RCID) as RemainingMx,
						0 as DrivePoolId,
						0 as DriveId,
						0 as VolumeId,
						0 as MediaId,
						0 as SpareGroupId,
						0 as MountPatchId,
						0 as ReservationId,
						0 as NoMux,
						0 as NoOtherSchedule,
						0 as ScheduleRunId,
						0 as LastUsedTime,
						0 as Priority,
						0,
						0
			FROM	RMReservations WITH (READUNCOMMITTED)
			WHERE	RequestId = @i_RequestId
			AND		CopyId = @i_primaryCopyId
			GROUP BY StreamId
			SET @NumCopyViews = @@ROWCOUNT
		END
		UPDATE @RMCopyView
		SET		MediaGroupId = b.MediaGroupId
		FROM	@RMCopyView a, ArchStream b with (readuncommitted)
		WHERE	a.StreamId = b.Stream
		AND		a.CopyId = b.ArchGroupCopyId
		UPDATE	@RMCopyView
		SET			RemainingMx 	= CASE WHEN @allowCombineStreams > 0
																 THEN (SELECT RemainingMx - COUNT(RCId) FROM MMResourceToJob WITH (READUNCOMMITTED)
																 				WHERE ReservationId = b.ReservationId)
																 ELSE RemainingMx
														END,
						DrivePoolId		= isnull(b.DrivePoolId, 0),
						DriveId				= isnull(b.DriveId, 0),
						VolumeId			= isnull(b.VolumeId, 0),
						MediaId				= isnull(b.MediaId, 0),
						SpareGroupId	= isnull(b.SpareGroupId, 0),
						MountPathId		= isnull(b.MountPathId, 0),
						Reservationid	= isnull(b.ReservationId, 0),
NoMux					= (isnull(b.ResourceFlag, 0) & (2 | 4)),
						NoOtherSchedule	= (isnull(b.NoOtherSchedule, 0)),
						ScheduleRunId	= (isnull(b.ScheduleRunId, 0))
		FROM		@RMCopyView a, MMResource b with (readuncommitted)
		WHERE		a.CopyId = b.CopyId
		AND			a.StreamId = b.StreamId
		AND			b.IntrJobId_l = 0 AND b.HasJobInterrupted = 0
	END
	IF @NumCopyViews = 0
	BEGIN
IF EXISTS (SELECT * FROM @RMCopyView WHERE FailureErrorCode = 20025)
SET @o_ErrorCode = 20025
		ELSE
SET @o_ErrorCode = 2000
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	END
  -------------------------------------
  --          End of Module          --
  -------------------------------------
  -------------------------------------------------------
  -- Put non-Job related check first 									 --
  -------------------------------------------------------
  -------------------------------------------------------
  -- Filter: streams that are marked not multiplexable --
  -------------------------------------------------------
	update	@RMCopyView
set			FailureErrorCode = 20026
	where		FailureErrorCode = 0
	and			StreamId > 0
and		 ((NoMux & 1 > 0)
or (noMux & 2 > 0 and @i_forceMultiplexing = 0)
or (noMux & 4 > 0))
  select @NumCopyViews = @NumCopyViews - @@rowcount
  if @NumCopyViews = 0
  begin
set @o_ErrorCode = 20026
set @o_FailureType = 1
  	 GOTO EXIT_AND_RETURN
  end
  ---------------------------------
  -- Filter: check volume active --
  ---------------------------------
	update	@RMCopyView
set			FailureErrorCode = 801
	from		@RMCopyView a, MMVolume v with (readuncommitted)
	where		a.FailureErrorCode = 0
	and			a.VolumeId > 0 and a.VolumeId = v.VolumeId
	and
	(
		(
				v.VolumeFlags <> 1 -- VOL_ACTIVE
				and 		a.StreamId > 0
		)
		or
		(
				@i_SIDBStoreId > 0
				and @i_SIDBStoreId <> v.SIDBStoreId
		)
	)
	select @NumCopyViews = @NumCopyViews - @@rowcount
	if @NumCopyViews = 0
	begin
set @o_ErrorCode = 2000
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
  ---------------------------------
  -- Filter: check drive accessbile --
  ---------------------------------
	update	@RMCopyView
set			FailureErrorCode = 20002
	from		@RMCopyView a, MMDrive d with (readuncommitted)
	where		a.FailureErrorCode = 0
	and			a.DriveId > 0 and a.DriveId = d.DriveId
	and 		( d.CleaningRequired <> 0
				or 	d.DriveSoftState <> 1
				or	d.DriveEnabled <> 1
				or	d.DriveBroken <> 0)
	and			a.StreamId > 0
	select @NumCopyViews = @NumCopyViews - @@rowcount
	if @NumCopyViews = 0
	begin
set @o_ErrorCode = 2000
set @o_FailureType = 1
	end
  -------------------------------------------------------
  -------------------------------------------------------
  -------------------------------------------------------
  -------------------------------------------------------
  -- Put Job related check here			 									 --
  -------------------------------------------------------
  ------------------------------------------------------
  -- Filter: check flag isForRemainingStreams					--
  ------------------------------------------------------
  if @i_isForRemainingStreams > 0
  begin
if exists (select * from MMResourceToJob with (readuncommitted) where ReservationType = 2 and JobId_l = @i_JobId)
		begin
			update	@RMCopyView
set			FailureErrorCode = CASE WHEN @i_isForSILOBackup = 0 THEN 20034 ELSE 20112 END
			where		FailureErrorCode = 0
			and			DrivePoolId > 0
			and			DrivePoolId not in (
								select DrivePoolId from MMResource with (readuncommitted)
								where ReservationId
in (select ReservationId from MMResourceToJob with (readuncommitted) where ReservationType = 2 and JobId_l = @i_JobId)
							)
			SELECT @NumCopyViews = @NumCopyViews - @@ROWCOUNT
			IF @NumCopyViews = 0
			BEGIN
SET @o_ErrorCode = 20034
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			END
		end
		else
		begin
			set @i_isForRemainingStreams = 0
		end
  end
  -------------------------------------------------------
  -- Filter: don't allow other schedule to share media --
  -------------------------------------------------------
	update	@RMCopyView
set			FailureErrorCode = 20027
	from		@RMCopyView a, MMMedia m with (readuncommitted)
	where		FailureErrorCode = 0
	and 		a.StreamId > 0
	and			a.ReservationId > 0
	and			a.MediaId = m.MediaId
and			(m.Attributes & 134217728 > 0
					or @i_doNotAllowOtherSchedule > 0
					or @i_MarkActiveMediaFull > 0
					or a.NoOtherSchedule > 0)
	and			a.ScheduleRunId > 0
	and 		a.ScheduleRunId != @i_scheduleRunId
	select @NumCopyViews = @NumCopyViews - @@rowcount
	if @NumCopyViews = 0
	begin
set @o_ErrorCode = 20027
set @o_FailureType = 2
		GOTO EXIT_AND_RETURN
	end
  -------------------------------------------------------------------------
  -- Filter: check dataMultiStream for reservations from the same jobs --
  -------------------------------------------------------------------------
	update	@RMCopyView
set			FailureErrorCode = 20007
	where		FailureErrorCode = 0
	and 		@i_dataMultiStream = 0
	and			ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where jobId_l = @i_jobId)
	select @NumCopyViews = @NumCopyViews - @@rowcount
	if @NumCopyViews = 0
	begin
set @o_ErrorCode = 20007
set @o_FailureType = 2
		GOTO EXIT_AND_RETURN
	end
  -------------------------------------------------------
  -- Filter: check multiplexable for synthtic full job --
  -------------------------------------------------------
if @i_JobType = 7
	begin
			-- For each volume, make sure there is no data on volume for the same app num
			declare @cur_volumeId int
			declare @check_result int
			declare @volumelist table (VolumeId int)
			declare CheckSynthFullJob_cursor cursor for
			select VolumeId from @RMCopyView where VolumeId > 0 and FailureErrorCode = 0
			and MountPathId = 0
			open CheckSynthFullJob_cursor
			fetch next from CheckSynthFullJob_cursor into @cur_volumeId
			while @@FETCH_STATUS = 0
			begin
				set @check_result = 0
				exec @check_result = archMediaHasChunkForApp @i_AppNum, @cur_volumeId, @i_JobId, 1
				IF @@ERROR > 0
				BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				END
				if @check_result > 0
				begin
					insert into @volumelist select @cur_volumeId
				end
				fetch next from CheckSynthFullJob_cursor into @cur_volumeId
			end
			close CheckSynthFullJob_cursor
			deallocate CheckSynthFullJob_cursor
			update @RMCopyView
set			FailureErrorCode = 20057
			where		FailureErrorCode = 0
			and			VolumeId in (select distinct VolumeId from @volumeList)
			select @NumCopyViews = @NumCopyViews - @@rowcount
			if @NumCopyViews = 0
			begin
set @o_ErrorCode = 20057
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			end
	end
  -------------------------------------------------------
  -- Filter: check multiplexable for SILO backup 			--
  -------------------------------------------------------
-- The following check doesn't apply anymore since SILO job will use dedicated streams in 10.0 and seperate copy in 10.0
-------------------------------------------------------
--	-- The stream can be multiplexable only when current reservation is only for SILO backup.
--	-- Otherwise, the stream is reserved by the single instace job and using magnetic library.
--	-- If current job is the single instance job but not SILO, we cannot do mulitplex anyway.
--	-- Therefore, there is no need to do following check for single instance job.
--	if @i_isForSILOBackup > 0 and
--	exists (select * from @RMCopyView where FailureErrorCode = 0 and ReservationId > 0)
--	begin
--
--		declare @currentNonSiloJobList table (JobId int, ReservationId int)
--
--		insert	into @currentNonSiloJobList
--		select	b.JobId_l, b.ReservationId
--		from		@RMCopyView a, MMResourceToJob b with (readuncommitted)
--		where		a.FailureErrorCode = 0
--		and			a.ReservationId > 0
--		and			a.ReservationId = b.ReservationId
--		and			not exists (select JobId from JMBkpJobInfo with (readuncommitted)
--												where JobId = b.JobId_l and CommcellId = 2
--												and		1 = (isnull(bkpattributes, 0) & 0x100000000 /*JMBKP_SINGLE_INSTENCE_SILO*/))
--
--
--		update	@RMCopyView
--		set			FailureErrorCode = E_MM_RESERVE_NO_STREAMS_DONOT_MX
--		where		FailureErrorCode = 0 and ReservationId > 0
--		and			ReservationId in ( select distinct ReservationId from @currentNonSiloJobList )
--
--	  select @NumCopyViews = @NumCopyViews - @@rowcount
--	  if @NumCopyViews = 0
--	  begin
--	  	 set @o_ErrorCode = E_MM_RESERVE_NO_STREAMS_DONOT_MX
--	  	 set @o_FailureType = RM_FAILURE_JOB
--	  	 GOTO EXIT_AND_RETURN
--	  end
--
--
--	end
-------------------------------------------------------
  -------------------------------------------------------
  -- Filter: check multiplexable for NAS Drive Pool		 --
  -------------------------------------------------------
	-- When using NAS drive pool, backup job and App Type is NAS, do not allow Multiplexing.
	-- When using NAS drive pool, and AuxCopy job Writer, do not allow Mulitplexing.
	if exists (select a.DrivePoolId from @RMCopyView a, MMDrivePool b with (readuncommitted)
							where a.DrivePoolId > 0 and a.DrivePoolId = b.DrivePoolId
and b.DrivePoolType = 3)
	begin
		if (@i_JobType in (@AUXCOPYJOB, @MEDIAREFRESHINGJOB, @DASHCOPYJOB))
		begin
			update	@RMCopyView
set			FailureErrorCode = 20026
			where		FailureErrorCode = 0
			and			StreamId > 0 and DrivePoolId > 0
			and		 	DrivePoolId in (
															select a.DrivePoolId from @RMCopyView a, MMDrivePool b with (readuncommitted)
															where a.DrivePoolId > 0 and a.DrivePoolId = b.DrivePoolId
and b.DrivePoolType = 3
															)
		  select @NumCopyViews = @NumCopyViews - @@rowcount
		  if @NumCopyViews = 0
		  begin
set @o_ErrorCode = 20026
set @o_FailureType = 2
		  	 GOTO EXIT_AND_RETURN
		  end
		end
if (@i_JobType = 1 or @i_JobType = 4 or @i_JobType = 7)
and exists (select * from App_Application with (readuncommitted) where id = @i_AppNum and AppTypeId in (13, 88))
		begin
			update	@RMCopyView
set			FailureErrorCode = 20026
			where		FailureErrorCode = 0
			and			StreamId > 0 and DrivePoolId > 0
			and		 	DrivePoolId in (
															select a.DrivePoolId from @RMCopyView a, MMDrivePool b with (readuncommitted)
															where a.DrivePoolId > 0 and a.DrivePoolId = b.DrivePoolId
and b.DrivePoolType = 3
															)
		  select @NumCopyViews = @NumCopyViews - @@rowcount
		  if @NumCopyViews = 0
		  begin
set @o_ErrorCode = 20026
set @o_FailureType = 2
		  	 GOTO EXIT_AND_RETURN
		  end
		end
	end
  -------------------------------------------------------
  -- Filter: check Job Option for Drive Id						 --
  -------------------------------------------------------
	-- Check if the Job Option for Drive Id exists. If exists:
	-- Current job can only reserve this Drive if it is active.
	-- Current job can only multiplex this Drive if it is reserved.
	-- Current job can only interrupt this Drive if it is reserved and cannot be multiplexed.
 	DECLARE @jobOptionDriveIdList TABLE (DriveId int)
	INSERT INTO @jobOptionDriveIdList
SELECT	cast(dbo.GetJobOption(@i_JobId, 1238677445) as int)
	DELETE @jobOptionDriveIdList WHERE DriveId = 0
	IF EXISTS (SELECT * FROM @jobOptionDriveIdList)
	BEGIN
			update	@RMCopyView
set			FailureErrorCode = 20047
			where		FailureErrorCode = 0
			and			StreamId > 0 and DrivePoolId > 0
			and		 	DriveId not in ( select DriveId from @jobOptionDriveIdList )
		  select @NumCopyViews = @NumCopyViews - @@rowcount
		  if @NumCopyViews = 0
		  begin
set @o_ErrorCode = 20047
set @o_FailureType = 2
		  	 GOTO EXIT_AND_RETURN
		  end
	END
if @NumCopyViews > 0
set @o_ErrorCode = 0
/*
if @isDebug > 0
begin
	set @debugDetail = cast(isnull((select StreamId, FailureErrorCode	from @RMCopyView where FailureErrorCode > 0
																	for XML RAW('UnavailableStreams'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
	set @debugDetail = cast(isnull((select StreamId, MediaGroupId, RemainingMx, DrivePoolId, DriveId,
																				VolumeId, MediaId, SpareGroupId, MountPathId, ReservationId
																	from @RMCopyView where FailureErrorCode = 0
																	for XML RAW('AvailableStreams'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetCopyStreamView', @debugDetail, @i_RequestId, getutcdate())
end
*/
EXIT_AND_RETURN:
IF OBJECT_ID('tempdb..#lt_RMCopyView') IS NOT NULL DROP TABLE #lt_RMCopyView
-- Stream Randomization Enabled
if @i_isForSILOBackup = 0
and @l_archGroupflags & 4 > 0
begin
	DECLARE @thresholdInGB INT
	SET @thresholdInGB = 0
	SELECT	@thresholdInGB = isnull(value, 0)
	FROM		MMConfigs
	WHERE		name = 'MMS2_CONFIG_STREAM_DATA_DISTRIBUTION_THRESHOLD'
	if @thresholdInGB <= 0
	begin
		select * from @RMCopyView order by sign(ReservationId) desc, StreamId
	end
	else
	begin
		update @RMCopyView set Priority = ISNULL(b.PhysicalDataSizeInGB, 0) / @thresholdInGB
		from @RMCopyView a, ArchStream b with (readuncommitted)
		where a.CopyId = b.ArchGroupCopyId and a.StreamId = b.Stream
		select *
		from @RMCopyView
		order by sign(ReservationId) desc, Priority, StreamId
	end
end
else
begin
	select * from @RMCopyView
end
GO

IF EXISTS (select * from GxQscripts where name = 'RMGetCopyStreamView')
	delete from GxQscripts where name = 'RMGetCopyStreamView'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetCopyStreamView')
	delete from GXDBVersions where aliasname = 'RMGetCopyStreamView'
GO

insert into GXDBVersions values(2, 'RMGetCopyStreamView',  '00010035004600160000', 'RMGetCopyStreamView', '00010035004600160000')
GO

