

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMGetAvailableDrivesForDrivePool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMGetAvailableDrivesForDrivePool.sp,v $ $Id: RMGetAvailableDrivesForDrivePool.sp,v 1.20.2.7 2018/09/29 18:57:21 pnara Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMGetAvailableDrivesForDrivePool <<<'

IF EXISTS (select * from sysobjects where name='RMGetAvailableDrivesForDrivePool')
	drop procedure RMGetAvailableDrivesForDrivePool
IF EXISTS (select * from GxQscripts where name='RMGetAvailableDrivesForDrivePool')
	delete from GxQscripts where name = 'RMGetAvailableDrivesForDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetAvailableDrivesForDrivePool')
	delete from GXDBVersions where aliasname = 'RMGetAvailableDrivesForDrivePool'
GO
print '... Creating Procedure: RMGetAvailableDrivesForDrivePool'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMGetAvailableDrivesForDrivePool
  @i_RequestId integer,
  @i_CopyId integer,
  @i_JobId integer,
  @i_JobType integer,
  @i_drivePoolId integer,
  @i_MediaAgentId integer,
  @i_allowOtherDrivePoolsForHostAndLibrary integer,
  @i_recordingFormatId Integer,
  @i_volumeId integer,
  @i_driveId integer,
  @i_ReservationType integer,
  @i_IsForSwap integer,
  @isDebug integer,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are returned
/*
  DECLARE @o_DriveControllerId Integer
  DECLARE @o_DriveId integer
  DECLARE @o_DrivePoolId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_DeviceId integer
  DECLARE @o_DeviceControllerId integer
*/
/*
DECLARE @RMDriveViewWithOffline TABLE ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
*/
	-- declare output table
	/*
	declare @lt_DriveViewWithOffline TABLE (
				DriveControllerId Integer,
				DriveId Integer,
				DrivePoolId Integer,
				MountPathId	integer,
				DeviceId integer,
				DeviceControllerId integer,
				RMStatus Integer)
	*/
	-- determine input drivepools
	declare @lt_DrivePoolIds TABLE (DrivePoolId Integer)
	DECLARE @l_MasterPoolId INTEGER
	DECLARE @l_ClientId INTEGER
	DECLARE @l_NDMPHostId INTEGER
	SELECT TOP 1 @l_MasterPoolId = MasterPoolId,
							 @l_ClientId = ClientId,
							 @l_NDMPHostId = NDMPHostId
	FROM MMDrivePool  with (readuncommitted)
	WHERE DrivePoolId = @i_drivePoolId
	IF (@l_MasterPoolId  is null)
	BEGIN
		GOTO PROC_EXIT
	END
	IF (@i_allowOtherDrivePoolsForHostAndLibrary = 1)
	BEGIN
		-- if a drive pool is specified, this leads to a host and a masterpool.
		-- There could be multiple drivepools for the same host though in the case of multiple HBAs (starting 6.1)
		-- and multiple drivepools when there are different drivetypes.
		-- so allow (optionally) to override drivepool as long as it still points to the same masterpool and client
		-- (we also have to take care of NAS).
		IF (@l_NDMPHostId > 0)
		BEGIN
			INSERT INTO @lt_DrivePoolIds
			SELECT DrivePoolId
			FROM MMDrivePool with (readuncommitted)
			WHERE MasterPoolId = @l_MasterPoolId AND NDMPHostId = @l_NDMPHostId
		END ELSE
		BEGIN
			INSERT INTO @lt_DrivePoolIds
			SELECT DrivePoolId
			FROM MMDrivePool with (readuncommitted)
			WHERE MasterPoolId = @l_MasterPoolId AND ClientId = @l_ClientId
		END
	END ELSE
	BEGIN
		-- do not override drivepool, just insert the one passed in
		INSERT INTO @lt_DrivePoolIds
		SELECT @i_drivePoolId
	END
	DECLARE @NumDataPathViews INT
  EXEC SQLUtilTruncateTable 'HistoryDB..RMDataPathView'
	INSERT INTO RMDataPathView
	SELECT	@i_RequestId, 0, 0, a.DrivePoolId, h.ClientId,
				l.LibraryId, mp.MasterPoolId, 0, 0, l.LibraryTypeId,
				mp.MaxSwitchForHost, dp.MaxDrivestoSwitch, h.MaxReservations,
				l.LibraryAttribute, l.ExtendedAttributes, l.RestrictActivity,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, l.LibrarySubType
	FROM	@lt_DrivePoolIds a, MMMasterPool mp with (readuncommitted), MMDrivePool dp with (readuncommitted), MMHost h with (readuncommitted), MMLibrary l with (readuncommitted)
	WHERE a.DrivePoolId = dp.DrivePoolId
	AND		dp.MasterPoolId = mp.MasterPoolId
	AND		h.ClientId = dp.ClientId
	AND		mp.LibraryId = l.LibraryId
	DECLARE @isTransactionLogBackupPhase INT = 0
	EXEC MMIsTransactionLogBackupPhase @i_JobId, 2, @isTransactionLogBackupPhase output
  exec RMDataPathStatusFilters @i_RequestId, @i_ReservationType, 0 /*copyId*/, @i_JobId, @i_JobType, 0 /*@AppNum*/, 0 /*@AppType*/, 0 /*@IsForRemainingStreams*/,
													0 /*@IsForSILOBackup*/, 0 /*currentSIDBStoreId*/, 0 /*@inClientId*/, 0 /*@MAClientId*/, 0 /*@isIndexingRequired*/, 0 /*@i_isUseSCDataPath*/, @isTransactionLogBackupPhase, 0 /*SIDBStoreId*/,
													@isDebug, @o_ErrorCode output, @o_FailureType output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO PROC_EXIT
	END
	select @NumDataPathViews = COUNT(*) from RMDataPathView WHERE FailureErrorCode = 0
	if @NumDataPathViews = 0
	begin
if @o_ErrorCode = 0
set @o_ErrorCode = 20013
		  GOTO PROC_EXIT
	end
	IF object_id('tempdb.dbo.#tmpRMDriveViewWithOffline') IS NULL
CREATE TABLE #tmpRMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, Priority					integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
	delete #tmpRMDriveViewWithOffline
	--insert into #tmpRMDriveViewWithOffline
	exec RMGetDriveView @i_RequestId, @i_JobId, 0 /*@appType*/, @i_ReservationType, @i_IsForSwap, 0 /*@numStreams*/, 0 /*@bestcaseReserve*/, @i_CopyId, 0 /*@UsePartialFullMedia*/,
											 @isDebug,  @o_ErrorCode output, @o_FailureType output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO PROC_EXIT
	END
	-- Make sure the drive can mount the media
	if @i_volumeId > 0
	begin
		declare @MediaId int = (select MediaId from MMVolume with (readuncommitted) where VolumeId = @i_volumeId)
if @i_recordingFormatId = 10001
		begin
			delete from #tmpRMDriveViewWithOffline
			where	MountPathId > 0
			and		MountPathId not in (select mp.MountPathId from MMVolume v with (readuncommitted), MMMountPath mp with (readuncommitted)
																where	v.VolumeId = @i_volumeId
																and		mp.MediaSideId = v.MediaSideId)
			IF NOT EXISTS (SELECT * FROM #tmpRMDriveViewWithOffline WHERE FailureErrorCode = 0)
AND @o_ErrorCode = 0
			BEGIN
				SET @o_ErrorCode = ISNULL((
														SELECT	TOP 1 FailureErrorCode
														FROM		#tmpRMDriveViewWithOffline
														WHERE		FailureErrorCode > 0
														ORDER BY FailurePriority DESC
), 807)
set @o_FailureType = 2
				GOTO PROC_EXIT
			END
		end
		-- cliu 08/26/2013, MR 101811 10.0: PnP Library does not reserve drive devices properly when configured with multiple drives
		-- When volume is PnP disk media, there is no mount path associated with media and only one drive is available to access it.
		-- In some cases, we can configure multipe PnP usb port for on drive pool, we need to make sure the given volume can be accessed by the correct drive.
else if @i_recordingFormatId = 11002
		begin
			if not exists (select * from MMDrive with (readuncommitted) where MediaId = @MediaId)
			begin
SET @o_ErrorCode = 807
set @o_FailureType = 2
				GOTO PROC_EXIT
			end
			delete from #tmpRMDriveViewWithOffline
			where	DriveId > 0
			and		DriveId not in (select DriveId from MMDrive with (readuncommitted)
									where MediaId = @MediaId
									)
		end
		else
		begin
			declare @MediaTypeId int
			select @MediaTypeId = ISNULL(MediaTypeId, 0)
			from	MMMedia with (readuncommitted)
			where	MediaId = @MediaId
			update	#tmpRMDriveViewWithOffline
set			FailureErrorCode = 260,
							FailurePriority = -1
			from		#tmpRMDriveViewWithOffline a
			where		FailureErrorCode = 0
			and			not exists (select d.DriveTypeId from MMDrive d with (readuncommitted), MMRecFmtMedTyp rfmt with (readuncommitted)
									where a.DriveId = d.DriveId
									and		d.DriveTypeId = rfmt.DriveTypeId
									and		(
												-- if the media is clean media, we only check the media type, not recording format
												rfmt.CleaningMediaTypeId = @MediaTypeId
												or
												-- Recording Format Id need to be supported by drive type
												(
													rfmt.RecordingFormatId = @i_recordingFormatId
													and (
															(
(@i_ReservationType & 1) = 1
and (rfmt.CompatibilityType & 4) > 0
															)
															or
															(
(@i_ReservationType & 2) = 2
and (rfmt.CompatibilityType & 2) > 0
															)
														)
												)
											)
									)
			IF NOT EXISTS (SELECT * FROM #tmpRMDriveViewWithOffline WHERE FailureErrorCode = 0)
AND @o_ErrorCode = 0
			BEGIN
				SET @o_ErrorCode = ISNULL((
														SELECT	TOP 1 FailureErrorCode
														FROM		#tmpRMDriveViewWithOffline
														WHERE		FailureErrorCode > 0
														ORDER BY FailurePriority DESC
), 807)
set @o_FailureType = 2
				GOTO PROC_EXIT
			END
		end
	end
	PROC_EXIT:
	-- If there is drive/mount path available, reset the error code here.
	if exists (select top 1 * from #tmpRMDriveViewWithOffline where FailureErrorCode = 0)
	begin
SET @o_ErrorCode = 0
	end
	/*
	select distinct DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId,
					SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0
	from	#tmpRMDriveViewWithOffline
	where	FailureErrorCode = 0
	*/
GO

IF EXISTS (select * from GxQscripts where name = 'RMGetAvailableDrivesForDrivePool')
	delete from GxQscripts where name = 'RMGetAvailableDrivesForDrivePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMGetAvailableDrivesForDrivePool')
	delete from GXDBVersions where aliasname = 'RMGetAvailableDrivesForDrivePool'
GO

insert into GXDBVersions values(2, 'RMGetAvailableDrivesForDrivePool',  '00010020000200070000', 'RMGetAvailableDrivesForDrivePool', '00010020000200070000')
GO

