

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMExchangeMultiplexingSourceVolume.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMExchangeMultiplexingSourceVolume.sp,v $ $Id: RMExchangeMultiplexingSourceVolume.sp,v 1.1.52.2 2018/03/19 23:56:20 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMExchangeForMAAndDP()
--  +========================================================================+
--
--
--	This is stored procedure used for exchange existing reservation for the given Media Agent and DrivePool.
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMExchangeMultiplexingSourceVolume <<<'

IF EXISTS (select * from sysobjects where name='RMExchangeMultiplexingSourceVolume')
	drop procedure RMExchangeMultiplexingSourceVolume
IF EXISTS (select * from GxQscripts where name='RMExchangeMultiplexingSourceVolume')
	delete from GxQscripts where name = 'RMExchangeMultiplexingSourceVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeMultiplexingSourceVolume')
	delete from GXDBVersions where aliasname = 'RMExchangeMultiplexingSourceVolume'
GO
print '... Creating Procedure: RMExchangeMultiplexingSourceVolume'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMExchangeMultiplexingSourceVolume
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationId integer;
  DECLARE @o_DriveId integer;
  DECLARE @o_RCId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @debugDetail varchar(max)
set @o_ErrorCode = 0
set @o_FailureType = 1
	set @o_ReservationId = 0
	set @o_DriveId = 0
	set @o_RCId = 0
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	if @i_isDebug > 0
	  insert into RMLogger values ('RMExchangeForRestore', 'Enter...', @i_RequestId, getutcdate())
	declare @sourceReservationResults XML
	set @sourceReservationResults = ''
	declare @RequestTime		int
	declare @FailureAttempts int
	declare @commCellId				int
	declare @phaseFirstAttemptTime	bigint
	declare @oldVolumeId		int
	declare @oldDrivePoolId int
	declare @volId			int
	declare @DrvPoolId	int
	declare @mediaAgentName	varchar(256)
	declare @mediaAgentId	int
	declare @mediaId		int
	declare @MediaGrpId	int
	declare @jobId			bigint
	declare @jobType		int
	declare @jobOpType	int
	declare @iDAType		int
	declare @priority		int
	declare @preEmptable			int
	declare @bestcaseReserve	int
	declare @rtype			int
	declare @checkConcurrency	int
	declare @isDummyReservation	int
	declare @destinationMediaGroupId	int
	declare @copyId			int
	declare @driveId		int
	declare @rsvBitMask int
	declare @xmlRegistrySetting XML
	declare @xmlParams	XML
	DECLARE @reservationId	int
	DECLARE @RCId						int
	DECLARE @ReservationType int
	set @RequestTime				= 0
	set @FailureAttempts		= 0
	set @phaseFirstAttemptTime	 = 0
	set @oldVolumeId		= 0
	set @oldDrivePoolId = 0
	set @volId					= 0
	set @DrvPoolId			= 0
	set @mediaAgentName	= ''
	set @mediaAgentId		= 0
	set @mediaId				= 0
	set @MediaGrpId			= 0
	set @jobId					= 0
	set @commCellId			= 0
	set @jobType 				= 0
	set @jobOpType			= 0
	set @iDAType				= 0
	set @priority				= 0
	set @preEmptable		= 0
	set @bestcaseReserve	= 0
	set @rtype					= 0
	set @checkConcurrency	= 0
	set @isDummyReservation	= 0
	set @destinationMediaGroupId	= 0
	set @copyId					= 0
	set @driveId				= 0
	set @rsvBitMask			= 0
	set @xmlParams			= ''
	set @reservationId	= 0
	set @RCId						= 0
	set @ReservationType = 0
	select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@commCellId = commCellId,
		@jobId = jobId,
		@jobType = jobType,
		@jobOpType = jobOpType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@xmlRegistrySetting = registrySetting,
		@xmlParams	= xmlParams
	from RMReservationRequest
	where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL AND @xmlParams.exist('/ResourceManager_RmExchangeVolumeArgs_t') > 0
	BEGIN
		SELECT	@oldVolumeId								= params.value('@oldVolumeId', 'int'),
						@oldDrivePoolId							= params.value('@oldDrivePoolId', 'int'),
						@ReservationId							= params.value('@reservationId', 'int'),
						@RCId									= params.value('@rcId', 'int'),
						@ReservationType						= params.value('@reservationType', 'int')
				FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]') AS R(params)
		SELECT	@volId											= params.value('@volId', 'int'),
						@DrvPoolId									= params.value('@DrvPoolId', 'int'),
						@mediaAgentName							= params.value('@mediaAgentName', 'varchar(256)'),
						@mediaId										= params.value('@mediaId', 'int'),
						@MediaGrpId									= params.value('@MediaGrpId', 'int'),
						--@jobId											= params.value('@jobId', 'bigint'),
						@jobOpType									= params.value('@jobOpType', 'int'),
						@priority										= params.value('@priority', 'int'),
						@preEmptable								= params.value('@preEmptable', 'int'),
						@bestcaseReserve						= params.value('@bestcaseReserve', 'int'),
						@rtype											= params.value('@rtype', 'int'),
						@checkConcurrency						= params.value('@checkConcurrency', 'int'),
						@isDummyReservation					= params.value('@isDummyReservation', 'int'),
						@destinationMediaGroupId		= params.value('@destinationMediaGroupId', 'int'),
						@copyId											= params.value('@copyId', 'int'),
						@driveId										= params.value('@driveId', 'int'),
						@rsvBitMask									= params.value('@resBitMask', 'int')
				FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]/newArgs[1]') AS R(params)
	END
	SET @mediaId = 0
	SELECT @mediaId = ISNULL(MediaId, 0) FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId
	IF @volId IS NULL OR @volId <= 0 OR @mediaId = 0
	BEGIN
SET @o_ErrorCode = 268
		insert into RMLogger values ('RMExchangeMultiplexingSourceVolume', 'The specified volume id is invalid', @i_RequestId, getutcdate())
		goto exit_error
	END
	declare @rmJustId table (id int)
	declare @isForSwap int = 0
	IF @DrvPoolId <= 0 and @MediaGrpId > 0
		BEGIN
		SELECT @DrvPoolId = DrivePoolId
		FROM	MMMediaGroup with (readuncommitted)
		WHERE	MediaGroupId = @MediaGrpId
	END
	IF LEN(@mediaAgentName) > 0
	BEGIN
		SELECT TOP 1 @mediaAgentId = h.ClientId
		FROM	MMHost h WITH (READUNCOMMITTED), APP_Client c WITH (READUNCOMMITTED)
		WHERE	H.ClientId = c.Id
		AND		c.Net_HostName = @mediaAgentName
	END
	IF (@mediaAgentId IS NULL OR @mediaAgentId = 0)
 	AND @DrvPoolId > 0
 	BEGIN
  		SELECT @mediaAgentId = ClientId
  		FROM	MMDrivePool WITH (READUNCOMMITTED)
  		WHERE DrivePoolId = @DrvPoolId
	END
	if @DrvPoolId <= 0
	begin
set @o_ErrorCode = 398
		insert into RMLogger values ('RMExchangeMultiplexingSourceVolume', 'Cannot find the drive pool information for exchange reader reservation', @i_RequestId, getutcdate())
		goto exit_error
	end
	declare @danglingReservationId int = 0;
	if @RCId > 0
	begin
		select @danglingReservationId = reservationId from MMResourceToJob with (NOLOCK) where RCId = @RCId
	end
	else
	begin
		select TOP 1 @danglingReservationId = res.ReservationId
		from MMResource res with (NOLOCK), MMResourceToJob resToJob with (NOLOCK)
		where	resToJob.JobId_l = @jobId
		and		res.ReservationId = resToJob.ReservationId
		and		res.DrivePoolId = @oldDrivePoolId
		and		res.VolumeId = @oldVolumeId
		and		res.HasJobInterrupted = 0
	end
	if @i_isDebug > 0
		insert into RMLogger values ('RMExchangeMultiplexingSourceVolume',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], MediaId['
																				+ cast(isnull(@mediaId, 0) as varchar(20)) + '], DrivePoolId['
																				+ cast(isnull(@DrvPoolId, 0) as varchar(20)) + '] DriveId['
																				+ cast(isnull(@DriveId, 0) as varchar(20)) + '] JobId['
																				+ cast(isnull(@JobId, 0) as varchar(20)) + '] OldVolumeId['
																				+ cast(isnull(@oldVolumeId, 0) as varchar(20)) + '] OldDrivePoolId['
																				+ cast(isnull(@oldDrivePoolId, 0) as varchar(20)) + ']',
						@i_RequestId, getutcdate())
	-- If the same volume has been reserved by the job with the given drive pool, then there is no need to create a new reservation. Just an entry in MMResourceToJob table.
	-- If not, then do regular reservation on the volume.
	set @ReservationId = 0
	select TOP 1 @ReservationId = res.ReservationId
	from MMResource res with (NOLOCK), MMResourceToJob resToJob with (NOLOCK)
	where	resToJob.JobId_l = @jobId
	and		res.ReservationId = resToJob.ReservationId
	and		res.DrivePoolId = @DrvPoolId
	and		res.VolumeId = @volId
	and		res.HasJobInterrupted = 0
	if @ReservationId  = 0
	begin
		select @isForSwap = case when @oldDrivePoolId = @DrvPoolId then 1 else 0 end
		exec @o_ErrorCode = RMReserveReaders @i_RequestId, @isForSwap,
																				@i_isDebug,
																				@o_ReservationId output, @o_DriveId output, @o_RCId output, @sourceReservationResults output,
																				@o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
		  GOTO exit_error
		END
if @o_ErrorCode != 0
		begin
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeMultiplexingSourceVolume', 'Reservation for backup return error code ['
				  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
			goto exit_error
		end
		set @sourceReservationResults = (select @o_ReservationId reservationId, @o_DriveId driveId	for XML RAW('copyRsrvList'), TYPE)
	end
	else
	begin
		set @o_ReservationId = @ReservationId
		set @o_RCId = 0
		select @o_DriveId = DriveId from MMResource with (NOLOCK) where ReservationId = @o_ReservationId
		set @sourceReservationResults = (select @o_ReservationId reservationId, @o_DriveId driveId	for XML RAW('copyRsrvList'), TYPE)
	end
	-- If the exchange is based on the RCId, then reuse the given RCID and point that to the new reservation, then remove the new RCID
	if @RCId > 0 and exists (select 1 from MMResourceToJob with (NOLOCK) where RCId = @RCId and JobId_l = @jobId)
	begin
		UPDATE MMResourceToJob SET ReservationId = @o_ReservationId, ReleaseTime = 0 WHERE RCId = @RCId and JobId_l = @jobId
		if @o_RCId > 0
			DELETE FROM MMResourceToJob WHERE RCId = @o_RCId
		SET @o_RCId = @RCId
	end
	-- if not, the exchange is based on volume and drive pool. Update reservation Id for all the entries in MMResourceToJob table
	else
	begin
		UPDATE MMResourceToJob SET ReservationId = @o_ReservationId, ReleaseTime = 0 WHERE ReservationId = @danglingReservationId and JobId_l = @jobId
		if @o_RCId > 0
			DELETE FROM MMResourceToJob WHERE RCId = @o_RCId
	end
	if @danglingReservationId > 0 and exists (SELECT 1 FROM MMResourceToJob WHERE ReservationId = @danglingReservationId)
	begin
		if exists (select 1 from MMResourceToJob with (NOLOCK) where ReservationId = @danglingReservationId and PreEmptable = 0)
		begin
			UPDATE MMResource
			SET Priority = ISNULL((SELECT MIN(Priority) FROM MMResourceToJob WHERE ReservationId = @danglingReservationId and PreEmptable = 0), Priority)
			WHERE	ReservationId = @danglingReservationId
		end
		else
		begin
			UPDATE MMResource
			SET Priority = ISNULL((SELECT MIN(Priority) FROM MMResourceToJob WHERE ReservationId = @danglingReservationId), Priority)
			WHERE	ReservationId = @danglingReservationId
		end
	end
	else
	begin
		DELETE FROM MMResource WHERE ReservationId = @danglingReservationId
	end
exit_error:
	if @sourceReservationResults is not null and len(cast(@sourceReservationResults as nvarchar(max))) > 0
		set @sourceReservationResults = '<ResourceManager_ReservationList>' + cast(@sourceReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		ReservationResults = LEFT(cast(@sourceReservationResults as nvarchar(max)), 4000)
  where RequestId = @i_RequestId
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
	  select top 1 ErrorCode, FailureType, @o_ReservationId, @o_DriveId, @o_RCId
	  from RMReservationRequest
	  where RequestId = @i_RequestId
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
  end
	*/
	if @i_isDebug > 0
	  insert into RMLogger values('RMExchangeForRestore', 'Exit...', @i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMExchangeMultiplexingSourceVolume')
	delete from GxQscripts where name = 'RMExchangeMultiplexingSourceVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeMultiplexingSourceVolume')
	delete from GXDBVersions where aliasname = 'RMExchangeMultiplexingSourceVolume'
GO

insert into GXDBVersions values(2, 'RMExchangeMultiplexingSourceVolume',  '00010001005200020000', 'RMExchangeMultiplexingSourceVolume', '00010001005200020000')
GO

