

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMExchangeForRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMExchangeForRestore.sp,v $ $Id: RMExchangeForRestore.sp,v 1.12.58.5 2018/03/20 00:05:55 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMExchangeForRestore()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMExchangeForRestore <<<'

IF EXISTS (select * from sysobjects where name='RMExchangeForRestore')
	drop procedure RMExchangeForRestore
IF EXISTS (select * from GxQscripts where name='RMExchangeForRestore')
	delete from GxQscripts where name = 'RMExchangeForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForRestore')
	delete from GXDBVersions where aliasname = 'RMExchangeForRestore'
GO
print '... Creating Procedure: RMExchangeForRestore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMExchangeForRestore
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationId integer;
  DECLARE @o_DriveId integer;
  DECLARE @o_RCId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @debugDetail varchar(max)
set @o_ErrorCode = 0
set @o_FailureType = 1
	set @o_ReservationId = 0
	set @o_DriveId = 0
	set @o_RCId = 0
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	if @i_isDebug > 0
	  insert into RMLogger values ('RMExchangeForRestore', 'Enter...', @i_RequestId, getutcdate())
	declare @sourceReservationResults XML
	set @sourceReservationResults = ''
  declare @RequestTime		int
  declare @FailureAttempts int
  declare @commCellId				int
	declare @phaseFirstAttemptTime	bigint
	declare @oldVolumeId		int
	declare @oldDrivePoolId int
	declare @volId			int
	declare @DrvPoolId	int
	declare @mediaAgentName	varchar(256)
	declare @mediaAgentId	int
	declare @mediaId		int
	declare @MediaGrpId	int
	declare @jobId			bigint
	declare @jobType		int
	declare @jobOpType	int
	declare @iDAType		int
	declare @priority		int
	declare @preEmptable			int
	declare @bestcaseReserve	int
	declare @rtype			int
	declare @checkConcurrency	int
	declare @isDummyReservation	int
	declare @destinationMediaGroupId	int
	declare @copyId			int
	declare @driveId		int
	declare @rsvBitMask int
	declare @xmlRegistrySetting XML
	declare @xmlParams	XML
	DECLARE @reservationId	int
	DECLARE @RCId						int
	DECLARE @ReservationType int
  set @RequestTime				= 0
  set @FailureAttempts		= 0
  set @phaseFirstAttemptTime	 = 0
	set @oldVolumeId		= 0
	set @oldDrivePoolId = 0
	set @volId					= 0
	set @DrvPoolId			= 0
	set @mediaAgentName	= ''
	set @mediaAgentId		= 0
	set @mediaId				= 0
	set @MediaGrpId			= 0
	set @jobId					= 0
  set @commCellId			= 0
  set @jobType 				= 0
	set @jobOpType			= 0
	set @iDAType				= 0
	set @priority				= 0
	set @preEmptable		= 0
	set @bestcaseReserve	= 0
	set @rtype					= 0
	set @checkConcurrency	= 0
	set @isDummyReservation	= 0
	set @destinationMediaGroupId	= 0
	set @copyId					= 0
	set @driveId				= 0
	set @rsvBitMask			= 0
	set @xmlParams			= ''
	set @reservationId	= 0
	set @RCId						= 0
	set @ReservationType = 0
	select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@commCellId = commCellId,
		@jobId = jobId,
		@jobType = jobType,
		@jobOpType = jobOpType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@xmlRegistrySetting = registrySetting,
		@xmlParams	= xmlParams
  from RMReservationRequest
  where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL AND @xmlParams.exist('/ResourceManager_RmExchangeVolumeArgs_t') > 0
	BEGIN
		SELECT	@oldVolumeId								= params.value('@oldVolumeId', 'int'),
						@oldDrivePoolId							= params.value('@oldDrivePoolId', 'int'),
						@ReservationId							= params.value('@reservationId', 'int'),
						@ReservationType						= params.value('@reservationType', 'int')
				FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]') AS R(params)
		SELECT	@volId											= params.value('@volId', 'int'),
						@DrvPoolId									= params.value('@DrvPoolId', 'int'),
						@mediaAgentName							= params.value('@mediaAgentName', 'varchar(256)'),
						@mediaId										= params.value('@mediaId', 'int'),
						@MediaGrpId									= params.value('@MediaGrpId', 'int'),
						--@jobId											= params.value('@jobId', 'bigint'),
						@jobOpType									= params.value('@jobOpType', 'int'),
						@priority										= params.value('@priority', 'int'),
						@preEmptable								= params.value('@preEmptable', 'int'),
						@bestcaseReserve						= params.value('@bestcaseReserve', 'int'),
						@rtype											= params.value('@rtype', 'int'),
						@checkConcurrency						= params.value('@checkConcurrency', 'int'),
						@isDummyReservation					= params.value('@isDummyReservation', 'int'),
						@destinationMediaGroupId		= params.value('@destinationMediaGroupId', 'int'),
						@copyId											= params.value('@copyId', 'int'),
						@driveId										= params.value('@driveId', 'int'),
						@rsvBitMask									= params.value('@resBitMask', 'int')
				FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]/newArgs[1]') AS R(params)
	END
	SET @mediaId = 0
	SELECT @mediaId = ISNULL(MediaId, 0) FROM MMVolume with (readuncommitted) WHERE VolumeId = @volId
	IF @volId IS NULL OR @volId <= 0 OR @mediaId = 0
	BEGIN
SET @o_ErrorCode = 268
		insert into RMLogger values ('RMExchangeForRestore', 'The specified volume id is invalid', @i_RequestId, getutcdate())
		goto exit_error
	END
  declare @rmJustId table (id int)
	declare @isForSwap int
	set @isForSwap = 0
  --------------------------------
  -- Module: claim interruption --
  --------------------------------
  if exists (select * from MMResource where HasJobInterrupted = 1 and ReservationId in
  						 (select ReservationId from MMResourceToJob where JobId_l = @jobId))
  begin
		-- check if interrupted resource can be claimed
		-- There is no need to check the status in MMResource, as long as the entry MMResourceToJob is marked released for interrupted jobs.
		--if exists (select * from MMResource  with (readuncommitted) where intrjobid_l = @jobId and Released = 0)
		if exists (select * from MMResourceToJob  with (readuncommitted) where ReservationId in (select ReservationId from MMResource  with (readuncommitted) where intrjobid_l = @jobId)
and NOT (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))))
or exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and DriveId in (select DriveId from MMDrive with (readuncommitted) where MountStatus in (2, 3)))
		begin
		  -- interrupted resources are not freed yet
			set @debugDetail = cast(isnull((
												select	ReservationId, CopyId, StreamId, DrivePoolId, DriveId, MediaId, MountPathId
												from		MMResource
												where		intrjobId_l = @JobId
												for XML RAW('InterruptedStreams'), TYPE), 'No Interrupted Resources') as nvarchar(max))
  		insert into RMLogger values ('RMReserveReader',
  				'Error return because Interrupted resources are not freed yet' + @debugDetail, @i_RequestId, getutcdate())
set @o_ErrorCode = 20004
set @o_FailureType = 2
		  goto exit_error
		end
		-- release interrupted resource
		delete from MMresourceToJob
		where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @jobId)
and (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0)))
		delete from MMResource where intrjobid_l = @jobId
		-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
		-- those are place holder anyway, also we will have to check availability of everything
		delete @rmJustId
		insert into @rmJustId
		select reservationid from MMResource where ReservationId in (select ReservationId from MMResourceToJob where JobId_l = @jobId) and HasJobInterrupted = 1
		if @i_isDebug > 0
		begin
			set @debugDetail = cast(isnull((
												select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.MediaId, a.DriveId, a.LibraryId, b.RCID, b.JobId_l
												from MMResource a, MMResourceToJob b
												where a.ReservationId = b.ReservationId and a.ReservationId in (select id from @rmJustId)
												for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resources') as nvarchar(max))
			insert into RMLogger values ('Claim Interruption', @debugDetail, @i_RequestId, getutcdate())
		end
    delete from MMResourceToJob where ReservationId in (select id from @rmJustId)
    delete from MMResource where ReservationId in (select id from @rmJustId)
  end
  ---------------------------------------
  -- End of Module: claim interruption --
  ---------------------------------------
  IF @DrvPoolId <= 0 and @MediaGrpId > 0
  BEGIN
  	SELECT @DrvPoolId = DrivePoolId
  	FROM	MMMediaGroup with (readuncommitted)
  	WHERE	MediaGroupId = @MediaGrpId
	END
  IF LEN(@mediaAgentName) > 0
  BEGIN
  	SELECT TOP 1 @mediaAgentId = h.ClientId
  	FROM	MMHost h WITH (READUNCOMMITTED), APP_Client c WITH (READUNCOMMITTED)
  	WHERE	H.ClientId = c.Id
  	AND		c.Net_HostName = @mediaAgentName
  END
	IF (@mediaAgentId IS NULL OR @mediaAgentId = 0)
 	AND @DrvPoolId > 0
 	BEGIN
  		SELECT @mediaAgentId = ClientId
  		FROM	MMDrivePool WITH (READUNCOMMITTED)
  		WHERE DrivePoolId = @DrvPoolId
	END
	if @DrvPoolId <= 0
	begin
set @o_ErrorCode = 398
		insert into RMLogger values ('RMExchangeForRestore', 'Cannot find the drive pool information for exchange reader reservation', @i_RequestId, getutcdate())
		goto exit_error
	end
	if @i_isDebug > 0
		insert into RMLogger values ('RMExchangeForRestore',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], MediaId['
																				+ cast(isnull(@mediaId, 0) as varchar(20)) + '], DrivePoolId['
																				+ cast(isnull(@DrvPoolId, 0) as varchar(20)) + '] DriveId['
																				+ cast(isnull(@DriveId, 0) as varchar(20)) + '] JobId['
																				+ cast(isnull(@JobId, 0) as varchar(20)) + '] OldVolumeId['
																				+ cast(isnull(@oldVolumeId, 0) as varchar(20)) + '] OldDrivePoolId['
																				+ cast(isnull(@oldDrivePoolId, 0) as varchar(20)) + ']',
						@i_RequestId, getutcdate())
	-- Check if the new volume reservable
 	declare @isReservable int
 	set @isReservable = 0
 	exec RMIsVolumeReservable @i_RequestId, @JobId, @volId, @MediaGrpId, 	@DrvPoolId, 0, @mediaAgentId, 0,
1, 1, @i_isDebug,
 														@isReservable output, @o_ErrorCode output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
	END
	if @i_isDebug > 0
	begin
			set @debugDetail = cast(isnull((
												select (case when @isReservable = 1 then 'YES' else 'NO' end) IsVolumeReservable,
																@o_ErrorCode ErrorCode,
																@jobId JobId, @volId VolumeId, @MediaGrpId MediaGroupId, @DrvPoolId DrivePoolId,
																0 MasterPoolId, @mediaAgentId MediaAgentId, 0 LibraryId,
1 ReservationType, 1 CheckOppositeSide
												for XML RAW('RMIsVolumeReservable'), TYPE), 'No params for RMIsVolumeReservable') as nvarchar(max))
		insert into RMLogger values ('RMExchangeForRestore', @debugDetail, @i_RequestId, getutcdate())
	end
	-- If the volume is not reservable, check if we need to interrupt or multiplexing
	if @isReservable = 0
	begin
		select @isForSwap = case when @oldDrivePoolId = @DrvPoolId then 1 else 0 end
		exec @o_ErrorCode = RMReserveReaders @i_RequestId, @isForSwap,
																				@i_isDebug,
																				@o_ReservationId output, @o_DriveId output, @o_RCId output, @sourceReservationResults output,
																				@o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
		END
		-- Volume is reserved because of multiplexing
if @o_ErrorCode = 0
		begin
			-- release the old reservation
			SELECT @reservationId = ReservationId FROM MMResource WHERE VolumeId = @oldVolumeId AND DrivePoolId = @oldDrivePoolId
			SELECT @RCId = RCID FROM MMResourceToJob WHERE JobId_l = @jobId AND ReservationId = @reservationId
			-- Reuse the original RCID
			IF @RCID IS NOT NULL AND EXISTS (SELECT * FROM MMResourceToJob WHERE RCID = @RCID)
			BEGIN
				UPDATE MMResourceToJob SET ReservationId = @o_ReservationId, ReleaseTime = 0 WHERE RCId = @RCId
				DELETE FROM MMResourceToJob WHERE RCId = @o_RCId
				SET @o_RCId = @RCId
			END
			-- If there are no other jobs reserved the same old volume, delete the reservation
			IF EXISTS (SELECT * FROM MMResourceToJob WHERE ReservationId = @reservationId)
			BEGIN
				UPDATE MMResource SET Priority = ISNULL((SELECT MIN(Priority) FROM MMResourceToJob WHERE ReservationId = @reservationId), Priority)
				WHERE		ReservationId = @reservationId
			END
			ELSE
			BEGIN
				DELETE FROM MMResource WHERE ReservationId = @reservationId
			END
			--SELECT @o_ReservationId = ReservationId FROM MMResource WHERE VolumeId = @volId
			set @sourceReservationResults = (select @o_ReservationId reservationId	for XML RAW('copyRsrvList'), TYPE)
		  GOTO exit_error
		end
else if @o_ErrorCode = 20005
		begin
			-- interrupton happens
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeForRestore', 'Interrupt for Volume ['	+ cast(@volId as varchar(10)) + '].', @i_RequestId, getutcdate())
		  GOTO exit_error
		end
		else
		begin
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeForRestore', 'Reservation for backup return error code ['
				  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		  goto exit_error
		end
	end
	-- Check if the old drive pool and new drive pool are the same or not.
	-- If the two drive pools are the same, we want to use the same drive if
	-- It is a NAS job
	-- The library is a standalone library
	-- Library has just one drive.
	DECLARE @exchangeDriveAlso int
	SET @exchangeDriveAlso = 1
	IF @oldDrivePoolId = @DrvPoolId
	BEGIN
		declare @DrivePoolType			int
		declare @LibraryId					int
		declare @LibraryTypeId			int
		declare @useDriveNeedClean	int
		declare @MasterPoolId				int
		declare @DriveCountByMP			int
		declare @GoodDriveCountByMP							int
		declare @GoodDriveCountByMPNotReserved int
		declare @MediaTypeId				int
		declare @oldMediaId					int
		SET @oldMediaId = 0
		SELECT @oldMediaId = ISNULL(MediaId, 0) FROM MMVolume with (READUNCOMMITTED) WHERE VolumeId = @oldVolumeId
		SELECT	@DrivePoolType			= dp.DrivePoolType,
						@MasterPoolId				= mp.MasterPoolId,
						@LibraryId					= mp.LibraryId,
						@LibraryTypeId			= l.LibraryTypeId,
@useDriveNeedClean	= 2048 & l.LibraryAttribute,
						@DriveCountByMP			= mp.TotalDrives
		FROM		MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMLibrary l with (readuncommitted)
		WHERE		dp.DrivePoolId = @DrvPoolId
		AND			dp.MasterPoolId = mp.MasterPoolId
		AND			mp.LibraryId = l.LibraryId
IF @LibraryTypeId != 3
		BEGIN
			SELECT @GoodDriveCountByMP = COUNT(DISTINCT DriveId)
			FROM	MMDrive with (readuncommitted)
			WHERE	MasterPoolId = @MasterPoolId
			AND		DriveSoftState = 1
			AND		DriveEnabled = 1
			AND		DriveBroken = 0
			AND		(@useDriveNeedClean > 0 OR CleaningRequired = 0)
			SELECT @GoodDriveCountByMPNotReserved = COUNT(DISTINCT DriveId)
			FROM	MMDrive with (readuncommitted)
			WHERE	MasterPoolId = @MasterPoolId
			AND		DriveSoftState = 1
			AND		DriveEnabled = 1
			AND		DriveBroken = 0
			AND		(@useDriveNeedClean > 0 OR CleaningRequired = 0)
			AND		DriveId NOT IN (SELECT DriveId FROM MMResource WHERE DriveId != 0)
			AND		DriveId IN (SELECT DriveId FROM MMDriveController with (readuncommitted) WHERE DrivePoolId = @DrvPoolId
												AND	DriveControllerSoftState = 1 AND DriveControllerEnabled = 1 AND DriveAccessible = 1)
		END
IF (@LibraryTypeId = 3 AND @oldMediaId = @mediaId)
OR (@LibraryTypeId in (2, 1))
		OR (@DrivePoolType = 3) -- CV_DRIVEPOOL_NAS
OR (@LibraryTypeId != 3 AND	( @DriveCountByMP <= 1 OR @GoodDriveCountByMP = 1 OR @GoodDriveCountByMPNotReserved <= 0))
		BEGIN
				SET @exchangeDriveAlso = 0
		END
	END
	SELECT @reservationId = ReservationId FROM MMResource WHERE VolumeId = @oldVolumeId AND DrivePoolId = @oldDrivePoolId
	SELECT @RCId = RCID FROM MMResourceToJob WHERE JobId_l = @jobId AND ReservationId = @reservationId
	IF @exchangeDriveAlso = 0
	BEGIN
		UPDATE MMResource SET VolumeId = @volId, MediaId = @mediaId, ReservationTime = dbo.GetUnixTime(getutcdate()), MediaGroupId = @MediaGrpId
		WHERE ReservationId = @reservationId AND VolumeId = @oldVolumeId
		UPDATE MMResourceToJob SET ReleaseTime = 0 WHERE ReservationId = @reservationId and JobId_l = @jobId
		SET @o_ReservationId = @reservationId
		set @sourceReservationResults = (select @o_ReservationId reservationId	for XML RAW('copyRsrvList'), TYPE)
	END
	ELSE
	BEGIN
		select @isForSwap = case when @oldDrivePoolId = @DrvPoolId then 1 else 0 end
		exec @o_ErrorCode = RMReserveReaders @i_RequestId, @isForSwap,
																				@i_isDebug,
																				@o_ReservationId output, @o_DriveId output, @o_RCId output, @sourceReservationResults output,
																				@o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
		END
if @o_ErrorCode != 0
and @o_ErrorCode != 20005
		begin
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeForRestore', 'Reservation for backup return error code ['
				  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
		  goto exit_error
		end
		--SELECT @o_ReservationId = ReservationId FROM MMResource WHERE VolumeId = @volId
if @o_ErrorCode = 0
		begin
			-- release the old reservation
			-- Reuse the original RCID
			IF @RCID IS NOT NULL AND EXISTS (SELECT * FROM MMResourceToJob WHERE RCID = @RCID)
			BEGIN
				UPDATE MMResourceToJob SET ReservationId = @o_ReservationId, ReleaseTime = 0 WHERE RCID = @RCId
				DELETE FROM MMResourceToJob WHERE RCID = @o_RCId
				SET @o_RCId = @RCId
			END
			-- If there are no other jobs reserved the same old volume, delete the reservation
			IF EXISTS (SELECT * FROM MMResourceToJob WHERE ReservationId = @reservationId)
			BEGIN
				UPDATE MMResource SET Priority = ISNULL((SELECT MIN(Priority) FROM MMResourceToJob WHERE ReservationId = @reservationId), Priority)
				WHERE		ReservationId = @reservationId
			END
			ELSE
			BEGIN
				DELETE FROM MMResource WHERE ReservationId = @reservationId
			END
			set @sourceReservationResults = (select @o_ReservationId reservationId	for XML RAW('copyRsrvList'), TYPE)
		end
	END
	if @i_isDebug > 0
	begin
		set @debugDetail = cast(isnull((select @reservationId OldReservationId, @oldVolumeId OldVolumeId, @oldDrivePoolId OldDrivePoolId,
																@o_ReservationId NewReservationId, @volId NewVolumeId, @DrvPoolId NewDrivePoolId
																for XML RAW('ExchangeVolume'), TYPE), 'No Volume Changed') as nvarchar(max))
		insert into RMLogger values ('RMExchangeForRestore', 'Exchange Succeed ' + @debugDetail, @i_RequestId, getutcdate())
	end
exit_error:
	if @sourceReservationResults is not null and len(cast(@sourceReservationResults as nvarchar(max))) > 0
		set @sourceReservationResults = '<ResourceManager_ReservationList>' + cast(@sourceReservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		ReservationResults = LEFT(cast(@sourceReservationResults as nvarchar(max)), 4000)
  where RequestId = @i_RequestId
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
	  select top 1 ErrorCode, FailureType, @o_ReservationId, @o_DriveId, @o_RCId
	  from RMReservationRequest
	  where RequestId = @i_RequestId
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
  end
	*/
	if @i_isDebug > 0
	  insert into RMLogger values('RMExchangeForRestore', 'Exit...', @i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMExchangeForRestore')
	delete from GxQscripts where name = 'RMExchangeForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForRestore')
	delete from GXDBVersions where aliasname = 'RMExchangeForRestore'
GO

insert into GXDBVersions values(2, 'RMExchangeForRestore',  '00010012005800050000', 'RMExchangeForRestore', '00010012005800050000')
GO

