

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMExchangeForMAAndDP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMExchangeForMAAndDP.sp,v $ $Id: RMExchangeForMAAndDP.sp,v 1.10.14.14.16.1 2021/05/13 02:21:08 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMExchangeForMAAndDP()
--  +========================================================================+
--
--
--	This is stored procedure used for exchange existing reservation for the given Media Agent and DrivePool.
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMExchangeForMAAndDP')
BEGIN
	print '>>> Drop Stored Procedure: RMExchangeForMAAndDP <<<'
	drop procedure RMExchangeForMAAndDP
END
IF EXISTS (select * from GxQscripts where name='RMExchangeForMAAndDP')
	delete from GxQscripts where name = 'RMExchangeForMAAndDP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForMAAndDP')
	delete from GXDBVersions where aliasname = 'RMExchangeForMAAndDP'
GO
print '... Creating Procedure: RMExchangeForMAAndDP'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMExchangeForMAAndDP
  @i_requestId int,
  @i_jobid int,
  @i_clientId int,
  @i_mediaAgentId int,
  @i_drivePoolId int,
  @i_reservationId int,
  @i_rcId int,
  @i_allowSwitchStoragePolicy int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationId integer;
  DECLARE @o_RCId integer;
  DECLARE @o_requestId integer;
  DECLARE @o_newStoragePolicyId integer;
  DECLARE @o_newCopyId integer;
  DECLARE @o_ErrorString varchar(max);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @debugDetail varchar(max)
	declare @reservationResults XML
	set @reservationResults = ''
	DECLARE @newRequestId INT
	SET @newRequestId = 0
	DECLARE @hasJobDataPathOptions INTEGER = 0
	declare @iDAType int
set @o_ErrorCode = 0
set @o_FailureType = 2
	set @o_Reservationid = 0
	set @o_RCId = 0
	set @o_newStoragePolicyId = 0
	set @o_newCopyId = 0
	set @o_ErrorString = ''
	set @iDAType = 0
	IF @i_requestId > 0
	BEGIN
		DECLARE @params XML = ''
		SELECT @params = xmlParams, @iDAType = iDAType FROM RMReservationRequest WHERE RequestId = @i_requestId
		IF @params IS NOT NULL AND
			@params.exist('/ResourceManager_RmExchangeReserveMAAndDP') > 0
		BEGIN
			SELECT	@i_jobId								= isnull(p.value('@jobid', 'int'), 0),
					@i_clientId								= isnull(p.value('@clientId', 'int'), 0),
					@i_mediaAgentId							= isnull(p.value('@mediaAgentId', 'int'), 0),
					@i_drivePoolId							= isnull(p.value('@drivePoolId', 'int'), 0),
					@i_reservationId						= isnull(p.value('@reservationId', 'int'), 0),
					@i_rcId									= isnull(p.value('@rcId', 'int'), 0),
					@i_allowSwitchStoragePolicy				= isnull(p.value('@allowSwitchStoragePolicy', 'int'), 0)
			FROM	@params.nodes('/ResourceManager_RmExchangeReserveMAAndDP[1]') AS R(p)
		END
SAVE TRANSACTION EXCHANGE_RESERVATION_TRANS
	END
	IF @i_rcId > 0
	BEGIN
		SELECT	@i_reservationId = ReservationId
		FROM	MMResourceToJob WITH (NOLOCK)
		WHERE	RCId = @i_rcId
		AND	JobId_l = @i_jobId
	END
	declare @newStoragePolicyId int = 0
	DECLARE @currentReservationType int
	DECLARE @currentReservationRequestId int
	DECLARE @currentCopyId	int
	DECLARE @currentClientTokenId	int
	DECLARE @currentMediaAgentId int = 0
	DECLARE @currentDrivePoolId int = 0
SET @currentReservationType = 2
	-- Find the reservation request for creating current reservations
	SET @currentReservationRequestId = 0
	SET @currentClientTokenID = 0
	SELECT @currentReservationRequestId = RequestId,
			@currentCopyId = CopyId,
			--@currentClientTokenID = ClientTokenId,
			@currentMediaAgentId = ClientId,
			@currentDrivePoolId = DrivePoolId
	FROM	RMReservations WITH (NOLOCK)
	WHERE	ReservationId = @i_reservationId
	AND		JobId = @i_jobId
	--AND		(@i_rcId = 0 OR @i_rcId = RCID)
	DECLARE @xmlParams XML
	DECLARE @dataType int = 0
	SELECT @xmlParams = xmlParams, @iDAType = iDAType FROM RMReservationRequest WHERE RequestId = @currentReservationRequestId
	DECLARE @numberOfStreams INT
	SET @numberOfStreams = 0
	IF @xmlParams IS NOT NULL
	BEGIN
		IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t') > 0
		BEGIN
			IF @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t[1]/copyIdList') > 0
			AND @xmlParams.exist('/ResourceManager_RmAllocateStreamArgs_t[1]/copyIdList[@val != sql:variable("@currentCopyId")]') > 0
			BEGIN
				set @o_Reservationid = @i_reservationId
				set @o_RCId = @i_rcId
				set @o_ErrorString = 'Inline reservations is not supported. No exchange is done.'
				goto exit_done
			END
			SELECT	@dataType = params.value('@dataType', 'int')
			FROM	@xmlParams.nodes('/ResourceManager_RmAllocateStreamArgs_t[1]') AS R(params)
			-- For given RCID only
			IF @i_rcId > 0
				SET @numberOfStreams = 1
			-- For given Reservation only
			ELSE
			BEGIN
				SELECT @numberOfStreams = COUNT(DISTINCT RCId)
				FROM MMResourceToJob WITH (NOLOCK)
				WHERE ReservationId = @i_reservationId
				AND JobId_l = @i_jobId
AND	ReservationType = 2
			END
		END
	END
	IF @numberOfStreams = 0
	BEGIN
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Cannot find the correct reservation parameters. No exchange is done.'
		goto exit_done
	END
	IF @iDAType > 0
		UPDATE RMReservationRequest SET iDAType = @iDAType WHERE RequestId = @i_requestId
	-- Physical Client id
    declare @physicalClientId int
    select  @physicalClientId = cast(attrVal as int)
    from        APP_ClientProp with (readuncommitted)
    where       componentNameId = @i_Clientid
    and         attrName = 'Active Physical Node'
    and         modified = 0
    if @physicalClientId is null or @physicalClientId = 0
        set @physicalClientId = @i_Clientid
	-- Check if there is switching storage policy required
	-- If the client is currently using a different proxy compared to current resevation,
	-- check if the given proxy of the new client belongs to a different region group and if there is a different storage policy pointing to the new regional client group.
	IF @i_allowSwitchStoragePolicy > 0
	AND @i_ClientId > 0
	AND	EXISTS (SELECT  1
				FROM    APP_AdvanceSettings WITH(READUNCOMMITTED)
				WHERE   keyname = 'EnableRegionBasedBackups'
				AND     entityId = @i_clientId
AND     entityType = 3
				AND     relativePath = 'iDataAgent'
				AND     CONVERT(NVARCHAR(10), value) = N'true'
				AND     enabled = 1
				AND     deleted = 0)
	AND EXISTS (SELECT 1 FROM APP_ClientGroupAssoc a WITH (NOLOCK), ArchGroupClientGroupAssociation b WITH (NOLOCK)
				WHERE	a.clientId = @i_Clientid
				AND		a.clientGroupId = b.clientGroupId
				AND		b.archGroupId > 0
				AND		attributes & 1 = 1 /*Region based client group backup*/
				AND		enabled = 1)
AND @iDAType IN ( 106, 81)
	BEGIN
		SELECT @newStoragePolicyId = b.archGroupId
		FROM	APP_ClientGroupAssoc a WITH (NOLOCK), ArchGroupClientGroupAssociation b WITH (NOLOCK)
		WHERE	a.clientId = @i_Clientid
		AND		a.clientGroupId = b.clientGroupId
		AND		b.archGroupId > 0
		AND		attributes & 1 = 1 /*Region based client group backup*/
		AND		enabled = 1
		-- Check log storage policy setting for log data type
IF @dataType = 4
		BEGIN
			SELECT @newStoragePolicyId = logSp FROM ArchGroup WITH (NOLOCK) WHERE Id = @newStoragePolicyId AND logSP > 0
		END
		SET @o_newStoragePolicyId = @newStoragePolicyId
	END
	IF @newStoragePolicyId = 0
	BEGIN
		-- Don't set media agent to client Id
		--IF @i_Clientid > 0 AND @i_mediaAgentId = 0
		--BEGIN
		--	SET @i_MediaAgentId = @i_ClientId
		--END
		IF @i_drivePoolId > 0 AND @i_mediaAgentId = 0
		BEGIN
			SELECT @i_mediaAgentId = CASE WHEN a.NDMPHostId > 0 THEN b.ClientId ELSE a.clientId END
			FROM
			 (
				SELECT 	*
				FROM	MMDrivePool WITH (NOLOCK)
				WHERE	DrivePoolId = @i_drivePoolId
			) a
			LEFT JOIN MMNDMPHostInfo b WITH (NOLOCK) ON a.NDMPHostId > 0 AND a.NDMPHostId = b.NDMPHostId
		END
	END
	-- Make sure the resevation is correct and the given media agent and drivepool can be used for switch
	IF NOT EXISTS (SELECT 1 FROM MMResource WITH (NOLOCK) WHERE ReservationId = @i_reservationId)
	OR NOT EXISTS (SELECT 1 FROM MMResourceToJob WITH (NOLOCK)
							WHERE ReservationId = @i_reservationId AND JobId_l = @i_jobId
							AND (@i_rcId = 0 OR @i_rcId = RCID)
AND 2 = reservationType)
	begin
	  set @o_Reservationid = @i_reservationId
	  set @o_RCId = @i_rcId
	  set @o_ErrorString = 'Given reservationId and RCId is invalid. No exchange is done.'
set @o_ErrorCode = 103
	  goto exit_done
	end
	-- Is the exchange really needed?
	IF @newStoragePolicyId = 0
	AND	EXISTS (SELECT * FROM MMResource WITH (NOLOCK)
				WHERE	ReservationId = @i_reservationId
				AND		(
							(@physicalClientId > 0 AND @i_mediaAgentId = 0 AND @i_drivePoolId = 0 AND @physicalClientId = ClientId)
							OR
							(@i_mediaAgentId > 0 AND @i_drivePoolId = 0 AND @i_mediaAgentId = ClientId)
							OR
							(@i_drivePoolId > 0 AND @i_drivePoolId = DrivePoolId)
						)
			)
	BEGIN
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Given media agent and drive pool is the same as current reservations. No exchange is done.'
		goto exit_done
	END
	-- Is there media agent in data path can be used for exchange?
	IF @newStoragePolicyId = 0 AND @currentCopyId > 0
	BEGIN
		DECLARE @dataPathCount INT = 0
		SELECT @dataPathCount = count(*)
		FROM	MMDataPath datapath WITH (NOLOCK)
		WHERE	CopyId = @currentCopyId
		IF @dataPathCount <= 1
		BEGIN
			set @o_Reservationid = @i_reservationId
			set @o_RCId = @i_rcId
			set @o_ErrorString = 'Current storage policy copy only has one data path. No exchange is done.'
			goto exit_done
		END
	END
	IF EXISTS (SELECT * FROM MMResource WITH (NOLOCK) WHERE	ReservationId = @i_reservationId AND (HasJobInterrupted > 1 OR IntrJobId_l > 0))
	BEGIN
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Resource is in interruption status. No exchange is done.'
		goto exit_done
	END
	-- ClientTokenId is looked up by job in previous logic, but the exchange needs to make sure the clientTokenId is the same as the current exchange one.
	-- VSA assume the clientTokenId as the RCId. If we don't do this check, it will cause problem during lookup pipeline info by clientTokenId.
	IF @i_rcId > 0
		SELECT @currentClientTokenId = ClientTokenId
		FROM	MMResourceToJob WITH (NOLOCK)
		WHERE	RCId = @i_rcId
	ELSE
	BEGIN
		SELECT TOP 1 @currentClientTokenId = ClientTokenId
		FROM	MMResourceToJob WITH (NOLOCK)
		WHERE	ReservationId = @i_reservationId
		AND	JobId_l = @i_jobId
		ORDER BY RCId
	END
	-- Check if there is Job DataPath Option defined
	DECLARE @jobOptionList VARCHAR(MAX)
SET @jobOptionList =	'<id val="' + cast(18276681 as varchar(20)) + '"/>' +
'<id val="' + cast(523178675 as varchar(20)) + '"/>' +
'<id val="' + cast(71136797 as varchar(20)) + '"/>' +
'<id val="' + cast(2081996217 as varchar(20)) + '"/>' +
'<id val="' + cast(1238677445 as varchar(20)) + '"/>'
	if exists (select * from dbo.GetJobOptionByIDList(@i_jobid, @jobOptionList) where cast(value as int) > 0)
	begin
		set @hasJobDataPathOptions = 1
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Cannot do exchange MediaAgent and Drive Pool since job data path options are set during starting of the backup job. No exchange is done.'
		goto exit_done
	end
	else if (@i_mediaAgentId > 0 OR @i_drivePoolId > 0 )
	begin
		DECLARE @taskId INTEGER = 0
		DECLARE @subTaskId INTEGER = 0
		DECLARE @refTime INTEGER = 0
		SELECT	@taskId = taskId, @subTaskId = subTaskId, @refTime = created
		FROM	TM_JobRequest WITH (READUNCOMMITTED)
		WHERE 	jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE jobId = @i_jobid)
		-- Insert media agent and drive pool info as job option to add support excachange based on drive pool also
		INSERT INTO TM_JobOptions
		(jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
		VALUES
( @i_jobid, 18276681, 7, CAST(@i_mediaAgentId AS NVARCHAR(MAX)), @taskId, @subTaskId, 0, @refTime, 0)
		INSERT INTO TM_JobOptions
		(jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
		VALUES
( @i_jobid, 523178675, 7, CAST(@i_drivePoolId AS NVARCHAR(MAX)), @taskId, @subTaskId, 0, @refTime, 0)
	end
	IF @newStoragePolicyId > 0
	AND	NOT EXISTS (SELECT 1 FROM ArchGroupCopy WHERE Id = @currentCopyId AND ArchGroupId = @newStoragePolicyId)
	BEGIN
		SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@archGroupId)[1] with sql:variable("@newStoragePolicyId")')
	END
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@numStreams)[1] with sql:variable("@numberOfStreams")')
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@isForRemainingStreams)[1] with "0"')
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@inClientId)[1] with sql:variable("@i_ClientId")')
	SET @xmlParams.modify('replace value of (/ResourceManager_RmAllocateStreamArgs_t[1]/@clientTokenId)[1] with sql:variable("@currentClientTokenID")')
	INSERT INTO RMReservationRequest
	(
		ErrorCode, FailureType, RequestTime, FailureAttempts, ShouldFailRequest, MaxNumOfAttempts, MaxNumOfReservedStreams,
		JobId, CommCellId, ScheduleRunId,
		UseSCDataPath,
		JobType, JobOpType, iDAType,
		PhaseFirstAttemptTime, CopyId, Priority, RequestCategory,
		RegistrySetting,
		XmlParams,
		ReservationResults
	)
	SELECT
0, -1, RequestTime, FailureAttempts, ShouldFailRequest, 1, MaxNumOfReservedStreams,
		JobId, CommCellId, ScheduleRunId,
		UseSCDataPath,
		JobType, JobOpType, iDAType,
		PhaseFirstAttemptTime, 0, Priority, RequestCategory,
		RegistrySetting,
		cast(@xmlParams as nvarchar(4000)),
		''
	FROM RMReservationRequest
	WHERE RequestId = @currentReservationRequestId
	SELECT @newRequestId = SCOPE_IDENTITY()
	if @i_isDebug > 0
	begin
		insert into RMLogger values ('RMExchangeForMAAndDP', 'Enter For Job['+ cast(@i_jobId as varchar(20)) + ']', @newRequestId, getutcdate())
		set @debugDetail = cast(isnull((select  @i_clientId NewClientId,
												@i_mediaAgentId PreferredMediaAgentId,
												@i_drivePoolId PreferreddrivePoolId,
												@i_reservationId CurrentReservationId,
												@i_rcId	CurrentRCID,
												@newStoragePolicyId NewStoragePolicyId
											for XML RAW('params'), TYPE), 'No params for RMExchangeForMAAndDP') as nvarchar(max))
		insert into RMLogger values ('RMExchangeForMAAndDP', @debugDetail, @newRequestId, getutcdate())
	end
	-- Remove the current reservations
	IF @i_rcId > 0
	BEGIN
		DELETE FROM MMResourceToJob WHERE RCId = @i_rcId
	END
	-- For given Reservation only
	ELSE
	BEGIN
		DELETE FROM MMResourceToJob
		WHERE ReservationId = @i_reservationId
		AND JobId_l = @i_jobId
AND	ReservationType = 2
	END
	IF NOT EXISTS (SELECT * FROM MMResourceToJob WHERE ReservationId = @i_reservationId)
	BEGIN
		DELETE FROM MMResource WHERE ReservationId = @i_reservationId
	END
	ELSE
	BEGIN
		UPDATE MMResource
SET ReservationType = CASE WHEN EXISTS (SELECT * FROM MMResourceToJob WHERE ReservationId = @i_ReservationId AND ReservationType = 2) THEN 2 ELSE 1 END,
			Priority = (SELECT MIN(Priority) FROM MMResourceToJob WHERE ReservationId = @i_ReservationId)
		WHERE ReservationId = @i_reservationId
	END
	if @i_isDebug > 0
	begin
		insert into RMLogger values ('RMExchangeForMAAndDP', 'Remove current reservation for ReservationId['+ cast(@i_reservationId as varchar(20)) + ']' + ' RCId['+ cast(@i_rcId as varchar(20)) + ']',
								@newRequestId, getutcdate())
	end
	exec @o_ErrorCode = RMReserveWriters @newRequestId, 0, 0, @i_isDebug, @reservationResults output, @o_ErrorCode output, @o_FailureType output
	if @@ERROR > 0
	begin
set @o_ErrorCode = 415
set @o_FailureType = 2
	end
if @o_ErrorCode != 0
	begin
		if @i_isDebug > 0
			  insert into RMLogger values('RMExchangeForMAAndDP', 'Reservation for backup return error code ['
															+ cast(@o_ErrorCode as varchar(10)) + '].', @newRequestId, getutcdate())
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Reservation fails based on the given media agent and drive pool. No exchange is done.'
		goto exit_done
	end
	DECLARE @newMediaAgentId	int = 0
	DECLARE @newDrivePoolId		int = 0
	SELECT @o_ReservationId = ReservationId, @o_RCId = RCId, @newMediaAgentId = clientId, @newDrivePoolId = drivePoolId
	FROM	RMReservations
	WHERE	requestId = @newRequestId
	-- Even the resrevation succeeds, if the newly reserved media agent is not the given one, rollback all the changes at the end
	IF @newStoragePolicyId = 0
	AND (
( @iDAType in ( 64 /*, 81*/ ) AND @newMediaAgentId = @currentMediaAgentId)
			OR
( @iDAType not in ( 64/*, 81*/ )
				AND
				(
					(@i_mediaAgentId = 0 AND @i_drivePoolId = 0 AND @newMediaAgentId != @physicalClientId )
					OR
					(@i_mediaAgentId > 0 AND @newMediaAgentId != @i_mediaAgentId )
					OR
					(@i_drivePoolId > 0 AND @newDrivePoolId != @i_drivePoolId)
				)
			)
		)
	BEGIN
		if @i_isDebug > 0
			  insert into RMLogger values('RMExchangeForMAAndDP', 'Reservation cannot happen on the given media agent and drive pool. No exchange is done.', @newRequestId, getutcdate())
		set @o_Reservationid = @i_reservationId
		set @o_RCId = @i_rcId
		set @o_ErrorString = 'Cannot do reservation on the given media agent and drive pool. No exchange is done.'
		goto exit_done
	END
	-- If exchange storage policy happens, update JMBkpJobInfo table for the policy Id
	IF @newStoragePolicyId > 0
	BEGIN
		UPDATE JMBkpJobInfo
		SET		currentPolicy = @newStoragePolicyId,
dataPolicy = CASE WHEN @dataType = 4 THEN dataPolicy ELSE @newStoragePolicyId END,
logPolicy = CASE WHEN @dataType = 4 THEN @newStoragePolicyId ELSE logPolicy END,
				targetCopyList = ''
		WHERE	JobId = @i_jobId
		AND		commCellId = 2
		-- Add job option to track changes when creating entries for JMBkpStats table
IF @dataType = 4
		BEGIN
DELETE	JMJobOptions WHERE jobId = @i_jobId AND CommCellId = 2 AND attributeid = 107
			INSERT INTO JMJobOptions (jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
SELECT @i_jobId, 2, 107, 'Backup job had log storage policy changed during reservation',  @newStoragePolicyId, ''
		END
		ELSE
		BEGIN
DELETE	JMJobOptions WHERE jobId = @i_jobId AND CommCellId = 2 AND attributeid = 106
			INSERT INTO JMJobOptions (jobId, commCellId, attributeid, attributeName, attributeValueInt, attributeValue)
SELECT @i_jobId, 2, 106, 'Backup job had data storage policy changed during reservation',  @newStoragePolicyId, ''
		END
	END
	-- Reuse the same RCId if it is possible
	IF @i_rcId > 0
	BEGIN
		UPDATE MMResourceToJob
		SET		RCId = @i_rcId
		FROM MMResourceToJob restojob, RMReservations res
		WHERE	restojob.RCId = res.RCID
		AND		restojob.JobId_l = res.jobId
		AND		res.requestId = @newRequestId
		SET @o_RCId = @i_rcId
		if @i_isDebug > 0
			  insert into RMLogger values('RMExchangeForMAAndDP', 'Reuse current RCId[' + cast(@i_rcId as varchar(10)) + '].', @newRequestId, getutcdate())
	END
exit_done:
	IF @hasJobDataPathOptions = 0
	BEGIN
		DELETE TM_JobOptions
WHERE jobId = @i_jobId AND optionId IN (18276681, 523178675)
	END
	IF @i_requestId > 0
	BEGIN
		INSERT INTO RMLogger
		SELECT	RMModule, State, @i_requestId, TimeStamp
		FROM	RMLogger
		WHERE	RequestId = @newRequestId
		DELETE RMLogger WHERE requestId = @newRequestId
		set @reservationResults = '<ResourceManager_ReservationList><copyRsrvList reservationId="'
								+ cast(@o_ReservationId as varchar(10))
								+ '"><rcidList val="'
								+ cast(@o_RCId as varchar(10))
								+ '"/></copyRsrvList></ResourceManager_ReservationList>'
		IF LEN(@o_ErrorString) > 0
		BEGIN
			INSERT INTO RMLogger VALUES ('RMExchangeForMAAndDP', 'Exchange failed due to :' + @o_ErrorString, @i_requestId, getutcdate())
			declare @tempLog table
			(
					RMModule	varchar(100),
					State		varchar(max),
					RequestId	integer,
					TimeStamp	datetime
			)
			insert into @tempLog
			select RMModule, State, RequestId, TimeStamp
			from	RMLogger with (readuncommitted)
			where	RequestId = @i_RequestId
ROLLBACK TRANSACTION EXCHANGE_RESERVATION_TRANS
			delete RMLogger where RequestId = @i_RequestId
			insert into RMLogger
			select * from @tempLog
		END
		update RMReservationRequest
		set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
			FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
			PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
			ReservationResults = LEFT(cast(@reservationResults as nvarchar(max)), 4000)
		where RequestId = @i_RequestId
	END
	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
		SELECT @o_ErrorCode, @o_FailureType, @o_ReservationId, @o_RCId, @newRequestId, @o_newStoragePolicyId, @o_newCopyId, @o_ErrorString
	END
  RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMExchangeForMAAndDP')
	delete from GxQscripts where name = 'RMExchangeForMAAndDP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForMAAndDP')
	delete from GXDBVersions where aliasname = 'RMExchangeForMAAndDP'
GO

insert into GXDBVersions values(2, 'RMExchangeForMAAndDP',  'v1.10.14.14.16.1', 'RMExchangeForMAAndDP', 'v1.10.14.14.16.1')
GO

