

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMExchangeForBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMExchangeForBackup.sp,v $ $Id: RMExchangeForBackup.sp,v 1.22.48.9 2019/12/27 13:33:05 pnara Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMExchangeForBackup()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMExchangeForBackup')
BEGIN
	print '>>> Drop Stored Procedure: RMExchangeForBackup <<<'
	drop procedure RMExchangeForBackup
END
IF EXISTS (select * from GxQscripts where name='RMExchangeForBackup')
	delete from GxQscripts where name = 'RMExchangeForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForBackup')
	delete from GXDBVersions where aliasname = 'RMExchangeForBackup'
GO
print '... Creating Procedure: RMExchangeForBackup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMExchangeForBackup
  @i_RequestId int,
  @i_isDebug int
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
  DECLARE @o_ReservationId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	declare @debugDetail varchar(max)
	declare @reservationResults XML
	set @reservationResults = ''
set @o_ErrorCode = 0
set @o_FailureType = 1
	set @o_ReservationId = 0
	delete RMReservations
	where RequestId = @i_RequestId
	delete RMLogger where requestId = @i_RequestId
	if @i_isDebug > 0
	  insert into RMLogger values ('RMExchangeForBackup', 'Enter...', @i_RequestId, getutcdate())
	IF object_id('tempdb.dbo.#tmpRMDriveViewWithOffline') IS NOT NULL
		DELETE #tmpRMDriveViewWithOffline
	ELSE
CREATE TABLE #tmpRMDriveViewWithOffline ( DatapathPriority			integer, DatapathId					integer, DriveControllerId			integer, DriveId						integer, DrivePoolId					integer, MasterPoolId				integer, LibraryId					integer, SpareGroupId				integer, HostClientId				integer, MAClientId					integer, MountPathId					integer, DeviceId					integer, DeviceControllerId			integer, MagNumReservations			integer, LastUseTime					integer, MagNumReused				integer, MediaId						integer, FailureErrorCode			integer, FailurePriority				integer, RMStatus					integer, LibrarySubType				integer, DriveAttributes				integer, Priority					integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, SpareGroupId, DriveId, MountPathId)	)
  declare @RequestTime		int
  declare @FailureAttempts int
  declare @commCellId				int
	declare @phaseFirstAttemptTime	bigint
	declare @oldVolumeId		int
	declare @volId			int
	declare @DrvPoolId	int
	declare @mediaAgentName	varchar(256)
	declare @mediaAgentId	int
	declare @mediaId		int
	declare @MediaGrpId	int
	declare @jobId			bigint
	declare @scheduleRunId bigint
	declare @jobType		int
	declare @jobOpType	int
	declare @iDAType		int
	declare @priority		int
	declare @preEmptable			int
	declare @bestcaseReserve	int
	declare @rtype			int
	declare @checkConcurrency	int
	declare @isDummyReservation	int
	declare @destinationMediaGroupId	int
	declare @copyId			int
	declare @driveId		int
	declare @recordingFormatId	int
	declare @xmlRegistrySetting XML
	declare @xmlParams	XML
	DECLARE @reservationId	int
	DECLARE @MediaGroupId		int
	DECLARE @RCId						int
	DECLARE @ReservationType int
	DECLARE @volumeFullReason int
	DECLARE @isStartNewMedia int
	DECLARE @UsePartialFullMedia int
	DECLARE @doNotAllowOtherSchedule INT
	DECLARE @oldSIDBStoreId		int = 0
	DECLARE @oldVolFlags 		int = 0
	DECLARE @oldVolFullReason	int = 0
	DECLARE @oldMediaSideId		int = 0
	DECLARE @oldMediaId			int = 0
	DECLARE @newSIDBStoreId		int = 0
	DECLARE @SIDBStoreId		int = 0
	select
		@RequestTime = RequestTime,
		@FailureAttempts = FailureAttempts,
		@commCellId = commCellId,
		@jobId = jobId,
		@scheduleRunId = scheduleRunId,
		@jobType = jobType,
		@jobOpType = jobOpType,
		@iDAType = iDAType,
		@phaseFirstAttemptTime = phaseFirstAttemptTime,
		@xmlRegistrySetting = registrySetting,
		@xmlParams	= xmlParams
  from RMReservationRequest
  where RequestId = @i_RequestId
	IF @xmlParams IS NOT NULL AND @xmlParams.exist('/ResourceManager_RmExchangeVolumeArgs_t') > 0
	BEGIN
		SELECT	@oldVolumeId								= params.value('@oldVolumeId', 'int'),
						@volId											= params.value('@newVolumeId', 'int'),
						@ReservationId							= params.value('@reservationId', 'int'),
						@MediaGroupId								= params.value('@mediaGroupId', 'int'),
						@ReservationType						= params.value('@reservationType', 'int'),
						@volumeFullReason						= params.value('@volumeFullReason', 'int'),
						@isStartNewMedia						= params.value('@startNewMedia', 'int'),
						@doNotAllowOtherSchedule		= params.value('@doNotAllowOtherSchedule', 'int'),
						@SIDBStoreId					= ISNULL(params.value('@newSIDBStoreId', 'int'), 0)
				FROM	@xmlParams.nodes('/ResourceManager_RmExchangeVolumeArgs_t[1]') AS R(params)
	END
	SET @UsePartialFullMedia = @isStartNewMedia ^ 1
	IF @oldVolumeId IS NULL OR @oldVolumeId = 0
	BEGIN
		SELECT @oldVolumeId = VolumeId FROM MMResource WHERE ReservationId = @ReservationId
	END
	-- Do the following to remove the lock in MediaManager
	IF @oldVolumeId IS NULL OR @oldVolumeID = 0
	BEGIN
SET @o_ErrorCode = 268
		insert into RMLogger values ('RMExchangeForBackup', 'The specified volume id is invalid with VolumeId ['
																+ (case when @oldVolumeId IS NULL then 'NULL' else cast(@oldVolumeId as varchar(20)) end) + '], ReservationId['
																+ (case when @ReservationId IS NULL then 'NULL' else cast(@ReservationId as varchar(20)) end) + ']'
																, @i_RequestId, getutcdate())
		goto exit_error
	END
	ELSE
	BEGIN
		insert into RMLogger values ('RMExchangeForBackup',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], ReservationId['
																				+ cast(isnull(@ReservationId, 0) as varchar(20)) + '] ActiveVolumeId['
																				+ cast(isnull(@oldVolumeId, 0) as varchar(20)) + '] MediaGroupId['
																				+ cast(isnull(@MediaGroupId, 0) as varchar(20)) + '] NewVolumeId['
																				+ cast(isnull(@volId, 0) as varchar(20)) + ']',
																				@i_RequestId, getutcdate())
	END
	SELECT 	@MediaGroupId = case when @MediaGroupId > 0 then @MediaGroupId else MediaGroupId end,
			@oldSIDBStoreId = SIDBStoreId,
			@oldVolFlags = VolumeFlags,
			@oldVolFullReason = VolumeFullReason,
			@oldMediaSideId = MediaSideId,
			@oldMediaId = MediaId
	FROM 	MMVolume with (NOLOCK)
	WHERE 	VolumeId = @oldVolumeId
	IF @SIDBStoreId = 0
		SET @newSIDBStoreId = @oldSIDBStoreId
	ELSE
		SET @newSIDBStoreId = @SIDBStoreId
	DECLARE @oldDrivePoolId INT
	DECLARE @curLibraryId INT
	DECLARE @curLibraryName nvarchar(256)
	DECLARE @isMagneticLib INT = 0
	DECLARE @oldMountPathId INT = 0
	DECLARE @oldMountPathTypeId INT = 0
	SELECT	@oldDrivePoolId = DrivePoolId
	FROM		MMMediaGroup with (readuncommitted) WHERE MediaGroupId = @MediaGroupId
	SELECT	@curLibraryId = LibraryId, @curLibraryName = AliasName,
@isMagneticLib = CASE WHEN LibraryTypeId = 3 THEN 1 ELSE 0 END
	FROM		MMLibrary with (readuncommitted)
	WHERE		LibraryId = (
												SELECT TOP 1 m.LibraryId
												FROM	MMMasterPool m with (readuncommitted), MMDrivePool d with (readuncommitted)
												WHERE	@oldDrivePoolId = d.DrivePoolId
												AND		d.MasterPoolId = m.MasterPoolId
											)
	IF @curLibraryId IS NULL OR @curLibraryId = 0
	BEGIn
SET @o_ErrorCode = 259
		insert into RMLogger values ('RMExchangeForBackup', 'Cannot find the library information based on the specified MediaGroupId['
																			+ cast(isnull(@MediaGroupId, 0) as varchar(20)) + ']',
																			@i_RequestId, getutcdate())
		goto exit_error
	END
	DECLARE @rmJustId TABLE (id int)
	DECLARE @rmMediaAllo TABLE (RetCode int, VolumeIDForJob int, SpareGroupID int, LibraryID int, MediaOfOtherSideSearched int, MediaAppendibleSearched int, MediaSpareSearched int)
	-- Make the active volume full
	IF @oldVolumeId > 0
	BEGIN
		IF @isMagneticLib = 0
		BEGIN
			UPDATE MMMediaSide SET FreeBytesMB = 0
			WHERE MediaSideId = @oldMediaSideId
		END
		ELSE
		BEGIN
			SELECT TOP 1 @oldMountPathId = mp.MountPathId, @oldMountPathTypeId = MountPathTypeId
			FROM	MMMountPath mp WITH (READUNCOMMITTED)
			WHERE	mp.MediaSideId = @oldMediaSideId
		END
IF @volumeFullReason = 42001 /*E_MM_VOL_FULL_ENDOFMEDIA*/
OR (@oldVolFlags = 2 /*VOL_FULL*/ AND @oldVolFullReason = 42001)
		BEGIN
			-- This check is to make sure the new volume does not belong to the same mount path of old volume
			IF @isMagneticLib = 1 AND @oldMountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			BEGIN
				UPDATE MMMediaSide
				SET FreeBytesMB = (CASE WHEN MMMountPath.MagneticSpaceRsrvInMB > 1 THEN MMMountPath.MagneticSpaceRsrvInMB-1 ELSE 0 END)
				FROM	MMMountPath WITH (NOLOCK)
				WHERE	MMMediaSide.MediaSideId = MMMountPath.MediaSideId
				AND		MMMountPath.MountPathId = @oldMountPathId
			END
		END
		IF @oldVolFlags = 1 /*VOL_ACTIVE*/
		BEGIN
			DECLARE @LogEvent int
			SET @LogEvent = 1
			EXEC MMS2SetVolumeFull @oldVolumeId, @LogEvent output, @volumeFullReason, @jobId, 0, 0
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
UPDATE MMVolume SET Attributes = 1 WHERE VolumeId = @oldVolumeId
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeForBackup', 'Make Active Volume [' + cast(@oldVolumeId as varchar(20))
																		 + '] Full With Reason [' + cast(@volumeFullReason as varchar(20)) + '].',
																		 @i_RequestId, getutcdate())
		END
	END
	-- Force the exchage happens only for new tape when using IBMI_VTL library
	IF @oldVolumeId > 0
	AND EXISTS (SELECT 1
				FROM MMMedia m WITH (NOLOCK), MMLibrary l WITH (NOLOCK)
				WHERE m.MediaId = @oldMediaId
				AND m.libraryId = l.libraryId
AND	l.VTLType = 4
				)
	BEGIN
		SET @UsePartialFullMedia = 0
	END
	IF @volId IS NULL OR @volId = 0
	BEGIN
		IF @MediaGroupId IS NULL OR @MediaGroupId = 0
		BEGIn
SET @o_ErrorCode = 268
			insert into RMLogger values ('RMExchangeForBackup', 'The specified media group id is invalid' + ' MediaGroupId['
																				+ cast(isnull(@MediaGroupId, 0) as varchar(20)) + ']',
																				@i_RequestId, getutcdate())
			goto exit_error
		END
		IF @isMagneticLib > 0
		BEGIN
			-- Find the mount path available
			DECLARE @MountPathId INT
DECLARE @RMMountView TABLE ( DataPathId				integer, DriveControllerId		integer, DriveId					integer, DrivePoolId				integer, MasterPoolId			integer, LibraryId				integer, LibrarySubType			integer, SpareGroupId			integer, HostClientId			integer, MAClientId				integer, MountPathId				integer, DeviceId				integer, DeviceControllerId		integer, FailureErrorCode		integer, DriveAttributes			integer, Priority				integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, DriveId, Priority)	)
			DELETE FROM #tmpRMDriveViewWithOffline
			SET @MountPathId = 0
			exec RMGetAvailableDrivesForDrivePool @i_RequestId, 0/*@CopyId*/, @JobId, 0/*@JobType*/, @oldDrivePoolId, 0/*@mediaAgentId*/,
0, 10001, 0/*@volId*/, 0,	2, 1, /*IsForSwap*/
																					@i_isDebug, @o_ErrorCode output, @o_FailureType output
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			insert into @RMMountView
			select DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId, LibrarySubType,
							SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0, DriveAttributes
			from	#tmpRMDriveViewWithOffline
			where	FailureErrorCode = 0
			order by Priority
IF (@volumeFullReason = 42001 /*E_MM_VOL_FULL_ENDOFMEDIA*/
OR (@oldVolFlags = 2 /*VOL_FULL*/ AND @oldVolFullReason = 42001))
			AND @oldMountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/
			BEGIN
				DELETE @RMMountView WHERE MountPathId = @oldMountPathId
				if not exists (select * from @RMMountView)
				begin
set @o_ErrorCode = 278
set @o_FailureType = 2
					GOTO exit_error
				end
			END
			-- Cannot find usable mount path, just use current active mount path
			if not exists (select * from @RMMountView)
			begin
select @o_ErrorCode = FailureErrorCode, @o_FailureType = 2
				from #tmpRMDriveViewWithOffline
				where	FailureErrorCode != 0
				order by Priority
				GOTO exit_error
			end
			else
			begin
				SELECT TOP 1 @MountPathId = MountPathId
				FROM @RMMountView order by Priority
			end
			declare @reservedClientId int = 0
			select @reservedClientId = ClientId FROM MMResource WHERE ReservationId = @ReservationId
			EXEC @o_ErrorCode = MMS2GetMagVolumeForJob @commCellId, @MountPathId, @MediaGroupID, @newSIDBStoreId, 0 /*AppId*/, @jobId, @jobOpType, @UsePartialFullMedia, 1 /*@markActiveMediaFull*/, @reservedClientId, 1 /*IgnoreOutput*/, @volId OUTPUT
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(isnull((select  @volId NewVolumeId, 0 NewMediaId,
																				@commCellId CommcellId, @MountPathId MountPathId,
																				@MediaGroupID MediaGroupId, @jobId JobId, @jobType JobType,
																				@UsePartialFullMedia UsePartialFullMedia, 1 MarkActiveMediaFull
													for XML RAW('MMS2GetMagVolumeForJob'), TYPE), 'No params for MMS2GetMagVolumeForJob') as nvarchar(max))
				insert into RMLogger values ('RMExchangeForBackup', @debugDetail, @i_RequestId, getutcdate())
			end
		END
		ELSE
		BEGIN
			exec @o_ErrorCode = MMS2GetVolumeForJob @commCellId, @MediaGroupID, @jobId, @jobOpType,@UsePartialFullMedia, @scheduleRunId, @doNotAllowOtherSchedule, 1 /*IgnoreOutput*/, @volId OUTPUT
			IF @@ERROR > 0
			BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO exit_error
			END
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(isnull((select  @volId NewVolumeId, 0 NewMediaId,
																				@commCellId CommcellId, @MediaGroupID MediaGroupId, @jobId JobId, @jobType JobType,
																				@UsePartialFullMedia UsePartialFullMedia, @scheduleRunId ScheduleRunId, @doNotAllowOtherSchedule DoNotAllowOtherSchedule
													for XML RAW('MMS2GetVolumeForJob'), TYPE), 'No params for MMS2GetVolumeForJob') as nvarchar(max))
				insert into RMLogger values ('RMExchangeForBackup', @debugDetail, @i_RequestId, getutcdate())
			end
		END
		IF @volId <= 0
		BEGIN
if @o_ErrorCode = 0
set @o_ErrorCode = 280
		  	if @i_isDebug > 0
		  	begin
					insert into RMLogger values ('RMExchangeForBackup',
										'Error returns no media to use in Library['+ isnull(@curLibraryName, '')
										+ '] MediaGroupId['+ cast(isnull(@MediaGroupID, 0) as varchar(20)) + '].',
										@i_RequestId, getutcdate())
					end
			goto exit_error
		END
	END
	-- End of replace Media Manager lock
	-- Following are the regular replace volume code in Resource Manager
	SELECT @driveId	= DriveId,
					@DrvPoolId = DrivePoolId,
					@mediaAgentId = ClientId,
					@MediaGrpId = MediaGroupId
	FROM		MMResource
	WHERE		VolumeId = @oldVolumeId
	SET @mediaId = 0
	SELECT @mediaId = ISNULL(MediaId, 0), @recordingFormatId = ISNULL(RecordingFormatId, 0) FROM MMVolume  with (READUNCOMMITTED) WHERE VolumeId = @volId
	IF @volId IS NULL OR @volId <= 0 OR @mediaId = 0
	BEGIN
SET @o_ErrorCode = 280
			insert into RMLogger values ('RMExchangeForBackup', 'The specified new volume id['+ (case when @volId is null then 'NULL' else '0' end)
																		+'] is invalid', @i_RequestId, getutcdate())
		goto exit_error
	END
/*
  --------------------------------
  -- Module: claim interruption --
  --------------------------------
  if exists (select * from MMResource where HasJobInterrupted = 1 and ReservationId in
  						 (select ReservationId from MMResourceToJob where JobId_l = @jobId))
  begin
		-- check if interrupted resource can be claimed
		if exists (select * from MMResource where intrjobid_l = @jobId and Released = 0)
		or exists (select * from MMResourceToJob where ReservationId in (select ReservationId from MMResource where intrjobid_l = @jobId))
		or exists (select * from MMResource where intrjobid_l = @jobId and DriveId in (select DriveId from MMDrive where MountStatus in (MNT_VOL_MOUNTING, MNT_VOL_UNMOUNTING)))
		begin
		  -- interrupted resources are not freed yet
			set @debugDetail = cast(isnull((
												select	ReservationId, CopyId, StreamId, DrivePoolId, DriveId, MediaId, MountPathId
												from		MMResource
												where		intrjobId_l = @JobId
												for XML RAW('InterruptedStreams'), TYPE), 'No Interrupted Resources') as nvarchar(max))
  		insert into RMLogger values ('RMExchangeForBackup',
  				'Error return because Interrupted resources are not freed yet' + @debugDetail, @i_RequestId, getutcdate())
set @o_ErrorCode = 20004
set @o_FailureType = 2
		  goto exit_error
		end
		-- release interrupted resource
		delete from MMResource where intrjobid_l = @jobId
		-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
		-- those are place holder anyway, also we will have to check availability of everything
		delete @rmJustId
		insert into @rmJustId
		select reservationid from MMResourceToJob where ReservationId in (select ReservationId from MMResourceToJob where JobId_l = @jobId)
		if @i_isDebug > 0
		begin
			set @debugDetail = cast(isnull((
												select distinct a.ReservationId RID, a.CopyId, a.StreamId, a.MediaId, a.DriveId, a.LibraryId, b.RCID, b.JobId_l
												from MMResource a, MMResourceToJob b
												where a.ReservationId = b.ReservationId and a.ReservationId in (select id from @rmJustId)
												for XML RAW('InterruptedResource'), TYPE), 'No Interrupted Resources') as nvarchar(max))
			insert into RMLogger values ('Claim Interruption', @debugDetail, @i_RequestId, getutcdate())
		end
    delete from MMResourceToJob where ReservationId in (select id from @rmJustId)
    delete from MMResource where ReservationId in (select id from @rmJustId)
  end
  ---------------------------------------
  -- End of Module: claim interruption --
  ---------------------------------------
*/
	if @i_isDebug > 0
		insert into RMLogger values ('RMExchangeForBackup',
						'Enter with RequestId[' + cast(isnull(@i_RequestId, 0) as varchar(20)) + '], ReservationId['
																				+ cast(isnull(@ReservationId, 0) as varchar(20)) + '] MediaId['
																				+ cast(isnull(@mediaId, 0) as varchar(20)) + '], DrivePoolId['
																				+ cast(isnull(@DrvPoolId, 0) as varchar(20)) + '] JobId['
																				+ cast(isnull(@JobId, 0) as varchar(20)) + '] OldVolumeId['
																				+ cast(isnull(@oldVolumeId, 0) as varchar(20)) + '] NewVolumeId['
																				+ cast(isnull(@volId, 0) as varchar(20)) + ']',
						@i_RequestId, getutcdate())
	-- Check if the new volume reservable
 	declare @isReservable int
 	set @isReservable = 0
 	exec RMIsVolumeReservable @i_RequestId, @JobId, @volId, @MediaGrpId, 	@DrvPoolId, 0, @mediaAgentId, 0,
2, 1, @i_isDebug,
 														@isReservable output, @o_ErrorCode output
	IF @@ERROR > 0
	BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
	  GOTO exit_error
	END
	if @i_isDebug > 0
	begin
			set @debugDetail = cast(isnull((
												select (case when @isReservable = 1 then 'YES' else 'NO' end) IsVolumeReservable,
																@o_ErrorCode ErrorCode,
																@jobId JobId, @volId VolumeId, @MediaGrpId MediaGroupId, @DrvPoolId DrivePoolId,
																0 MasterPoolId, @mediaAgentId MediaAgentId, 0 LibraryId,
2 ReservationType, 1 CheckOppositeSide
												for XML RAW('RMIsVolumeReservable'), TYPE), 'No params for RMIsVolumeReservable') as nvarchar(max))
		insert into RMLogger values ('RMExchangeForBackup', @debugDetail, @i_RequestId, getutcdate())
	end
	-- If the volume is not reservable, check if we need to interrupt or multiplexing
	if @isReservable = 0
	begin
		if @i_isDebug > 0
			  insert into RMLogger values('RMExchangeForBackup', 'Reservation for backup return error code ['
			  												+ cast(@o_ErrorCode as varchar(10)) + '].', @i_RequestId, getutcdate())
	  goto exit_error
	end
	DECLARE @tryToFindDrive			int
	DECLARE @exchangeDriveAlso	int
	SET @tryToFindDrive = 1
	SET @exchangeDriveAlso = 0
	declare @DrivePoolType			int
	declare @LibraryId					int
	declare @LibraryTypeId			int
	declare @useDriveNeedClean	int
	declare @MasterPoolId				int
	declare @DriveCountByMP			int
	declare @GoodDriveCountByMP							int
	declare @GoodDriveCountByMPNotReserved int
	declare @MediaTypeId				int
	declare @newDriveId					int
	declare @newDrivePoolId			int
	declare @newMasterPoolId		int
	SELECT	@DrivePoolType			= dp.DrivePoolType,
					@MasterPoolId				= mp.MasterPoolId,
					@LibraryId					= mp.LibraryId,
					@LibraryTypeId			= l.LibraryTypeId,
@useDriveNeedClean	= 2048 & l.LibraryAttribute,
					@DriveCountByMP			= mp.TotalDrives
	FROM		MMDrivePool dp with (readuncommitted), MMMasterPool mp with (readuncommitted), MMLibrary l with (readuncommitted)
	WHERE		dp.DrivePoolId = @DrvPoolId
	AND			dp.MasterPoolId = mp.MasterPoolId
	AND			mp.LibraryId = l.LibraryId
	--The new volume could be in a different Drive.
	--This can happen when we span mountPaths or when we span across standalone drives or when
	--a spare is mounted in another drive.
	--In this case we need to update the MountPath, DrivePool and Drive Counters.
IF @LibraryTypeId = 5
OR @LibraryTypeId = 2
	--OR @LibraryTypeId = CV_LIB_TAPE
	BEGIN
		SET @tryToFindDrive = 0
		SET @exchangeDriveAlso = 0
	END
ELSE IF @LibraryTypeId = 4
	BEGIN
		-- See if the standalone drivepool has more than one drive.
		-- If it does then we might need to replace drive reservation.
		-- If there is just one drive we cannot exchange drive reservation,
		-- just replace the volumeid in that case.
		SELECT @GoodDriveCountByMPNotReserved = COUNT(DISTINCT DriveId)
		FROM	MMDrive with (readuncommitted)
		WHERE	MasterPoolId = @MasterPoolId
		AND		DriveSoftState = 1
		AND		DriveEnabled = 1
		AND		DriveBroken = 0
		AND		CleaningRequired = 0
		AND		DriveId NOT IN (SELECT DriveId FROM MMResource WHERE DriveId != 0)
		AND		DriveId IN (SELECT DriveId FROM MMDriveController with (readuncommitted) WHERE DrivePoolId = @DrvPoolId
											AND	DriveControllerSoftState = 1 AND DriveControllerEnabled = 1 AND DriveAccessible = 1)
		IF @GoodDriveCountByMPNotReserved <= 0
		BEGIN
			SET @tryToFindDrive = 0
			SET @exchangeDriveAlso = 0
		END
	END
	ELSE
	BEGIN
IF @LibraryTypeId != 3
		BEGIN
			SELECT @GoodDriveCountByMP = COUNT(DISTINCT DriveId)
			FROM	MMDrive with (readuncommitted)
			WHERE	MasterPoolId = @MasterPoolId
			AND		DriveSoftState = 1
			AND		DriveEnabled = 1
			AND		DriveBroken = 0
			AND		CleaningRequired = 0
			SELECT @GoodDriveCountByMPNotReserved = COUNT(DISTINCT DriveId)
			FROM	MMDrive with (readuncommitted)
			WHERE	MasterPoolId = @MasterPoolId
			AND		DriveSoftState = 1
			AND		DriveEnabled = 1
			AND		DriveBroken = 0
			AND		CleaningRequired = 0
			AND		DriveId NOT IN (SELECT DriveId FROM MMResource WHERE DriveId != 0)
			AND		DriveId IN (SELECT DriveId FROM MMDriveController with (readuncommitted) WHERE DrivePoolId = @DrvPoolId
												AND	DriveControllerSoftState = 1 AND DriveControllerEnabled = 1 AND DriveAccessible = 1)
		END
IF (@LibraryTypeId = 3 AND @oldMediaId = @mediaId)
		OR (@DrivePoolType = 3) -- CV_DRIVEPOOL_NAS
OR (@LibraryTypeId != 3 AND	( @DriveCountByMP <= 1
									-- If there is only one drive and reserved by current old volume, no need to exchange the drive
									 OR (@GoodDriveCountByMP > 0 AND EXISTS (SELECT DriveId
																			FROM	MMDrive with (readuncommitted)
																			WHERE DriveId = @driveId
																			AND		DriveSoftState = 1
																			AND		DriveEnabled = 1
																			AND		DriveBroken = 0
																			AND		CleaningRequired = 0)
										)
									 OR @GoodDriveCountByMPNotReserved <= 0))
		BEGIN
				SET @tryToFindDrive = 0
		END
	END
	if @i_isDebug > 0
		  insert into RMLogger values('RMExchangeForBackup', 'Try to find drive or not [' + (CASE WHEN @tryToFindDrive > 0 THEN 'YES' ELSE 'NO' END) + ']',
		   													@i_RequestId, getutcdate())
	-- Try to get an available drive
	IF @tryToFindDrive > 0
	BEGIN
		declare @NumDriveViews int
DECLARE @RMDriveView TABLE ( DataPathId				integer, DriveControllerId		integer, DriveId					integer, DrivePoolId				integer, MasterPoolId			integer, LibraryId				integer, LibrarySubType			integer, SpareGroupId			integer, HostClientId			integer, MAClientId				integer, MountPathId				integer, DeviceId				integer, DeviceControllerId		integer, FailureErrorCode		integer, DriveAttributes			integer, Priority				integer IDENTITY(1, 1), UNIQUE CLUSTERED (DataPathId, DrivePoolId, DriveId, Priority)	)
		DELETE FROM #tmpRMDriveViewWithOffline
  	exec RMGetAvailableDrivesForDrivePool @i_RequestId, 0/*@CopyId*/, @JobId, 0/*@JobType*/, @DrvPoolId, @mediaAgentId,
0, @RecordingFormatId, @volId, 0,	2, 1, /*IsForSwap*/
																				@i_isDebug, @o_ErrorCode output, @o_FailureType output
		IF @@ERROR > 0
		BEGIN
set @o_ErrorCode = 415
set @o_FailureType = 2
		  GOTO exit_error
		END
		insert into @RMDriveView
		select distinct DataPathId, DriveControllerId, DriveId, DrivePoolId, MasterPoolId, LibraryId, LibrarySubType,
						SpareGroupId, HostClientId, MAClientId, MountPathId, DeviceId, DeviceControllerId, 0, DriveAttributes
		from	#tmpRMDriveViewWithOffline
		where	FailureErrorCode = 0
		select @NumDriveViews = @@rowcount
		if @i_isDebug > 0
		begin
			insert into RMLogger values ('RMExchangeForBackup',
							'There are total ['+ cast(isnull(@NumDriveViews, 0) as varchar(10))
							+ '] Drives (Mount Paths) availabe for volume ['
							+ cast(isnull(@volId, 0) as varchar(10)) + '] RecordingFormat ['
							+ cast(isnull(@recordingFormatId, 0) as varchar(10)) +'] in this library ['
							+ cast(isnull(@LibraryId, 0) as varchar(20)) +']',
							@i_RequestId, getutcdate())
			set @debugDetail = cast(isnull((select FailureErrorCode FailureReason, DataPathId, DrivePoolId, MasterPoolId,
																						LibraryId, HostClientId, MAClientId, DriveId, DeviceId, MountPathId
																			from #tmpRMDriveViewWithOffline
																			for XML RAW('DriveMountPathList'), TYPE), 'No Drive or Mount Path Available') as nvarchar(max))
			insert into RMLogger values('RMExchangeForBackup', @debugDetail, @i_RequestId, getutcdate())
		end
		if @NumDriveViews = 0
		begin
			set @exchangeDriveAlso = 0
			if @i_isDebug > 0
				  insert into RMLogger values('RMExchangeForBackup', 'Cannot find available drives, skip Exchange Drive.', @i_RequestId, getutcdate())
		end
		else
		begin
			set @exchangeDriveAlso = 1
set @o_ErrorCode = 0
if @RecordingFormatId = 10001 or @RecordingFormatId = 11002
			begin
				select top 1 @newDriveId = isnull(DriveId, 0),
									@newDrivePoolId = isnull(DrivePoolId, 0),
									@newMasterPoolId = isnull(MasterPoolId, 0)
				from @RMDriveView order by Priority
			end
			else
			begin
				if exists (select * from MMDrive with (readuncommitted) where MediaId = @mediaId and DriveId in (select DriveId from @RMDriveView))
				begin
					-- get a free drive
					select top 1 @newDriveId = isnull(DriveId, 0),
									@newMasterPoolId = isnull(MasterPoolId, 0)
 					from MMDrive with (readuncommitted) where MediaId = @mediaId and DriveId in (select DriveId from @RMDriveView)
					select @newDrivePoolId = isnull(DrivePoolId, 0)
					from @RMDriveView where DriveId = @newDriveId
				end
				else
				begin
					select top 1 @newDriveId = isnull(DriveId, 0),
									@newDrivePoolId = isnull(DrivePoolId, 0),
									@newMasterPoolId = isnull(MasterPoolId, 0)
 					from @RMDriveView where DriveId in (select DriveId from MMDrive with (readuncommitted) where MediaId = 0)
 					order by Priority
					if @newDriveId is null or @newDriveId = 0
					begin
						select top 1 @newDriveId = DriveId, @newDrivePoolId = DrivePoolId, @newMasterPoolId = MasterPoolId
						from @RMDriveView order by Priority
					end
				end
			end
			if @i_isDebug > 0
			begin
				set @debugDetail = cast(isnull((select  @newDriveId DriveId, @newDrivePoolId DrivePoolId, @newMasterPoolId MasterPoolId
																		for XML RAW('NewDriveInfo'), TYPE), 'No Drive Available') as nvarchar(max))
				insert into RMLogger values ('RMExchangeForBackup', 'Exange Drive to' + @debugDetail, @i_RequestId, getutcdate())
			end
		end
	END
	SELECT @reservationId = ReservationId FROM MMResource WHERE VolumeId = @oldVolumeId
	IF @exchangeDriveAlso = 0
	BEGIN
		UPDATE MMResource SET VolumeId = @volId, MediaId = @mediaId, ReservationTime = dbo.GetUnixTime(getutcdate()), MediaGroupId = @MediaGrpId
		WHERE ReservationId = @reservationId AND VolumeId = @oldVolumeId
	END
	ELSE
	BEGIN
		UPDATE MMResource
		SET VolumeId = @volId, MediaId = @mediaId, DriveId = @newDriveId,
				DrivePoolId = @newDrivePoolId, MasterPoolId = @newMasterPoolId,
				MediaGroupId = @MediaGrpId, ReservationTime = dbo.GetUnixTime(getutcdate())
		WHERE ReservationId = @reservationId
		AND		VolumeId = @oldVolumeId
		AND		DriveId = @driveId
		AND		DrivePoolId = @DrvPoolId
	END
	UPDATE 	MMResourceToJob
	SET 	ReleaseTime = 0,
			ClientTokenId = IIF((ClientTokenId <= 0 AND @SIDBStoreId > 0), RCID, ClientTokenId)  --if exchage by DDB then we should set RCId as clientToken inorder to reuturn same stream during pipeline reset
	WHERE 	ReservationId = @reservationId
	if @i_isDebug > 0
	begin
		set @debugDetail = cast(isnull((select @reservationId ReservationId,
																@oldVolumeId OldVolumeId, @driveId OldDriveId, @DrvPoolId OldDrivePoolId,
																@volId NewVolumeId, @newDriveId NewDriveId, @newDrivePoolId NewDrivePoolId
																for XML RAW('ExchangeVolume'), TYPE), 'No Volume Changed') as nvarchar(max))
		insert into RMLogger values ('RMExchangeForBackup', 'Exchange Succeed ' + @debugDetail, @i_RequestId, getutcdate())
	end
	SET @o_ReservationId = @reservationId
	set @reservationResults = (select @o_ReservationId reservationId	for XML RAW('copyRsrvList'), TYPE)
	set @reservationResults = '<ResourceManager_ReservationList>' + cast(@reservationResults as nvarchar(max)) + '</ResourceManager_ReservationList>'
exit_error:
  update RMReservationRequest
  set ErrorCode = @o_ErrorCode, FailureType = @o_FailureType,
  		FailureAttempts = FailureAttempts + sign(@o_ErrorCode),
  		PhaseFirstAttemptTime = case PhaseFirstAttemptTime when 0 then dbo.GetUnixTime(getutcdate()) else PhaseFirstAttemptTime end,
  		ReservationResults = LEFT(cast(@reservationResults as nvarchar(max)), 4000)
  where RequestId = @i_RequestId
  	IF OBJECT_ID('tempdb..#__suppress_results') IS NULL BEGIN
		select @o_ErrorCode, @o_FailureType, @o_ReservationId
	END
	/*
  if @o_ErrorCode = 0
  begin
    delete RMReservationRequest
    where RequestId = @i_RequestId
  end
	*/
	if @i_isDebug > 0
	  insert into RMLogger values('RMExchangeForBackup', 'Exit...', @i_RequestId, getutcdate())
  return @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMExchangeForBackup')
	delete from GxQscripts where name = 'RMExchangeForBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMExchangeForBackup')
	delete from GXDBVersions where aliasname = 'RMExchangeForBackup'
GO

insert into GXDBVersions values(2, 'RMExchangeForBackup',  '00010022004800090000', 'RMExchangeForBackup', '00010022004800090000')
GO

