

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMDataPathStatusFilters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMDataPathStatusFilters.sp,v $ $Id: RMDataPathStatusFilters.sp,v 1.79.2.37 2020/12/28 22:43:10 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMDataPathStatusFilters()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMDataPathStatusFilters')
BEGIN
	print '>>> Drop Stored Procedure: RMDataPathStatusFilters <<<'
	drop procedure RMDataPathStatusFilters
END
IF EXISTS (select * from GxQscripts where name='RMDataPathStatusFilters')
	delete from GxQscripts where name = 'RMDataPathStatusFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMDataPathStatusFilters')
	delete from GXDBVersions where aliasname = 'RMDataPathStatusFilters'
GO
print '... Creating Procedure: RMDataPathStatusFilters'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMDataPathStatusFilters
  @i_RequestId int,
  @i_ReservationType int,
  @i_CopyId int,
  @i_JobId int,
  @i_JobType int,
  @i_AppNum int,
  @i_AppType int,
  @i_IsForRemainingStreams int,
  @i_IsForSILOBackup int,
  @i_currentSIDBStoreId int,
  @i_inClientId int,
  @i_MAClientId int,
  @i_isIndexingRequired int,
  @i_isUseSCDataPath int,
  @i_isTransactionLogBackupPhase int,
  @i_SIDBStoreId int,
  @isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--:DECLARE o_ErrorCode			integer;
--:DECLARE o_FailureType			integer;
/* below defines are from enum : OpwindowRuleLevel*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--set @o_FailureType = RM_FAILURE_SP
  declare @BKPJOB int
  declare @RSTJOB	int
  declare @CSDRBKPJOB int
	declare @INDRSTJOB	int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  set @BKPJOB = 1
  set @RSTJOB = 2
  set @CSDRBKPJOB = 4
  set @INDRSTJOB = 5
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
  IF object_id('tempdb.dbo.#tblClientOPWindowCodes') IS NOT null DROP TABLE #tblClientOPWindowCodes
  CREATE TABLE #tblClientOPWindowCodes(clientId  integer, opWindowRetCode integer)
	declare @ARCHIVECHECK	integer
	declare @SELECTIVEDELETE integer
	declare @DRIVEVALIDATION integer
	declare @DRIVECLEANING integer
	declare @BROWSEANDDELETE integer
	declare @STAMPMEDIA integer
	declare @DEDUPDBSYNC integer
	declare @AUXCOPY2		integer
	declare @ARCHIVECHECK2 	integer
	declare @MEDIAREFRESHING2 	integer
	set @ARCHIVECHECK = 31 -- Data Verification
	set @SELECTIVEDELETE = 38
	set @DRIVEVALIDATION = 41
	set @DRIVECLEANING = 42
	set @BROWSEANDDELETE = 44
	set @STAMPMEDIA = 46
	set @DEDUPDBSYNC = 80
	set @AUXCOPY2	= 104
	set @ARCHIVECHECK2  = 106 -- Data Verfication(Dash)
	set @MEDIAREFRESHING2  = 127 -- Media Refresh(Dash)
	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	SET		@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
	SET		@HOST_STATUS_POWER_MANAGED_VM		= 7
	declare @isMaintenanceJob int = 0
	declare @jobOpType int = 0
	declare @jobSubOpType int = 0
	DECLARE @taskId INTEGER = 0
	DECLARE @isPowerVMFeatureEnabled INT
	SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
	--set @jobOpType = dbo.GetJobTypeForJobID(@i_JobId)
	 IF EXISTS (SELECT * FROM JMJobInfo WITH (NOLOCK) WHERE JobId = @i_JobId)
    BEGIN
        SELECT  @jobOpType = ISNULL(job.opType, 0),
                @jobSubOpType = ISNULL(job.subOpType, 0)
        FROM    JMJobInfo job WITH (NOLOCK)
        WHERE   job.JobId = @i_JobId
		IF @jobSubOpType > 0
			SET @jobOpType = @jobSubOpType
	END
	if @jobOpType = @DRIVEVALIDATION or @jobOpType = @DRIVECLEANING or @jobOpType = @STAMPMEDIA
		set @isMaintenanceJob = 1
	declare @NumDataPathViews int
	select @NumDataPathViews = count(*) from RMDataPathView where FailureErrorCode = 0
	if @NumDataPathViews = 0
	begin
if @i_ReservationType = 2
		begin
set @o_ErrorCode = 20016
set @o_FailureType = 2
			GOTO EXIT_AND_RETURN
		end
if @i_ReservationType = 1
		begin
set @o_ErrorCode = 322
set @o_FailureType = 2
			GOTO EXIT_AND_RETURN
		END
	end
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	/*
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMGetDataPathView', 'Enter...', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select @i_CopyId copyId, @i_JobId jobId, @i_JobType jobType, @i_AppNum appNum, @i_AppType appType,
																	@i_DataType dataType, @i_BkpLevel bkpLevel, @i_IsForRemainingStreams isForRemainingStreams,
																	@i_UseSCDataPath useSCDataPath, @i_UsePreferredDP usePreferredDP, @i_IsForSILOBackup isForSILOBackup, @i_inClientId inClientId,
																	@i_addtionalFilter additionalFilter
															for XML RAW('Parameters'), TYPE), 'NULL') as varchar(max))
		insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	end
	*/
  ---------------------------------------------------------------
  --   Check Media Agent version for backup of duplcaiton copy --
  ---------------------------------------------------------------
IF @i_ReservationType = 2
	BEGIN
		IF @i_CopyId > 0 AND @i_IsForSILOBackup = 0 AND @i_SIDBStoreId > 0
		BEGIN
			--MA Delete case
			DECLARE @sidbMAReleaseId int
			SET @sidbMAReleaseId = ISNULL( ( SELECT TOP 1 cl.releaseId
																FROM	 App_Client cl with (readuncommitted), IdxSIDBSubStore store with (readuncommitted)
																WHERE		@i_SIDBStoreId = store.SIDBStoreId
																AND			store.clientId = cl.id AND cl.id <> 1
																ORDER BY cl.releaseId desc), 0)
			DECLARE @mediaAgentVersionCheckList TABLE ( clientId INT, releaseId INT)
			INSERT INTO @mediaAgentVersionCheckList
				SELECT	DISTINCT cl.Id, cl.releaseId
				FROM		RMDataPathView a with (readuncommitted), App_Client cl with (readuncommitted)
				WHERE		a.FailureErrorCode = 0
					AND			a.HostClientid = cl.Id AND cl.id <> 1
			INSERT INTO @mediaAgentVersionCheckList
				SELECT DISTINCT cl.Id, cl.releaseId
				FROM	 App_Client cl with (readuncommitted), IdxSIDBSubStore store with (readuncommitted)
				WHERE		@i_SIDBStoreId = store.SIDBStoreId
					AND			store.clientId = cl.id AND cl.id <> 1
			DECLARE @versions int
			SET @versions = isnull ( (select count( distinct releaseId ) from @mediaAgentVersionCheckList), 0)
			IF @versions > 1
			BEGIN
				DECLARE @maxVersion int
				SET @maxVersion = (select max(releaseId) from @mediaAgentVersionCheckList)
				-- cliu 3/14/3013,
				-- MR 91583, Upgrade Enhancement, when DataMover MA is compatible with DDB MA, backup should be able to run using such MA.
				-- Therefore, we don't need to make sure all the DataMover MAs have to be comptible with DDB MA anymore.
				IF @sidbMAReleaseId = @maxVersion
				BEGIN
					UPDATE RMDataPathView
SET		FailureErrorCode = 20071,
FailureType = 1
					WHERE	FailureErrorCode = 0
					ANd		HostClientId IN (SELECT clientId FROM @mediaAgentVersionCheckList WHERE releaseId != @sidbMAReleaseId)
				END
				ELSE
				BEGIN
					UPDATE RMDataPathView
SET		FailureErrorCode = 20081,
FailureType = 1
					WHERE	FailureErrorCode = 0
					AND		HostClientId IN (SELECT clientId FROM @mediaAgentVersionCheckList WHERE releaseId != @sidbMAReleaseId)
				END
				SELECT @NumDataPathViews = @NumDataPathViews - @@rowcount
				IF @NumDataPathViews = 0
				BEGIN
SET @o_ErrorCode = 20070
SET @o_FailureType = 2
					GOTO EXIT_AND_RETURN
				END
			END
			-- Client with client side dedup enabled from pre 10.0 release cannot run backup
			-- to the SIDB Store Media Agent that is 10.0 and using multiple partitions.
			IF @i_CopyId > 0 AND @i_JobType = @AUXCOPYJOB
			IF EXISTS (SELECT 1 FROM App_Client with (readuncommitted) WHERE Id = @i_inClientId AND ReleaseId <= 14 /* release 9.0*/)
			IF EXISTS (SELECT 1 FROM IdxSIDBSubStore substore with (readuncommitted)
							WHERE		@i_SIDBStoreId = substore.SIDBStoreId
							GROUP BY substore.SIDBStoreId
							HAVING COUNT(substore.SubStoreId) > 1
						)
			BEGIN
				UPDATE RMDataPathView
SET		FailureErrorCode = 20111,
FailureType = 2
				FROM RMDataPathView a with (readuncommitted), App_Client cl with (readuncommitted)
				WHERE		a.FailureErrorCode = 0
				AND			a.HostClientid = cl.Id
				AND			cl.ReleaseId > 14 /* release 9.0 */
				SELECT @NumDataPathViews = @NumDataPathViews - @@rowcount
				IF @NumDataPathViews = 0
				BEGIN
SET @o_ErrorCode = 20111
SET @o_FailureType = 2
					GOTO EXIT_AND_RETURN
				END
			END
			-- For Object level single instance, don't allow any 10.0 MAs.
			-- Block level single instance
			if not exists (select 1 from ArchGroup with (readuncommitted)
								 where id = (select ArchGroupId from ArchGroupCopy with (readuncommitted) where id = @i_CopyId)
and flags & 32 > 0)
			-- Skip the check if using GDSP
			and not exists (select 1 from ArchGroupCopy a with (readuncommitted)
								where	a.Id = @i_CopyId
								-- do not check if the copy uses GDSP regradless if the DDB is active or not
--and		(a.dedupeFlags & 262144 > 0)
and		(a.dedupeFlags & 268435456 > 0
										 OR
a.dedupeFlags & 134217728 > 0))
			and @sidbMAReleaseId > 14 /*release 9.0*/
			BEGIN
				UPDATE RMDataPathView
SET		FailureErrorCode = 481,
FailureType = 1
				WHERE FailureErrorCode = 0
				SET @NumDataPathViews = 0
SET @o_ErrorCode = 481
SET @o_FailureType = 1
				GOTO EXIT_AND_RETURN
			END
		END
	END
  ----------------------------------------
  --   License Check For Data Paths     --
  ----------------------------------------
IF @i_ReservationType = 2
	BEGIN
	  ----------------------------------------
	  --   Media Agent   License Check      --
	  ----------------------------------------
		declare @hasLicense int
		declare @mediaAgentLicCheckList table ( clientId int, validLicense int, errorcode int )
		declare @mediaAgentId int
		declare @mediaAgentLicType int
		insert into @mediaAgentLicCheckList
		select	DISTINCT HostClientId, 0, 0 from RMDataPathView where FailureErrorCode = 0
		IF (Cursor_Status('LOCAL', 'mediaAgentList_Cursor') >= -1)
		BEGIN
			CLOSE mediaAgentList_Cursor
			DEALLOCATE mediaAgentList_Cursor
		END
		DECLARE mediaAgentList_Cursor CURSOR LOCAL FOR
			SELECT	clientId FROM @mediaAgentLicCheckList
		OPEN mediaAgentList_Cursor
		FETCH NEXT FROM mediaAgentList_Cursor INTO @mediaAgentId
		WHILE @@FETCH_STATUS = 0
		begin
			exec RMLookupLicTypeByMediaAgentId @mediaAgentId, @mediaAgentLicType output
			IF @@ERROR > 0
			BEGIN
			  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if exists (select CId from LicUsage with (readuncommitted)
						where CId = @mediaAgentId and LicType = @mediaAgentLicType
and AppType = 1002 and OpType = 'Uninstall'
						)
			begin
			  UPDATE	RMDataPathView
SET		FailureErrorCode = 529,
FailureType = 1
			  WHERE		FailureErrorCode = 0
			  AND		HostClientId = @mediaAgentId
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 529
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			-- Media Agent License
			-- This is no way to get the license type based on the media.
			-- But only check based on app type will be enough.
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @mediaAgentId, @mediaAgentLicType, 1002, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
			  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE RMDataPathView
SET		FailureErrorCode = 518,
FailureType = 1
			  WHERE	FailureErrorCode = 0
			  AND		HostClientId = @mediaAgentId
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 518
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
			-- Auxcopy Encryption License
			if @i_CopyId > 0
			and  @i_JobType = @AUXCOPYJOB
			and exists (select * from ArchGroupCopy with (readuncommitted) where id = @i_CopyId and encType > 0)
			begin
				set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @mediaAgentId, 139, 1077, 'install', 0, 0
				IF @@ERROR > 0
				BEGIN
				  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				END
				if @hasLicense = 0
				begin
				  UPDATE RMDataPathView
SET		FailureErrorCode = 520,
FailureType = 1
				  WHERE	FailureErrorCode = 0
				  AND		HostClientId = @mediaAgentId
					select @NumDataPathViews = @NumDataPathViews - @@rowcount
					if @NumDataPathViews = 0
					begin
set @o_ErrorCode = 520
set @o_FailureType = 1
					  GOTO EXIT_AND_RETURN
					end
				end
			end
			-- end of checking media agent license
			FETCH NEXT FROM mediaAgentList_Cursor INTO @mediaAgentId
		end -- while for check the media agent
		-- Single Instance License
		if @i_CopyId > 0
		and ( @i_IsForSILOBackup > 0
              or @i_SIDBStoreId > 0
            )
		begin
			declare @SIDBStoreMAId int
			set @SIDBStoreMAId = 0
			declare @sidbstoreMAList table (clientId int)
			if @i_IsForSILOBackup = 0
			begin
				insert into @sidbstoreMAList
				select distinct c.ClientId
				from 	IdxSIDBSubStore c with (readuncommitted)
				where	@i_SIDBStoreId = c.SIDBStoreId
					AND c.ClientId <> 1 --MA delete case
			end
            -- for SILO job, the copy will be the soruceCopyId.
            else
            begin
				insert into @sidbstoreMAList
				select distinct c.ClientId
				from 	ArchGroupCopy a with (readuncommitted), ArchCopySIDBStore b with (readuncommitted), IdxSIDBSubStore c with (readuncommitted)
				where	a.Id = @i_CopyId
					and     b.CopyId = a.SourceCopyId
					and		b.SIDBStoreId = @i_currentSIDBStoreId
					and		b.SIDBStoreId = c.SIDBStoreId
					AND c.ClientId <> 1 --MA delete case
            end
			IF (Cursor_Status('LOCAL', 'sidbMAList_Cursor') >= -1)
			BEGIN
				CLOSE sidbMAList_Cursor
				DEALLOCATE sidbMAList_Cursor
			END
			DECLARE sidbMAList_Cursor CURSOR LOCAL FOR
				SELECT	clientId FROM @sidbstoreMAList
			OPEN sidbMAList_Cursor
			FETCH NEXT FROM sidbMAList_Cursor INTO @SIDBStoreMAId
			WHILE @@FETCH_STATUS = 0
			begin
				-- Block level single instance
				if exists (select 1 from ArchGroup with (readuncommitted)
									 where id = (select ArchGroupId from ArchGroupCopy with (readuncommitted) where id = @i_CopyId)
and flags & 32 > 0)
				or exists (select a.Id from ArchGroupCopy a with (readuncommitted)
									where a.Id = @i_CopyId
and		(a.dedupeFlags & 134217728) > 0)
				begin
					set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @SIDBStoreMAId, 168, 1100, 'install', 0, 0
					IF @@ERROR > 0
					BEGIN
					  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO EXIT_AND_RETURN
					END
					if @hasLicense = 0
					begin
					  UPDATE RMDataPathView
SET		FailureErrorCode = 525,
FailureType = 1
					  WHERE	FailureErrorCode = 0
					  --AND		HostClientId = @mediaAgentId
						select @NumDataPathViews = @NumDataPathViews - @@rowcount
						if @NumDataPathViews = 0
						begin
set @o_ErrorCode = 525
set @o_FailureType = 1
						  GOTO EXIT_AND_RETURN
						end
					end
				end
				-- Object level single instance
				else
				begin
					set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @SIDBStoreMAId, 132, 1076, 'install', 0, 0
					IF @@ERROR > 0
					BEGIN
					  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO EXIT_AND_RETURN
					END
					if @hasLicense = 0
					begin
					  UPDATE RMDataPathView
SET		FailureErrorCode = 519,
FailureType = 1
					  WHERE	FailureErrorCode = 0
					  --AND		HostClientId = @mediaAgentId
						select @NumDataPathViews = @NumDataPathViews - @@rowcount
						if @NumDataPathViews = 0
						begin
set @o_ErrorCode = 519
set @o_FailureType = 1
						  GOTO EXIT_AND_RETURN
						end
					end
				end
				-- SILO backup License
				if @i_IsForSILOBackup > 0
				begin
					set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, @SIDBStoreMAId, 169, 1101, 'install', 0, 0
					IF @@ERROR > 0
					BEGIN
					  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
					  GOTO EXIT_AND_RETURN
					END
					if @hasLicense = 0
					begin
					  UPDATE RMDataPathView
SET		FailureErrorCode = 523,
FailureType = 1
					  WHERE	FailureErrorCode = 0
					  --AND		HostClientId = @mediaAgentId
						select @NumDataPathViews = @NumDataPathViews - @@rowcount
						if @NumDataPathViews = 0
						begin
set @o_ErrorCode = 523
set @o_FailureType = 1
						  GOTO EXIT_AND_RETURN
						end
					end
				end
				FETCH NEXT FROM sidbMAList_Cursor INTO @SIDBStoreMAId
			end
		end
	  ----------------------------------------
	  --    Library  License Check          --
	  ----------------------------------------
		-- Check for CAS
if exists (select * from RMDataPathView where LibraryAttribute & 268435456 > 0)
		begin
			set @hasLicense = 1
exec @hasLicense = RMCheckLicenseStatus 0, 2, 105, 1035, 'install', 0, 0
			IF @@ERROR > 0
			BEGIN
			  set @NumDataPathViews = 0
set @o_ErrorCode = 415
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			END
			if @hasLicense = 0
			begin
			  UPDATE RMDataPathView
SET		FailureErrorCode = 512,
FailureType = 1
			  WHERE	FailureErrorCode = 0
AND		LibraryAttribute & 268435456 > 0
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 512
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
		end
	END
-- *********************************************************************************  --
--                                                                      							--
--	After decide the data path selection order, now we can check whether							--
--	data path availiable to be used or not based on the resource properties.					--
--																																										--
--																																										--
-- *********************************************************************************  --
STATUS_CHECK_FILTER:
  -- Status check priority
  -- 1. Media Agent
  -- 2. Library
  -- 3. MasterPool
  -- 4. DrivePool
  ----------------------	Media Agent Status	---------------------------------------------------------
  update	RMDataPathView
set			FailureErrorCode = case when (c.status & 16384) > 0 then 527
when mmhostsoftstate <> 1		then 384
when mmhostenabled <> 1			then 383
  															 else 0 end,
FailureType = 1
  from		RMDataPathView a, App_Client c with (readuncommitted), MMHost h WITH (READUNCOMMITTED)
  WHERE		a.FailureErrorCode = 0
	and			a.HostClientId = c.Id and c.Id = h.ClientId
	and 		(-- don't include preconfigured client
				  (c.status & 16384) > 0
				  or h.mmhostsoftstate <> 1
				  or h.mmhostenabled <> 1)
	AND NOT EXISTS (
					SELECT 1 FROM MMHost WITH (READUNCOMMITTED)
					WHERE ClientId = h.ClientId AND offlineReason = @HOST_STATUS_POWER_MANAGED_VM
AND Attribute & 32768 > 0
					AND mmhostenabled = 1 AND @isPowerVMFeatureEnabled > 0
					)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 371
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
  -----------------------	Library Status	--------------------------------------------------------
  update	RMDataPathView
set			FailureErrorCode = case when l.LibrarySoftState <> 1	then 374
when l.LibraryEnabled <> 1		then 372
when l.LibraryBroken <> 0			then 373
  															else 0 end,
FailureType = 1
  from		RMDataPathView a, MMLibrary l WITH (READUNCOMMITTED)
  WHERE		a.FailureErrorCode = 0
  and			a.LibraryId > 0
  and			a.LibraryId = l.LibraryId
  and			(l.LibrarySoftState <> 1
		  	or l.LibraryEnabled <> 1
		  	or l.LibraryBroken <> 0)
  AND 	NOT EXISTS (
						SELECT 1 FROM MMHost WITH (READUNCOMMITTED)
						WHERE ClientId = a.HostClientId AND OfflineReason = @HOST_STATUS_POWER_MANAGED_VM
AND Attribute & 32768 > 0
						AND l.LibraryEnabled = 1 AND @isPowerVMFeatureEnabled > 0
					)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 270
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
	----------------------	Library Controller Status	( no active library controller	)	-----------------
  -- Don't check library controller status for magnetic library
	update	RMDataPathView
set			FailureErrorCode = 309,
FailureType = 1
	where 	FailureErrorCode = 0
	and			SpareGroupId > 0
	and			LibraryId > 0
	and			not exists (select LC.libraryControllerId from MMLibraryController LC with (readuncommitted)
											where RMDataPathView.LibraryId = LC.LibraryId
											and	 ( LC.LibraryControllerActive = 1 OR ( LC.LibraryControllerActive = 0
AND EXISTS(SELECT 1 FROM MMHost WITH (READUNCOMMITTED) WHERE ClientId = LC.ClientId AND OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND Attribute & 32768 > 0 AND @isPowerVMFeatureEnabled > 0 ))))
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 309
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
	----------------------	Library Controller Status	( library controller offline )	-----------------
  -- Don't check library controller status for magnetic library
	update	RMDataPathView
set			FailureErrorCode = 269,
FailureType = 1
	where		FailureErrorCode = 0
	and			SpareGroupId > 0
	and			LibraryId > 0
	and			not exists (select libraryId from MMLibraryController WITH (READUNCOMMITTED)
									where RMDataPathView.LibraryId = LibraryId
									and		LibraryControllerActive = 1
									and		librarycontrollersoftstate = 1
									and		librarycontrollerenabled = 1)
	and 		NOT EXISTS (SELECT 1 FROM MMHost H, MMLibraryController LC WITH (READUNCOMMITTED)
									WHERE RMDataPathView.LibraryId = LC.LibraryId AND H.ClientId = LC.ClientId
									AND H.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM
AND H.Attribute & 32768 > 0
									AND	LC.librarycontrollerenabled = 1
									AND LC.LibraryControllerActive = 1
									AND @isPowerVMFeatureEnabled > 0)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 269
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
	----------------------	Library Server Host Status	-----------------
	update	RMDataPathView
set			FailureErrorCode = 40070,
FailureType = 1
	where		FailureErrorCode = 0
	and			SpareGroupId > 0
	and			LibraryId > 0
	and			LibrarySubType = @CV_LIBSUBTYPE_LIBRARY_SERVER
	and			not exists (select host.ClientId from MMLibraryController lc WITH (READUNCOMMITTED),
													MMLibraryHostInfo lh WITH (READUNCOMMITTED),
													MMHost	host WITH (READUNCOMMITTED),
													APP_Client client WITH (READUNCOMMITTED)
									where RMDataPathView.LibraryId = lc.LibraryId
									and		lc.LibraryControllerId = lh.LibraryControllerId
									and		lh.HostClientId = host.ClientId
									and		host.ClientId = client.Id
									and		(-- don't include preconfigured client
												(client.status & 16384) = 0
												and host.mmhostsoftstate = 1
												and host.mmhostenabled = 1)
									)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 40070
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
	----------------------	Master Pool Status	---------------------------------------------------------
	update	RMDataPathView
set			FailureErrorCode = 271,
FailureType = 1
	from		RMDataPathView a, MMMasterPool mp  WITH (READUNCOMMITTED)
	where		a.FailureErrorCode = 0
	and			a.MasterPoolId > 0
	and			a.MasterPoolId = mp.MasterPoolId
	and			(mp.MasterPoolSoftState	<> 1 or mp.MasterPoolEnabled <> 1)
	and 		NOT EXISTS (SELECT 1 FROM MMHost WITH (READUNCOMMITTED)
							WHERE ClientId = a.HostClientId AND OfflineReason = @HOST_STATUS_POWER_MANAGED_VM
AND Attribute & 32768 > 0 AND mp.MasterPoolEnabled = 1 AND @isPowerVMFeatureEnabled > 0)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 271
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
	---------------------	Drive Pool Status	---------------------------------------------------------
	update	RMDataPathView
set			FailureErrorCode = 256,
FailureType = 1
	from		RMDataPathView a, MMDrivePool dp  WITH (READUNCOMMITTED)
	where		a.FailureErrorCode = 0
	and			a.DrivePoolId > 0
	and			a.DrivePoolId = dp.DrivePoolId
	and			(dp.DrivePoolSoftState <> 1 or dp.DrivePoolEnabled <> 1)
	and 		NOT EXISTS (SELECT 1 FROM MMHost WITH (READUNCOMMITTED)
							WHERE ClientId = a.HostClientId AND OfflineReason = @HOST_STATUS_POWER_MANAGED_VM
AND Attribute & 32768 > 0 AND dp.DrivePoolEnabled = 1 AND @isPowerVMFeatureEnabled > 0)
	set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
	if @NumDataPathViews = 0
	begin
set @o_ErrorCode = 256
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
  -------------------------------------
  --          End of Module          --
  -------------------------------------
  -----------------------------------------------
  --       Filter: Operation Window 		   --
  -----------------------------------------------
  ----------------------	AuxCopy2 Operation Window  -----------------------
	IF @jobOpType IN (@AUXCOPY2, @MEDIAREFRESHING2)
	BEGIN
		SET @taskId = ISNULL((SELECT TOP 1 jobReq.taskId FROM TM_Jobs jobs WITH(NOLOCK) INNER JOIN TM_JobRequest jobReq WITH(NOLOCK)
										ON jobs.jobId = @i_JobId AND jobs.jobRequestId = jobReq.jobRequestId ),0)
		INSERT INTO #tblClientOPWindowCodes
		SELECT DISTINCT HostClientId, -1
		FROM RMDataPathView WITH (READUNCOMMITTED)
		WHERE FailureErrorCode = 0
		UPDATE #tblClientOPWindowCodes
SET opWindowRetCode = CASE dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, ClientId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId) WHEN 0 THEN 84001
WHEN 1 THEN 84002
WHEN 2 THEN 84003
WHEN 3 THEN 84004
WHEN 4 THEN 84005
WHEN 5 THEN 84006
WHEN 6 THEN 84007
WHEN 7 THEN 84008
WHEN 8 THEN 84009
							   WHEN -1	THEN 0
ELSE 84001 END
		update	RMDataPathView
		set		FailureErrorCode = opWindowRetCode,
FailureType = 1
		from	RMDataPathView R, #tblClientOPWindowCodes t
		where	t.opWindowRetCode <> 0 AND t.clientId = R.HostClientId
                        AND R.FailureErrorCode = 0
		set @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
		if @NumDataPathViews = 0
		begin
set @o_ErrorCode = (SELECT TOP 1 FailureErrorCode FROM RMDataPathView WITH (READUNCOMMITTED) WHERE FailureErrorCode BETWEEN 84001 AND 84009)
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		end
	END
  ----------------------------------------------------
  --          End of Operation Window Module        --
  ----------------------------------------------------
  -----------------------------------------------
  -- Filter: Index Cache check on DrivePool		 --
  -----------------------------------------------
if @i_isIndexingRequired /*dbo.IsIndexingApp(@i_AppType)*/ > 0 and @i_ReservationType = 2
  begin
		update	RMDataPathView
set			FailureErrorCode = 840,
FailureType = 1
		where		FailureErrorCode = 0
		and			exists (select idxc.IdxCacheId from IdxCache idxc with (readuncommitted), IdxAccessPath idxa with (readuncommitted), MMDrivePool dp with (readuncommitted),
									App_Client cl with (readuncommitted)
										where RMDataPathView.DrivePoolId = dp.DrivePoolId
										and		dp.ClientId = idxa.ClientId
										and		idxa.IdxCacheId = idxc.IdxCacheId
and		idxc.IdxCacheType = 1
										and		( idxc.Enabled <> 1 or idxc.SoftState <> 1)
										and		dp.ClientId = cl.id
										and 	cl.ReleaseId < 16)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 840
set @o_FailureType = 1
	    GOTO EXIT_AND_RETURN
	  end
	  --For 11.0 MA check app_client prop for index chche status
		update	RMDataPathView
set		FailureErrorCode = 840,
FailureType = 1
		where	FailureErrorCode = 0
		and		exists (select 1 from App_ClientProp clProp with (readuncommitted), MMDrivePool dp with (readuncommitted),
								App_Client cl with (readuncommitted)
						where RMDataPathView.DrivePoolId = dp.DrivePoolId
						and		dp.ClientId = cl.id
						and 	cl.ReleaseId >= 16
						and 	clProp.componentNameId = cl.id
						and		clProp.attrName = 'Idx: cache enabled'
						and		CONVERT(INT, clProp.attrVal) <> 1
						)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 840
set @o_FailureType = 1
	    GOTO EXIT_AND_RETURN
	  end
		update	RMDataPathView
set			FailureErrorCode = 839,
FailureType = 1
		where		FailureErrorCode = 0
		-- If the IdxCache exists, check the status of access path.
		-- If the IdxCache doesn't exist, skip the check for access path.
		and			exists (select idxc.IdxCacheId from IdxCache idxc with (readuncommitted), IdxAccessPath idxa with (readuncommitted), MMDrivePool dp with (readuncommitted),
								App_Client cl with (readuncommitted)
								where RMDataPathView.DrivePoolId = dp.DrivePoolId
								and		dp.ClientId = idxa.ClientId
								and		idxa.IdxCacheId = idxc.IdxCacheId
and		idxc.IdxCacheType = 1
								and		dp.ClientId = cl.id
								and 	cl.ReleaseId < 16)
		and			not exists (select idxa.IdxAccessPathId from IdxAccessPath idxa with (readuncommitted), MMDrivePool dp with (readuncommitted), IdxCache idxc with (readuncommitted)
												where RMDataPathView.DrivePoolId = dp.DrivePoolId
												and		dp.ClientId = idxa.ClientId
												and		idxa.IdxCacheId = idxc.IdxCacheId
and		idxc.IdxCacheType = 1
												and		idxa.Enabled = 1
												and		idxa.SoftState = 1)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 839
set @o_FailureType = 1
	    GOTO EXIT_AND_RETURN
	  end
		-- If the Index is shared among Media Agent, and there are 9.0 Media Agent existing in the data path list,
		-- then any 8.0 Media Agent will be filtered out to prevent it accessing the index.
		DECLARE @isIndexShared INTEGER
		SET @isIndexShared = CASE
		  WHEN (	select count(distinct idxc.IdxCacheId)
							from 	RMDataPathView rm, IdxCache idxc with (readuncommitted), IdxAccessPath idxa with (readuncommitted), MMDrivePool dp with (readuncommitted)
							-- When use subclient data path, only check the subclient data path.
							-- Leave a work around for use is they don't want to upgrade the MA for now.
where (@i_isUseSCDataPath = 0 OR rm.FailureErrorCode != 20017)
							and		rm.DrivePoolId = dp.DrivePoolId
							and		dp.ClientId = idxa.ClientId
							and		idxa.IdxCacheId = idxc.IdxCacheId
and		idxc.IdxCacheType = 1
					) > 1
			THEN 0
		  ELSE 1 END
		IF @isIndexShared > 0
		-- 9.0 Media Agent exists
		AND EXISTS (
									SELECT 	client.Id
									FROM		RMDataPathView rm, MMDrivePool dp with (readuncommitted), APP_Client client with (readuncommitted)
WHERE		(@i_isUseSCDataPath = 0 OR rm.FailureErrorCode != 20017)
									AND			rm.DrivePoolId = dp.DrivePoolId
									AND			dp.ClientId = client.Id
									AND			client.ReleaseId >= 14 /* release 9.0*/
								)
		BEGIN
			update	RMDataPathView
set			FailureErrorCode = 20063,
FailureType = 2
			where		FailureErrorCode = 0
			and			exists (SELECT	client.Id
											from		MMDrivePool dp with (readuncommitted), APP_Client client with (readuncommitted)
											WHERE		RMDataPathView.DrivePoolId = dp.DrivePoolId
											AND			dp.ClientId = client.Id
											AND			client.ReleaseId < 14)
		  select @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20063
set @o_FailureType = 2
		    GOTO EXIT_AND_RETURN
		  end
		END
	end
  ---------------------------------------------------
  -- End of Filter: Index Cache check on DrivePool --
  ---------------------------------------------------
  -----------------------------------------------------------
  -- Filter: Prevent SI job if the SIDB is not accessable	 --
  -----------------------------------------------------------
  if @i_CopyId > 0
  and @i_IsForSILOBackup = 0
  and @i_SIDBStoreId > 0
  -- Skip DDB check for transaction log backup phase during reservation
  and @i_isTransactionLogBackupPhase = 0
  begin
    declare @sidbStoreStatus int
	declare @sidbStoreFlags int
  	declare @dedupeFlags int
	declare @commCellId int
	declare @sidbCorruptLimit int = 0
  	select @dedupeFlags = dedupeFlags from ArchGroupCopy with (readuncommitted) where id = @i_CopyId
  	select @sidbStoreStatus = Status, @sidbStoreFlags = flags, @commCellId = CommCellId from IdxSIDBStore with (readuncommitted) where SIDBStoreId = @i_SIDBStoreId
	-- this value is only usable when flag CVA_SIDB_RESILIENCY_ENABLED_FLAG is set for copy dedupeFlags
	select top 1 @sidbCorruptLimit = isnull(task.percentCorruptLimit, 0)
	from archTask as task with (readuncommitted), ArchGroupCopy as copy with (readuncommitted)
	where	copy.id = @i_CopyId
	and		copy.sealStoreTaskId = task.id
	-- If the following option is one, and subclient dedupelication property is turned off, job can still run.
	declare @allowDeDupJobsWhenDDBCorrupted int
	set @allowDeDupJobsWhenDDBCorrupted = 0
	select @allowDeDupJobsWhenDDBCorrupted = isnull(value, 0)
	from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION'
	declare @dedupeDisabledOnSubClient int
	set @dedupeDisabledOnSubClient = 0
	IF @i_appNum > 0 AND @i_JobType != @AUXCOPYJOB
	AND	(
			EXISTS ( select prop.Id from APP_SubClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
							where app.Id = @i_appNum and app.Id = prop.ComponentNameId
							and prop.cs_attrName = CheckSum(N'Single Instancing Option')
							and prop.attrName = N'Single Instancing Option' and prop.attrVal = '0' and prop.Modified = 0
					)
		)
	begin
		set @dedupeDisabledOnSubClient = 1
	end
	-- alway assume subclient dedupe is enabled for auxcopy, as it doesn't exist for auxcopy job
	else if @i_JobType = @AUXCOPYJOB
	begin
		set @dedupeDisabledOnSubClient = 0
	end
	declare @isDDBActivityDisabled int
	set @isDDBActivityDisabled = 0
	IF EXISTS( SELECT 1 FROM JMJobAction WITH (READUNCOMMITTED) WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND opType IN (1, 100) /*All Activity, DDB Activity*/
				AND appId = (SELECT id FROM App_Application WITH (READUNCOMMITTED) WHERE appTypeId = 1000) AND clientGroupId = 0 AND action = 1)
	BEGIN
		set @isDDBActivityDisabled = 1
	END
    if @isDebug > 0
    begin
    	set @debugDetail = cast((select @allowDeDupJobsWhenDDBCorrupted allowDeDupJobsWhenDDBCorrupted,
@dedupeFlags & 67108864 AutoRecontructionDedupStore,
@dedupeFlags & 33554432 RecontructSIDBFromSnapshot,
                                        @dedupeDisabledOnSubClient DedupeDisabledOnSubClient,
										@isDDBActivityDisabled isDDBActivityDisabledOnCommServer
 								for XML RAW('DedupeOptions'), TYPE) as varchar(max))
    	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
    end
	-- if DDB or Backup activity is disabled then disallow all the backup jobs for the whole commserver
	if @isDDBActivityDisabled > 0
	begin
set @o_ErrorCode = 20119
		update	RMDataPathView
		set		FailureErrorCode = @o_ErrorCode,
FailureType = 1
		where	FailureErrorCode = 0
		set @NumDataPathViews = 0
set @o_FailureType = 1
		GOTO EXIT_AND_RETURN
	end
/*
	-- Prevent backup of DDB subclient if DDB move of DDB subclient content is in progress.
	IF  @i_AppNum > 0 AND @i_JobType = @BKPJOB  AND
		EXISTS (	SELECT 1 FROM App_Application APP WITH (NOLOCK)
					INNER JOIN APP_SubClientProp SCPROP WITH (NOLOCK) ON SCPROP.componentNameId = APP.Id AND SCPROP.attrName LIKE 'DDB Backup' AND SCPROP.attrVal = 1 AND APP.Id = @i_AppNum
					INNER JOIN IdxSIDBSubStore subStore WITH (NOLOCK) ON APP.clientId = subStore.clientId
AND (subStore.Flags & 1024) = 1024
				)
	BEGIN
set @o_ErrorCode = 53079
			UPDATE	RMDataPathView
			SET		FailureErrorCode = @o_ErrorCode,
FailureType = 1
			WHERE	FailureErrorCode = 0
			SET @NumDataPathViews = 0
SET @o_FailureType = 1
			GOTO EXIT_AND_RETURN
	END
*/
	-- if the sidb store is corrupted, disallow all the backup jobs for this copy
	-- if the configuration allows backup, then skip the check if flags set to recontruction not failover.
  	if (
			-- If dedupe is disabled on subclient, we allow regular backup run to this particular subclient
			@dedupeDisabledOnSubClient = 0
			AND
			-- If dedupe is disabled on copy, we allow regular bakcup run to this copy for all the subclients
(@dedupeFlags & 1048576) = 0
		)
	begin
		-- Check if the store is under maintenance. But allow the job to proceed if dedupe is disabled on the copy
if @allowDeDupJobsWhenDDBCorrupted = 0 and (@sidbStoreFlags & 16777216) <> 0
		begin
set @o_ErrorCode = 66017
			update RMDataPathView
set	FailureErrorCode = @o_ErrorCode, FailureType = 1
			set @NumDataPathViews = 0
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		end
		if (@allowDeDupJobsWhenDDBCorrupted = 0 or @i_JobType = @AUXCOPYJOB or @jobOpType = @AUXCOPY2) and exists
		(
				select idxss.SIDBStoreId
				from IdxSIDBSubStore idxss with (readuncommitted)
				join IdxSIDBStore st with (readuncommitted) on idxss.SIDBStoreId = st.SIDBStoreId
				where st.SIDBStoreId = @i_SIDBStoreId
				and	((idxss.Version > st.Version)
or  (idxss.Flags & 8192 <> 0
and st.Flags & 8192 = 0))
		)
		begin
set @o_ErrorCode = 53078
			update RMDataPathView
set	FailureErrorCode = @o_ErrorCode, FailureType = 1
			set @NumDataPathViews = 0
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		end
IF (@sidbStoreFlags & 1024) <> 0
		BEGIN
SET @o_ErrorCode = 53049 -- DDB Move partition job is running
			UPDATE RMDataPathView
SET	FailureErrorCode = @o_ErrorCode, FailureType = 1
			SET @NumDataPathViews = 0
SET @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
IF NOT EXISTS (SELECT 1 FROM IdxSIDBSubStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId AND (flags & 64) = 0)
		BEGIN
SET @o_ErrorCode = 66105
			UPDATE RMDataPathView
SET	FailureErrorCode = @o_ErrorCode, FailureType = 1
			SET @NumDataPathViews = 0
SET @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		END
		-- Check if the store is set as DV in progress. But should allow job to proceed if dedup is disabled on the copy
if (@sidbStoreFlags & (67108864|268435456)) = 67108864
		begin
set @o_ErrorCode = 20122
			update RMDataPathView
set	FailureErrorCode = @o_ErrorCode, FailureType = 1
			where FailureErrorCode = 0
			set @NumDataPathViews = 0
set @o_FailureType = 1
			GOTO EXIT_AND_RETURN
		end
		-- If that resiliency flag set, then honour the # in archTask table. Instead of making the job wait when ALL partitions are offline, make it wait when archtask value # of partitions are offline.
		-- If the flag is not set, then prevent backup even if only on substore is corrupted.
		-- All the following checks only apply when there is DDB store offline or corrupted. Any other conditions we may add later should not be put into the following block,
		-- if it is not for DDB offline or corrupted cases.
		if @allowDeDupJobsWhenDDBCorrupted = 0
		begin
if (@dedupeFlags & 67108864 > 0)
			begin
set @o_ErrorCode = 20066
			end
else if (@dedupeFlags & 33554432 > 0)
			begin
set @o_ErrorCode = 20067
			end
			else
			begin
set @o_ErrorCode = 20082
			end
			-- if recon validatation fails for the store then set different error code.
if exists ( select 1 from IdxSIDBSubStore with (readuncommitted) where SIDBStoreId = @i_SIDBStoreId and (flags & 4194304) > 0 )
			begin
set @o_ErrorCode = 20120
			end
if (@dedupeFlags & 8 > 0) and @sidbCorruptLimit > 0
			begin
				-- Number of currpted substore exceeds the option, prevent backup
				if exists
				(
					select idxss.SIDBStoreId
					from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
							IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted)
					where idxss.SIDBStoreId = @i_SIDBStoreId
					and		idxss.ClientId = host.ClientId
					and		idxss.IdxCacheId = idxc.IdxCacheId
					and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
					-- not corrupted
					and	(
(idxss.Status = 1)
					-- ddb move is not running ( all the comments here say inverse of what it checks)
OR (idxss.Flags & 1024 = 1024)
					-- Media Agent online
						OR (
								( host.mmhostsoftstate = 0 AND
									(  host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR
									/* Treat the MA is offline if it is not power vm and softstate is 0.
									   If MA is power vm then assume it is offline if vm power on req is failed after 3 retries by MM */
										(
											host.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND
												EXISTS ( SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK) INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON
																	VM.RequestId = VMMAP.RequestId
WHERE VM.HostId = host.ClientId AND VM.FailureReason = 2 AND VMMAP.EntityId = @i_JobId AND VMMAP.EntityType = 1 )
										)
										OR @isPowerVMFeatureEnabled = 0
									 )
								) OR host.mmhostenabled = 0
							)
					-- Index Cache online
						OR (idxc.Enabled = 0 OR idxc.SoftState = 0)
					-- Access Path online and enabled
						OR (idxa.Enabled = 0 OR idxa.SoftState = 0)
						)
					group by idxss.SIDBStoreId
					having Count (distinct idxss.SubStoreId) > @sidbcorruptlimit
				)
				begin
					update	RMDataPathView
					set			FailureErrorCode = @o_ErrorCode,
FailureType = 1
					where		FailureErrorCode = 0
					set @NumDataPathViews = 0
set @o_FailureType = 1
					GOTO EXIT_AND_RETURN
				end
			end
			else
			begin
				-- if no resiliency and any of the substores is not usable, then fail the job
				if exists (select idxss.subStoreId
						from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
								IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted)
						where idxss.SIDBStoreId = @i_SIDBStoreId
						and		idxss.ClientId = host.ClientId
						and		idxss.IdxCacheId = idxc.IdxCacheId
						and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
						-- not corrupted
						and	(
(idxss.Status = 1)
						-- ddb move is not running ( all the comments here say inverse of what it checks)
OR (idxss.Flags & 1024 = 1024)
						-- Media Agent online
OR ((host.mmhostsoftstate = 0 AND ( host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR @isPowerVMFeatureEnabled = 0)) OR host.mmhostenabled = 0  OR ((host.Attribute & 16) > 0))
						-- Index Cache online
							OR (idxc.Enabled = 0 OR idxc.SoftState = 0)
						-- Access Path online
							OR (idxa.Enabled = 0 OR idxa.SoftState = 0)
							)
							)
				begin
					update	RMDataPathView
					set			FailureErrorCode = @o_ErrorCode,
FailureType = 1
					where		FailureErrorCode = 0
					set @NumDataPathViews = 0
set @o_FailureType = 1
					GOTO EXIT_AND_RETURN
				end
			end
set @o_ErrorCode = 0
			-- In all cases, if there is no available substores with online Media Agent, Index Cache and Access Path, then fail the job
			if not exists
			(
				select idxss.subStoreId
						from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
								IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted)
						where idxss.SIDBStoreId = @i_SIDBStoreId
						-- not corrupted
and		idxss.Status != 1
						-- ddb move is not running
and 		(idxss.Flags & 1024 = 0)
						-- Media Agent online
				and		idxss.ClientId = host.ClientId
				and		(( host.mmhostsoftstate > 0 OR (host.mmhostsoftstate = 0 AND host.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND @isPowerVMFeatureEnabled > 0 )) and host.mmhostenabled > 0)
						-- Index Cache online
				and		idxss.IdxCacheId = idxc.IdxCacheId
				and		( idxc.Enabled > 0 and idxc.SoftState > 0)
						-- Access Path online
				and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
				and		(idxa.Enabled > 0 and idxa.SoftState > 0)
					)
			begin
set @o_ErrorCode = 20109
				update	RMDataPathView
				set			FailureErrorCode = @o_ErrorCode,
FailureType = 1
				where		FailureErrorCode = 0
				set @NumDataPathViews = 0
set @o_FailureType = 1
				GOTO EXIT_AND_RETURN
			end
		end -- end if @allowDeDupJobsWhenDDBCorrupted = 0
	end -- end if dedupeDisabled = 0
  end
	-----------------------------------------------------------
  -- Filter: Prevent SI job if the SIDB is not accessable	 --
  -----------------------------------------------------------
	--------------------------------------------
	 -- Filter: NAS Reservation Number Filter --
	--------------------------------------------
	-- cliu, Feb 5, 2009
	-- The setting on how many reservations are allowed for one NAS Filer
	declare @checkMaxReservationOfNASFiler int
	select @checkMaxReservationOfNASFiler = isnull(value, 0)
	from MMConfigs WITH (READUNCOMMITTED)
	where name = 'MMS2_CONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_DRIVES_PER_NASFILER'
	if @checkMaxReservationOfNASFiler > 0
	begin
		declare @drivepoolOfNASFiler table ( drivepoolId integer, clientId integer, NDMPHostId integer )
		insert	into @drivePoolOfNASFiler
		select	a.drivepoolid, b.clientId, b.NDMPHostId
		from 		RMDataPathView a, MMDrivePool b with (readuncommitted)
		where		a.drivepoolid = b.drivepoolid
		and			b.drivepooltype = 3 -- CV_DRIVEPOOL_NAS
		and			a.FailureErrorCode = 0
		if (@@rowcount > 0)
		begin
			delete @drivePoolOfNASFiler
			where NDMPHostId not in
			(
				select a.NDMPHostId
				from @drivePoolOfNASFiler a, MMDrivePool b with (readuncommitted), MMResource c
				where a.NDMPHostId = b.NDMPHostId and b.drivepoolid = c.drivepoolid
				group by a.NDMPHostId
				having count(distinct c.driveId) >= @checkMaxReservationOfNASFiler
			)
			update	RMDataPathView
set			FailureErrorCode = 20056,
FailureType = 2
			where		FailureErrorCode = 0
			and			DrivePoolId in (select DrivePoolId from @drivePoolOfNASFiler)
			select @NumDataPathViews = @NumDataPathViews - @@rowcount
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20056
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			end
		end
	end
  ---------------------------------------------------
  -- End of Filter: NAS Reservation Number Filter  --
  ---------------------------------------------------
  -------------------------------------
  -- Filter: isForRemainingStreams	 --
  -------------------------------------
if @i_isForRemainingStreams > 0  and @i_ReservationType = 2
  and exists (select * from MMResourceToJob where JobId_l = @i_JobId)
  begin
	  update	RMDataPathView
set			FailureErrorCode = CASE WHEN @i_IsForSILOBackup = 0 THEN 20034 ELSE 20112 END,
FailureType = 2
	  where		FailureErrorCode = 0
	  and			DrivePoolId > 0
	  and 		DrivePoolId not in (select distinct DrivePoolId from MMResource a, MMResourceToJob b
	  														where a.ReservationId = b.ReservationId and b.JobId_l = @i_JobId)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 20034
set @o_FailureType = 2
		  GOTO EXIT_AND_RETURN
		end
  end
	  ---------------------------------------------------
	  -- Filter: Media Agent and Client Version Check  --
	  ---------------------------------------------------
	-- NOTICE: For inline copy, the passing-in client should be the Media Agent resered by the primary copy
	--				 For Parallel AuxCopy, the passing-in client should be the one reserved by the source stream.
	-- TODO: check for content indexing job between source media agent and content indexing server versions.
	IF @i_inClientId > 0
	BEGIN
		DECLARE @clientRelId int
		DECLARE @mediaAgentRelId int
		SELECT @clientRelId = ReleaseId FROM App_Client with (readuncommitted) WHERE Id = @i_inClientId
		SET @mediaAgentRelId = (CASE WHEN @i_MAClientId > 0 THEN (SELECT ReleaseId FROM App_Client with (readuncommitted) WHERE Id = @i_MAClientId) ELSE @clientRelId END)
		-- If Job is AuxCopy backup, the clients' version have to match
		-- MR 108886, adding support for using 9.0 source Media Agent and 10.0 destination Media Agent
		-- Only case we don't support is when 10.0 is using multiple split for DDB store.
		-- And we don't support from 10.0 source MediaAgent to 9.0 destination Media agent.
		-- Refer the code for non silo job. http:--ncvs/source/xref/10.0-win/vaultcx/Source/CommServer/Db/Sp/RMDataPathStatusFilters.sp#270
		IF @i_JobType = @AUXCOPYJOB
		BEGIN
			UPDATE	DPView
SET		FailureErrorCode = 20042,
FailureType = 2
			FROM	RMDataPathView DPView, App_Client CN WITH (READUNCOMMITTED)
			WHERE	DPView.FailureErrorCode = 0
			AND		DPView.HostClientId = CN.id
			AND		(
						--Source version > destination version
						@mediaAgentRelId /*Source Media Agent Version*/ > CN.ReleaseId
						OR
						-- Destination uses multiple split, and source verion < destination version and source is v9 and dest is v10 or later
						@i_SIDBStoreId > 0
						AND EXISTS (SELECT 1 FROM IdxSIDBSubStore substore with (readuncommitted)
							WHERE       @i_SIDBStoreId = substore.SIDBStoreId
							GROUP BY substore.SIDBStoreId
							HAVING COUNT(substore.SubStoreId) > 1)
						AND @mediaAgentRelId < CN.ReleaseId
						AND @mediaAgentRelId <= 14 /*v9*/ AND CN.ReleaseId > 14 /*v10 and above*/
					)
			select @NumDataPathViews = @NumDataPathViews - @@rowcount
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20042
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			end
		END
		-- For backup job, if MA is newer than the client and client version is before 7.0,
		-- check if SDT is enabled on the MA, if so, fail
		IF @i_JobType = @BKPJOB AND @clientRelId < 12 /*SIM_ID_GX_REL70*/
		BEGIN
			UPDATE	RMDataPathView
SET			FailureErrorCode = 20039,
FailureType = 2
			FROM		RMDataPathView a, MMHost h WITH (READUNCOMMITTED)
			WHERE		a.FailureErrorCode = 0
			AND			@clientRelId < (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = a.HostClientId)
			AND			a.HostClientId = h.ClientId
AND			(h.Attribute & 32) > 0
			select @NumDataPathViews = @NumDataPathViews - @@rowcount
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20039
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			end
		END
		-- cliu 03/14/2013, MR 87005, Silo backup with MA at earlier release than client should go to waiting, not fail.
		-- For SILO backup, the inline client is the media agent from source copy DDB. We need to make sure such DDB MA is compatible with SILO MA.
		-- It requires the media agents are from the same release.
		IF @i_IsForSILOBackup > 0
		BEGIN
			-- media agent version has to be the same or newer than client
			UPDATE	RMDataPathView
SET			FailureErrorCode = 20012,
FailureType = 2
			WHERE		FailureErrorCode = 0
			AND			@clientRelId > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
			select @NumDataPathViews = @NumDataPathViews - @@rowcount
			if @NumDataPathViews = 0
			begin
set @o_ErrorCode = 20012
set @o_FailureType = 2
			  GOTO EXIT_AND_RETURN
			end
		END
		DECLARE @nas_proxy_defined Integer = 0
		IF @i_AppNum > 0 AND @i_JobType != @AUXCOPYJOB
		BEGIN
			IF EXISTS (SELECT 1 FROM APP_Client client WITH (NOLOCK), APP_Application app WITH (NOLOCK)
						WHERE app.Id = @i_AppNum AND app.ClientId = client.Id
AND		(client.Status & 0x0080) > 0
					)
			BEGIN
				SET @nas_proxy_defined = 1
			END
		END
		-- If the client version is greater than the media agent version, do the following check
		IF EXISTS (SELECT HostClientId FROM RMDataPathView
								WHERE	FailureErrorCode = 0
								AND		@clientRelId > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
								)
		-- For NAS client, always support even the clients' version doesn't match, allow job continue
AND (@i_AppType <> 13 AND @i_AppType <> 88)
		AND @nas_proxy_defined = 0
		BEGIN
			DECLARE @xmlParams XML
			SELECT @xmlParams = RegistrySetting FROM RMReservationRequest WHERE RequestId = @i_RequestId
			DECLARE @ignoreAuxCopyVersionCheck	INT
			DECLARE @ignoreBackupVersionCheck		INT
			DECLARE @ignoreRestoreVersionCheck	INT
			SET @ignoreAuxCopyVersionCheck = 0
			SET @ignoreBackupVersionCheck = 0
			SET @ignoreRestoreVersionCheck = 0
			IF @i_JobType = @AUXCOPYJOB
				SELECT	@ignoreAuxCopyVersionCheck			= params.value('@ignoreAuxCopyVersionCheck', 'int'),
								@ignoreBackupVersionCheck				= params.value('@ignoreBackupVersionCheck', 'int'),
								@ignoreRestoreVersionCheck			= params.value('@ignoreRestoreVersionCheck', 'int')
				FROM		@xmlParams.nodes('/ResourceManager_RmRegistrySetting_t[1]') AS R(params)
			ELSE
				SELECT	@ignoreAuxCopyVersionCheck			= params.value('@ignoreAuxCopyVersionCheck', 'int'),
								@ignoreBackupVersionCheck				= params.value('@ignoreBackupVersionCheck', 'int'),
								@ignoreRestoreVersionCheck			= params.value('@ignoreRestoreVersionCheck', 'int')
				FROM		@xmlParams.nodes('/ResourceManager_RmRegistrySetting_t[1]') AS R(params)
			IF @i_JobType = @AUXCOPYJOB
			BEGIN
				UPDATE	RMDataPathView
SET			FailureErrorCode = 20015,
FailureType = 2
				WHERE		FailureErrorCode = 0
				AND			@ignoreAuxCopyVersionCheck = 0
				AND			@clientRelId /*Source MA version*/ < (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 20015
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				end
			END
			IF @i_JobType = @BKPJOB OR @i_JobType = @CSDRBKPJOB
			BEGIN
				UPDATE	RMDataPathView
SET			FailureErrorCode = 20012,
FailureType = 2
				WHERE		FailureErrorCode = 0
				AND			@ignoreBackupVersionCheck = 0
				AND			@clientRelId > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 20012
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				end
			END
			IF @i_JobType = @RSTJOB OR @i_JobType = @INDRSTJOB
			BEGIN
				-- Backward compatibility support when media agent is one release earlier than client, starting from release 11.0
				IF @clientRelId >= 16 /*release 11.0*/
				BEGIN
					UPDATE	RMDataPathView
SET			FailureErrorCode = 20012,
FailureType = 2
					WHERE		FailureErrorCode = 0
					AND			@ignoreRestoreVersionCheck = 0
					AND			(@clientRelId - 1) > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
				END
				ELSE
				BEGIN
					UPDATE	RMDataPathView
SET			FailureErrorCode = 20012,
FailureType = 2
					WHERE		FailureErrorCode = 0
					AND			@ignoreRestoreVersionCheck = 0
					AND			@clientRelId > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
				END
				select @NumDataPathViews = @NumDataPathViews - @@rowcount
				if @NumDataPathViews = 0
				begin
set @o_ErrorCode = 20012
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				end
			END
		END
	END
	-- cliu 3/14/2013
	-- MR 90584, Backward compatability : 10 CS and 9.0 MA : Erase data by browse should not succeed when all the datapaths of a storage policy are 9.0.
	-- When doing such job, the index is always done through Commserver later regardless the passing client id in the parameters.
	-- Therefore, we need to make sure the job cannot continue if there is no MA compatible with Commserver version.
	IF @jobOpType = @SELECTIVEDELETE OR @jobOpType = @BROWSEANDDELETE
	BEGIN
		DECLARE @commcellRelId INT
		SELECT @commcellRelId = ReleaseId FROM App_Client with (readuncommitted) WHERE Id = 2 /*CommServer only*/
		-- media agent version has to be the same or newer than client
		UPDATE	RMDataPathView
SET			FailureErrorCode = 20012,
FailureType = 2
		WHERE		FailureErrorCode = 0
		AND			@commcellRelId > (SELECT ISNULL(ReleaseId, 0) FROM APP_Client with (readuncommitted) WHERE Id = HostClientId)
		select @NumDataPathViews = @NumDataPathViews - @@rowcount
		if @NumDataPathViews = 0
		begin
set @o_ErrorCode = 20012
set @o_FailureType = 2
		  GOTO EXIT_AND_RETURN
		end
	END
	  ----------------------------------------------------------
	  -- End of Filter: Media Agent and Client Version Check  --
	  ----------------------------------------------------------
  	  ---------------------------------------------------
	  -- Filter: Check the availablity of library server
	  ---------------------------------------------------
	--	DECLARE	@CV_LIBSUBTYPE_LIBRARY_SERVER	INTEGER
	--	SET			@CV_LIBSUBTYPE_LIBRARY_SERVER	= 3
	-- If previous request for library server returns no drive available,
	-- put the library server as the last datapath for current reservation.
	if exists ( select dp.libraryId
				from RMDataPathView dp, MMLibrary lib with (readuncommitted)
				where	FailureErrorCode = 0
				and		dp.libraryId = lib.LibraryId
				and		lib.LibrarySubType = 3 /*CV_LIBSUBTYPE_LIBRARY_SERVER*/
			)
	begin
		declare @maxPriority int
		select @maxPriority = max(Precedence) + 1 from RMDataPathView
		UPDATE	RMDataPathView
		SET		Precedence = @maxPriority + Precedence
		WHERE	NOT EXISTS (
					SELECT	RequestId
					FROM	MMSharedDriveAllocation with (readuncommitted)
					WHERE	JobId = @i_jobId
					AND		CommcellId = 2
					AND		RMDataPathView.LibraryId = LibraryId
AND		RequestStatus IN (1, 4)
				)
		AND		EXISTS (
					SELECT	RequestId
					FROM	MMSharedDriveAllocation with (readuncommitted)
					WHERE	JobId = @i_jobId
					AND		CommcellId = 2
					AND		RMDataPathView.LibraryId = LibraryId
AND		RequestStatus IN (3)
					AND		LastModifiedTime <= ((datediff(second,'01/01/1970', getutcdate()) - 5 * 60))
				)
	end
	-- If this is DDB recontruction job and reservation type is read,
	-- we need to make sure the to-be-reconstructed DDB has online indexcache and index accesspath
	-- Refer to MR 90230 for more details
if @i_ReservationType = 1
	and @jobOpType = @DEDUPDBSYNC
	begin
		-- Lookup to-be-reconstructed DDB substore list
		declare @xmlmsg xml
		declare @subStoreIdList table (subStoreId int)
		set @xmlmsg = ''
		select @xmlmsg = (dbo.GetJobOption(@i_jobId, 34449693)) -- DEDUPDBSYNCOPTION__SUB_STORE_ID_LIST
		insert into @subStoreIdList
		select p.value('@val', 'int') from @xmlmsg.nodes('/SubStoreIdList') as R (p)
		if exists (select * from @subStoreIdList)
		begin
			-- check index cache offline for any reason
			if exists (select idxc.IdxCacheId from IdxCache idxc with (readuncommitted), IdxSIDBSubStore idxsubstore with (readuncommitted), @subStoreIdList storeId
										where storeId.subStoreId = idxsubstore.SubStoreId
										and		idxsubstore.IdxCacheId = idxc.IdxCacheId
										and		( idxc.Enabled <> 1 or idxc.SoftState <> 1))
			begin
				update	RMDataPathView
set			FailureErrorCode = 20074,
FailureType = 1
				where		FailureErrorCode = 0
				set @NumDataPathViews = 0
set @o_ErrorCode = 20074
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			end
			-- check index access path offline for any reason
			if exists (select idxa.IdxAccessPathId from IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxsubstore with (readuncommitted), @subStoreIdList storeId
										where storeId.subStoreId = idxsubstore.SubStoreId
										and		idxsubstore.IdxAccessPathId = idxa.IdxAccessPathId
										and		( idxa.Enabled <> 1 or idxa.SoftState <> 1)
										and 	idxa.OfflineReason <> 3) --IDXACCPATH_PATH_DOES_NOT_EXIST-- recon can be run if whole path does not exist
			begin
				update	RMDataPathView
set			FailureErrorCode = 20073,
FailureType = 1
				where		FailureErrorCode = 0
				set @NumDataPathViews = 0
set @o_ErrorCode = 20073
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			end
		end
	end
if @i_ReservationType = 1
	and @jobOpType in ( @ARCHIVECHECK, @ARCHIVECHECK2 )
	--In JMAdminJobInfoTable table if cloudid column is greater than 0 means it is DDB verification job.
	and exists (select 1 from JMAdminJobInfoTable with (NOLOCK) where jobId = @i_JobId and cloudId > 0)
	begin
		set @i_currentSIDBStoreId = 0
		select @i_currentSIDBStoreId = cloudId from JMAdminJobInfoTable with (nolock)
		where jobId = @i_JobId
		if @i_currentSIDBStoreId = 0 and @i_CopyId > 0
		begin
			select @i_currentSIDBStoreId = @i_SIDBStoreId
		end
		if @i_currentSIDBStoreId > 0
		begin
			if exists
			(
				select idxss.subStoreId
						from	MMHost host with (readuncommitted), IdxCache idxc with (readuncommitted),
								IdxAccessPath idxa with (readuncommitted), IdxSIDBSubStore idxss with (readuncommitted),
								IdxSIDBStore sidb with (readuncommitted)
						where 	sidb.SIDBStoreId = @i_currentSIDBStoreId
						and		idxss.SIDBStoreId = sidb.SIDBStoreId
						and		idxss.CommCellId = sidb.CommCellId
				and		idxss.ClientId = host.ClientId
				and		idxss.IdxCacheId = idxc.IdxCacheId
				and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
				and		(
-- idxss.Status != 1 or
							-- ddb move is not running ( all the comments here say inverse of what it checks) dont allow ddb verification while partition is being moved
(idxss.Flags & 1024 = 1024)
							or
							-- Media Agent online
							(	host.mmhostsoftstate = 0 AND
									(  host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR
									/* Consider the MA as offline, only if it is not power vm and softstate is 0 and also
									   if MA is power vm then assume it as offline if power on req is failed even after 3 retries by MM */
										(
											host.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND
											EXISTS( SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
															INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
WHERE VM.HostId = host.ClientId AND VM.FailureReason = 2 AND VMMAP.EntityId = @i_JobId AND VMMAP.EntityType = 1
												  )
										)
										OR @isPowerVMFeatureEnabled = 0
									 )	or host.mmhostenabled = 0
							)
							or
							-- Index Cache online
							(idxc.Enabled = 0 or idxc.SoftState = 0)
							or
							-- Access Path online
							(idxa.Enabled = 0 or idxa.SoftState = 0)
						)
			)
			begin
set @o_ErrorCode = 20109
					update	RMDataPathView
					set			FailureErrorCode = @o_ErrorCode,
FailureType = 1
					where		FailureErrorCode = 0
					set @NumDataPathViews = 0
set @o_FailureType = 1
					GOTO EXIT_AND_RETURN
			end
		end
	end
EXIT_AND_RETURN:
if @NumDataPathViews > 0
set @o_ErrorCode = 0
/*
if @isDebug > 0
begin
	set @debugDetail = cast(isnull((select DataPathId, FailureErrorCode	from RMDataPathView where FailureErrorCode > 0
																	for XML RAW('UnavailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	set @debugDetail = cast(isnull((select DataPathId, Priority, DrivePoolId, HostClientId, LibraryId, MasterPoolId, SpareGroupId
																	from RMDataPathView where FailureErrorCode = 0
																	for XML RAW('AvailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
end
*/
-- select * from RMDataPathView where FailureErrorCode = 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMDataPathStatusFilters')
	delete from GxQscripts where name = 'RMDataPathStatusFilters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMDataPathStatusFilters')
	delete from GXDBVersions where aliasname = 'RMDataPathStatusFilters'
GO

insert into GXDBVersions values(2, 'RMDataPathStatusFilters',  '00010079000200370000', 'RMDataPathStatusFilters', '00010079000200370000')
GO

