

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMDataPathAdditionalFilter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMDataPathAdditionalFilter.sp,v $ $Id: RMDataPathAdditionalFilter.sp,v 1.14.14.14 2020/04/05 19:25:14 anarulkar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMDataPathAdditionalFilter()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMDataPathAdditionalFilter')
BEGIN
	print '>>> Drop Stored Procedure: RMDataPathAdditionalFilter <<<'
	drop procedure RMDataPathAdditionalFilter
END
IF EXISTS (select * from GxQscripts where name='RMDataPathAdditionalFilter')
	delete from GxQscripts where name = 'RMDataPathAdditionalFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMDataPathAdditionalFilter')
	delete from GXDBVersions where aliasname = 'RMDataPathAdditionalFilter'
GO
print '... Creating Procedure: RMDataPathAdditionalFilter'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMDataPathAdditionalFilter
  @i_RequestId int,
  @i_ReservationType int,
  @i_JobId int,
  @i_numStreams int,
  @i_bestcaseReserve int,
  @i_dataMultiStream int,
  @i_MuxFactor int,
  @i_extraRestoreDrive int,
  @i_extraRestoreDrivePoolId int,
  @i_CopyId int,
  @i_SIDBStoreId int,
  @i_appNum int,
  @i_isTransactionLogBackupPhase int,
  @isDebug int,
  @o_ErrorCode integer OUTPUT,
  @o_FailureType integer OUTPUT
AS
--:DECLARE o_ErrorCode			integer;
--:DECLARE o_FailureType			integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	--set @o_FailureType = RM_FAILURE_SP
  declare @BKPJOB int
  declare @RSTJOB	int
  declare @CSDRBKPJOB int
	declare @INDRSTJOB	int
  declare @AUXCOPYJOB int
  declare @SYNTHFULLJOB int
  set @BKPJOB = 1
  set @RSTJOB = 2
  set @CSDRBKPJOB = 4
  set @INDRSTJOB = 5
  set @AUXCOPYJOB = 6
  set @SYNTHFULLJOB = 7
	declare @DRIVEVALIDATION integer
	declare @DRIVECLEANING integer
	declare @STAMPMEDIA integer
	set @DRIVEVALIDATION = 41
	set @DRIVECLEANING = 42
	set @STAMPMEDIA = 46
	declare @isMaintenanceJob int
	declare @jobOpType int
	set @isMaintenanceJob = 0
  set @jobOpType = dbo.GetJobTypeForJobID(@i_JobId)
  if @jobOpType = @DRIVEVALIDATION or @jobOpType = @DRIVECLEANING or @jobOpType = @STAMPMEDIA
    set @isMaintenanceJob = 1
	declare @o_perferredDataPathForCopy	integer
	declare @NumDataPathViews int
	select @NumDataPathViews = count(*) from RMDataPathView where FailureErrorCode = 0
	DECLARE @l_numStreams INT = (case when @i_bestcaseReserve = 1 then 1 else @i_numStreams end)
	declare @debugDetail varchar(max)
	set	@debugDetail = ''
	/*
	if @isDebug > 0
	begin
		insert into RMLogger values ('RMGetDataPathView', 'Enter...', @i_RequestId, getutcdate())
		set @debugDetail = cast(isnull((select @i_CopyId copyId, @i_JobId jobId, @i_JobType jobType, @i_AppNum appNum, @i_AppType appType,
																	@i_DataType dataType, @i_BkpLevel bkpLevel, @i_IsForRemainingStreams isForRemainingStreams,
																	@i_UseSCDataPath useSCDataPath, @i_UsePreferredDP usePreferredDP, @i_IsForSILOBackup isForSILOBackup, @i_inClientId inClientId,
																	@i_addtionalFilter additionalFilter
															for XML RAW('Parameters'), TYPE), 'NULL') as varchar(max))
		insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	end
	*/
ADDITIONAL_FILTER:
	-- The above are the either configuration or hardware problem. We cannot do anything about it.
	-- The following check are the checking based on current reservation. We may need to interruption if data path is not available.
  -----------------------------------
  -- Filter: max reservation on MA --
  -----------------------------------
	if @i_numStreams > 1 AND @i_bestcaseReserve = 0
  begin
	  update RMDataPathView
set			FailureErrorCode = 330,
FailureType = 2
	  where		FailureErrorCode = 0
	  and			(
	  					MaxReservations = 0
	  					or
	  					(
		  					MaxReservations > 0
								and			((select count(*) from MMResourceToJob with (readuncommitted)
where (ReservationType & 2) = 2
													and	ReservationId in (select ReservationId from MMResource with (readuncommitted)
																									where ClientId = RMDataPathView.HostClientId))
												+ @i_numStreams)
												> MaxReservations
							)
						)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 330
set @o_FailureType = 2
	    GOTO EXIT_AND_RETURN
	  end
	end
	else if @i_numStreams > 0
	begin
	  update RMDataPathView
set			FailureErrorCode = 330,
FailureType = 2
	  where		FailureErrorCode = 0
	  and			(
	  					MaxReservations = 0
	  					or
	  					(
		  					MaxReservations > 0
								and			MaxReservations <= (select count(*) from MMResourceToJob with (readuncommitted)
where (ReservationType & 2) = 2
																	and ReservationId in (select ReservationId from MMResource with (readuncommitted)
																										where ClientId = RMDataPathView.HostClientId))
							)
						)
	  select @NumDataPathViews = @NumDataPathViews - @@rowcount
	  if @NumDataPathViews = 0
	  begin
set @o_ErrorCode = 330
set @o_FailureType = 2
	    GOTO EXIT_AND_RETURN
	  end
	end
  ------------------------------------------
  -- End of Filter: max reservation on MA --
  ------------------------------------------
  -----------------------------------
  -- Filter: max streams on Client --
  -----------------------------------
	DECLARE @l_MaxStreamsOnClient INT = 0
	DECLARE @l_appClientId INT = 0
	SELECT 	@l_appClientId = clientId
	FROM	App_Application WITH(READUNCOMMITTED)
	WHERE	id = @i_appNum
	SELECT 	@l_MaxStreamsOnClient = CAST(attrVal as INT)
	FROM	App_ClientProp WITH(READUNCOMMITTED)
	WHERE	componentNameId = @l_appClientId AND attrName = N'MaxStreams'
	IF @l_MaxStreamsOnClient > 0
	BEGIN
		DECLARE @l_CurrentStreamsOnClient INT = 0
		SELECT 	@l_CurrentStreamsOnClient = count(distinct RCId)
		FROM	MMResourceToJob RJ WITH(READUNCOMMITTED),
				MMResource R WITH(READUNCOMMITTED),
				JMBkpJobInfo J WITH(READUNCOMMITTED),
				App_Application A WITH(READUNCOMMITTED)
		WHERE	RJ.ReservationId = R.ReservationId
				AND R.IntrJobId_l = 0
AND	(R.ReservationType & 2) = 2
				AND RJ.JobId_l = J.jobId AND J.commCellId = 2
				AND J.applicationId = A.id
				AND A.clientId = @l_appClientId
		IF (@l_CurrentStreamsOnClient + @l_numStreams) > @l_MaxStreamsOnClient
		BEGIN
		  update RMDataPathView
set	FailureErrorCode = 349,
FailureType = 2,
				interruptibleDrives = 0,
				interruptibleStreams = 0
		  set @NumDataPathViews = 0
set @o_ErrorCode = 349
set @o_FailureType = 2
		  GOTO EXIT_AND_RETURN
		END
	END
  ------------------------------------------
  -- End of Filter: max streams on Client --
  ------------------------------------------
  ----------------------------------------------------------------------
  /* MR 87209, Max # of parallel data transfer option for DDB
	The limit is to allow only certain number of connection to the active DDB at any given time.
*/
  ----------------------------------------------------------------------
	if @i_CopyId > 0 and @i_SIDBStoreId > 0
		--dedupe is not disabled on subclient
		and (@i_appNum = 0 OR NOT EXISTS ( select 1 from APP_SubClientProp prop with (readuncommitted), App_Application app with (readuncommitted)
                            where app.Id = @i_appNum and app.Id = prop.ComponentNameId
                            and prop.cs_attrName = CheckSum(N'Single Instancing Option')
							and prop.attrName = N'Single Instancing Option' and prop.attrVal = '0' and prop.Modified = 0)
			)
		--dedupe is not disabled on copy
and NOT EXISTS (select 1 from archGroupCopy with (readuncommitted) where id = @i_CopyId and (dedupeFlags & 1048576) > 0)
		--allow dedupe jobs when DDB in maintenance config param is not set
		and NOT EXISTS (select 1 from MMConfigs WITH (READUNCOMMITTED) where name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_BACKUP_DURING_DDB_RECONSTRUCTION' and value = 1)
		--not transactional log backup
		and @i_isTransactionLogBackupPhase = 0
	begin
		declare @maxSIDBReservationOnCopy int
		set @maxSIDBReservationOnCopy = 0
		DECLARE @lt_CopyList TABLE (copyId int)
		INSERT INTO @lt_CopyList
		SELECT 	copyId
		FROM 	ArchCopySIDBStore WITH (READUNCOMMITTED)
		WHERE 	SIDBStoreId = @i_SIDBStoreId
		--Get total number of streams reserved on store including all dependent copies in case of GDSP.
		select @maxSIDBReservationOnCopy = count (distinct a.reservationId)
		from
		(
			select ReservationId, StreamId, CopyId from MMResource with (readuncommitted)
			where 	IntrJobId_l = 0
and		(ReservationType & 2) = 2
			and		StreamId > 0 AND SIDBStoreId > 0
		) a inner join @lt_CopyList c on a.CopyId = c.CopyId
		left join
		(
			select Stream, ArchGroupCopyId from ArchStream with (readuncommitted)
where  Flags & 1 = 0
		 ) b
		 on a.StreamId = b.Stream and c.CopyId = b.ArchGroupCopyId
		where b.Stream is not null
		-- If there is no reservation on the given DDB and copy, skip the check
		--if @maxSIDBReservationOnCopy > 0
		begin
			-- If we reach this point and there is no active DDB substore available, then, job must run as regular backup.
			-- Skip the check in this case.
			declare @subStoreMAList table (MediaAgentId int)
			insert into @subStoreMAList
			select distinct idxss.ClientId
			from	IdxSIDBSubStore idxss with (readuncommitted),
					MMHost host with (readuncommitted),
					IdxCache idxc with (readuncommitted),
					IdxAccessPath idxa with (readuncommitted)
			where	idxss.SIDBStoreId = @i_SIDBStoreId
					-- not corrupted
and		idxss.Status != 1
					-- ddb move is not running
and 		(idxss.Flags & 1024 = 0)
					-- Media Agent online
			and		idxss.ClientId = host.ClientId
			and		(host.mmhostsoftstate > 0 and host.mmhostenabled > 0)
					-- Index Cache online
			and		idxss.IdxCacheId = idxc.IdxCacheId
			and		( idxc.Enabled > 0 and idxc.SoftState > 0)
					-- Access Path online
			and		idxss.IdxAccessPathId = idxa.IdxAccessPathId
			and		(idxa.Enabled > 0 and idxa.SoftState > 0)
			if exists (select * from @subStoreMAList)
			begin
				declare @checkMaxReservationOfDDBConn int
				set @checkMaxReservationOfDDBConn = 0
				SELECT 	@checkMaxReservationOfDDBConn = ISNULL(MaxAllowedConnections, 0)
				FROM 	IdxSIDBStore WITH (READUNCOMMITTED)
				WHERE 	SIDBStoreId = @i_SIDBStoreId
				IF @checkMaxReservationOfDDBConn = 0
				BEGIN
					select @checkMaxReservationOfDDBConn = isnull(value, 0)
					from MMConfigs WITH (READUNCOMMITTED)
					where name = 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB'
				END
				if @checkMaxReservationOfDDBConn > 0 and
					(
						(@i_bestcaseReserve = 0 and (@maxSIDBReservationOnCopy + @i_numStreams) > @checkMaxReservationOfDDBConn)
						or (@i_bestcaseReserve = 1 and (@maxSIDBReservationOnCopy + 1) > @checkMaxReservationOfDDBConn)
					)
				begin
				  update RMDataPathView
set			FailureErrorCode = 20118,
FailureType = 1,
								RemainingMx = 0,
								interruptibleDrives = 0,
								interruptibleStreams = 0
				  -- Set all the datapath with the same error in this case to prevent additional reservation attempts on the copy
				  --where		FailureErrorCode = 0
				  set @NumDataPathViews = 0
set @o_ErrorCode = 20118
set @o_FailureType = 1
				  GOTO EXIT_AND_RETURN
				end
			end
		end
	end
  ----------------------------------------------------------------------
  -- End of Filter: Limit the number of ddbs running concurrenlty per MA 		--
  ----------------------------------------------------------------------
  -----------------------------------------------
  -- Filter: number of streams required by job --
  -----------------------------------------------
	-- The case of @i_numStream = 1 has already been checked in stored procedure RMGetDriveView
  if @i_numStreams > 1 AND @i_bestcaseReserve = 0
  begin
		DECLARE @DriveInActionList	TABLE ( DriveId int, MasterPoolId int)
		INSERT INTO @DriveInActionList
    SELECT DISTINCT R.DriveId, D.MasterPoolId
    FROM MMResource AS R with (readuncommitted), MMDrive AS D WITH (READUNCOMMITTED)
   	WHERE R.DriveId = D.DriveId
   	AND 	((R.MediaId != D.MediaId) OR
(D.MountStatus in (2, 3)))
		-- this is a rare case @numStreams > 1 AND @bestcaseReserve = 0
		-- delete drive pools that don't have enough drives or media to support such case
		if @i_dataMultiStream = 0
		begin
			-- no mx
			UPDATE RMDataPathView
SET		FailureErrorCode = 20022,
FailureType = 2
			WHERE	FailureErrorCode = 0
			AND		SpareGroupId > 0
			AND		(NonReservedDriveCount + RemainingMx) < @i_numStreams
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
	  	if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20022
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
		  ---------------------------------------------------
		  -- Filter: check for total drives in the master pool --
		  ---------------------------------------------------
			update	RMDataPathView
set			FailureErrorCode = 279,
FailureType = 2
			from		RMDataPathView a, MMMasterPool mp with (readuncommitted)
			where		a.FailureErrorCode = 0
			and			a.MasterPoolId > 0
			and			a.MasterPoolId = mp.MasterPoolId
			and			@i_numStreams > RemainingMx
			and			((select Count(*) from MMResource with (readuncommitted) where MasterPoolId = mp.MasterPoolId AND HasJobInterrupted = 0)
							+ (@i_numStreams - RemainingMx))
							> mp.TotalDrives
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 279
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
			-- Additional new drives required with existing reservation on the master pool exceeds the Max num
			-- For non-Magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 296,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
			AND			(
								MPMaxSwitchForHost = 0
								OR
								(
									MPMaxSwitchForHost > 0
									AND		RemainingMx < @i_numStreams
									AND		((@i_numStreams - RemainingMx) +
												 (select count(distinct DriveId) from MMResource with (readuncommitted)
													where IntrJobId_l = 0 and MasterPoolId = RMDataPathView.MasterPoolId))
												> MPMaxSwitchForHost
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
	  	if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 296
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
		  -- For magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 297,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId = 3
			AND			(
								MPMaxSwitchForHost = 0
								OR
								(
									MPMaxSwitchForHost > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) +
													 (select count(*) from MMResource with (readuncommitted)
														where IntrJobId_l = 0
and (ReservationType & 2) = 2
														and MasterPoolId = RMDataPathView.MasterPoolId))
														> MPMaxSwitchForHost
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
			-- Additional new drives required with existing reservation on the drive pool exceeds the Max num
			-- For non-Magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 296,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
			AND			(
								DPMaxDrivestoSwitch = 0
								OR
								(
									DPMaxDrivestoSwitch > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) +
													 (select count(distinct DriveId) from MMResource with (readuncommitted)
														where IntrJobId_l = 0 and DrivePoolId = RMDataPathView.DrivePoolId))
														> DPMaxDrivestoSwitch
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 296
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
		  -- For magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 297,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId = 3
			AND			(
								DPMaxDrivestoSwitch = 0
								OR
								(
									DPMaxDrivestoSwitch > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) +
													 (select count(*) from MMResource with (readuncommitted)
														where IntrJobId_l = 0
and (ReservationType & 2) = 2
														and DrivePoolId = RMDataPathView.DrivePoolId))
														> DPMaxDrivestoSwitch
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
		  ---------------------------------------------------
		  -- Filter: Library RestrictActivity status			 --
		  ---------------------------------------------------
			UPDATE	RMDataPathView
SET			FailureErrorCode = 20006,
FailureType = 2
			FROM		RMDataPathView
			WHERE		FailureErrorCode = 0
			AND			RestrictActivity > 0
			AND			RemainingMx < @i_numStreams
			AND			RestrictActivity <
							((	SELECT COUNT(*) FROM @DriveInActionList WHERE MasterPoolId = RMDataPathView.MasterPoolId )
							+ (@i_numStreams - RemainingMx))
			SET @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
			IF @NumDataPathViews = 0
			BEGIN
SET @o_ErrorCode = 20006
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			END
		end
		else -- @i_dataMultiStream > 0
		begin
			-- multiplexing
			UPDATE RMDataPathView
SET		FailureErrorCode = 20022,
FailureType = 2
			WHERE	FailureErrorCode = 0
			AND		SpareGroupId > 0
			AND		(NonReservedDriveCount * @i_MuxFactor + RemainingMx) < @i_numStreams
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
	  	if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20022
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
		  ---------------------------------------------------
		  -- Filter: check for total drives in the master pool --
		  ---------------------------------------------------
			update	RMDataPathView
set			FailureErrorCode = 279,
FailureType = 2
			from		RMDataPathView a, MMMasterPool mp with (readuncommitted)
			where		a.FailureErrorCode = 0
			and			a.MasterPoolId > 0
			and			a.MasterPoolId = mp.MasterPoolId
			and			RemainingMx < @i_numStreams
			and			((select Count(*) from MMResource with (readuncommitted) where MasterPoolId = mp.MasterPoolId AND HasJobInterrupted = 0)
							+ (@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor))
							 > mp.TotalDrives
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 279
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
			-- Additional new drives required with existing reservation on the master pool exceeds the Max num
			-- For non-Magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 296,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
			AND			(
								MPMaxSwitchForHost = 0
								OR
								(
									MPMaxSwitchForHost > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor) +
													 (select count(distinct DriveId) from MMResource with (readuncommitted)
														where IntrJobId_l = 0 and MasterPoolId = RMDataPathView.MasterPoolId))
														> MPMaxSwitchForHost
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
	  	if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 296
set @o_FailureType = 2
					goto EXIT_AND_RETURN
			end
		  -- For magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 297,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId = 3
			AND			(
								MPMaxSwitchForHost = 0
								OR
								(
									MPMaxSwitchForHost > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor) +
													 (select count(*) from MMResource with (readuncommitted)
														where IntrJobId_l = 0
and (ReservationType & 2) = 2
														and MasterPoolId = RMDataPathView.MasterPoolId))
														> MPMaxSwitchForHost
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
			-- Additional new drives required with existing reservation on the drive pool exceeds the Max num
			-- For non-Magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 296,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
			AND			(
								DPMaxDrivestoSwitch = 0
								OR
								(
									DPMaxDrivestoSwitch > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor) +
													 (select count(distinct DriveId) from MMResource with (readuncommitted)
														where IntrJobId_l = 0 and DrivePoolId = RMDataPathView.DrivePoolId))
														> DPMaxDrivestoSwitch
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 296
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
		  -- For magnetic library
			UPDATE RMDataPathView
SET			FailureErrorCode = 297,
FailureType = 2
			WHERE		FailureErrorCode = 0
AND			LibraryTypeId = 3
			AND			(
								DPMaxDrivestoSwitch = 0
								OR
								(
									DPMaxDrivestoSwitch > 0
									AND			RemainingMx < @i_numStreams
									AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor) +
													 (select count(*) from MMResource with (readuncommitted)
														where IntrJobId_l = 0
and (ReservationType & 2) = 2
														and DrivePoolId = RMDataPathView.DrivePoolId))
														> DPMaxDrivestoSwitch
								)
							)
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 297
set @o_FailureType = 2
			    goto EXIT_AND_RETURN
			end
		  ---------------------------------------------------
		  -- Filter: Library RestrictActivity status			 --
		  ---------------------------------------------------
			UPDATE	RMDataPathView
SET			FailureErrorCode = 20006,
FailureType = 2
			FROM		RMDataPathView
			WHERE		FailureErrorCode = 0
			AND			RestrictActivity > 0
			AND			RemainingMx < @i_numStreams
			AND			RestrictActivity <
							((	SELECT COUNT(*) FROM @DriveInActionList WHERE MasterPoolId = RMDataPathView.MasterPoolId )
							+ ((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor)))
			SET @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
			IF @NumDataPathViews = 0
			BEGIN
SET @o_ErrorCode = 20006
set @o_FailureType = 2
				GOTO EXIT_AND_RETURN
			END
		end -- end of else @i_dataMultiStream = 0
  end -- end of if @i_numStreams > 1 AND @i_bestcaseReserve = 0
  ------------------------------------------------------
  -- End of Filter: number of streams required by job --
  ------------------------------------------------------
  ------------------------------------------------------
  -- Filter: number of media required by job 					--
	-- Available Media should also meet the requirement
	-- Only do the check if the values have been set.
	-- If the values are less than 0, it means we donot want this check.
  ------------------------------------------------------
IF @i_ReservationType = 2
  AND	EXISTS ( SELECT * FROM RMDataPathView WHERE FailureErrorCode = 0 AND ( AppendableMediaCount >= 0 OR SpareMediaCount >= 0 ) )
  BEGIN
	  IF @i_numStreams > 1 AND @i_bestcaseReserve = 0
	  BEGIN
	  	IF @i_dataMultiStream = 0
	  	BEGIN
				-- If media count less than the required numStream
				UPDATE	RMDataPathView
SET			FailureErrorCode = 20029,
FailureType = 2
				WHERE		FailureErrorCode = 0
				AND			SpareGroupId > 0
AND			LibraryTypeId NOT in  (3,	4, 5)
				AND			RemainingMx < @i_numStreams
				AND			(@i_numStreams - RemainingMx) > (AppendableMediaCount + SpareMediaCount)
				SET @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
				IF @NumDataPathViews = 0
				BEGIN
SET @o_ErrorCode = 20029
SET @o_FailureType = 2
					GOTO EXIT_AND_RETURN
				END
			END
			ELSE -- @i_dataMultiStream > 0
			BEGIN
				UPDATE	RMDataPathView
SET			FailureErrorCode = 20029,
FailureType = 2
				WHERE		FailureErrorCode = 0
				AND			SpareGroupId > 0
AND			LibraryTypeId NOT in  (3,	4, 5)
				AND			RemainingMx < @i_numStreams
				AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor))
								>  (AppendableMediaCount + SpareMediaCount)
			  set @NumDataPathViews = @NumDataPathViews - @@rowcount
			  if @NumDataPathViews = 0
			  begin
set @o_ErrorCode = 20029
set @o_FailureType = 2
				    goto EXIT_AND_RETURN
				end
			END
		END
		ELSE -- NOT @i_numStreams > 1 AND @i_bestcaseReserve = 0
		BEGIN
			-- Have at least one media
			UPDATE	RMDataPathView
SET			FailureErrorCode = 20029,
FailureType = 1
			WHERE		FailureErrorCode = 0
			AND			SpareGroupId > 0
AND			LibraryTypeId NOT in  (3,	4, 5)
			AND			RemainingMx = 0
			AND			(AppendableMediaCount + SpareMediaCount) = 0
		  set @NumDataPathViews = @NumDataPathViews - @@rowcount
		  if @NumDataPathViews = 0
		  begin
set @o_ErrorCode = 20029
set @o_FailureType = 1
			    goto EXIT_AND_RETURN
			end
		END
	END
 ------------------------------------------------------
  -- End of Filter: number of media required by job 	--
  ------------------------------------------------------
  ------------------------------------------------------------------------------------
  -- Filter: Check if extra drive availabe. This is used for For Synthetic Full job --
  -- Make sure there are at least two good drives that are not reserved if the extra
  -- drive pool is the same as data path drive pool. Or make sure there are at least
  -- one good drive that is not reserved in every drive pool.
  ------------------------------------------------------------------------------------
	if @i_extraRestoreDrive > 0
	begin
		if (@i_extraRestoreDrivePoolId > 0
		and exists (select * from RMDataPathView where FailureErrorCode = 0 and DrivePoolId = @i_extraRestoreDrivePoolId))
		or @i_extraRestoreDrivePoolId <= 0
		begin
		  if @i_numStreams > 1 AND @i_bestcaseReserve = 0
		  begin
				if @i_dataMultiStream = 0
				begin
					UPDATE	RMDataPathView
SET			FailureErrorCode = 807,
FailureType = 2
					WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
					AND			(@i_extraRestoreDrivePoolId = 0 OR DrivePoolId = @i_extraRestoreDrivePoolId)
					AND			RemainingMx < @i_numStreams
					AND			(@i_numStreams - RemainingMx + 1) > NonReservedDriveCount
					SET @NumDataPathViews = @NumDataPathViews - @@ROWCOUNT
					IF @NumDataPathViews = 0
					BEGIN
SET @o_ErrorCode = 807
set @o_FailureType = 2
						GOTO EXIT_AND_RETURN
					END
				end
				else -- @i_dataMultiStream > 0
				begin
					UPDATE RMDataPathView
SET			FailureErrorCode = 807,
FailureType = 2
					WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
					AND			(@i_extraRestoreDrivePoolId = 0 OR DrivePoolId = @i_extraRestoreDrivePoolId)
					AND			RemainingMx < @i_numStreams
					AND			((@i_numStreams - RemainingMx) / @i_MuxFactor + sign((@i_numStreams - RemainingMx) % @i_MuxFactor) + 1)
										> NonReservedDriveCount
				  set @NumDataPathViews = @NumDataPathViews - @@rowcount
			  	if @NumDataPathViews = 0
				  begin
set @o_ErrorCode = 807
set @o_FailureType = 2
							goto EXIT_AND_RETURN
					end
				end
			end
			ELSE -- NOT @i_numStreams > 1 AND @i_bestcaseReserve = 0
			BEGIN
				-- Have at least one media
				UPDATE	RMDataPathView
SET			FailureErrorCode = 807,
FailureType = 2
				WHERE		FailureErrorCode = 0
AND			LibraryTypeId != 3
				AND			(@i_extraRestoreDrivePoolId = 0 OR DrivePoolId = @i_extraRestoreDrivePoolId)
				AND			((RemainingMx > 0 AND NonReservedDriveCount < 1)
								OR
								 (RemainingMx = 0 AND NonReservedDriveCount < 2))
			  set @NumDataPathViews = @NumDataPathViews - @@rowcount
			  if @NumDataPathViews = 0
			  begin
set @o_ErrorCode = 807
set @o_FailureType = 2
				    goto EXIT_AND_RETURN
				end
			END
		end
		else -- if @i_extraRestoreDrivePoolId > 0 and not in Data Path list
		begin
			declare @extraDriveCount int
			declare @extraNonReservedDriveCount int
			set @extraDriveCount = 0
			set @extraNonReservedDriveCount = 0
			declare @libraryUseDriveNeedCleaning int
			declare @libraryIsMagnetic int
			declare @extraRestoreMasterPoolId int
select	@libraryUseDriveNeedCleaning = l.LibraryAttribute & 2048,
@libraryIsMagnetic = case when l.LibraryTypeId = 3 then 1 else 0 end,
@extraDriveCount = case when l.LibraryTypeId = 3 then mp.TotalDrives else 0 end,
							@extraRestoreMasterPoolId = mp.MasterPoolId
			from MMLibrary as l with (readuncommitted), MMMasterPool as mp with (readuncommitted), MMDrivePool as dp with (readuncommitted)
			where	l.LibraryId = mp.LibraryId
			and		mp.MasterPoolId = dp.MasterPoolId
			and		dp.DrivePoolId = @i_extraRestoreDrivePoolId
			if @libraryIsMagnetic is not null and @libraryIsMagnetic = 0
			begin
				if @libraryUseDriveNeedCleaning = 0
				begin
					select @extraDriveCount = count(distinct DriveId)
					from	MMDrive with (readuncommitted)
					where DriveId in (select DriveId from MMDriveController with (readuncommitted)
														where DrivePoolId = @i_extraRestoreDrivePoolId
														and DriveControllerSoftState = 1
														and DriveControllerEnabled = 1
														and DriveAccessible = 1)
					and MasterPoolId = @extraRestoreMasterPoolId
					and DriveSoftState = 1
					and DriveEnabled = 1
					and DriveBroken = 0
					and CleaningRequired = 0
					select @extraNonReservedDriveCount = count(distinct DriveId)
					from	MMDrive with (readuncommitted)
					where DriveId not in (select DriveId from MMResource  with (readuncommitted) where DriveId != 0)
					and	DriveId in (select DriveId from MMDriveController with (readuncommitted)
														where DrivePoolId = @i_extraRestoreDrivePoolId
														and DriveControllerSoftState = 1
														and DriveControllerEnabled = 1
														and DriveAccessible = 1)
					and MasterPoolId = @extraRestoreMasterPoolId
					and DriveSoftState = 1
					and DriveEnabled = 1
					and DriveBroken = 0
					and CleaningRequired = 0
				end
				else
				begin
					select @extraDriveCount = count(distinct DriveId)
					from	MMDrive with (readuncommitted)
					where DriveId in (select DriveId from MMDriveController with (readuncommitted)
														where DrivePoolId = @i_extraRestoreDrivePoolId
														and DriveControllerSoftState = 1
														and DriveControllerEnabled = 1
														and DriveAccessible = 1)
					and MasterPoolId = @extraRestoreMasterPoolId
					and DriveSoftState = 1
					and DriveEnabled = 1
					and DriveBroken = 0
					select @extraNonReservedDriveCount = count(distinct DriveId)
					from	MMDrive with (readuncommitted)
					where DriveId not in (select DriveId from MMResource  with (readuncommitted) where DriveId != 0)
					and	DriveId in (select DriveId from MMDriveController with (readuncommitted)
														where DrivePoolId = @i_extraRestoreDrivePoolId
														and DriveControllerSoftState = 1
														and DriveControllerEnabled = 1
														and DriveAccessible = 1)
					and MasterPoolId = @extraRestoreMasterPoolId
					and DriveSoftState = 1
					and DriveEnabled = 1
					and DriveBroken = 0
				end
				if @extraDriveCount < 1
				begin
					update RMDataPathView
set			FailureErrorCode = 811,
FailureType = 2
					where		FailureErrorCode = 0
					set @NumDataPathViews = 0
set @o_ErrorCode = 811
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				end
				if @extraNonReservedDriveCount < 1
				begin
					update RMDataPathView
set			FailureErrorCode = 807,
FailureType = 2
					where		FailureErrorCode = 0
					set @NumDataPathViews = 0
set @o_ErrorCode = 807
set @o_FailureType = 2
				  GOTO EXIT_AND_RETURN
				end
			end
		end -- if @i_extraRestoreDrivePoolId > 0 and not in Data Path list
	end -- if @i_extraRestoreDrive > 0
  ------------------------------------------------------------------------------------
  -- End Of Filter: Check if extra drive availabe. This is used for For Synthetic Full job --
  ------------------------------------------------------------------------------------
EXIT_AND_RETURN:
if @NumDataPathViews > 0
set @o_ErrorCode = 0
/*
if @isDebug > 0
begin
	set @debugDetail = cast(isnull((select DataPathId, FailureErrorCode	from RMDataPathView where FailureErrorCode > 0
																	for XML RAW('UnavailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
	set @debugDetail = cast(isnull((select DataPathId, Priority, DrivePoolId, HostClientId, LibraryId, MasterPoolId, SpareGroupId
																	from RMDataPathView where FailureErrorCode = 0
																	for XML RAW('AvailableDataPath'), TYPE), 'NULL') as varchar(max))
	insert into RMLogger values ('RMGetDataPathView', @debugDetail, @i_RequestId, getutcdate())
end
*/
-- select * from RMDataPathView where FailureErrorCode = 0
GO

IF EXISTS (select * from GxQscripts where name = 'RMDataPathAdditionalFilter')
	delete from GxQscripts where name = 'RMDataPathAdditionalFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMDataPathAdditionalFilter')
	delete from GXDBVersions where aliasname = 'RMDataPathAdditionalFilter'
GO

insert into GXDBVersions values(2, 'RMDataPathAdditionalFilter',  '00010014001400140000', 'RMDataPathAdditionalFilter', '00010014001400140000')
GO

