

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMCreateReservationRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMCreateReservationRequest.sp,v $ $Id: RMCreateReservationRequest.sp,v 1.27.2.7 2018/03/27 17:27:05 cliu Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMCreateReservationRequest()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMCreateReservationRequest <<<'

IF EXISTS (select * from sysobjects where name='RMCreateReservationRequest')
	drop procedure RMCreateReservationRequest
IF EXISTS (select * from GxQscripts where name='RMCreateReservationRequest')
	delete from GxQscripts where name = 'RMCreateReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCreateReservationRequest')
	delete from GXDBVersions where aliasname = 'RMCreateReservationRequest'
GO
print '... Creating Procedure: RMCreateReservationRequest'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMCreateReservationRequest
  @i_RequestId int,
  @i_jobId bigint,
  @i_commCellId int,
  @i_scheduleRunId bigint,
  @i_useSCDataPath int,
  @i_jobType int,
  @i_jobOpType int,
  @i_iDAType int,
  @i_priority int,
  @i_phaseFirstAttemptTime int,
  @i_RequestCategory int,
  @i_maxNumOfAttempts int,
  @i_MaxNumOfReservedStreams int,
  @i_registrySetting varchar(max),
  @i_xml varchar(max),
  @i_isForNewRM int
AS
  DECLARE @o_RequestId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- If the request id is specified, update the request using input
	IF @i_RequestId IS NOT NULL AND @i_RequestId > 0
	AND EXISTS (SELECT JobId FROM RMReservationRequest WITH (NOLOCK) WHERE RequestId = @i_RequestId)
	BEGIN
		UPDATE	RMReservationRequest
		SET			--JobId = CASE WHEN @i_jobId > 0 THEN @i_JobId ELSE JobId END,
						--CommCellId = CASE WHEN @i_commCellId > 0 THEN @i_commCellId ELSE CommCellId END,
						--ScheduleRunId = CASE WHEN @i_scheduleRunId > 0 THEN @i_scheduleRunId ELSE ScheduleRunId END,
						UseSCDataPath = @i_useSCDataPath,
						--JobType = CASE WHEN @i_jobType > 0 THEN @i_JobType ELSE JobType END
						--JobOpType = CASE WHEN @i_jobOpType > 0 THEN @i_JobOpType ELSE JobOpType END,
						--iDAType	= CASE WHEN @i_iDAType > 0 THEN @i_iDAType ELSE iDAType END,
						priority	= CASE WHEN @i_priority > 0 THEN @i_priority ELSE priority END,
						phaseFirstAttemptTime = @i_phaseFirstAttemptTime,
						copyId = 0,
						--RequestCategory = @i_RequestCategory,
						MaxNumOfAttempts = CASE WHEN @i_maxNumOfAttempts > 0 THEN @i_maxNumOfAttempts ELSE MaxNumOfAttempts END,
						MaxNumOfReservedStreams = CASE WHEN @i_MaxNumOfReservedStreams > 0 THEN @i_MaxNumOfReservedStreams ELSE MaxNumOfReservedStreams END,
						registrySetting = CASE WHEN LEN(@i_registrySetting) > 0 THEN @i_registrySetting ELSE registrySetting END,
						xmlParams = CASE WHEN LEN(@i_xml) > 0 THEN @i_xml ELSE xmlParams END
		WHERE		RequestId = @i_RequestId
		SET @o_RequestId = @i_RequestId
		GOTO exit_done
	END
IF (@i_RequestId IS NULL OR @i_RequestId = 0) AND @i_RequestCategory != 0
	BEGIN
		IF (@i_isForNewRM <> 1 OR @i_maxNumOfAttempts < 0)
		BEGIN
			if @i_jobType = 4
			begin
				SELECT TOP 1 @i_RequestId = ISNULL(RequestId, 0)
				FROM	RMReservationRequest WITH (NOLOCK)
				WHERE	JobId = @i_jobId
				AND		CommCellId = @i_commCellId
				AND		ScheduleRunId = @i_scheduleRunId
				AND		JobType = @i_jobType
				AND		JobOpType = @i_jobOpType
				AND		iDAType = @i_iDAType
				AND		XmlParams = @i_xml
				ORDER BY PhaseFirstAttemptTime DESC
			end
			else
			begin
				SELECT TOP 1 @i_RequestId = ISNULL(RequestId, 0)
				FROM	RMReservationRequest WITH (NOLOCK)
				WHERE	JobId = @i_jobId
				AND		CommCellId = @i_commCellId
				AND		ScheduleRunId = @i_scheduleRunId
				AND		JobType = @i_jobType
				AND		JobOpType = @i_jobOpType
				AND		iDAType = @i_iDAType
				AND		XmlParams = @i_xml
				AND		(
							@i_isForNewRM = 1 AND ErrorCode > 0 AND PhaseFirstAttemptTime = @i_phaseFirstAttemptTime
							OR
							@i_isForNewRM = 0 AND ErrorCode != 0
						)
				--AND		NOT EXISTS (SELECT 1 FROM JMJobStats WITH (NOLOCK) WHERE JobId = @i_jobId AND CommCellId = @i_commCellId AND opType IN (18 /*BACKUP3RD*/))
				ORDER BY SIGN(ErrorCode)
			end
		END
	END
	IF @i_JobId = 0 AND @i_RequestId IS NOT NULL AND @i_RequestId > 0
	BEGIN
		DELETE FROM RMReservationRequest WHERE RequestId = @i_RequestId
		--DELETE FROM RMLogger WHERE RequestId = @i_RequestId
	END
	IF @i_RequestId IS NOT NULL AND @i_RequestId > 0
	AND EXISTS (SELECT JobId FROM RMReservationRequest WITH (NOLOCK) WHERE RequestId = @i_RequestId)
	BEGIN
		UPDATE	RMReservationRequest
		SET			FailureType = CASE WHEN ErrorCode = 0 THEN -1 ELSE FailureType END,
					ErrorCode = CASE WHEN ErrorCode = 0 THEN -1 ELSE ErrorCode END,
						UseSCDataPath = @i_useSCDataPath,
						priority	= CASE WHEN @i_priority > 0 THEN @i_priority ELSE priority END,
						--CopyId = 0,
						MaxNumOfAttempts = CASE WHEN @i_maxNumOfAttempts > 0 THEN @i_maxNumOfAttempts ELSE MaxNumOfAttempts END,
						MaxNumOfReservedStreams = CASE WHEN @i_MaxNumOfReservedStreams > 0 THEN @i_MaxNumOfReservedStreams ELSE MaxNumOfReservedStreams END,
						PhaseFirstAttemptTime = @i_phaseFirstAttemptTime,
						registrySetting = CASE WHEN LEN(@i_registrySetting) > 0 THEN @i_registrySetting ELSE registrySetting END--,
						--ReservationResults = ''
		WHERE		RequestId = @i_RequestId
		--AND			ErrorCode > 0
		--DELETE FROM RMLogger WHERE RequestId = @i_RequestId
		SET @o_RequestId = @i_RequestId
		GOTO exit_done
	END
	ELSE
	BEGIN
		INSERT INTO RMReservationRequest
		(
			ErrorCode, FailureType, RequestTime, FailureAttempts, ShouldFailRequest, MaxNumOfAttempts, MaxNumOfReservedStreams,
			JobId, CommCellId, ScheduleRunId,
			UseSCDataPath,
			JobType, JobOpType, iDAType,
			PhaseFirstAttemptTime, CopyId, Priority, RequestCategory,
			RegistrySetting,
			XmlParams,
			ReservationResults
		)
		VALUES
		(
			-1, -1, dbo.GetUnixTime(getutcdate()), 0, -1, @i_maxNumOfAttempts, @i_MaxNumOfReservedStreams,
			@i_jobId, @i_commCellId, @i_scheduleRunId,
			@i_useSCDataPath,
			@i_jobType, @i_jobOpType, @i_iDAType,
			@i_phaseFirstAttemptTime, 0, @i_Priority, @i_RequestCategory,
			@i_registrySetting,
			@i_xml,
				''
		)
		SELECT @o_RequestId = @@identity
	END
	IF @i_jobId > 0 AND NOT EXISTS (SELECT JobId FROM RMJobControl WITH (NOLOCK) WHERE JobId = @i_jobId)
	BEGIN
		INSERT INTO RMJobControl
		(
			JobId, CommCellId, ErrorCode, FailureType, RequestTime, FailureAttempts,
			Priority, NoOfReservedStreams, Status, FailureReason
		)
		VALUES
		(
			@i_jobId, @i_commCellId, -1, -1, dbo.GetUnixTime(getutcdate()), 0,
@i_Priority, 0, 1, ''
		)
	END
	ELSE IF @i_jobId > 0 AND EXISTS (SELECT JobId FROM RMJobControl WITH (NOLOCK) WHERE JobId = @i_jobId)
	BEGIN
		DECLARE @isJobRunning INT = 1
		EXEC 	RMIsJobOnRunningState @i_JobId, @i_commCellId, @isJobRunning output
		UPDATE RMJobControl
SET Status = 1,
			ErrorCode = -1,
			FailureType = -1,
			FailureReason = '',
			RequestTime = dbo.GetUnixTime(getutcdate())
		WHERE	JobId = @i_JobId
AND		(@isJobRunning != 0 OR Status != 4)
	END
exit_done:
  select @o_RequestId
  return @o_RequestId
GO

IF EXISTS (select * from GxQscripts where name = 'RMCreateReservationRequest')
	delete from GxQscripts where name = 'RMCreateReservationRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCreateReservationRequest')
	delete from GXDBVersions where aliasname = 'RMCreateReservationRequest'
GO

insert into GXDBVersions values(2, 'RMCreateReservationRequest',  '00010027000200070000', 'RMCreateReservationRequest', '00010027000200070000')
GO

