

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMCheckPowerONStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMCheckPowerONStatus.sp,v $ $Id: RMCheckPowerONStatus.sp,v 1.1.2.2 2018/03/19 23:56:45 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMCheckPowerONStatus()
--  +========================================================================+
--
/*
This procedure checks if power managed MA is ready.
*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMCheckPowerONStatus <<<'

IF EXISTS (select * from sysobjects where name='RMCheckPowerONStatus')
	drop procedure RMCheckPowerONStatus
IF EXISTS (select * from GxQscripts where name='RMCheckPowerONStatus')
	delete from GxQscripts where name = 'RMCheckPowerONStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckPowerONStatus')
	delete from GXDBVersions where aliasname = 'RMCheckPowerONStatus'
GO
print '... Creating Procedure: RMCheckPowerONStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMCheckPowerONStatus
  @i_requestId integer
AS
  DECLARE @o_ErrorCode integer;
  DECLARE @o_FailureType integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_FailureType = 2
if @i_requestId = 0
	OR NOT EXISTS (SELECT 1 FROM MMPowerMgmtJobToVMMap WHERE RMRequestId = @i_requestId)
begin
set @o_ErrorCode = 103
  GOTO ERROR_EXIT
end
DECLARE @HOST_STATUS_POWER_MANAGED_VM		INTEGER
SET		@HOST_STATUS_POWER_MANAGED_VM		= 7
DECLARE @powerManagedVMlist TABLE (requestId INT, clientId INT, hostSoftState INT, hostOfflineReason INT, hostAttributes INT, powerONfailureReason INT)
INSERT INTO @powerManagedVMlist
SELECT @i_requestId, VM.HostId, H.MmHostSoftState, H.OfflineReason, H.Attribute, VM.FailureReason
FROM MMPowerMgmtJobToVMMap VMMAP WITH (READUNCOMMITTED)
	INNER JOIN MMVMPowerMgmtReq VM WITH (READUNCOMMITTED) ON VM.RequestId = VMMAP.RequestId
	INNER JOIN MMHost H ON VM.HostId = H.clientId
WHERE VMMAP.RMRequestId = @i_requestId
IF (SELECT COUNT(*) FROM @powerManagedVMlist WHERE hostSoftState <> 1) = 0
BEGIN
	SET @o_ErrorCode = 0
	GOTO ERROR_EXIT
END
ELSE
/*If this request needs more than one power VM and if any of the VM power ON fails we are failing whole request , think about it later.
 Power on VM failed after 3 retries, so JM should stop calling this api and submit new resouce allocation request */
IF EXISTS (SELECT 1 FROM @powerManagedVMlist
			WHERE powerONfailureReason = 2 )
BEGIN
	SET @o_ErrorCode = 1
	GOTO ERROR_EXIT
END
ELSE
 -- User disabled power management option on MA after job is submitted, so no need to wait for power ON, ask JM to submit new resouce allocation request
IF EXISTS (SELECT 1 FROM @powerManagedVMlist
WHERE hostAttributes & 32768 <>  32768 AND hostSoftState <> 1)
BEGIN
	SET @o_ErrorCode = 2
END
ELSE
SET @o_ErrorCode = 346
ERROR_EXIT:
SELECT @o_ErrorCode, @o_FailureType
GO

IF EXISTS (select * from GxQscripts where name = 'RMCheckPowerONStatus')
	delete from GxQscripts where name = 'RMCheckPowerONStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckPowerONStatus')
	delete from GXDBVersions where aliasname = 'RMCheckPowerONStatus'
GO

insert into GXDBVersions values(2, 'RMCheckPowerONStatus',  '00010001000200020000', 'RMCheckPowerONStatus', '00010001000200020000')
GO

