

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMCheckLicenseStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMCheckLicenseStatus.sp,v $ $Id: RMCheckLicenseStatus.sp,v 1.12.2.9 2020/11/06 23:57:05 cliu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RMCheckLicenseStatus')
BEGIN
	print '>>> Drop Stored Procedure: RMCheckLicenseStatus <<<'
	drop procedure RMCheckLicenseStatus
END
IF EXISTS (select * from GxQscripts where name='RMCheckLicenseStatus')
	delete from GxQscripts where name = 'RMCheckLicenseStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckLicenseStatus')
	delete from GXDBVersions where aliasname = 'RMCheckLicenseStatus'
GO
print '... Creating Procedure: RMCheckLicenseStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RMCheckLicenseStatus
  @i_LicenseLevel integer,
  @i_ClientId integer,
  @i_LicType bigint,
  @i_AppType integer,
  @i_OpType varchar(20),
  @i_Valid integer,
-- If > 1 then update, -1 to cleanup, otherwise retrieve
  @i_Update integer
AS
  DECLARE @o_Valid integer;
	set @o_Valid = 0
/*
create table RMLicenseStatus
	(
		LicenseLevel				integer,
		ClientId						integer,
		LicType							integer,
		AppType							integer,
		OpType							integer,
		Valid								integer
	);;
*/
	DECLARE @defaultCCId INT = 2
	IF @i_Update > 0
	BEGIN
		IF EXISTS (SELECT * FROM RMLicenseStatus
								WHERE LicenseLevel = @i_LicenseLevel
								AND		ClientId = @i_ClientId
								AND		LicType = @i_LicType
								AND		AppType = @i_AppType
								AND		OpType = @i_OpType)
		BEGIN
			UPDATE RMLicenseStatus
			SET		Valid = @i_Valid
			WHERE LicenseLevel = @i_LicenseLevel
			AND		ClientId = @i_ClientId
			AND		LicType = @i_LicType
			AND		AppType = @i_AppType
			AND		OpType = @i_OpType
		END
		ELSE
		BEGIN
			INSERT INTO RMLicenseStatus
			SELECT @i_LicenseLevel, @i_ClientId, @i_LicType, @i_AppType, @i_OpType, @i_Valid
		END
		SET @o_Valid = @i_Valid
		SELECT @o_Valid
	END
	ELSE IF @i_Update = -1
	BEGIN
		DELETE RMLicenseStatus
		SELECT 0
		DECLARE @OneDayBeforeNow INT
		SELECT @OneDayBeforeNow = dbo.GetUnixTime(getutcdate()) - 86400 /*24 * 3600*/
		DECLARE @JobIdList TABLE (jobId integer)
		INSERT INTO @JobIdList
		SELECT	DISTINCT JobId
		FROM	RMReservationRequest with (readuncommitted)
		WHERE	(
					RequestTime > 0 AND RequestTime <= @OneDayBeforeNow
					OR
					RequestTime < 0 AND PhaseFirstAttemptTime > 0 AND PhaseFirstAttemptTime <= @OneDayBeforeNow
				)
		AND		JobId NOT IN
		(select JobId from JMJobInfo with (readuncommitted) where commCellId = @defaultCCId)
		EXEC SQLUtilTruncateTable 'HistoryDB..RMLogger'
		WHILE (1=1)
		BEGIN
			DELETE TOP (20000) FROM RMReservations
			FROM RMReservations a, RMReservationRequest b, @JobIdList c
			WHERE	b.JobId = c.jobId
			AND	a.RequestId = b.RequestId
			IF @@ROWCOUNT < 1 BREAK
		END
		WHILE (1=1)
		BEGIN
			DELETE TOP (20000) FROM RMReservationRequest
			FROM RMReservationRequest a, @JobIdList b
			WHERE a.JobId = b.JobId
			IF @@ROWCOUNT < 1 BREAK
		END
		WHILE (1=1)
		BEGIN
			DELETE TOP (20000) FROM RMReservationRequest
WHERE	RequestCategory in (0, 1, 3,
										/*RM_RESERVATION_BACKUP,*/
4, 5, 6,
7, 8, 9)
			AND		ErrorCode != -1
			AND		(
						RequestTime > 0 AND RequestTime <= @OneDayBeforeNow
						OR
						RequestTime < 0 AND PhaseFirstAttemptTime > 0 AND PhaseFirstAttemptTime <= @OneDayBeforeNow
					)
			IF @@ROWCOUNT < 1 BREAK
		END
		DELETE FROM RMJobControl
		FROM RMJobControl a, @JobIdList b
		WHERE a.JobId = b.JobId
		/* No need to remove rows based on the reservation requests since job can be inactive for long time.
		DELETE FROM RMJobControl
		FROM RMJobControl a left join RMReservationRequest b on a.JobId = b.JobId
		WHERE b.JobId is NULL
		*/
		DELETE FROM RMReservations
		FROM RMReservations a left join RMJobControl b on a.JobId = b.JobId
		WHERE b.JobId is NULL
		WHILE (1=1)
		BEGIN
			DELETE TOP (20000) FROM ArchJobStreamStatus
			FROM ArchJobStreamStatus a LEFT JOIN RMJobControl b ON a.JobId = b.jobId
			WHERE b.jobId IS NULL
			AND   ModifiedTime <= @OneDayBeforeNow
			IF @@ROWCOUNT < 1 BREAK
		END
		WHILE (1=1)
		BEGIN
			DELETE TOP (20000) FROM ArchJobStreamStatusHistory
			FROM ArchJobStreamStatusHistory a LEFT JOIN RMJobControl b ON a.JobId = b.jobId
			WHERE b.jobId IS NULL
			AND	  ModifiedTime <= @OneDayBeforeNow
			IF @@ROWCOUNT < 1 BREAK
		END
	END
	ELSE
	BEGIN
		SELECT TOP 1 @o_Valid = ISNULL(Valid, 0)
		FROM RMLicenseStatus WITH (READUNCOMMITTED)
		WHERE LicenseLevel = @i_LicenseLevel
		AND		ClientId = @i_ClientId
		AND		LicType = @i_LicType
		AND		AppType = @i_AppType
		AND		OpType = @i_OpType
		ORDER BY Valid DESC
		if @o_Valid = 0
		begin
			declare @licenseCheckResults table ( isValid integer, expTime integer, errorStr varchar(MAX))
			insert into @licenseCheckResults
			exec simValidLicenseCheck @i_ClientId, @i_AppType, @i_LicType
			IF @@ERROR > 0
			BEGIN
			  set @o_Valid = 0
			END
			if exists (select * from @licenseCheckResults where isValid = 1)
			begin
				set @o_Valid = 1
				if exists (select * FROM RMLicenseStatus
									WHERE LicenseLevel = @i_LicenseLevel
									AND		ClientId = @i_ClientId
									AND		LicType = @i_LicType
									AND		AppType = @i_AppType
									AND		OpType = @i_OpType
									)
				begin
					update RMLicenseStatus set Valid = @o_Valid
					WHERE LicenseLevel = @i_LicenseLevel
					AND		ClientId = @i_ClientId
					AND		LicType = @i_LicType
					AND		AppType = @i_AppType
					AND		OpType = @i_OpType
				end
				else
				begin
					INSERT INTO RMLicenseStatus
					SELECT @i_LicenseLevel, @i_ClientId, @i_LicType, @i_AppType, @i_OpType, @o_Valid
				end
			end
		end
	END
	RETURN @o_Valid
GO

IF EXISTS (select * from GxQscripts where name = 'RMCheckLicenseStatus')
	delete from GxQscripts where name = 'RMCheckLicenseStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckLicenseStatus')
	delete from GXDBVersions where aliasname = 'RMCheckLicenseStatus'
GO

insert into GXDBVersions values(2, 'RMCheckLicenseStatus',  '00010012000200090000', 'RMCheckLicenseStatus', '00010012000200090000')
GO

