

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMCheckIfMxedForRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMCheckIfMxedForRestore.sp,v $ $Id: RMCheckIfMxedForRestore.sp,v 1.1.2.2 2018/11/21 19:43:09 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RMCheckIfMxedForRestore')
BEGIN
	print '>>> Drop Stored Procedure: RMCheckIfMxedForRestore <<<'
	drop procedure RMCheckIfMxedForRestore
END
IF EXISTS (select * from GxQscripts where name='RMCheckIfMxedForRestore')
	delete from GxQscripts where name = 'RMCheckIfMxedForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckIfMxedForRestore')
	delete from GXDBVersions where aliasname = 'RMCheckIfMxedForRestore'
GO
print '... Creating Procedure: RMCheckIfMxedForRestore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMCheckIfMxedForRestore
-- Set the default value as -1 to allow special lookup for value of 0
  @i_jobId integer = -1,
  @i_reservationId integer = -1,
  @i_volumeId integer = -1,
  @i_jobOpType integer = -1
AS
  DECLARE @o_isMXedForRestore integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET @o_isMXedForRestore = 0
	DECLARE @noOfReads integer = 0
	DECLARE @noOfWrites integer = 0
	DECLARE @noOfNotAuxcopyReads integer = 0
	IF @i_jobId <= 0 OR @i_volumeId <= 0
	BEGIN
		GOTO EXIT_RETURN
	END
	-- Check if there is interruption where there is no reservation Id
	IF @i_reservationid <= 0
	BEGIN
		SELECT TOP 1  @i_reservationId = res.ReservationId
		FROM	MMResource res WITH (READUNCOMMITTED), MMResourceToJob job WITH (READUNCOMMITTED)
		WHERE	res.ReservationId = job.ReservationId
		AND		res.VolumeId = @i_volumeId
		AND		job.JobId_l = @i_jobId AND job.JobId_h = 0
		AND		res.HasJobInterrupted = 0
		ORDER BY job.RCId
		IF @i_reservationId <= 0
		BEGIN
			GOTO EXIT_RETURN
		END
	END
	IF @i_jobOpType <= 0
	BEGIN
		SET @i_jobOpType = dbo.GetJobTypeForJobID(@i_jobId)
	END
	;WITH resTypeTable as
	(
		select 'totalreservationType' as TotalReservationType, [1], [2]
		from
		(select resToJob.ReservationType as reservationType
		FROM	MMResource res WITH (READUNCOMMITTED), MMResourceToJob resToJob WITH (READUNCOMMITTED)
		WHERE	res.ReservationId = resToJob.ReservationId
		AND		res.ReservationId = @i_reservationId
		AND		res.VolumeId = @i_volumeId
		) as sourceTable
		pivot
		(
		count(reservationType) for reservationType in ([1], [2]) /*RM_RESERVE_TYPE_READ, RM_RESERVE_TYPE_WRITE*/
		) as pivottable
	)
	SELECT @noOfReads= resTypeTable.[1],  @noOfWrites = resTypeTable.[2]
	from resTypeTable
	IF @i_jobOpType = 13 /*AUXCOPY*/
	BEGIN
		SELECT @noOfNotAuxcopyReads = count(DISTINCT resToJob.RCId)
		FROM	MMResource res WITH (READUNCOMMITTED), MMResourceToJob resToJob WITH (READUNCOMMITTED)
		WHERE	res.ReservationId = resToJob.ReservationId
		AND		res.ReservationId = @i_reservationId
		AND		res.VolumeId = @i_volumeId
		AND		resToJob.JobId_l != @i_jobId
		AND		resToJob.ReservationType = 1 /*RM_RESERVE_TYPE_READ*/
	END
	SET @o_isMXedForRestore = CASE WHEN @noOfReads > 0 AND @noOfWrites > 0 THEN 1
								   WHEN @noOfReads > 1 AND @i_jobOpType != 13 THEN 1
								   WHEN @noOfReads > 1 AND @noOfNotAuxcopyReads > 0 THEN 1
								   ELSE 0 END
EXIT_RETURN:
	SELECT @o_isMXedForRestore
	RETURN @o_isMXedForRestore
GO

IF EXISTS (select * from GxQscripts where name = 'RMCheckIfMxedForRestore')
	delete from GxQscripts where name = 'RMCheckIfMxedForRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCheckIfMxedForRestore')
	delete from GXDBVersions where aliasname = 'RMCheckIfMxedForRestore'
GO

insert into GXDBVersions values(2, 'RMCheckIfMxedForRestore',  '00010001000200020000', 'RMCheckIfMxedForRestore', '00010001000200020000')
GO

