

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMCanTurnOffPowerVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMCanTurnOffPowerVM <<<'

IF EXISTS (select * from sysobjects where name='RMCanTurnOffPowerVM')
	drop procedure RMCanTurnOffPowerVM
IF EXISTS (select * from GxQscripts where name='RMCanTurnOffPowerVM')
	delete from GxQscripts where name = 'RMCanTurnOffPowerVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCanTurnOffPowerVM')
	delete from GXDBVersions where aliasname = 'RMCanTurnOffPowerVM'
GO
print '... Creating Procedure: RMCanTurnOffPowerVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RMCanTurnOffPowerVM
  @i_inClientId INT
AS
  DECLARE @o_isJobScheduled INT
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
	SET @o_isJobScheduled = 1
	DECLARE @i_timeRange INT = 15
	IF OBJECT_ID('#subClientList') IS NOT NULL
		DROP TABLE #subClientList
	CREATE TABLE #subClientList ( clientId INT, subclientId INT, dataSp INT, logSp INT )
	INSERT INTO #subClientList
	SELECT  DISTINCT APP.clientId, APP.id, APP.dataArchGrpID, APP.logArchGrpID
	FROM      TM_subTask AS STASK WITH (NOLOCK) INNER JOIN TM_PatternAssoc AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
			   INNER JOIN TM_Pattern AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
			   INNER JOIN TM_AssocEntity AS ENT WITH (NOLOCK) ON STASK.taskId = ENT.taskId
			   INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.clientId = CASE WHEN ENT.clientId > 0 THEN ENT.clientId ELSE APP.clientId END
					AND APP.appTypeId = CASE WHEN ENT.apptypeId > 0 THEN ENT.apptypeId ELSE APP.appTypeId END
					AND APP.instance = CASE WHEN ENT.instanceId > 0 THEN ENT.instanceId ELSE APP.instance END
					AND APP.backupSet = CASE WHEN ENT.backupsetId > 0 THEN ENT.backupsetId ELSE APP.backupSet END
					AND APP.id = CASE WHEN ENT.subclientId > 0 THEN ENT.subclientId ELSE APP.id END
               INNER JOIN TM_RunTime AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId AND NRT.processed = 0
    WHERE     PAT.deleted = 0 AND datediff(MINUTE, GETUTCDATE(), NRT.nextRunTime) <= @i_timeRange
	IF EXISTS( SELECT 1 FROM archGroup AG WITH (NOLOCK)
					INNER JOIN #subClientList SC ON ( AG.id = SC.dataArchGrpID OR AG.id = SC.logArchGrpID )
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON ( AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy )
					INNER JOIN MMDataPath DP WITH (NOLOCK) ON DP.copyId = AGC.id
					INNER JOIN MMDrivePool DRP WITH (NOLOCK) ON DRP.DrivePoolId = DP.DrivePoolId
				WHERE SC.clientId = DRP.clientId AND DRP.clientId = @i_inClientId
			  )
	BEGIN
		SET @o_isJobScheduled = 0
	END
	SELECT @o_isJobScheduled
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RMCanTurnOffPowerVM')
	delete from GxQscripts where name = 'RMCanTurnOffPowerVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMCanTurnOffPowerVM')
	delete from GXDBVersions where aliasname = 'RMCanTurnOffPowerVM'
GO

insert into GXDBVersions values(2, 'RMCanTurnOffPowerVM',  '00000000000000000000', 'RMCanTurnOffPowerVM', '00000000000000000000')
GO

