

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RMBackupCachingReserve.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RMBackupCachingReserve.sp,v $ $Id: RMBackupCachingReserve.sp,v 1.9.194.4 2018/03/20 00:02:42 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RMBackupCachingReserve()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RMBackupCachingReserve <<<'

IF EXISTS (select * from sysobjects where name='RMBackupCachingReserve')
	drop procedure RMBackupCachingReserve
IF EXISTS (select * from GxQscripts where name='RMBackupCachingReserve')
	delete from GxQscripts where name = 'RMBackupCachingReserve'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMBackupCachingReserve')
	delete from GXDBVersions where aliasname = 'RMBackupCachingReserve'
GO
print '... Creating Procedure: RMBackupCachingReserve'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RMBackupCachingReserve
  @i_jobid_l int,
  @i_copyId int,
  @i_inClientId int,
  @o_ErrorCode integer OUTPUT,
  @o_reservationid integer OUTPUT,
  @o_rcid integer OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
set @o_ErrorCode = 0
set @o_reservationid = 0
set @o_rcid = 0
declare @reservationid integer
declare @drivepoolid integer
declare @driveid integer
declare @rcid integer
declare @mediaid integer
declare @mediagroupid integer
declare @recordingformatid integer
set @reservationId = 0
set @rcid = 0
set @drivepoolid = 0
set @driveid = 0
set @mediaid = 0
set @mediagroupid = 0
set @recordingformatid = 0
if @i_copyId = 0 or @i_jobid_l = 0
begin
set @o_ErrorCode = 103
  goto exit_done
end
-- Get the Lan-Free media agent candidates
declare @physicalClientId int
select	@physicalClientId = cast(attrVal as int)
from		APP_ClientProp with (readuncommitted)
where		componentNameId = @i_inClientId
and			attrName = 'Active Physical Node'
and			modified = 0
if @physicalClientId is null or @physicalClientId = 0
	set @physicalClientId = @i_inClientId
-- Get the caching reserve candidates by job id
select top 1 @reservationid = isnull(reservationid, 0), @rcid = isnull(rcid, 0)
from	mmresourcetojob
where	jobid_l = @i_jobid_l and reservationtype = 2 /*write*/ and releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))
and		reservationId in (
							select ReservationId from MMResource
							where copyId = @i_copyId and streamId > 0
							and ClientId in (@physicalClientId, @i_inClientId)
							and (intrjobid_l = 0 and hasjobinterrupted = 0)
						)
if @reservationid > 0 and @rcId > 0
begin
	if exists (select ReservationId from MMResource where reservationId = @reservationId and VolumeId = 0)
	begin
		delete MMResourceToJob where RCID = @rcid
		if not exists (select RCID from MMResourceToJob where ReservationId = @reservationId and RCId != @rcId)
		begin
			delete MMResource where ReservationId = @reservationId
		end
		set @reservationId = 0
		set @rcid = 0
		goto exit_done
	end
	-- check drive
	select @drivepoolid = drivepoolid, @driveid = driveid
	from mmresource
	where reservationid = @reservationid
	-- volume and drive are good, update inuse and return
	set @o_reservationid = @reservationid
	set @o_rcid = @rcid
update mmresourcetojob set inuse = 0, releasetime = 0, ReserveBitMask = (ReserveBitMask | 1), LogicalReleased = 0
	where rcid = @o_rcid
	update mmresource set LogicalRelease = 0
	where reservationId = @reservationId
	goto exit_done
end
-- No lan-free one being cache reserved
if @reservationId = 0 or @rcId = 0
begin
	select top 1 @reservationid = isnull(a.reservationid, 0), @rcid = isnull(b.rcid, 0)
	-- Find one backup cache that can be used by current lan-free MA
	from MMResource a WITH (READUNCOMMITTED), MMResourceToJob b WITH (READUNCOMMITTED)
	where a.copyId = @i_copyId and a.streamId > 0
	and		a.ReservationId = b.ReservationId
	and		b.jobId_l = @i_jobId_l
and		b.reservationType = 2 /*write*/ and b.releaseTime != 0 and (b.inuse = 0 OR (b.ReserveBitMask & (~2) = 0))
	and		a.DriveId in (
						select	distinct d.DriveId
						from	MMDataPath c WITH (READUNCOMMITTED), MMDrive d WITH (READUNCOMMITTED), MMDrivePool e WITH (READUNCOMMITTED)
						where	c.CopyId = @i_copyId and c.HostClientId in (@physicalClientId, @i_inClientId)
						and		c.DrivePoolId = e.DrivePoolId
						and		e.MasterPoolId = d.MasterPoolId
					)
	-- This indicates there is one resource can be used as lan-free backup.
	-- Release them and then regular reservation process will pick them up using the lan-free MA
	if @reservationId > 0 and @rcid > 0
	begin
		delete MMResourceToJob where RCID = @rcid
		if not exists (select RCID from MMResourceToJob where ReservationId = @reservationId and RCId != @rcId)
		begin
			delete MMResource where ReservationId = @reservationId
		end
		set @reservationId = 0
		set @rcid = 0
		goto exit_done
	end
end
-- If there is only one data path defined, there is no need to check if lan-free is possible. Just use the cached resources.
if @reservationId = 0 or @rcId = 0
begin
	declare @datapathCount int
	set @datapathCount = 0
	select @datapathCount = Count(DataPathId) from MMDataPath with (readuncommitted)
	where CopyId = @i_copyId
and	(Flag & 16) = 0
and (Flag & 4) = 4
	if @datapathCount = 1
	begin
		-- Get the caching reserve candidates by job id
		select top 1 @reservationid = isnull(reservationid, 0), @rcid = isnull(rcid, 0)
		from	mmresourcetojob
where	jobid_l = @i_jobid_l and reservationtype = 2 /*write*/ and releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))
		and		reservationId in (
									select ReservationId from MMResource
									where copyId = @i_copyId and streamId > 0
								)
		order by releasetime
		if @reservationid > 0 and @rcId > 0
		begin
			-- check drive
			select @drivepoolid = drivepoolid, @driveid = driveid
			from mmresource
			where reservationid = @reservationid
			-- volume and drive are good, update inuse and return
			set @o_reservationid = @reservationid
			set @o_rcid = @rcid
update mmresourcetojob set inuse = 0, releasetime = 0, ReserveBitMask = (ReserveBitMask | 1), LogicalReleased = 0
			where rcid = @o_rcid
			update mmresource set LogicalRelease = 0
			where reservationId = @reservationId
			goto exit_done
		end
	end
end
exit_done:
  RETURN @o_ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'RMBackupCachingReserve')
	delete from GxQscripts where name = 'RMBackupCachingReserve'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RMBackupCachingReserve')
	delete from GXDBVersions where aliasname = 'RMBackupCachingReserve'
GO

insert into GXDBVersions values(2, 'RMBackupCachingReserve',  '00010009019400040000', 'RMBackupCachingReserve', '00010009019400040000')
GO

