

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QscriptGetAppIdsFromNames.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QscriptGetAppIdsFromNames.sp,v $ $Id: QscriptGetAppIdsFromNames.sp,v 1.13.12.3.46.1 2021/04/01 15:07:06 cnaik Exp $";
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  Returns a AppId given five names
--
--  BEGIN
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QscriptGetAppIdsFromNames')
BEGIN
	print '>>> Drop Stored Procedure: QscriptGetAppIdsFromNames <<<'
	drop procedure QscriptGetAppIdsFromNames
END
IF EXISTS (select * from GxQscripts where name='QscriptGetAppIdsFromNames')
	delete from GxQscripts where name = 'QscriptGetAppIdsFromNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QscriptGetAppIdsFromNames')
	delete from GXDBVersions where aliasname = 'QscriptGetAppIdsFromNames'
GO
print '... Creating Procedure: QscriptGetAppIdsFromNames'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QscriptGetAppIdsFromNames
  @PARAM1 varchar(1030),
  @PARAM2 varchar(100),
  @PARAM3 varchar(1030),
  @PARAM4 varchar(1030),
  @PARAM5 varchar(1030),
  @SubclientId integer OUTPUT,
  @BackupsetId integer OUTPUT,
  @InstanceId integer OUTPUT,
  @ApptypeId integer OUTPUT,
  @ClientId integer OUTPUT,
  @errorString varchar(1024)  OUTPUT,
  @isSubclientOptional INT = 0
AS
	DECLARE @i_retCode integer
	SET @i_retCode =0
	--extracting names from input
	DECLARE @clientOption			varchar(10)
	SET		@clientOption			='c='
	DECLARE @apptypeOption			varchar(32)
	set		@apptypeOption			='a='
	DECLARE @instanceOption			varchar(32)
	set		@instanceOption			='i='
	DECLARE @backupsetOption		varchar(32)
	set		@backupsetOption		='b='
	DECLARE @subclientOption		varchar(32)
	set		@subclientOption		='s='
	DECLARE @clientName varchar(1024)
	DECLARE @appTypeName varchar(100)
	DECLARE @instanceName varchar(1024)
	DECLARE @backupsetName varchar(1024)
	DECLARE @subclientName varchar(1024)
--@PARAM1
	IF SUBSTRING(@PARAM1, 1, 2) = @clientOption
		SET @clientName  = (SELECT SUBSTRING(@PARAM1, 3, LEN(@PARAM1)-2))
  	ELSE
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter1 must be Client name beginning with c= . But it was ['+@PARAM1+'].'
		GOTO EXIT_ERR
	END
--@PARAM2
	IF SUBSTRING(@PARAM2, 1, 2) = @apptypeOption
		SET @appTypeName  = (SELECT SUBSTRING(@PARAM2, 3, LEN(@PARAM2)-2))
  	ELSE IF @isSubclientOptional=0 OR LEN(ISNULL(@PARAM2,''))>0 -- Return error only if hierarchy is mandatory which is default behaviour or invalid param is specified.
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter2 must be iDA name beginning with a= . But it was ['+@PARAM2+'].'
		GOTO EXIT_ERR
	END
--@PARAM3
	IF SUBSTRING(@PARAM3, 1, 2) = @instanceOption
	BEGIN
		SET @instanceName  = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
		SET @backupsetName = ''
	END
	ELSE IF SUBSTRING(@PARAM3, 1, 2) = @backupsetOption
	BEGIN
		SET @instanceName = ''
		SET @backupsetName  = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
	END
	ELSE IF SUBSTRING(@PARAM3, 1, 2) = @subclientOption
	BEGIN
		SET @instanceName = ''
		SET @backupsetName  = ''
		SET @subclientName = (SELECT SUBSTRING(@PARAM3, 3, LEN(@PARAM3)-2))
	END
  	ELSE IF @isSubclientOptional=0 OR LEN(ISNULL(@PARAM3,''))>0 -- Return error only if hierarchy is mandatory which is default behaviour or invalid param is specified.
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter3 must be Instance Name / Backupset Name / Subclient Name beginning with i= | b= | s= . But it was ['+@PARAM3+'].'
		GOTO EXIT_ERR
	END
--@PARAM4
	IF SUBSTRING(@PARAM4, 1, 2) = @backupsetOption
		SET @backupsetName  = (SELECT SUBSTRING(@PARAM4, 3, LEN(@PARAM4)-2))
	ELSE IF SUBSTRING(@PARAM4, 1, 2) = @subclientOption
	BEGIN
		SET @subclientName = (SELECT SUBSTRING(@PARAM4, 3, LEN(@PARAM4)-2))
	END
  	ELSE IF @subclientName IS NULL AND
		(@isSubclientOptional=0 OR LEN(ISNULL(@PARAM4,''))>0 ) -- Return error only if hierarchy is mandatory which is default behaviour or invalid param is specified.
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter4 must be Backupset Name / Subclient Name beginning with  b= | s= . But it was ['+@PARAM4+'].'
		GOTO EXIT_ERR
	END
--@PARAM5
	IF SUBSTRING(@PARAM5, 1, 2) = @subclientOption
		SET @subclientName = (SELECT SUBSTRING(@PARAM5, 3, LEN(@PARAM5)-2))
  	ELSE IF @subclientName IS NULL  --don't error out if it was seem earlier
	AND (@isSubclientOptional=0 OR LEN(ISNULL(@PARAM5,''))>0 ) -- Return error only if hierarchy is mandatory which is default behaviour or invalid param is specified.
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Parameter5 must be Subclient Name beginning with s= . But it was ['+@PARAM5+'].'
		GOTO EXIT_ERR
	END
	IF (@isSubclientOptional=1 AND @appTypeName IS NULL AND
		(@instanceName IS NOT NULL OR
		@backupsetName IS NOT NULL OR
		@subclientName IS NOT NULL )
	)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Application Type is not given but instance or backupset or subclient is provided.'
		GOTO EXIT_ERR
	END
--If all the inputs were fine then proceed otherwise abort here
	IF (@clientName IS NULL OR
		@appTypeName  IS NULL OR
		@instanceName IS NULL OR
		@backupsetName IS NULL OR
		@subclientName IS NULL) AND @isSubclientOptional=0
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. One or more of the inputs are incorrect Client ['+ @clientName + '], iDA ['+@apptypeName+'], Instance ['+ @instanceName + '], Backupset ['+ @backupsetName + '], Subclient ['+ @subclientName+'].'
		GOTO EXIT_ERR
	END
	ELSE
		PRINT 'Client ['+ ISNULL(@clientName,'') + '], iDA ['+ISNULL(@apptypeName,'')+'], Instance ['+ ISNULL(@instanceName,'') + '], Backupset ['+ ISNULL(@backupsetName,'') + '], Subclient ['+ ISNULL(@subclientName,'')+'].'
--Proceed to find the ids
	DECLARE @i_SubclientId integer = 0
	DECLARE @i_BackupsetId integer = 0
	DECLARE @i_InstanceId integer = 0
	DECLARE @i_ApptypeId integer = 0
	DECLARE @i_ClientId integer = 0
	SET @i_retCode = 0
	SET @errorString =''
	--Client Id
    SELECT @i_ClientId = id FROM APP_Client WHERE name = @clientName AND status & 2 <> 2 AND status & 4 <> 4
	IF(@i_ClientId = 0 OR @i_ClientId IS NULL)
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Client ['+ @clientName + '] does not exist'
		GOTO EXIT_ERR
	END
	IF (@appTypeName IS NOT NULL)
	BEGIN
IF @appTypeName = 'Q_FILESYSTEM'
BEGIN
	SELECT @i_ApptypeId = appTypeId FROM APP_IDAName WHERE clientId = @i_ClientId AND appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = (SELECT appTypeGroupId FROM APP_AppTypeGroup WHERE groupName = 'APPGRP_FileSystemIDA'))
END
ELSE
	--APPTYPE defined by QSDK:
    SELECT @i_ApptypeId =
        CASE @appTypeName
WHEN 'Q_WINDOWS_FS'THEN 33
WHEN 'Q_WINDOWS_FS_64'THEN 34
WHEN 'Q_WINNET_FS'THEN 42
WHEN 'Q_WINNET_FS_64'THEN 43
WHEN 'Q_SHAREPOINT_SERVER'THEN 78
WHEN 'Q_SHAREPOINT_SERVER'THEN 69
WHEN 'Q_MSEXCH_MB'THEN 54
WHEN 'Q_MSEXCH_DB'THEN 53
WHEN 'Q_MSEX_WEB'THEN 55
WHEN 'Q_MSEX_MIG'THEN 56
WHEN 'Q_MSEX_PUB'THEN 35
WHEN 'Q_FS'THEN 1
WHEN 'Q_WIN2K_FS'THEN 11
WHEN 'Q_NETWARE_FS'THEN 12
WHEN 'Q_HPUX64_FS'THEN 18
WHEN 'Q_SOLARIS64_FS'THEN 20
WHEN 'Q_AIX_FS'THEN 21
WHEN 'Q_HPUX_FS'THEN 17
WHEN 'Q_SOLARIS_FS'THEN 19
WHEN 'Q_LINUX_FS'THEN 29
WHEN 'Q_WINXP32_FS'THEN 33
WHEN 'Q_WINXP64_FS'THEN 34
WHEN 'Q_TRU64_FS_64'THEN 36
WHEN 'Q_TRU64_FS_32'THEN 38
WHEN 'Q_WINNET32_FS'THEN 42
WHEN 'Q_WINNET64_FS'THEN 43
WHEN 'Q_MAC_FS'THEN 63
WHEN 'Q_SGI_FS'THEN 64
WHEN 'Q_FREEBSD_FS'THEN 74
WHEN 'Q_WINFS_MIG'THEN 58
WHEN 'Q_UNIXFS_MIG'THEN 66
WHEN 'Q_ORACLE'THEN 22
WHEN 'Q_DB2'THEN 37
WHEN 'Q_UNIX_DB2'THEN 62
WHEN 'Q_INFORMIX'THEN 3
WHEN 'Q_MSSQLSERVER'THEN 4
WHEN 'Q_MSSQL_2K'THEN 16
WHEN 'Q_MSSQL_YUKON'THEN 70
WHEN 'Q_MSSQL'THEN 81
WHEN 'Q_SYBASE'THEN 5
WHEN 'Q_MSEX_MB'THEN 8
WHEN 'Q_MSEX2K_MB'THEN 14
WHEN 'Q_MSEX2003_MB'THEN 54
WHEN 'Q_MSEX_DB'THEN 9
WHEN 'Q_MSEX2K_DB'THEN 15
WHEN 'Q_MSEX2003_DB'THEN 53
WHEN 'Q_MSEX55_PUB'THEN 35
WHEN 'Q_MSEX2K_WEB'THEN 44
WHEN 'Q_MSEX2003_WEB'THEN 55
WHEN 'Q_MSEX_ARCH'THEN 67
WHEN 'Q_MSEX55_ARCH'THEN 68
WHEN 'Q_MSEX2K_MIG'THEN 45
WHEN 'Q_MSEX2003_MIG'THEN 56
WHEN 'Q_MSEX55_MIG'THEN 57
WHEN 'Q_LOTUS_DB'THEN 6
WHEN 'Q_LOTUS_UNIX_DB'THEN 51
WHEN 'Q_LOTUS_DOMINO_DB'THEN 59
WHEN 'Q_LOTUS6_DB'THEN 77
WHEN 'Q_LOTUS_DOC'THEN 7
WHEN 'Q_LOTUS_UNIX_DOC'THEN 52
WHEN 'Q_LOTUS_DOMINO_DOC'THEN 60
WHEN 'Q_SHAREPOINT_DB'THEN 69
WHEN 'Q_SHAREPOINT_DOC'THEN 78
WHEN 'Q_GROUPWISE'THEN 71
WHEN 'Q_NDS'THEN 10
WHEN 'Q_SDM_WIN2K'THEN 24
WHEN 'Q_SDM_UNIX'THEN 48
WHEN 'Q_SAP_ORADB'THEN 61
WHEN 'Q_SAP_SAPDB'THEN 79
WHEN 'Q_PROXYHOST'THEN 25
WHEN 'Q_PROXYHOST_UNIX'THEN 40
WHEN 'Q_ACTIVEDIR'THEN 41
WHEN 'Q_IMAGELEVEL_WIN'THEN 65
WHEN 'Q_IMAGELEVEL_UNIX'THEN 75
WHEN 'Q_IMAGELEVEL_PROXY'THEN 76
WHEN 'Q_NETSTORAGE_MIG'THEN 73
WHEN 'Q_NAS'THEN 13
WHEN 'Q_REPLICATION'THEN 47
WHEN 'Q_REPLICATION_UNIX'THEN 50
WHEN 'Q_MSEXPF_MIG'THEN 82
WHEN 'Q_ORACLE_RAC'THEN 80
WHEN 'Q_NETWARE_MIG'THEN 83
WHEN 'Q_FILE_REPLICATION'THEN 84
WHEN 'Q_DATA_CLASSIFICATION'THEN 85
WHEN 'Q_NETWARE_LINUX'THEN 86
WHEN 'Q_PROXYHOST_IMAGE_UNIX'THEN 87
WHEN 'Q_CENTERA'THEN 88
WHEN 'Q_SHAREPOINT_ARCH'THEN 89
WHEN 'Q_LOTUS_DOC_MIG'THEN 90
WHEN 'Q_DPM_AGENT'THEN 91
WHEN 'Q_DB2_DPF'THEN 103
WHEN 'Q_MYSQL'THEN 104
WHEN 'Q_VIRTUAL_SERVER'THEN 106
WHEN 'Q_POSTGRESS' THEN 125
            ELSE 0
		END
		IF((SELECT count(id) FROM app_idaname WHERE clientId = @i_clientId AND AppTypeId = @i_AppTypeId AND status & 2 <> 2 AND status & 4 <> 4) < 1)
			SET @i_AppTypeId = 0
		IF(@i_AppTypeId = 0 OR @i_ApptypeId IS NULL)
		BEGIN
			SET @i_retCode = 1
			SET @errorString = 'Error. AppType ['+ @apptypeName + '] does not exist on Client ['+ @clientName+'].'
			GOTO EXIT_ERR
		END
	END
	--@InstanceId, @BackupsetId and subclientid
	IF 	(@i_ApptypeId>0 AND @subclientName IS NOT NULL )
	BEGIN
	IF @instanceName IS NULL
		SET @instanceName = ''
	IF @backupsetName IS NULL
		SET @backupsetName = ''
	IF @subclientName IS NULL
		SET @subclientName = ''
	--All five names are given
	if(@instanceName <> '' AND @backupsetName <> '')
		SELECT  @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND INS.name = @instanceName AND BS.name = @backupsetName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
    ELSE if(@instanceName = '' AND @backupsetName <> '')
   		SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND BS.name = @backupsetName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	ELSE if(@instanceName <> ''AND @backupsetName = '')
		SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND INS.name = @instanceName AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
    ELSE --only apptype and subclient given
    	SELECT @i_InstanceId = INS.id, @i_BackupsetId = BS.id, @i_subclientId = APP.id
		FROM APP_InstanceName INS LEFT JOIN APP_Application APP ON INS.id = APP.instance
			LEFT JOIN APP_BackupsetName BS ON APP.backupset = BS.id
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND APP.subclientname = @subclientName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND BS.status & 2 <> 2 AND BS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	IF @@ROWCOUNT > 1
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Ambiguous input Instance ['+ ISNULL(@instanceName,'') + '] Backupset ['+ ISNULL(@backupsetName,'') + '] Subclient ['+ ISNULL(@subclientName,'')+'] for Client ['+@clientName+'] and iDA ['+@apptypeName+'].'
		GOTO EXIT_ERR
	END
	END
	IF (@i_ApptypeId>0 AND @instanceName IS NOT NULL AND @subclientName IS NULL  )
	BEGIN
		SELECT @i_InstanceId = INS.id
		FROM APP_InstanceName INS INNER JOIN APP_Application APP ON INS.id = APP.instance
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND INS.name = @instanceName
			  AND INS.status & 2 <> 2 AND INS.status & 4 <> 4 AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	END
	IF (@i_ApptypeId>0 AND @backupsetName IS NOT NULL AND @subclientName IS NULL  )
	BEGIN
		SELECT @i_BackupsetId = BS.id, @i_InstanceId = App.instance
		FROM APP_BackupsetName BS INNER JOIN APP_Application APP ON BS.id = APP.backupset
		WHERE APP.clientId = @i_ClientId AND APP.apptypeId = @i_AppTypeId AND BS.name = @backupsetName
			  AND (APP.instance = @i_InstanceId OR @i_InstanceId = 0)
			  AND BS.status & 2 <> 2 AND BS.status & 4 <> 4
			  AND APP. subclientstatus & 2 <> 2 AND APP.subclientstatus & 4 <> 4
	END
	IF(@i_InstanceId = 0 AND LEN(ISNULL(@instanceName,''))>0 )
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Instance ['+ ISNULL(@instanceName,'') + '] incorrect for Client ['+@clientName+'] and iDA ['+@apptypeName+'].'
		GOTO EXIT_ERR
	END
	IF(@i_BackupsetId = 0 AND LEN(ISNULL(@backupsetName,''))>0 )
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Backupset ['+ ISNULL(@backupsetName,'') + '] incorrect for Client ['+@clientName+'] , iDA ['+@apptypeName+'] and instance ['+ISNULL(@instanceName,'')+'].'
		GOTO EXIT_ERR
	END
	IF(@i_subclientId = 0 AND LEN(ISNULL(@subclientName,''))>0 )
	BEGIN
		SET @i_retCode = 1
		SET @errorString = 'Error. Subclient ['+ ISNULL(@subclientName,'')+']  incorrect for Client ['+@clientName+'] , iDA ['+@apptypeName+'] , instance ['+ISNULL(@instanceName,'')+'] and backupset ['+ISNULL(@backupsetName,'')+'].'
		GOTO EXIT_ERR
	END
EXIT_ERR:
    SELECT 	@SubclientId = @i_SubclientId, @BackupsetId = @i_BackupsetId, @InstanceId = @i_InstanceId, @ApptypeId  = @i_ApptypeId, @ClientId = @i_ClientId
	RETURN @i_retCode
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  END
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+


IF EXISTS (select * from GxQscripts where name = 'QscriptGetAppIdsFromNames')
	delete from GxQscripts where name = 'QscriptGetAppIdsFromNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QscriptGetAppIdsFromNames')
	delete from GXDBVersions where aliasname = 'QscriptGetAppIdsFromNames'
GO

insert into GXDBVersions values(2, 'QscriptGetAppIdsFromNames',  'v1.13.12.3.46.1', 'QscriptGetAppIdsFromNames', 'v1.13.12.3.46.1')
GO

