

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Qs_SAPArchiveMigration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Qs_SAPArchiveMigration <<<'

IF EXISTS (select * from sysobjects where name='Qs_SAPArchiveMigration')
	drop procedure Qs_SAPArchiveMigration
IF EXISTS (select * from GxQscripts where name='Qs_SAPArchiveMigration')
	delete from GxQscripts where name = 'Qs_SAPArchiveMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Qs_SAPArchiveMigration')
	delete from GXDBVersions where aliasname = 'Qs_SAPArchiveMigration'
GO
print '... Creating Procedure: Qs_SAPArchiveMigration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Qs_SAPArchiveMigration
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @inSAPSubclientId INT,
  @inObjectStoreSubclientId INT,
  @inRootGUID NVARCHAR(64)
AS
SET NOCOUNT ON
DECLARE @outErrorCode INT = 0
DECLARE @outErrorString NVARCHAR(MAX) = 'Success'
DECLARE @startedTran INT = 0
BEGIN TRY
IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @inSAPSubclientId)
BEGIN
       SET @outErrorCode = 1
       SET @outErrorString = 'Provided SAP subclient does not exist'
       RAISERROR (@outErrorString, 16, 1)
END
IF NOT EXISTS(SELECT 1 FROM APP_Application WHERE id = @inObjectStoreSubclientId)
BEGIN
       SET @outErrorCode = 2
       SET @outErrorString = 'Provided Object store subclient does not exist'
       RAISERROR (@outErrorString, 16, 1)
END
IF (@@TRANCOUNT = 0)
BEGIN
    BEGIN TRANSACTION SAPMIG
    SET @startedTran = 1
END
DECLARE @tempAppId TABLE
(id INT, newId INT, clientId INT, appTypeId INT, instance INT, backupSet INT, subClientName NVARCHAR(MAX), subclientStatus INT)
INSERT INTO @tempAppId
SELECT id,
              (CASE
                     WHEN id = @inSAPSubclientId THEN @inObjectStoreSubclientId
                     ELSE @inSAPSubclientId
              END),
              clientId, appTypeId, instance, backupSet, subclientName, subclientStatus
FROM APP_Application
WHERE id in (@inSAPSubclientId, @inObjectStoreSubclientId)
-- Move subclients
UPDATE APP
SET APP.clientId = T.clientId,
       APP.appTypeId = T.appTypeId,
       APP.instance = T.instance,
       APP.backupSet = T.backupSet,
       APP.subclientName = T.subClientName,
       APP.subclientStatus = T.subclientStatus
FROM APP_Application APP
INNER JOIN @tempAppId T ON APP.id = T.newId
-- Move subclient props
UPDATE SP
SET componentNameId = T.newId
FROM APP_SubClientProp SP
INNER JOIN @tempAppId T ON Sp.componentNameId = T.id
-- Move SAP site configuration
UPDATE S
SET subClientId = T.newId
FROM App_Sites S
INNER JOIN @tempAppId T ON S.subClientId = T.id
-- Move sync configuration
UPDATE App_SyncCloudConfig
SET subclientId = @inSAPSubclientId
WHERE subclientId = @inObjectStoreSubclientId
UPDATE App_SyncCloudStats
SET sourceSubclientId = @inSAPSubclientId
WHERE sourceSubclientId = @inObjectStoreSubclientId
-- Set new root GUID
IF @inRootGUID <> '' AND @inRootGUID IS NOT NULL
BEGIN
    UPDATE App_SyncCloudConfig
    SET syncPath = @inRootGUID
    WHERE subclientId = @inSAPSubclientId
END
-- Move User Security
UPDATE UMSecurityAssociations
SET entityId5 = T.newId
FROM UMSecurityAssociations UMS
INNER JOIN @tempAppId T ON UMS.entityId5 = T.id
IF @startedTran = 1
BEGIN
       COMMIT TRAN SAPMIG
       SET @startedTran = 0
END
SELECT N'Query executed successfully.'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0 AND @startedTran = 1)
    BEGIN
        ROLLBACK TRANSACTION SAPMIG
              SET  @startedTran = 0
    END
	IF @outErrorCode = 0
        SELECT @outErrorCode = -1, @outErrorString = 'Failed to migrate SAP subclient.'
	RAISERROR (@outErrorString, 16, 1)
END CATCH
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Qs_SAPArchiveMigration')
	delete from GxQscripts where name = 'Qs_SAPArchiveMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Qs_SAPArchiveMigration')
	delete from GXDBVersions where aliasname = 'Qs_SAPArchiveMigration'
GO

insert into GXDBVersions values(2, 'Qs_SAPArchiveMigration',  '00000000000000000000', 'Qs_SAPArchiveMigration', '00000000000000000000')
GO

insert into GxQscripts values(2,'Qs_SAPArchiveMigration',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn Qs_SAPArchiveMigration -si <SAP Subclient> -si <Object Store Subclient Id> -si <RootGUID>'
 + CHAR(10) + '--  -  This QScript can be used to migrate the SAP Archive link subclient to Object store. Both the subclients will be interchanged in database and root GUID will be updated.'
)
GO

