

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Qs_AssociateVMsToPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Qs_AssociateVMsToPolicy <<<'

IF EXISTS (select * from sysobjects where name='Qs_AssociateVMsToPolicy')
	drop procedure Qs_AssociateVMsToPolicy
IF EXISTS (select * from GxQscripts where name='Qs_AssociateVMsToPolicy')
	delete from GxQscripts where name = 'Qs_AssociateVMsToPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Qs_AssociateVMsToPolicy')
	delete from GXDBVersions where aliasname = 'Qs_AssociateVMsToPolicy'
GO
print '... Creating Procedure: Qs_AssociateVMsToPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Qs_AssociateVMsToPolicy
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @VMPolicy1 NVARCHAR(MAX) ='',
  @VMPolicy2 NVARCHAR(MAX) =''
AS
SET NOCOUNT ON
DECLARE @lastError INT = 0
DECLARE @ToPolicyId INT
DECLARE @FromPolicyId INT
DECLARE @ToPolicyVendorType INT
DECLARE @FromPolicyVendorType INT
DECLARE @TovDataCenterId INT
DECLARE @FromvDataCenterId INT
SET @VMPolicy1 = ISNULL(LTRIM(RTRIM(@VMPolicy1)),'')
SET @VMPolicy2 = ISNULL(LTRIM(RTRIM(@VMPolicy2)),'')
BEGIN TRY
	IF @VMPolicy1 = ''
	BEGIN
		SET @lastError = 1
	    RAISERROR ('Incorret usage.', 16, 1);
	END
    IF NOT EXISTS(SELECT * FROM App_VMAllocationPolicy WHERE name = @VMPolicy1)
	BEGIN
		SET @lastError = 1
        RAISERROR ('The VM Allocation policy 1: %s doesn''t exist.', 16, 1, @VMPolicy1 );
	END
    IF @VMPolicy2 = '' -- Check if paramter 2 is set or not, if not then assign all orphan VMs(those who belog to same vendor as of policy and which are not templates) to policy 1.
    BEGIN
        SET @ToPolicyId = (SELECT id FROM App_VMAllocationPolicy WHERE name = @VMPolicy1)
        SET @FromPolicyId = (SELECT id FROM App_VMAllocationPolicy WHERE flags = 1)
		SELECT @ToPolicyVendorType = CAST(attrVal AS INT), @TovDataCenterId = VMP.vDataCenterId from App_VmAllocationPolicy VMP
			INNER JOIN App_VMDataCenterMap D
				ON VMP.vDataCenterId = D.vDataCenterId AND VMP.id = @ToPolicyId
			 INNER JOIN APP_InstanceProp I
				ON D.instanceId = I.componentNameId AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
        UPDATE VM
        SET vmAllocationPolicyId = @ToPolicyId
		FROM App_VM VM
		CROSS APPLY VM.vxml.nodes('/QSMServer_QVirtualMachineReq') v(n)
		inner join App_VMHost VH
			ON VH.id = VM.vHostId
        WHERE vmAllocationPolicyId IN (0, @FromPolicyId) AND v.n.value('@vendorType','INTEGER') = @ToPolicyVendorType AND ISNULL(v.n.value('@isTemplate','INTEGER'),0) = 0
			AND (v.n.value('@vendorType','INTEGER') NOT IN (101,102)  OR (v.n.value('@vendorType','INTEGER') IN (101,102) AND VH.vDataCenterId = @TovDataCenterId)) -- 101: VMWare, 102: Hyper-V Aand vCenter check is just for VMWare and Hyper, not for other vendors as we want to associate only those VMs to policy which were created on same vCenter which is used by policy
    END
    ELSE
    BEGIN
        IF NOT EXISTS(SELECT * FROM App_VMAllocationPolicy WHERE name = @VMPolicy2)
            RAISERROR ('The VM Allocation policy 2: %s doesn''t exist.', 16, 1, @VMPolicy2 );
        SET @ToPolicyId = (SELECT id FROM App_VMAllocationPolicy WHERE name = @VMPolicy2)
        SET @FromPolicyId = (SELECT id FROM App_VMAllocationPolicy WHERE name = @VMPolicy1)
		SELECT @FromPolicyVendorType = CAST(attrVal AS INT), @FromvDataCenterId = VMP.vDataCenterId from App_VmAllocationPolicy VMP
			INNER JOIN App_VMDataCenterMap D
				ON VMP.vDataCenterId = D.vDataCenterId AND VMP.id = @FromPolicyId
			 INNER JOIN APP_InstanceProp I
				ON D.instanceId = I.componentNameId AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
		SELECT @ToPolicyVendorType = CAST(attrVal AS INT), @TovDataCenterId = VMP.vDataCenterId from App_VmAllocationPolicy VMP
			INNER JOIN App_VMDataCenterMap D
				ON VMP.vDataCenterId = D.vDataCenterId AND VMP.id = @ToPolicyId
			 INNER JOIN APP_InstanceProp I
				ON D.instanceId = I.componentNameId AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
		IF @FromPolicyVendorType <> @ToPolicyVendorType
            RAISERROR ('The two mentioned VM Allocation policies belong to different vendors.', 16, 1 );
		IF @FromPolicyVendorType IN (101, 102) AND @FromvDataCenterId <> @TovDataCenterId
            RAISERROR ('The two mentioned VM Allocation policies have different vCenters', 16, 1 );
        UPDATE App_VM
        SET vmAllocationPolicyId = @ToPolicyId
        WHERE vmAllocationPolicyId = @FromPolicyId
    END
    SELECT N'Query executed successfully.'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
    DECLARE @ErrorMessage NVARCHAR(4000) = ''
    DECLARE @ErrorSeverity INT
    DECLARE @ErrorState INT
	IF (@lastError = 1 )
    BEGIN
        SELECT usage FROM GxQscripts
        WHERE name = 'Qs_AssociateVMsToPolicy'
    END
    SELECT
        @ErrorMessage = 'Failed to associate . ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
    RAISERROR (@ErrorMessage, @ErrorSeverity, @ErrorState);
END CATCH
Set NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Qs_AssociateVMsToPolicy')
	delete from GxQscripts where name = 'Qs_AssociateVMsToPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Qs_AssociateVMsToPolicy')
	delete from GXDBVersions where aliasname = 'Qs_AssociateVMsToPolicy'
GO

insert into GXDBVersions values(2, 'Qs_AssociateVMsToPolicy',  '00000000000000000000', 'Qs_AssociateVMsToPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2,'Qs_AssociateVMsToPolicy',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '--  qoperation execscript -sn Qs_AssociateVMsToPolicy -si @VMPolicy1 = ''FromVMPolicyName'' -si @VMPolicy2 = ''ToVMPolicyName'' '
 + CHAR(10) + '--  -  This QScript can be used to assign a particular VM Allocation policy to all Orphan VMs (which have same vendor as the allocation policy) or to the VMs allocated under different policy.'
 + CHAR(10) + '--  -  If only first policy name is mentioned and second parameter is left empty, then all Orphan VMs, which have the same vendor as the policy, will be associated to  "FromVMPolicyName" VM Allocation Policy.'
 + CHAR(10) + '--  -  If both policy names are mentioned, then all VMs associated to policy1 will be assigned to policy2 i.e. from "FromVMPolicyName" to "ToVMPolicyName"'
)
GO

