

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QlistClient.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QlistClient <<<'

IF EXISTS (select * from sysobjects where name='QlistClient')
	drop procedure QlistClient
IF EXISTS (select * from GxQscripts where name='QlistClient')
	delete from GxQscripts where name = 'QlistClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QlistClient')
	delete from GXDBVersions where aliasname = 'QlistClient'
GO
print '... Creating Procedure: QlistClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QlistClient
  @userId integer,
  @clientName nvarchar(100)=N'',
  @clientGroupName nvarchar(100)=N'',
  @allClients integer = 0,
  @entityInfo XML
AS
  DECLARE @outXML XML 
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @errorCode integer=0
DECLARE @clientTbl TABLE (
							clientId integer,
						    --clientName nvarchar(MAX_ENTITY_SIZE), change it to match size of column till we fix MAX_ENTITY_SIZE everywhere
							clientName nvarchar(512),
						    osType nvarchar(10),
osName nvarchar(100),
						    isUninstalled integer,
						    releaseId integer
						  )
DECLARE @entityInput TABLE ( name nvarchar(100))
DECLARE @clientGroupId integer
DECLARE @clientList TABLE (clientId integer)
-- GET ALL CLIENTS OLD BEHAVIOR
IF @allClients <> 0
BEGIN
	INSERT INTO @clientTbl
	SELECT C.id, C.name, OS.type , OS.name,( case (C.status & 2)
	when 2 then 1
	else 0
	end),C.releaseId
	from APP_CLIENT C, simOperatingSystem OS,APP_Platform P
	where OS.id = C.simOperatingSystemId and
	P.clientId = C.id and P.platformType =4
	and C.id <> 1
	goto PROCESSSP
END
--FAST LOOKUP
IF @clientName <> N''
BEGIN
	INSERT INTO @clientTbl
	SELECT C.id, C.name, OS.type , OS.name,( case (C.status & 2)
	when 2 then 1
	else 0
	end),C.releaseId
	from APP_CLIENT C, simOperatingSystem OS,APP_Platform P
	where OS.id = C.simOperatingSystemId and
	 C.name = @clientName and P.clientId = C.id and P.platformType =4
	IF (SELECT COUNT(*) FROM @clientTbl) <> 1
	BEGIN
SET @errorCode = 0x303
		goto ENDSP
	END
END
--FAST LOOKUP
IF @clientGroupName <> N''
BEGIN
	SET @clientGroupId = ISNULL((select id from APP_ClientGroup where name = @clientGroupName),0)
	IF (@clientGroupId = 0)
	BEGIN
SET @errorCode = 0x303
		goto ENDSP
	END
	INSERT INTO @clientList
	select clientId from APP_ClientGroupAssoc where clientGroupId = @clientGroupId
	INSERT INTO @clientTbl
	SELECT C.id, C.name, OS.type , OS.name,( case (C.status & 2)
	when 2 then 1
	else 0
	end),C.releaseId
	from APP_CLIENT C, simOperatingSystem OS, @clientList CI,App_Platform P
	WHERE CI.clientId  = C.ID and OS.id = C.simOperatingSystemId and P.platformType =4
	and P.clientId = CI.clientId
END
-- MULTIPLE CLIENTS CLIENTS OR/AND CLIENTGROUP
IF @entityInfo.exist('/App_Associations/entity') = 1
BEGIN
	INSERT INTO @entityInput
	SELECT  ref.value('@clientName', 'nvarchar(100)') AS Client
	FROM    @entityInfo.nodes('/App_Associations/entity') R ( ref )
	INSERT INTO @clientList
	SELECT C.id
	FROM @entityInput E,APP_CLIENT C
	WHERE C.name = E.name
	DELETE @entityInput
	INSERT INTO @entityInput
	SELECT  ref.value('@clientGroupName', 'nvarchar(100)') AS Client
	FROM    @entityInfo.nodes('/App_Associations/entity') R ( ref )
	INSERT INTO @clientList
	SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId IN
	(SELECT id FROM APP_CLIENTGROUP CG,@entityInput E
		WHERE E.name = CG.name)
	INSERT INTO @clientTbl
	SELECT DISTINCT C.id, C.name, OS.type , OS.name,( case (C.status & 2)
	when 2 then 1
	else 0
	end),C.releaseId
	from APP_CLIENT C, simOperatingSystem OS, @clientList CI,App_Platform P
	WHERE CI.ClientId = C.ID and OS.id = C.simOperatingSystemId and P.platformType=4
	and P.clientId = C.ID
END
PROCESSSP:
if (@userId <> 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getIdaObjectsForUser') IS NOT NULL
		DROP TABLE #getIdaObjectsForUser
	CREATE TABLE #getIdaObjectsForUser (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
	EXEC sec_getIdaObjectsForUser @userId, 3, 0, 1, '#getIdaObjectsForUser'
	DELETE Tbl
	FROM @clientTbl Tbl
	WHERE NOT EXISTS (SELECT 1 FROM #getIdaObjectsForUser Tmp WHERE Tmp.clientId = Tbl.clientId)
	DROP TABLE #getIdaObjectsForUser
END
--Check for client package installed on the client
--DELETE FROM @clientTbl
--WHERE clientId NOT IN (SELECT PT.clientId FROM APP_Platform PT WITH (NOLOCK) WHERE platformType = 4)
--Delete the physical client IDs of the cluster CS
DELETE FROM @clientTbl
WHERE clientId IN (SELECT VMPM.PMClientId FROM APP_VmToPMMap VMPM WITH (NOLOCK) WHERE VMPM.VMClientId = 2)
ENDSP:
SELECT @outXML = (SELECT
					(
						SELECT @errorCode as errorCode
						FOR XML PATH('error'),TYPE
					),
					(
						SELECT DISTINCT
						   clientId,
						   clientName,
						   osType,
						   osName,
						   isUninstalled,
						   releaseId
						  FROM @clientTbl
						  FOR XML PATH('clients'),TYPE
					)
					FOR XML PATH(''),
					ROOT('GalaxyUtilities_QGetClientsRespMsg')
				)
SELECT @outXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QlistClient')
	delete from GxQscripts where name = 'QlistClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QlistClient')
	delete from GXDBVersions where aliasname = 'QlistClient'
GO

insert into GXDBVersions values(2, 'QlistClient',  '00000000000000000000', 'QlistClient', '00000000000000000000')
GO

