

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_updateUserGroupUserPropertiesCap.sp] ---------- 

-------------------------------------------
--         Name:   QS_updateUserGroupUserPropertiesCap.sql
--  Description:   Update "cloud Capabilities" property for a user or a user group
-------------------------------------------
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_updateUserGroupUserPropertiesCap')
BEGIN
	print '>>> Drop Stored Procedure: QS_updateUserGroupUserPropertiesCap <<<'
	drop procedure QS_updateUserGroupUserPropertiesCap
END
IF EXISTS (select * from GxQscripts where name='QS_updateUserGroupUserPropertiesCap')
	delete from GxQscripts where name = 'QS_updateUserGroupUserPropertiesCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateUserGroupUserPropertiesCap')
	delete from GXDBVersions where aliasname = 'QS_updateUserGroupUserPropertiesCap'
GO
print '... Creating Procedure: QS_updateUserGroupUserPropertiesCap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_updateUserGroupUserPropertiesCap
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @i_entityName NVARCHAR(MAX) = N'',
  @i_attrName NVARCHAR(MAX) = N'',
  @i_attrVal NVARCHAR(MAX) = N'',
  @i_operation NVARCHAR(MAX) = N'',
  @i_attrType INT = 7
AS
Set NOCOUNT ON
------------------------  Convenience Definitions --------------------------
DECLARE @scriptName NVARCHAR(MAX)
SET		@scriptName = N'QS_updateUserGroupUserPropertiesCap'
DECLARE @lastError INT
SET @lastError = 0
DECLARE	@localErrorMsg NVARCHAR(MAX)
SET		@localErrorMsg = N'Error encountered when running script'
DECLARE @NoParameter NVARCHAR(10)
SET		@NoParameter = N''
---------------------- Local Variables    ------------------------
DECLARE @iUserId	INT = 0
DECLARE @iUserGroupId	INT = 0
DECLARE @iCapability INT = 0
DECLARE @i_userName  nvarchar(1024)= ''
DECLARE @i_userGroupName  nvarchar(1024) = ''
DECLARE @userOption           varchar(10)
SET     @userOption           ='u='
DECLARE @userGroupOption           varchar(10)
SET     @userGroupOption           ='ug='
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF (@i_entityName = @NoParameter)
BEGIN
	SET @localErrorMsg	='User Name or User Group name not passed. One of these parameters is required.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF (@i_attrName = @NoParameter)
BEGIN
	SET @localErrorMsg	='Attribute name parameter is required.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
 IF @i_attrVal = @noParameter --if i_capability is not passed
    BEGIN
		SET @localErrorMsg = N'Attribute value parameter is required.'
		SET @lastError = 1
		goto   ARGS_ERROR
    END
IF (@i_attrName = 'Cloud Capabilities') --FOR Cloud Capabilities validate the capabilities
BEGIN
	IF @i_attrVal = 'COMMCELLCONSOLE'
		SET @iCapability = 1
	ELSE IF @i_attrVal = 'DOCUMENTATION'
		SET @iCapability = 2
	ELSE IF @i_attrVal = 'EDC'
		SET @iCapability = 3
	ELSE IF @i_attrVal = 'SURVEY'
		SET @iCapability = 4
	ELSE IF @i_attrVal = 'CONFIGURATIONREQUEST'
		SET @iCapability = 5
	ELSE IF @i_attrVal = 'HIDEDOWNLOAD'
		SET @iCapability = 6
	ELSE IF @i_attrVal = 'HIDESYNC'
		SET @iCapability = 7
	ELSE IF @i_attrVal = 'GENERATEAUTHCODE'
		SET @iCapability = 8
	ELSE
	BEGIN
			SET @localErrorMsg = N'Incorrect capability specified: ' + @i_attrVal
			SET @lastError = 1
			goto   ARGS_ERROR
	END
END
IF (@i_attrName = 'cvFeature Capabilities') --FOR cvFeature Capabilities validate the capabilities
BEGIN
	IF @i_attrVal = 'COLLABORATIVESHARE'
		SET @iCapability = 14
	ELSE IF @i_attrVal = 'STORAGEREPLICATION'
		SET @iCapability = 10
	ELSE IF @i_attrVal = 'HIDESOFTWARESTORE'
		SET @iCapability = 16
	ELSE IF @i_attrVal = 'HIDEAPPBUILDER'
		SET @iCapability = 17
	ELSE
	BEGIN
			SET @localErrorMsg = N'Incorrect capability specified: ' + @i_attrVal
			SET @lastError = 1
			goto   ARGS_ERROR
	END
END
IF (@i_attrName = 'Cloud Capabilities' OR @i_attrName = 'cvFeature Capabilities') and (@i_operation <> N'add' AND @i_operation <> N'remove')
     BEGIN
		SET @localErrorMsg = N'operation parameter should be add or remove: ' + @i_operation
		SET @lastError = 1
		goto   ARGS_ERROR
   END
BEGIN TRY
	DECLARE @addUserLevelProperty int = 0
	DECLARE @addUserGroupLevelProperty int = 0
	 IF SUBSTRING(@i_entityName, 1, 2) = @userOption
			SET @i_userName  = (SELECT SUBSTRING(@i_entityName, 3, LEN(@i_entityName)-2))
	 IF SUBSTRING(@i_entityName, 1, 3) = @userGroupOption
			SET @i_userGroupName  = (SELECT SUBSTRING(@i_entityName, 4, LEN(@i_entityName)-3))
	IF(@i_userName = '' AND @i_userGroupName = '')
	 BEGIN
			SET @localErrorMsg = N'User Name or User Group name not passed. One of these parameters is required.'
			SET @lastError = 1
			goto   ARGS_ERROR
		END
	-- Check User
	IF(@i_userName <> '')
	BEGIN
		SET @iUserId = ISNULL((SELECT id FROM UMUsers WHERE login = @i_userName and flags & 0x001  <> 0 and flags & ( CAST (0x200   AS INT) | CAST (0x004  AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT))  = 0  ), 0)
		IF @iUserId = 0
		BEGIN
			SET @localErrorMsg = 'Cannot find user [' + @i_userName + '] in CS DB'
			SET	@lastError =1
			goto   ARGS_ERROR
		END
		ELSE
			SET @addUserLevelProperty = 1
	END
	-- Check User Group
	IF(@i_userGroupName <> '')
	BEGIN
		--Now check whether it is normal group or AD group.
		DECLARE @deLimiter INTEGER = CHARINDEX('\',@i_userGroupName)
		DECLARE @providerId INTEGER = 0
		IF(@deLimiter <> 0)
		BEGIN
			DECLARE @providerName NVARCHAR(MAX) = SUBSTRING(@i_userGroupName,1,@deLimiter-1)
			SET @providerId = ISNULL((SELECT id FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @providerName),0)
			IF(@providerId = 0)
			BEGIN
				SET @localErrorMsg = 'Cannot find domain name [' + @providerName + '] in CS DB'
				SET	@lastError =1
				goto   ARGS_ERROR
			END
			SET @i_userGroupName = SUBSTRING(@i_userGroupName,@deLimiter+1,len(@i_userGroupName))
		END
	SET @iUserGroupId = ISNULL((SELECT id FROM UMGroups WHERE name = @i_userGroupName and groupFlags & 0x0002= 0 AND (@providerId = 0 OR umdsProviderId=@providerId)), 0)
	IF @iUserGroupId = 0
		BEGIN
			SET @localErrorMsg = 'Cannot find user group [' + @i_userGroupName + '] in CS DB'
			SET	@lastError =1
			goto   ARGS_ERROR
		END
		ELSE
			SET @addUserGroupLevelProperty = 1
	END
	------------------------------------------------
	--- END CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
	------------------------------------------------
	-- MOFIFY THE ATTRBUTE NAME FOR ENABLING TFA WITH USER GROUP INCLUSION, BECAUSE WE HAVE REPLACED PROPERTY 'AddTwoFactorAuthentication' with 'DisableTwoFactorAuthentication' FOR THIS FEATURE
IF @i_attrName = 'AddTwoFactorAuthentication'
	BEGIN
SET @i_attrName = 'DisableTwoFactorAuthentication'
		 SET @i_attrVal = (CASE WHEN @i_attrVal = '1' THEN '0' ELSE '1' END)
	END
	BEGIN TRAN
	IF (@i_attrName = 'Cloud Capabilities' OR @i_attrName = 'cvFeature Capabilities')
	BEGIN
		DECLARE @maskForNewFeature INT = POWER( 2, @iCapability - 1)
		IF(@addUserGroupLevelProperty=1) --User group properties
		BEGIN
			IF EXISTS(SELECT 1 FROM UMGroupsProp WHERE componentNameId = @iUserGroupId AND modified = 0 AND attrName=@i_attrName)
			BEGIN
			IF(@i_operation = 'add') --Add capability
			UPDATE UMGroupsProp SET attrval = attrval |@maskForNewFeature WHERE componentNameId = @iUserGroupId AND modified = 0 AND attrName=@i_attrName
			ELSE IF(@i_operation = 'remove')--remove capability
			UPDATE UMGroupsProp SET attrval = attrval & ~@maskForNewFeature WHERE componentNameId = @iUserGroupId AND modified = 0 AND attrName=@i_attrName
			END
			ELSE IF(@i_operation = 'add')
			INSERT INTO UMGroupsProp VALUES (@iUserGroupId,@i_attrName,@i_attrType,@maskForNewFeature,dbo.GetUnixTime(getutcdate()),0)
		END
		IF(@addUserLevelProperty = 1)--user properties
		BEGIN
			IF EXISTS(SELECT 1 FROM UMUsersProp WHERE componentNameId = @iUserId AND modified = 0 AND attrName=@i_attrName)
			BEGIN
			if(@i_operation = 'add') --Add capability
			UPDATE UMUsersProp SET attrval = attrval |@maskForNewFeature WHERE componentNameId = @iUserId AND modified = 0 AND attrName=@i_attrName
			ELSE IF(@i_operation = 'remove')--remove capability
			UPDATE UMUsersProp SET attrval = attrval & ~@maskForNewFeature WHERE componentNameId = @iUserId AND modified = 0 AND attrName=@i_attrName
			END
			ELSE IF(@i_operation = 'add')
			INSERT INTO UMUsersProp VALUES (@iUserId,@i_attrName,@i_attrType,@maskForNewFeature ,dbo.GetUnixTime(getutcdate()),0)
		END
	END
	ELSE --NOT CLOUD CAPABILITES
	BEGIN
		IF(@addUserGroupLevelProperty=1)-- user group properties
		BEGIN
			IF EXISTS(SELECT 1 FROM UMGroupsProp WHERE componentNameId = @iUserGroupId AND modified = 0 AND attrName=@i_attrName)
			BEGIN
				UPDATE UMGroupsProp SET attrval = @i_attrVal WHERE componentNameId = @iUserGroupId AND modified = 0 AND attrName=@i_attrName
			END
			ELSE
				INSERT INTO UMGroupsProp VALUES (@iUserGroupId,@i_attrName,@i_attrType,@i_attrVal,dbo.GetUnixTime(getutcdate()),0)
		END
		IF(@addUserLevelProperty = 1)-- user properties
		BEGIN
			IF EXISTS(SELECT 1 FROM UMUsersProp WHERE componentNameId = @iUserId AND modified = 0 AND attrName=@i_attrName)
			BEGIN
			UPDATE UMUsersProp SET attrval = @i_attrVal WHERE componentNameId = @iUserId AND modified = 0 AND attrName=@i_attrName
			END
			ELSE
			INSERT INTO UMUsersProp VALUES (@iUserId,@i_attrName,@i_attrType,@i_attrVal ,dbo.GetUnixTime(getutcdate()),0)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END
END CATCH
ARGS_ERROR:
IF @lastError  = 0
BEGIN
	COMMIT  Tran
END
ELSE
BEGIN
	IF @@TRANCOUNT > 0
	BEGIN
		ROLLBACK Tran
	END
END
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: entityName = ['
         + @i_entityName
         + '], operation = ['
         + @i_operation
         + ']'
         + '], capability = ['
         + @i_attrVal
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_updateUserGroupUserPropertiesCap')
	delete from GxQscripts where name = 'QS_updateUserGroupUserPropertiesCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateUserGroupUserPropertiesCap')
	delete from GXDBVersions where aliasname = 'QS_updateUserGroupUserPropertiesCap'
GO

insert into GXDBVersions values(2, 'QS_updateUserGroupUserPropertiesCap',  '00000000000000000000', 'QS_updateUserGroupUserPropertiesCap', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_updateUserGroupUserPropertiesCap',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '  To add or update "Cloud Capabilities" property for a user or a user group:
'
 + CHAR(10) + '  qoperation execscript -sn updateUserGroupUserPropertiesCap -si ''u=username''|''ug=usergroupname'' -si ''Cloud Capabilities'' -si ''attrVal'' -si ''add''|''remove''
'
 + CHAR(10) + '  Where ''attrVal''  is one of the following capabilities:
'
 + CHAR(10) + '-- 	COMMCELLCONSOLE '
 + CHAR(10) + '-- 	DOCUMENTATION '
 + CHAR(10) + '-- 	EDC'
 + CHAR(10) + '-- 	SURVEY  '
 + CHAR(10) + '-- 	CONFIGURATIONREQUEST'
 + CHAR(10) + '-- 	HIDEDOWNLOAD'
 + CHAR(10) + '-- 	HIDESYNC'
 + CHAR(10) + '-- 	GENERATEAUTHCODE'
 + CHAR(10) + '  To add or update any other property for a user or a user group
'
 + CHAR(10) + '  qoperation execscript -sn updateUserGroupUserPropertiesCap -si ''u=username''|''ug=usergroupname'' -si ''attrName'' -si ''attrVal''
'
)
GO

