

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_updateDAGNameServer.sp] ---------- 

-------------------------------------------
--         Name:   QS_updateDAGNameServer.sp
--         Date:   05/01/2012
--       Author:   Mandar Khadilkar
--  Description:   Update 'DAG Associated Name Server' property for a Exchange DAG client
--           TR:   Copy of 120418-000017, Incident: 120418-000091
--     Customer:   ATK
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_updateDAGNameServer <<<'

IF EXISTS (select * from sysobjects where name='QS_updateDAGNameServer')
	drop procedure QS_updateDAGNameServer
IF EXISTS (select * from GxQscripts where name='QS_updateDAGNameServer')
	delete from GxQscripts where name = 'QS_updateDAGNameServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateDAGNameServer')
	delete from GXDBVersions where aliasname = 'QS_updateDAGNameServer'
GO
print '... Creating Procedure: QS_updateDAGNameServer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_updateDAGNameServer
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(100) = N'',
  @domainName NVARCHAR(1024) = N''
AS
SET NOCOUNT ON
------------------------  Convenience Definitions --------------------------
DECLARE @scriptName NVARCHAR(50)
SET     @scriptName = N'QS_updateDAGNameServer'
DECLARE @errorCode INT
SET @errorCode = 0
DECLARE @errorString NVARCHAR(200)
SET     @errorString = N'Error encountered while executing script'
DECLARE @NoParameter NVARCHAR(3)
SET @NoParameter = ''
---------------------- Local Variables    ------------------------
DECLARE @clientId INT
DECLARE @propId INT
IF @clientName = @NoParameter
BEGIN
    SET @errorCode = 1
    SET @errorString = N'Error - Client name not specified.'
    GOTO ARGS_ERROR
END
ELSE
BEGIN
    SET @clientId = ISNULL((SELECT id FROM App_Client WHERE name = @clientName),0)
    IF @clientId = 0
    BEGIN
        SET @errorCode = 2
        SET @errorString = N'Error - Client not found in database.'
        GOTO ARGS_ERROR
    END
END
IF @domainName = @NoParameter
BEGIN
    SET @errorCode = 3
    SET @errorString = N'Error - Domain name not specified.'
    GOTO ARGS_ERROR
END
SET @propId = ISNULL((SELECT TOP(1) id FROM App_ClientProp WHERE lower(attrName) = 'dag associated name server' and componentNameId = @clientID and modified = 0),0)
IF @propId = 0
BEGIN
    SET @errorCode = 4
    SET  @errorString = N'Error - Property DAG Associated Name Server does not exist for client'
    goto ARGS_ERROR
END
-- Validations successful, perform update
BEGIN TRY
    BEGIN TRAN
        UPDATE APP_ClientProp SET attrVal = @domainName WHERE id = @propID and componentNameId = @clientId
    COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
  BEGIN
    SET @errorCode = ERROR_NUMBER ()
    SET @errorString = ERROR_MESSAGE ()
    ROLLBACK TRANSACTION
    GOTO ARGS_ERROR
  END
END CATCH
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
         + ' with Parameters: ['+@clientName  + ', '+@domainName +
        + ']. Exit Code(' +convert(varchar(2), @errorCode) + ').'
IF @errorCode <> 0
Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_updateDAGNameServer')
	delete from GxQscripts where name = 'QS_updateDAGNameServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateDAGNameServer')
	delete from GXDBVersions where aliasname = 'QS_updateDAGNameServer'
GO

insert into GXDBVersions values(2, 'QS_updateDAGNameServer',  '00000000000000000000', 'QS_updateDAGNameServer', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_updateDAGNameServer',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '        QScript to Update ''AD Domain Name'' for a MS Exchange DAG Client
'
 + CHAR(10) + '        qoperation execscript -sn updateDAGNameServer -si ''clientName'' -si ''domainName''
'
)
GO

