

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_updateDAGADCredential.sp] ---------- 

-------------------------------------------
--         Name:   QS_updateDAGADCredential.sql
--         Date:   07/18/2011
--       Author:   vbhise
--  Description:   Update 'DAG Associated AD User Name'  and 'DAG Associated AD User Password' for particular client
--
-- TR(original):   110713-000086
--     Customer:   Eng-Server-BB
--   CommcellId:   N/A (generic)
-------------------------------------------
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_updateDAGADCredential <<<'

IF EXISTS (select * from sysobjects where name='QS_updateDAGADCredential')
	drop procedure QS_updateDAGADCredential
IF EXISTS (select * from GxQscripts where name='QS_updateDAGADCredential')
	delete from GxQscripts where name = 'QS_updateDAGADCredential'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateDAGADCredential')
	delete from GXDBVersions where aliasname = 'QS_updateDAGADCredential'
GO
print '... Creating Procedure: QS_updateDAGADCredential'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_updateDAGADCredential
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @clientName NVARCHAR(MAX) = N'',
  @userName NVARCHAR(MAX) = N'',
  @encryptedPassword NVARCHAR(MAX) = N''
AS
Set NOCOUNT ON
------------------------  Convenience Definitions --------------------------
DECLARE @scriptName NVARCHAR(MAX)
SET		@scriptName = N'QS_updateDAGADCredential'
DECLARE @errorCode INT
SET @errorCode = 0
DECLARE	@errorString NVARCHAR(MAX)
SET		@errorString = N'Error encountered when running script'
DECLARE @NoParameter NVARCHAR(10)
SET		@NoParameter = N'%'						-- Get Around QScript Parameter
SET		@NoParameter = @NoParameter + N's'			-- .. Substitution
---------------------- Local Variables    ------------------------
DECLARE @clientId INT
-- Process client name parameter
IF (@clientName = @NoParameter OR @clientName = N'')
BEGIN
	SET @errorCode = 1
	SET @errorString = N'Error. Client name not specified.'
	goto ARGS_ERROR
END
ELSE
BEGIN
	SET @clientId = ISNULL((SELECT TOP(1) id FROM App_Client WHERE name = @clientName),0)
	IF @clientId = 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = N'Error. Client not found.'
		goto ARGS_ERROR
	END
END
-- Process User name parameter
IF (@userName = @NoParameter OR @userName = N'')
BEGIN
	SET @errorCode = 1
	SET @errorString = N'Error. User name not specified.'
	goto ARGS_ERROR
END
-- Process Password parameter
IF (@encryptedPassword = @NoParameter OR @encryptedPassword = N'')
BEGIN
	SET @errorCode = 1
	SET @errorString = N'Error. Password not specified.'
	goto ARGS_ERROR
END
PRINT CONVERT(NVARCHAR(60), GETDATE()) + N' [Start] '+ @scriptName
BEGIN TRY
	BEGIN TRAN
	UPDATE APP_ClientProp SET attrVal = @userName WHERE  componentNameId = @clientId and attrName = N'DAG Associated AD User Name' --CV_PROP_DAG_ADSERVER_USERNAME
	UPDATE APP_ClientProp SET attrVal = @encryptedPassword WHERE  componentNameId = @clientId and attrName = N'DAG Associated AD User Password' --CV_PROP_DAG_ADSERVER_PASSWORD
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	PRINT N'Error occured. ErrorNo(' + CAST(@errorCode AS NVARCHAR(10)) + N') ErrorMsg(' + @errorString + N').'
	PRINT N'So Rolling back Transactions.'
	ROLLBACK TRANSACTION
END
END CATCH
ARGS_ERROR:
PRINT @scriptName + N' completed at '
         + CONVERT(NVARCHAR(60), GETDATE())
		 + N' with '
         + N' Exit Code(' +CONVERT(NVARCHAR(10), @errorCode) + N').'
IF @errorCode <> 0
	RAISERROR(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_updateDAGADCredential')
	delete from GxQscripts where name = 'QS_updateDAGADCredential'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateDAGADCredential')
	delete from GXDBVersions where aliasname = 'QS_updateDAGADCredential'
GO

insert into GXDBVersions values(2, 'QS_updateDAGADCredential',  '00000000000000000000', 'QS_updateDAGADCredential', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_updateDAGADCredential',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '--       To update ''DAG Associated AD User Name''  and ''DAG Associated AD User Password'' for particular client'
 + CHAR(10) + '-- 		qoperation execscript -sn updateDAGADCredential -si ''clientName'' -si ''userName'' -p2 ''password'''
)
GO

