

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_updateAgentUpgradeDate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_updateAgentUpgradeDate <<<'

IF EXISTS (select * from sysobjects where name='QS_updateAgentUpgradeDate')
	drop procedure QS_updateAgentUpgradeDate
IF EXISTS (select * from GxQscripts where name='QS_updateAgentUpgradeDate')
	delete from GxQscripts where name = 'QS_updateAgentUpgradeDate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateAgentUpgradeDate')
	delete from GXDBVersions where aliasname = 'QS_updateAgentUpgradeDate'
GO
print '... Creating Procedure: QS_updateAgentUpgradeDate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_updateAgentUpgradeDate
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @i_Authentcode INT,
  @i_agentType VARCHAR(1024),
  @i_newUpgradeDate DATETIME,
  @i_bBypassAuthCode DATETIME = 0
AS
Set NOCOUNT ON
-- LOcal variables
DECLARE @ErrorNumber	INT = 0
DECLARE @ErrorMessage	VARCHAR(MAX) = ''
DECLARE @scriptName	VARCHAR(50) = 'QS_updateAgentUpgradeDate'
DECLARE @commcellID	INT = ISNULL((SELECT number FROM APP_Commcell WHERE id = 2), 0)
DECLARE @newUpgradeTime	INT = dbo.getUNIXTime(@i_newUpgradeDate)
DECLARE @appTypeID	INT
-- Validate Input
IF @newUpgradeTime < dbo.getUNIXTime(GETDATE())
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage += 'Invalid new upgrade date [' + @i_newUpgradeDate + '] which is older than current time.'
END
IF @i_agentType = 'SharePoint Server'
	SET @appTypeID = 78
ELSE IF @i_agentType = 'SharePoint Archiver'
	SET @appTypeID = 89
ELSE
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage += 'Invalid Agent Type [' + @i_agentType + '] which should be ''SharePoint Server'' or ''SharePoint Archiver''.'
END
-- Validation for the AuthCode
IF @i_bBypassAuthCode = 0 AND (checksum(HASHBYTES('SHA1','<'+CAST(@commcellID AS VARCHAR(64))+'><'+CAST(@i_agentType AS VARCHAR(64))+'><COMMVAULT>')) & 2147483646)+1 != @i_Authentcode
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage += 'Incorrect Authentication code.'
END
IF @ErrorNumber > 0
	GOTO QS_ERROR
-- UPDATE DB
DECLARE @agentUpgradeDelayInfo VARCHAR(1024) = '15:-'+CAST(@newUpgradeTime AS VARCHAR(65))
UPDATE simApptypeProp
SET attrVal = @agentUpgradeDelayInfo
WHERE componentNameId = @appTypeID AND attrName = 'DelayedAgentUpgradeInfo'
IF @@ERROR > 0
BEGIN
	SET @ErrorNumber = 1
	SET @ErrorMessage = 'Error in updating agent upgrade info for [' + @i_agentType + ']'
END
ELSE
BEGIN
	SET @ErrorMessage  ='Updated agent upgrade info for [' + @i_agentType + ']'
END
QS_ERROR:
	PRINT @scriptName + ' completed at ' + Convert(varchar(60), getdate())
		 + ' with Parameters:[' + cast(@i_Authentcode as varchar(MAX)) + ', ' + @i_agentType + ', ' + cast(@i_newUpgradeDate as varchar(MAX))
	IF @ErrorNumber =0
		PRINT  @ErrorMessage
	IF @ErrorNumber > 0
		Raiserror(@ErrorMessage,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
                )
GO

IF EXISTS (select * from GxQscripts where name = 'QS_updateAgentUpgradeDate')
	delete from GxQscripts where name = 'QS_updateAgentUpgradeDate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_updateAgentUpgradeDate')
	delete from GXDBVersions where aliasname = 'QS_updateAgentUpgradeDate'
GO

insert into GXDBVersions values(2, 'QS_updateAgentUpgradeDate',  '00000000000000000000', 'QS_updateAgentUpgradeDate', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_updateAgentUpgradeDate',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '
'
 + CHAR(10) + '	qoperation execscript -sn UpdateAgentUpgradeDate -si <AuthenticationCode> -si <AgentType> -si <newUpgradeDate> 
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    Authentication Code	- Authentication code to use the script
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    Agent Type		- agent name (''SharePoint Server'' or ''SharePoint Archiver'')
'
 + CHAR(10) + '
'
 + CHAR(10) + '  --    New upgrade date	- date time when the given agent is allowed to be upgraded to 10.0
'
 + CHAR(10) + '
'
)
GO

