

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setSubclientFilter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_setSubclientFilter')
BEGIN
	print '>>> Drop Stored Procedure: QS_setSubclientFilter <<<'
	drop procedure QS_setSubclientFilter
END
IF EXISTS (select * from GxQscripts where name='QS_setSubclientFilter')
	delete from GxQscripts where name = 'QS_setSubclientFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setSubclientFilter')
	delete from GXDBVersions where aliasname = 'QS_setSubclientFilter'
GO
print '... Creating Procedure: QS_setSubclientFilter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_setSubclientFilter
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @optName nvarchar(2050) = N'',
  @DELIM nvarchar(2) = N'',
  @owrite nvarchar(3) = N'o=y',
  @param1 nvarchar(100) = N'',
  @param2 nvarchar(100) = N'',
  @param3 nvarchar(100) = N'',
  @param4 nvarchar(100) = N'',
  @param5 nvarchar(100) = N''
AS
Set NOCOUNT ON
------------------input prefixes---------
DECLARE @contentPrefix  nvarchar(32)
SET @contentPrefix = 'p='
DECLARE @filterPrefix nvarchar(32)
SET @filterPrefix = 'f='
DECLARE @exceptPrefix nvarchar(32)
SET @exceptPrefix = 'e='
DECLARE @wcardedContentPrefix nvarchar(32)
SET @wcardedContentPrefix = 'w='
DECLARE @overwrite int
DECLARE @flag as int
----------------------constants--------
DECLARE @scriptName nvarchar(100)
SET @scriptName = 'SetSubclientFilter'
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------error handling----
DECLARE @errorCode int
SET @errorCode = 0
DECLARE @errorString nvarchar(1024)
SET @errorString = ''
---------------insufficient parameters --------------------------------
DECLARE @noParameter nvarchar(32)
SET @noParameter = ''
--SET @noParameter = @noParameter + 's'
IF @optName = @noParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No input was given.'
	GOTO ARGS_ERROR
END
--These checks are common for both SCPolicy and FSSubclients--
DECLARE @optPrefix nvarchar(4)
SET @optPrefix = SUBSTRING(@optName, 0, 3)
DECLARE @opt integer
SET @opt = (CASE @optPrefix
WHEN @contentPrefix THEN 1
WHEN @filterPrefix THEN  3
WHEN @exceptPrefix THEN  2
WHEN @wcardedContentPrefix THEN 4
ELSE 0
END)
IF @opt = 0
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid input parameter ['+@optName+'].'
	GOTO ARGS_ERROR
END
DECLARE @listOfPaths nvarchar(2048)
SET @listOfPaths = SUBSTRING(@optName, 3, LEN(@optName)-2)
IF @listOfPaths = ''
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No Content specified.'
	GOTO ARGS_ERROR
END
IF @DELIM = @NoParameter
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. No Content delimiter specified.'
	GOTO ARGS_ERROR
END
--Overwrite check--
IF @owrite NOT in (N'o=y',N'o=n')
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Invalid option specified '+ @owrite
	GOTO ARGS_ERROR
END
IF @owrite = 'o=y'	SET @overwrite = 1
ELSE	SET @overwrite = 0
--Check whether it is going to be scp or file system--
IF @param1 NOT like (N'c=%') AND @param1 NOT LIKE N'scp=%'
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. The fourth parameter must be c=clientnamt or scp=subclientpolicy name'
	GOTO ARGS_ERROR
END
IF @param1 LIKE 'c=%'
	SET @flag = 1			--FSSubclient
ELSE
	SET @flag = 0			--SCPolicy
DECLARE @ClientId int
DECLARE @AppTypeId int
DECLARE @InstanceId int
DECLARE @BackupsetId int
DECLARE @subclientId int
--These checks are needed for fssubclients--
IF @flag = 1
BEGIN
	IF OBJECTPROPERTY(object_id(N'[dbo].[QscriptGetAppIdsFromNames]'), N'IsProcedure') IS NULL
	BEGIN
		SET @errorCode = 1
		SET @errorString  = 'This script requires Stored procedure QscriptGetAppIdsFromNames to be installed. Please install it and try again.'
		GOTO ARGS_ERROR
	END
	EXECUTE @errorCode = QscriptGetAppIdsFromNames @PARAM1, @PARAM2, @PARAM3, @PARAM4, @PARAM5,
		@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
		@errorString OUTPUT
	IF @errorCOde != 0
	BEGIN
		GOTO ARGS_ERROR
	END
	--------------------------apptype and default subclient checks..------------------------
	IF @apptypeId not in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
	BEGIN
		SET @errorCode = 1
		SET @errorString  = 'Error. Apptype not supported.'
		GOTO ARGS_ERROR
	END
END
--These checks are needed for subclients associated with a subclientpolicy
ELSE
BEGIN
	--Now param1 = subclientpolicy name and param2 = subclientname. Only param1 and param2 are passed--
	--Check for empty params--
	IF @param2 = @noParameter OR @param2 NOT LIKE 's=%'
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Please specify the correct params in the correct format.'
		GOTO ARGS_ERROR
	END
	DECLARE @scpolicyname AS NVARCHAR(100)
	DECLARE @subclientname AS NVARCHAR(100)
	SET @scpolicyname = SUBSTRING(@Param1 , LEN('scp=')+1 , LEN(@param1)-LEN('scp='))
	SET @subclientname = SUBSTRING(@Param2, LEN('S=') + 1 ,LEN(@param2)-LEN('S='))
	--Validate scpolicy--
	SET @BackupsetId = (SELECT prop.componentNameId
						FROM APP_Backupsetprop prop INNER JOIN APP_BackupsetName bkp
						ON prop.componentNameId = bkp.id
						WHERE prop.attrName = 'Associated subclient Policy Ida Type' AND prop.modified = 0 AND bkp.name = @scpolicyname)
	IF @BackupsetId = 0
	BEGIN
		SET @errorCode = 1
		SET	@errorString = 'Error. Invalid subclient policy [' + @scpolicyname + '] specified.'
		GOTO ARGS_ERROR
	END
	--Validate whether subclient is associated with this sc policy--
	SET @subclientId = ISNULL((SELECT id FROM App_Application WHERE appTypeId = 1030 AND backupSet = @BackupsetId AND clientId = 2 AND subclientName  = @subclientname),0)
	IF @subclientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Subclient [' + @subclientname  +'] + subclientpolicy [' + @scpolicyname  +'] does not exist.'
		GOTO ARGS_ERROR
	END
END
--These checks are for FSSubclients and SCPolicies--
IF ((SELECT SubclientStatus & 2 FROM APP_APPLICATION WHERE id = @subclientid) = 2  OR
(SELECT SubclientStatus & 4 FROM APP_APPLICATION WHERE id = @subclientid) = 4 )
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Subclient is deleted or uninstalled.'
	GOTO ARGS_ERROR
END
IF EXISTS (select 1 FROM App_backupsetprop where attrname like 'OnDemand Backupset' and attrVal = 1 and modified = 0 and componentNameId = @BackupsetID)
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Backupset is an On Demand backupset.'
	GOTO ARGS_ERROR
END
--commented out since this same script is used for scpolicies also--
/*IF EXISTS(Select * from APP_subclientprop
		where componentnameid = @subclientid and attrname like 'Associated subclient Policy' and modified =0)
BEGIN
	SET @errorCode = 1
	SET @errorString  = 'Error. Cannot change contents. Subclient is associated with a subclient policy.'
	GOTO ARGS_ERROR
END*/
/*-------------------reset empty options so that script exit message does not have [%s] as parameter--------
IF @PARAM1 = @noParameter
	SET @PARAM1 = ''
IF @PARAM2 = @noParameter
	SET @PARAM2 = ''
IF @PARAM3 = @noParameter
	SET @PARAM3 = ''
IF @PARAM4 = @noParameter
	SET @PARAM4 = ''
IF @PARAM5 = @noParameter
	SET @PARAM5 = ''*/
------------------------set contents or filters or exception to filter depending on input---------
--get correct slash
DECLARE @dirDelim   nvarchar(4)
IF @flag = '1'
	SET @dirDelim = (select dirDelim from app_idatype where type = @apptypeId)
ELSE
BEGIN
	--Get the delimiter of the apptype to which the scpolicy is associated to
	SET @dirDelim = (CASE (SELECT attrval FROM APP_BackupSetProp WHERE componentNameId = @BackupsetId AND attrName = 'Associated subclient Policy Ida Type' AND modified = 0)
	WHEN '2' THEN '\'		--Windows File System
	WHEN '3' THEN '/'		--Unix File System
	ELSE '\'				--Netware File System
	END)
END
DECLARE @isUnixFS INT = 0
IF @dirDelim = '/'
	SET @isUnixFS = 1
DECLARE @isWildCardContent INT
set @isWildCardContent =0
if(@opt=4)
BEGIN
	set @opt=1
	set @isWildCardContent =1
END
BEGIN TRAN
--	age previous contents or filters or exception to filter
IF @overwrite = 1
BEGIN
UPDATE APP_SCFILTERFILE	SET modified = @nowTime
		WHERE COMPONENTNAMEID = @subClientId AND Modified = 0 AND type = @opt
SET @errorCode = @@error
IF @errorCode <> 0
BEGIN
	SET @errorString = 'Error. Could not age content for subclient'
	GOTO TRANS_EXIT
END
END
-- PARSE LIST OF PATHS.
DECLARE @thisPath		varchar(1024)
DECLARE @inStrLen       int
DECLARE @nextSeper		int
SET  @inStrLen   = LEN(@listOfPaths)
IF @inStrLen > 0
BEGIN
    WHILE (LEN(@listOfPaths) > 0)
    BEGIN
		SET @nextSeper   = CHARINDEX(@DELIM, @listOfPaths, 1)
		IF @nextSeper = 0
		BEGIN
			SET @listOfPaths = @listOfPaths+@DELIM
			SET @nextSeper = @instrlen+1
		END
        SET @thisPath    = RTRIM(LTRIM(SUBSTRING(@listOfPaths, 1, @nextSeper-1)))
		--validate path
		IF charindex('\', @thisPath) <> 0 AND @dirDelim = '/'--unix path
		BEGIN
				SET @errorString = 'Error. Invalid path ['+@thisPath+'].'
				set @errorCode = 1
				goto TRANS_EXIT
		END
		ELSE IF charindex('/', @thisPath) <> 0 AND @dirDelim = '\'
		BEGIN
			SET @errorString = 'Error. Invalid path ['+@thisPath+'].'
			set @errorCode = 1
			goto TRANS_EXIT
		END
		IF( @isWildCardContent <> 0)
		BEGIN
			IF( PATINDEX('%[*?]%',@thisPath) <> 0 OR ( (PATINDEX('%[[]%',@thisPath))<>0  AND  (PATINDEX('%]%',@thisPath)) <> 0) )
			BEGIN
				set @thisPath = @thisPath + '\/\/'
			END
		END
		--for contents see if other subclients in the same bs have the same content
		IF @opt = 1 AND EXISTS(SELECT* FROM APP_SCFILTERFILE AS SCF, APP_APPLICATION AS APP
									WHERE SCF.modified = 0
									AND SCF.filename <> @dirDelim  -- to filter out default subclient with only '/' or '\' as content (as it would always be a substring and return one row here).
									AND SCF.componentNameId <> @subClientId
									AND SCF.componentNameId = APP.id
									AND ((@isUnixFS = 0 AND SCF.fileName = @thisPath) OR
										 (@isUnixFS = 1 AND SCF.fileName COLLATE SQL_Latin1_General_CP1_CS_AS = @thisPath))
									AND SCF.type = @opt
									AND APP.backupset = @backupsetid)
		BEGIN
			SET @errorString = 'Error. Cannot Add path ['+@thisPath+'] to subClient.  It already exists in another subClient'
			set @errorCode = 1
			goto TRANS_EXIT
		END
		--filter path must be a subpath of contents of the same subclient
		/*ELSE IF @opt = 3 AND ((select ISNULL(max(charindex(filename, @thispath)), 0)FROM APP_SCFILTERFILE AS SCF
					WHERE SCF.modified = 0  AND SCF.componentNameId = @subClientId
					  AND SCF.type = 1) = 0)
		BEGIN
			SET @errorString = 'Error. Cannot Add filter ['+@thisPath+'] to subClient.  Subclient contents do not have this path.'
			set @errorCode = 1
			goto TRANS_EXIT
		END
		-- exception to filter must a subpath of filter
		ELSE IF @opt = 2 AND ((select ISNULL(max(charindex(filename, @thispath)), 0)FROM APP_SCFILTERFILE AS SCF
					WHERE SCF.modified = 0  AND SCF.componentNameId = @subClientId
					  AND SCF.type = 3) = 0)
		BEGIN
			SET @errorString = 'Error. Cannot Add exception to filter ['+@thisPath+'] to subClient.  Subclient filters do not have this path.'
			set @errorCode = 1
			goto TRANS_EXIT
		END*/
		--Check if this content / filter / exception is already present for this subclient. If so then no need to set it again
		ELSE IF EXISTS (SELECT *
							FROM APP_ScFilterFile AS SCF INNER JOIN APP_Application AS APL
							ON SCF.componentNameId = APL.id
							WHERE SCF.componentNameId = @subClientId AND
							SCF.type = @opt AND
							((@isUnixFS = 0 AND SCF.fileName = @thisPath) OR
							(@isUnixFS = 1 AND SCF.fileName COLLATE SQL_Latin1_General_CP1_CS_AS = @thisPath)) AND
							SCF.modified = 0)
		BEGIN
			PRINT 'Path [' + @thisPath +'] is present already for this subclient. So skipping duplicate entry'
			--Lets not throw error. Just print this on the console and proceed
		END
		--valid path for that file type. insert it.
		ELSE
		BEGIN
			IF(@thisPath <> '')
			BEGIN
				INSERT APP_SCFILTERFILE(componentNameId,type,fileName,created,modified)
					VALUES (@subClientId, @opt, @thisPath, @nowTime, 0)
				SET @errorCode = @@error
				IF @errorCode <> 0
				BEGIN
					SET @errorString = 'Error. Could not add path [' +@thisPath +'] to subclient.'
					GOTO TRANS_EXIT
				END
				PRINT 'Added Path ['+@thisPath+'].'
			END
		END
--      SET UP TO GET NEXT PATH IN THE LIST:
--      --------------------------------------
        IF (@inStrLen - @nextSeper <= 0)
            BREAK
        SET @listOfPaths = SUBSTRING(@listOfPaths, @nextSeper+1, @inStrLen-@nextSeper)
        SET @inStrLen = LEN(@listOfPaths)
    END
END
TRANS_EXIT:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
	--ROLLBACK TRAN				-- (Use rollback for debugging purposes!)
ARGS_ERROR:
print @scriptName + ' completed at '	+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errorCode) +').'
if @errorCode <> 0
	Raiserror(@errorString,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setSubclientFilter')
	delete from GxQscripts where name = 'QS_setSubclientFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setSubclientFilter')
	delete from GXDBVersions where aliasname = 'QS_setSubclientFilter'
GO

insert into GXDBVersions values(2, 'QS_setSubclientFilter',  '00000000000000000000', 'QS_setSubclientFilter', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setSubclientFilter',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	For file system subclient, qoperation execscript -sn SetSubclientFilter.sql -si [p=contents | f=filters | e=exceptions] -si [delimiter] -si [o=y | o=n] -si c=clientname -si a=IDA name -si b=backupsetname -si s=subclientname
'
 + CHAR(10) + '    For subclient policy, qoperation execscript -sn SetSubclientFilter.sql -si [p=contents | f=filters | e=exceptions] -si [delimiter] -si [o=y | o=n] -si scp=subclient policy name -si s=Subclientname
'
 + CHAR(10) + '-- 	script_name: setSubclientFilter'
 + CHAR(10) + '-- 	Set content / wildcarded content / filters /exception to filter in a file system subclient and subclientpolicy.'
)
GO

