

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setRegisterClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_SetRegisterClient.sp,v $ $Id: QS_SetRegisterClient.sp,v 1.3.60.3 2018/03/22 00:59:01 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_setRegisterClient')
BEGIN
	print '>>> Drop Stored Procedure: QS_setRegisterClient <<<'
	drop procedure QS_setRegisterClient
END
IF EXISTS (select * from GxQscripts where name='QS_setRegisterClient')
	delete from GxQscripts where name = 'QS_setRegisterClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setRegisterClient')
	delete from GXDBVersions where aliasname = 'QS_setRegisterClient'
GO
print '... Creating Procedure: QS_setRegisterClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_setRegisterClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @in_clientName varchar(255),
  @in_targetCC varchar(255),
  @in_userName varchar(255)=NULL,
  @in_password varchar(255)=NULL,
  @in_clientGroup varchar(255)=NULL,
  @in_subclientpolicy varchar(255)=NULL,
  @in_storagePolicy varchar(255)=NULL
AS
SET ANSI_PADDING ON
SET ARITHABORT ON
SET QUOTED_IDENTIFIER ON
Set NOCOUNT ON
DECLARE	@targetCCId	INT = 0
DECLARE	@errorCode	INT = -1
DECLARE	@errorString	VARCHAR(256) = ''
DECLARE	@newEncPwd	VARCHAR(1024) = ''
BEGIN TRY
   IF @in_clientName IS NULL OR LEN(@in_clientName) = 0
   BEGIN
	SET @errorString = 'Invalid input client name'
	GOTO SP_EXIT
   END
   SELECT @targetCCId = ID FROM APP_CommCell WHERE aliasName = @in_targetCC
   IF @targetCCId = 0
   BEGIN
	SET @errorString = 'Invalid input CommCell name'
	GOTO SP_EXIT
   END
   IF NOT EXISTS (select * from APP_CommCellInfo where commcellId = @targetCCId)
   BEGIN
	SET @errorString = 'Input CommCell name [' + @in_targetCC + '] is not in destination CommCell list'
	GOTO SP_EXIT
   END
   IF @in_password IS NOT NULL AND LEN(@in_password) > 0
   BEGIN
	EXEC pswEncryptionManaged @in_password, @newEncPwd OUTPUT
   END
   IF EXISTS (select * from APP_RegisterClient where name = @in_clientName)
   BEGIN
	UPDATE	APP_RegisterClient
	SET	targetCCId	= @targetCCId,
		username = COALESCE(@in_userName, userName),
		password = COALESCE(@in_password, password),
		clientGroup = COALESCE(@in_clientGroup, clientGroup),
		subclientPolicy = COALESCE(@in_subclientpolicy, subclientPolicy),
		storagePolicy = COALESCE(@in_storagePolicy, storagePolicy)
	WHERE	name = @in_clientName
	SET @errorString = 'Register client info is updated for client [' + @in_clientName + ']'
   END
   ELSE
   BEGIN
	INSERT INTO APP_RegisterClient
	SELECT	@in_clientName, @targetCCId,
		COALESCE(@in_userName, ''),
		@newEncPwd,
		COALESCE(@in_clientGroup, ''),
		COALESCE(@in_subclientpolicy, ''),
		COALESCE(@in_storagePolicy, ''),
		0, dbo.GetUnixTime(GETDATE()), 0
	SET @errorString = 'Register client info is added for client [' + @in_clientName + ']'
   END
   SET @errorCode = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message [' +ERROR_MESSAGE() + '].'
END CATCH
SP_EXIT:
IF @errorCode <> 0 AND LEN(@errorString) = 0
	SET @errorString = 'Failed to set Register client info for client [' + @in_clientName + ']'
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setRegisterClient')
	delete from GxQscripts where name = 'QS_setRegisterClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setRegisterClient')
	delete from GXDBVersions where aliasname = 'QS_setRegisterClient'
GO

insert into GXDBVersions values(2, 'QS_setRegisterClient',  '00010003006000030000', 'QS_setRegisterClient', '00010003006000030000')
GO

insert into GxQscripts values(2,'QS_setRegisterClient',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn setRegisterClient -si clientName -si targetCommCell [-si userName] [-si password] [-si clientGroup] [-si subclientPolicy] [-si storagePolicy]
'
 + CHAR(10) + '-- 	script_name: setRegisterClient'
 + CHAR(10) + '-- 	Set auto register client info'
)
GO

