

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setMediaAgentProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_setMediaAgentProperty.sp,v $ $Id: QS_setMediaAgentProperty.sp,v 1.8.2.18 2020/11/12 01:45:51 prasanthm Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_setMediaAgentProperty')
BEGIN
	print '>>> Drop Stored Procedure: QS_setMediaAgentProperty <<<'
	drop procedure QS_setMediaAgentProperty
END
IF EXISTS (select * from GxQscripts where name='QS_setMediaAgentProperty')
	delete from GxQscripts where name = 'QS_setMediaAgentProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setMediaAgentProperty')
	delete from GXDBVersions where aliasname = 'QS_setMediaAgentProperty'
GO
print '... Creating Procedure: QS_setMediaAgentProperty'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_setMediaAgentProperty
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
-- Stored Procedure Inputs
  @PARAM1 varchar(1024) = '',
  @PARAM2 varchar(1024) = '',
  @PARAM3 varchar(1024) = '',
  @PARAM4 varchar(1024) = ''
AS
Set NOCOUNT ON
/*
 Input Prameters
 */
 declare @option_value_no_parallel_data  int            -- No of parallel data transfer operations
declare @media_agent_name               nvarchar(510)  -- Name of the Media Agent
declare @option_num                     int            -- Number indicating the operation type
declare @option_value_enable            bit            -- Enable (1)/Disable(0) value
declare @scan_interval                  int            -- Scan Interval in Hours
/*
 Local Variables
 */
 ---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'setMediaAgentProperty'
DECLARE @lastError				integer
SET		@lastError				= 0
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @NoParameter			varchar(10)
SET     @NoParameter			=''
declare @client_id                      int
declare @attribute                      int
declare @media_agent_os                 varchar(64)    -- Operating system of the Media Agent
declare @upper_limit                    int            -- Upper Limit of Max Reservations
declare @attrName 						nvarchar(512)
declare @HyperVisorType integer = 0	-- Cloud VM Power Management
------------------------------------------------------------------
/*
  Hard code sample values to test the script
  The following section is not meant to be a permanent change,
  ideally the script would be changed into a QCommand which can
  very well accept input parameters.
 */
 --set @option_value_no_parallel_data = 200
-- set @media_agent_name = 'pc2-t3400_cn'
 --set @option_num = 1
 --set @option_value_enable = 1
 --set @scan_interval = 24
 --set @PARAM1 = 'pc2-t3400_cn'
 --set @PARAM2 = '1'
 --set @PARAM3 = '200'
 --set @PARAM4 = '24'
------------------------------------------------------------------
set @client_id = 0
set @attribute = 0
set @upper_limit = 0
begin transaction
if(@PARAM1 = @NoParameter or @PARAM2 = @NoParameter or @PARAM3 = @NoParameter)
begin
 print 'Error: Insufficient command line parameters'
 print 'Please refer to the readme file and retry with necessary parameters'
 SET	@lastError		=	1
 GOTO SCRIPT_EXIT
end
 print '------------------------------------------'
 print 'Input Parameters'
 print '------------------------------------------'
 print 'Media Agent   : ' + @PARAM1
 print 'Option Number : ' + @PARAM2
 print 'Option Value  : ' + @PARAM3
 print '------------------------------------------'
 set @media_agent_name = @PARAM1
 set @option_num = convert(int,@PARAM2)
 if(@option_num = 1)
 begin
   set @option_value_no_parallel_data = convert(int,@PARAM3)
   select @media_agent_os = upper(SOS.name)
   from App_client AC, simOperatingSystem SOS
   where AC.simOperatingSystemId = SOS.Id
         and AC.name = @media_agent_name
   if(@media_agent_os = 'NETWARE' or @media_agent_os = 'NEW NETWARE')
      set @upper_limit = 75
   else
      set @upper_limit = 800
   -- Validate the number of parallel data transfer operations
   if(@option_value_no_parallel_data <= 0 or @option_value_no_parallel_data > @upper_limit)
   begin
     print 'Error: Invalid number of Parallel data transfer operations'
	 print 'Please retry with a valid value from 1 to less than or equal to '+convert(VARCHAR,@upper_limit)
	 SET	@lastError		=	1
     GOTO SCRIPT_EXIT
   end
 end
 else if (@option_num <10 or @option_num >14 and @option_num <> 17)
 begin
   set @option_value_enable = convert(bit,@PARAM3)
 end
 if(@option_num = 2 and @option_value_enable = 1)
 begin
  if(@PARAM4 = @NoParameter)
  begin
   print 'Error: Scan interval not specified'
   print 'Please retry with scan interval as the fourth command line option'
   SET	@lastError		=	1
   GOTO SCRIPT_EXIT
  end
  print 'Scan Interval : ' + @PARAM4 + ' Hours'
  print '------------------------------------------'
  set @scan_interval = convert(int,@PARAM4)
  if(@scan_interval <= 0)
   begin
    print 'Error: Invalid duration for Scan Interval'
    print 'Please retry with a valid Scan Interval'
    SET	@lastError		=	1
	GOTO SCRIPT_EXIT
   end
 end
/*
 Verify if a Media Agent by the specified name exists in the database.
 Perform the check done by MMMiscDB::getInfoByClientName and MMHostDB::getHostStatus
 */
 select @client_id = isnull(AC.id,0)
 from app_client AC, MMHost MH
 where AC.id = MH.clientid
       and name = @media_agent_name
 if(@client_id = 0)
 begin
  print 'Error: Invalid Media Agent Name'
  print 'Please retry with a valid Media Agent Name'
 end
 else
 begin
  --print 'Media Agent Name Verified...'
    begin
     --print 'About to update Media Agent Properties'
     -- To set the number of parallel data operations
     if(@option_num = 1)
      begin
       update MMHost
       set MaxReservations = @option_value_no_parallel_data
       where Clientid = @client_id
       --print 'No of parallel data operation update complete'
      end
      else if(@option_num >= 2 and @option_num <= 8)
      begin
       set @attribute = case @option_num
                        when 2 then
                          case @option_value_enable
                          when 1 then 1            -- #define MMS2_MA_UPDATE_SCSI_ADDRESS_ON_ERROR				1
                          when 0 then ~1
                          end
                        when 3 then
                          case @option_value_enable
                          when 1 then 4           -- #define MMS2_MA_MARK_DRIVE_INACCESSIBLE_ON_ERROR			4
                          when 0 then ~4
                          end
                        when 4 then
                          case @option_value_enable
                          when 1 then 2           -- #define MMS2_MA_USE_NATIVE_DRIVER							2
                          when 0 then ~2
                          end
                        when 5 then
                          case @option_value_enable
                          when 1 then 32           -- #define MMS2_MA_USE_SIMPLE_DATA_TRANSFER					32
                          when 0 then ~32
                          end
                        when 6 then
                         case @option_value_enable
			 when 1 then  256		--#define MMS2_MA_VERIFY_DATA_CRC_OVER_NETWORK                256
			 when 0 then ~256
                          end
                        when 7 then
			 case @option_value_enable
			 when 1 then 512		--#define MMS2_MA_VERIFY_DATA_CRC_ON_MEDIA                    512
			 when 0 then ~512
                         end
						 when 8 then
							 case @option_value_enable
							 when 1 then 16		--#define MMS2_MA_MARKED_FOR_MAINTENANCE                      16
							 when 0 then ~16
                         end
                      end
/*
    Significance of Attribute in MMHost:
                  LSB
 -------------------
    |    |    |    |
    | 1  | 1  | 1  |
    |    |    |    |
 -------------------
      |    |    |
      |    |    ---------> MMS2_MA_UPDATE_SCSI_ADDRESS_ON_ERROR (MMS2Defines.h)
      |    |
      |    --------------> MMS2_MA_USE_NATIVE_DRIVER (MMS2Defines.h)
      |
      -------------------> MMS2_MA_MARK_DRIVE_INACCESSIBLE_ON_ERROR (MMS2Defines.h)
------------------------------------------------------------------------------------------------------
					Option									Bit Value(MMS2Defines.h)
------------------------------------------------------------------------------------------------------
		MMS2_MA_UPDATE_SCSI_ADDRESS_ON_ERROR				1
		MMS2_MA_USE_NATIVE_DRIVER							2
		MMS2_MA_MARK_DRIVE_INACCESSIBLE_ON_ERROR			4
		MMS2_MA_AUTO_DETECT_WORM_MEDIA						8
		MMS2_MA_MARKED_FOR_MAINTENANCE						16
		MMS2_MA_USE_SIMPLE_DATA_TRANSFER					32
 */
       if(@option_value_enable = 1)             -- To set the bit as specified option is to enable
        begin
         update MMHost
         set Attribute = Attribute | @attribute
         where Clientid = @client_id
         --print 'Enable update complete'
        end
       else if(@option_value_enable = 0)        -- To reset the bit as specified option is to disable
        begin
         update MMHost
         set Attribute = Attribute & @attribute
         where Clientid = @client_id
         --print 'Disable update complete'
        end
       else
        begin
         print 'Error: Invalid Enable/Disable Option'
		 SET	@lastError		=	1
		 GOTO SCRIPT_EXIT
        end
       if(@option_num = 2 and @option_value_enable = 1) -- Set the interval period only when the option is to enable.
        begin
        /* MMS2Defines.h
          @scan_interval is in terms of Hours, convert it into seconds
         */
         update MMHost
         set ScanIntervalInSec = @scan_interval * 60 * 60
         where Clientid = @client_id
         --print 'Scan interval update complete'
        end
      end
	 else if (@option_num = 9)
	 begin
		update	MMHost
		set		MmHostEnabled = @option_value_enable
		where	ClientId = @client_id
	  end
	 else if @option_num IN (11, 12)
	  begin
		SET @attrName = (case @option_num
								when 11 then 'Idx: alert space'
								when 12 then 'Idx: min space'
								end)
		update	app_clientprop
		set		attrVal = (case @option_num
								when 11 then cast(convert(float, @PARAM3) as numeric(10,1))*1024
								when 12 then cast(convert(float, @PARAM3) as numeric(10,1))*1024
								end)
		where	componentNameId = @client_id
		and		attrName = @attrName
	end
	ELSE IF @option_num IN (10, 13, 14)
	BEGIN
		SET @attrName = (case @option_num
								when 10 then 'Idx: age days'
								when 13 then 'Idx: cleanup percent'
								when 14 then 'Idx: cache enabled'
								end)
		update	app_clientprop
		set		attrVal = (case @option_num
								when 10 then case when convert(int, @PARAM3) <1 then attrVal
												else convert(int, @PARAM3)
												end
								when 13 then case
												when convert(int, @PARAM3) > 100 or convert(int, @PARAM3) <1  then attrVal
												else 100 - convert(int, @PARAM3)
												end
								when 14 then convert(bit, @PARAM3)
								end)
		where	componentNameId = @client_id
		and		attrName = @attrName
	END
	else if (@option_num = 15)
	  begin
		exec MMEnableRansomwareOnMA @client_id, @option_value_enable, 1 /*Force update*/
	  end
	 else if (@option_num = 16 OR @option_num = 17)
	  begin
			-- common validations
			-- Feature enable
			IF NOT EXISTS(SELECT 1 FROM MMConfigs WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG' AND value = 1)
			BEGIN
				print 'Power Management feature is not enabled. Please enable and try again.'
				SET	@lastError		=	1
				GOTO SCRIPT_EXIT
			END
			-- not supported vendor
			DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
			declare @input_option_value integer
			set @input_option_value = convert(int,@PARAM3)
			select @HyperVisorType = CAST(attrVal AS INTEGER) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @client_id AND attrName = 'VSA HyperVisor Type' AND modified = 0
			if ((@HyperVisorType & 16 <> 16) AND (@HyperVisorType & 32 <> 32) AND (@HyperVisorType & 512 <> 512)) --AMAZON_VM, AZURE_VM, KUBERNETES_VM
			begin
				print 'Power Management is not supported for the Media Agent ' + @media_agent_name + '.'
				SET	@lastError		=	1
				GOTO SCRIPT_EXIT
			end
			-- cloud controller selection and enable disable power management
			if( (@option_num = 16 AND @PARAM4 <> @NoParameter) OR @option_num = 17)
			begin
IF EXISTS (SELECT 1 FROM MMPowerMgmtHost WHERE HostId = @client_id AND (Flags & 1024) = 0)
				BEGIN
					print 'Power Management using Client Group settings. Please change it to MediaAgent settings to enable or diable power management at MediaAgent level for the ' + @media_agent_name + '.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				END
			end
			-- select MediaAgent or client Group level
			IF(@option_num = 16 AND @PARAM4 = @NoParameter)
			BEGIN
				IF @input_option_value = 0
				BEGIN
					--Client Group level
					EXEC MMSetCGConfigOnMA @client_id
				END
				ELSE
				BEGIN
					-- MediaAgent level
					IF EXISTS (SELECT 1 FROM MMPowerMgmtHost WHERE HostId = @client_id)
					BEGIN
						UPDATE MMPowerMgmtHost
SET Flags =  (Flags | 1024),
						isEnabled = 0,
						LastPowerMgmtUpdateTime = @currentUTCTime,
						PowerStatus = 0,
						LastAccessTime = @currentUTCTime
						WHERE HostId = @client_id
					END
					ELSE
					BEGIN
						INSERT INTO MMPowerMgmtHost
SELECT @client_id, 0, @currentUTCTime, 0, 0, 1024, 0, @currentUTCTime, 0, 0, NULL, 0, 0
					END
					update MMHost
set Attribute =  (Attribute & ~32768)
					where ClientId = @client_id
				END
				commit transaction
				GOTO SCRIPT_EXIT
			END
			--here after this second parameter should be 1
			IF @input_option_value = 0
			BEGIN
				print 'Invalid option received. Please select use MediaAgent settings option to enable or disable power management at MediaAgent level for the MediaAgent ' + @media_agent_name + '.'
				SET	@lastError		=	1
				GOTO SCRIPT_EXIT
			END
			-- enable or disable power management
			if (@option_num = 16)
			begin
				declare @EnableORDisablePM INTEGER = 0
				set @EnableORDisablePM = convert(int,@PARAM4)
				-- Given mediaagent is part of any cloud controller proxies.
				IF @EnableORDisablePM = 1
				BEGIN
					DECLARE @TMPRetcodeTbl TABLE(retCode INTEGER)
					INSERT INTO @TMPRetcodeTbl
					exec MMIsPowerManagementAllowed @client_id, 11, 0
					IF EXISTS (SELECT retCode FROM @TMPRetcodeTbl WHERE retCode = 0)
					BEGIN
						print 'MediaAgent ' + @media_agent_name + ' act as proxy of another cloud controller which is using for power management.'
						SET	@lastError		=	1
						GOTO SCRIPT_EXIT
					END
				END
				IF EXISTS (SELECT 1 FROM MMPowerMgmtHost WHERE HostId = @client_id)
				BEGIN
					UPDATE MMPowerMgmtHost
					SET isEnabled = @EnableORDisablePM,
					LastPowerMgmtUpdateTime = @currentUTCTime,
					PowerStatus = 0,
					ControllerNode = 0,
					LastAccessTime = @currentUTCTime
					WHERE HostId = @client_id
				END
				ELSE
				BEGIN
					INSERT INTO MMPowerMgmtHost
SELECT @client_id, @EnableORDisablePM, @currentUTCTime, 0, 0, 1024, 0, @currentUTCTime, 0, 0, NULL, 0, 0
				END
				update MMHost
				set Attribute = case @EnableORDisablePM
when 1 then (Attribute | 32768)
when 0 then (Attribute & ~32768)
								end
				where ClientId = @client_id
				commit transaction
				GOTO SCRIPT_EXIT
		   end
		   if (@option_num = 17)
		   begin
				declare @VCId integer = 0
				select @VCId = id from APP_Client WITH (NOLOCK) where name = @PARAM3
				if (@VCId = 0)
				begin
					print 'Invalid cloud controller ' + @PARAM3 + ', Please provide valid cloud controller name.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				end
				-- input cloud controller and mediaagent are same vendor
				DECLARE @InstanceType INTEGER = 0
				SELECT @InstanceType = CAST(IPROP.attrVal as INTEGER) from APP_InstanceProp IPROP WITH (NOLOCK)
				INNER JOIN APP_Application APP WITH (NOLOCK) ON APP.instance = IPROP.componentNameId AND IPROP.attrName = 'Virtual Server Instance Type'
				WHERE APP.ClientId = @VCId
				IF (@HyperVisorType & 16 = 16 AND @InstanceType <> 301) --APP_VIRTSERV_AMAZON, AMAZON_VM
				BEGIN
					print 'Invalid cloud controller ' + @PARAM3 + ', Please provide Amazon cloud controller name.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				END
				IF (@HyperVisorType & 32 = 32 AND @InstanceType <> 402) --APP_VIRTSERV_AZURE_V2, AZURE_VM
				BEGIN
					print 'Invalid cloud controller ' + @PARAM3 + ', Please provide Azure cloud controller name.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				END
				-- Given mediaagent as part of given cloud controller proxy
				DECLARE @TMPRetcodeTbl1 TABLE(retCode INTEGER)
				INSERT INTO @TMPRetcodeTbl1
				exec MMIsPowerManagementAllowed @client_id, 11, @VCId
				IF EXISTS (SELECT retCode FROM @TMPRetcodeTbl1 WHERE retCode = -1)
				BEGIN
					print 'MediaAgent ' + @media_agent_name + ' act as proxy of given cloud controller ' + @PARAM3 + '. Please provide different cloud controller.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				END
				-- Cloud controller has power managed proxy or not
				DECLARE @TMPRetcodeTbl2 TABLE(retCode INTEGER)
				INSERT INTO @TMPRetcodeTbl2
				exec MMIsSelectedVCHasNonPowerManagedProxy @VCId
				IF EXISTS(SELECT 1 FROM @TMPRetcodeTbl2 WHERE retCode = 0)
				BEGIN
					print 'Given cloud controller ' + @PARAM3 + ' does not has non power managed proxies. Please provide different cloud controller.'
					SET	@lastError		=	1
					GOTO SCRIPT_EXIT
				END
				--update or insert
				IF EXISTS (SELECT 1 FROM MMPowerMgmtHost WHERE HostId = @client_id)
				BEGIN
					UPDATE MMPowerMgmtHost
					SET ControllerNode = @VCId
					WHERE HostId = @client_id
				END
				ELSE
				BEGIN
					INSERT INTO MMPowerMgmtHost
SELECT @client_id, 0, @currentUTCTime, @VCId, 0, 1024, 0, @currentUTCTime, 0, 0, NULL, 0, 0
				END
			end
		end
     else
      begin
       print 'Error: Invalid option specified'
       print 'Please retry with a valid option number'
	   SET	@lastError		=	1
	   GOTO SCRIPT_EXIT
      end
    end
  end
commit transaction
SCRIPT_EXIT:
	IF @lastError <> 0
	BEGIN
		ROLLBACK TRAN
		Raiserror(@localErrorMsg,
						15,  --Severity (> 10 to force DOS Error Code = 1)
						1	 --State
						)
	END
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_setMediaAgentProperty')
	delete from GxQscripts where name = 'QS_setMediaAgentProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setMediaAgentProperty')
	delete from GXDBVersions where aliasname = 'QS_setMediaAgentProperty'
GO

insert into GXDBVersions values(2, 'QS_setMediaAgentProperty',  '00010008000200180000', 'QS_setMediaAgentProperty', '00010008000200180000')
GO

insert into GxQscripts values(2,'QS_setMediaAgentProperty',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		To set the Maximum number of parallel data transfer operations'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 1 -si 100'
 + CHAR(10) + '-- 		To disable the Auto Update SCSI during live operation'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 2 -si 0'
 + CHAR(10) + '-- 		To enable the Auto Update SCSI during live operation and set the scan interval period (in hours)'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 2 -si 1 -si 24'
 + CHAR(10) + '-- 		To enable the drive as inaccessible on error'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 3 -si 1'
 + CHAR(10) + '-- 		To disable the drive as inaccessible on error'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 3 -si 0'
 + CHAR(10) + '-- 		To enable Native device Driver for data transfer'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 4 -si 1'
 + CHAR(10) + '-- 		To disable use of Native device Driver for data transfer'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 4 -si 0'
 + CHAR(10) + '-- 		To enable Optimize for concurrent LAN backups'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 5 -si 1'
 + CHAR(10) + '-- 		To disable Optimize for concurrent LAN backups'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 5 -si 0'
 + CHAR(10) + '-- 		To enable Data integrity validation on Network'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 6 -si 1'
 + CHAR(10) + '-- 		To disable Data integrity validation on Network'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 6 -si 0'
 + CHAR(10) + '-- 		To enable Data integrity validation on Media'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 7 -si 1'
 + CHAR(10) + '-- 		To disable Data integrity validation on Media'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 7 -si 0'
 + CHAR(10) + '-- 		To mark MediaAgent as offline for maintenance'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 8 -si 1'
 + CHAR(10) + '-- 		To unmark MediaAgent as offline for maintenance'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 8 -si 0'
 + CHAR(10) + '-- 		To mark MediaAgent as enabled'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 9 -si 1'
 + CHAR(10) + '-- 		To unmark MediaAgent as enabled'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 9 -si 0'
 + CHAR(10) + '-- 		To set Index Retention period (in days)'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 10 -si 15'
 + CHAR(10) + '-- 		To generate alerts when free space is below certain size (in GB)'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 11 -si 50'
 + CHAR(10) + '-- 		To take Index offline when free space falls below certain size (in GB)'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 12 -si 10'
 + CHAR(10) + '-- 		To Cleanup until free space is at least(in percent)'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 13 -si 10'
 + CHAR(10) + '-- 		To enable the IndexCache'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 14 -si 1'
 + CHAR(10) + '-- 		To disable the IndexCache'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 14 -si 0'
 + CHAR(10) + '-- 		To enable Ransomware Protection'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 15 -si 1'
 + CHAR(10) + '-- 		To disable Ransomware Protection'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 15 -si 0'
 + CHAR(10) + '-- 		To select MediaAgent settings for power management'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 16 -si 1 '
 + CHAR(10) + '-- 		To select Client Group settings for power management'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 16 -si 0'
 + CHAR(10) + '-- 		To enable Power Management at MediaAgent level'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 16 -si 1 -si 1'
 + CHAR(10) + '-- 		To disable Power Management at MediaAgent level'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 16 -si 1 -si 0'
 + CHAR(10) + '-- 		To select Cloud Controller for Power Management at MediaAgent level'
 + CHAR(10) + '-- 		qoperation execscript -sn setMediaAgentProperty -si sample_ma -si 17 -si contorller_node_name'
)
GO

