

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_setGlobalFilterStateForClient.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_setGlobalFilterStateForClient <<<'

IF EXISTS (select * from sysobjects where name='QS_setGlobalFilterStateForClient')
	drop procedure QS_setGlobalFilterStateForClient
IF EXISTS (select * from GxQscripts where name='QS_setGlobalFilterStateForClient')
	delete from GxQscripts where name = 'QS_setGlobalFilterStateForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setGlobalFilterStateForClient')
	delete from GXDBVersions where aliasname = 'QS_setGlobalFilterStateForClient'
GO
print '... Creating Procedure: QS_setGlobalFilterStateForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_setGlobalFilterStateForClient
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @NEWSTATE varchar(1024) = '',
  @CLIENTNAME varchar(1024) = ''
--SET @NEWSTATE   = '%s'
--SET @CLIENTNAME = '%s'
AS
-------------------------------------------
--         Name:   QS_setGlobalFilterStateForClient.sql
--         Date:   01-Jun-2010
--       Author:   SKatz
--  Description:   Script to set GlobalFilters subClient property for all applicable iDa's on a client
--				   Can set to "on", "off", or "USE CELL LEVEL POLICY" for an individual client
--				   or for all clients
--
-- TR(original):   100527-000276
--     Customer:   Noble
--   CommcellId:   N/A (generic)
-------------------------------------------
-- Following AppTypes Adressed:
-- ===========================
-- CV_APPTYPE_FILESYSTEM                1
-- CV_APPTYPE_WIN2KFS                  11
-- CV_APPTYPE_NETWARE_FS               12
-- CV_APPTYPE_HPUX32_FS                17
-- CV_APPTYPE_HPUX64_FS                18
-- CV_APPTYPE_SOLARIS32_FS             19
-- CV_APPTYPE_SOLARIS64_FS             20
-- CV_APPTYPE_AIX_FS                   21
-- CV_APPTYPE_FASTRAX_FS               28
-- CV_APPTYPE_LINUX_FS                 29
-- CV_APPTYPE_OSF_FS                   36
-- CV_APPTYPE_MS_WINDOWS_XP_FS_32      33
-- CV_APPTYPE_MS_WINDOWS_XP_FS_64      34
-- CV_APPTYPE_UNIX_TRU64_FS_64         36
-- CV_APPTYPE_UNIX_TRU64_FS_32         38
-- CV_APPTYPE_MS_WINDOWS_DOTNET_FS_32  42
-- CV_APPTYPE_MS_WINDOWS_DOTNET_FS_64  43
-- CV_APPTYPE_APPLEMAC_FS              63
-- CV_APPTYPE_SGI_FS                   64
-- CV_APPTYPE_FREE_BSD                 74
-- CV_APPTYPE_LINUX_OES_FS             86
--   (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
--                                       --
-------------------------------------------
-- CANNOT DO THE FOLLOWING IN A STORED PROCEDURE!
--use commserv
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
--Set NOCOUNT ON
-------------------------------------------
-- FOLLOWING ARE FILLED IN FROM COMMAND  --
-- .. LINE, IN THIS ORDER				 --
-------------------------------------------
--DECLARE @NEWSTATE		varchar(512)
--DECLARE @CLIENTNAME     varchar(1024)
-- Stored Procedure Inputs
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_setGlobalFilterStateForClient'
DECLARE @created			   integer
SET     @created				= 0
DECLARE @SC_STATUS_BITS        integer
--SET		@SC_STATUS_BITS    =  2+4+16			-- CV_STATUS_UNINSTALLED+CV_STATUS_DELETED+CV_STATUS_DUMMY
SET		@SC_STATUS_BITS        =  4+16				-- CV_STATUS_DELETED+CV_STATUS_DUMMY  (Allow props change for uninstalled subClients)
DECLARE @CellLevelPolicyProp	nvarchar(50)
SET		@CellLevelPolicyProp	= N'use cs setting for Global Filters'
DECLARE @UseGlobalFiltersProp	nvarchar(32)
SET		@UseGlobalFiltersProp	=N'Use Global Filters'
DECLARE @AssocSCPolicyProp		Nvarchar(32)
SET		@AssocSCPolicyProp		=N'Associated subclient Policy'
DECLARE @AssocSCPolicyVal		Nvarchar(256)
DECLARE @nowTime				integer
SET     @nowTime				= dbo.GetUnixTime (GetUTCdate())
DECLARE @NoParameter			varchar(10)
SET		@NoParameter			='%'						-- Get Around QScript Parameter
SET		@NoParameter            =@NoParameter + 's'			-- .. Substitution
-------- Local Variables    -------------
DECLARE @clientId				integer
DECLARE @appTypeId				integer
DECLARE @instanceId				integer
DECLARE @backupSetId			integer
DECLARE	@subClientId			integer
DECLARE	@subclientName			varchar(1024)
DECLARE @currentPropId			integer
DECLARE @lastError				integer
DECLARE @OldState				varchar(512)
DECLARE @NewStateName			varchar(128)
DECLARE @localErrorMsg			varchar(512)
SET		@localErrorMsg			='Error Encountered when running script.'
DECLARE @isAllClients			integer
SET		@isAllClients			= 0						-- default is NO!
SET     @lastError  = 0									-- Be optimistic
DECLARE @CellLevelPolicyVal		integer
DECLARE @UseGlobalFilterVal		integer
DECLARE @OldCellLevelPolicyVal integer
DECLARE @oldUseGlobalFilterVal	integer
---------------------------------------
-- SET FOR STANDALONE DEBUGGING ONLY --
---------------------------------------
--SET @newState =  'off'    --(or 'off' or 'USE CELL LEVEL POLICY')
--SET @newState =  'USE CELL LEVEL POLICY'    --(or 'off' or 'USE CELL LEVEL POLICY')
--Set @clientName = 'AllClientsInCommcell'
---------------------------------------
------------------------------------------------
--- CHECK IF MINIMUM PARAMETERS SPECIFIED	 ---
------------------------------------------------
IF (@newState = @NoParameter)
BEGIN														------------------------------
	SET @localErrorMsg	='Error. No new state Specified.'	-- CHECK FOR 'NEW' STATE	--
	Set @lastError = 1										------------------------------
	goto   ARGS_ERROR
END
ELSE IF(@newState = N'OFF')
BEGIN
	SET @CellLevelPolicyVal	= 0
	SET @UseGlobalFilterVal		= 0
END
ELSE IF(@newState = N'ON')
BEGIN
	SET @CellLevelPolicyVal	= 0
	SET @UseGlobalFilterVal		= 1
END
ELSE IF(@newState = N'USE CELL LEVEL POLICY')
BEGIN
	SET @CellLevelPolicyVal	= 1
	SET @UseGlobalFilterVal		= 0
END
ELSE
BEGIN
	SET @localErrorMsg	='Error. Invalid state ['+ @newState + '] specified.'
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF (@clientName = @NoParameter)								------------------------------
BEGIN														-- CHECK FOR CLIENT NAME	--
	SET @localErrorMsg	='Error. No Client Name Specified.'	------------------------------
	Set @lastError = 1
	goto   ARGS_ERROR
END
IF @clientName = 'AllClientsInCommcell'			-- ASSUMPTION: CANNOT have a Client with this name
	SET @isAllClients = 1
------------------------------------------------
-- "Normalize" new state to what Props Expect --
------------------------------------------------
PRINT @scriptName + ' Started at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newState
         + '], client = ['
         + @clientName
         + '].'
--------------------------------------------------------------
-- Figure Out ClientId from name (unless is "all clients":	--
--------------------------------------------------------------
IF @isAllClients = 0
BEGIN
	SET @clientId     = (Select id from APP_CLIENT where name = @CLIENTNAME)
	IF @clientId is Null
	BEGIN
		SET @localErrorMsg	='No Client with name ['+@ClientName+'] exists.'
		Set @lastError = 1
		goto   ARGS_ERROR
	END
END
------------------------------------------------
-- DO THE WORK (LOOP FOR ALL SUBCLIENTS)!	----
------------------------------------------------
begin tran
BEGIN TRY
IF @isAllClients = 0
	DECLARE subClientCursor CURSOR STATIC FOR
	  SELECT distinct id, clientId, appTypeId, instance, backupSet, subclientName  from APP_APPLICATION
		WHERE clientId = @clientId
			AND (subClientStatus & @SC_STATUS_BITS) = 0
			AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
ELSE   -- ALL Clients:
	DECLARE subClientCursor CURSOR STATIC FOR
	  SELECT distinct id, clientId, appTypeId, instance, backupSet, subclientName  from APP_APPLICATION
		WHERE
        		(subClientStatus & @SC_STATUS_BITS) = 0
			AND appTypeId in (1,11,12,17,18,19,20,21,28,29,36,33,34,36,38,42,43,63,64,74,86)
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    WHILE @@FETCH_STATUS = 0
    BEGIN
--		-------------------------------------------------------------------------------------------------------------------------
--		FETCH THE "OLD" VALUES OF BOTH PROPERTIES.  NOTE THAT THEY HAVE DIFFERENT DEFAULT VALUES.  WE ALSO NEED TO LOOK FOR
--		THE LATEST "CURRENT" VERSION, AS WE'VE SEEN ON SOME OLD CUSTOMER DB'S THAT OCCAISIONALLY WE SEE MORE THAN ONE "CURRENT"
--		-------------------------------------------------------------------------------------------------------------------------
		SET @AssocSCPolicyVal
				   = ISNULL((SELECT TOP 1 attrVal
				                 FROM APP_SubclientProp
				                 WHERE componentNameId = @subclientId
				                  AND modified =0
				                  and attrName = @AssocSCPolicyProp
								  AND cs_attrName = checksum(@AssocSCPolicyProp)
				                  ORDER by created DESC), N'0')
		IF @AssocSCPolicyVal <> '0'
		BEGIN
--			FOR TESTING:			PRint 'Subclient['+convert(varchar(12), @subClientId) + '] is part of a subClient Policy and will not be modified.'
			GOTO skip_it
		END
		SET @OldCellLevelPolicyVal
		          = ISNULL((SELECT TOP 1 attrVal
		                     FROM APP_SubclientProp
		                      WHERE componentNameId = @subclientId
		                       AND modified =0
		                       AND attrName = @CellLevelPolicyProp
		                       AND cs_attrName = checksum(@CellLevelPolicyProp)
		                       ORDER by created DESC), 1)
		SET @oldUseGlobalFilterVal
				   = ISNULL((SELECT TOP 1 attrVal
				                 FROM APP_SubclientProp
				                 WHERE componentNameId = @subclientId
				                  AND modified =0
				                  AND attrName = @UseGlobalFiltersProp
								  AND cs_attrName = checksum(@UseGlobalFiltersProp)
				                  ORDER by created DESC), 0)
-- ONLY AGE OLD PROPERTY/ADD NEW IF THE STATE OF THE PROPERTY HAS CHANGED!
		IF @CellLevelPolicyVal <> @OldCellLevelPolicyVal
		BEGIN
			UPDATE APP_SubclientProp
			SET modified = @nowTime
			WHERE componentNameId = @subclientId
			  AND modified =0
			  AND attrName = @CellLevelPolicyProp
			  AND cs_attrName = checksum(@CellLevelPolicyProp )
			INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
				VALUES (@subclientId, @nowTime, 0, 2 , @CellLevelPolicyProp, @CellLevelPolicyVal)
		END
		IF @UseGlobalFilterVal <> @oldUseGlobalFilterVal
		BEGIN
			UPDATE APP_SubclientProp
			SET modified = @nowTime
			WHERE componentNameId = @subclientId
			  AND modified =0
			  AND attrName = @UseGlobalFiltersProp
			  AND cs_attrName = checksum(@UseGlobalFiltersProp)
			INSERT INTO APP_SubclientProp(componentNameId, created, modified, attrtype, attrname, attrval)
									VALUES (@subclientId, @nowTime, 0, 2 , @UseGlobalFiltersProp, @UseGlobalFilterVal)
		END
skip_it:
		FETCH NEXT FROM subClientCursor INTO @subClientId, @clientId, @appTypeId, @instanceId, @backupSetId, @subclientName
    END			-- WHILE subClientCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
	CLOSE       subClientCursor
    DEALLOCATE  subClientCursor
IF @lastError  = 0
	COMMIT  Tran
ELSE
	ROLLBACK Tran
ARGS_ERROR:
PRINT @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newstate = ['
         + @newState
         + '], client = ['
         + @clientName
         + ']. Exit Code(' +convert(varchar(2), @lastError) + ').'
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO
/*
FOR TESTING:
==========
1. Using Qscript, set option for all Clients = ON and then FOR OFF.
2. Run script below. Any rows returned need to be looked at to see if OK to skip.
select id, subClientId=componentNameId,
 appTypeId=(select appTypeId from APP_Application where id = componentNameId),
 idaName = (Select name from APP_iDAType where type =  (select appTypeId from APP_Application where id = componentNameId)),
 attrName, attrVal, created, modified,
 subClientStatus=(select subClientStatus from APP_Application where id = componentNameId)
   from app_subClientprop where
(attrName = 'use global filters' OR attrName = 'use cs setting for Global Filters')
and modified=0 and attrVal = '1'
AND ((select subClientStatus from APP_Application where id = componentNameId) & 32) = 0
order by componentNameId, attrNAme
*/

IF EXISTS (select * from GxQscripts where name = 'QS_setGlobalFilterStateForClient')
	delete from GxQscripts where name = 'QS_setGlobalFilterStateForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_setGlobalFilterStateForClient')
	delete from GXDBVersions where aliasname = 'QS_setGlobalFilterStateForClient'
GO

insert into GXDBVersions values(2, 'QS_setGlobalFilterStateForClient',  '00000000000000000000', 'QS_setGlobalFilterStateForClient', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_setGlobalFilterStateForClient',  4, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn SetGlobalFilterStateForClient -si ''ON''|''OFF''|''USE CELL LEVEL POLICY'' -si ''clientName''|''AllClientsInCommcell'''
 + CHAR(10) + '--       To set Cell Level Policy on for all clients:'
 + CHAR(10) + '-- 		qoperation execscript -sn SetGlobalFilterStateForClient -si ''USE CELL LEVEL POLICY'' -si ''AllClientsInCommcell'''
 + CHAR(10) + '--       To set Cell Level Policy only for for client myClient:'
 + CHAR(10) + '-- 		qoperation execscript -sn SetGlobalFilterStateForClient -si ''USE CELL LEVEL POLICY'' -si ''myClient'''
 + CHAR(10) + '-- 		To turn off global filters for myClient:'
 + CHAR(10) + '-- 		qoperation execscript -sn SetGlobalFilterStateForClient -si ''OFF'' -si ''myClient'''
 + CHAR(10) + '-- 		To turn on global filters (not cell level( for myClient:'
 + CHAR(10) + '-- 		qoperation execscript -sn SetGlobalFilterStateForClient -si ''ON'' -si ''myClient'''
)
GO

